/*
 * Decompiled with CFR 0.152.
 */
package cerent.launcher;

import cerent.launcher.CtcHttpRetriever;
import cerent.util.BuildInfo;
import cerent.util.CtcRuntime;
import cerent.util.CtcSecurityManager;
import cerent.util.DebugManager;
import cerent.util.DebugWindow;
import cerent.util.EID;
import cerent.util.KDebug;
import cerent.util.KEMC;
import cerent.util.KErrorMsg;
import cerent.util.PolicyTool;
import cerent.util.Preferences;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Color;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.NoRouteToHostException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.AccessControlException;
import java.util.StringTokenizer;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class CtcLauncherApplet
extends JApplet
implements Runnable {
    private static DebugManager dbm;
    private static BootDebug db;
    private String nodeName;
    private CtcRuntime ctcRuntime;
    private boolean windows = false;
    private Process launcherProc = null;
    private boolean anApplication = false;
    private Container contentPane = null;
    private AppletPanel ctcAppPanel = null;
    private static final String CTC_STARTED = "Started CTC; reload/refresh to restart";
    private static final String CTC_DEBUG_PARM = "ctc.launcher.debug";
    private static final String CTC_DEBUG_FILE = "ctc.launcher.dbFile";
    private static final String CTC_DEBUG_KEYS = "ctc.launcher.dbKeys";
    private static boolean DEBUG;
    private static PrintStream out;

    private static void setProperty(String string) {
        int n = string.indexOf(61);
        if (n >= 0) {
            System.setProperty(string.substring(0, n), string.substring(n + 1));
        } else {
            System.setProperty(string, "true");
        }
    }

    public static void main(String[] stringArray) {
        String string = null;
        CtcLauncherApplet.initializePreferences();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("-D")) {
                CtcLauncherApplet.setProperty(stringArray[i].substring(2));
                continue;
            }
            string = stringArray[i];
        }
        CtcRuntime ctcRuntime = new CtcRuntime(string);
        try {
            Process process = ctcRuntime.exec();
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
        }
        System.exit(0);
    }

    private static void initializePreferences() {
        dbm = DebugManager.instance();
        Preferences.setDefault(Preferences.getDefaultLauncherPrefsFileName(), true);
    }

    public void initialize(String string) {
        if (DEBUG) {
            dbm.println("-> initialize( " + string + " )");
        }
        this.setNodeName(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Object object;
        String string;
        Object object2;
        CtcLauncherApplet.initializePreferences();
        String string2 = this.getProp(CTC_DEBUG_PARM);
        if (string2 != null && string2.compareToIgnoreCase("true") == 0) {
            DEBUG = true;
        }
        if (Preferences.instance().getBoolean("ctc.boot", "debug", false)) {
            db = new BootDebug();
            DebugWindow.instance().display();
            DEBUG = true;
            db.println("Applet paused, type \"Bootstrap resume\" to resume.");
            object2 = db;
            synchronized (object2) {
                try {
                    db.wait();
                }
                catch (Exception exception) {
                    db.finest("Exception while waiting: " + exception);
                }
            }
            db.println("Applet resumed");
        }
        if (DEBUG) {
            dbm.println("-> init( )");
        }
        if ((object2 = this.getProp(CTC_DEBUG_FILE)) != null && !((String)object2).equals("")) {
            try {
                dbm.addPrintStream(new PrintStream(new FileOutputStream((String)object2)));
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (DEBUG) {
                    dbm.println("Unable to start CTC debugger, write to " + (String)object2 + " failed.");
                }
            }
        } else if (DEBUG) {
            dbm.addPrintStream(System.out);
        }
        if ((string = this.getProp(CTC_DEBUG_KEYS)) != null) {
            object = new StringTokenizer(string, ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string3 = ((StringTokenizer)object).nextToken();
                dbm.exec("preset " + string3);
                dbm.exec(string3 + " set");
            }
            dbm.exec("showPreset");
        }
        if (!this.anApplication) {
            System.setSecurityManager(new CtcSecurityManager());
        }
        object = this.getDocumentBase().getHost();
        if (DEBUG) {
            dbm.println("nodeName     = " + (String)object);
            dbm.println("Parameter    = " + this.getParameter("NodeName"));
            dbm.println("CodeBase     = " + this.getCodeBase());
            dbm.println("DocumentBase = " + this.getDocumentBase());
        }
        this.ctcRuntime = new CtcRuntime((String)object, this);
        this.contentPane = this.getContentPane();
        this.ctcAppPanel = new AppletPanel(this.ctcRuntime);
        this.contentPane.add(this.ctcAppPanel);
        this.contentPane.setBackground(Color.white);
        this.initialize((String)object);
        this.ctcAppPanel.setCtcRuntime(this.ctcRuntime);
    }

    public void start() {
        if (DEBUG) {
            dbm.println("-> start( )");
        }
        if (!this.ctcAppPanel.appletProblem()) {
            new Thread(this).start();
        }
        this.ctcAppPanel.display();
    }

    public void run() {
        PolicyTool.run();
        this.launch();
    }

    public void stop() {
        if (DEBUG) {
            dbm.println("-> stop( )");
        }
    }

    public void destroy() {
        if (DEBUG) {
            dbm.println("-> destroy( )");
        }
        if (CtcRuntime.isWin9x()) {
            if (DEBUG) {
                dbm.println("destroy( ): destroying CTC process");
            }
            this.launcherProc.destroy();
        }
        this.ctcRuntime.deleteBatchFiles();
        if (DEBUG) {
            dbm.println("Exiting void destroy( )");
        }
    }

    public void setNodeName(String string) {
        this.nodeName = string;
    }

    public void errorDialog(String string) {
        if (this.anApplication) {
            JOptionPane.showMessageDialog(this, string, "Error", 0);
        } else {
            if (DEBUG) {
                dbm.println("Error: " + string);
            }
            this.setLabelText(string);
            this.ctcAppPanel.display();
        }
    }

    private void errorDialog(EID eID) {
        KErrorMsg.displayError(null, eID);
    }

    public void launch() {
        if (DEBUG) {
            dbm.println("-> launch( )");
        }
        this.setLabelText("CTC launch failed");
        this.ctcAppPanel.display();
        CtcHttpRetriever.useProxy(false);
        if (!this.isAppletVersionCompatibleNodeVersion()) {
            if (DEBUG) {
                dbm.println("Applet version does not match node version. CTC launch failed.");
            }
            this.errorDialog(KEMC.EID_APPLET_VERSION_MISMATCH);
            this.setAppletProblem(true);
            this.stop();
            return;
        }
        try {
            this.windows = new WindowsLookAndFeel().isSupportedLookAndFeel();
            if (this.windows) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            } else {
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            }
            this.launcherProc = this.ctcRuntime.exec();
            this.setLabelText(CTC_STARTED);
            this.ctcAppPanel.display();
            this.stop();
        }
        catch (SecurityException securityException) {
            if (DEBUG) {
                securityException.printStackTrace(out);
            }
            this.errorDialog(KEMC.EID_UNABLE_TO_LAUNCH_CTC);
        }
        catch (NoRouteToHostException noRouteToHostException) {
            if (DEBUG) {
                noRouteToHostException.printStackTrace(out);
            }
            this.errorDialog(KEMC.EID_NO_ROUTE);
        }
        catch (UnknownHostException unknownHostException) {
            if (DEBUG) {
                unknownHostException.printStackTrace(out);
            }
            this.errorDialog(KEMC.EID_CANT_RESOLVE_HOSTNAME);
        }
        catch (Exception exception) {
            if (DEBUG) {
                exception.printStackTrace(out);
            }
            this.errorDialog(exception.getMessage() == null ? KErrorMsg.getString(KEMC.EID_ERROR_LAUNCHING_CTC_PARAM_1, exception.toString()) : exception.getMessage());
        }
        this.setAppletProblem(true);
        if (DEBUG) {
            dbm.println("Exiting void launch( )");
        }
    }

    private void setLabelText(String string) {
        this.ctcAppPanel.setLabel(string);
    }

    private void setAppletProblem(boolean bl) {
        this.ctcAppPanel.setProblem(bl);
    }

    public void setActualJre(String string, String string2) {
        this.ctcAppPanel.setActualJre(string, string2);
    }

    private String getProp(String string) {
        int n;
        String string2;
        block4: {
            string2 = System.getProperty(string);
            if (string2 == null) {
                try {
                    string2 = this.getParameter(string);
                }
                catch (Exception exception) {
                    if (!DEBUG) break block4;
                    dbm.println("getProp: " + exception.getMessage());
                }
            }
        }
        if (string2 == null && (n = string.indexOf(46)) != -1) {
            String string3 = string.substring(0, n);
            String string4 = string.substring(n + 1);
            string2 = Preferences.instance().getProperty(string3, string4, null);
        }
        return string2;
    }

    private boolean isAppletVersionCompatibleNodeVersion() {
        boolean bl;
        block3: {
            String string;
            bl = true;
            String string2 = string = BuildInfo.version;
            try {
                string2 = CtcHttpRetriever.getSwVersion(this.nodeName);
                int n = this.getVersionAsNumber(string2);
                int n2 = this.getVersionAsNumber(string);
                if (n > n2) {
                    dbm.println("nodeSwVersion = " + n + ", appletVersion = " + n2);
                    bl = false;
                }
            }
            catch (Exception exception) {
                if (!DEBUG) break block3;
                dbm.println("An error occurred while retrieving the node version information.");
                dbm.println("Allowing CTC to launch.");
            }
        }
        return bl;
    }

    private int getVersionAsNumber(String string) {
        if (string != null) {
            String string2 = string.substring(0, 2) + string.substring(3, 5);
            return Integer.valueOf(string2);
        }
        return -1;
    }

    static {
        URL uRL;
        ClassLoader classLoader = CtcLauncherApplet.class.getClassLoader();
        if (classLoader instanceof URLClassLoader && (uRL = ((URLClassLoader)classLoader).findResource("META-INF/MANIFEST.MF")) != null) {
            try {
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.setDefaultUseCaches(false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        dbm = null;
        db = null;
        DEBUG = false;
        out = System.out;
    }

    public static class BootDebug
    extends KDebug {
        public BootDebug() {
            super("Bootstrap", true);
        }

        public final synchronized void resume() {
            this.notifyAll();
        }
    }

    protected class AppletPanel
    extends JPanel {
        private String _javaVersion;
        private String _javaHome;
        private String _javaVmName;
        private String _javaVmVersion;
        private String _javaVmVendor;
        private String _osName;
        private String _osVendor;
        private String _osVersion;
        private String _labelText;
        private CtcRuntime _runtime;
        private String _fileSep;
        private String _version;
        private JTextArea textArea;
        private JButton cacheButton;
        private boolean _appletProblem = false;

        public AppletPanel(CtcRuntime ctcRuntime) {
            this._runtime = ctcRuntime;
            this._version = BuildInfo.version;
            this._labelText = "CTC launch failed";
            this.setBackground(Color.white);
            this.cacheButton = new JButton("Delete CTC Cache");
            this.cacheButton.addActionListener(new Controller());
            this.cacheButton.setBackground(Color.white);
            this.add(this.cacheButton);
            this.textArea = new JTextArea(15, 35);
            this.textArea.setLineWrap(true);
            this.textArea.setWrapStyleWord(true);
            this.textArea.setTabSize(4);
            this.add(this.textArea);
            try {
                this._fileSep = System.getProperty("file.separator");
                this._javaVersion = System.getProperty("java.version");
                this._javaHome = System.getProperty("java.home");
                this._javaVmName = System.getProperty("java.vm.name");
                this._javaVmVersion = System.getProperty("java.vm.version");
                this._javaVmVendor = System.getProperty("java.vm.vendor");
                this._osName = System.getProperty("os.name");
                this._osVendor = System.getProperty("os.vendor");
                this._osVersion = System.getProperty("os.version");
            }
            catch (AccessControlException accessControlException) {
                accessControlException.printStackTrace(System.err);
                this._appletProblem = true;
                if (this._labelText == null) {
                    this._labelText = "CTC launch failed";
                }
                this._labelText.concat("Access Control Exception. ");
            }
        }

        public boolean appletProblem() {
            return this._appletProblem;
        }

        public void setLabel(String string) {
            this._labelText = string;
        }

        public void setProblem(boolean bl) {
            this._appletProblem = bl;
        }

        public void setCtcRuntime(CtcRuntime ctcRuntime) {
            this._runtime = ctcRuntime;
        }

        public void setCTCVersion(String string) {
            this._version = string;
        }

        public void display() {
            this.textArea.setText("");
            this.textArea.append("\nCisco Transport Controller " + this._version + " Status:\n");
            this.textArea.append(this._labelText + "\n");
            this.textArea.append("\nCTC Java Environment:\n");
            this.textArea.append("\tJava VM Version: " + this._javaVersion + "\n");
            this.textArea.append("\tJava VM Home: " + this._javaHome + "\n");
            this.textArea.append("\nBrowser Java Environment:\n");
            this.textArea.append("\tJava VM Name: " + this._javaVmName + "\n");
            this.textArea.append("\tJava VM Version: " + this._javaVmVersion + "\n");
            this.textArea.append("\tJava VM Vendor: " + this._javaVmVendor + "\n");
            this.textArea.append("\nSystem Environment:\n");
            this.textArea.append("\tOS Name: " + this._osName + "\n");
            this.textArea.append("\tOS Vendor: " + this._osVendor + "\n");
            this.textArea.append("\tOS Version: " + this._osVersion + "\n");
        }

        public void setActualJre(String string, String string2) {
            this._javaVersion = string;
            this._javaHome = string2;
            this.setLabel(CtcLauncherApplet.CTC_STARTED);
        }

        private class Controller
        implements ActionListener {
            private Controller() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = new Object[]{"Yes", "No"};
                int n = JOptionPane.showOptionDialog(null, KErrorMsg.getString(KEMC.WID_DELETE_CTC_CACHE) + "\n\nOK to continue?", "Delete CTC Cache", 0, 2, null, objectArray, objectArray[1]);
                if (n == 0) {
                    AppletPanel.this._runtime.deleteCache();
                }
            }
        }
    }
}

