/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import sun.misc.BASE64Decoder;

public final class CtcSslFactory {
    private static final String BEGIN_CERT = "-----BEGIN CERTIFICATE-----";
    private static final String END_CERT = "-----END CERTIFICATE-----";
    private static final String BEGIN_KEY = "-----BEGIN PRIVATE KEY-----";
    private static final String END_KEY = "-----END PRIVATE KEY-----";
    private static final String CONTEXT_PROTOCOL = "SSL";
    private static final String MANAGER_ALGORITHM = "SunX509";
    private static final String MANAGER_PROVIDER = "SunJSSE";
    private static final String KEYSTORE_ENGINE = "JKS";
    private static final String CERTIFICATE_ENGINE = "X.509";
    private static final String RSA_KEY_FACTORY = "RSA";
    private static final String SSL_CERT_ALIAS = "Nodes";
    private static final String SSL_KEY_ALIAS = "Callbacks";
    private static final char[] SSL_KEY_PASSWORD = "6ab4!F".toCharArray();
    private static final String SSL_CERTIFICATE = "server.pem";
    private static final char[] SSL_KEYSTORE_PASSWORD = "J. Random Hacker".toCharArray();
    private static KeyStore keyStore = null;
    private static SSLContext ctcContext = null;
    private static SSLSocketFactory clientFactory = null;
    private static SSLServerSocketFactory serverFactory = null;

    private CtcSslFactory() {
    }

    public static synchronized SSLSocketFactory getSSLSocketFactory() {
        if (clientFactory == null) {
            SSLContext sSLContext = CtcSslFactory.getSSLContext();
            clientFactory = sSLContext.getSocketFactory();
        }
        return clientFactory;
    }

    public static synchronized SSLServerSocketFactory getSSLServerSocketFactory() {
        if (serverFactory == null) {
            SSLContext sSLContext = CtcSslFactory.getSSLContext();
            serverFactory = sSLContext.getServerSocketFactory();
        }
        return serverFactory;
    }

    private static synchronized SSLContext getSSLContext() {
        if (ctcContext == null) {
            try {
                KeyManager[] keyManagerArray = CtcSslFactory.getKeyManagers();
                TrustManager[] trustManagerArray = CtcSslFactory.getTrustManagers();
                ctcContext = SSLContext.getInstance(CONTEXT_PROTOCOL);
                ctcContext.init(keyManagerArray, trustManagerArray, null);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                noSuchAlgorithmException.printStackTrace(System.err);
                throw new RuntimeException(noSuchAlgorithmException);
            }
            catch (KeyManagementException keyManagementException) {
                keyManagementException.printStackTrace(System.err);
                throw new RuntimeException(keyManagementException);
            }
        }
        return ctcContext;
    }

    private static TrustManager[] getTrustManagers() {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(MANAGER_ALGORITHM, MANAGER_PROVIDER);
            trustManagerFactory.init(CtcSslFactory.getKeyStore());
            return trustManagerFactory.getTrustManagers();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace(System.err);
            throw new RuntimeException(noSuchAlgorithmException);
        }
        catch (KeyStoreException keyStoreException) {
            keyStoreException.printStackTrace(System.err);
            throw new RuntimeException(keyStoreException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            noSuchProviderException.printStackTrace(System.err);
            throw new RuntimeException(noSuchProviderException);
        }
    }

    private static KeyManager[] getKeyManagers() {
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(MANAGER_ALGORITHM, MANAGER_PROVIDER);
            keyManagerFactory.init(CtcSslFactory.getKeyStore(), SSL_KEY_PASSWORD);
            return keyManagerFactory.getKeyManagers();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace(System.err);
            throw new RuntimeException(noSuchAlgorithmException);
        }
        catch (KeyStoreException keyStoreException) {
            keyStoreException.printStackTrace(System.err);
            throw new RuntimeException(keyStoreException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            noSuchProviderException.printStackTrace(System.err);
            throw new RuntimeException(noSuchProviderException);
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            unrecoverableKeyException.printStackTrace(System.err);
            throw new RuntimeException(unrecoverableKeyException);
        }
    }

    private static synchronized KeyStore getKeyStore() {
        if (keyStore == null) {
            try {
                Certificate certificate = CtcSslFactory.getCertificate();
                KeyStore keyStore = KeyStore.getInstance(KEYSTORE_ENGINE);
                keyStore.load(null, SSL_KEYSTORE_PASSWORD);
                keyStore.setKeyEntry(SSL_KEY_ALIAS, CtcSslFactory.getKey(), SSL_KEY_PASSWORD, new Certificate[]{certificate});
                CtcSslFactory.keyStore = keyStore;
            }
            catch (KeyStoreException keyStoreException) {
                keyStoreException.printStackTrace(System.err);
                throw new RuntimeException(keyStoreException);
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
                throw new RuntimeException(iOException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                noSuchAlgorithmException.printStackTrace(System.err);
                throw new RuntimeException(noSuchAlgorithmException);
            }
            catch (CertificateException certificateException) {
                certificateException.printStackTrace(System.err);
                throw new RuntimeException(certificateException);
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                invalidKeySpecException.printStackTrace(System.err);
                throw new RuntimeException(invalidKeySpecException);
            }
        }
        return keyStore;
    }

    private static Certificate getCertificate() {
        ClassLoader classLoader = CtcSslFactory.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(SSL_CERTIFICATE);
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance(CERTIFICATE_ENGINE);
            Certificate certificate = certificateFactory.generateCertificate(inputStream);
            return certificate;
        }
        catch (CertificateException certificateException) {
            certificateException.printStackTrace(System.err);
            throw new RuntimeException(certificateException);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static Key getKey() throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        String string;
        ClassLoader classLoader = CtcSslFactory.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(SSL_CERTIFICATE);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = bufferedReader.readLine()) != null && !string.equals(BEGIN_KEY)) {
        }
        string = bufferedReader.readLine();
        while (string != null && !string.equals(END_KEY)) {
            stringBuffer.append(string);
            string = bufferedReader.readLine();
        }
        try {
            inputStream.close();
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byte[] byArray = new BASE64Decoder().decodeBuffer(stringBuffer.toString());
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_KEY_FACTORY);
        return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(byArray));
    }
}

