/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.Preferences;
import cerent.util.RootDebug;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class DebugManager {
    private static final String PREF_EXC_SYSOUT = "debug.excsysout";
    private static final String PREF_PATH = "ctc";
    private static final String COPYRIGHT = "Copyright (c) 2000 Cisco Systems, Inc.";
    private static final int MAX_HISTORY = 30;
    private static final String prompt = "> ";
    private static DebugManager _instance = null;
    private static LinkedList printList = new LinkedList();
    private History history = new History();
    private static boolean excToSysOut = true;
    private static boolean sysOutInList = false;
    private RootDebug root;
    private static final String[][] helpMatrix = new String[][]{{"?", "Print this help message"}, {"quit, exit, bye", "Terminate debug session"}, {"!!", "Execute last command"}, {"!?", "Print command history"}, {"!<number>", "Execute command at rank <number>"}, {"!<text>", "Execute previous command matching <text>"}};

    private DebugManager() {
        if (_instance != null) {
            throw new RuntimeException("Fatal Error: Multiple DebugManager instances present!");
        }
        _instance = this;
        this.root = new RootDebug(this);
        excToSysOut = Preferences.instance().getBoolean(PREF_PATH, PREF_EXC_SYSOUT, false);
    }

    public static DebugManager instance() {
        if (_instance == null) {
            _instance = new DebugManager();
        }
        return _instance;
    }

    public void addPrintStream(PrintStream printStream) {
        this.addPrintStream(printStream, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrintStream(PrintStream printStream, boolean bl) {
        LinkedList linkedList = printList;
        synchronized (linkedList) {
            if (!printList.contains(printStream)) {
                printList.add(printStream);
                if (bl) {
                    printStream.println("CTC debugger");
                    printStream.println(COPYRIGHT);
                    printStream.print(prompt);
                }
                if (printStream == System.out) {
                    sysOutInList = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePrintStream(PrintStream printStream) {
        LinkedList linkedList = printList;
        synchronized (linkedList) {
            printList.remove(printStream);
            if (printStream == System.out) {
                sysOutInList = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean exec(String string) {
        string = string == null ? "" : string.trim();
        try {
            Object object;
            String[] stringArray;
            if (string.startsWith("!") && (string = this.history.load(string)) == null) {
                this.history.print();
                boolean bl = false;
                return bl;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            boolean bl = true;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            while (stringTokenizer.hasMoreTokens()) {
                stringArray = stringTokenizer.nextToken();
                if (bl && stringArray.indexOf(".") != -1) {
                    object = new StringTokenizer((String)stringArray, ".");
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        arrayList.add(((StringTokenizer)object).nextToken());
                    }
                } else {
                    arrayList.add(stringArray);
                }
                bl = false;
            }
            stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            if (stringArray.length == 0) {
                boolean bl2 = false;
                return bl2;
            }
            object = stringArray[0].toUpperCase(Locale.ENGLISH);
            if (((String)object).equals("QUIT") || ((String)object).equals("BYE") || ((String)object).equals("EXIT")) {
                this.println("Goodbye");
                boolean bl3 = true;
                return bl3;
            }
            if (this.root.apply(stringArray, 0)) {
                this.history.save(string);
            } else {
                this.println("Syntax error");
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            DebugManager.printStackTrace(noSuchElementException);
        }
        catch (Exception exception) {
            DebugManager.printStackTrace(exception);
        }
        finally {
            this.print(prompt);
        }
        return false;
    }

    public synchronized void disposeClassLoader(ClassLoader classLoader) {
        this.root.disposeClassLoader(classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printStackTrace(Throwable throwable) {
        LinkedList linkedList = printList;
        synchronized (linkedList) {
            Iterator iterator = printList.iterator();
            while (iterator.hasNext()) {
                throwable.printStackTrace((PrintStream)iterator.next());
            }
        }
        if (excToSysOut && !sysOutInList) {
            throwable.printStackTrace(System.out);
        }
    }

    String[][] getHelpMatrix() {
        return helpMatrix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String string) {
        LinkedList linkedList = printList;
        synchronized (linkedList) {
            Iterator iterator = printList.iterator();
            while (iterator.hasNext()) {
                ((PrintStream)iterator.next()).println(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void print(String string) {
        LinkedList linkedList = printList;
        synchronized (linkedList) {
            Iterator iterator = printList.iterator();
            while (iterator.hasNext()) {
                ((PrintStream)iterator.next()).print(string);
            }
        }
    }

    public boolean getExcToSysOut() {
        return excToSysOut;
    }

    public void setExcToSysOut(boolean bl) {
        excToSysOut = bl;
        Preferences.instance().setBoolean(PREF_PATH, PREF_EXC_SYSOUT, excToSysOut);
    }

    public RootDebug getRoot() {
        return this.root;
    }

    class History {
        private LinkedList _history = new LinkedList();

        History() {
        }

        void save(String string) {
            ListIterator listIterator = this._history.listIterator();
            while (listIterator.hasNext()) {
                String string2 = (String)listIterator.next();
                if (!string.equals(string2)) continue;
                listIterator.remove();
                break;
            }
            this._history.addFirst(string);
            if (this._history.size() >= 30) {
                this._history.removeLast();
            }
        }

        void print() {
            for (int i = 0; i < this._history.size(); ++i) {
                String string = i < 10 ? " " : "";
                DebugManager.this.println("[" + string + i + "] " + (String)this._history.get(i));
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        String load(String string) {
            String string2 = null;
            if ((string = string.substring(1)).startsWith("?")) {
                return null;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (!stringTokenizer.hasMoreTokens()) {
                return null;
            }
            String string3 = stringTokenizer.nextToken();
            if (string3.equals("!")) {
                string3 = "0";
            }
            try {
                int n = Integer.parseInt(string3);
                if (n < this._history.size()) {
                    string2 = (String)this._history.get(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                ListIterator listIterator = this._history.listIterator();
                while (listIterator.hasNext()) {
                    String string4 = (String)listIterator.next();
                    if (string4.indexOf(string3) == -1) continue;
                    string2 = string4;
                    break;
                }
            }
            if (string2 != null) {
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = string2 + " " + stringTokenizer.nextToken();
                }
            }
            DebugManager.this.println("->" + string2);
            return string2;
        }
    }
}

