/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.EID;
import cerent.util.KDebug;
import cerent.util.MsgMgr;
import java.awt.Component;
import java.awt.Dimension;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class KErrorMsg {
    private static final String FATAL_ICON_STR = "/images/icons/fatal_error32.gif";
    protected static final KDebug db = new KDebug("ErrorMsg");
    public static ImageIcon FATAL_ICON;

    protected KErrorMsg() {
    }

    public static String getString(EID eID) {
        return eID.getComposedMessage();
    }

    public static String getString(EID eID, Object object) {
        Object[] objectArray = new Object[]{object};
        return KErrorMsg.getString(eID, objectArray);
    }

    public static String getString(EID eID, Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        return KErrorMsg.getString(eID, objectArray);
    }

    public static String getString(EID eID, Object object, Object object2, Object object3) {
        Object[] objectArray = new Object[]{object, object2, object3};
        return KErrorMsg.getString(eID, objectArray);
    }

    public static String getString(EID eID, Object object, Object object2, Object object3, Object object4) {
        Object[] objectArray = new Object[]{object, object2, object3, object4};
        return KErrorMsg.getString(eID, objectArray);
    }

    public static String getString(EID eID, Object[] objectArray) {
        return KErrorMsg.buildMsg(eID, objectArray);
    }

    public static void displayError(Component component, EID eID) {
        String string = eID.getComposedMessage();
        KErrorMsg.showMsg(component, string);
    }

    public static void displayError(Component component, EID eID, Object object) {
        Object[] objectArray = new Object[]{object};
        KErrorMsg.displayError(component, eID, objectArray);
    }

    public static void displayError(Component component, EID eID, Object[] objectArray) {
        if (objectArray != null) {
            String string = KErrorMsg.buildMsg(eID, objectArray);
            KErrorMsg.showMsg(component, string);
        } else {
            KErrorMsg.displayError(component, eID);
        }
    }

    private static void showMsg(final Component component, final String string) {
        if (string == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            KErrorMsg.showMessageDialog(component, string);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        KErrorMsg.showMessageDialog(component, string);
                    }
                });
            }
            catch (Exception exception) {
                KDebug.printStackTrace(exception);
            }
        }
    }

    private static void showMessageDialog(Component component, String string) {
        if (FATAL_ICON == null) {
            FATAL_ICON = new ImageIcon(KErrorMsg.class.getResource(FATAL_ICON_STR));
        }
        int n = 0;
        int n2 = 0;
        while ((n = string.indexOf(10, n)) != -1) {
            ++n;
            ++n2;
        }
        if (n2 > 10 || n2 == 0 && string.length() >= 80) {
            JTextArea jTextArea = new JTextArea(string);
            jTextArea.setEditable(false);
            jTextArea.setText(string);
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            JScrollPane jScrollPane = new JScrollPane(jTextArea);
            jScrollPane.setVerticalScrollBarPolicy(22);
            jScrollPane.setPreferredSize(new Dimension(200, 150));
            JOptionPane.showMessageDialog(component, jScrollPane, "Error", 0, FATAL_ICON);
        } else {
            JOptionPane.showMessageDialog(component, string, "Error", 0, FATAL_ICON);
        }
    }

    protected static String buildMsg(EID eID, Object[] objectArray) {
        String string = eID.getComposedMessage();
        if (string == null) {
            return null;
        }
        MessageFormat messageFormat = new MessageFormat("");
        messageFormat.setLocale(MsgMgr.currentLocale);
        messageFormat.applyPattern(string);
        return messageFormat.format(objectArray);
    }
}

