/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.proxy;

import cerent.util.proxy.CtcProxyFactory;
import cerent.util.proxy.SckfwdClient;
import cerent.util.proxy.SckfwdIo;
import cerent.util.proxy.SckfwdReply;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

class SckfwdClientsReply
extends SckfwdReply
implements Comparable {
    private String _server;
    private ArrayList _clients;

    SckfwdClientsReply(SckfwdIo sckfwdIo) throws IOException {
        this.readVersion(sckfwdIo);
        int n = sckfwdIo.readByte();
        if (n != 0) {
            sckfwdIo.skip(sckfwdIo.available());
            throw sckfwdIo.requestException(n);
        }
        int n2 = sckfwdIo.readByte();
        if (n2 != 0) {
            sckfwdIo.skip(sckfwdIo.available());
            throw sckfwdIo.protocolError("reserved byte (" + n2 + ") not zero");
        }
        int n3 = sckfwdIo.readByte();
        this._server = sckfwdIo.readAddress(n3);
        int n4 = sckfwdIo.readShort();
        this._clients = new ArrayList();
        int n5 = CtcProxyFactory.defaultCost();
        for (int i = 0; i < n4; ++i) {
            String string = sckfwdIo.readAddress(n3);
            if (string.equals(this._server)) {
                this._clients.add(new SckfwdClient(string, 0));
                continue;
            }
            this._clients.add(new SckfwdClient(string, n5));
        }
        Collections.sort(this._clients);
    }

    String getServer() {
        return this._server;
    }

    ArrayList clients() {
        return (ArrayList)this._clients.clone();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#<clients");
        Iterator iterator = this._clients.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(" ");
            stringBuffer.append(iterator.next().toString());
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public int compareTo(Object object) {
        int n = 0;
        Iterator iterator = this._clients.iterator();
        Iterator iterator2 = ((SckfwdClientsReply)object)._clients.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            n = ((SckfwdClient)iterator.next()).compareTo(iterator2.next());
            if (n == 0) continue;
            return n;
        }
        if (iterator.hasNext()) {
            n = -1;
        } else if (iterator2.hasNext()) {
            n = 1;
        }
        return n;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public int hashCode() {
        int n = this._clients.size();
        Iterator iterator = this._clients.iterator();
        while (iterator.hasNext()) {
            SckfwdClient sckfwdClient = (SckfwdClient)iterator.next();
            n ^= sckfwdClient.hashCode();
        }
        return n;
    }
}

