/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.proxy;

import cerent.util.proxy.CtcProxyFactory;
import cerent.util.proxy.SckfwdDisallowedException;
import cerent.util.proxy.SckfwdException;
import cerent.util.proxy.SckfwdExpiredException;
import cerent.util.proxy.SckfwdFailedException;
import cerent.util.proxy.SckfwdRefusedException;
import cerent.util.proxy.SckfwdUnreachableHostException;
import cerent.util.proxy.SckfwdUnreachableNetException;
import cerent.util.proxy.SckfwdUnsupportedAddressException;
import cerent.util.proxy.SckfwdUnsupportedCommandException;
import com.cisco.sot.SotSocketFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;

class SckfwdIo {
    private static SotSocketFactory _socketFactory = new SotSocketFactory();
    private Socket _socket;
    private InputStream _is;
    private OutputStream _os;
    private int _version;

    SckfwdIo(int n, String string, int n2) throws IOException {
        this._version = n;
        this._socket = _socketFactory.createSocket(string, n2, CtcProxyFactory.connectTimeout());
        this._socket.setSoTimeout(CtcProxyFactory.readTimeout());
        this._is = this._socket.getInputStream();
        this._os = this._socket.getOutputStream();
    }

    void close() throws IOException {
        this._is.close();
        this._os.close();
        this._socket.close();
    }

    int available() throws IOException {
        return this._is.available();
    }

    void skip(long l) throws IOException {
        this._is.skip(l);
    }

    IOException protocolError(String string) {
        return new IOException(string);
    }

    IOException protocolError(int n, int n2) {
        return this.protocolError("read failed: expected=" + n + " read=" + n2);
    }

    IOException protocolError(int n, int n2, int n3, int n4) {
        return this.protocolError("Send version " + n + " is incompatible with " + "reply version " + n2 + ". code=" + n3 + " avail=" + n4);
    }

    SckfwdException requestException(int n) {
        SckfwdException sckfwdException;
        switch (n) {
            case 1: {
                sckfwdException = new SckfwdFailedException();
                break;
            }
            case 2: {
                sckfwdException = new SckfwdDisallowedException();
                break;
            }
            case 3: {
                sckfwdException = new SckfwdUnreachableNetException();
                break;
            }
            case 4: {
                sckfwdException = new SckfwdUnreachableHostException();
                break;
            }
            case 5: {
                sckfwdException = new SckfwdRefusedException();
                break;
            }
            case 6: {
                sckfwdException = new SckfwdExpiredException();
                break;
            }
            case 7: {
                sckfwdException = new SckfwdUnsupportedCommandException();
                break;
            }
            case 8: {
                sckfwdException = new SckfwdUnsupportedAddressException();
                break;
            }
            default: {
                sckfwdException = new SckfwdException(n);
            }
        }
        return sckfwdException;
    }

    int readByte() throws IOException {
        int n = 0;
        byte[] byArray = new byte[1];
        int n2 = this._is.read(byArray, 0, byArray.length);
        if (n2 != byArray.length) {
            throw this.protocolError(byArray.length, n2);
        }
        n = byArray[0] & 0xFF;
        return n;
    }

    int readShort() throws IOException {
        int n = 0;
        byte[] byArray = new byte[2];
        int n2 = this._is.read(byArray, 0, byArray.length);
        if (n2 != byArray.length) {
            throw this.protocolError(byArray.length, n2);
        }
        for (int i = 0; i < 2; ++i) {
            n |= (byArray[1 - i] & 0xFF) << i * 8;
        }
        return n;
    }

    int readInt() throws IOException {
        int n = 0;
        byte[] byArray = new byte[4];
        int n2 = this._is.read(byArray, 0, byArray.length);
        if (n2 != byArray.length) {
            throw this.protocolError(byArray.length, n2);
        }
        for (int i = 0; i < 4; ++i) {
            n |= (byArray[3 - i] & 0xFF) << i * 8;
        }
        return n;
    }

    private int unsigned(byte by) {
        return by & 0xFF;
    }

    String readIpV4() throws IOException {
        byte[] byArray = new byte[4];
        int n = this._is.read(byArray, 0, byArray.length);
        if (n != byArray.length) {
            throw this.protocolError(byArray.length, n);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.unsigned(byArray[0]));
        for (int i = 1; i < 4; ++i) {
            stringBuffer.append('.');
            stringBuffer.append(this.unsigned(byArray[i]));
        }
        return stringBuffer.toString();
    }

    String readAddress(int n) throws IOException {
        switch (n) {
            case 1: {
                return this.readIpV4();
            }
            case 3: {
                this.skip(this.available());
                throw this.protocolError("Domain name addresses not implemented");
            }
            case 4: {
                this.skip(this.available());
                throw this.protocolError("IPV6 addresses not implemented");
            }
        }
        this.skip(this.available());
        throw this.protocolError("invalid address type (" + n + ")");
    }

    private static void writeByte(OutputStream outputStream, int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        outputStream.write(byArray, 0, byArray.length);
    }

    private static void writeShort(OutputStream outputStream, int n) throws IOException {
        byte[] byArray = new byte[2];
        for (int i = 0; i < 2; ++i) {
            byArray[1 - i] = (byte)(n >>> i * 8);
        }
        outputStream.write(byArray, 0, byArray.length);
    }

    private static void writeInt(OutputStream outputStream, int n) throws IOException {
        byte[] byArray = new byte[4];
        for (int i = 0; i < 4; ++i) {
            byArray[3 - i] = (byte)(n >>> i * 8);
        }
        outputStream.write(byArray, 0, byArray.length);
    }

    private static void writeIpV4(OutputStream outputStream, String string) throws IOException {
        byte[] byArray = InetAddress.getByName(string).getAddress();
        outputStream.write(byArray, 0, byArray.length);
    }

    private static void writeString(OutputStream outputStream, String string) throws IOException {
        byte[] byArray = string.getBytes();
        SckfwdIo.writeByte(outputStream, byArray.length);
        outputStream.write(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeMethods(int[] nArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            SckfwdIo.writeByte(byteArrayOutputStream, this.getVersion());
            SckfwdIo.writeByte(byteArrayOutputStream, nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                SckfwdIo.writeByte(byteArrayOutputStream, nArray[i]);
            }
            byteArrayOutputStream.writeTo(this._os);
        }
        finally {
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeUidPwd(String string, String string2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            SckfwdIo.writeByte(byteArrayOutputStream, this.getVersion());
            SckfwdIo.writeString(byteArrayOutputStream, string);
            SckfwdIo.writeString(byteArrayOutputStream, string2);
            byteArrayOutputStream.writeTo(this._os);
        }
        finally {
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRequest(int n, String string, int n2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            SckfwdIo.writeByte(byteArrayOutputStream, this.getVersion());
            SckfwdIo.writeByte(byteArrayOutputStream, n);
            SckfwdIo.writeByte(byteArrayOutputStream, 0);
            SckfwdIo.writeByte(byteArrayOutputStream, 1);
            SckfwdIo.writeIpV4(byteArrayOutputStream, string);
            SckfwdIo.writeShort(byteArrayOutputStream, n2);
            byteArrayOutputStream.writeTo(this._os);
        }
        finally {
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
        }
    }

    void writeConnect(String string, int n) throws IOException {
        this.writeRequest(1, string, n);
    }

    void writeBind(String string, int n) throws IOException {
        this.writeRequest(2, string, n);
    }

    void writeWhoami() throws IOException {
        this.writeRequest(4, InetAddress.getLocalHost().getHostAddress(), 0);
    }

    void writeClients() throws IOException {
        this.writeRequest(5, InetAddress.getLocalHost().getHostAddress(), 0);
    }

    void writeTopology() throws IOException {
        this.writeRequest(6, InetAddress.getLocalHost().getHostAddress(), 0);
    }

    void writeReset(String string, int n) throws IOException {
        this.writeRequest(8, string, n);
    }

    Socket getSocket() {
        return this._socket;
    }

    int getVersion() {
        return this._version;
    }

    void setVersion(int n) {
        this._version = n;
    }
}

