/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.core;

import cerent.util.IExecArgs;
import cerent.util.KDebug;
import com.cisco.ctc.core.IDownloadItem;
import com.cisco.ctc.core.IFutureProofer;
import com.cisco.ctc.core.IJreReqs;
import com.cisco.ctc.core.IJreVersion;
import com.cisco.ctc.core.INgrp;
import com.cisco.ctc.core.JreReqs;
import com.cisco.ctc.core.StraightProxy;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;

public class BaseCoreReflectionUtil {
    protected static final Class[] StringArgTypes = new Class[]{String.class};
    private static final Class ME = BaseCoreReflectionUtil.class;
    protected static final Class[] OBJECT_METHOD_ARGS_TYPES = new Class[]{Object.class, Method.class, Integer.TYPE};
    protected static final Method JRE_VERSION_CONVERTOR_METHOD = BaseCoreReflectionUtil.getDeclaredMethod("jreVersionConvertor", OBJECT_METHOD_ARGS_TYPES);
    protected static final Method DOWNLOAD_ITEM_CONVERTOR_METHOD = BaseCoreReflectionUtil.getDeclaredMethod("downloadItemConvertor", OBJECT_METHOD_ARGS_TYPES);
    protected static final Method FUTURE_PROOFER_CONVERTOR_METHOD = BaseCoreReflectionUtil.getDeclaredMethod("futureProoferConvertor", OBJECT_METHOD_ARGS_TYPES);
    private static final String IDOWNLOADITEM_CLASSNAME = IDownloadItem.class.getName();
    private static final String IJREVERSION_CLASSNAME = IJreVersion.class.getName();
    private static final String INGRP_CLASSNAME = INgrp.class.getName();
    private static final String IFUTUREPROOFER_CLASSNAME = IFutureProofer.class.getName();
    protected static final KDebug db = new KDebug("CoreReflectionUtil");

    protected BaseCoreReflectionUtil() {
    }

    protected static Method getDeclaredMethod(String string, Class[] classArray) {
        return BaseCoreReflectionUtil.getDeclaredMethod(ME, string, classArray);
    }

    protected static Method getDeclaredMethod(Class clazz, String string, Class[] classArray) {
        Method method = null;
        try {
            method = clazz.getDeclaredMethod(string, classArray);
        }
        catch (Throwable throwable) {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(throwable);
        }
        return method;
    }

    static Object jreVersionConvertor(Object object, Method method, int n) throws ClassNotFoundException {
        Class clazz;
        Object object2;
        Class<?> clazz2;
        if (object == null) {
            return null;
        }
        Class<?> clazz3 = clazz2 = n >= 0 ? method.getParameterTypes()[n] : method.getReturnType();
        if (clazz2.isPrimitive() || clazz2.getName().startsWith("java.")) {
            return object;
        }
        if (!clazz2.getName().equals(IJREVERSION_CLASSNAME)) {
            return null;
        }
        if (n >= 0) {
            object2 = clazz2.getClassLoader();
            clazz = ((ClassLoader)object2).loadClass(IJREVERSION_CLASSNAME);
        } else {
            clazz = IJreVersion.class;
        }
        object2 = BaseCoreReflectionUtil.createStraightProxy(clazz, object, null);
        return object2;
    }

    static Object ngrpConvertor(Object object, Method method, int n) {
        Class<?> clazz;
        if (object == null) {
            return null;
        }
        Class<?> clazz2 = clazz = n >= 0 ? method.getParameterTypes()[n] : method.getReturnType();
        if (clazz.isPrimitive() || clazz.getName().startsWith("java.")) {
            return object;
        }
        if (!clazz.getName().equals(INGRP_CLASSNAME)) {
            return null;
        }
        Object object2 = BaseCoreReflectionUtil.createStraightProxy(INgrp.class, object, null);
        return object2;
    }

    static Object downloadItemConvertor(Object object, Method method, int n) throws IOException, ClassNotFoundException {
        if (object == null) {
            return null;
        }
        Class<?> clazz = n >= 0 ? method.getParameterTypes()[n] : method.getReturnType();
        boolean bl = clazz.isArray();
        if (bl) {
            clazz = clazz.getComponentType();
        }
        if (!clazz.getName().equals(IDOWNLOADITEM_CLASSNAME)) {
            return null;
        }
        Object object2 = null;
        if (!bl) {
            object2 = BaseCoreReflectionUtil.createStraightProxy(IDownloadItem.class, object, null);
        } else {
            int n2 = Array.getLength(object);
            Class clazz2 = n >= 0 ? BaseCoreReflectionUtil.createServiceInterface(IDownloadItem.class, method) : IDownloadItem.class;
            object2 = Array.newInstance(clazz2, n2);
            for (int i = 0; i < n2; ++i) {
                Object object3 = Array.get(object, i);
                Object object4 = BaseCoreReflectionUtil.createStraightProxy(clazz2, object3, null);
                Array.set(object2, i, object4);
            }
        }
        return object2;
    }

    static Object futureProoferConvertor(Object object, Method method, int n) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> clazz;
        if (object == null) {
            return null;
        }
        Class<?> clazz2 = clazz = n >= 0 ? method.getParameterTypes()[n] : method.getReturnType();
        if (clazz.isPrimitive() || clazz.getName().startsWith("java.")) {
            return object;
        }
        Object object2 = clazz;
        while (clazz.isArray()) {
            if (!(clazz = clazz.getComponentType()).isPrimitive() && !clazz.getName().startsWith("java.")) continue;
            return clazz;
        }
        clazz = object2;
        object2 = BaseCoreReflectionUtil.downloadItemConvertor(object, method, n);
        if (object2 == null) {
            object2 = BaseCoreReflectionUtil.getJreReqs(object);
        }
        if (object2 == null) {
            object2 = BaseCoreReflectionUtil.ngrpConvertor(object, method, n);
        }
        if (object2 == null && clazz.getName().equals(IFUTUREPROOFER_CLASSNAME)) {
            ClassLoader classLoader = clazz.getClassLoader();
            Class<?> clazz3 = classLoader.loadClass(IFUTUREPROOFER_CLASSNAME);
            object2 = BaseCoreReflectionUtil.createStraightProxy(clazz3, object, FUTURE_PROOFER_CONVERTOR_METHOD, FUTURE_PROOFER_CONVERTOR_METHOD);
        }
        if (object2 == null) {
            throw new IllegalStateException("Logic missing in the futureProoferConvertor method to convert FutureProofer method return type: " + clazz.getName());
        }
        return object2;
    }

    protected static Object createStraightProxy(Class clazz, Object object, Method method) {
        return BaseCoreReflectionUtil.createStraightProxy(clazz, object, method, null);
    }

    protected static Object createStraightProxy(Class clazz, Object object, Method method, Method method2) {
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException("Class c: " + clazz.getName() + " must be an interface");
        }
        Class[] classArray = new Class[]{clazz};
        Object object2 = StraightProxy.newInstance(object, method, method2, classArray);
        return object2;
    }

    static Class createServiceInterface(Class clazz, Method method) throws ClassNotFoundException {
        Class<?> clazz2 = method.getDeclaringClass();
        ClassLoader classLoader = clazz2.getClassLoader();
        return classLoader.loadClass(clazz.getName());
    }

    public static Class loadClass(URL uRL, String string) throws ClassNotFoundException {
        URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{uRL}, null);
        Class<?> clazz = uRLClassLoader.loadClass(string);
        return clazz;
    }

    public static IJreVersion getJreVersion(Object object) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (object == null || object instanceof IJreVersion) {
            return (IJreVersion)object;
        }
        IJreVersion iJreVersion = (IJreVersion)BaseCoreReflectionUtil.createStraightProxy(IJreVersion.class, object, null);
        return iJreVersion;
    }

    public static IJreReqs getJreReqs(Object object) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (object == null || object instanceof IJreReqs) {
            return (IJreReqs)object;
        }
        Class<?> clazz = object.getClass();
        if (!clazz.getName().equals(JreReqs.class.getName())) {
            return null;
        }
        IJreReqs iJreReqs = (IJreReqs)BaseCoreReflectionUtil.createStraightProxy(IJreReqs.class, object, JRE_VERSION_CONVERTOR_METHOD, JRE_VERSION_CONVERTOR_METHOD);
        return iJreReqs;
    }

    public static IExecArgs getExecArgs(ClassLoader classLoader) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> clazz = classLoader.loadClass("cerent.util.ExecArgs");
        Object obj = clazz.newInstance();
        IExecArgs iExecArgs = (IExecArgs)BaseCoreReflectionUtil.createStraightProxy(IExecArgs.class, obj, null);
        return iExecArgs;
    }

    public static IFutureProofer getFutureProofer(ClassLoader classLoader) throws ClassNotFoundException, InstantiationException, InvocationTargetException {
        Class<?> clazz = classLoader.loadClass("com.cisco.ctc.core.FutureProofer");
        Object object = BaseCoreReflectionUtil.newInstance(clazz);
        IFutureProofer iFutureProofer = (IFutureProofer)BaseCoreReflectionUtil.createStraightProxy(IFutureProofer.class, object, FUTURE_PROOFER_CONVERTOR_METHOD, FUTURE_PROOFER_CONVERTOR_METHOD);
        return iFutureProofer;
    }

    protected static Object newInstance(Class clazz) throws InvocationTargetException, InstantiationException {
        int n;
        Constructor constructor = null;
        try {
            constructor = clazz.getConstructor(null);
            int n2 = clazz.getModifiers();
            if ((n2 & 1) != 0) {
                return clazz.newInstance();
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        Method method = null;
        try {
            method = clazz.getDeclaredMethod("instance", null);
            n = method.getModifiers();
            if ((n & 1) != 0 && (n & 8) != 0) {
                return method.invoke(null, null);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            method = clazz.getDeclaredMethod("getInstance", null);
            n = method.getModifiers();
            if ((n & 1) != 0 && (n & 8) != 0) {
                return method.invoke(null, null);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    public static Object getInstanceFieldValue(Object object, String string) throws NoSuchFieldException, IllegalAccessException {
        Class<?> clazz = object.getClass();
        Field field = null;
        do {
            try {
                field = clazz.getDeclaredField(string);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                clazz = clazz.getSuperclass();
            }
        } while (field == null && clazz != null && !clazz.equals(class$java$lang$Object == null ? BaseCoreReflectionUtil.class$("java.lang.Object") : class$java$lang$Object));
        field.setAccessible(true);
        Object object2 = field.get(object);
        return object2;
    }
}

