/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.core;

import com.cisco.ctc.core.IDownloadItem;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;

public class DownloadItem
implements IDownloadItem {
    private final File downloadDir;
    private final File file;
    private final String downloadUri;
    private final String path;
    private final String simpleName;
    private final URL url;

    public DownloadItem(File file, String string) throws IOException {
        this.downloadDir = file;
        String string2 = string = string == null ? null : string.trim();
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Download line must be a non-empty string");
        }
        this.downloadUri = string;
        this.file = new File(file, string);
        this.path = this.file.getCanonicalPath();
        String string3 = this.file.getName();
        int n = string3.lastIndexOf(".");
        if (n >= 0) {
            string3 = string3.substring(0, n);
        }
        this.simpleName = string3;
        this.url = new URL("file", "", this.path);
    }

    public DownloadItem(IDownloadItem iDownloadItem) throws IOException {
        this(iDownloadItem.getDownloadDir(), iDownloadItem.getDownloadUri());
    }

    public File getDownloadDir() {
        return this.downloadDir;
    }

    public String getDownloadUri() {
        return this.downloadUri;
    }

    public File getFile() {
        return this.file;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public URL getURL() {
        return this.url;
    }

    public URL getDownloadURL(String string) {
        URL uRL = null;
        try {
            String string2 = this.downloadUri;
            if (!string2.startsWith("/")) {
                string2 = "/" + string2;
            }
            uRL = new URL("http", string, string2);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return uRL;
    }

    public String toWriteString() {
        return this.downloadUri;
    }

    public String toString() {
        return this.downloadUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IDownloadItem[] readDownloadItems(File file, InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = null;
        ArrayList<DownloadItem> arrayList = new ArrayList<DownloadItem>();
        String string = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith("#")) continue;
                DownloadItem downloadItem = new DownloadItem(file, string);
                arrayList.add(downloadItem);
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return arrayList.toArray(DOWNLOAD_ITEM_ARRAY_TEMPLATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDownloadItems(IDownloadItem[] iDownloadItemArray, OutputStream outputStream) throws IOException {
        if (iDownloadItemArray == null || iDownloadItemArray.length == 0) {
            return;
        }
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
            int n = iDownloadItemArray == null ? 0 : iDownloadItemArray.length;
            for (int i = 0; i < n; ++i) {
                IDownloadItem iDownloadItem = iDownloadItemArray[i];
                String string = iDownloadItem.toWriteString();
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.newLine();
            }
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

