/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.core.launcher;

import cerent.util.EID;
import cerent.util.KEMC;
import cerent.util.KErrorMsg;
import com.cisco.ctc.core.IJreReqs;
import com.cisco.ctc.core.JreVersion;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class JreChooser
extends JDialog
implements ActionListener {
    private JFileChooser fc;
    private static String lastDir = null;
    private Object lock = new Object();
    private boolean done = false;
    private JreVersion pickedJreVersion = null;
    private File pickedJreDir = null;
    private IJreReqs reqs;

    public JreChooser(Frame frame, IJreReqs iJreReqs, String string) {
        super(frame, "Java Directory Selection", true);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Java Version Requirements for CTC R" + string));
        JPanel jPanel2 = new JPanel(new GridLayout(2, 2));
        jPanel2.add(new JLabel("Minimum Java Version:  ", 4));
        jPanel2.add(new JLabel(iJreReqs.getMinimum().toString()));
        jPanel2.add(new JLabel("Recommended Java Version:  ", 4));
        jPanel2.add(new JLabel(iJreReqs.getRecommended().toString()));
        JTextArea jTextArea = new JTextArea();
        jTextArea.append("\nSelecting a Java version greater or equal to " + iJreReqs.getMaximum().toString() + " will be allowed but may cause unexpected issues using the software");
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        jTextArea.setBackground(this.getBackground());
        jPanel.add((Component)jPanel2, "North");
        jPanel.add(jTextArea);
        this.fc = new JFileChooser(lastDir);
        this.fc.setBorder(BorderFactory.createEmptyBorder(20, 5, 10, 5));
        this.fc.setFileSelectionMode(1);
        this.fc.setApproveButtonText("Select Directory");
        this.getContentPane().add((Component)jPanel, "North");
        this.getContentPane().add((Component)this.fc, "Center");
        this.fc.addActionListener(this);
        this.setDefaultCloseOperation(2);
        this.reqs = iJreReqs;
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        int n = (dimension.width - dimension2.width) / 2;
        int n2 = (dimension.height - dimension2.height) / 2;
        this.setLocation(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        super.dispose();
        Object object = this.lock;
        synchronized (object) {
            this.done = true;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getJavaDirectory() {
        Object object = this.lock;
        synchronized (object) {
            while (!this.done) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    return null;
                }
            }
        }
        return this.pickedJreDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JreVersion getJavaVersion() {
        Object object = this.lock;
        synchronized (object) {
            while (!this.done) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    return null;
                }
            }
        }
        return this.pickedJreVersion;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand() == "CancelSelection") {
            this.dispose();
        } else {
            JreVersion jreVersion;
            File file;
            File file2 = this.fc.getSelectedFile();
            lastDir = file2.getAbsolutePath();
            try {
                file = JreChooser.getJreDir(file2);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "Invalid Java Directory:" + exception.toString(), "Invalid Java Directory", 0);
                return;
            }
            try {
                jreVersion = JreChooser.getRtJarVer(file);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(null, "Cannot get Java version:" + iOException.getMessage(), "Invalid Java Runtime", 0);
                return;
            }
            if (this.reqs.meetsReqs(jreVersion)) {
                String string;
                int n;
                if (this.reqs.isUntested(jreVersion) && (n = JOptionPane.showConfirmDialog(this, string = KErrorMsg.getString((EID)KEMC.WID_JRE_VERSION_NOT_RECOMMENDED_P1, jreVersion), "Select JRE", 2, 2)) == 2) {
                    return;
                }
                this.pickedJreDir = file;
                this.pickedJreVersion = jreVersion;
                this.done = true;
                this.dispose();
            } else {
                JOptionPane.showMessageDialog(null, "Selected Java version " + jreVersion + " does not meet requirements", "Invalid Java Version", 0);
            }
        }
    }

    public static File getJreDir(File file) throws IOException {
        File file2;
        File file3;
        if (file.getName().equalsIgnoreCase("bin") || file.getName().equalsIgnoreCase("lib")) {
            file = file.getParentFile();
        }
        if (!(file3 = new File(file, "jre")).isDirectory()) {
            file3 = file;
        }
        if (!(file2 = JreChooser.getJavaCmd(file3)).exists()) {
            throw new IOException("Cannot find:" + file2);
        }
        return file3;
    }

    private static JavaVersionMatcher makeMatcher(String string, Pattern pattern, InputStream inputStream) {
        return new JavaVersionMatcher(string, pattern, inputStream);
    }

    public static JreVersion getRtJarVer(File file) throws IOException {
        JreVersion jreVersion = null;
        String string = JreChooser.getJavaCmd(file).getAbsolutePath();
        Process process = Runtime.getRuntime().exec(new String[]{string, "-version"});
        Pattern pattern = Pattern.compile("java version \"(.*)\"");
        JavaVersionMatcher[] javaVersionMatcherArray = new JavaVersionMatcher[]{JreChooser.makeMatcher(string + "-input", pattern, process.getInputStream()), JreChooser.makeMatcher(string + "-error", pattern, process.getErrorStream())};
        for (int i = 0; i < javaVersionMatcherArray.length; ++i) {
            JreVersion jreVersion2 = javaVersionMatcherArray[i].getVersion();
            if (jreVersion2 == null) continue;
            jreVersion = jreVersion2;
        }
        return jreVersion;
    }

    private static File getJavaCmd(File file) {
        return new File(new File(file, "bin"), File.separator.equals("/") ? "java" : "java.exe");
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.print(stringArray[i]);
            try {
                System.out.println(" -> " + JreChooser.getRtJarVer(new File(stringArray[i])));
                continue;
            }
            catch (IOException iOException) {
                System.out.println(": " + iOException.toString());
            }
        }
    }

    private static class JavaVersionMatcher
    implements Runnable {
        private Pattern versionPattern;
        private InputStream source;
        private IOException exception;
        private JreVersion jreVersion;
        private Thread thread;

        JavaVersionMatcher(String string, Pattern pattern, InputStream inputStream) {
            this.versionPattern = pattern;
            this.source = inputStream;
            this.exception = null;
            this.jreVersion = null;
            this.thread = new Thread((Runnable)this, string);
            this.thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(this.source));
                String string = bufferedReader.readLine();
                while (string != null) {
                    Matcher matcher = this.versionPattern.matcher(string);
                    if (matcher.matches()) {
                        this.jreVersion = new JreVersion(matcher.group(1));
                    }
                    string = bufferedReader.readLine();
                }
            }
            catch (IOException iOException) {
                this.exception = iOException;
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        this.exception = iOException;
                    }
                }
            }
        }

        private JreVersion getVersion() throws IOException {
            boolean bl = false;
            do {
                try {
                    this.thread.join();
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                }
            } while (bl);
            if (this.exception != null) {
                throw this.exception;
            }
            return this.jreVersion;
        }
    }
}

