/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.sot;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;

public class CircularBuffer {
    private ByteBuffer bb;
    private int available = 0;
    private int readIndex = 0;
    private int writeIndex = 0;

    public CircularBuffer(int n, int n2) {
        this.bb = ByteBuffer.allocate(n);
    }

    public synchronized void write(ByteBuffer byteBuffer, int n) throws BufferOverflowException {
        if (n == 0) {
            return;
        }
        if (n + this.available > this.bb.capacity()) {
            throw new BufferOverflowException();
        }
        this.bb.position(this.writeIndex);
        int n2 = byteBuffer.limit();
        int n3 = byteBuffer.position();
        if (this.readIndex > this.writeIndex) {
            byteBuffer.limit(n3 + n);
            this.bb.put(byteBuffer);
        } else {
            int n4 = this.bb.capacity() - this.writeIndex;
            if (n <= n4) {
                byteBuffer.limit(n3 + n);
                this.bb.put(byteBuffer);
            } else {
                byteBuffer.limit(n3 + n4);
                this.bb.put(byteBuffer);
                this.bb.position(0);
                byteBuffer.limit(n3 + n);
                this.bb.put(byteBuffer);
            }
        }
        this.writeIndex = this.bb.position();
        if (this.writeIndex == this.bb.capacity()) {
            this.writeIndex = 0;
        }
        this.available += n;
        byteBuffer.limit(n2);
    }

    public synchronized int read(byte[] byArray, int n, int n2) {
        if (this.available == 0) {
            return 0;
        }
        if (this.available < n2) {
            n2 = this.available;
        }
        this.bb.position(this.readIndex);
        if (this.readIndex >= this.writeIndex) {
            int n3 = this.bb.capacity() - this.readIndex;
            if (n2 > n3) {
                this.bb.get(byArray, n, n3);
                this.bb.position(0);
                this.bb.get(byArray, n + n3, n2 - n3);
            } else {
                this.bb.get(byArray, n, n2);
            }
        } else {
            this.bb.get(byArray, n, n2);
        }
        this.readIndex = this.bb.position();
        if (this.readIndex == this.bb.capacity()) {
            this.readIndex = 0;
        }
        this.available -= n2;
        return n2;
    }

    public long skip(long l) {
        int n;
        if (this.available == 0 || l <= 0L) {
            return 0L;
        }
        int n2 = l > (long)this.available ? this.available : (int)l;
        this.readIndex = this.readIndex >= this.writeIndex ? (n2 > (n = this.bb.capacity() - this.readIndex) ? n2 - n : (this.readIndex += n2)) : (this.readIndex += n2);
        if (this.readIndex == this.bb.capacity()) {
            this.readIndex = 0;
        }
        this.available -= n2;
        return n2;
    }

    public int available() {
        return this.available;
    }

    public int capacity() {
        return this.bb.capacity();
    }

    public String dump() {
        return " AV=" + this.available + " R=" + this.readIndex + " W=" + this.writeIndex;
    }
}

