/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.sot;

import cerent.util.KDebug;
import com.cisco.sot.SotSocketImpl;
import com.cisco.sot.Ssh;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;

public class SotOutputStream
extends OutputStream {
    private static final int MAX_DATA_SIZE = 1024;
    private SotSocketImpl socket;
    private boolean closed = false;
    private Object writeLock = new Object();
    private byte[] singleByteArray = new byte[1];
    private byte[] outByteArray = null;
    private int outLen = 0;
    private int outOffset = 0;
    private int lockCount = 0;
    private int credit;

    protected SotOutputStream(SotSocketImpl sotSocketImpl, int n) {
        this.socket = sotSocketImpl;
        this.credit = n;
    }

    public void close() throws IOException {
        this.socket.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        this.closed = true;
        Object object = this.writeLock;
        synchronized (object) {
            this.writeLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("Socket closed");
        }
        if (n2 > 0) {
            Object object = this.writeLock;
            synchronized (object) {
                ++this.lockCount;
                while (this.outByteArray != null) {
                    try {
                        this.writeLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!this.closed) continue;
                    --this.lockCount;
                    throw new IOException("Socket closed");
                }
                this.outByteArray = byArray;
                this.outLen = n2;
                this.outOffset = n;
                this.sendData();
                --this.lockCount;
            }
            this.socket.getTunnel().addTx(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void write(int n) throws IOException {
        if (this.closed) {
            throw new IOException("Socket closed");
        }
        Object object = this.writeLock;
        synchronized (object) {
            while (this.outByteArray != null) {
                try {
                    this.writeLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.closed) continue;
                throw new IOException("Socket closed");
            }
            this.singleByteArray[0] = (byte)n;
            this.outByteArray = this.singleByteArray;
            this.outLen = 1;
            this.outOffset = 0;
            this.sendData();
        }
        this.socket.getTunnel().addTx(1);
    }

    private void sendData() throws ClosedChannelException, IOException {
        if (this.credit > 0) {
            this.socket.getTunnel().setWritable();
        }
        int n = this.outLen;
        while (this.outLen > 0) {
            try {
                this.writeLock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.socket.isClosed()) continue;
            throw new IOException("Socket is closed");
        }
        this.outByteArray = null;
        this.writeLock.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int collectSendPdus(ByteBuffer byteBuffer) {
        int n = byteBuffer.remaining() - 9;
        if (this.outByteArray != null && this.outLen > 0 && this.credit > 0) {
            if (n > 0) {
                int n2 = Math.min(this.credit, this.outLen);
                n2 = Math.min(n2, 1024);
                n2 = Math.min(n2, n);
                Ssh.chnDataRq(byteBuffer, this.socket.getLocChnId(), this.socket.getRemChnId(), this.outByteArray, this.outOffset, n2);
                this.outOffset += n2;
                this.outLen -= n2;
                this.credit -= n2;
                if (this.outLen == 0) {
                    Object object = this.writeLock;
                    synchronized (object) {
                        this.writeLock.notifyAll();
                    }
                }
                return 1;
            }
            return -1;
        }
        return 0;
    }

    public void addCredit(int n) throws ClosedChannelException, IOException {
        this.credit += n;
        if (this.outLen > 0) {
            this.socket.getTunnel().setReadWriteByNio();
        }
    }

    public void dump(KDebug kDebug) {
        StringBuffer stringBuffer = new StringBuffer("    OutputStream ");
        if (this.lockCount > 0) {
            stringBuffer.append(" blocked writer=" + this.lockCount);
        }
        if (this.outLen > 0) {
            stringBuffer.append(" tosend=" + this.outLen);
            stringBuffer.setCharAt(0, '*');
        }
        stringBuffer.append(" credit=" + this.credit);
        if (this.closed) {
            stringBuffer.append("closed");
        }
        kDebug.println(stringBuffer.toString());
    }
}

