/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.sot;

import cerent.util.KDebug;
import com.cisco.sot.SotInputStream;
import com.cisco.sot.SotOutputStream;
import com.cisco.sot.Ssh;
import com.cisco.sot.SsiState;
import com.cisco.sot.Tl1Tunnel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;

public class SotSocketImpl
extends SocketImpl {
    protected static final int WINDOW_SIZE = 4096;
    private Tl1Tunnel tunnel;
    private SotOutputStream outputStream;
    private SotInputStream inputStream;
    private int locid;
    private int remid;
    private InetSocketAddress sockAddr;
    static KDebug dbg = new KDebug("Ssi");
    private SsiState state;
    private String openFailedDesc = null;
    private SshQueue sshQ;

    private SotSocketImpl() {
    }

    SotSocketImpl(Tl1Tunnel tl1Tunnel, int n) {
        this.tunnel = tl1Tunnel;
        this.locid = n;
        this.outputStream = new SotOutputStream(this, 4096);
        this.inputStream = new SotInputStream(this, 4096);
        this.sshQ = new SshQueue();
    }

    public int getLocChnId() {
        return this.locid;
    }

    public int getRemChnId() {
        return this.remid;
    }

    public Tl1Tunnel getTunnel() {
        return this.tunnel;
    }

    public boolean isClosed() {
        return this.state == SsiState.CLOSED;
    }

    int collectSendPdus(ByteBuffer byteBuffer) {
        return this.sshQ.collectSendPdus(byteBuffer);
    }

    protected int available() throws IOException {
        return this.inputStream.available();
    }

    protected void close() throws IOException {
        if (this.tunnel.getState() == Tl1Tunnel.OPEN) {
            this.tunnel.sendChnClose(this.getRemChnId(), false);
        }
        this.localClose();
    }

    private void localClose() {
        if (dbg.on()) {
            dbg.println("close state=" + this.state + " locid=" + Integer.toHexString(this.locid) + " remid=" + Integer.toHexString(this.remid));
        }
        this.state = SsiState.CLOSED;
        this.tunnel.removeSocket(this);
        this.unblockAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unblockAll() {
        this.inputStream.dispose();
        this.outputStream.dispose();
        SshQueue sshQueue = this.sshQ;
        synchronized (sshQueue) {
            this.sshQ.notifyAll();
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connect(SocketAddress socketAddress, int n) throws IOException {
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new IOException("Unsupported SocketAddress class");
        }
        this.sockAddr = (InetSocketAddress)socketAddress;
        this.port = this.sockAddr.getPort();
        this.address = this.sockAddr.getAddress();
        this.state = SsiState.OPENING;
        this.sshQ.sendConnectRq(this.sockAddr);
        if (dbg.on()) {
            dbg.println("connect " + this.sockAddr + " timeout=" + n);
        }
        SshQueue sshQueue = this.sshQ;
        synchronized (sshQueue) {
            while (this.state == SsiState.OPENING) {
                try {
                    this.sshQ.wait(n);
                    if (this.state == SsiState.OPENING) {
                        this.localClose();
                        throw new IOException("Connect timed out");
                    }
                    if (this.state == SsiState.CLOSED) {
                        throw new IOException("Connect failed:" + (this.openFailedDesc == null ? "Unspecified reason" : this.openFailedDesc));
                    }
                    break;
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    protected void connect(String string, int n) throws IOException {
        this.connect(InetAddress.getByName(string), n);
    }

    protected void connect(InetAddress inetAddress, int n) throws IOException {
        this.connect(new InetSocketAddress(inetAddress, n), 5000);
    }

    protected void accept(SocketImpl socketImpl) throws IOException {
        throw new IOException("accept not supported on SoTL1 sockets");
    }

    protected void bind(InetAddress inetAddress, int n) throws IOException {
        throw new IOException("bind not supported on SoTL1 sockets");
    }

    protected void listen(int n) throws IOException {
        throw new IOException("listen not supported on SoTL1 sockets");
    }

    protected void create(boolean bl) throws IOException {
        if (!bl) {
            throw new IOException("create datagram not supported");
        }
    }

    public Object getOption(int n) throws SocketException {
        throw new SocketException("getOption not supported");
    }

    public void setOption(int n, Object object) throws SocketException {
        switch (n) {
            case 4102: {
                if (object instanceof Integer) {
                    int n2 = (Integer)object;
                    this.inputStream.setTimeout(n2);
                    break;
                }
                dbg.println("Unexpected object type for SO_TIMEOUT:" + object);
                break;
            }
            case 1: 
            case 8: {
                break;
            }
            default: {
                dbg.println("setOption unsupported id=" + n + " obj=" + object);
            }
        }
    }

    protected void sendUrgentData(int n) throws IOException {
        throw new IOException("sendUrgentData not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chnOpenConf(int n, int n2, int n3) throws ClosedChannelException, IOException {
        SotSocketImpl sotSocketImpl = this.tunnel.getStaleSocket(n);
        if (sotSocketImpl != null) {
            dbg.println("Forcing a tunnel reset");
            this.tunnel.dispose();
        } else {
            if (this.state == SsiState.OPENING) {
                this.state = SsiState.OPEN;
            } else {
                dbg.println("chnOpenConf invalid state:" + this.state);
            }
            this.remid = n;
            if (dbg.on()) {
                dbg.println("connect-cf remid=" + Integer.toHexString(this.remid));
            }
            SshQueue sshQueue = this.sshQ;
            synchronized (sshQueue) {
                this.sshQ.notifyAll();
            }
        }
    }

    public void chnOpenFail(int n, String string) {
        this.openFailedDesc = string;
        if (this.state == SsiState.OPEN) {
            dbg.println("chnOpenFail invalid state:" + this.state);
        }
        this.localClose();
    }

    public void chnWndAdjust(int n) throws ClosedChannelException, IOException {
        this.outputStream.addCredit(n);
    }

    public void chnData(int n, ByteBuffer byteBuffer) {
        if (this.state == SsiState.OPEN) {
            try {
                this.inputStream.addData(byteBuffer, n);
            }
            catch (BufferOverflowException bufferOverflowException) {
                KDebug.printStackTrace(bufferOverflowException);
                try {
                    this.close();
                }
                catch (IOException iOException) {}
            }
        } else {
            byteBuffer.position(byteBuffer.position() + n);
        }
    }

    public void chnClose() {
        this.tunnel.sendChnClose(this.remid, true);
        this.localClose();
    }

    public void dump() {
        dbg.println("--- Socket " + this.sockAddr + " ST=" + this.state + " locid=" + Integer.toHexString(this.locid) + " remid=" + Integer.toHexString(this.remid));
        this.sshQ.dump();
    }

    class SshQueue {
        private InetSocketAddress pendingConnect = null;
        private boolean pendingConnectRs = false;

        void sendConnectRq(InetSocketAddress inetSocketAddress) throws ClosedChannelException, IOException {
            this.pendingConnect = inetSocketAddress;
            SotSocketImpl.this.tunnel.setWritable();
        }

        void sendConnectRs() throws ClosedChannelException, IOException {
            this.pendingConnectRs = true;
            SotSocketImpl.this.tunnel.setWritable();
        }

        int collectSendPdus(ByteBuffer byteBuffer) {
            if (this.pendingConnect != null) {
                if (byteBuffer.remaining() >= Ssh.OPEN_CHANNEL_SIZE) {
                    Ssh.openChannelRq(byteBuffer, SotSocketImpl.this.locid, 4096, 0, this.pendingConnect.getAddress().getHostAddress(), this.pendingConnect.getPort());
                    this.pendingConnect = null;
                    return 1;
                }
                return -1;
            }
            if (this.pendingConnectRs) {
                if (byteBuffer.remaining() >= 17) {
                    Ssh.openChannelRs(byteBuffer, SotSocketImpl.this.getRemChnId(), SotSocketImpl.this.getLocChnId(), 4096, 0);
                    this.pendingConnectRs = false;
                    return 1;
                }
                return -1;
            }
            int n = 0;
            n = SotSocketImpl.this.inputStream.collectSendPdus(byteBuffer);
            if (n < 0) {
                return -1;
            }
            int n2 = SotSocketImpl.this.outputStream.collectSendPdus(byteBuffer);
            if (n2 < 0) {
                if (n == 0) {
                    return -1;
                }
                return n;
            }
            return n += n2;
        }

        public void dump() {
            if (this.pendingConnect != null) {
                dbg.println("*   pendingConnect=" + this.pendingConnect);
            }
            SotSocketImpl.this.inputStream.dump(dbg);
            SotSocketImpl.this.outputStream.dump(dbg);
        }
    }
}

