/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.sot;

import cerent.util.Preferences;
import com.cisco.sot.Tl1TunnelAddr;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

public class Tl1TunnelAddrBook {
    private static final String PREFS_PREFIX = "ctc.sotl1";
    private static final String PREFS_TUNNEL = "tunnel.";
    private LinkedList mrulist = new LinkedList();
    private static Tl1TunnelAddrBook _instance;
    private int lastKey = -1;

    private Tl1TunnelAddrBook() {
        this.load();
    }

    public static synchronized Tl1TunnelAddrBook instance() {
        if (_instance == null) {
            _instance = new Tl1TunnelAddrBook();
        }
        return _instance;
    }

    public void setMruTunnel(Tl1TunnelAddr tl1TunnelAddr) {
        this.deleteTunnel(tl1TunnelAddr, false);
        this.mrulist.addFirst(tl1TunnelAddr);
        this.save();
    }

    public Tl1TunnelAddr[] getTunnels() {
        return this.mrulist.toArray(new Tl1TunnelAddr[0]);
    }

    public String[] getUniqueGneHosts() {
        LinkedList<String> linkedList = new LinkedList<String>();
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.mrulist.iterator();
        while (iterator.hasNext()) {
            Tl1TunnelAddr tl1TunnelAddr = (Tl1TunnelAddr)iterator.next();
            if (hashSet.contains(tl1TunnelAddr.host)) continue;
            linkedList.addLast(tl1TunnelAddr.host);
            hashSet.add(tl1TunnelAddr.host);
        }
        return linkedList.toArray(new String[0]);
    }

    public void deleteTunnel(Tl1TunnelAddr tl1TunnelAddr, boolean bl) {
        Iterator iterator = this.mrulist.iterator();
        while (iterator.hasNext()) {
            Tl1TunnelAddr tl1TunnelAddr2 = (Tl1TunnelAddr)iterator.next();
            if (!tl1TunnelAddr2.equals(tl1TunnelAddr)) continue;
            iterator.remove();
            if (!bl) break;
            this.save();
            break;
        }
    }

    public Tl1TunnelAddr[] getTunnelFromGneHost(String string) {
        LinkedList<Tl1TunnelAddr> linkedList = new LinkedList<Tl1TunnelAddr>();
        Iterator iterator = this.mrulist.iterator();
        while (iterator.hasNext()) {
            Tl1TunnelAddr tl1TunnelAddr = (Tl1TunnelAddr)iterator.next();
            if (!tl1TunnelAddr.host.equals(string)) continue;
            linkedList.add(tl1TunnelAddr);
        }
        return linkedList.toArray(new Tl1TunnelAddr[0]);
    }

    private void save() {
        Preferences preferences = Preferences.instance();
        Iterator iterator = this.mrulist.iterator();
        int n = 0;
        while (true) {
            String string = PREFS_TUNNEL + n;
            if (iterator.hasNext()) {
                Tl1TunnelAddr tl1TunnelAddr = (Tl1TunnelAddr)iterator.next();
                preferences.setProperty(PREFS_PREFIX, string, tl1TunnelAddr.getPersistedValue());
            } else {
                if (n > this.lastKey) break;
                preferences.removeProperty(PREFS_PREFIX, string);
            }
            ++n;
        }
        try {
            preferences.store();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void load() {
        String string;
        String string2;
        Preferences preferences = Preferences.instance();
        int n = 0;
        while ((string2 = preferences.getProperty(PREFS_PREFIX, string = PREFS_TUNNEL + n, null)) != null) {
            try {
                Tl1TunnelAddr tl1TunnelAddr = new Tl1TunnelAddr(string2);
                this.mrulist.addLast(tl1TunnelAddr);
                this.lastKey = n;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n;
        }
    }
}

