/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.loader;

import cerent.cms.loader.ElementCachedJarFactory;
import cerent.cms.loader.FactoryMap;
import cerent.cms.loader.IElementFactory;
import cerent.cms.loader.INodeFactory;
import cerent.cms.model.Feature;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IProgressManager;
import cerent.cms.ui.IEntityCellRenderer;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.IViewController;
import cerent.launcher.Bootstrap;
import cerent.launcher.CachedJar;
import cerent.launcher.CachedJarFactory;
import cerent.launcher.ClassLoaderFactory;
import cerent.launcher.CmsClassLoader;
import cerent.util.BuildInfo;
import cerent.util.ConcurrentReaderMap;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.awt.Image;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;

public class ElementFactory
implements IElementFactory {
    private static final String[] StringArrayTemplate = new String[0];
    private static CmsClassLoader myParent = null;
    protected static FactoryMap myFactories = null;
    private static String myBaseUrl = null;
    protected static final String FTG_PKG_PREFIX = "cerent.cms.model.ftg.";
    private static final String FTG_UI_PKG_PREFIX = "cerent.cms.ui.ftg.";
    private static SDebug db = new SDebug("ElementFactory");
    private static ElementFactory instance = new ElementFactory();
    private static ConcurrentReaderMap versionTypeClMap = new ConcurrentReaderMap();

    protected static synchronized IElementFactory getInstance() {
        return instance;
    }

    public static final ElementFactory getElementFactoryInstance() {
        return instance;
    }

    protected SDebug getDb() {
        return db;
    }

    public static synchronized void setParent(CmsClassLoader cmsClassLoader) {
        if (myParent == null) {
            myParent = cmsClassLoader;
        }
        if (myFactories == null) {
            myFactories = new FactoryMap();
        }
    }

    public static synchronized void setBaseUrl(String string) {
        if (myBaseUrl == null) {
            myBaseUrl = string;
        }
    }

    protected ElementFactory() {
        SDebug sDebug = this.getDb();
        sDebug.set(true);
        if (sDebug.on()) {
            sDebug.println("ctor: instance created");
        }
    }

    private ClassLoader loadFromBaseUrl(String string, String string2) throws Exception {
        SDebug sDebug = this.getDb();
        if (sDebug.on()) {
            sDebug.println("!Loading ELE from " + myBaseUrl + " for " + string + "...");
        }
        ElementCachedJarFactory elementCachedJarFactory = new ElementCachedJarFactory(myBaseUrl, "ELE", string2, string);
        return ClassLoaderFactory.getClassLoader((String)string, (CachedJarFactory)elementCachedJarFactory, (ClassLoader)myParent);
    }

    private ClassLoader loadFromNetwork(String string, String string2) throws Exception {
        SDebug sDebug = this.getDb();
        if (sDebug.on()) {
            sDebug.println("loadFromNetwork " + string);
        }
        ElementCachedJarFactory elementCachedJarFactory = new ElementCachedJarFactory("http://" + string, "ELE", string2, string);
        return ClassLoaderFactory.getClassLoader((String)string, (CachedJarFactory)elementCachedJarFactory, (ClassLoader)myParent);
    }

    protected ClassLoader findClassLoader(String string, String string2) throws Exception {
        ClassLoader classLoader;
        SDebug sDebug = this.getDb();
        try {
            classLoader = myBaseUrl == null ? this.loadFromNetwork(string, string2) : this.loadFromBaseUrl(string, string2);
        }
        catch (Exception exception) {
            sDebug.println("!Failed to load any JAR for " + string);
            SDebug.printStackTrace((Throwable)exception);
            throw exception;
        }
        if (sDebug.on()) {
            sDebug.println("findClassLoader=" + classLoader);
        }
        return classLoader;
    }

    public IViewController createSVC(IViewController iViewController, INodeModel iNodeModel, IUiToolkit iUiToolkit) {
        SDebug sDebug = this.getDb();
        if (sDebug.on()) {
            sDebug.println("createSVC " + iNodeModel);
        }
        INodeFactory iNodeFactory = myFactories.get(iNodeModel.loader());
        return iNodeFactory.createSVC(iViewController, iNodeModel, iUiToolkit);
    }

    protected Object InvokeFTGCtor(String string, Object object, Class clazz) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException {
        Class clazz2 = ElementFactory.class;
        Class<?> clazz3 = Class.forName(string);
        Class[] classArray = new Class[]{clazz};
        Constructor<?> constructor = clazz3.getDeclaredConstructor(classArray);
        Object[] objectArray = new Object[]{object};
        return constructor.newInstance(objectArray);
    }

    public INodeModel createNodeModel(String string, int n, String string2, String string3, String string4, String string5, IUiToolkit iUiToolkit, IProgressManager iProgressManager) throws ClassNotFoundException, InstantiationException, IllegalAccessException, MalformedURLException, IOException, Exception {
        SDebug sDebug = this.getDb();
        sDebug.println("createNodeModel: NOT IMPLEMENTED");
        return null;
    }

    public INodeModel createNodeModel(INodeModel iNodeModel, KDebug kDebug, String string, String string2, int n) throws ClassNotFoundException, InstantiationException, IllegalAccessException, MalformedURLException, IOException, Exception {
        SDebug sDebug = this.getDb();
        if (sDebug.on()) {
            sDebug.println("createNodeModel: " + string);
        }
        ClassLoader classLoader = this.findClassLoader(string, string2);
        INodeFactory iNodeFactory = this.getNodeFactory(classLoader);
        INodeModel iNodeModel2 = iNodeFactory.createNodeModel(iNodeModel, kDebug, string, n);
        boolean bl = false;
        try {
            if (!iNodeModel2.provides(Feature.FTG)) {
                bl = true;
            }
        }
        catch (AbstractMethodError abstractMethodError) {
            bl = true;
        }
        if (bl) {
            iNodeModel2 = (INodeModel)this.InvokeFTGCtor("cerent.cms.model.ftg.OldNodeModelDelegateAdapter", iNodeModel2, INodeModel.class);
        }
        return iNodeModel2;
    }

    public IEntityCellRenderer createEntityCellRenderer(INodeModel iNodeModel, String string) {
        INodeFactory iNodeFactory = myFactories.get(iNodeModel.loader());
        IEntityCellRenderer iEntityCellRenderer = iNodeFactory.createEntityCellRenderer(string);
        return iEntityCellRenderer;
    }

    public IEntityCellRenderer createEntityCellRenderer(IModuleModel iModuleModel) {
        return this.createEntityCellRenderer(iModuleModel.getNodeModel());
    }

    public IEntityCellRenderer createEntityCellRenderer(INodeModel iNodeModel) {
        SDebug sDebug = this.getDb();
        INodeFactory iNodeFactory = myFactories.get(iNodeModel.loader());
        IEntityCellRenderer iEntityCellRenderer = iNodeFactory.createEntityCellRenderer();
        if (!Feature.delegateProvides((INodeModel)iNodeModel, (Feature)Feature.FTG)) {
            try {
                iEntityCellRenderer = (IEntityCellRenderer)this.InvokeFTGCtor("cerent.cms.ui.ftg.OldEntityCellRendererAdapter", iEntityCellRenderer, IEntityCellRenderer.class);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                sDebug.severe("Can't create the EntityCellRendererAdapter!");
                return null;
            }
        }
        return iEntityCellRenderer;
    }

    public IEntityCellRenderer createEntityCellRenderer(IModuleModel iModuleModel, boolean bl) {
        INodeFactory iNodeFactory = myFactories.get(iModuleModel.getNodeModel().loader());
        return iNodeFactory.createEntityCellRenderer(bl);
    }

    public boolean isCardViewAvailable(IModuleModel iModuleModel) {
        INodeFactory iNodeFactory = myFactories.get(iModuleModel.getNodeModel().loader());
        return iNodeFactory.isCardViewAvailable(iModuleModel);
    }

    public String getBuildInfo(INodeModel iNodeModel) {
        ClassLoader classLoader = iNodeModel.loader();
        CachedJar cachedJar = classLoader != null ? ((CmsClassLoader)classLoader).getCachedJar() : null;
        String string = null;
        String string2 = null;
        if (cachedJar != null) {
            int n;
            string = cachedJar.getSwVersionAndDate();
            if (string != null && (n = string.indexOf(45)) != -1) {
                string = string.substring(n);
            }
            if ((string2 = cachedJar.getSwVersion()) != null) {
                string2 = BuildInfo.sanitize(string2);
            }
        }
        if (string == null || string2 == null) {
            return "Unavailable";
        }
        return string2 + " " + string;
    }

    public Image[] getIconSet(INodeModel iNodeModel) {
        INodeFactory iNodeFactory = myFactories.get(iNodeModel.loader());
        Image[] imageArray = null;
        if (iNodeFactory != null) {
            imageArray = Feature.provides((INodeModel)iNodeModel, (Feature)Feature.OCHNC_PROVISIONING) ? iNodeFactory.getIconSet(iNodeModel) : iNodeFactory.getIconSet();
        }
        return imageArray;
    }

    public String getConstString(INodeModel iNodeModel, Class clazz, int n) {
        INodeFactory iNodeFactory = myFactories.get(iNodeModel.loader());
        if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.FTG)) {
            return iNodeFactory.getConstString(iNodeModel, clazz, n);
        }
        return iNodeFactory.getConstString(clazz, n);
    }

    public void removeClassLoader(ClassLoader classLoader) throws Exception {
        myFactories.remove(classLoader);
        ClassLoaderFactory.removeClassLoader((ClassLoader)classLoader);
    }

    private static String getKey(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(";");
        stringBuffer.append("neType");
        return stringBuffer.toString();
    }

    protected ClassLoader getClassLoader(String string, String string2, String string3) throws Exception {
        boolean bl = Bootstrap.isUnifiedEle((String)string2);
        String string4 = bl ? string2 : ElementFactory.getKey(string2, string3);
        ClassLoader classLoader = (ClassLoader)versionTypeClMap.get((Object)string4);
        if (classLoader == null) {
            classLoader = this.findClassLoader(string, string3);
            versionTypeClMap.put((Object)string4, (Object)classLoader);
        }
        return classLoader;
    }

    private INodeFactory getNodeFactoryByKeys(String string, String string2, String string3) throws Exception {
        ClassLoader classLoader = this.getClassLoader(string, string2, string3);
        INodeFactory iNodeFactory = this.getNodeFactory(classLoader);
        return iNodeFactory;
    }

    protected INodeFactory getNodeFactory(ClassLoader classLoader) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        INodeFactory iNodeFactory = myFactories.get(classLoader);
        if (iNodeFactory == null) {
            Class<?> clazz = classLoader.loadClass(this.getINodeFactoryClassName());
            iNodeFactory = (INodeFactory)clazz.newInstance();
            myFactories.put(classLoader, iNodeFactory);
            if (db.on()) {
                db.println("createNodeFactory: cl=> " + classLoader + ", nf=> " + iNodeFactory);
            }
        }
        return iNodeFactory;
    }

    protected String getINodeFactoryClassName() {
        if (db.on()) {
            db.println("using cerent.cms.loader.NodeFactory");
        }
        return "cerent.cms.loader.NodeFactory";
    }

    public boolean provides(Feature feature, String string, String string2, String string3) throws Exception {
        INodeFactory iNodeFactory = this.getNodeFactoryByKeys(string, string2, string3);
        return iNodeFactory.provides(feature);
    }

    public Boolean isKnownDynamic(Feature feature, String string, String string2, String string3) throws Exception {
        INodeFactory iNodeFactory = this.getNodeFactoryByKeys(string, string2, string3);
        return iNodeFactory.isKnownDynamic(feature);
    }

    public void setDynamic(Feature feature, boolean bl, String string, String string2, String string3) throws Exception {
        INodeFactory iNodeFactory = this.getNodeFactoryByKeys(string, string2, string3);
        iNodeFactory.setDynamic(feature, bl);
    }
}

