/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.Feature;
import cerent.cms.model.ICircuitRepairManager;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NodeModel;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ocm.OhCircuitManager;
import cerent.cms.topo.Network;
import cerent.util.SDebug;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class CircuitRepairManager
implements ICircuitRepairManager {
    private static final SDebug db = new SDebug("CircuitRepairManager");
    private static CircuitRepairManager repairManager;

    public static synchronized CircuitRepairManager instance() {
        if (repairManager == null) {
            repairManager = new CircuitRepairManager();
        }
        return repairManager;
    }

    public boolean allCktsRepairable(int n, int n2) {
        if (this.getEnhancedCircuitRepairNodes(n, n2) == null) {
            if (CircuitRepairManager.dbgOn()) {
                CircuitRepairManager.debug("allCktsRepairable: Not all nodes support new functionality");
            }
            return false;
        }
        if (CircuitRepairManager.dbgOn()) {
            CircuitRepairManager.debug("allCktsRepairable: all nodes support new functionality");
        }
        return true;
    }

    public void repairCircuits(int n, int n2) throws CircuitProvError {
        if (CircuitRepairManager.dbgOn()) {
            CircuitRepairManager.debug("repairCircuits: oldNodeId = " + n + " newNodeId = " + n2);
        }
        if (n == 0 || n2 == 0) {
            throw new CircuitProvError(" Invalid Parameter ");
        }
        Set set = this.getEnhancedCircuitRepairNodes(n, n2);
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                INodeModel iNodeModel = (INodeModel)iterator.next();
                if (CircuitRepairManager.dbgOn()) {
                    CircuitRepairManager.debug("repairCircuits: Updating on node " + iNodeModel.getName());
                }
                iNodeModel.updateCircuitIds(n, n2);
            }
        } else {
            NetCircuitManager.instance().repairCircuits(n, n2);
            OhCircuitManager.instance().repairCircuits(n, n2);
        }
        ((NodeModel)Network.instance().getNodeModel(n2)).updateLocal();
    }

    private Set getEnhancedCircuitRepairNodes(int n, int n2) {
        HashSet hashSet = new HashSet();
        hashSet.addAll(NetCircuitManager.instance().getAffectedNodes(n, n2));
        hashSet.addAll(OhCircuitManager.instance().getAffectedNodes(n));
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            INodeModel iNodeModel = (INodeModel)iterator.next();
            if (iNodeModel.provides(Feature.ENHANCED_CIRCUIT_REPAIR)) continue;
            if (CircuitRepairManager.dbgOn()) {
                CircuitRepairManager.debug("getEnhancedCircuitRepairNodes: node " + iNodeModel.getName() + " does not support new functionality");
            }
            return null;
        }
        if (CircuitRepairManager.dbgOn()) {
            CircuitRepairManager.debug("getEnhancedCircuitRepairNodes: all nodes support new functionality");
        }
        return hashSet;
    }

    private static boolean dbgOn() {
        return db.on();
    }

    private static void debug(String string) {
        db.println(string);
    }
}

