/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.Attribute;
import cerent.cms.model.CircuitType;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IPortModel;
import cerent.cms.model.circuits.NetCircuitModel;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitAdminState;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ui.NetworkDefaults;
import cerent.util.SDHTDMTerminology;
import cerent.util.SDebug;
import cerent.util.SONETTDMTerminology;
import cerent.util.TDMTerminology;
import java.util.ArrayList;

public class NetAdminState
implements INetCircuitAdminState {
    public static final int NO_CHANGE = -2;
    public static final Attribute NO_CHANGE_ATTR = new Attribute("No Change", -2);
    private static final int[] cktStatusesAllowAdminStateEdit = new int[]{1, 4, 5, 6};
    private static final Attribute[] adminStateAttrsSONET = new Attribute[5];
    private static final Attribute[] adminStateAttrsSDH = new Attribute[5];
    private static final int NUMBER_OF_CIRCUITS = 0;
    private static final int IS_VCAT = 1;
    private static final int IS_MONITOR = 2;
    private static final int IS_OCHNC = 3;
    private static final int NUMBER_OF_CIRCUIT_CHARACTERISTICS = 4;

    private static boolean useSDH() {
        TDMTerminology tDMTerminology = NetworkDefaults.getCmsHostTDMTerms();
        return tDMTerminology instanceof SDHTDMTerminology;
    }

    public static Attribute[] getAdminStateAttrs() {
        if (NetAdminState.useSDH()) {
            return adminStateAttrsSDH;
        }
        return adminStateAttrsSONET;
    }

    private static boolean isVcatOrMemberCkt(INetCircuit iNetCircuit) {
        return iNetCircuit != null && (iNetCircuit.isMemberOfVcat() || iNetCircuit.getCircuitTypeObj().isVcatCircuitType());
    }

    private static void characterizeCircuits(INetCircuit[] iNetCircuitArray, int[] nArray) {
        if (nArray != null && iNetCircuitArray != null) {
            int n;
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = 0;
            }
            nArray[0] = iNetCircuitArray.length;
            for (n = 0; n < nArray[0]; ++n) {
                if (NetAdminState.isVcatOrMemberCkt(iNetCircuitArray[n])) {
                    SDebug.root.fine("Its a vcat");
                    nArray[1] = nArray[1] + 1;
                }
                if (iNetCircuitArray[n].isMonitorCircuit()) {
                    SDebug.root.fine("Its a monitor");
                    nArray[2] = nArray[2] + 1;
                }
                if (!CircuitType.getCircuitType((int)iNetCircuitArray[n].getCircuitType()).isOchncType()) continue;
                SDebug.root.fine("Its an OCHNC");
                nArray[3] = nArray[3] + 1;
            }
        }
    }

    private static Attribute[] buildAttributes(int[] nArray, boolean bl) {
        Attribute[] attributeArray = NetAdminState.getAdminStateAttrs();
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        for (int i = 0; i < attributeArray.length; ++i) {
            int n = attributeArray[i].getIntValue();
            if (n == 4) {
                if (nArray[1] == 0 || nArray[1] != nArray[0]) {
                    SDebug.root.fine("Excluding OOG");
                    continue;
                }
                if (nArray[3] > 0) {
                    SDebug.root.fine("Excluding OOG");
                    continue;
                }
            } else if (n == 3) {
                if (nArray[2] > 0) {
                    SDebug.root.fine("Excluding IS_AINS");
                    continue;
                }
            } else if (n == 1) {
                if (nArray[2] > 0) {
                    SDebug.root.fine("Excluding OOS_DSBLD");
                    continue;
                }
            } else if (n == 0) {
                if (nArray[3] > 0) {
                    SDebug.root.fine("Excluding IS");
                    continue;
                }
            } else if (n == 2 && nArray[3] > 0) {
                SDebug.root.fine("Excluding OOS_MT");
                continue;
            }
            arrayList.add(attributeArray[i]);
        }
        if (bl) {
            SDebug.root.fine("Including NO_CHANGE");
            arrayList.add(NO_CHANGE_ATTR);
        }
        return arrayList.toArray(new Attribute[0]);
    }

    public static Attribute[] getAdminStateAttrs(INetCircuit[] iNetCircuitArray, boolean bl) {
        SDebug.root.info("getAdminStateAttrs: " + iNetCircuitArray.length + " " + bl);
        int[] nArray = new int[4];
        NetAdminState.characterizeCircuits(iNetCircuitArray, nArray);
        return NetAdminState.buildAttributes(nArray, bl);
    }

    public static Attribute[] getAdminStateAttrs(INetCircuit iNetCircuit, boolean bl) {
        SDebug.root.info("getAdminStateAttrs: " + iNetCircuit.getCircuitName() + " " + bl);
        INetCircuit[] iNetCircuitArray = new INetCircuit[]{iNetCircuit};
        return NetAdminState.getAdminStateAttrs(iNetCircuitArray, bl);
    }

    public static Attribute[] getAdminStateAttrs(boolean bl) {
        SDebug.root.info("getAdminStateAttrs: " + bl);
        int[] nArray = new int[4];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = 0;
        }
        nArray[0] = 1;
        return NetAdminState.buildAttributes(nArray, bl);
    }

    public static Attribute[] getAdminStateAttrs(ICircuitType iCircuitType, boolean bl) {
        SDebug.root.info("getAdminStateAttrs: " + iCircuitType + " " + bl);
        int[] nArray = new int[4];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = 0;
        }
        nArray[0] = 1;
        if (iCircuitType.isVcatCircuitType()) {
            nArray[1] = nArray[1] + 1;
        }
        if (iCircuitType.isOchncType()) {
            nArray[3] = nArray[3] + 1;
        }
        return NetAdminState.buildAttributes(nArray, bl);
    }

    public static String getAdminStateStringFromAdminState(int n) {
        Attribute[] attributeArray = NetAdminState.getAdminStateAttrs();
        String string = null;
        for (int i = 0; string == null && i < attributeArray.length; ++i) {
            if (attributeArray[i].getIntValue() != n) continue;
            string = attributeArray[i].toString();
        }
        return string == null ? "UNKNOWN" : string;
    }

    public static int[] circuitStatusesAllowsAdminStateEdit() {
        return cktStatusesAllowAdminStateEdit;
    }

    public static boolean circuitStatusAllowsAdminStateToBeEdited(int n) {
        for (int i = 0; i < cktStatusesAllowAdminStateEdit.length; ++i) {
            if (n != cktStatusesAllowAdminStateEdit[i]) continue;
            return true;
        }
        return false;
    }

    private static boolean isVlanCapable(INetCircuit iNetCircuit) {
        boolean bl = true;
        try {
            bl = iNetCircuit.isVlanCapable();
        }
        catch (IncorrectCircuitState incorrectCircuitState) {
            SDebug.root.severe("isVlanCapable(): " + incorrectCircuitState.toString());
        }
        return bl;
    }

    private static boolean sourceAndDropDisallowESM(INetCircuit iNetCircuit) {
        int n = 0;
        IPortModel[] iPortModelArray = NetCircuitModel.getEndpoints(iNetCircuit);
        if (iPortModelArray != null && iPortModelArray.length > 0) {
            for (int i = 0; i < iPortModelArray.length; ++i) {
                int n2 = iPortModelArray[i].getEqType();
                int n3 = iPortModelArray[i].getModuleModel().getEqType();
                if (n2 != 105 && (n2 != 165 || n3 != 164) && n3 != 248) continue;
                ++n;
            }
        }
        return iPortModelArray != null && n > 0 && n == iPortModelArray.length;
    }

    public static boolean circuitAllowsStateApplicationToDrops(INetCircuit iNetCircuit) {
        boolean bl = true;
        if (iNetCircuit.getCircuitTypeObj().isTunnelCircuitType() || iNetCircuit.getCircuitTypeObj().isOchncType() || NetAdminState.isVlanCapable(iNetCircuit) || NetAdminState.sourceAndDropDisallowESM(iNetCircuit)) {
            bl = false;
        }
        return bl;
    }

    public static boolean isFormOfIS(int n) {
        switch (n) {
            case 0: {
                return true;
            }
        }
        return false;
    }

    public static boolean isFormOfOOS(int n) {
        switch (n) {
            case 0: {
                return false;
            }
        }
        return true;
    }

    static {
        SONETTDMTerminology sONETTDMTerminology = SONETTDMTerminology.instance();
        NetAdminState.adminStateAttrsSONET[0] = new Attribute(sONETTDMTerminology.getTermForAdminState(1), 1);
        NetAdminState.adminStateAttrsSONET[1] = new Attribute(sONETTDMTerminology.getTermForAdminState(0), 0);
        NetAdminState.adminStateAttrsSONET[2] = new Attribute(sONETTDMTerminology.getTermForAdminState(3), 3);
        NetAdminState.adminStateAttrsSONET[3] = new Attribute(sONETTDMTerminology.getTermForAdminState(2), 2);
        NetAdminState.adminStateAttrsSONET[4] = new Attribute(sONETTDMTerminology.getTermForAdminState(4), 4);
        sONETTDMTerminology = SDHTDMTerminology.instance();
        NetAdminState.adminStateAttrsSDH[0] = new Attribute(sONETTDMTerminology.getTermForAdminState(1), 1);
        NetAdminState.adminStateAttrsSDH[1] = new Attribute(sONETTDMTerminology.getTermForAdminState(0), 0);
        NetAdminState.adminStateAttrsSDH[2] = new Attribute(sONETTDMTerminology.getTermForAdminState(3), 3);
        NetAdminState.adminStateAttrsSDH[3] = new Attribute(sONETTDMTerminology.getTermForAdminState(2), 2);
        NetAdminState.adminStateAttrsSDH[4] = new Attribute(sONETTDMTerminology.getTermForAdminState(4), 4);
    }
}

