/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.INetProtectionType;
import cerent.util.AbstractEnumBehavior;
import cerent.util.TDMTerminology;

public class NetProtectionType
extends AbstractEnumBehavior
implements INetProtectionType {
    protected static AbstractEnumBehavior.EnumRange Range = new AbstractEnumBehavior.EnumRange(NetProtectionType.class);
    protected int terminologyIndex;
    public static int UNDEFINED_TERM_INDEX = -1;
    protected static NetProtectionType[] NetProtectionTypes = new NetProtectionType[Range.getNumTypes()];
    public static final NetProtectionType BLSR2F = new NetProtectionType(0, "2F-", false, 1);
    public static final NetProtectionType ONE_PLUS_ONE = new NetProtectionType(1, "1+1", false, UNDEFINED_TERM_INDEX);
    public static final NetProtectionType LOT = new NetProtectionType(2, "LOT", false, UNDEFINED_TERM_INDEX);
    public static final NetProtectionType UNPROTECTED = new NetProtectionType(3, "Unprot", false, UNDEFINED_TERM_INDEX);
    public static final NetProtectionType BLSR4F = new NetProtectionType(4, "4F-", false, 1);
    public static final NetProtectionType PCA2F = new NetProtectionType(5, "2F-PCA", true, UNDEFINED_TERM_INDEX);
    public static final NetProtectionType PCA4F = new NetProtectionType(6, "4F-PCA", true, UNDEFINED_TERM_INDEX);
    public static final NetProtectionType YCABLE = new NetProtectionType(7, "Y-CABLE", false, UNDEFINED_TERM_INDEX);
    public static final NetProtectionType SPLITTER = new NetProtectionType(8, "SPLITTER", false, UNDEFINED_TERM_INDEX);
    public static final NetProtectionType DONT_USE_0 = new NetProtectionType(9, "???", false, UNDEFINED_TERM_INDEX);
    public static final NetProtectionType PROTECTED = new NetProtectionType(10, "Protected", false, UNDEFINED_TERM_INDEX);
    public static final NetProtectionType BLSR = new NetProtectionType(11, "", false, 1);
    public static final NetProtectionType UPSR = new NetProtectionType(12, "", false, 0);
    public static final NetProtectionType PCA = new NetProtectionType(13, "PCA", true, UNDEFINED_TERM_INDEX);
    public static final NetProtectionType LOST = new NetProtectionType(14, "Unprot", false, UNDEFINED_TERM_INDEX);
    public static final NetProtectionType UNKNOWN = new NetProtectionType(15, "Unknown", false, UNDEFINED_TERM_INDEX);
    public static final NetProtectionType NONE = new NetProtectionType(16, "N/A", false, UNDEFINED_TERM_INDEX);
    public static final NetProtectionType DRI = new NetProtectionType(17, "DRI", false, UNDEFINED_TERM_INDEX);
    public static final NetProtectionType DONT_USE_1 = new NetProtectionType(18, "???", false, UNDEFINED_TERM_INDEX);
    protected final int protType;
    protected final String displayStr;
    protected final boolean isPca;
    protected final boolean prefixTerminology;

    protected static boolean CheckType(int n, boolean bl) {
        boolean bl2 = NetProtectionType._CheckType((int)n, (AbstractEnumBehavior.EnumRange)Range);
        if (!bl && !bl2) {
            throw new IllegalArgumentException("net prot type: " + n + " value is Illegal");
        }
        return bl2;
    }

    public static boolean isProtectedType(int n) {
        return n == 12 || n == 17 || n == 0 || n == 4 || n == 11 || n == 1 || n == 10 || n == 8;
    }

    public static boolean isUnprotectedType(int n) {
        return n == 3 || n == 7 || n == 5 || n == 6 || n == 13;
    }

    public static boolean isBlsrType(int n) {
        return n == 0 || n == 4 || n == 11;
    }

    public static boolean isPcaType(int n) {
        return n == 5 || n == 6 || n == 13;
    }

    protected NetProtectionType(int n, String string, boolean bl, int n2) {
        this(n, string, bl, n2, false);
    }

    protected NetProtectionType(int n, String string, boolean bl, int n2, boolean bl2) {
        super((Object)NetProtectionTypes, n);
        this.protType = n;
        this.displayStr = string;
        this.isPca = bl;
        this.terminologyIndex = n2;
        this.prefixTerminology = bl2;
        NetProtectionType.NetProtectionTypes[n] = this;
    }

    public boolean isPca() {
        return this.isPca;
    }

    public String getNetProtectionTypeString(TDMTerminology tDMTerminology) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.prefixTerminology) {
            stringBuffer.append(this.displayStr);
            if (this.terminologyIndex != UNDEFINED_TERM_INDEX) {
                stringBuffer.append(tDMTerminology.getRingTerms(this.terminologyIndex));
            }
        } else {
            if (this.terminologyIndex != UNDEFINED_TERM_INDEX) {
                stringBuffer.append(tDMTerminology.getRingTerms(this.terminologyIndex));
            }
            stringBuffer.append(this.displayStr);
        }
        return stringBuffer.toString();
    }

    public static INetProtectionType getNetProtectionType(int n, boolean bl) {
        boolean bl2 = NetProtectionType.CheckType(n, bl);
        return bl2 ? NetProtectionTypes[n] : null;
    }

    public static INetProtectionType getNetProtectionType(int n) {
        return NetProtectionType.getNetProtectionType(n, false);
    }

    public static INetProtectionType[] getAllNetProtectionTypes() {
        return NetProtectionTypes;
    }

    public String toString() {
        return this.displayStr;
    }
}

