/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.AbstractCmsCommFailException;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.Feature;
import cerent.cms.model.IActiveUserInfoModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ISecurityModel;
import cerent.cms.model.ISecurityPolicy;
import cerent.cms.model.IUserInfoModel;
import cerent.cms.model.InvalidParams;
import cerent.cms.model.InvalidRange;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.NodeModel;
import cerent.cms.model.SecurityActiveUserSession;
import cerent.cms.model.SecurityBadMinPwdDiff;
import cerent.cms.model.SecurityBadPassword;
import cerent.cms.model.SecurityBadPasswordFlipping;
import cerent.cms.model.SecurityBadPasswordToggling;
import cerent.cms.model.SecurityExistingUser;
import cerent.cms.model.SecurityKeepOneSuperUser;
import cerent.cms.model.SecurityMaximumUsers;
import cerent.cms.model.SecurityNotAuthenticated;
import cerent.cms.model.SecurityNotAuthorized;
import cerent.cms.model.SecurityPolicy;
import cerent.cms.model.SecurityUnknownUser;
import cerent.cms.model.SecurityUserNotLoggedIn;
import cerent.cms.model.SessionNotFound;
import cerent.cms.model.vf.AbstractVersionedFeature;
import cerent.cms.model.vf.SecurityVersionedFeature;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.NetElement;
import cerent.cms.topo.Network;
import cerent.util.EID;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.KEMC;
import cerent.util.KErrorMsg;
import cerent.util.SDebug;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class NetSecurityModel
extends CmsObservable
implements IObserver {
    private static final String MSG_INVALID_PASSWORD = "New password must be different than the old password";
    private static final int DEFAULT_ALLOWED_UNLOCK_ATTEMPTS = 5;
    private String userName;
    private String password;
    private SecurityVersionedFeature securityVersion;
    private static NetSecurityModel instance = null;
    private static final SDebug db = new SDebug("NetSecurityModel");

    public static final synchronized NetSecurityModel instance() {
        if (instance == null) {
            instance = new NetSecurityModel();
        }
        return instance;
    }

    private static String defaultFailureMessage(Exception exception) {
        String string = exception.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string = string.substring(n + 1);
        }
        return string + "\n" + exception.getMessage();
    }

    public static String exceptionToStatusString(Exception exception) {
        String string = "Succeeded";
        if (exception != null) {
            string = "Operation failed: ";
            string = exception instanceof InvalidParams ? string + exception.getMessage() : (exception instanceof SecurityExistingUser ? string + "User already exists" : (exception instanceof SecurityNotAuthorized ? string + "Not authorized" : (exception instanceof SecurityNotAuthenticated ? string + "Password authentication fails" : (exception instanceof SecurityMaximumUsers ? string + exception.getMessage() : (exception instanceof SecurityUnknownUser ? string + "Unknown user" : (exception instanceof SecurityKeepOneSuperUser ? string + "System requires at least one Super user" : (exception instanceof SecurityBadPassword ? string + KErrorMsg.getString((EID)KEMC.EID_PASSWORD_TOO_SIMPLE) : (exception instanceof SecurityBadMinPwdDiff ? string + "New password fails to meet the minimum required number of different characters policy" : (exception instanceof SecurityActiveUserSession ? string + "Currently in use" : (exception instanceof SecurityBadPasswordFlipping ? string + "Current password fails to meet the required waiting period" : (exception instanceof SecurityBadPasswordToggling ? string + MSG_INVALID_PASSWORD : (exception instanceof UnsupportedOperationException ? string + "Node does not support this operation" : (exception instanceof AbstractCmsCommFailException ? (exception.getMessage().indexOf("No Permission") != -1 ? string + "Not authorized" : (exception.getMessage().indexOf("not initialized") != -1 ? string + "Not ready" : string + NetSecurityModel.defaultFailureMessage(exception))) : string + NetSecurityModel.defaultFailureMessage(exception))))))))))))));
        }
        return string;
    }

    public static boolean hasFailures(Map map) {
        if (map != null) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Exception exception = (Exception)entry.getValue();
                if (exception == null) continue;
                return true;
            }
        }
        return false;
    }

    public static void formatFailedMap(StringBuffer stringBuffer, Map map) {
        Exception exception;
        Map.Entry entry;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            exception = (Exception)entry.getValue();
            if (exception == null) continue;
            if (entry.getKey() instanceof NodeModel) {
                stringBuffer.append(((NodeModel)entry.getKey()).getName() + " - " + NetSecurityModel.exceptionToStatusString((Exception)entry.getValue()) + ".\n");
                continue;
            }
            if (!(entry.getKey() instanceof String)) continue;
            stringBuffer.append((String)entry.getKey() + " - " + NetSecurityModel.exceptionToStatusString((Exception)entry.getValue()) + ".\n");
        }
        iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            exception = (Exception)entry.getValue();
            if (exception != null) continue;
            if (entry.getKey() instanceof NodeModel) {
                stringBuffer.append(((NodeModel)entry.getKey()).getName() + " - " + NetSecurityModel.exceptionToStatusString((Exception)entry.getValue()) + ".\n");
                continue;
            }
            if (!(entry.getKey() instanceof String)) continue;
            stringBuffer.append((String)entry.getKey() + " - " + NetSecurityModel.exceptionToStatusString((Exception)entry.getValue()) + ".\n");
        }
    }

    public Map createUser(String string, String string2, int n, List list) {
        HashMap<NodeModel, Throwable> hashMap = new HashMap<NodeModel, Throwable>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NodeModel nodeModel = (NodeModel)iterator.next();
            try {
                ISecurityModel iSecurityModel = nodeModel.getSecurityModel();
                try {
                    iSecurityModel.createUser(string, string2, n);
                    hashMap.put(nodeModel, null);
                }
                catch (SecurityExistingUser securityExistingUser) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)securityExistingUser);
                    }
                    hashMap.put(nodeModel, securityExistingUser);
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)abstractCmsIOException);
                    }
                    hashMap.put(nodeModel, abstractCmsIOException);
                }
                catch (SecurityNotAuthorized securityNotAuthorized) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)securityNotAuthorized);
                    }
                    hashMap.put(nodeModel, securityNotAuthorized);
                }
                catch (SecurityMaximumUsers securityMaximumUsers) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)securityMaximumUsers);
                    }
                    hashMap.put(nodeModel, securityMaximumUsers);
                }
                catch (SecurityBadPassword securityBadPassword) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)securityBadPassword);
                    }
                    hashMap.put(nodeModel, securityBadPassword);
                }
            }
            catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                SDebug.printStackTrace((Throwable)abstractCmsCommFailException);
                hashMap.put(nodeModel, abstractCmsCommFailException);
            }
        }
        return hashMap;
    }

    private void logoutBeforeDelete(NodeModel nodeModel, ISecurityModel iSecurityModel, String string) {
        try {
            IActiveUserInfoModel[] iActiveUserInfoModelArray = iSecurityModel.getActiveUsers();
            for (int i = 0; i < iActiveUserInfoModelArray.length; ++i) {
                if (!string.equals(iActiveUserInfoModelArray[i].getUserId())) continue;
                try {
                    if (nodeModel.provides(Feature.SECURITY_VERSIONING)) {
                        iSecurityModel.logoutSession(iActiveUserInfoModelArray[i].getSessionTicket(), false);
                        continue;
                    }
                    if (!nodeModel.provides(Feature.SECURITY_USER_STATUS)) continue;
                    iSecurityModel.logoutUser(iActiveUserInfoModelArray[i].getUserId(), iActiveUserInfoModelArray[i].getClientIpAddress(), false);
                    continue;
                }
                catch (SecurityUnknownUser securityUnknownUser) {
                    db.println("lbd:logoutUser(" + nodeModel.getHostName() + ") failed: " + (Object)((Object)securityUnknownUser));
                    continue;
                }
                catch (SecurityKeepOneSuperUser securityKeepOneSuperUser) {
                    db.println("lbd:logoutUser(" + nodeModel.getHostName() + ") failed: " + (Object)((Object)securityKeepOneSuperUser));
                    continue;
                }
                catch (SecurityUserNotLoggedIn securityUserNotLoggedIn) {
                    db.println("lbd:logoutUser(" + nodeModel.getHostName() + ") failed: " + (Object)((Object)securityUserNotLoggedIn));
                    continue;
                }
                catch (SessionNotFound sessionNotFound) {
                    db.println("lbd:logoutSession(" + nodeModel.getHostName() + ") failed: " + (Object)((Object)sessionNotFound));
                    continue;
                }
                catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                    db.println("lbd:logoutUser(" + nodeModel.getHostName() + ") failed: " + (Object)((Object)abstractCmsCommFailException));
                }
            }
        }
        catch (AbstractCmsCommFailException abstractCmsCommFailException) {
            db.println("lbd:getActiveUsers(" + nodeModel.getHostName() + ") failed: " + (Object)((Object)abstractCmsCommFailException));
        }
    }

    public Map deleteUser(String string, boolean bl, List list) {
        HashMap<NodeModel, Throwable> hashMap = new HashMap<NodeModel, Throwable>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                NodeModel nodeModel = (NodeModel)iterator.next();
                ISecurityModel iSecurityModel = nodeModel.getSecurityModel();
                try {
                    if (bl) {
                        this.logoutBeforeDelete(nodeModel, iSecurityModel, string);
                    }
                    iSecurityModel.deleteUser(string);
                    hashMap.put(nodeModel, null);
                }
                catch (SecurityNotAuthorized securityNotAuthorized) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)securityNotAuthorized);
                    }
                    hashMap.put(nodeModel, securityNotAuthorized);
                }
                catch (SecurityUnknownUser securityUnknownUser) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)securityUnknownUser);
                    }
                    hashMap.put(nodeModel, securityUnknownUser);
                }
                catch (SecurityActiveUserSession securityActiveUserSession) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)securityActiveUserSession);
                    }
                    hashMap.put(nodeModel, securityActiveUserSession);
                }
                catch (SecurityKeepOneSuperUser securityKeepOneSuperUser) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)securityKeepOneSuperUser);
                    }
                    hashMap.put(nodeModel, securityKeepOneSuperUser);
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)abstractCmsIOException);
                    }
                    hashMap.put(nodeModel, abstractCmsIOException);
                }
            }
            catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                SDebug.printStackTrace((Throwable)abstractCmsCommFailException);
            }
        }
        return hashMap;
    }

    public Map clearSecurityIntrusionAlarm(List list) {
        HashMap<NodeModel, AbstractCmsIOException> hashMap = new HashMap<NodeModel, AbstractCmsIOException>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                NodeModel nodeModel = (NodeModel)iterator.next();
                ISecurityModel iSecurityModel = nodeModel.getSecurityModel();
                if (!nodeModel.provides(Feature.SEC_CLR_VIOLATION_ALM)) continue;
                try {
                    iSecurityModel.clearSecurityViolationAlarm();
                    hashMap.put(nodeModel, null);
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)abstractCmsIOException);
                    }
                    hashMap.put(nodeModel, abstractCmsIOException);
                }
            }
            catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                SDebug.printStackTrace((Throwable)abstractCmsCommFailException);
            }
        }
        return hashMap;
    }

    public Map setUserPassword(String string, String string2, List list) {
        HashMap<NodeModel, Throwable> hashMap = new HashMap<NodeModel, Throwable>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                NodeModel nodeModel = (NodeModel)iterator.next();
                ISecurityModel iSecurityModel = nodeModel.getSecurityModel();
                try {
                    iSecurityModel.setUserPassword(string, string2);
                    hashMap.put(nodeModel, null);
                }
                catch (SecurityNotAuthorized securityNotAuthorized) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)securityNotAuthorized);
                    }
                    hashMap.put(nodeModel, securityNotAuthorized);
                }
                catch (SecurityUnknownUser securityUnknownUser) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)securityUnknownUser);
                    }
                    hashMap.put(nodeModel, securityUnknownUser);
                }
                catch (SecurityBadPassword securityBadPassword) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)securityBadPassword);
                    }
                    hashMap.put(nodeModel, securityBadPassword);
                }
                catch (SecurityBadPasswordFlipping securityBadPasswordFlipping) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)securityBadPasswordFlipping);
                    }
                    hashMap.put(nodeModel, securityBadPasswordFlipping);
                }
                catch (SecurityBadPasswordToggling securityBadPasswordToggling) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)securityBadPasswordToggling);
                    }
                    hashMap.put(nodeModel, securityBadPasswordToggling);
                }
                catch (SecurityActiveUserSession securityActiveUserSession) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)securityActiveUserSession);
                    }
                    hashMap.put(nodeModel, securityActiveUserSession);
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)abstractCmsIOException);
                    }
                    hashMap.put(nodeModel, abstractCmsIOException);
                }
            }
            catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                SDebug.printStackTrace((Throwable)abstractCmsCommFailException);
            }
        }
        return hashMap;
    }

    public Map setUserSecurityLevel(String string, int n, List list) {
        HashMap<NodeModel, Throwable> hashMap = new HashMap<NodeModel, Throwable>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                NodeModel nodeModel = (NodeModel)iterator.next();
                ISecurityModel iSecurityModel = nodeModel.getSecurityModel();
                try {
                    iSecurityModel.setUserSecurityLevel(string, n);
                    hashMap.put(nodeModel, null);
                }
                catch (SecurityNotAuthorized securityNotAuthorized) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)securityNotAuthorized);
                    }
                    hashMap.put(nodeModel, securityNotAuthorized);
                }
                catch (SecurityUnknownUser securityUnknownUser) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)securityUnknownUser);
                    }
                    hashMap.put(nodeModel, securityUnknownUser);
                }
                catch (SecurityKeepOneSuperUser securityKeepOneSuperUser) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)securityKeepOneSuperUser);
                    }
                    hashMap.put(nodeModel, securityKeepOneSuperUser);
                }
                catch (SecurityActiveUserSession securityActiveUserSession) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)securityActiveUserSession);
                    }
                    hashMap.put(nodeModel, securityActiveUserSession);
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)abstractCmsIOException);
                    }
                    hashMap.put(nodeModel, abstractCmsIOException);
                }
            }
            catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                SDebug.printStackTrace((Throwable)abstractCmsCommFailException);
            }
        }
        return hashMap;
    }

    public Map changePassword(String string, String string2, String string3, List list) {
        HashMap<NodeModel, Throwable> hashMap = new HashMap<NodeModel, Throwable>();
        boolean bl = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                NodeModel nodeModel = (NodeModel)iterator.next();
                ISecurityModel iSecurityModel = nodeModel.getSecurityModel();
                try {
                    iSecurityModel.changePassword(string, string2, string3);
                    if (string.equals(nodeModel.getUserName())) {
                        nodeModel.setUserPassword(string3);
                        INodeModel iNodeModel = NetworkModel.instance().getCmsHostModel();
                        if (nodeModel.getHostName().equals(iNodeModel.getHostName())) {
                            bl = true;
                        }
                    }
                    hashMap.put(nodeModel, null);
                }
                catch (SecurityNotAuthorized securityNotAuthorized) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)securityNotAuthorized);
                    }
                    hashMap.put(nodeModel, securityNotAuthorized);
                }
                catch (SecurityNotAuthenticated securityNotAuthenticated) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)securityNotAuthenticated);
                    }
                    hashMap.put(nodeModel, securityNotAuthenticated);
                }
                catch (SecurityUnknownUser securityUnknownUser) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)securityUnknownUser);
                    }
                    hashMap.put(nodeModel, securityUnknownUser);
                }
                catch (SecurityBadMinPwdDiff securityBadMinPwdDiff) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)securityBadMinPwdDiff);
                    }
                    hashMap.put(nodeModel, securityBadMinPwdDiff);
                }
                catch (SecurityBadPassword securityBadPassword) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)securityBadPassword);
                    }
                    hashMap.put(nodeModel, securityBadPassword);
                }
                catch (SecurityBadPasswordFlipping securityBadPasswordFlipping) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)securityBadPasswordFlipping);
                    }
                    hashMap.put(nodeModel, securityBadPasswordFlipping);
                }
                catch (SecurityBadPasswordToggling securityBadPasswordToggling) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)securityBadPasswordToggling);
                    }
                    hashMap.put(nodeModel, securityBadPasswordToggling);
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)abstractCmsIOException);
                    }
                    hashMap.put(nodeModel, abstractCmsIOException);
                }
                catch (SecurityActiveUserSession securityActiveUserSession) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)securityActiveUserSession);
                    }
                    hashMap.put(nodeModel, securityActiveUserSession);
                }
            }
            catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                SDebug.printStackTrace((Throwable)abstractCmsCommFailException);
            }
        }
        if (bl) {
            this.setPassword(string3);
        }
        return hashMap;
    }

    public IUserInfoModel[] getUsers(List list) {
        if (db.on()) {
            db.println("getUsers( " + list + " )");
        }
        TreeSet<IUserInfoModel> treeSet = new TreeSet<IUserInfoModel>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                NodeModel nodeModel = (NodeModel)iterator.next();
                ISecurityModel iSecurityModel = nodeModel.getSecurityModel();
                if (nodeModel.provides(Feature.SEC_GET_USERS)) {
                    try {
                        IUserInfoModel[] iUserInfoModelArray = iSecurityModel.getUsers();
                        for (int i = 0; i < iUserInfoModelArray.length; ++i) {
                            IUserInfoModel iUserInfoModel = iUserInfoModelArray[i];
                            if (db.on()) {
                                db.println("\tAdding user " + iUserInfoModel);
                            }
                            treeSet.add(iUserInfoModel);
                        }
                        continue;
                    }
                    catch (AbstractCmsIOException abstractCmsIOException) {
                        if (db.on()) {
                            db.println("exception occurred during getUsers");
                        }
                        SDebug.printStackTrace((Throwable)abstractCmsIOException);
                        continue;
                    }
                }
                if (!db.on()) continue;
                db.println("\tNode " + nodeModel.getName() + " doesn't support getUsers.");
            }
            catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                SDebug.printStackTrace((Throwable)abstractCmsCommFailException);
            }
        }
        return treeSet.toArray(new IUserInfoModel[0]);
    }

    public Map adminLockUsername(String string, List list) {
        HashMap<NodeModel, Throwable> hashMap = new HashMap<NodeModel, Throwable>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NodeModel nodeModel = (NodeModel)iterator.next();
            try {
                if (nodeModel.provides(Feature.SECURITY_USER_STATUS)) {
                    ISecurityModel iSecurityModel = nodeModel.getSecurityModel();
                    try {
                        iSecurityModel.adminLockUsername(string);
                        hashMap.put(nodeModel, null);
                    }
                    catch (SecurityKeepOneSuperUser securityKeepOneSuperUser) {
                        if (db.on()) {
                            SDebug.printStackTrace((Throwable)securityKeepOneSuperUser);
                        }
                        hashMap.put(nodeModel, securityKeepOneSuperUser);
                    }
                    catch (SecurityUnknownUser securityUnknownUser) {
                        if (db.on()) {
                            SDebug.printStackTrace((Throwable)securityUnknownUser);
                        }
                        hashMap.put(nodeModel, securityUnknownUser);
                    }
                    catch (SecurityActiveUserSession securityActiveUserSession) {
                        if (db.on()) {
                            SDebug.printStackTrace((Throwable)securityActiveUserSession);
                        }
                        hashMap.put(nodeModel, securityActiveUserSession);
                    }
                    catch (AbstractCmsIOException abstractCmsIOException) {
                        if (db.on()) {
                            SDebug.printStackTrace((Throwable)abstractCmsIOException);
                        }
                        hashMap.put(nodeModel, abstractCmsIOException);
                    }
                    continue;
                }
                hashMap.put(nodeModel, new UnsupportedOperationException());
            }
            catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                hashMap.put(nodeModel, abstractCmsCommFailException);
            }
        }
        return hashMap;
    }

    public Map adminUnlockUsername(String string, List list) {
        HashMap<NodeModel, Throwable> hashMap = new HashMap<NodeModel, Throwable>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NodeModel nodeModel = (NodeModel)iterator.next();
            try {
                if (nodeModel.provides(Feature.SECURITY_USER_STATUS)) {
                    ISecurityModel iSecurityModel = nodeModel.getSecurityModel();
                    try {
                        iSecurityModel.adminUnlockUsername(string);
                        hashMap.put(nodeModel, null);
                    }
                    catch (SecurityUnknownUser securityUnknownUser) {
                        if (db.on()) {
                            SDebug.printStackTrace((Throwable)securityUnknownUser);
                        }
                        hashMap.put(nodeModel, securityUnknownUser);
                    }
                    catch (SecurityActiveUserSession securityActiveUserSession) {
                        if (db.on()) {
                            SDebug.printStackTrace((Throwable)securityActiveUserSession);
                        }
                        hashMap.put(nodeModel, securityActiveUserSession);
                    }
                    catch (AbstractCmsIOException abstractCmsIOException) {
                        if (db.on()) {
                            SDebug.printStackTrace((Throwable)abstractCmsIOException);
                        }
                        hashMap.put(nodeModel, abstractCmsIOException);
                    }
                    continue;
                }
                hashMap.put(nodeModel, new UnsupportedOperationException());
            }
            catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                hashMap.put(nodeModel, abstractCmsCommFailException);
            }
        }
        return hashMap;
    }

    public Map logout(IActiveUserInfoModel iActiveUserInfoModel, boolean bl, List list) {
        HashMap<String, Throwable> hashMap = new HashMap<String, Throwable>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                NodeModel nodeModel = (NodeModel)iterator.next();
                String string = nodeModel + ":" + iActiveUserInfoModel.getUserId();
                ISecurityModel iSecurityModel = nodeModel.getSecurityModel();
                try {
                    if (nodeModel.provides(Feature.SECURITY_VERSIONING)) {
                        iSecurityModel.logoutSession(iActiveUserInfoModel.getSessionTicket(), bl);
                        string = string + ":" + iActiveUserInfoModel.getSessionType();
                        hashMap.put(string, null);
                        continue;
                    }
                    if (nodeModel.provides(Feature.SECURITY_USER_STATUS)) {
                        iSecurityModel.logoutUser(iActiveUserInfoModel.getUserId(), iActiveUserInfoModel.getClientIpAddress(), bl);
                        hashMap.put(string, null);
                        continue;
                    }
                    hashMap.put(string, new UnsupportedOperationException());
                }
                catch (SecurityUserNotLoggedIn securityUserNotLoggedIn) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)securityUserNotLoggedIn);
                    }
                    hashMap.put(string, securityUserNotLoggedIn);
                }
                catch (SecurityUnknownUser securityUnknownUser) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)securityUnknownUser);
                    }
                    hashMap.put(string, securityUnknownUser);
                }
                catch (SecurityKeepOneSuperUser securityKeepOneSuperUser) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)securityKeepOneSuperUser);
                    }
                    hashMap.put(string, securityKeepOneSuperUser);
                }
                catch (SessionNotFound sessionNotFound) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)sessionNotFound);
                    }
                    hashMap.put(string, sessionNotFound);
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)abstractCmsIOException);
                    }
                    hashMap.put(string, abstractCmsIOException);
                }
            }
            catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                SDebug.printStackTrace((Throwable)abstractCmsCommFailException);
            }
        }
        return hashMap;
    }

    public Map setSecurityPolicy(ISecurityPolicy iSecurityPolicy, List list) {
        HashMap<NodeModel, Throwable> hashMap = new HashMap<NodeModel, Throwable>();
        Iterator iterator = list.iterator();
        int n = iSecurityPolicy.getMaxInactiveDaysBeforeDisable();
        while (iterator.hasNext()) {
            NodeModel nodeModel = (NodeModel)iterator.next();
            try {
                if (nodeModel.provides(Feature.SECURITY_POLICY)) {
                    if (nodeModel.provides(Feature.SECURITY_VERSIONING)) {
                        ((SecurityPolicy)iSecurityPolicy).setMaxInactiveDaysBeforeDisable(n);
                    } else if (nodeModel.provides(Feature.SEC_PASSWD_AGING)) {
                        if (n < 45) {
                            ((SecurityPolicy)iSecurityPolicy).setMaxInactiveDaysBeforeDisable(45);
                        } else if (n > 90) {
                            ((SecurityPolicy)iSecurityPolicy).setMaxInactiveDaysBeforeDisable(90);
                        }
                    }
                    ISecurityModel iSecurityModel = nodeModel.getSecurityModel();
                    try {
                        iSecurityModel.setSecurityPolicy(iSecurityPolicy);
                        hashMap.put(nodeModel, null);
                    }
                    catch (InvalidParams invalidParams) {
                        if (db.on()) {
                            SDebug.printStackTrace((Throwable)invalidParams);
                        }
                        hashMap.put(nodeModel, invalidParams);
                    }
                    catch (InvalidRange invalidRange) {
                        if (db.on()) {
                            SDebug.printStackTrace((Throwable)invalidRange);
                        }
                        hashMap.put(nodeModel, invalidRange);
                    }
                    catch (AbstractCmsIOException abstractCmsIOException) {
                        if (db.on()) {
                            SDebug.printStackTrace((Throwable)abstractCmsIOException);
                        }
                        hashMap.put(nodeModel, abstractCmsIOException);
                    }
                    continue;
                }
                hashMap.put(nodeModel, new UnsupportedOperationException());
            }
            catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                hashMap.put(nodeModel, abstractCmsCommFailException);
            }
        }
        ((SecurityPolicy)iSecurityPolicy).setMaxInactiveDaysBeforeDisable(n);
        return hashMap;
    }

    public Map setUserDisabled(String string, boolean bl, List list) {
        HashMap<NodeModel, Throwable> hashMap = new HashMap<NodeModel, Throwable>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NodeModel nodeModel = (NodeModel)iterator.next();
            try {
                if (nodeModel.provides(Feature.SEC_DISABLE_USERID)) {
                    ISecurityModel iSecurityModel = nodeModel.getSecurityModel();
                    try {
                        iSecurityModel.setUserDisabled(string, bl);
                        hashMap.put(nodeModel, null);
                    }
                    catch (SecurityUnknownUser securityUnknownUser) {
                        if (db.on()) {
                            SDebug.printStackTrace((Throwable)securityUnknownUser);
                        }
                        hashMap.put(nodeModel, securityUnknownUser);
                    }
                    catch (SecurityActiveUserSession securityActiveUserSession) {
                        if (db.on()) {
                            SDebug.printStackTrace((Throwable)securityActiveUserSession);
                        }
                        hashMap.put(nodeModel, securityActiveUserSession);
                    }
                    catch (AbstractCmsIOException abstractCmsIOException) {
                        if (db.on()) {
                            SDebug.printStackTrace((Throwable)abstractCmsIOException);
                        }
                        hashMap.put(nodeModel, abstractCmsIOException);
                    }
                    continue;
                }
                hashMap.put(nodeModel, new UnsupportedOperationException());
            }
            catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                hashMap.put(nodeModel, abstractCmsCommFailException);
            }
        }
        return hashMap;
    }

    public Map setUserForcePasswordChange(String string, boolean bl, List list) {
        HashMap<NodeModel, Throwable> hashMap = new HashMap<NodeModel, Throwable>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NodeModel nodeModel = (NodeModel)iterator.next();
            try {
                if (nodeModel.provides(Feature.SEC_FORCE_PASSWD_CHANGE)) {
                    ISecurityModel iSecurityModel = nodeModel.getSecurityModel();
                    try {
                        iSecurityModel.setUserForcePasswordChange(string, bl);
                        hashMap.put(nodeModel, null);
                    }
                    catch (SecurityUnknownUser securityUnknownUser) {
                        if (db.on()) {
                            SDebug.printStackTrace((Throwable)securityUnknownUser);
                        }
                        hashMap.put(nodeModel, securityUnknownUser);
                    }
                    catch (SecurityActiveUserSession securityActiveUserSession) {
                        if (db.on()) {
                            SDebug.printStackTrace((Throwable)securityActiveUserSession);
                        }
                        hashMap.put(nodeModel, securityActiveUserSession);
                    }
                    catch (AbstractCmsIOException abstractCmsIOException) {
                        if (db.on()) {
                            SDebug.printStackTrace((Throwable)abstractCmsIOException);
                        }
                        hashMap.put(nodeModel, abstractCmsIOException);
                    }
                    continue;
                }
                hashMap.put(nodeModel, new UnsupportedOperationException());
            }
            catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                hashMap.put(nodeModel, abstractCmsCommFailException);
            }
        }
        return hashMap;
    }

    public AbstractVersionedFeature getSecurityVersion() {
        return this.securityVersion;
    }

    private void observe(NodeModel nodeModel) {
        block13: {
            try {
                NodeModel.ConnectionNotifier connectionNotifier = (NodeModel.ConnectionNotifier)nodeModel.getConnectionNotifier();
                if (connectionNotifier != null) {
                    if (db.on()) {
                        db.println("observe: cn: " + nodeModel.getHostName());
                    }
                    connectionNotifier.addObserver(this);
                } else if (db.on()) {
                    db.println("observe: no cn: " + nodeModel.getHostName());
                }
                if (nodeModel.isInited() && nodeModel.getConnectionState()) {
                    ISecurityModel iSecurityModel = nodeModel.getSecurityModel();
                    if (iSecurityModel != null) {
                        if (db.on()) {
                            db.println("observe NetSecurityModel: " + nodeModel.getHostName());
                        }
                        iSecurityModel.addObserver((IObserver)this);
                    } else if (db.on()) {
                        db.println("observe no NetSecurityModel: " + nodeModel.getHostName());
                    }
                } else if (db.on()) {
                    db.println("observe not ready: " + nodeModel.getHostName());
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block13;
                db.println("observe: " + nodeModel.getHostName() + ": failed: " + exception);
            }
        }
    }

    public void update(IObservable iObservable, Object object) {
        if (iObservable instanceof Network.NetElementCreationNotifier) {
            if (object instanceof NetElement) {
                if (db.on()) {
                    db.println("upd: net: NetElement: " + object);
                }
                this.observe((NodeModel)((INetElement)object).getNodeModel());
            } else if (db.on()) {
                db.println("upd: net: not a NetElement: " + object);
            }
        } else if (iObservable instanceof NodeModel.ConnectionNotifier) {
            NodeModel.ConnectionNotifier connectionNotifier = (NodeModel.ConnectionNotifier)iObservable;
            if (object == ModelUpdateType.DELETED) {
                connectionNotifier.deleteObserver(this);
                if (db.on()) {
                    db.println("upd: cn: DELETED: " + connectionNotifier.getNodeModel().getHostName());
                }
            } else if (object == ModelUpdateType.CHANGED) {
                if (db.on()) {
                    db.println("upd: cn: CHANGED: " + connectionNotifier.getNodeModel().getHostName());
                }
                this.observe(connectionNotifier.getNodeModel());
            } else if (db.on()) {
                db.println("upd: cn: ?" + object + "?: " + connectionNotifier.getNodeModel().getHostName());
            }
        } else if (iObservable instanceof ISecurityModel) {
            ISecurityModel iSecurityModel = (ISecurityModel)iObservable;
            if (object == ModelUpdateType.DELETED) {
                if (db.on()) {
                    db.println("upd: sec: DELETED: " + iSecurityModel.getNodeModel().getHostName());
                }
                iSecurityModel.deleteObserver((IObserver)this);
            } else if (db.on()) {
                db.println("upd: sec: ?" + object + "?: " + iSecurityModel.getNodeModel().getHostName());
            }
        } else if (db.on()) {
            db.println("upd: not Network, CN, or NetSecurityModel: " + iObservable);
        }
        this.setChanged();
        this.notifyObservers(object);
    }

    public boolean networkSupportsGetUsers(List list) {
        boolean bl = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && !bl) {
            try {
                NodeModel nodeModel = (NodeModel)iterator.next();
                ISecurityModel iSecurityModel = nodeModel.getSecurityModel();
                if (!nodeModel.provides(Feature.SEC_GET_USERS)) continue;
                bl = true;
            }
            catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                SDebug.printStackTrace((Throwable)abstractCmsCommFailException);
            }
        }
        return bl;
    }

    public boolean nodeDoesNotSupportGetUsers(List list) {
        boolean bl = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && !bl) {
            try {
                NodeModel nodeModel = (NodeModel)iterator.next();
                ISecurityModel iSecurityModel = nodeModel.getSecurityModel();
                if (nodeModel.provides(Feature.SEC_GET_USERS)) continue;
                bl = true;
            }
            catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                SDebug.printStackTrace((Throwable)abstractCmsCommFailException);
            }
        }
        return bl;
    }

    public synchronized String setUserName(String string) {
        this.userName = string;
        return this.userName;
    }

    public synchronized String getUserName() {
        return this.userName;
    }

    public synchronized String setPassword(String string) {
        this.password = string;
        return this.password;
    }

    public synchronized String getPassword() {
        return this.password;
    }

    public int getAllowedUnlockAttempts() {
        int n = 5;
        try {
            INodeModel iNodeModel = NetworkModel.instance().getCmsHostModel();
            if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.SECURITY_POLICY)) {
                n = iNodeModel.getSecurityModel().getSecurityPolicy().getLockoutThreshold();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    private NetSecurityModel() {
        Network.instance().getNetElementCreationNotifier().addObserver(this);
        if (db.on()) {
            db.println("Observing Network...");
        }
        this.securityVersion = new SecurityVersionedFeature();
        this.init();
    }

    private void init() {
        Iterator iterator = Network.instance().getElements().iterator();
        while (iterator.hasNext()) {
            NodeModel nodeModel = (NodeModel)((INetElement)iterator.next()).getNodeModel();
            this.observe(nodeModel);
        }
    }
}

