/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.IFramingType;
import cerent.cms.model.INodeDeletionHandler;
import cerent.cms.model.INodeModel;
import cerent.cms.model.Model;
import cerent.cms.model.NodeModel;
import cerent.cms.model.User;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.NetElementDeletionException;
import cerent.cms.topo.Network;
import cerent.util.AnnotatedException;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.orb.OngORB;
import cerent.util.threadpool.IActionClient;
import cerent.util.threadpool.IThreadWorker;
import cerent.util.threadpool.ThreadPool;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Observable;
import java.util.Properties;

public class NetworkModel
extends Model {
    protected static NetworkModel instance;
    private NodeModel cmsHost;
    private INetElement cmsHostNetElement;
    private User user;
    private HashMap nodeIdMap = new HashMap();

    protected NetworkModel() {
        this(new SDebug("NetworkModel"));
    }

    protected NetworkModel(SDebug sDebug) {
        super(sDebug);
    }

    public void init(String[] stringArray) throws Exception {
        if (this.db.on()) {
            this.db.println("NetworkModel init(): ");
        }
        OngORB.init((String[])stringArray, (Properties)new Properties());
    }

    public static synchronized NetworkModel instance() {
        if (instance == null) {
            String string = "";
            try {
                String string2 = Preferences.instance().getProperty("ctc", "mode", "DEFAULT");
                string = NetworkModel.getNetworkClassName(string2);
                instance = (NetworkModel)Class.forName(string).newInstance();
                NetworkModel.instance.db.println("CTC running in mode: " + string2);
            }
            catch (Exception exception) {
                instance = new NetworkModel();
                NetworkModel.instance.db.println("Caught Exception while trying to instantiate " + string);
                SDebug cfr_ignored_0 = NetworkModel.instance.db;
                SDebug.printStackTrace((Throwable)exception);
                NetworkModel.instance.db.println("Running CTC under the default single-process mode");
            }
        }
        return instance;
    }

    public static String getNetworkClassName(String string) {
        if (string.equalsIgnoreCase("REMOTE_ADDON")) {
            return "cerent.cms.model.RemoteNetworkModel";
        }
        if (string.equalsIgnoreCase("INDEX_ADDON")) {
            return "cerent.cms.model.AddonNetworkModel";
        }
        return "cerent.cms.model.NetworkModel";
    }

    public void setExcludeDyn(boolean bl) {
        Network.instance().setExcludeDyn(bl);
    }

    public void setEnableCircuitDiscovery(boolean bl) {
        Network.instance().setEnableCircuitDiscovery(bl);
    }

    public synchronized INetElement addNetElementBlocking(String string, String string2, String string3, boolean bl) throws UnknownHostException {
        if (this.db.on()) {
            this.db.println("Adding new topo host=" + string + " user=" + string2);
        }
        INetElement iNetElement = Network.instance().addNetElement(string, string2, string3);
        this.updateCmsHost(iNetElement, string, string2, string3);
        if (bl) {
            Network.instance().createTopology(iNetElement);
        }
        return iNetElement;
    }

    private void updateCmsHost(INetElement iNetElement, String string, String string2, String string3) {
        if (this.cmsHost == null) {
            if (!(iNetElement.getNodeModel() instanceof NodeModel)) {
                return;
            }
            this.cmsHost = (NodeModel)iNetElement.getNodeModel();
            this.cmsHostNetElement = iNetElement;
            this.user = new User(string2, string3);
            this.cmsHost.setCmsHost(true);
            if (this.db.on()) {
                this.db.println("Topo host set to cms host");
            }
        }
    }

    public void addNetElement(String string, String string2, String string3) throws UnknownHostException {
        if (this.db.on()) {
            this.db.println("Adding new net element:" + string);
        }
        if (this.user != null) {
            if (string2 == null) {
                string2 = this.user.getName();
            }
            if (string3 == null) {
                string3 = this.user.getPassword();
            }
        }
        ThreadPool.instance().enqueueClient((IActionClient)new NodeAdder(string, string2, string3));
    }

    public void deleteNetElement(INetElement iNetElement, INodeDeletionHandler iNodeDeletionHandler) {
        ThreadPool.instance().enqueueClient((IActionClient)new NodeDeleter(iNetElement, iNodeDeletionHandler));
    }

    public synchronized void destroyCmsHost() {
        if (this.cmsHost != null) {
            try {
                if (this.db.on()) {
                    this.db.println("invoking Network.deleteNetElement ne=" + this.cmsHostNetElement);
                }
                Network.instance().deleteNetElement(this.cmsHostNetElement);
            }
            catch (NetElementDeletionException netElementDeletionException) {
                SDebug.printStackTrace((Throwable)((Object)netElementDeletionException));
            }
            this.cmsHost = null;
            this.cmsHostNetElement = null;
        }
    }

    public Network.NetElementCreationNotifier getNetElementCreationNotifier() {
        return Network.instance().getNetElementCreationNotifier();
    }

    public Network.NetLinkCreationNotifier getNetLinkCreationNotifier() {
        return Network.instance().getNetLinkCreationNotifier();
    }

    public synchronized INodeModel getCmsHostModel() {
        return this.cmsHost;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(String string, String string2) {
        this.db.println("setUser: user = " + this.user + ", userName = " + string + ", password = " + string2);
        if (this.user == null) {
            this.user = new User(string, string2);
        }
    }

    public void destroy() {
        super.destroy();
        if (this.cmsHost != null) {
            this.cmsHost = null;
        }
        Network.instance().destroy();
        OngORB.instance().shutdown(true);
        this.db.println("Destruction completed");
    }

    public void update(Observable observable, Object object) {
    }

    public INodeModel getNodeModel(int n) throws AbstractCmsIOException {
        INodeModel iNodeModel = Network.instance().getNodeModel(this.getMostCurrentNodeId(n));
        return iNodeModel;
    }

    public NodeModel getNodeModelForDelegate(INodeModel iNodeModel) {
        NodeModel nodeModel = null;
        if (iNodeModel instanceof NodeModel) {
            nodeModel = (NodeModel)iNodeModel;
        } else {
            INodeModel iNodeModel2 = Network.instance().getNodeModel(iNodeModel.getNodeId());
            if (iNodeModel2 instanceof NodeModel) {
                nodeModel = (NodeModel)iNodeModel2;
            }
        }
        return nodeModel;
    }

    public INodeModel getNodeModel() {
        return this.cmsHost;
    }

    public int getMostCurrentNodeId(int n) {
        Object v;
        Integer n2 = new Integer(n);
        while ((v = this.nodeIdMap.get(n2)) != null) {
            n2 = (Integer)v;
        }
        if (this.db.on()) {
            this.db.println("getMostCurrentNodeId " + n + "->" + n2);
        }
        return n2;
    }

    public void nodeIdChanged(int n, int n2) {
        if (this.db.on()) {
            this.db.println("nodeIdChanged " + n + "->" + n2);
        }
        this.nodeIdMap.put(new Integer(n), new Integer(n2));
    }

    public TDMTerminology getTDMTerminology() throws AnnotatedException {
        return Model.getTDMTerminology(this.cmsHost);
    }

    public IFramingType getFramingType() throws AnnotatedException {
        return Model.getFramingType(this.cmsHost);
    }

    private class NodeDeleter
    implements IActionClient {
        private INetElement ne;
        private String hostName;
        private INodeDeletionHandler ndh;

        public NodeDeleter(INetElement iNetElement, INodeDeletionHandler iNodeDeletionHandler) {
            this.ne = iNetElement;
            this.ndh = iNodeDeletionHandler;
            this.hostName = iNetElement.getNodeModel().getName();
        }

        public void doAction() {
            NetElementDeletionException netElementDeletionException = null;
            int n = this.ne.getNodeId();
            try {
                Network.instance().deleteNetElement(this.ne);
            }
            catch (NetElementDeletionException netElementDeletionException2) {
                NetworkModel.this.db.println("Caught exception while deleting net element");
                SDebug cfr_ignored_0 = NetworkModel.this.db;
                SDebug.printStackTrace((Throwable)((Object)netElementDeletionException2));
                netElementDeletionException = netElementDeletionException2;
            }
            if (this.ndh != null) {
                this.ndh.handleResult(n, (Exception)((Object)netElementDeletionException), this.ne);
            }
        }

        public String toString() {
            return "NodeDeleter for " + this.hostName;
        }

        public void failedAction(IThreadWorker iThreadWorker) {
            NetworkModel.this.db.println("Node Deletion failed for " + this.hostName);
        }

        public void dispose() {
            NetworkModel.this.db.println("Disposing " + this);
        }
    }

    private class NodeAdder
    implements IActionClient {
        private String hostName;
        private String userName;
        private String password;

        public NodeAdder(String string, String string2, String string3) {
            this.hostName = string;
            this.userName = string2;
            this.password = string3;
        }

        public void doAction() {
            try {
                INetElement iNetElement = Network.instance().addNetElement(this.hostName, this.userName, this.password);
                if (iNetElement != null) {
                    Network.instance().createTopology(iNetElement);
                    NetworkModel.this.updateCmsHost(iNetElement, this.hostName, this.userName, this.password);
                }
            }
            catch (UnknownHostException unknownHostException) {
                NetworkModel.this.db.println("Caught exception in doAction() for " + this);
                SDebug cfr_ignored_0 = NetworkModel.this.db;
                SDebug.printStackTrace((Throwable)unknownHostException);
            }
        }

        public String toString() {
            return "Node Adder for " + this.hostName + "/" + NetworkModel.this.user;
        }

        public void failedAction(IThreadWorker iThreadWorker) {
            NetworkModel.this.db.println("Node Addition failed for " + this);
        }

        public void dispose() {
            NetworkModel.this.db.println("Disposing " + this);
        }
    }
}

