/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.loader.ElementFactoryFinder;
import cerent.cms.model.AbstractCmsCommFailException;
import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.DetailedConfigError;
import cerent.cms.model.DuplicateLocalVlinkId;
import cerent.cms.model.DuplicateRemoteVlinkId;
import cerent.cms.model.EndPointInUse;
import cerent.cms.model.Feature;
import cerent.cms.model.FeatureNotSupported;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IDwdmModuleModel;
import cerent.cms.model.IElementModel;
import cerent.cms.model.IElementModels;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.ILinkModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOchTrailAditModel;
import cerent.cms.model.IOchccConnectionModel;
import cerent.cms.model.IOpticsChannelModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IVirtualLinkModel;
import cerent.cms.model.IVirtualLinksManager;
import cerent.cms.model.MissingLink;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NoSuchVirtualLink;
import cerent.cms.model.NodeModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ResourceInUse;
import cerent.cms.model.WarningMessageException;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.cms.topo.VirtualNetLink;
import cerent.cms.ui.IEntityCellRenderer;
import cerent.cms.ui.Wavelength;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeSet;

public class VirtualLinksDirector
extends Model
implements Observer {
    public static final String ORIG = "Origination";
    public static final String TERM = "Termination";
    private static final Network network = Network.instance();
    private static final short NC_SHELF_ID = 1;
    private Set nodes = new TreeSet(new NodeComparator());
    private static VirtualLinksDirector instance = null;
    private static final SDebug db = new VlinkDebug("VirtualLinksDirector");

    public static final synchronized VirtualLinksDirector instance() {
        if (instance == null) {
            instance = new VirtualLinksDirector();
        }
        return instance;
    }

    public synchronized INodeModel[] getKnownNodes() {
        return this.nodes.toArray(new INodeModel[this.nodes.size()]);
    }

    public synchronized Integer[] getKnownShelfIds(INodeModel iNodeModel) {
        IEntityModel[] iEntityModelArray = null;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        IVirtualLinksManager iVirtualLinksManager = iNodeModel.getVirtualLinksManager();
        if (iVirtualLinksManager != null) {
            iEntityModelArray = iVirtualLinksManager.getVirtualLinkCandidates();
        }
        if (iEntityModelArray != null) {
            for (int i = 0; i < iEntityModelArray.length; ++i) {
                int n = iEntityModelArray[i].getShelfId();
                if (arrayList.contains(new Integer(n))) continue;
                arrayList.add(new Integer(n));
            }
        }
        Object[] objectArray = arrayList.toArray(new Integer[arrayList.size()]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Set getVirtualLinks() {
        TreeSet<IVirtualLinkModel> treeSet = new TreeSet<IVirtualLinkModel>();
        Set set = this.nodes;
        synchronized (set) {
            Iterator iterator = this.nodes.iterator();
            while (iterator.hasNext()) {
                INodeModel iNodeModel = (INodeModel)iterator.next();
                IVirtualLinkModel[] iVirtualLinkModelArray = this.getVirtualLinks(iNodeModel);
                if (iVirtualLinkModelArray == null) continue;
                db.fine(iNodeModel.getName() + " returned " + iVirtualLinkModelArray.length + " vlinks.");
                treeSet.addAll(Arrays.asList(iVirtualLinkModelArray));
            }
        }
        return this.combineVlinkFragments(treeSet);
    }

    public IVirtualLinkModel[] getVirtualLinks(INodeModel iNodeModel) {
        try {
            return iNodeModel.getVirtualLinksManager().getVirtualLinks();
        }
        catch (Exception exception) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return null;
        }
    }

    public static final boolean isVLIDInUse(INodeModel iNodeModel, short s) {
        Set set = VirtualLinksDirector.instance().getVirtualLinks();
        boolean bl = false;
        IIpAddr iIpAddr = iNodeModel.getIpConfig().getIpAddress();
        Iterator iterator = set.iterator();
        while (!bl && iterator.hasNext()) {
            IVirtualLinkModel iVirtualLinkModel = (IVirtualLinkModel)iterator.next();
            if ((iVirtualLinkModel.getOrigVLID() != s || iVirtualLinkModel.getOrigNode().compareTo((Object)iIpAddr) != 0) && (iVirtualLinkModel.getTermVLID() != s || iVirtualLinkModel.getTermNode().compareTo((Object)iIpAddr) != 0)) continue;
            bl = true;
        }
        return bl;
    }

    public synchronized void deleteVirtualLink(IIpAddr iIpAddr, short s) throws Exception {
        INetElement iNetElement = network.findNetElemByIp(VirtualLinksDirector.ipToString(iIpAddr));
        if (iNetElement == null) {
            throw new Exception("Unable to locate NE for " + VirtualLinksDirector.ipToString(iIpAddr));
        }
        INodeModel iNodeModel = iNetElement.getNodeModel();
        this.deleteVirtualLink(iNodeModel, s);
    }

    public synchronized void deleteVirtualLink(INodeModel iNodeModel, short s) throws Exception {
        IVirtualLinksManager iVirtualLinksManager = iNodeModel.getVirtualLinksManager();
        if (iVirtualLinksManager == null) {
            throw new NoSuchVirtualLink("Unable to locate VLM for " + iNodeModel.getName());
        }
        iVirtualLinksManager.deleteVirtualLink(s);
    }

    private void rollback(IVirtualLinksManager iVirtualLinksManager, short s) {
        try {
            iVirtualLinksManager.deleteVirtualLink(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void createVirtualLink(short s, INodeModel iNodeModel, IEntityModel iEntityModel, short s2, INodeModel iNodeModel2) throws NoSuchInterface, WrongInterfaceType, ProvisionError, DuplicateLocalVlinkId, DuplicateRemoteVlinkId, EndPointInUse, FeatureUnsupported, UnknownHostException {
        IIpAddr iIpAddr = iNodeModel.getIpConfig().getIpAddress();
        IIpAddr iIpAddr2 = iNodeModel2.getIpConfig().getIpAddress();
        if (iIpAddr == null) {
            throw new UnknownHostException("Unable to locate IP for " + iNodeModel.getName());
        }
        if (iIpAddr2 == null) {
            throw new UnknownHostException("Unable to locate IP for " + iNodeModel2.getName());
        }
        IVirtualLinksManager iVirtualLinksManager = iNodeModel.getVirtualLinksManager();
        try {
            iVirtualLinksManager.createVirtualLink(iEntityModel, s, iIpAddr, s2, iIpAddr2);
        }
        catch (FeatureUnsupported featureUnsupported) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)featureUnsupported);
            }
            this.rollback(iVirtualLinksManager, s);
            throw featureUnsupported;
        }
        catch (NoSuchInterface noSuchInterface) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
            this.rollback(iVirtualLinksManager, s);
            throw noSuchInterface;
        }
        catch (EndPointInUse endPointInUse) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)endPointInUse);
            }
            this.rollback(iVirtualLinksManager, s);
            throw endPointInUse;
        }
        catch (DuplicateLocalVlinkId duplicateLocalVlinkId) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)duplicateLocalVlinkId);
            }
            this.rollback(iVirtualLinksManager, s);
            throw duplicateLocalVlinkId;
        }
        catch (DuplicateRemoteVlinkId duplicateRemoteVlinkId) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)duplicateRemoteVlinkId);
            }
            this.rollback(iVirtualLinksManager, s);
            throw duplicateRemoteVlinkId;
        }
        catch (ProvisionError provisionError) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)provisionError);
            }
            this.rollback(iVirtualLinksManager, s);
            throw provisionError;
        }
    }

    public synchronized IEntityModel[] getVirtualLinkCandidates(INodeModel iNodeModel) {
        IVirtualLinksManager iVirtualLinksManager = iNodeModel.getVirtualLinksManager();
        if (iVirtualLinksManager != null) {
            return iVirtualLinksManager.getVirtualLinkCandidates();
        }
        return new IEntityModel[0];
    }

    public void update(Observable observable, Object object) {
        if (db.isFinestEnabled()) {
            db.finest("update from " + observable + " regarding " + object);
        }
        if (observable instanceof Network.NetElementCreationNotifier) {
            INetElement iNetElement;
            INodeModel iNodeModel;
            INodeModel.AbstractConnectionNotifier abstractConnectionNotifier;
            if (object instanceof INetElement && (abstractConnectionNotifier = (iNodeModel = (iNetElement = (INetElement)object).getNodeModel()).getConnectionNotifier()) != null) {
                abstractConnectionNotifier.addObserver(this);
            }
        } else if (observable instanceof NodeModel.ConnectionNotifier) {
            NodeModel.ConnectionNotifier connectionNotifier = (NodeModel.ConnectionNotifier)((Object)observable);
            NodeModel nodeModel = connectionNotifier.getNodeModel();
            if (object == ModelUpdateType.DELETED) {
                this.deregisterNode(nodeModel, connectionNotifier);
            } else {
                this.registerNode(nodeModel);
            }
            this.setChanged();
            this.notifyObservers(ModelUpdateType.CHANGED);
        } else if (observable instanceof IVirtualLinksManager) {
            this.setChanged();
            this.notifyObservers(object);
        }
    }

    public void addNode(String string) throws UnknownHostException {
        String string2 = null;
        string2 = InetAddress.getByName(string).getHostAddress().trim();
        NetworkModel.instance().addNetElement(string2, null, null);
    }

    public synchronized void deleteNode(INodeModel iNodeModel) {
        Iterator iterator = this.nodes.iterator();
        while (iterator.hasNext()) {
            INodeModel iNodeModel2 = (INodeModel)iterator.next();
            if (iNodeModel2 != iNodeModel) continue;
            iterator.remove();
            break;
        }
    }

    public IEntityModel isProtected(IEntityModel iEntityModel) {
        IEntityModel iEntityModel2;
        block10: {
            iEntityModel2 = null;
            INodeModel iNodeModel = iEntityModel.getNodeModel();
            if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.MULTISHELF)) {
                iEntityModel2 = iEntityModel.isProtected();
            } else {
                try {
                    IElementModels iElementModels = iNodeModel.getIElementModels();
                    if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.ISTU)) {
                        IElementModel iElementModel = iElementModels.getIElementModel(iEntityModel);
                        switch (iElementModel.getType()) {
                            case 1: 
                            case 4: {
                                int n = iElementModel.getProtectEntityIndex();
                                IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                                iEntityModel2 = iEntityTableModel.getEntityModelByIndex(n);
                                break;
                            }
                        }
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (db.isFineEnabled()) {
                        db.fine("Caught " + (Object)((Object)abstractCmsNoSuchEntityException) + " in isProtected(" + iEntityModel + ")");
                    }
                }
                catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                    if (!db.isFineEnabled()) break block10;
                    db.fine("Caught " + (Object)((Object)abstractCmsNoSuchElementException) + " in isProtected(" + iEntityModel + ")");
                }
            }
        }
        return iEntityModel2;
    }

    public IEntityModel isYCableProtected(IEntityModel iEntityModel) {
        IEntityModel iEntityModel2;
        block10: {
            iEntityModel2 = null;
            INodeModel iNodeModel = iEntityModel.getNodeModel();
            if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.MULTISHELF)) {
                iEntityModel2 = iEntityModel.isYCableProtected();
            } else {
                try {
                    IElementModels iElementModels = iNodeModel.getIElementModels();
                    if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.ISTU)) {
                        IElementModel iElementModel = iElementModels.getIElementModel(iEntityModel);
                        switch (iElementModel.getType()) {
                            case 4: {
                                int n = iElementModel.getProtectEntityIndex();
                                IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                                iEntityModel2 = iEntityTableModel.getEntityModelByIndex(n);
                                break;
                            }
                        }
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (db.isFineEnabled()) {
                        db.fine("Caught " + (Object)((Object)abstractCmsNoSuchEntityException) + " in isYCableProtected(" + iEntityModel + ")");
                    }
                }
                catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                    if (!db.isFineEnabled()) break block10;
                    db.fine("Caught " + (Object)((Object)abstractCmsNoSuchElementException) + " in isYCableProtected(" + iEntityModel + ")");
                }
            }
        }
        return iEntityModel2;
    }

    public short obtainUnusedVLID(INodeModel iNodeModel, short s) {
        IVirtualLinksManager iVirtualLinksManager = iNodeModel.getVirtualLinksManager();
        IVirtualLinkModel[] iVirtualLinkModelArray = iVirtualLinksManager.getVirtualLinks();
        int n = 0;
        for (int i = 0; i < iVirtualLinkModelArray.length; ++i) {
            short s2 = iVirtualLinkModelArray[i].getOrigVLID();
            n = (short)Math.max(n, s2);
        }
        return (short)(Math.max(n, s) + 1);
    }

    private VirtualLinksDirector() {
        super(db);
        this.updateNodeTable();
        Network.instance().getNetElementCreationNotifier().addObserver(this);
    }

    private void updateNodeTable() {
        Iterator iterator = Network.instance().getElements().iterator();
        while (iterator.hasNext()) {
            INetElement iNetElement = (INetElement)iterator.next();
            INodeModel iNodeModel = iNetElement.getNodeModel();
            INodeModel.AbstractConnectionNotifier abstractConnectionNotifier = iNodeModel.getConnectionNotifier();
            if (abstractConnectionNotifier != null) {
                abstractConnectionNotifier.addObserver(this);
            }
            this.registerNode(iNodeModel);
        }
    }

    private Set combineVlinkFragments(TreeSet treeSet) {
        Iterator iterator;
        TreeSet<IVirtualLinkModel> treeSet2 = new TreeSet<IVirtualLinkModel>();
        if (db.isFinestEnabled()) {
            db.finest("combineVlinkFragements ---- BEFORE (" + treeSet.size() + ") ----");
            iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                db.finest("  " + (IVirtualLinkModel)iterator.next());
            }
            db.finest("combineVlinkFragements ^^^^ BEFORE ^^^^");
        }
        while (treeSet.size() > 0) {
            boolean bl = false;
            IVirtualLinkModel iVirtualLinkModel = (IVirtualLinkModel)treeSet.first();
            if (!treeSet.remove(iVirtualLinkModel)) {
                db.warning("***** ERROR removing " + iVirtualLinkModel + " from set! *****");
            }
            Iterator iterator2 = treeSet.iterator();
            while (iterator2.hasNext()) {
                IVirtualLinkModel iVirtualLinkModel2 = (IVirtualLinkModel)iterator2.next();
                if (iVirtualLinkModel.getOrigVLID() != iVirtualLinkModel2.getTermVLID() || iVirtualLinkModel.getOrigNode().compareTo((Object)iVirtualLinkModel2.getTermNode()) != 0 || iVirtualLinkModel.getTermVLID() != iVirtualLinkModel2.getOrigVLID() || iVirtualLinkModel.getTermNode().compareTo((Object)iVirtualLinkModel2.getOrigNode()) != 0) continue;
                iterator2.remove();
                treeSet2.add(this.combineVlinks(iVirtualLinkModel, iVirtualLinkModel2));
                bl = true;
                break;
            }
            if (bl) continue;
            if (db.isFineEnabled()) {
                db.fine("Couldn't find partner for " + iVirtualLinkModel);
            }
            treeSet2.add(iVirtualLinkModel);
        }
        if (db.isFinestEnabled()) {
            db.finest("combineVlinkFragements ---- AFTER (" + treeSet2.size() + ") ----");
            iterator = treeSet2.iterator();
            while (iterator.hasNext()) {
                db.finest("  " + (IVirtualLinkModel)iterator.next());
            }
            db.finest("combineVlinkFragements ^^^^ AFTER ^^^^");
        }
        return treeSet2;
    }

    private IVirtualLinkModel combineVlinks(IVirtualLinkModel iVirtualLinkModel, IVirtualLinkModel iVirtualLinkModel2) {
        if (db.isFinestEnabled()) {
            db.finest(" combining " + iVirtualLinkModel + "       and " + iVirtualLinkModel2);
        }
        return new VlinkHolder(iVirtualLinkModel.getOrigVLID(), iVirtualLinkModel.getOrigNode(), iVirtualLinkModel.getOrigEntity(), iVirtualLinkModel2.getOrigVLID(), iVirtualLinkModel2.getOrigNode(), iVirtualLinkModel2.getOrigEntity());
    }

    private synchronized void registerNode(INodeModel iNodeModel) {
        block5: {
            db.fine("registerNode(" + iNodeModel + ")");
            if (iNodeModel.provides(Feature.VLINK_PROVISIONING) && iNodeModel.isInited() && !this.nodes.contains(iNodeModel)) {
                try {
                    this.nodes.add(iNodeModel);
                    iNodeModel.getVirtualLinksManager().addObserver((Observer)this);
                }
                catch (FeatureNotSupported featureNotSupported) {
                    db.fine(iNodeModel.getName() + " does not support virtual links.");
                    if (db.isFineEnabled()) {
                        SDebug.printStackTrace((Throwable)featureNotSupported);
                    }
                }
                catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                    db.fine(iNodeModel.getName() + " is not connected.");
                    if (!db.isFineEnabled()) break block5;
                    SDebug.printStackTrace((Throwable)abstractCmsCommFailException);
                }
            }
        }
    }

    private synchronized void deregisterNode(INodeModel iNodeModel, INodeModel.AbstractConnectionNotifier abstractConnectionNotifier) {
        block2: {
            db.fine("deregisterNode(" + iNodeModel + ")");
            abstractConnectionNotifier.deleteObserver((Observer)this);
            try {
                iNodeModel.getVirtualLinksManager().deleteObserver((Observer)this);
            }
            catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                if (!db.isFineEnabled()) break block2;
                SDebug.printStackTrace((Throwable)abstractCmsCommFailException);
            }
        }
        this.nodes.remove(iNodeModel);
    }

    public String getNodeNameByIp(IIpAddr iIpAddr) {
        INodeModel iNodeModel;
        String string = VirtualLinksDirector.ipToString(iIpAddr);
        INetElement iNetElement = network.findNetElemByIp(string);
        INodeModel iNodeModel2 = iNodeModel = iNetElement != null ? iNetElement.getNodeModel() : null;
        if (iNodeModel != null && iNodeModel.getConnectionState()) {
            try {
                string = iNodeModel.getName();
            }
            catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                string = VirtualLinksDirector.ipToString(iIpAddr);
            }
        }
        return string;
    }

    public INodeModel getNodeModelFromString(String string) {
        String string2 = null;
        try {
            string2 = InetAddress.getByName(string).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            if (db.on()) {
                db.println("Cannot find IP name " + string + ": " + unknownHostException.getMessage());
            }
            return null;
        }
        INetElement iNetElement = network.findNetElemByIp(string2);
        if (iNetElement == null) {
            Collection collection = network.getAllElements();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                INetElement iNetElement2 = (INetElement)iterator.next();
                if (iNetElement2.getNodeModel().getName().compareToIgnoreCase(string) != 0) continue;
                iNetElement = iNetElement2;
                break;
            }
        }
        if (iNetElement != null) {
            return iNetElement.getNodeModel();
        }
        return null;
    }

    public static boolean shouldSwap(IEntityModel iEntityModel, IEntityModel iEntityModel2) {
        boolean bl = false;
        if (iEntityModel != null && iEntityModel2 != null && (iEntityModel.getEqType() == 139 || iEntityModel.getEqType() == 141 || iEntityModel2.getEqType() == 139 || iEntityModel2.getEqType() == 141)) {
            IModuleModel iModuleModel = iEntityModel.getModuleModel();
            IModuleModel iModuleModel2 = iEntityModel2.getModuleModel();
            if (iModuleModel.getEqType() == 131 || (iModuleModel.getEqType() == 133 || iEntityModel.getEqType() == 141) && iEntityModel.getPositionInParent() % 2 != 0) {
                bl = true;
            }
            if (iModuleModel2.getEqType() == 132 || (iModuleModel2.getEqType() == 133 || iEntityModel2.getEqType() == 141) && iEntityModel2.getPositionInParent() % 2 == 0) {
                bl = true;
            }
        }
        return bl;
    }

    public static final String ipToString(IIpAddr iIpAddr) {
        byte[] byArray = iIpAddr.getAddr();
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < byArray.length; ++i) {
            if (bl && byArray[i] == 0) continue;
            bl = false;
            stringBuffer.append(Integer.toString(byArray[i] & 0xFF));
            if (i + 1 >= byArray.length) continue;
            stringBuffer.append(".");
        }
        return stringBuffer.toString();
    }

    public static boolean hasSeparateTxRx(VirtualNetLink virtualNetLink) throws AbstractCmsNoSuchEntityException {
        IEntityModel iEntityModel;
        Object object;
        boolean bl = false;
        ILinkModel iLinkModel = virtualNetLink.getLinkModel();
        ILinkModel iLinkModel2 = null;
        INetLink iNetLink = network.findNetLinkFromLinkModel(iLinkModel);
        if (iNetLink != null) {
            object = network.findReverseLink(iNetLink);
            iLinkModel2 = object != null ? object.getLinkModel() : null;
        }
        object = iLinkModel.src();
        int n = iLinkModel.srcEntityIndex();
        if (n == 0 && iLinkModel2 != null) {
            n = iLinkModel2.dstEntityIndex();
        }
        IEntityTableModel iEntityTableModel = object != null ? object.getEntityTable() : null;
        IEntityModel iEntityModel2 = iEntityModel = iEntityTableModel != null ? iEntityTableModel.getEntityModelByIndex(n) : null;
        if (iEntityModel != null && (iEntityModel.getEqType() == 139 || iEntityModel.getEqType() == 141)) {
            bl = true;
        } else {
            IEntityModel iEntityModel3;
            INodeModel iNodeModel = iLinkModel.dst();
            int n2 = iLinkModel.dstEntityIndex();
            if (n2 == 0 && iLinkModel2 != null) {
                n2 = iLinkModel2.srcEntityIndex();
            }
            IEntityTableModel iEntityTableModel2 = iNodeModel != null ? iNodeModel.getEntityTable() : null;
            IEntityModel iEntityModel4 = iEntityModel3 = iEntityTableModel2 != null ? iEntityTableModel2.getEntityModelByIndex(n2) : null;
            if (iEntityModel3 != null && (iEntityModel3.getEqType() == 139 || iEntityModel3.getEqType() == 141)) {
                bl = true;
            }
        }
        return bl;
    }

    public static boolean arePeers(VirtualNetLink virtualNetLink, VirtualNetLink virtualNetLink2) throws AbstractCmsNoSuchEntityException {
        boolean bl = false;
        ILinkModel iLinkModel = virtualNetLink.getLinkModel();
        ILinkModel iLinkModel2 = virtualNetLink2.getLinkModel();
        if (iLinkModel.getSrcLinkId() != iLinkModel2.getSrcLinkId() && iLinkModel.getDstLinkId() != iLinkModel2.getDstLinkId()) {
            INodeModel iNodeModel = iLinkModel.src();
            INodeModel iNodeModel2 = iLinkModel2.src();
            INodeModel iNodeModel3 = iLinkModel.dst();
            INodeModel iNodeModel4 = iLinkModel2.dst();
            IIpAddr iIpAddr = iNodeModel.getIpConfig().getIpAddress();
            IIpAddr iIpAddr2 = iNodeModel2.getIpConfig().getIpAddress();
            IIpAddr iIpAddr3 = iNodeModel3.getIpConfig().getIpAddress();
            IIpAddr iIpAddr4 = iNodeModel4.getIpConfig().getIpAddress();
            if (iIpAddr.compareTo((Object)iIpAddr2) == 0 && iIpAddr3.compareTo((Object)iIpAddr4) == 0 || iIpAddr.compareTo((Object)iIpAddr4) == 0 && iIpAddr3.compareTo((Object)iIpAddr2) == 0) {
                int n = virtualNetLink.getSrcEntityIndex();
                int n2 = virtualNetLink2.getSrcEntityIndex();
                int n3 = virtualNetLink.getDstEntityIndex();
                int n4 = virtualNetLink2.getDstEntityIndex();
                if (db.isFineEnabled()) {
                    db.fine("arePeers([" + iNodeModel.getName() + "/" + iLinkModel.getSrcLinkId() + "/0x" + Integer.toHexString(n) + " - " + iNodeModel3.getName() + "/" + iLinkModel.getDstLinkId() + "/0x" + Integer.toHexString(n3) + "]\n\tagainst [" + iNodeModel2.getName() + "/" + iLinkModel2.getSrcLinkId() + "/0x" + Integer.toHexString(n2) + " - " + iNodeModel4.getName() + "/" + iLinkModel2.getDstLinkId() + "/0x" + Integer.toHexString(n4) + "])");
                }
                if (n == n2 || n3 == n4 || n == n4 || n3 == n2) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    public static INetLink[] getLinkTerminations(VirtualNetLink virtualNetLink) throws MissingLink {
        Object object;
        IEntityModel iEntityModel;
        db.fine("getLinkTerminations(" + virtualNetLink + ")");
        INetElement iNetElement = virtualNetLink.getSrc();
        INetElement iNetElement2 = virtualNetLink.getDst();
        if (!iNetElement.isInited() || !iNetElement2.isInited()) {
            throw new MissingLink("src/dst node not inited!");
        }
        IEntityTableModel iEntityTableModel = iNetElement.getNodeModel().getEntityTable();
        IEntityTableModel iEntityTableModel2 = iNetElement2.getNodeModel().getEntityTable();
        try {
            iEntityModel = iEntityTableModel.getEntityModelByIndex(virtualNetLink.getSrcEntityIndex());
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            throw new MissingLink((Exception)((Object)abstractCmsNoSuchEntityException));
        }
        int n = iEntityModel.getEqType();
        boolean bl = VirtualLinksDirector.isOch(n);
        INetLink iNetLink = network.findReverseLink(virtualNetLink);
        if (iNetLink == null) {
            throw new MissingLink("Link has no reverse: cannot complete it");
        }
        if (!bl) {
            try {
                object = iEntityTableModel2.getEntityModelByIndex(iNetLink.getSrcEntityIndex());
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                throw new MissingLink((Exception)((Object)abstractCmsNoSuchEntityException));
            }
            int n2 = object.getEqType();
            bl = VirtualLinksDirector.isOch(n2);
        }
        if (db.isFineEnabled()) {
            db.fine("Calling getLinkTerminations for: " + virtualNetLink.prettyString() + " (isBarolo: " + bl + ")");
        }
        object = null;
        INetLink iNetLink2 = null;
        if (bl) {
            Collection collection = network.findVirtualLinks(iNetElement, iNetElement2);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                VirtualNetLink virtualNetLink2 = (VirtualNetLink)iterator.next();
                if (virtualNetLink2 == virtualNetLink || virtualNetLink2 == iNetLink) continue;
                if (db.isFineEnabled()) {
                    db.fine("candidate: " + virtualNetLink2.prettyString());
                }
                try {
                    if (!VirtualLinksDirector.arePeers(virtualNetLink, virtualNetLink2)) continue;
                    object = virtualNetLink2;
                }
                catch (Exception exception) {
                    db.fine("Caught " + exception);
                }
            }
            if (object == null) {
                throw new MissingLink("Link has no peer: cannot complete it");
            }
            iNetLink2 = network.findReverseLink((INetLink)object);
            if (iNetLink2 == null) {
                throw new MissingLink("Reverse link has no peer: cannot complete it");
            }
        }
        if (db.isFinestEnabled()) {
            db.finest("Found all links: \nvl: " + virtualNetLink.prettyString() + (virtualNetLink.isDeleted() ? "[deleted]" : "") + "\n" + "reverse: " + iNetLink.prettyString() + (iNetLink.isDeleted() ? "[deleted]" : "") + (bl ? "\npeer: " + object.prettyString() + (object.isDeleted() ? "[deleted]" : "") + ": " + "\n" + "peer reverse: " + iNetLink2.prettyString() + (iNetLink2.isDeleted() ? "[deleted]" : "") : ""));
        }
        if (bl) {
            return new INetLink[]{virtualNetLink, iNetLink, object, iNetLink2};
        }
        return new INetLink[]{virtualNetLink, iNetLink};
    }

    public static INetLink[] getCoupledLinkTerminations(VirtualNetLink virtualNetLink) {
        db.fine("getCoupledLinkTerminations(" + virtualNetLink.prettyString() + ")");
        INetLink[] iNetLinkArray = VirtualLinksDirector.getAvailLinkTerminations(virtualNetLink);
        LinkedList<INetLink> linkedList = new LinkedList<INetLink>();
        block2: for (int i = 0; i < iNetLinkArray.length - 1; ++i) {
            INetLink iNetLink = iNetLinkArray[i];
            for (int j = i; j < iNetLinkArray.length; ++j) {
                INetLink iNetLink2 = iNetLinkArray[j];
                try {
                    if (!VirtualLinksDirector.arePeers((VirtualNetLink)iNetLink, (VirtualNetLink)iNetLink2)) continue;
                    linkedList.add(iNetLink);
                    continue block2;
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    db.fine("Caugt " + (Object)((Object)abstractCmsNoSuchEntityException));
                }
            }
        }
        return linkedList.toArray(new INetLink[0]);
    }

    public static INetLink[] getAvailLinkTerminations(VirtualNetLink virtualNetLink) {
        Object object;
        db.fine("getAvailLinkTerminations(" + virtualNetLink.prettyString() + ")");
        HashSet<INetLink> hashSet = new HashSet<INetLink>();
        if (!virtualNetLink.isDeleted()) {
            hashSet.add(virtualNetLink);
        } else if (db.isFineEnabled()) {
            db.fine(virtualNetLink.prettyString() + " is deleted.");
        }
        INetElement iNetElement = virtualNetLink.getSrc();
        INetElement iNetElement2 = virtualNetLink.getDst();
        INetLink iNetLink = network.findReverseLink(virtualNetLink);
        if (iNetLink != null) {
            if (!iNetLink.isDeleted()) {
                hashSet.add(iNetLink);
            } else if (db.isFineEnabled()) {
                db.fine("reverse is deleted.");
            }
        } else if (db.isFineEnabled()) {
            db.fine("reverse is null.");
        }
        INetLink iNetLink2 = null;
        INetLink iNetLink3 = null;
        Collection collection = network.findVirtualLinks(iNetElement, iNetElement2);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            object = (VirtualNetLink)iterator.next();
            if (object == virtualNetLink || object == iNetLink) continue;
            if (db.isFinestEnabled()) {
                db.finest("candidate: " + ((VirtualNetLink)object).prettyString());
            }
            try {
                if (!VirtualLinksDirector.arePeers(virtualNetLink, (VirtualNetLink)object)) continue;
                iNetLink2 = object;
            }
            catch (Exception exception) {
                db.fine("Caugt " + exception);
            }
        }
        if (iNetLink2 != null) {
            if (!iNetLink2.isDeleted()) {
                hashSet.add(iNetLink2);
            } else if (db.isFineEnabled()) {
                db.fine("peer is deleted.");
            }
        } else if (db.isFineEnabled()) {
            db.fine("peer is null.");
        }
        iNetLink3 = network.findReverseLink(iNetLink2);
        if (iNetLink3 != null) {
            if (!iNetLink3.isDeleted()) {
                hashSet.add(iNetLink3);
            } else if (db.isFineEnabled()) {
                db.fine("reversePeer is deleted.");
            }
        } else if (db.isFineEnabled()) {
            db.fine("reversePeer is null.");
        }
        if (db.isFineEnabled()) {
            object = new StringBuffer("Found " + hashSet.size() + " available links:");
            if (virtualNetLink != null && !virtualNetLink.isDeleted()) {
                ((StringBuffer)object).append("\nvnl: " + virtualNetLink.prettyString());
            }
            if (iNetLink != null && !iNetLink.isDeleted()) {
                ((StringBuffer)object).append("\nreverse: " + iNetLink.prettyString());
            }
            if (iNetLink2 != null && !iNetLink2.isDeleted()) {
                ((StringBuffer)object).append("\npeer: " + iNetLink2.prettyString());
            }
            if (iNetLink3 != null && !iNetLink3.isDeleted()) {
                ((StringBuffer)object).append("\nreversePeer: " + iNetLink3.prettyString());
            }
            db.fine(((StringBuffer)object).toString());
        }
        return hashSet.toArray(new INetLink[0]);
    }

    public boolean isLinkUp(VirtualNetLink virtualNetLink) {
        int n;
        INetLink[] iNetLinkArray;
        try {
            iNetLinkArray = VirtualLinksDirector.getLinkTerminations(virtualNetLink);
        }
        catch (MissingLink missingLink) {
            db.warning("Cannot calculate VL state.\n" + missingLink.getMessage());
            return false;
        }
        boolean bl = true;
        for (int i = 0; bl && i < iNetLinkArray.length; ++i) {
            n = iNetLinkArray[i].getLinkModel().state();
            bl = !iNetLinkArray[i].isDeleted() && n == 1;
        }
        if (db.isFineEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("isLinkUp state summary: ");
            for (n = 0; n < iNetLinkArray.length; ++n) {
                int n2 = iNetLinkArray[n].getLinkModel().state();
                switch (n) {
                    case 0: {
                        stringBuffer.append("vl state=");
                        break;
                    }
                    case 1: {
                        stringBuffer.append("reverse state=");
                        break;
                    }
                    case 2: {
                        stringBuffer.append("peer state=");
                        break;
                    }
                    case 3: {
                        stringBuffer.append("peer reverse state=");
                    }
                }
                stringBuffer.append(n2);
            }
            stringBuffer.append("; Is link up: " + bl);
            db.fine(stringBuffer.toString());
        }
        return bl;
    }

    public static void deletionSanityCheck(IVirtualLinkModel iVirtualLinkModel) throws ResourceInUse, NoSuchVirtualLink {
        if (iVirtualLinkModel != null) {
            if (iVirtualLinkModel.getOrigEntity() != null && iVirtualLinkModel.getTermEntity() != null) {
                List list = iVirtualLinkModel.getOrigEntity().getConnectionsList();
                list.addAll(iVirtualLinkModel.getTermEntity().getConnectionsList());
                if (list.size() != 0) {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        IConnectionModel iConnectionModel = (IConnectionModel)iterator.next();
                        if (!(iConnectionModel instanceof IOchTrailAditModel) && !(iConnectionModel instanceof IOchccConnectionModel)) continue;
                        throw new ResourceInUse("This PPC cannot be deleted as one or more circuits are provisioned over it.");
                    }
                }
            }
        } else {
            throw new NoSuchVirtualLink("Attempt to delete invalid PPC!");
        }
    }

    public static final void sanityCheck(INodeModel iNodeModel, short s, short s2, IEntityModel iEntityModel, IEntityModel iEntityModel2, INodeModel iNodeModel2, short s3, short s4, IEntityModel iEntityModel3, IEntityModel iEntityModel4) throws Exception {
        IIpAddr iIpAddr;
        IIpAddr iIpAddr2;
        boolean bl;
        boolean bl2 = s2 != -1 && iEntityModel2 != null & s4 != -1 && iEntityModel4 != null ? true : (bl = false);
        if (s == -1) {
            throw new Exception("Origination patchcord identifier is invalid.");
        }
        if (VirtualLinksDirector.isVLIDInUse(iNodeModel, s)) {
            throw new Exception("Origination patchcord identifier " + s + " is in use.");
        }
        if (iEntityModel == null) {
            throw new Exception("Origination port has not been selected.");
        }
        if (s3 == -1) {
            throw new Exception("Termination patchcord identifier is invalid.");
        }
        if (VirtualLinksDirector.isVLIDInUse(iNodeModel2, s3)) {
            throw new Exception("Termination patchcord identifier " + s3 + " is in use.");
        }
        if (iEntityModel3 == null) {
            throw new Exception("Termination port has not been selected.");
        }
        if (bl) {
            if (s2 == -1) {
                throw new Exception("Origination RX patchcord identifier is invalid.");
            }
            if (VirtualLinksDirector.isVLIDInUse(iNodeModel, s2)) {
                throw new Exception("Origination RX patchcord identifier " + s2 + " is in use.");
            }
            if (s4 == -1) {
                throw new Exception("Termination RX patchcord identifier is invalid.");
            }
            if (VirtualLinksDirector.isVLIDInUse(iNodeModel2, s4)) {
                throw new Exception("Termination RX patchcord identifier " + s4 + " is in use.");
            }
            if (iEntityModel2 == null) {
                throw new Exception("Origination RX port has not been selected.");
            }
            if (iEntityModel4 == null) {
                throw new Exception("Termination RX port has not been selected.");
            }
            if (s == s2) {
                throw new Exception("Origination TX and RX patchcord identifiers cannot be the same.");
            }
            if (s3 == s4) {
                throw new Exception("Termination TX and RX patchcord identifiers cannot be the same.");
            }
        }
        if ((iIpAddr2 = iNodeModel.getIpConfig().getIpAddress()).compareTo((Object)(iIpAddr = iNodeModel2.getIpConfig().getIpAddress())) == 0) {
            if (iEntityModel3 == iEntityModel) {
                throw new Exception("Origination and Termination ports must be different.");
            }
            if (iEntityModel.getModuleModel() == iEntityModel3.getModuleModel()) {
                throw new Exception("Origination and Termination ports must be on different cards.");
            }
            if (bl) {
                if (s == s3) {
                    throw new Exception("Origination and Termination TX IDs must be different.");
                }
                if (s2 == s4) {
                    throw new Exception("Origination and Termination RX IDs must be different.");
                }
            } else if (s == s3) {
                throw new Exception("Origination and Termination IDs must be different.");
            }
        }
        if (bl) {
            VirtualLinksDirector.checkPortCompatibility(iNodeModel, iEntityModel, iEntityModel2, iNodeModel2, iEntityModel3, iEntityModel4);
        } else {
            VirtualLinksDirector.checkPortCompatibility(true, iNodeModel, iEntityModel, iNodeModel2, iEntityModel3);
        }
    }

    private static final boolean isTxp25G(int n) {
        return n == 120 || n == 121;
    }

    private static final boolean isMxp25G(int n) {
        return n == 183 || n == 184;
    }

    private static final boolean is25GTrunk(int n) {
        return VirtualLinksDirector.isTxp25G(n) || VirtualLinksDirector.isMxp25G(n);
    }

    private static final boolean is10GTrunk(int n) {
        return VirtualLinksDirector.is10GTransponder(n) || VirtualLinksDirector.is10GMuxponder(n) || n == 243;
    }

    private static final boolean isOC48Txp(int n) {
        return VirtualLinksDirector.isTxp25G(n) || n == 119 || n == 182;
    }

    private static final boolean is10GTransponder(int n) {
        return VirtualLinksDirector.isTxp10G(n) || VirtualLinksDirector.isTxp10E(n);
    }

    private static final boolean is10GMuxponder(int n) {
        return VirtualLinksDirector.isMxp10G(n) || VirtualLinksDirector.isMxp10E(n);
    }

    private static final boolean isTxp10G(int n) {
        return n == 118;
    }

    private static final boolean isMxp10G(int n) {
        return n == 119;
    }

    private static final boolean isTxp10E(int n) {
        return n == 181;
    }

    private static final boolean isMxp10E(int n) {
        return n == 182;
    }

    private static final boolean isOC192Txp(int n) {
        return VirtualLinksDirector.isTxp10G(n) || VirtualLinksDirector.isTxp10E(n);
    }

    private static final boolean isOch(int n) {
        return n == 139 || n == 141;
    }

    private static final boolean hasSeparateTxRxOnCard(int n) {
        return n == 133 || n == 134 || n == 135 || n == 136 || n == 137 || n == 138;
    }

    private static final void checkPortCompatibility(INodeModel iNodeModel, IEntityModel iEntityModel, IEntityModel iEntityModel2, INodeModel iNodeModel2, IEntityModel iEntityModel3, IEntityModel iEntityModel4) throws Exception {
        int n;
        int n2;
        VirtualLinksDirector.checkPortCompatibility(false, iNodeModel, iEntityModel, iNodeModel2, iEntityModel3);
        VirtualLinksDirector.checkPortCompatibility(true, iNodeModel, iEntityModel2, iNodeModel2, iEntityModel4);
        IModuleModel iModuleModel = iEntityModel.getModuleModel();
        IModuleModel iModuleModel2 = iEntityModel2.getModuleModel();
        IModuleModel iModuleModel3 = iEntityModel3.getModuleModel();
        IModuleModel iModuleModel4 = iEntityModel4.getModuleModel();
        IEntityCellRenderer iEntityCellRenderer = ElementFactoryFinder.getElementFactory(iNodeModel).createEntityCellRenderer(iModuleModel);
        IEntityCellRenderer iEntityCellRenderer2 = ElementFactoryFinder.getElementFactory(iNodeModel2).createEntityCellRenderer(iModuleModel3);
        if ((VirtualLinksDirector.hasSeparateTxRxOnCard(iModuleModel.getEqType()) || VirtualLinksDirector.hasSeparateTxRxOnCard(iModuleModel2.getEqType())) && iModuleModel != iModuleModel2) {
            throw new Exception("Node " + iNodeModel.getName() + " " + iEntityCellRenderer.getString((Object)iEntityModel, "slot ") + " and\n" + iEntityCellRenderer.getString((Object)iEntityModel2, "slot ") + " are not on the same\ncard! Please select a different port.");
        }
        if ((VirtualLinksDirector.hasSeparateTxRxOnCard(iModuleModel3.getEqType()) || VirtualLinksDirector.hasSeparateTxRxOnCard(iModuleModel4.getEqType())) && iModuleModel3 != iModuleModel4) {
            throw new Exception("Node " + iNodeModel2.getName() + " " + iEntityCellRenderer2.getString((Object)iEntityModel3, "slot ") + " and\n" + iEntityCellRenderer2.getString((Object)iEntityModel4, "slot ") + " are not on the same\ncard! Please select a different port.");
        }
        if (iEntityModel.getEqType() == 141 || iEntityModel3.getEqType() == 141) {
            n2 = -1;
            n = -1;
            if (iEntityModel.getEqType() == 141) {
                n2 = iEntityModel.getPort();
                if (n2 != (n = iEntityModel2.getPort()) + 1) {
                    throw new Exception("Node " + iNodeModel.getName() + " " + iEntityCellRenderer.getString((Object)iEntityModel, "slot ") + " and\n" + iEntityCellRenderer.getString((Object)iEntityModel2, "slot ") + " must be on the same\nchannel! Please select a different port.");
                }
            } else if (iEntityModel3.getEqType() == 141 && (n2 = iEntityModel3.getPort()) != (n = iEntityModel4.getPort()) + 1) {
                throw new Exception("Node " + iNodeModel2.getName() + " " + iEntityCellRenderer2.getString((Object)iEntityModel3, "slot ") + " and\n" + iEntityCellRenderer2.getString((Object)iEntityModel4, "slot ") + " must be on the same\nchannel! Please select a different port.");
            }
        }
        if (iEntityModel.getEqType() == 139 && !VirtualLinksDirector.hasSeparateTxRxOnCard(iModuleModel.getEqType()) || iEntityModel3.getEqType() == 139 && !VirtualLinksDirector.hasSeparateTxRxOnCard(iModuleModel3.getEqType())) {
            n2 = -1;
            n = -1;
            if (iEntityModel.getEqType() == 139) {
                n2 = iEntityModel.getPort();
                if (n2 != (n = iEntityModel2.getPort())) {
                    throw new Exception("Node " + iNodeModel.getName() + " " + iEntityCellRenderer.getString((Object)iEntityModel, "slot ") + " and\n" + iEntityCellRenderer.getString((Object)iEntityModel2, "slot ") + " must be on the same\nchannel! Please select a different port.");
                }
            } else if (iEntityModel3.getEqType() == 139 && (n2 = iEntityModel3.getPort()) != (n = iEntityModel4.getPort())) {
                throw new Exception("Node " + iNodeModel2.getName() + " " + iEntityCellRenderer2.getString((Object)iEntityModel3, "slot ") + " and\n" + iEntityCellRenderer2.getString((Object)iEntityModel4, "slot ") + " must be on the same\nchannel! Please select a different port.");
            }
        }
        if (iEntityModel.getEqType() == 139 && iModuleModel.getEqType() == 133 || iEntityModel3.getEqType() == 139 && iModuleModel3.getEqType() == 133) {
            n2 = -1;
            n = -1;
            if (iModuleModel.getEqType() == 133) {
                n2 = iEntityModel.getPort();
                if (n2 != (n = iEntityModel2.getPort()) + 1) {
                    throw new Exception("Node " + iNodeModel.getName() + " " + iEntityCellRenderer.getString((Object)iEntityModel, "slot ") + " and\n" + iEntityCellRenderer.getString((Object)iEntityModel2, "slot ") + " must be on the same\nchannel! Please select a different port.");
                }
            } else if (iModuleModel3.getEqType() == 133 && (n2 = iEntityModel3.getPort()) != (n = iEntityModel4.getPort()) + 1) {
                throw new Exception("Node " + iNodeModel2.getName() + " " + iEntityCellRenderer2.getString((Object)iEntityModel3, "slot ") + " and\n" + iEntityCellRenderer2.getString((Object)iEntityModel4, "slot ") + " must be on the same\nchannel! Please select a different port.");
            }
        }
    }

    private static final void checkPortCompatibility(boolean bl, INodeModel iNodeModel, IEntityModel iEntityModel, INodeModel iNodeModel2, IEntityModel iEntityModel2) throws Exception {
        int n;
        Object object;
        String string;
        IDwdmModuleModel iDwdmModuleModel;
        IDwdmModuleModel iDwdmModuleModel2;
        int n2 = iEntityModel.getEqType();
        int n3 = iEntityModel2.getEqType();
        int n4 = iEntityModel.getModuleModel().getEqType();
        int n5 = iEntityModel2.getModuleModel().getEqType();
        IIpAddr iIpAddr = iNodeModel.getIpConfig().getIpAddress();
        IIpAddr iIpAddr2 = iNodeModel2.getIpConfig().getIpAddress();
        IModuleModel iModuleModel = iEntityModel.getModuleModel();
        IModuleModel iModuleModel2 = iEntityModel2.getModuleModel();
        IEntityCellRenderer iEntityCellRenderer = ElementFactoryFinder.getElementFactory(iNodeModel).createEntityCellRenderer(iModuleModel);
        IEntityCellRenderer iEntityCellRenderer2 = ElementFactoryFinder.getElementFactory(iNodeModel2).createEntityCellRenderer(iModuleModel2);
        if ((n2 == 28 || n2 == 29) && n3 == 122 && !VirtualLinksDirector.isTxp25G(n5) || (n3 == 28 || n3 == 29) && n2 == 122 && !VirtualLinksDirector.isTxp25G(n4)) {
            throw new Exception("Provisionable patchcords between OC3/OC12 ports and non-multirate transponders are not supported.");
        }
        if (n2 == 30 && n3 == 122 && !VirtualLinksDirector.isOC48Txp(n5) || n3 == 30 && n2 == 122 && !VirtualLinksDirector.isOC48Txp(n4)) {
            throw new Exception("Provisionable patchcords between OC48 ports and non-2.5G transponders are not supported.");
        }
        if (n2 == 61 && n3 == 122 && !VirtualLinksDirector.isOC192Txp(n5) || n3 == 61 && n2 == 122 && !VirtualLinksDirector.isOC192Txp(n4)) {
            throw new Exception("Provisionable patchcords between OC192 ports and non-10G transponders are not supported.");
        }
        if (n2 == 122 && n3 == 122) {
            iDwdmModuleModel2 = (IDwdmModuleModel)iModuleModel;
            iDwdmModuleModel = (IDwdmModuleModel)iModuleModel2;
            if (VirtualLinksDirector.isTxp10G(n4) && !VirtualLinksDirector.isTxp10G(n5) || VirtualLinksDirector.isTxp10E(n4) && !VirtualLinksDirector.isTxp10E(n5) || VirtualLinksDirector.isTxp25G(n4) && !VirtualLinksDirector.isTxp25G(n5) || iIpAddr.compareTo((Object)iIpAddr2) != 0 || iDwdmModuleModel2.getSlot() == iDwdmModuleModel.getSlot() || iDwdmModuleModel2.getRegenPeer() != iDwdmModuleModel.getSlot() || iDwdmModuleModel.getRegenPeer() != iDwdmModuleModel2.getSlot()) {
                throw new Exception("Provisionable patchcords between transponder client ports must be part of the same regeneration group.");
            }
        }
        if (n2 == 123 && n3 == 123 && (VirtualLinksDirector.is10GTrunk(n4) && !VirtualLinksDirector.is10GTrunk(n5) || VirtualLinksDirector.is25GTrunk(n4) && !VirtualLinksDirector.is25GTrunk(n5))) {
            throw new Exception("Provisionable patchcords between transponder trunk ports must be the same rate.");
        }
        if (n2 == 123 && n3 == 122 || n2 == 122 && n3 == 123) {
            throw new Exception("Provisionable patchcords may not be created between transponder client and trunk ports.");
        }
        if (n2 == 123 && (n3 == 28 || n3 == 29 || n3 == 30 || n3 == 61) || n3 == 123 && (n2 == 28 || n2 == 29 || n2 == 30 || n2 == 61)) {
            throw new Exception("Provisionable patchcords may not be created between transponder trunk ports and SONET/SDH ports.");
        }
        if (VirtualLinksDirector.isOch(n2) && n3 == 122 || VirtualLinksDirector.isOch(n3) && n2 == 122) {
            throw new Exception("Provisionable patchcords may not be created between transponder client ports and OCH ports.");
        }
        if (VirtualLinksDirector.isOch(n2) && VirtualLinksDirector.isOch(n3) && iIpAddr.compareTo((Object)iIpAddr2) == 0) {
            throw new Exception("Provisionable patchcords are not a replacement for ANS;\nin this case, at least one end-point must be a transponder trunk port.");
        }
        if (n2 == 123 && n3 == 123) {
            iDwdmModuleModel2 = (IDwdmModuleModel)iEntityModel.getModuleModel();
            iDwdmModuleModel = (IDwdmModuleModel)iEntityModel2.getModuleModel();
            if (iDwdmModuleModel2.getWavelengthAsString() != null && iDwdmModuleModel.getWavelengthAsString() != null && !iDwdmModuleModel2.getWavelengthAsString().equals(iDwdmModuleModel.getWavelengthAsString())) {
                throw new Exception("Provisionable patchcords between transponder/muxponder trunk ports must use the same wavelength:\n" + iDwdmModuleModel2.getWavelengthAsString() + " is not equal to " + iDwdmModuleModel.getWavelengthAsString() + ".");
            }
        }
        if (VirtualLinksDirector.isOch(n2) && n3 == 123 || VirtualLinksDirector.isOch(n3) && n2 == 123) {
            if (iNodeModel == iNodeModel2) {
                throw new Exception(ErrorMsg.getString((EID)NEMC.EID_ERROR_VL_TXPMXP_MUXDEMUX_SAMENODE));
            }
            if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.OCH_TRAIL_PROVISIONING) && Feature.provides((INodeModel)iNodeModel2, (Feature)Feature.OCH_TRAIL_PROVISIONING)) {
                if (db.isFinestEnabled()) {
                    db.finest("DWDM trunk <-> Barolo client wlen check");
                }
                int n6 = VirtualLinksDirector.getWlen(iEntityModel);
                int n7 = VirtualLinksDirector.getWlen(iEntityModel2);
                if (db.isFinestEnabled()) {
                    db.finest("local wlen = " + Wavelength.getWavelengthStringFromWavelength(n6) + "remote wlen = " + Wavelength.getWavelengthStringFromWavelength(n7));
                }
                if (n6 != n7) {
                    string = Wavelength.getWavelengthStringFromWavelength(n6);
                    String string2 = Wavelength.getWavelengthStringFromWavelength(n7);
                    String string3 = null;
                    object = null;
                    n = 0;
                    if (n6 == 0 && n2 == 123) {
                        string = string + " /\"first tunable wavelength\"";
                        string3 = string2;
                        object = iEntityCellRenderer.getString((Object)iEntityModel, "slot ");
                        n = VirtualLinksDirector.attemptProvisionWlen(iEntityModel, n7) ? 1 : 0;
                    } else if (n7 == 0 && n3 == 123) {
                        string2 = string2 + " /\"first tunable wavelength\"";
                        string3 = string;
                        object = iEntityCellRenderer2.getString((Object)iEntityModel2, "slot ");
                        n = VirtualLinksDirector.attemptProvisionWlen(iEntityModel2, n6) ? 1 : 0;
                    }
                    if (n == 0) {
                        if (string3 != null && object != null) {
                            throw new Exception(ErrorMsg.getString((EID)NEMC.EID_ERROR_VL_TXPMXP_MUXDEMUX_WLEN_PARAM_4, (Object)string, (Object)string2, (Object)string3, (Object)object));
                        }
                        throw new Exception(ErrorMsg.getString((EID)NEMC.EID_ERROR_VL_TXPMXP_MUXDEMUX_WLEN_PARAM_2, (Object)string, (Object)string2));
                    }
                }
            } else if (db.isFinestEnabled()) {
                db.finest("DWDM trunk <-> Barolo client wlen check skipped due to feature check");
            }
        }
        if (VirtualLinksDirector.isSdh(n2) && VirtualLinksDirector.isOch(n3) || VirtualLinksDirector.isOch(n2) && VirtualLinksDirector.isSdh(n3)) {
            if (VirtualLinksDirector.isSdh(n2) && (n2 == 28 || n2 == 29)) {
                throw new Exception(ErrorMsg.getString((EID)NEMC.EID_ERROR_VL_OC3OC12_MUXDEMUX));
            }
            if (VirtualLinksDirector.isSdh(n3) && (n3 == 28 || n3 == 29)) {
                throw new Exception(ErrorMsg.getString((EID)NEMC.EID_ERROR_VL_OC3OC12_MUXDEMUX));
            }
            if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.OCH_TRAIL_PROVISIONING) && Feature.provides((INodeModel)iNodeModel2, (Feature)Feature.OCH_TRAIL_PROVISIONING)) {
                boolean bl2;
                if (db.isFinestEnabled()) {
                    db.finest("SONET/SDH trunk <-> Barolo client check");
                }
                IPortModel iPortModel = (IPortModel)iEntityModel;
                IPortModel iPortModel2 = (IPortModel)iEntityModel2;
                if (VirtualLinksDirector.isSdh(n2)) {
                    string = iEntityModel.getModuleModel();
                    object = (IOpticsChannelModel)((IPortModel)iEntityModel).getInterfaceModel();
                    bl2 = object.isWavelengthSupported();
                } else {
                    string = iEntityModel2.getModuleModel();
                    object = (IOpticsChannelModel)((IPortModel)iEntityModel2).getInterfaceModel();
                    bl2 = object.isWavelengthSupported();
                }
                boolean bl3 = string.isPreProvisioned();
                if (db.isFinestEnabled()) {
                    db.finest("isLcPreProvisioned = " + bl3);
                }
                if (bl2 || !bl3) {
                    if (db.isFinestEnabled()) {
                        db.finest("isWLenSupported = " + bl2);
                    }
                    int n8 = VirtualLinksDirector.getWlen(iEntityModel);
                    n = VirtualLinksDirector.getWlen(iEntityModel2);
                    if (db.isFinestEnabled()) {
                        db.finest("local wlen = " + Wavelength.getWavelengthStringFromWavelength(n8) + "remote wlen = " + Wavelength.getWavelengthStringFromWavelength(n));
                    }
                    if (n8 != n) {
                        throw new Exception(ErrorMsg.getString((EID)NEMC.EID_ERROR_VL_OCN_MUXDEMUX_WLEN_PARAM_2, (Object)Wavelength.getWavelengthStringFromWavelength(n8), (Object)Wavelength.getWavelengthStringFromWavelength(n)));
                    }
                } else {
                    if (!bl2 && !bl3) {
                        throw new Exception(ErrorMsg.getString((EID)NEMC.EID_ERROR_VL_NON_COLORED_OCN));
                    }
                    if (db.isFinestEnabled()) {
                        db.finest("SONET/SDH trunk <-> Barolo client wlen check skipped due to pre-provisioned line card");
                    }
                    if (bl && bl3) {
                        throw new WarningMessageException(ErrorMsg.getString((EID)NEMC.WID_VL_OCN_PREPROV_WLEN_SKIPPED));
                    }
                }
            } else if (db.isFinestEnabled()) {
                db.finest("SONET/SDH trunk <-> Barolo client wlen check skipped due to feature check");
            }
        }
        if (VirtualLinksDirector.isSdh(n2) && VirtualLinksDirector.isSdh(n3)) {
            if (n2 == 28 || n2 == 29 || n3 == 28 || n3 == 29) {
                throw new Exception(ErrorMsg.getString((EID)NEMC.EID_ERROR_OC3OC12_MUXDEMUX));
            }
            if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.OCH_TRAIL_PROVISIONING) && Feature.provides((INodeModel)iNodeModel2, (Feature)Feature.OCH_TRAIL_PROVISIONING)) {
                if (db.isFinestEnabled()) {
                    db.finest("SONET/SDH trunk <-> SONET/SDH trunk check");
                }
                IPortModel iPortModel = (IPortModel)iEntityModel;
                IPortModel iPortModel3 = (IPortModel)iEntityModel2;
                IOpticsChannelModel iOpticsChannelModel = (IOpticsChannelModel)((IPortModel)iEntityModel).getInterfaceModel();
                boolean bl4 = iOpticsChannelModel.isWavelengthSupported();
                iOpticsChannelModel = (IOpticsChannelModel)((IPortModel)iEntityModel2).getInterfaceModel();
                boolean bl5 = iOpticsChannelModel.isWavelengthSupported();
                boolean bl6 = iEntityModel.getModuleModel().isPreProvisioned();
                boolean bl7 = iEntityModel2.getModuleModel().isPreProvisioned();
                if (db.isFinestEnabled()) {
                    db.finest("isLcPreProvisioned = " + bl6 + "isRemoteLcPreProvisioned = " + bl7);
                }
                if (!bl6 && !bl7) {
                    if (db.isFinestEnabled()) {
                        db.finest("isWLenSupported = " + bl4 + "isRemoteWLenSupported = " + bl5);
                    }
                    if (!bl4 && !bl5) {
                        throw new Exception(ErrorMsg.getString((EID)NEMC.EID_ERROR_VL_BOTH_NON_COLORED_OCN));
                    }
                    if (!bl4) {
                        throw new Exception(ErrorMsg.getString((EID)NEMC.EID_ERROR_VL_NON_COLORED_OCN_OCN));
                    }
                    if (!bl5) {
                        throw new Exception(ErrorMsg.getString((EID)NEMC.EID_ERROR_VL_NON_COLORED_OCN_OCN));
                    }
                    int n9 = VirtualLinksDirector.getWlen(iEntityModel);
                    int n10 = VirtualLinksDirector.getWlen(iEntityModel2);
                    if (db.isFinestEnabled()) {
                        db.finest("local wlen = " + Wavelength.getWavelengthStringFromWavelength(n9) + "remote wlen = " + Wavelength.getWavelengthStringFromWavelength(n10));
                    }
                    if (n9 != n10) {
                        throw new Exception(ErrorMsg.getString((EID)NEMC.EID_ERROR_VL_OCN_MUXDEMUX_WLEN_PARAM_2, (Object)Wavelength.getWavelengthStringFromWavelength(n9), (Object)Wavelength.getWavelengthStringFromWavelength(n10)));
                    }
                } else {
                    if (db.isFinestEnabled()) {
                        db.finest("SONET/SDH trunk <-> Barolo client wlen check skipped due to pre-provisioned line card");
                    }
                    if (bl) {
                        throw new WarningMessageException(ErrorMsg.getString((EID)NEMC.WID_VL_OCN_PREPROV_WLEN_SKIPPED));
                    }
                }
            } else if (db.isFinestEnabled()) {
                db.finest("SONET/SDH trunk <-> SONET client check skipped due to feature check");
            }
        }
    }

    private static final boolean isSdh(int n) {
        return n == 28 || n == 29 || n == 30 || n == 61;
    }

    private static final int getWlen(IEntityModel iEntityModel) throws NoSuchInterface, WrongInterfaceType {
        IPortModel iPortModel = (IPortModel)iEntityModel;
        IOpticsChannelModel iOpticsChannelModel = (IOpticsChannelModel)iPortModel.getInterfaceModel();
        int n = iOpticsChannelModel.getActualWaveLength();
        if (n == 0) {
            if (db.isFineEnabled()) {
                db.fine("Using expected wlen for local port");
            }
            n = iOpticsChannelModel.getExpectedWaveLength();
        } else if (db.isFineEnabled()) {
            db.fine("Using expected wlen for local port");
        }
        return n;
    }

    private static final boolean attemptProvisionWlen(IEntityModel iEntityModel, int n) {
        boolean bl;
        block6: {
            bl = false;
            db.fine("attemptProvisionWlen(" + iEntityModel + ", " + n + ")");
            try {
                IOpticsChannelModel iOpticsChannelModel = (IOpticsChannelModel)((IPortModel)iEntityModel).getInterfaceModel();
                iOpticsChannelModel.setWaveLength(n);
                db.finest("\tprovisioning the wavelength succeeded.");
                bl = true;
            }
            catch (NoSuchInterface noSuchInterface) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                }
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
            }
            catch (DetailedConfigError detailedConfigError) {
                if (!db.on()) break block6;
                SDebug.printStackTrace((Throwable)detailedConfigError);
            }
        }
        return bl;
    }

    public class NodeComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            if (object instanceof INodeModel) {
                if (object2 instanceof INodeModel) {
                    INodeModel iNodeModel = (INodeModel)object;
                    INodeModel iNodeModel2 = (INodeModel)object2;
                    try {
                        IIpAddr iIpAddr = iNodeModel.getIpConfig().getIpAddress();
                        IIpAddr iIpAddr2 = iNodeModel2.getIpConfig().getIpAddress();
                        if (iIpAddr != null && iIpAddr2 != null) {
                            try {
                                return iIpAddr.compareTo((Object)iIpAddr2);
                            }
                            catch (ClassCastException classCastException) {
                                return -iIpAddr2.compareTo((Object)iIpAddr);
                            }
                        }
                        if (iIpAddr != null) {
                            return 1;
                        }
                        return -1;
                    }
                    catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                        if (iNodeModel == iNodeModel2) {
                            return 0;
                        }
                        return 1;
                    }
                }
                return 1;
            }
            return -1;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof NodeComparator) {
                NodeComparator nodeComparator = (NodeComparator)object;
                bl = nodeComparator == this;
            }
            return bl;
        }
    }

    protected class VlinkHolder
    extends Model
    implements IVirtualLinkModel {
        private short origVLID;
        private IIpAddr origNode;
        private IEntityModel origEntity;
        private short termVLID;
        private IIpAddr termNode;
        private IEntityModel termEntity;
        private short termShelfId;
        private short origShelfId;

        public VlinkHolder(short s, IIpAddr iIpAddr, IEntityModel iEntityModel, short s2, IIpAddr iIpAddr2, IEntityModel iEntityModel2) {
            super(db);
            this.origVLID = s;
            this.origNode = iIpAddr;
            this.origEntity = iEntityModel;
            this.termVLID = s2;
            this.termNode = iIpAddr2;
            this.termEntity = iEntityModel2;
        }

        public short getOrigVLID() {
            return this.origVLID;
        }

        public IIpAddr getOrigNode() {
            return this.origNode;
        }

        public IEntityModel getOrigEntity() {
            return this.origEntity;
        }

        public IEntityModel getTermEntity() {
            return this.termEntity;
        }

        public IIpAddr getTermNode() {
            return this.termNode;
        }

        public short getTermVLID() {
            return this.termVLID;
        }

        public short getOrigShelfId() {
            if (this.origEntity != null && Feature.provides((INodeModel)this.origEntity.getNodeModel(), (Feature)Feature.MULTISHELF) && this.origEntity.getNodeModel().isMultishelf()) {
                return (short)this.origEntity.getShelfId();
            }
            return 1;
        }

        public short getTermShelfId() {
            if (this.termEntity != null && Feature.provides((INodeModel)this.termEntity.getNodeModel(), (Feature)Feature.MULTISHELF)) {
                return (short)this.termEntity.getShelfId();
            }
            return 1;
        }

        public boolean equals(Object object) {
            return this.compareTo(object) == 0;
        }

        public int compareTo(Object object) {
            if (object != null && object instanceof IVirtualLinkModel) {
                IVirtualLinkModel iVirtualLinkModel = (IVirtualLinkModel)object;
                if (this.db.isFineEnabled()) {
                    this.db.fine("compareTo: this is " + this + "          other is " + iVirtualLinkModel);
                }
                if (iVirtualLinkModel.getOrigVLID() == this.origVLID) {
                    if (iVirtualLinkModel.getOrigNode().compareTo((Object)this.origNode) == 0) {
                        if (iVirtualLinkModel.getOrigEntity() != null && iVirtualLinkModel.getOrigEntity().equals(this.origEntity) || iVirtualLinkModel.getOrigEntity() == null && this.origEntity == null) {
                            if (iVirtualLinkModel.getTermVLID() == this.origVLID) {
                                if (iVirtualLinkModel.getTermNode().compareTo((Object)this.termNode) == 0) {
                                    if (iVirtualLinkModel.getTermEntity() == null && this.termEntity == null || iVirtualLinkModel.getTermEntity().equals(this.termEntity)) {
                                        return 0;
                                    }
                                    if (iVirtualLinkModel.getTermEntity() != null && this.termEntity == null) {
                                        return -1;
                                    }
                                    return 1;
                                }
                                return iVirtualLinkModel.getTermNode().compareTo((Object)this.termNode);
                            }
                            return new Integer(this.termVLID).compareTo(new Integer(iVirtualLinkModel.getTermVLID()));
                        }
                        if (iVirtualLinkModel.getOrigEntity() != null && this.origEntity == null) {
                            return -1;
                        }
                        return 1;
                    }
                    return iVirtualLinkModel.getOrigNode().compareTo((Object)this.origNode);
                }
                return new Integer(this.origVLID).compareTo(new Integer(iVirtualLinkModel.getOrigVLID()));
            }
            return 1;
        }

        public void swap() {
            if (VirtualLinksDirector.shouldSwap(this.origEntity, this.termEntity)) {
                short s = this.origVLID;
                IIpAddr iIpAddr = this.origNode;
                IEntityModel iEntityModel = this.origEntity;
                short s2 = this.origShelfId;
                this.origVLID = this.termVLID;
                this.origNode = this.termNode;
                this.origEntity = this.termEntity;
                this.origShelfId = this.termShelfId;
                this.termVLID = s;
                this.termNode = iIpAddr;
                this.termEntity = iEntityModel;
                this.termShelfId = s2;
            }
        }

        public String toString() {
            IEntityCellRenderer iEntityCellRenderer;
            INodeModel iNodeModel;
            StringBuffer stringBuffer = new StringBuffer("[");
            stringBuffer.append(Short.toString(this.origVLID) + ", ");
            stringBuffer.append(VirtualLinksDirector.ipToString(this.origNode) + ", ");
            if (this.origEntity != null) {
                iNodeModel = this.origEntity.getNodeModel();
                iEntityCellRenderer = ElementFactoryFinder.getElementFactory(iNodeModel).createEntityCellRenderer(this.origEntity.getModuleModel());
                stringBuffer.append(iEntityCellRenderer.getString((Object)this.origEntity, "slot ") + ", ");
            } else {
                stringBuffer.append("<null entity>, ");
            }
            stringBuffer.append(Short.toString(this.termVLID) + ", ");
            stringBuffer.append(VirtualLinksDirector.ipToString(this.termNode) + ", ");
            if (this.termEntity != null) {
                iNodeModel = this.termEntity.getNodeModel();
                iEntityCellRenderer = ElementFactoryFinder.getElementFactory(iNodeModel).createEntityCellRenderer(this.termEntity.getModuleModel());
                stringBuffer.append(iEntityCellRenderer.getString((Object)this.termEntity, "slot ") + "]");
            } else {
                stringBuffer.append("<null entity>]");
            }
            return stringBuffer.toString();
        }

        public void update(Observable observable, Object object) {
        }
    }

    protected static class VlinkDebug
    extends SDebug {
        public VlinkDebug(String string) {
            super(string);
        }

        public final void dumpNodes() {
            db.println("Known Nodes:");
            INodeModel[] iNodeModelArray = instance.getKnownNodes();
            for (int i = 0; i < iNodeModelArray.length; ++i) {
                db.println("\t" + iNodeModelArray[i].getName());
            }
        }

        public final void dumpLinks() {
            db.println("Known Links:");
            Set set = instance.getVirtualLinks();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                db.println("\t" + (IVirtualLinkModel)iterator.next());
            }
        }
    }
}

