/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.blsr;

import cerent.cms.model.blsr.BlsrRingManager;
import cerent.cms.model.blsr.BlsrRingModel;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.SDebug;
import cerent.util.UObservable;
import cerent.util.gui.row.AbstractRowDataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;

public class BlsrRingDataSource
extends AbstractRowDataSource {
    private BlsrRingCreationObserver creationObserver = new BlsrRingCreationObserver();
    private BlsrRingChangeObserver changeObserver = new BlsrRingChangeObserver();
    private BlsrRingManager ringManager;
    private List rings;
    private static final String className = "BlsrRingDataSource";
    private static final SDebug db = new SDebug("BlsrRingDataSource");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlsrRingDataSource() {
        Object object;
        BlsrRingModel blsrRingModel = null;
        this.rings = Collections.synchronizedList(new ArrayList());
        this.ringManager = BlsrRingManager.instance();
        UObservable.addObserver((Object)((Object)this.ringManager.getBlsrCreationNotifier()), (Object)this.creationObserver, (String)className);
        Set set = this.ringManager.getBlsrRingModels();
        Object object2 = set;
        synchronized (object2) {
            object = set.iterator();
            while (object.hasNext()) {
                blsrRingModel = (BlsrRingModel)object.next();
                UObservable.addObserver((Object)blsrRingModel.getStateChangeNotifier(), (Object)this.changeObserver, (String)className);
                UObservable.addObserver((Object)blsrRingModel.getReversionChangeNotifier(), (Object)this.changeObserver, (String)className);
                this.rings.add(blsrRingModel);
            }
        }
        if (db.on()) {
            db.println("BlsrRingDataSource initialized with " + this.rings.size() + " rings.");
            object2 = this.rings.iterator();
            while (object2.hasNext()) {
                object = (BlsrRingModel)object2.next();
                db.println("\t" + object);
            }
        }
    }

    public Collection getAllObjects() {
        return this.rings;
    }

    public Object getObjectAtRow(int n) {
        BlsrRingModel blsrRingModel = null;
        if (n < this.rings.size() && n >= 0) {
            blsrRingModel = (BlsrRingModel)this.rings.get(n);
        }
        return blsrRingModel;
    }

    public int getRowCount() {
        return this.rings.size();
    }

    public synchronized void destroy() {
        UObservable.deleteObserver((Object)((Object)this.ringManager.getBlsrCreationNotifier()), (Object)this.creationObserver, (String)className);
        Iterator iterator = this.rings.iterator();
        while (iterator.hasNext()) {
            UObservable.deleteObserver((Object)((BlsrRingModel)iterator.next()).getStateChangeNotifier(), (Object)this.changeObserver, (String)className);
            UObservable.deleteObserver((Object)((BlsrRingModel)iterator.next()).getReversionChangeNotifier(), (Object)this.changeObserver, (String)className);
        }
    }

    protected void fireBulkRowAdded(int n, Object object) {
        super.fireBulkRowAdded(n, object);
        this.fireBulkUpdateView();
    }

    protected void fireBulkRowDeleted(int n, Object object) {
        super.fireBulkRowDeleted(n, object);
        this.fireBulkUpdateView();
    }

    protected void fireBulkRowUpdated(int n, Object object, Object object2) {
        super.fireBulkRowUpdated(n, object, object2);
        this.fireBulkUpdateView();
    }

    class BlsrRingChangeObserver
    implements Observer,
    IObserver {
        BlsrRingChangeObserver() {
        }

        public void update(Observable observable, Object object) {
            this._update(observable, object);
        }

        public void update(IObservable iObservable, Object object) {
            this._update(iObservable, object);
        }

        private synchronized void _update(Object object, Object object2) {
            if (db.on()) {
                db.println("[BlsrRingChangeObserver:_update] called from");
                db;
                SDebug.printStackTrace((Throwable)new Exception());
            }
            BlsrRingModel blsrRingModel = (BlsrRingModel)object2;
            db.fine("[BlsrRingChangeObserver] Ring: " + blsrRingModel.getRingName() + " CHANGED");
            int n = blsrRingModel.getState();
            int n2 = BlsrRingDataSource.this.rings.indexOf(blsrRingModel);
            if (n2 >= 0 && n2 < BlsrRingDataSource.this.rings.size()) {
                switch (n) {
                    case 666: {
                        BlsrRingDataSource.this.rings.remove(blsrRingModel);
                        if (db.on()) {
                            db.println("BlsrRingDataSource rings size decremented to" + BlsrRingDataSource.this.rings.size() + " \t" + blsrRingModel);
                        }
                        BlsrRingDataSource.this.fireBulkRowDeleted(n2, blsrRingModel);
                        UObservable.deleteObserver((Object)blsrRingModel.getReversionChangeNotifier(), (Object)BlsrRingDataSource.this.changeObserver, (String)BlsrRingDataSource.className);
                        UObservable.deleteObserver((Object)blsrRingModel.getReversionChangeNotifier(), (Object)BlsrRingDataSource.this.changeObserver, (String)BlsrRingDataSource.className);
                        if (!db.on()) break;
                        db.println("[BlsrRingChangeObserver] fireBulkRowDeleted(" + n2 + ", " + blsrRingModel + ") called.");
                        break;
                    }
                    default: {
                        BlsrRingModel blsrRingModel2 = (BlsrRingModel)BlsrRingDataSource.this.rings.get(n2);
                        BlsrRingDataSource.this.rings.set(n2, blsrRingModel);
                        BlsrRingDataSource.this.fireBulkRowUpdated(n2, blsrRingModel2, blsrRingModel);
                        if (!db.on()) break;
                        db.println("[BlsrRingChangeObserver] fireBulkRowUpdated(" + n2 + ", old=" + blsrRingModel2 + ", new=" + blsrRingModel + ") called.");
                    }
                }
            }
        }
    }

    class BlsrRingCreationObserver
    implements Observer,
    IObserver {
        BlsrRingCreationObserver() {
        }

        public void update(Observable observable, Object object) {
            this._update(observable, object);
        }

        public void update(IObservable iObservable, Object object) {
            this._update(iObservable, object);
        }

        private synchronized void _update(Object object, Object object2) {
            int n = -1;
            BlsrRingModel blsrRingModel = (BlsrRingModel)object2;
            if (db.on()) {
                db.println("[BlsrRingCreationObserver] BlsrRingDataSource rings size incremented to " + BlsrRingDataSource.this.rings.size() + " \t" + blsrRingModel);
            }
            UObservable.addObserver((Object)blsrRingModel.getStateChangeNotifier(), (Object)BlsrRingDataSource.this.changeObserver, (String)BlsrRingDataSource.className);
            UObservable.addObserver((Object)blsrRingModel.getReversionChangeNotifier(), (Object)BlsrRingDataSource.this.changeObserver, (String)BlsrRingDataSource.className);
            n = BlsrRingDataSource.this.rings.size() - 1;
            BlsrRingDataSource.this.rings.add(blsrRingModel);
            if (n > -1) {
                BlsrRingDataSource.this.fireBulkRowAdded(n, blsrRingModel);
            }
            if (db.on()) {
                db.println(BlsrRingDataSource.className + blsrRingModel.getRingName() + " CREATED.");
                db.println("fireBulkRowAdded(" + n + ", " + blsrRingModel + ") called.");
            }
        }
    }
}

