/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.blsr;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.BlsrSpanSwitched;
import cerent.cms.model.Busy;
import cerent.cms.model.DuplicateNodeId;
import cerent.cms.model.DuplicateRingId;
import cerent.cms.model.Feature;
import cerent.cms.model.IBlsrModel;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.IElementModels;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.ILinkModel;
import cerent.cms.model.ILinkPhysicalType;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IReversionMode;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.Model;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModel;
import cerent.cms.model.blsr.BlsrCompatBundle;
import cerent.cms.model.blsr.BlsrNode;
import cerent.cms.model.blsr.BlsrProvisionAgent;
import cerent.cms.model.blsr.BlsrProvisionException;
import cerent.cms.model.blsr.BlsrRingIdInUseException;
import cerent.cms.model.blsr.BlsrRingInfo;
import cerent.cms.model.blsr.BlsrRingManager;
import cerent.cms.model.blsr.BlsrSpan;
import cerent.cms.model.blsr.BlsrUnprovisionAgent;
import cerent.cms.model.blsr.BlsrUnprovisionException;
import cerent.cms.model.blsr.BlsrUpgradeAgent;
import cerent.cms.model.blsr.BlsrUpgradeException;
import cerent.cms.model.blsr.CircuitOnHighAndLowHOException;
import cerent.cms.model.blsr.ExistingPCAException;
import cerent.cms.model.blsr.ExistingProtectionSwitchException;
import cerent.cms.model.blsr.IncompatibleBlsrNodesException;
import cerent.cms.model.blsr.InconsistentMediumTypeException;
import cerent.cms.model.blsr.InvalidProtectPortsSpecifiedException;
import cerent.cms.model.blsr.InvalidRingNameException;
import cerent.cms.model.blsr.LockOutSpanException;
import cerent.cms.model.blsr.MultipleSpansInCardException;
import cerent.cms.model.blsr.NodeUnreachableException;
import cerent.cms.model.blsr.OspfAreaException;
import cerent.cms.model.blsr.ParallelSpanAlreadyPresentException;
import cerent.cms.model.blsr.PathSelectorOnSpanException;
import cerent.cms.model.blsr.PortsInProtectionGroupException;
import cerent.cms.model.blsr.PortsNotEnabledException;
import cerent.cms.model.blsr.PortsNotSpecifiedException;
import cerent.cms.model.blsr.PortsSdccTerminatedException;
import cerent.cms.model.blsr.PortsWithOrderwireException;
import cerent.cms.model.blsr.RingTooLargeException;
import cerent.cms.model.blsr.SpanAlreadyInBlsrException;
import cerent.cms.model.blsr.SpanNoLongerPresentException;
import cerent.cms.model.blsr.TimingReferenceException;
import cerent.cms.model.blsr.TooManyBlsrException;
import cerent.cms.model.blsr.TopoUpgradeNotSupportedException;
import cerent.cms.model.blsr.WigglingCircuitException;
import cerent.cms.model.circuits.SpanRow;
import cerent.cms.model.vf.AbstractVersionedFeature;
import cerent.cms.model.vf.Version;
import cerent.cms.ncp.IInServiceUpgradeMgr;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitSpan;
import cerent.cms.ncp.InServiceUpgradeError;
import cerent.cms.ncp.InServiceUpgradeMgr;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.cms.topo.Topology;
import cerent.util.HoLoComparator;
import cerent.util.HoLoFactory;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.UObservable;
import cerent.util.job.IJobControl;
import cerent.util.job.IJobGroupListener;
import cerent.util.job.JobController;
import cerent.util.job.JobControllerFactory;
import cerent.util.job.JobGroup;
import cerent.util.job.JobStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class BlsrRingModel
extends Model {
    BlsrRingInfo ringInfo;
    public static final short RING_ID_CHANGED = 1;
    public static final short INCOMPLETE = 2;
    public static final short COMPLETE = 3;
    public static final short EDITING = 4;
    public static final int CREATING = 5;
    public static final int DELETING = 6;
    public static final int UPSR2BLSR_CONVERSION = 7;
    public static final int DEAD = 666;
    public static final Long OSPF_AREA_INCONSISTENT = new Long(-1L);
    private static final int INITIAL_STATE = 0;
    private static final int ADD = 1;
    private static final int ADD_DUPLICATE_NODE_ID = 2;
    private static final int ADD_DISCOVERED = 3;
    private static final int REMOVE = 4;
    private static final int REMOVE_DISCOVERED = 5;
    private static final int REMOVE_DISCOVERED_UNREACHABLE = 6;
    private static final int DELETE = 7;
    private static final int DESTROY = 8;
    private static final int UNPROVISION = 9;
    private static final int UPDATE = 10;
    private static final String INCOMPLETE_DISPLAY = "INCOMPLETE";
    private static final String COMPLETE_DISPLAY = "COMPLETE";
    private static final String EDITING_DISPLAY = "EDITING";
    private static final String CREATING_DISPLAY = "CREATING";
    private static final String UNKNOWN_DISPLAY = "UNKNOWN";
    private static final String DELETING_DISPLAY = "DELETING";
    private static final String DEAD_DISPLAY = "DEAD";
    private static final String UPSR2BLSR_CONVERSION_DISPLAY = "UPSR2BLSR_CONVERSION";
    private int state;
    private int stateReason;
    private int[] oldState;
    private int[] oldStateReason;
    private int history;
    private BlsrRingReversionChangeNotifier reversionChangeNotifier;
    private BlsrRingStateChangeNotifier stateChangeNotifier;
    private BlsrRingNodeAddedNotifier nodeAddedNotifier;
    private BlsrRingNodeRemovedNotifier nodeRemovedNotifier;
    private BlsrRingSpanAddedNotifier spanAddedNotifier;
    private BlsrRingSpanRemovedNotifier spanRemovedNotifier;
    private ProtectionSwitchClearNotifier switchClearNotifier;
    private BlsrNodeChangeObserver nodeObserver;
    private BlsrSpanDeathObserver spanObserver;
    private ProtectionSwitchClearObserver switchClearObserver;
    private Set blsrNodes;
    private Map unprovisionedBlsrNodes = new HashMap();
    private SortedMap unBlsrableNodes = new TreeMap(new Comparator(){

        public int compare(Object object, Object object2) {
            return ((INodeModel)object).getName().compareTo(((INodeModel)object2).getName());
        }
    });
    private Set blsrSpans;
    private static final String className = "BlsrRingModel";
    private static SDebug db = new SDebug("BlsrRingModel");
    private BRMDebug brmdb;
    private static final String INSTANCE_DEBUG_PREF = "BlsrRingModelHelper_";
    private BlsrSpan[] spanCandidates;
    private short nodeId = 0;
    private ILinkPhysicalType ringSpeed = null;
    private Long ospfArea = null;
    private String blsrTerm;
    private IInServiceUpgradeMgr upsr2BlsrUpgradeMgr;

    private IHoNum getUpperHalfHoNum(int n) {
        int n2 = this.ringSpeed.getStsCapacity();
        int n3 = n2 / 2 + 1;
        return n3 * 2 < n2 ? null : HoLoFactory.idlSts2HoNum(n, n3);
    }

    private IHoNum getUpperHalfHoNum(INetElement iNetElement) {
        return this.getUpperHalfHoNum(iNetElement.getFramingType());
    }

    private IHoNum getUpperHalfHoNum(INetLink iNetLink) {
        return this.getUpperHalfHoNum(iNetLink.getSrc());
    }

    private IHoNum getUpperHalfHoNum(INodeModel iNodeModel) {
        return this.getUpperHalfHoNum(iNodeModel.getFramingType());
    }

    private IHoNum getUpperHalfHoNum(BlsrNode blsrNode) {
        return this.getUpperHalfHoNum(blsrNode.getNodeModel());
    }

    private IHoNum getUpperHalfHoNum(BlsrSpan blsrSpan) {
        return !blsrSpan.isProtectSpan() ? this.getUpperHalfHoNum(blsrSpan.getOriginalLink()) : this.getUpperHalfHoNum(blsrSpan.getEastSide());
    }

    BlsrRingModel(BlsrRingInfo blsrRingInfo, List list, int n) throws IllegalArgumentException {
        super(db);
        if (n != 5 && n != 2 && n != 7) {
            throw new IllegalArgumentException("state must be either CREATING or INCOMPLETE or UPSR2BLSR_CONVERSION");
        }
        this.ringInfo = blsrRingInfo;
        this.blsrTerm = blsrRingInfo.getTDMTerminology().getRingTerms(1);
        this.state = n;
        this.stateReason = 0;
        this.oldState = new int[3];
        Arrays.fill(this.oldState, -1);
        this.oldStateReason = new int[3];
        Arrays.fill(this.oldStateReason, -1);
        this.history = 0;
        this.blsrNodes = Collections.synchronizedSet(new HashSet());
        this.blsrSpans = Collections.synchronizedSet(new HashSet());
        if (n == 7) {
            try {
                this.upsr2BlsrUpgradeMgr = InServiceUpgradeMgr.createInServiceUpgradeMgr(1);
            }
            catch (InServiceUpgradeError inServiceUpgradeError) {
                db.println("BlsrRingModel: Cannot create UPSR to BLSR Upgrade Manager");
            }
        }
        this.ringSpeed = this.getRingSpeed();
        if (n == 2) {
            this.stateChangeNotifier = new BlsrRingStateChangeNotifier();
            this.reversionChangeNotifier = new BlsrRingReversionChangeNotifier();
            this.nodeAddedNotifier = new BlsrRingNodeAddedNotifier();
            this.nodeRemovedNotifier = new BlsrRingNodeRemovedNotifier();
            this.spanAddedNotifier = new BlsrRingSpanAddedNotifier();
            this.spanRemovedNotifier = new BlsrRingSpanRemovedNotifier();
            this.nodeObserver = new BlsrNodeChangeObserver();
            this.spanObserver = new BlsrSpanDeathObserver();
            this.switchClearNotifier = new ProtectionSwitchClearNotifier();
            this.switchClearObserver = new ProtectionSwitchClearObserver();
        }
        if (n == 5 || n == 7) {
            this.spanCandidates = this.discoverBlsrSpanCandidatesForNewBlsrRing(list);
        }
        this.brmdb = new BRMDebug(INSTANCE_DEBUG_PREF + this.getRingName(), this);
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("(Ring " + this.ringInfo.getRingName());
        stringBuffer.append(" State " + this.getStateString() + " " + this.state + ":" + this.stateReason);
        for (int i = 0; i < this.oldState.length; ++i) {
            n = this.oldState.length + this.history - i - 1;
            if (this.oldState[n %= this.oldState.length] == -1) break;
            stringBuffer.append((i == 0 ? " History " : ", ") + this.oldState[n] + ":" + this.oldStateReason[n]);
        }
        BlsrNode[] blsrNodeArray = this.getBlsrNodes();
        stringBuffer.append("\n\t[" + blsrNodeArray.length + " Nodes=\n");
        for (n = 0; n < blsrNodeArray.length; ++n) {
            stringBuffer.append("\t" + blsrNodeArray[n]);
            if (n + 1 >= blsrNodeArray.length) continue;
            stringBuffer.append("\n");
        }
        stringBuffer.append("]");
        BlsrSpan[] blsrSpanArray = this.getWorkingBlsrSpans();
        if (blsrSpanArray.length > 0) {
            stringBuffer.append("\n\t[" + blsrSpanArray.length + " Spans=\n");
            for (int i = 0; i < blsrSpanArray.length; ++i) {
                stringBuffer.append("\t" + blsrSpanArray[i]);
                if (i + 1 >= blsrSpanArray.length) continue;
                stringBuffer.append("\n");
            }
            stringBuffer.append("]");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private BlsrSpan[] discoverBlsrSpanCandidatesForNewBlsrRing(List list) {
        INodeModel[] iNodeModelArray = list == null ? this.getAllNodes() : this.getTopologyNodes(list);
        iNodeModelArray = this.getInitedNodes(iNodeModelArray);
        iNodeModelArray = this.getNetBlsrWizNodes(iNodeModelArray);
        iNodeModelArray = this.getNodesWithoutTooManyBlsrs(iNodeModelArray);
        if (this.ringInfo.isFourFiber()) {
            iNodeModelArray = this.get4FiberCapableNodes(iNodeModelArray);
        }
        BlsrSpan[] blsrSpanArray = this.getAllSpansOfRightSpeed();
        iNodeModelArray = this.getNodesInLoops(iNodeModelArray, blsrSpanArray, BedEliminationReason.NOT_ENOUGH_SPANS_OF_RIGHT_SPEED, null);
        HashSet hashSet = new HashSet();
        if (this.ringInfo.isFourFiber()) {
            iNodeModelArray = this.getNodesWithEnoughProtectPorts(iNodeModelArray);
            blsrSpanArray = BlsrRingModel.getAllSpansWithValidEndpoints(blsrSpanArray, iNodeModelArray);
            iNodeModelArray = this.getNodesInLoops(iNodeModelArray, blsrSpanArray, BedEliminationReason.NOT_IN_LOOP, null);
            blsrSpanArray = BlsrRingModel.getAllSpansWithValidEndpoints(blsrSpanArray, iNodeModelArray);
        }
        blsrSpanArray = this.getAllSpansWithOspfAreasForBlsr(blsrSpanArray, hashSet);
        iNodeModelArray = this.getNodesInLoops(iNodeModelArray, blsrSpanArray, BedEliminationReason.INVALID_OSPF_AREA, hashSet);
        hashSet = new HashSet();
        if (!this.getBlsrRingInfo().isFourFiber()) {
            blsrSpanArray = this.getAllSpansWithoutCircuitsThatSpanHighHOandLowHO(blsrSpanArray, hashSet);
            iNodeModelArray = this.getNodesInLoops(iNodeModelArray, blsrSpanArray, BedEliminationReason.HIGH_LOW_HO_CIRCUIT, hashSet);
            hashSet = new HashSet();
        }
        blsrSpanArray = BlsrRingModel.getAllSpansNotParticipatingInABlsr(blsrSpanArray, hashSet);
        iNodeModelArray = this.getNodesInLoops(iNodeModelArray, blsrSpanArray, BedEliminationReason.NEEDED_SPAN_IN_BLSR, hashSet);
        hashSet = new HashSet();
        blsrSpanArray = BlsrRingModel.getAllSpansWithoutProtection(blsrSpanArray, hashSet);
        iNodeModelArray = this.getNodesInLoops(iNodeModelArray, blsrSpanArray, BedEliminationReason.OPTICAL_PROTECTION_GROUP, hashSet);
        hashSet = new HashSet();
        blsrSpanArray = BlsrRingModel.getAllSpansOfConsistentMediumType(blsrSpanArray, hashSet);
        iNodeModelArray = this.getNodesInLoops(iNodeModelArray, blsrSpanArray, BedEliminationReason.INCONSISTENT_MEDIUM_TYPE, hashSet);
        hashSet = new HashSet();
        if (this.state != 7) {
            blsrSpanArray = BlsrRingModel.getAllSpansWithOutPathSelectors(blsrSpanArray, hashSet);
            iNodeModelArray = this.getNodesInLoops(iNodeModelArray, blsrSpanArray, BedEliminationReason.PATH_SELECTOR, hashSet);
            hashSet = new HashSet();
        }
        iNodeModelArray = this.getNodesInLoops(iNodeModelArray, blsrSpanArray, BedEliminationReason.WIGGLING_CIRCUITS, hashSet);
        hashSet = new HashSet();
        blsrSpanArray = BlsrRingModel.getAllSpansWithValidEndpoints(blsrSpanArray, iNodeModelArray);
        iNodeModelArray = this.getNodesInLoops(iNodeModelArray, blsrSpanArray, BedEliminationReason.NOT_IN_LOOP, hashSet);
        blsrSpanArray = BlsrRingModel.getAllSpansWithValidEndpoints(blsrSpanArray, iNodeModelArray);
        if (db.on()) {
            db.println("The nodes eliminated by BED are: ");
            db.println(this.unBlsrableNodes.toString());
        }
        return blsrSpanArray;
    }

    private static INetElement[] toElementArray(Collection collection) {
        return collection.toArray(new INetElement[collection.size()]);
    }

    private static INodeModel[] toNodeArray(Collection collection) {
        return collection.toArray(new INodeModel[collection.size()]);
    }

    private static ITdmPortModel[] toPortArray(Collection collection) {
        return collection.toArray(new ITdmPortModel[collection.size()]);
    }

    private static IBlsrModel[] toBlsrArray(Collection collection) {
        return collection.toArray(new IBlsrModel[collection.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BlsrSpan[] toBlsrSpanArray(Collection collection) {
        Collection collection2 = collection;
        synchronized (collection2) {
            return collection.toArray(new BlsrSpan[collection.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BlsrNode[] toBlsrNodeArray(Collection collection) {
        Collection collection2 = collection;
        synchronized (collection2) {
            return collection.toArray(new BlsrNode[collection.size()]);
        }
    }

    private static INetLink[] toLinkArray(Collection collection) {
        return collection.toArray(new INetLink[collection.size()]);
    }

    private static BlsrCompatBundle[] toBundleArray(Collection collection) {
        return collection.toArray(new BlsrCompatBundle[collection.size()]);
    }

    private INodeModel[] get4FiberCapableNodes(INodeModel[] iNodeModelArray) {
        ArrayList<INodeModel> arrayList = new ArrayList<INodeModel>();
        for (int i = 0; iNodeModelArray != null && i < iNodeModelArray.length; ++i) {
            Version version = iNodeModelArray[i].getVersionedFeature(Feature.BLSR_4F_VERSIONING).getVersion();
            if (version == Version.NIL) {
                if (!this.unBlsrableNodes.containsKey(iNodeModelArray[i])) {
                    this.unBlsrableNodes.put(iNodeModelArray[i], BedEliminationReason.FOUR_FIBER_INCAPABLE_NODE);
                }
                if (!db.on()) continue;
                db.println("[get4FiberCapableNodes] " + iNodeModelArray[i] + " does not support 4F BLSR.");
                continue;
            }
            arrayList.add(iNodeModelArray[i]);
        }
        return BlsrRingModel.toNodeArray(arrayList);
    }

    private INodeModel[] getNodesWithEnoughProtectPorts(INodeModel[] iNodeModelArray) {
        HashSet<INodeModel> hashSet = new HashSet<INodeModel>();
        if (BlsrRingModel.db.on) {
            db.fine("getNodesWithEnoughProtectPorts called");
        }
        for (int i = 0; i < iNodeModelArray.length; ++i) {
            if (this.getAvailableProtectPorts(iNodeModelArray[i]).size() >= 2) {
                hashSet.add(iNodeModelArray[i]);
                continue;
            }
            if (this.unBlsrableNodes.containsKey(iNodeModelArray[i])) continue;
            this.unBlsrableNodes.put(iNodeModelArray[i], BedEliminationReason.NOT_ENOUGH_PROTECT_PORTS);
        }
        if (db.on()) {
            db.println("found nodes with enough usable protect ports.  They are: ");
            db.println(((Object)hashSet).toString());
        }
        return BlsrRingModel.toNodeArray(hashSet);
    }

    public boolean isProposedSpan(BlsrSpan blsrSpan) {
        boolean bl = false;
        if (this.blsrSpans.contains(blsrSpan)) {
            bl = true;
        }
        return bl;
    }

    public static boolean isPortIS(ITdmPortModel iTdmPortModel) throws NoSuchInterface {
        boolean bl = false;
        if (iTdmPortModel != null) {
            bl = Feature.provides((INodeModel)iTdmPortModel.getNodeModel(), (Feature)Feature.ENHANCED_STATE_MODEL) ? iTdmPortModel.getAdminState() != 1 : iTdmPortModel.isPortIS();
        }
        return bl;
    }

    public Set getAvailableProtectPorts(INodeModel iNodeModel) {
        if (this.ringInfo.getRingSpeed() < 2) {
            return new HashSet();
        }
        if (BlsrRingModel.db.on) {
            db.fine("getAvailableProtectPorts called");
        }
        int n = this.ringInfo.getRingSpeed() == 2 ? 30 : 61;
        IElementModels iElementModels = iNodeModel.getIElementModels();
        Set set = iElementModels.getBlsrAvailableEntities(3);
        Iterator iterator = set.iterator();
        ITdmPortModel iTdmPortModel = null;
        int n2 = 0;
        while (iterator.hasNext()) {
            block8: {
                try {
                    iTdmPortModel = (ITdmPortModel)iterator.next();
                }
                catch (ClassCastException classCastException) {
                    if (!db.on()) break block8;
                    db.println("Uh oh I should have never gotten here.  In ElementModelsDelegate the method getBlsrAvailableEntities returned something that is not an ITdmPortModel.  That should not be possible right?");
                }
            }
            try {
                boolean bl = iTdmPortModel.isOrderwireOn();
                if (!iTdmPortModel.isSonetDccTermination() && BlsrRingModel.isPortIS(iTdmPortModel) && !bl && iTdmPortModel.getEqType() == n && !BlsrNode.isEntityTimingReference((IPortModel)iTdmPortModel)) continue;
                iterator.remove();
                if (!bl) continue;
                ++n2;
            }
            catch (NoSuchInterface noSuchInterface) {
                iterator.remove();
                if (!db.on()) continue;
                db.println(this + "  in method getAvailableProtectPorts, and eliminated a port as a NoSuchInterface was caught.");
            }
        }
        if (set.size() < 2 && set.size() + n2 >= 2 && !this.unBlsrableNodes.containsKey(iNodeModel)) {
            this.unBlsrableNodes.put(iNodeModel, BedEliminationReason.ORDER_WIRE_ON_PROTECT_PORT);
        }
        return set;
    }

    public ITdmPortModel[] getPotentialProtectPorts(INodeModel iNodeModel) {
        return BlsrRingModel.toPortArray(this.getAvailableProtectPorts(iNodeModel));
    }

    private static Set spansToNetLinks(BlsrSpan[] blsrSpanArray) {
        HashSet<INetLink> hashSet = new HashSet<INetLink>();
        for (int i = 0; i < blsrSpanArray.length; ++i) {
            INetLink iNetLink = blsrSpanArray[i].getOriginalLink();
            INetLink iNetLink2 = blsrSpanArray[i].getReverseLink();
            if (iNetLink == null || iNetLink2 == null) continue;
            hashSet.add(iNetLink);
            hashSet.add(iNetLink2);
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void syncRingReversion() {
        HashSet<IRevertiveBehavior> hashSet = new HashSet<IRevertiveBehavior>();
        BlsrNode blsrNode = null;
        IRevertiveBehavior iRevertiveBehavior = this.ringInfo.getRingReversion();
        Set set = this.blsrNodes;
        synchronized (set) {
            Iterator iterator = this.blsrNodes.iterator();
            while (iterator.hasNext()) {
                blsrNode = (BlsrNode)iterator.next();
                hashSet.add(blsrNode.getBlsrModel().getRingReversion());
            }
        }
        if (hashSet.size() != 1) {
            this.ringInfo.setUnprovisionedRingReversion(new IRevertiveBehavior(){

                public int getReversionMode() {
                    return -1;
                }

                public IReversionMode getReversionModeEnum() {
                    return null;
                }

                public void setReversionMode(int n) {
                }

                public int getReversionTime() {
                    return -1;
                }

                public void setReversionTime(int n) {
                }

                public IRevertiveBehavior duplicate() {
                    return this;
                }
            });
        } else {
            this.ringInfo.setUnprovisionedRingReversion(blsrNode.getBlsrModel().getRingReversion());
        }
        if (!this.ringInfo.getRingReversion().equals(iRevertiveBehavior)) {
            this.reversionChangeNotifier.notifyObservers(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void syncSpanReversion() {
        if (this.ringInfo.isFourFiber()) {
            HashSet<IRevertiveBehavior> hashSet = new HashSet<IRevertiveBehavior>();
            BlsrNode blsrNode = null;
            IRevertiveBehavior iRevertiveBehavior = this.ringInfo.getSpanReversion();
            Set set = this.blsrNodes;
            synchronized (set) {
                Iterator iterator = this.blsrNodes.iterator();
                while (iterator.hasNext()) {
                    blsrNode = (BlsrNode)iterator.next();
                    hashSet.add(blsrNode.getBlsrModel().getSpanReversion());
                }
            }
            if (hashSet.size() != 1) {
                this.ringInfo.setUnprovisionedSpanReversion(new IRevertiveBehavior(){

                    public int getReversionMode() {
                        return -1;
                    }

                    public IReversionMode getReversionModeEnum() {
                        return null;
                    }

                    public void setReversionMode(int n) {
                    }

                    public int getReversionTime() {
                        return -1;
                    }

                    public void setReversionTime(int n) {
                    }

                    public IRevertiveBehavior duplicate() {
                        return this;
                    }
                });
            } else {
                this.ringInfo.setUnprovisionedSpanReversion(blsrNode.getBlsrModel().getSpanReversion());
            }
            if (!this.ringInfo.getSpanReversion().equals(iRevertiveBehavior)) {
                this.reversionChangeNotifier.notifyObservers(this);
            }
        }
    }

    public SortedMap getBedEliminatedNodes() {
        return new TreeMap(this.unBlsrableNodes);
    }

    public IRevertiveBehavior getRingReversion() {
        return this.ringInfo.getRingReversion();
    }

    public IRevertiveBehavior getSpanReversion() {
        return this.ringInfo.getSpanReversion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void setRingName(String string) throws DuplicateRingId, BlsrSpanSwitched {
        block29: {
            String string2;
            ArrayList<BlsrNode> arrayList;
            block28: {
                arrayList = null;
                string2 = this.ringInfo.getRingName();
                if (db.on()) {
                    db.println("setRingName(), changing name from: " + string2 + " to: " + string + ".");
                }
                Set set = this.blsrNodes;
                synchronized (set) {
                    Iterator iterator = new ArrayList(this.blsrNodes).iterator();
                    arrayList = new ArrayList<BlsrNode>(this.blsrNodes.size());
                    while (iterator.hasNext()) {
                        BlsrNode blsrNode = (BlsrNode)iterator.next();
                        blsrNode.getBlsrRingInfo().setRingName(string);
                        arrayList.add(blsrNode);
                    }
                }
                if (!db.on()) break block28;
                db.println("The Ring Name was successfully changed to: " + string + ".");
            }
            Object var9_10 = null;
            if (arrayList.size() >= this.blsrNodes.size()) break block29;
            if (db.on()) {
                db.println("Failed to changes all nodes in the ring from: " + string2 + " to: " + string + ".");
                db.println("Undoing any changes that where made.");
            }
            try {
                ArrayList<BlsrNode> arrayList2 = arrayList;
                synchronized (arrayList2) {
                    Iterator iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        ((BlsrNode)iterator.next()).getBlsrRingInfo().setRingName(string2);
                    }
                }
                if (db.on()) {
                    db.println("Ring Name successfully changed back to: " + string2 + ".");
                }
                break block29;
            }
            catch (Exception exception) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)exception);
                }
                break block29;
            }
            {
                catch (DuplicateRingId duplicateRingId) {
                    if (db.on()) {
                        db.println("DuplicateRingId Exception.");
                    }
                    throw duplicateRingId;
                }
                catch (BlsrSpanSwitched blsrSpanSwitched) {
                    if (db.on()) {
                        db.println("BlsrSpanSwitched Exception.");
                    }
                    throw blsrSpanSwitched;
                }
            }
            catch (Throwable throwable) {
                block31: {
                    Object var9_11 = null;
                    if (arrayList.size() < this.blsrNodes.size()) {
                        if (db.on()) {
                            db.println("Failed to changes all nodes in the ring from: " + string2 + " to: " + string + ".");
                            db.println("Undoing any changes that where made.");
                        }
                        try {
                            ArrayList<BlsrNode> arrayList3 = arrayList;
                            synchronized (arrayList3) {
                                Iterator iterator = arrayList.iterator();
                                while (iterator.hasNext()) {
                                    ((BlsrNode)iterator.next()).getBlsrRingInfo().setRingName(string2);
                                }
                            }
                            if (db.on()) {
                                db.println("Ring Name successfully changed back to: " + string2 + ".");
                            }
                        }
                        catch (Exception exception) {
                            if (!db.on()) break block31;
                            SDebug.printStackTrace((Throwable)exception);
                        }
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRingReversion(IRevertiveBehavior iRevertiveBehavior) throws Busy {
        if (iRevertiveBehavior != null) {
            IRevertiveBehavior iRevertiveBehavior2 = this.getRingReversion();
            Set set = this.blsrNodes;
            synchronized (set) {
                Object object;
                HashSet<Object> hashSet = new HashSet<Object>();
                Iterator iterator = this.blsrNodes.iterator();
                while (iterator.hasNext()) {
                    object = (BlsrNode)iterator.next();
                    if (!((BlsrNode)object).getBlsrRingInfo().isBusy()) continue;
                    throw new Busy("Ring or Span switch is active on " + ((BlsrNode)object).getRingName());
                }
                try {
                    iterator = this.blsrNodes.iterator();
                    while (iterator.hasNext()) {
                        object = (BlsrNode)iterator.next();
                        ((BlsrNode)object).getBlsrRingInfo().setRingReversion(iRevertiveBehavior);
                        hashSet.add(object);
                    }
                }
                catch (Busy busy) {
                    object = hashSet.iterator();
                    while (object.hasNext()) {
                        BlsrNode blsrNode = (BlsrNode)object.next();
                        blsrNode.getBlsrRingInfo().setRingReversion(iRevertiveBehavior2);
                    }
                    throw busy;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSpanReversion(IRevertiveBehavior iRevertiveBehavior) throws Busy {
        if (iRevertiveBehavior != null && this.ringInfo.isFourFiber()) {
            IRevertiveBehavior iRevertiveBehavior2 = this.getSpanReversion();
            Set set = this.blsrNodes;
            synchronized (set) {
                Object object;
                HashSet hashSet = new HashSet();
                Iterator iterator = this.blsrNodes.iterator();
                while (iterator.hasNext()) {
                    object = (BlsrNode)iterator.next();
                    if (!((BlsrNode)object).getBlsrRingInfo().isBusy()) continue;
                    throw new Busy("Ring or Span switch is active on " + ((BlsrNode)object).getRingName());
                }
                try {
                    iterator = this.blsrNodes.iterator();
                    while (iterator.hasNext()) {
                        object = (BlsrNode)iterator.next();
                        ((BlsrNode)object).getBlsrRingInfo().setSpanReversion(iRevertiveBehavior);
                    }
                }
                catch (Busy busy) {
                    object = hashSet.iterator();
                    while (object.hasNext()) {
                        BlsrNode blsrNode = (BlsrNode)object.next();
                        blsrNode.getBlsrRingInfo().setSpanReversion(iRevertiveBehavior2);
                    }
                    throw busy;
                }
            }
        }
    }

    private boolean isSpecialReason(BedEliminationReason bedEliminationReason) {
        return bedEliminationReason == BedEliminationReason.NOT_ENOUGH_SPANS_OF_RIGHT_SPEED || bedEliminationReason == BedEliminationReason.NOT_ENOUGH_SPANS_WITHOUT_LDCC;
    }

    private INodeModel[] getNodesInLoops(INodeModel[] iNodeModelArray, BlsrSpan[] blsrSpanArray, BedEliminationReason bedEliminationReason, Set set) {
        boolean bl;
        if (BlsrRingModel.db.on) {
            db.fine("getNodesInLoops called");
        }
        Network network = Network.instance();
        HashSet<INodeModel> hashSet = new HashSet<INodeModel>(Arrays.asList(iNodeModelArray));
        Set set2 = BlsrRingModel.spansToNetLinks(blsrSpanArray);
        int n = 0;
        Integer n2 = null;
        Map map = null;
        if (this.isSpecialReason(bedEliminationReason)) {
            map = this.getLinksOnNode(hashSet, set2);
        }
        do {
            Iterator iterator = hashSet.iterator();
            bl = false;
            while (iterator.hasNext()) {
                INetElement iNetElement = network.getNetElem(((INodeModel)iterator.next()).getNodeId());
                n = 0;
                Iterator iterator2 = set2.iterator();
                HashSet<Integer> hashSet2 = new HashSet<Integer>();
                while (iterator2.hasNext()) {
                    INetLink iNetLink = (INetLink)iterator2.next();
                    INetElement iNetElement2 = iNetLink.getSrc();
                    if (!iNetElement2.equals(iNetElement)) continue;
                    try {
                        n2 = new Integer(iNetLink.getSrc().getNodeModel().getEntityTable().getEntityModelByIndex(iNetLink.getSrcEntityIndex()).getSlot());
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        db.severe("In BlsrRingModel.geNodesInLoops().  Unable to determine the src port of the net link.");
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                        continue;
                    }
                    if (hashSet2.contains(n2)) continue;
                    n = (short)(n + 1);
                    hashSet2.add(n2);
                    n2 = null;
                }
                if (n >= 2) continue;
                INodeModel iNodeModel = iNetElement.getNodeModel();
                if (this.isSpecialReason(bedEliminationReason)) {
                    if ((Integer)map.get(iNetElement) >= 2) {
                        if (!this.unBlsrableNodes.containsKey(iNodeModel)) {
                            this.unBlsrableNodes.put(iNodeModel, BedEliminationReason.NOT_IN_LOOP);
                        }
                    } else if (!this.unBlsrableNodes.containsKey(iNodeModel)) {
                        if (n2 != null && n == 1) {
                            this.unBlsrableNodes.put(iNodeModel, BedEliminationReason.ALL_LINKS_ON_SAME_CARD);
                        } else {
                            this.unBlsrableNodes.put(iNodeModel, bedEliminationReason);
                        }
                    }
                }
                if (set != null && set.contains(iNodeModel)) {
                    if (!this.unBlsrableNodes.containsKey(iNodeModel)) {
                        this.unBlsrableNodes.put(iNodeModel, bedEliminationReason);
                    }
                } else if (!this.unBlsrableNodes.containsKey(iNodeModel)) {
                    this.unBlsrableNodes.put(iNodeModel, BedEliminationReason.NOT_IN_LOOP);
                }
                iterator.remove();
                bl = true;
                blsrSpanArray = BlsrRingModel.getAllSpansWithValidEndpoints(blsrSpanArray, BlsrRingModel.toNodeArray(hashSet));
                set2 = BlsrRingModel.spansToNetLinks(blsrSpanArray);
            }
        } while (bl);
        return BlsrRingModel.toNodeArray(hashSet);
    }

    private Map getLinksOnNode(Set set, Set set2) {
        HashMap<INetElement, Integer> hashMap = new HashMap<INetElement, Integer>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            INetElement iNetElement = Network.instance().getNetElem(((INodeModel)iterator.next()).getNodeId());
            int n = 0;
            HashSet<Integer> hashSet = new HashSet<Integer>();
            Iterator iterator2 = set2.iterator();
            while (iterator2.hasNext()) {
                Integer n2;
                INetLink iNetLink = (INetLink)iterator2.next();
                INetElement iNetElement2 = iNetLink.getSrc();
                if (!iNetElement2.equals(iNetElement)) continue;
                try {
                    n2 = new Integer(iNetLink.getSrc().getNodeModel().getEntityTable().getEntityModelByIndex(iNetLink.getSrcEntityIndex()).getSlot());
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    db.severe("In BlsrRingModel.geNodesInLoops().  Unable to determine the src port of the net link.");
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    continue;
                }
                if (hashSet.contains(n2)) continue;
                ++n;
                hashSet.add(n2);
            }
            if (hashMap.containsKey(iNetElement)) continue;
            hashMap.put(iNetElement, new Integer(n));
        }
        return hashMap;
    }

    private HashSet getAllSpansWithoutTopoUpgradeSupport(BlsrSpan[] blsrSpanArray) {
        HashSet<BlsrSpan> hashSet = new HashSet<BlsrSpan>(Arrays.asList(blsrSpanArray));
        HashSet<INodeModel> hashSet2 = new HashSet<INodeModel>();
        for (int i = 0; i < blsrSpanArray.length; ++i) {
            INetLink iNetLink = blsrSpanArray[i].getOriginalLink();
            INodeModel iNodeModel = iNetLink.getSrc().getNodeModel();
            INodeModel iNodeModel2 = iNetLink.getDst().getNodeModel();
            if (this.state != 7 || iNodeModel.provides(Feature.ISTU) && iNodeModel2.provides(Feature.ISTU)) continue;
            hashSet.remove(blsrSpanArray[i]);
            if (!iNodeModel.provides(Feature.ISTU)) {
                hashSet2.add(iNodeModel);
            }
            if (iNodeModel2.provides(Feature.ISTU)) continue;
            hashSet2.add(iNodeModel2);
        }
        return hashSet2;
    }

    private BlsrSpan[] getAllSpansWithCompatibleFeatureVersions(BlsrSpan[] blsrSpanArray, Set set) {
        Object object;
        HashSet<BlsrSpan> hashSet = new HashSet<BlsrSpan>(Arrays.asList(blsrSpanArray));
        HashMap hashMap = new HashMap();
        AbstractVersionedFeature abstractVersionedFeature = null;
        AbstractVersionedFeature abstractVersionedFeature2 = null;
        if (BlsrRingModel.db.on) {
            db.fine("getAllSpansWithCompatibleFeatureVersions called");
        }
        for (int i = 0; i < blsrSpanArray.length; ++i) {
            INetLink iNetLink = blsrSpanArray[i].getOriginalLink();
            INodeModel iNodeModel = iNetLink.getSrc().getNodeModel();
            INodeModel iNodeModel2 = iNetLink.getDst().getNodeModel();
            if (iNodeModel.provides(Feature.FEATURE_VERSIONING) && iNodeModel2.provides(Feature.FEATURE_VERSIONING)) {
                switch (this.ringInfo.getRingType()) {
                    case 2: {
                        abstractVersionedFeature = iNodeModel.getVersionedFeature(Feature.BLSR_2F_VERSIONING);
                        abstractVersionedFeature2 = iNodeModel2.getVersionedFeature(Feature.BLSR_2F_VERSIONING);
                        break;
                    }
                    case 3: {
                        abstractVersionedFeature = iNodeModel.getVersionedFeature(Feature.BLSR_4F_VERSIONING);
                        abstractVersionedFeature2 = iNodeModel2.getVersionedFeature(Feature.BLSR_4F_VERSIONING);
                        break;
                    }
                    default: {
                        abstractVersionedFeature = null;
                        abstractVersionedFeature2 = null;
                    }
                }
                boolean bl = AbstractVersionedFeature.isCompatibilityPresent((AbstractVersionedFeature)abstractVersionedFeature, abstractVersionedFeature2);
                if (!bl) {
                    hashSet.remove(blsrSpanArray[i]);
                    if (!hashMap.containsKey(abstractVersionedFeature)) {
                        hashMap.put(abstractVersionedFeature, new HashSet());
                    }
                    object = (Set)hashMap.get(abstractVersionedFeature);
                    object.add(iNodeModel);
                    if (!hashMap.containsKey(abstractVersionedFeature2)) {
                        hashMap.put(abstractVersionedFeature2, new HashSet());
                    }
                    object = (Set)hashMap.get(abstractVersionedFeature2);
                    object.add(iNodeModel2);
                }
                if (!db.on()) continue;
                db.println("Src/Dst version: " + abstractVersionedFeature + "/" + abstractVersionedFeature2 + " -> " + (bl ? "COMPATIBLE" : "INCOMPATIBLE"));
                continue;
            }
            if (db.on()) {
                db.print("Endpoints that don't support feature versioning: ");
                if (!iNodeModel.provides(Feature.FEATURE_VERSIONING)) {
                    db.print(iNodeModel.toString() + " ");
                }
                if (!iNodeModel2.provides(Feature.FEATURE_VERSIONING)) {
                    db.print(iNodeModel2.toString());
                }
                db.println("");
            }
            hashSet.remove(blsrSpanArray[i]);
            if (!hashMap.containsKey(abstractVersionedFeature)) {
                hashMap.put(abstractVersionedFeature, new HashSet());
            }
            object = (Set)hashMap.get(abstractVersionedFeature);
            object.add(iNodeModel);
            if (!hashMap.containsKey(abstractVersionedFeature2)) {
                hashMap.put(abstractVersionedFeature2, new HashSet());
            }
            object = (Set)hashMap.get(abstractVersionedFeature2);
            object.add(iNodeModel2);
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            object = (AbstractVersionedFeature)iterator.next();
            set.add(new BlsrCompatBundle((AbstractVersionedFeature)object, (Set)hashMap.get(object)));
        }
        return BlsrRingModel.toBlsrSpanArray(hashSet);
    }

    private static BlsrSpan[] getAllSpansWithValidEndpoints(BlsrSpan[] blsrSpanArray, INodeModel[] iNodeModelArray) {
        List<INodeModel> list = Arrays.asList(iNodeModelArray);
        HashSet<BlsrSpan> hashSet = new HashSet<BlsrSpan>();
        for (int i = 0; i < blsrSpanArray.length; ++i) {
            HashSet<INodeModel> hashSet2 = new HashSet<INodeModel>(Arrays.asList(blsrSpanArray[i].getNodeEndPoints()));
            hashSet2.retainAll(list);
            if (hashSet2.size() <= 1) continue;
            hashSet.add(blsrSpanArray[i]);
        }
        return BlsrRingModel.toBlsrSpanArray(hashSet);
    }

    private BlsrSpan[] getAllSpansOfRightSpeed() {
        Network network = Network.instance();
        INetLink[] iNetLinkArray = BlsrRingModel.toLinkArray(network.getNetLinks());
        HashSet<BlsrSpan> hashSet = new HashSet<BlsrSpan>();
        int n = this.ringInfo.getRingSpeed();
        if (BlsrRingModel.db.on) {
            db.fine("getAllSpansOfRightSpeed called");
        }
        for (int i = 0; i < iNetLinkArray.length; ++i) {
            if (iNetLinkArray[i].getPhysicalType() != n || !iNetLinkArray[i].isBlsrCapable()) continue;
            try {
                hashSet.add(new BlsrSpan(iNetLinkArray[i], false));
                continue;
            }
            catch (InstantiationException instantiationException) {
                if (!db.on()) continue;
                db.println(iNetLinkArray[i].prettyString() + " Does not provide NET_BLSR_WIZ on both sides.");
            }
        }
        return BlsrRingModel.toBlsrSpanArray(hashSet);
    }

    private BlsrSpan[] getAllSpansWithOspfAreasForBlsr(BlsrSpan[] blsrSpanArray, Set set) {
        Set<BlsrSpan> set2;
        HashMap<INodeModel, Set<BlsrSpan>> hashMap;
        BlsrSpan blsrSpan;
        HashSet<BlsrSpan> hashSet = new HashSet<BlsrSpan>(Arrays.asList(blsrSpanArray));
        Iterator iterator = hashSet.iterator();
        HashMap hashMap2 = new HashMap();
        if (BlsrRingModel.db.on) {
            db.fine("getAllSpansWithOspfAreasForBlsr called");
        }
        while (iterator.hasNext()) {
            blsrSpan = (BlsrSpan)iterator.next();
            INodeModel[] iNodeModelArray = blsrSpan.getNodeEndPoints();
            Long l = new Long(blsrSpan.getOspfAreaId());
            hashMap = (HashMap<INodeModel, Set<BlsrSpan>>)hashMap2.get(l);
            if (hashMap == null) {
                hashMap = new HashMap<INodeModel, Set<BlsrSpan>>();
                set2 = new HashSet<BlsrSpan>();
                set2.add(blsrSpan);
                hashMap.put(iNodeModelArray[0], set2);
                hashMap.put(iNodeModelArray[1], set2);
                hashMap2.put(l, hashMap);
                continue;
            }
            boolean bl = false;
            set2 = (Set)hashMap.get(iNodeModelArray[0]);
            if (set2 == null) {
                set2 = new HashSet();
                bl = true;
            }
            set2.add(blsrSpan);
            if (bl) {
                hashMap.put(iNodeModelArray[0], set2);
                bl = false;
            }
            if ((set2 = (Set)hashMap.get(iNodeModelArray[1])) == null) {
                set2 = new HashSet();
                bl = true;
            }
            set2.add(blsrSpan);
            if (!bl) continue;
            hashMap.put(iNodeModelArray[1], set2);
            bl = false;
        }
        Set set3 = hashMap2.keySet();
        if (set3.size() == 1) {
            return blsrSpanArray;
        }
        Iterator iterator2 = set3.iterator();
        Iterator iterator3 = null;
        INodeModel iNodeModel = null;
        while (iterator2.hasNext()) {
            hashMap = (Map)hashMap2.get(iterator2.next());
            iterator3 = hashMap.keySet().iterator();
            while (iterator3.hasNext()) {
                iNodeModel = (INodeModel)iterator3.next();
                set2 = (Set)hashMap.get(iNodeModel);
                if (set2.size() != 1) continue;
                blsrSpan = (BlsrSpan)set2.iterator().next();
                if (hashSet.remove(blsrSpan) && db.on()) {
                    db.println("span removed because of bad OSPF id: " + blsrSpan);
                }
                set.add(iNodeModel);
            }
        }
        return BlsrRingModel.toBlsrSpanArray(hashSet);
    }

    private static BlsrSpan[] getAllSpansWithOutPathSelectors(BlsrSpan[] blsrSpanArray, Set set) {
        HashSet<BlsrSpan> hashSet = new HashSet<BlsrSpan>(Arrays.asList(blsrSpanArray));
        Iterator iterator = hashSet.iterator();
        IEntityTableModel iEntityTableModel = null;
        IEntityTableModel iEntityTableModel2 = null;
        ITdmPortModel iTdmPortModel = null;
        ITdmPortModel iTdmPortModel2 = null;
        boolean bl = false;
        boolean bl2 = false;
        if (BlsrRingModel.db.on) {
            db.fine("getAllSpansWithOutPathSelectors called");
        }
        while (iterator.hasNext()) {
            BlsrSpan blsrSpan = (BlsrSpan)iterator.next();
            INodeModel iNodeModel = blsrSpan.getOriginalLink().getSrc().getNodeModel();
            INodeModel iNodeModel2 = blsrSpan.getOriginalLink().getDst().getNodeModel();
            iEntityTableModel = iNodeModel.getEntityTable();
            iEntityTableModel2 = iNodeModel2.getEntityTable();
            try {
                iTdmPortModel = (ITdmPortModel)iEntityTableModel.getEntityModelByIndex(blsrSpan.getOriginalLink().getSrcEntityIndex());
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                db.severe("In BlsrRingModel.getAllSpansWithoutPathSelectors an INetLink with the src port absent from the entity table model was found.");
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                continue;
            }
            try {
                iTdmPortModel2 = (ITdmPortModel)iEntityTableModel2.getEntityModelByIndex(blsrSpan.getOriginalLink().getDstEntityIndex());
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                db.severe("In BlsrRingModel.getAllSpansWithoutPathSelectors an INetLink with the dst port absent from the entity table model was found.");
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                continue;
            }
            if (iNodeModel.provides(Feature.BLSR_UPSR_DRI) && iNodeModel2.provides(Feature.BLSR_UPSR_DRI)) {
                bl = iTdmPortModel.isUpsrSelectorPresent(true);
                bl2 = iTdmPortModel2.isUpsrSelectorPresent(true);
            } else {
                bl = iTdmPortModel.isUpsrSelectorPresent();
                bl2 = iTdmPortModel2.isUpsrSelectorPresent();
            }
            if (bl || bl2) {
                if (db.on()) {
                    db.println("getAllSpansWithoutPathSelectors removing " + blsrSpan);
                }
                iterator.remove();
            }
            if (set == null) continue;
            if (bl) {
                set.add(blsrSpan.getOriginalLink().getSrc().getNodeModel());
            }
            if (!bl2) continue;
            set.add(blsrSpan.getOriginalLink().getDst().getNodeModel());
        }
        return BlsrRingModel.toBlsrSpanArray(hashSet);
    }

    private static BlsrSpan[] getAllSpansWithOutPathSelectors(BlsrSpan[] blsrSpanArray) {
        return BlsrRingModel.getAllSpansWithOutPathSelectors(blsrSpanArray, null);
    }

    private ILinkPhysicalType getRingSpeed() {
        return this.getBlsrRingInfo().getRingSpeedObj();
    }

    private BlsrSpan[] getAllSpansWithoutCircuitsThatSpanHighHOandLowHO(BlsrSpan[] blsrSpanArray, Set set) {
        HashSet<BlsrSpan> hashSet = new HashSet<BlsrSpan>(Arrays.asList(blsrSpanArray));
        Set set2 = this.getHighLowSpans(hashSet).keySet();
        BlsrSpan blsrSpan = null;
        if (BlsrRingModel.db.on) {
            db.fine("getAllSpansWithoutCircuitsThatSpanHighSTSandLowSTS called");
        }
        if (set2.isEmpty()) {
            return blsrSpanArray;
        }
        Iterator iterator = set2.iterator();
        hashSet.removeAll(set2);
        while (iterator.hasNext()) {
            blsrSpan = (BlsrSpan)iterator.next();
            set.add(blsrSpan.getOriginalLink().getSrc().getNodeModel());
            set.add(blsrSpan.getOriginalLink().getDst().getNodeModel());
        }
        return BlsrRingModel.toBlsrSpanArray(hashSet);
    }

    private Map getHighLowSpans(Set set) {
        Map map = this.getAllSpansWithCircuitsInHighHO(set);
        Iterator iterator = map.keySet().iterator();
        Iterator iterator2 = null;
        SpanRow spanRow = null;
        BlsrSpan blsrSpan = null;
        HashMap hashMap = new HashMap();
        HashSet<SpanRow> hashSet = null;
        IHoNum iHoNum = null;
        if (BlsrRingModel.db.on) {
            db.fine("getHighLowSpans called");
        }
        while (iterator.hasNext()) {
            hashSet = new HashSet<SpanRow>();
            blsrSpan = (BlsrSpan)iterator.next();
            iHoNum = this.getUpperHalfHoNum(blsrSpan);
            iterator2 = ((Set)map.get(blsrSpan)).iterator();
            while (iterator2.hasNext()) {
                spanRow = (SpanRow)iterator2.next();
                if (!spanRow.doesStraddle(iHoNum)) continue;
                hashSet.add(spanRow);
            }
            if (hashSet.isEmpty()) continue;
            hashMap.put(blsrSpan, hashSet);
        }
        return hashMap;
    }

    public Map getSpansWithPotentialPCATraffic() throws IllegalStateException {
        if (this.isProvisioned()) {
            throw new IllegalStateException("This method should only be called on unprovisioned rings!");
        }
        if (this.getBlsrRingInfo().isFourFiber()) {
            throw new IllegalStateException("This method should only be called on two fiber rings!");
        }
        return this.getAllSpansWithCircuitsInHighHO(this.blsrSpans);
    }

    public Map getWigglingCircuits() {
        return this.getWigglers(this.blsrSpans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getWigglingCircuits(BlsrSpan blsrSpan) {
        HashSet<BlsrSpan> hashSet;
        Set set = this.blsrSpans;
        synchronized (set) {
            hashSet = new HashSet<BlsrSpan>(this.blsrSpans);
        }
        hashSet.add(blsrSpan);
        return this.getWigglers(hashSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getWigglers(Set set) {
        HashSet hashSet;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        Object object7 = set;
        synchronized (object7) {
            if (db.on()) {
                object6 = new StringBuffer("getWigglers([");
                object5 = set.iterator();
                while (object5.hasNext()) {
                    ((StringBuffer)object6).append((BlsrSpan)object5.next());
                    if (!object5.hasNext()) continue;
                    ((StringBuffer)object6).append(", ");
                }
                ((StringBuffer)object6).append("])");
                db.fine(((StringBuffer)object6).toString());
            }
            object6 = set.iterator();
            while (object6.hasNext()) {
                object5 = new HashSet();
                object4 = (BlsrSpan)object6.next();
                BlsrRingModel.getLinkCircuits((Collection)object5, ((BlsrSpan)object4).getOriginalLink(), null);
                BlsrRingModel.getLinkCircuits((Collection)object5, ((BlsrSpan)object4).getReverseLink(), null);
                object3 = object5.iterator();
                while (object3.hasNext()) {
                    SpanRow spanRow = (SpanRow)object3.next();
                    object2 = spanRow.getCircuit();
                    object = (Collection)hashMap.get(object2);
                    hashSet = (Collection)hashMap2.get(object2);
                    if (object == null) {
                        object = new HashSet();
                        hashSet = new HashSet();
                        hashMap.put(object2, object);
                        hashMap2.put(object2, hashSet);
                    }
                    object.add(spanRow);
                    hashSet.add(spanRow.duplicateSpanRowWithoutSpan());
                }
            }
        }
        object7 = hashMap2.keySet().iterator();
        while (object7.hasNext()) {
            object6 = (INetCircuit)object7.next();
            object5 = (Collection)hashMap2.get(object6);
            object4 = (Collection)hashMap.get(object6);
            if (object5.size() < 2) {
                hashMap.remove(object6);
                object7.remove();
                continue;
            }
            object3 = new HashSet();
            boolean bl = false;
            object2 = object5.iterator();
            block9: while (!bl && object2.hasNext()) {
                object = (SpanRow)object2.next();
                hashSet = object4.iterator();
                while (hashSet.hasNext()) {
                    SpanRow spanRow = (SpanRow)hashSet.next();
                    if (((SpanRow)object).compareTo(spanRow) != 0) continue;
                    object = spanRow;
                    try {
                        String string = ((SpanRow)object).getSpan().getLink().getLinkModel().blsrRingName();
                        if (((HashSet)object3).contains(string)) {
                            bl = true;
                            continue block9;
                        }
                        ((HashSet)object3).add(string);
                    }
                    catch (NullPointerException nullPointerException) {
                        INetLink iNetLink = ((SpanRow)object).getSpan() != null ? ((SpanRow)object).getSpan().getLink() : null;
                        ILinkModel iLinkModel = iNetLink != null ? iNetLink.getLinkModel() : null;
                        String string = iLinkModel != null ? iLinkModel.blsrRingName() : null;
                        db.println("Caught " + nullPointerException);
                        db.println(object + " span is " + ((SpanRow)object).getSpan() + " link is " + iNetLink + " link model is " + iLinkModel + " blsrRingName is " + string);
                    }
                    continue block9;
                }
            }
            if (bl) continue;
            hashMap.remove(object6);
            object7.remove();
        }
        return this.removePcaBlsrDriFromWigglers(hashMap, this.getUpperHalfHoNum((BlsrSpan)set.iterator().next()));
    }

    private Map removePcaBlsrDriFromWigglers(Map map, IHoNum iHoNum) {
        if (db.on()) {
            db.println("getWigglers() -> ");
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            INetCircuit iNetCircuit = (INetCircuit)iterator.next();
            HashSet hashSet = (HashSet)map.get(iNetCircuit);
            if (db.on()) {
                db.println("\t" + iNetCircuit + (iNetCircuit.isPca() ? " (PCA - removing)" : (iNetCircuit.hasBlsrDri() ? " (DRI - removing)" : "")) + " -> " + hashSet + " (" + hashSet.size() + ")");
                Iterator iterator2 = hashSet.iterator();
                while (iterator2.hasNext()) {
                    object2 = (SpanRow)iterator2.next();
                    object = ((SpanRow)object2).getSpan().getLink().getLinkModel().blsrRingName();
                    if (((String)object).equals("")) {
                        db.println("\t\t" + object2 + " is NOT part of a BLSR.");
                        continue;
                    }
                    db.println("\t\t" + object2 + " IS part of BLSR '" + (String)object + "'");
                }
            }
            if (iNetCircuit.isPca() || iNetCircuit.hasBlsrDri()) {
                iterator.remove();
                continue;
            }
            boolean bl = true;
            object2 = HoLoComparator.instance();
            object = hashSet.iterator();
            while (bl && object.hasNext()) {
                SpanRow spanRow = (SpanRow)object.next();
                if (((HoLoComparator)object2).compare(iHoNum, spanRow.getFirstHo()) <= 0) continue;
                bl = false;
            }
            if (!bl) continue;
            db.println("\t Removing " + iNetCircuit.getCircuitName() + " from wiggling circuits list as all of its spans are in PCA bandwidth (equals or higher than HO " + iHoNum.getHoNum() + " )");
            iterator.remove();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getAllSpansWithCircuitsInHighHO(Set set) {
        HashSet hashSet = null;
        Iterator iterator = null;
        HashSet<SpanRow> hashSet2 = null;
        BlsrSpan blsrSpan = null;
        HashMap hashMap = new HashMap();
        Object var7_7 = null;
        if (BlsrRingModel.db.on) {
            db.fine("getAllSpansWithCircuitsInHighSTS called");
        }
        Set set2 = set;
        synchronized (set2) {
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                hashSet = new HashSet();
                blsrSpan = (BlsrSpan)iterator2.next();
                BlsrRingModel.getLinkCircuits(hashSet, blsrSpan.getOriginalLink(), null);
                BlsrRingModel.getLinkCircuits(hashSet, blsrSpan.getReverseLink(), null);
                if (db.on()) {
                    db.println("BlsrRingModel.getAllSpansWithCircuitsInHighHO is examining span " + blsrSpan + " with circuits " + hashSet);
                }
                if (hashSet.isEmpty()) continue;
                IHoNum iHoNum = this.getUpperHalfHoNum(blsrSpan);
                if (db.on()) {
                    db.println("The the upper HO region is " + iHoNum);
                }
                SpanRow spanRow = null;
                iterator = hashSet.iterator();
                hashSet2 = new HashSet<SpanRow>();
                while (iterator.hasNext()) {
                    spanRow = (SpanRow)iterator.next();
                    if (HoLoComparator.instance().compare(iHoNum, spanRow.getLastHo()) > 0) continue;
                    hashSet2.add(spanRow);
                }
                if (hashSet2.isEmpty()) continue;
                if (db.on()) {
                    db.println("BlsrRingModel.getAllSpansWithCircuitsInHighHO has added " + blsrSpan + ". It has the following circuits: " + hashSet2);
                }
                hashMap.put(blsrSpan, hashSet2);
            }
        }
        return hashMap;
    }

    private static void getLinkCircuits(Collection collection, INetLink iNetLink, IHoNum iHoNum) {
        SpanRow spanRow;
        INetCircuit iNetCircuit;
        Object object;
        if (iNetLink == null) {
            return;
        }
        NetCircuitManager netCircuitManager = NetCircuitManager.instance();
        List list = netCircuitManager.getCircuitSpans(iNetLink);
        List list2 = netCircuitManager.getEndpointsUseLink(iNetLink);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (INetCircuitSpan)iterator.next();
            iNetCircuit = object.getCircuit();
            if (iNetCircuit == null) {
                db.println("WARNING: ckt for span " + object + " is null.");
                continue;
            }
            spanRow = BlsrRingModel.createSpanRow(iNetCircuit, (INetCircuitSpan)object, iHoNum, object.getSrcHoNum(), object.getLoNum());
            if (!collection.add(spanRow) && BlsrRingModel.db.on) {
                db.println("last add was a duplicate");
            }
            if (!iNetCircuit.getCircuitTypeObj().isTunnelCircuitType()) continue;
            IHoNum iHoNum2 = spanRow.getFirst().getHoNum();
            BlsrRingModel.getLinkCircuits(collection, iNetCircuit.getLotLink(), iHoNum2);
            BlsrRingModel.getLinkCircuits(collection, iNetCircuit.getReverseLotLink(), iHoNum2);
        }
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            object = (INetCircuitEnd)iterator.next();
            iNetCircuit = netCircuitManager.getCircuitFromCircuitEnd((INetCircuitEnd)object);
            if (iNetCircuit == null) {
                db.println("WARNING: ckt for cktEnd " + object + " is null.");
                continue;
            }
            spanRow = BlsrRingModel.createSpanRow(iNetCircuit, null, iHoNum, object.getHoNum(), object.getLoNum());
            if (collection.add(spanRow) || !BlsrRingModel.db.on) continue;
            db.println("last add was a duplicate");
        }
    }

    protected static SpanRow createSpanRow(INetCircuit iNetCircuit, INetCircuitSpan iNetCircuitSpan, IHoNum iHoNum, IHoNum iHoNum2, ILoNum iLoNum) {
        ILoNum iLoNum2;
        ILoNum iLoNum3;
        IHoNum iHoNum3;
        IHoNum iHoNum4;
        if (iNetCircuit.getCircuitTypeObj().isLoCircuitType()) {
            iHoNum4 = iHoNum != null ? iHoNum : iHoNum2;
            iHoNum3 = iHoNum4;
            iLoNum2 = iLoNum3 = iLoNum;
            if (db.on()) {
                db.println(iNetCircuit.getCircuitName() + " is a lo circuit type");
            }
        } else {
            iHoNum3 = iHoNum2;
            int n = iHoNum3.getFramingType();
            ICircuitSize iCircuitSize = iNetCircuit.getCircuitSizeObj();
            if (db.on()) {
                db.fine("The offset for " + iNetCircuit.getCircuitName() + " is " + iCircuitSize.getFramingTypeHoPathWidth(n) + " The hoLow is " + iHoNum3.prettyString());
            }
            iHoNum4 = HoLoFactory.addOffset(iHoNum3, iCircuitSize.getFramingTypeHoPathWidth(n) - 1);
            iLoNum3 = null;
            iLoNum2 = null;
        }
        if (db.on()) {
            db.fine("adding new SpanRow(" + iHoNum3 + ", " + iHoNum4 + ", " + iLoNum2 + ", " + iLoNum3 + ", " + iNetCircuit.getCircuitName() + ")");
        }
        SpanRow spanRow = new SpanRow(iHoNum3, iLoNum2, iHoNum4, iLoNum3, iNetCircuit, iNetCircuitSpan);
        return spanRow;
    }

    private static BlsrSpan[] getAllSpansWithoutProtection(BlsrSpan[] blsrSpanArray, Set set) {
        HashSet<BlsrSpan> hashSet = new HashSet<BlsrSpan>(Arrays.asList(blsrSpanArray));
        if (BlsrRingModel.db.on) {
            db.fine("getAllSpansWithoutProtection called");
        }
        for (int i = 0; i < blsrSpanArray.length; ++i) {
            INetLink iNetLink = blsrSpanArray[i].getOriginalLink();
            INodeModel iNodeModel = iNetLink.getSrc().getNodeModel();
            try {
                ITdmPortModel iTdmPortModel = (ITdmPortModel)iNodeModel.getEntityTable().getEntityModelByIndex(iNetLink.getSrcEntityIndex());
                if (iTdmPortModel.hasOpticalProtection()) {
                    set.add(iNetLink.getSrc().getNodeModel());
                    hashSet.remove(blsrSpanArray[i]);
                }
                if (!(iTdmPortModel = (ITdmPortModel)(iNodeModel = iNetLink.getDst().getNodeModel()).getEntityTable().getEntityModelByIndex(iNetLink.getDstEntityIndex())).hasOpticalProtection()) continue;
                set.add(iNetLink.getDst().getNodeModel());
                hashSet.remove(blsrSpanArray[i]);
                continue;
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return BlsrRingModel.toBlsrSpanArray(hashSet);
    }

    private static BlsrSpan[] getAllSpansOfConsistentMediumType(BlsrSpan[] blsrSpanArray, Set set) {
        HashSet<BlsrSpan> hashSet = new HashSet<BlsrSpan>(Arrays.asList(blsrSpanArray));
        if (BlsrRingModel.db.on) {
            db.fine("getAllSpansOfConsistentMediumType called");
        }
        for (int i = 0; i < blsrSpanArray.length; ++i) {
            INetLink iNetLink = blsrSpanArray[i].getOriginalLink();
            try {
                INodeModel iNodeModel = iNetLink.getSrc().getNodeModel();
                ITdmPortModel iTdmPortModel = (ITdmPortModel)iNodeModel.getEntityTable().getEntityModelByIndex(iNetLink.getSrcEntityIndex());
                INodeModel iNodeModel2 = iNetLink.getDst().getNodeModel();
                ITdmPortModel iTdmPortModel2 = (ITdmPortModel)iNodeModel2.getEntityTable().getEntityModelByIndex(iNetLink.getDstEntityIndex());
                if (iTdmPortModel.getMediumType() == iTdmPortModel2.getMediumType()) continue;
                hashSet.remove(blsrSpanArray[i]);
                if (set == null) continue;
                set.add(iNodeModel);
                set.add(iNodeModel2);
                continue;
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return BlsrRingModel.toBlsrSpanArray(hashSet);
    }

    private static BlsrSpan[] getAllSpansNotParticipatingInABlsr(BlsrSpan[] blsrSpanArray, Set set) {
        int n = 0;
        int n2 = 0;
        Set set2 = null;
        Set set3 = null;
        HashSet<BlsrSpan> hashSet = new HashSet<BlsrSpan>();
        IBlsrModel iBlsrModel = null;
        boolean bl = false;
        boolean bl2 = false;
        if (BlsrRingModel.db.on) {
            db.fine("getAllSpansNotParticipatingInABlsr called");
        }
        for (int i = 0; i < blsrSpanArray.length; ++i) {
            bl = false;
            bl2 = false;
            n = blsrSpanArray[i].getOriginalLink().getDstEntityIndex();
            n2 = blsrSpanArray[i].getOriginalLink().getSrcEntityIndex();
            if (!blsrSpanArray[i].getOriginalLink().getDst().getNodeModel().isInited() || !blsrSpanArray[i].getOriginalLink().getSrc().getNodeModel().isInited()) {
                if (!db.on()) continue;
                db.println("BlsrRingModel.getAllSpansNotParticipatingInABlsr is eliminating " + blsrSpanArray[i] + "as it has at least one side with an uninited NMD");
                continue;
            }
            INetLink iNetLink = blsrSpanArray[i].getOriginalLink();
            INetLink iNetLink2 = blsrSpanArray[i].getReverseLink();
            if (!iNetLink.isSdccLink() || iNetLink2 != null && !iNetLink2.isSdccLink()) {
                if (!db.on()) continue;
                db.println("BlsrRingModel.getAllSpansNotParticipatingInABlsr is eliminating " + blsrSpanArray[i] + "as it is a non dcc span (PCA, or vtt)");
                continue;
            }
            set3 = blsrSpanArray[i].getOriginalLink().getDst().getNodeModel().getIElementModels().getBlsrElements();
            set2 = blsrSpanArray[i].getOriginalLink().getSrc().getNodeModel().getIElementModels().getBlsrElements();
            Iterator iterator = set3.iterator();
            Iterator iterator2 = set2.iterator();
            while (!bl && iterator.hasNext()) {
                iBlsrModel = (IBlsrModel)iterator.next();
                try {
                    if (iBlsrModel.getEastEntityModel().getEntityIndex() != n && iBlsrModel.getWestEntityModel().getEntityIndex() != n) continue;
                    bl = true;
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
            while (!bl2 && iterator2.hasNext()) {
                iBlsrModel = (IBlsrModel)iterator2.next();
                try {
                    if (iBlsrModel.getEastEntityModel().getEntityIndex() != n2 && iBlsrModel.getWestEntityModel().getEntityIndex() != n2) continue;
                    bl2 = true;
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
            if (!bl2 && !bl) {
                hashSet.add(blsrSpanArray[i]);
                continue;
            }
            if (set == null) continue;
            if (bl2) {
                set.add(blsrSpanArray[i].getOriginalLink().getSrc().getNodeModel());
            }
            if (!bl) continue;
            set.add(blsrSpanArray[i].getOriginalLink().getDst().getNodeModel());
        }
        return BlsrRingModel.toBlsrSpanArray(hashSet);
    }

    private static BlsrSpan[] getAllSpansNotParticipatingInABlsr(BlsrSpan[] blsrSpanArray) {
        return BlsrRingModel.getAllSpansNotParticipatingInABlsr(blsrSpanArray, null);
    }

    private INodeModel[] getAllNodes() {
        INetElement[] iNetElementArray = BlsrRingModel.toElementArray(Network.instance().getElements());
        ArrayList<INodeModel> arrayList = new ArrayList<INodeModel>();
        for (int i = 0; i < iNetElementArray.length; ++i) {
            arrayList.add(iNetElementArray[i].getNodeModel());
        }
        return BlsrRingModel.toNodeArray(arrayList);
    }

    private INodeModel[] getTopologyNodes(List list) {
        Iterator iterator = list.iterator();
        ArrayList<INodeModel> arrayList = new ArrayList<INodeModel>();
        Network network = Network.instance();
        HashSet<Topology> hashSet = new HashSet<Topology>();
        while (iterator.hasNext()) {
            INetElement iNetElement = network.findNetElem((Integer)iterator.next());
            if (iNetElement == null || hashSet.contains(iNetElement.getTopology())) continue;
            Iterator iterator2 = iNetElement.getTopology().getTopoElems().iterator();
            while (iterator2.hasNext()) {
                arrayList.add(((INetElement)iterator2.next()).getNodeModel());
            }
            hashSet.add(iNetElement.getTopology());
        }
        return BlsrRingModel.toNodeArray(arrayList);
    }

    private INodeModel[] getInitedNodes(INodeModel[] iNodeModelArray) {
        ArrayList<INodeModel> arrayList = new ArrayList<INodeModel>();
        if (BlsrRingModel.db.on) {
            db.fine("getInitedNodes called");
        }
        for (int i = 0; iNodeModelArray != null && i < iNodeModelArray.length; ++i) {
            INetElement iNetElement = Network.instance().findNetElem(iNodeModelArray[i].getNodeId());
            if (iNetElement != null && iNetElement.getConnectionState()) {
                arrayList.add(iNodeModelArray[i]);
                continue;
            }
            if (this.unBlsrableNodes.containsKey(iNodeModelArray[i])) continue;
            this.unBlsrableNodes.put(iNodeModelArray[i], BedEliminationReason.NODE_NOT_INITED);
        }
        return BlsrRingModel.toNodeArray(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getInitedNodes(Set set) {
        ArrayList<BlsrNode> arrayList = new ArrayList<BlsrNode>();
        BlsrNode blsrNode = null;
        Set set2 = set;
        synchronized (set2) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                blsrNode = (BlsrNode)iterator.next();
                INetElement iNetElement = Network.instance().findNetElem(blsrNode.getNodeModel().getNodeId());
                if (!iNetElement.getConnectionState()) continue;
                arrayList.add(blsrNode);
            }
        }
        return arrayList;
    }

    private INodeModel[] getNetBlsrWizNodes(INodeModel[] iNodeModelArray) {
        HashSet<INodeModel> hashSet = new HashSet<INodeModel>();
        if (BlsrRingModel.db.on) {
            db.fine("getNetBlsrWizNodes called");
        }
        for (int i = 0; iNodeModelArray != null && i < iNodeModelArray.length; ++i) {
            Version version = iNodeModelArray[i].getVersionedFeature(Feature.BLSR_2F_VERSIONING).getVersion();
            Version version2 = iNodeModelArray[i].getVersionedFeature(Feature.BLSR_4F_VERSIONING).getVersion();
            if (version == Version.NIL && version2 == Version.NIL) {
                if (this.unBlsrableNodes.containsKey(iNodeModelArray[i])) continue;
                this.unBlsrableNodes.put(iNodeModelArray[i], BedEliminationReason.NO_BLSR_SUPPORT);
                continue;
            }
            if (iNodeModelArray[i].provides(Feature.NET_BLSR_WIZ)) {
                hashSet.add(iNodeModelArray[i]);
                continue;
            }
            if (this.unBlsrableNodes.containsKey(iNodeModelArray[i])) continue;
            this.unBlsrableNodes.put(iNodeModelArray[i], BedEliminationReason.DOES_NOT_PROVIDE);
        }
        if (db.on()) {
            db.println("The initial size of Nodes wich provide NET_BLSR_WIZ is " + hashSet.size());
            db.println("The nodes that provide are " + ((Object)hashSet).toString());
        }
        return BlsrRingModel.toNodeArray(hashSet);
    }

    private static IBlsrModel[] getBlsrModels(INodeModel iNodeModel) {
        return BlsrRingModel.toBlsrArray(iNodeModel.getIElementModels().getBlsrElements());
    }

    private INodeModel[] getNodesWithoutTooManyBlsrs(INodeModel[] iNodeModelArray) {
        HashSet<INodeModel> hashSet = new HashSet<INodeModel>();
        short s = 0;
        if (BlsrRingModel.db.on) {
            db.fine("getNodesWithoutTooManyBlsrs called");
        }
        block0: for (int i = 0; i < iNodeModelArray.length; ++i) {
            int n;
            s = 0;
            INodeModel iNodeModel = iNodeModelArray[i];
            IBlsrModel[] iBlsrModelArray = BlsrRingModel.getBlsrModels(iNodeModel);
            if (iBlsrModelArray.length >= iNodeModel.getIElementModels().getBlsrLimits().getMaxBlsr()) {
                if (this.unBlsrableNodes.containsKey(iNodeModel)) continue;
                this.unBlsrableNodes.put(iNodeModel, BedEliminationReason.BLSR_LIMIT_REACHED);
                continue;
            }
            if (this.ringInfo.isFourFiber()) {
                for (n = 0; n < iBlsrModelArray.length; ++n) {
                    if (!new BlsrRingInfo(iBlsrModelArray[n]).isFourFiber()) continue;
                    s = (short)(s + 1);
                }
                if (db.on()) {
                    db.println(iNodeModel.getName() + " has " + s + " four fibers already present.");
                }
                if (s >= iNodeModel.getIElementModels().getBlsrLimits().getMax4FBlsr()) {
                    if (!this.unBlsrableNodes.containsKey(iNodeModel) && iNodeModel.getIElementModels().getBlsrLimits().getMax4FBlsr() == 0) {
                        this.unBlsrableNodes.put(iNodeModel, BedEliminationReason.FOUR_FIBER_INCAPABLE_NODE);
                    }
                    if (this.unBlsrableNodes.containsKey(iNodeModel)) continue;
                    this.unBlsrableNodes.put(iNodeModel, BedEliminationReason.FOUR_FIBER_LIMIT_REACHED);
                    continue;
                }
            }
            for (n = 0; n < iBlsrModelArray.length; ++n) {
                if (!this.getRingName().equals(BlsrRingManager.getRingName(iBlsrModelArray[n]))) continue;
                if (this.unBlsrableNodes.containsKey(iNodeModel)) continue block0;
                this.unBlsrableNodes.put(iNodeModel, BedEliminationReason.BLSR_WITH_SAME_RING_ID);
                continue block0;
            }
            hashSet.add(iNodeModel);
        }
        return BlsrRingModel.toNodeArray(hashSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getNodesWithTooManyBlsrs(Set set) {
        HashSet<BlsrNode> hashSet = new HashSet<BlsrNode>();
        BlsrNode blsrNode = null;
        short s = 0;
        if (BlsrRingModel.db.on) {
            db.fine("getNodesWithTooManyBlsrs called");
        }
        Set set2 = set;
        synchronized (set2) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                blsrNode = (BlsrNode)iterator.next();
                s = 0;
                IBlsrModel[] iBlsrModelArray = BlsrRingModel.getBlsrModels(blsrNode.getNodeModel());
                if (iBlsrModelArray.length >= blsrNode.getNodeModel().getIElementModels().getBlsrLimits().getMaxBlsr()) {
                    hashSet.add(blsrNode);
                }
                if (!this.ringInfo.isFourFiber()) continue;
                for (int i = 0; i < iBlsrModelArray.length; ++i) {
                    if (!new BlsrRingInfo(iBlsrModelArray[i]).isFourFiber()) continue;
                    s = (short)(s + 1);
                }
                if (s < blsrNode.getNodeModel().getIElementModels().getBlsrLimits().getMax4FBlsr()) continue;
                hashSet.add(blsrNode);
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getNodesWithWorkingPortsInProtectionGroup(Set set) {
        HashSet<BlsrNode> hashSet = new HashSet<BlsrNode>();
        BlsrNode blsrNode = null;
        if (BlsrRingModel.db.on) {
            db.fine("getNodesWithWorkingPortsInProtectionGroup called");
        }
        Set set2 = set;
        synchronized (set2) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                blsrNode = (BlsrNode)iterator.next();
                if (!blsrNode.isWorkingPortsInProtectionGroup()) continue;
                hashSet.add(blsrNode);
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getNodesWithBlsrOfSameRingName(Set set) {
        HashSet<BlsrNode> hashSet = new HashSet<BlsrNode>();
        IBlsrModel[] iBlsrModelArray = null;
        String string = this.ringInfo.getRingName();
        BlsrNode blsrNode = null;
        NodeModel nodeModel = null;
        if (BlsrRingModel.db.on) {
            db.fine("getNodesWithBlsrOfSameRingName called");
        }
        Set set2 = set;
        synchronized (set2) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                blsrNode = (BlsrNode)iterator.next();
                nodeModel = blsrNode.getNodeModel();
                iBlsrModelArray = BlsrRingModel.getBlsrModels(nodeModel);
                for (int i = 0; i < iBlsrModelArray.length; ++i) {
                    if (!string.equals(BlsrRingManager.getRingName(iBlsrModelArray[i]))) continue;
                    hashSet.add(BlsrNode.provisionedInstance(iBlsrModelArray[i], nodeModel));
                }
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set getNodeModels() {
        HashSet<NodeModel> hashSet = new HashSet<NodeModel>();
        Set set = this.blsrNodes;
        synchronized (set) {
            Iterator iterator = this.blsrNodes.iterator();
            while (iterator.hasNext()) {
                NodeModel nodeModel = ((BlsrNode)iterator.next()).getNodeModel();
                if (nodeModel == null) continue;
                hashSet.add(nodeModel);
            }
        }
        return hashSet;
    }

    public boolean containsNodeModel(INodeModel iNodeModel) {
        Set set = this.getNodeModels();
        Iterator iterator = set.iterator();
        boolean bl = false;
        while (!bl && iterator.hasNext()) {
            bl = ((INodeModel)iterator.next()).equals(iNodeModel);
        }
        return bl;
    }

    public boolean containsBlsrSpan(BlsrSpan blsrSpan) {
        if (blsrSpan == null) {
            return false;
        }
        if (blsrSpan.isProtectSpan()) {
            blsrSpan = blsrSpan.getWestSide().getWestMain();
        }
        return this.blsrSpans.contains(blsrSpan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlsrNode getBlsrNode(INodeModel iNodeModel) {
        BlsrNode blsrNode = null;
        Set set = this.blsrNodes;
        synchronized (set) {
            HashSet hashSet = new HashSet(this.blsrNodes);
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext() && !(blsrNode = (BlsrNode)iterator.next()).getNodeModel().equals(iNodeModel)) {
                blsrNode = null;
            }
        }
        return blsrNode;
    }

    public BlsrSpan[] getPotentialWorkingSpans() throws IllegalStateException {
        if (this.state != 5 && this.state != 7) {
            if (db.on()) {
                db.println("Someone attempted to call getPotentialSpans on a provisioned BlsrRingModel.  Throwing an IllegalStateException");
            }
            throw new IllegalStateException("This method only supported while in the creating state");
        }
        return this.spanCandidates;
    }

    public String getRingName() {
        return this.ringInfo.getRingName();
    }

    public int getRingId() {
        return this.ringInfo.getRingId();
    }

    public BlsrNode[] getBlsrNodes() {
        return BlsrRingModel.toBlsrNodeArray(this.blsrNodes);
    }

    public BlsrSpan[] getWorkingBlsrSpans() {
        return BlsrRingModel.toBlsrSpanArray(this.blsrSpans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlsrSpan[] getProtectBlsrSpans() throws IllegalStateException {
        if (!this.isProvisioned()) {
            throw new IllegalStateException("This Ring Model has not yet been provisioned");
        }
        BlsrSpan[] blsrSpanArray = null;
        Set set = this.blsrSpans;
        synchronized (set) {
            blsrSpanArray = new BlsrSpan[this.blsrSpans.size()];
            Iterator iterator = this.blsrSpans.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                blsrSpanArray[n] = ((BlsrSpan)iterator.next()).getParallelProtectSpan();
                ++n;
            }
        }
        return blsrSpanArray;
    }

    public BlsrSpan[] getWorkingExtensionByteMismatchSpans() {
        ArrayList<BlsrSpan> arrayList = new ArrayList<BlsrSpan>();
        BlsrSpan[] blsrSpanArray = this.getWorkingBlsrSpans();
        for (int i = 0; i < blsrSpanArray.length; ++i) {
            if (db.on()) {
                db.println("getWorkingExtensionByteMismatchSpans is examining " + blsrSpanArray[i]);
            }
            if (blsrSpanArray[i].isExtensionByteInSync()) continue;
            arrayList.add(blsrSpanArray[i]);
        }
        if (db.on()) {
            db.println("The working spans with extension byte trouble are " + arrayList);
        }
        return BlsrRingModel.toBlsrSpanArray(arrayList);
    }

    public BlsrSpan[] getProtectExtensionByteMismatchSpans() {
        ArrayList<BlsrSpan> arrayList = new ArrayList<BlsrSpan>();
        BlsrSpan[] blsrSpanArray = this.getWorkingBlsrSpans();
        for (int i = 0; i < blsrSpanArray.length; ++i) {
            if (db.on()) {
                db.println("getProtectExtensionByteMismatchSpans is examining " + blsrSpanArray[i].getParallelProtectSpan());
            }
            if (blsrSpanArray[i].getParallelProtectSpan().isExtensionByteInSync()) continue;
            arrayList.add(blsrSpanArray[i].getParallelProtectSpan());
        }
        if (db.on()) {
            db.println("The protect spans with extension byte trouble are " + arrayList);
        }
        return BlsrRingModel.toBlsrSpanArray(arrayList);
    }

    public BlsrSpan[] getPotentialProtectExtensionByteMismatchSpans() {
        ArrayList<BlsrSpan> arrayList = new ArrayList<BlsrSpan>();
        BlsrSpan[] blsrSpanArray = this.getWorkingBlsrSpans();
        for (int i = 0; i < blsrSpanArray.length; ++i) {
            if (db.on()) {
                db.println("getPotentialProtectExtensionByteMismatchSpans is examining " + blsrSpanArray[i].getParallelProtectSpanToBe());
            }
            if (blsrSpanArray[i].getParallelProtectSpanToBe().isExtensionByteInSync()) continue;
            arrayList.add(blsrSpanArray[i].getParallelProtectSpanToBe());
        }
        if (db.on()) {
            db.println("The potential protect spans with extension byte trouble are " + arrayList);
        }
        return BlsrRingModel.toBlsrSpanArray(arrayList);
    }

    synchronized void addBlsrNode(BlsrNode blsrNode) {
        if (this.state != 666 && blsrNode != null && blsrNode.isProvisioned()) {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            if (this.blsrNodes.add(blsrNode)) {
                UObservable.addObserver((Object)blsrNode, (Object)this.nodeObserver, (String)className);
                bl = true;
                if (db.on()) {
                    db.println("[addBlsrNode] ^^^^^^^^^^^ Added observer..." + blsrNode);
                }
            }
            BlsrSpan blsrSpan = blsrNode.getEastMain();
            BlsrSpan blsrSpan2 = blsrNode.getWestMain();
            if (blsrSpan != null && !this.blsrSpans.contains(blsrSpan)) {
                UObservable.addObserver((Object)blsrSpan.getDeathNotifier(), (Object)this.spanObserver, (String)className);
                this.blsrSpans.add(blsrSpan);
                bl2 = true;
            }
            if (blsrSpan2 != null && !this.blsrSpans.contains(blsrSpan2)) {
                UObservable.addObserver((Object)blsrSpan2.getDeathNotifier(), (Object)this.spanObserver, (String)className);
                this.blsrSpans.add(blsrSpan2);
                bl3 = true;
            }
            if (db.on()) {
                db.println("[addBlsrNode] ********** Added node: " + blsrNode);
                db.println("[addBlsrNode] ********** Number of nodes in ring: " + this.blsrNodes.size());
                db.println("[addBlsrNode] ********** Number of working spans in ring: " + this.blsrSpans.size());
            }
            if (this.hasDuplicateNodeId()) {
                this.setState(2, 2);
            } else if (!this.isLoopComplete()) {
                this.setState(2, 1);
            } else {
                this.setState(3, 1);
            }
            this.syncRingReversion();
            this.syncSpanReversion();
            if (!this.areAllSpansInSameOSPFArea() && db.on()) {
                db.println("Span added that has wrong OSPF Area id!  Span is one of:");
                db.println("  eastSpan is:" + blsrSpan);
                db.println("  westSpan is:" + blsrSpan2);
            }
            if (bl) {
                UObservable.addObserver((Object)blsrNode, (Object)this.switchClearObserver, (String)className);
                this.nodeAddedNotifier.notifyObservers(blsrNode);
            }
            if (bl2) {
                this.spanAddedNotifier.notifyObservers(blsrSpan);
            }
            if (bl3) {
                this.spanAddedNotifier.notifyObservers(blsrSpan2);
            }
        }
    }

    synchronized void removeBlsrNode(BlsrNode blsrNode) {
        if (blsrNode != null && this.blsrNodes.contains(blsrNode)) {
            BlsrNode blsrNode2;
            this.blsrNodes.remove(blsrNode);
            UObservable.deleteObserver((Object)blsrNode, (Object)this.nodeObserver, (String)className);
            BlsrSpan blsrSpan = blsrNode.getEastMain();
            BlsrSpan blsrSpan2 = blsrNode.getWestMain();
            blsrNode.setEastMain(null);
            blsrNode.setWestMain(null);
            boolean bl = false;
            boolean bl2 = false;
            if (this.blsrSpans.contains(blsrSpan)) {
                UObservable.deleteObserver((Object)blsrSpan.getDeathNotifier(), (Object)this.spanObserver, (String)className);
                this.blsrSpans.remove(blsrSpan);
                blsrNode2 = blsrSpan.getWestSide();
                if (blsrNode2 != null) {
                    blsrNode2.setWestMain(null);
                }
                bl = true;
            }
            if (this.blsrSpans.contains(blsrSpan2)) {
                UObservable.deleteObserver((Object)blsrSpan2.getDeathNotifier(), (Object)this.spanObserver, (String)className);
                this.blsrSpans.remove(blsrSpan2);
                blsrNode2 = blsrSpan2.getEastSide();
                if (blsrNode2 != null) {
                    blsrNode2.setEastMain(null);
                }
                bl2 = true;
            }
            if (this.blsrNodes.isEmpty()) {
                this.destroy();
            } else if (this.state == 6) {
                this.setState(6, 4);
            } else {
                this.setState(2, 4);
            }
            UObservable.deleteObserver((Object)blsrNode, (Object)this.switchClearObserver, (String)className);
            this.nodeRemovedNotifier.notifyObservers(blsrNode);
            if (bl) {
                if (db.on()) {
                    db.println("[removeBlsrNode] -- Notify East Span removed from: " + blsrNode);
                }
                this.spanRemovedNotifier.notifyObservers(blsrSpan);
                blsrSpan.destroy();
            }
            if (bl2) {
                if (db.on()) {
                    db.println("[removeBlsrNode] -- Notify West Span removed from: " + blsrNode);
                }
                this.spanRemovedNotifier.notifyObservers(blsrSpan2);
                blsrSpan2.destroy();
            }
            if (db.on()) {
                db.println("[removeBlsrNode] ********** Removed node: " + blsrNode);
                db.println("[removeBlsrNode] ********** Number of nodes in ring: " + this.blsrNodes.size());
                db.println("[removeBlsrNode] ********** Number of working spans in ring: " + this.blsrSpans.size());
            }
        } else if (null == blsrNode) {
            if (BlsrRingModel.db.on) {
                db.println("blsrNode is NULL!");
            }
        } else if (BlsrRingModel.db.on) {
            db.println("blsrNode must not be in the list! blsrNodes.contains(blsrNode) = " + this.blsrNodes.contains(blsrNode));
        }
        if (this.isLoopComplete()) {
            this.setState(3, 10);
        }
    }

    public Long getOspfArea() {
        this.areAllSpansInSameOSPFArea();
        return this.ospfArea;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean areAllSpansInSameOSPFArea() {
        BlsrSpan blsrSpan;
        Iterator iterator;
        HashSet<Long> hashSet = new HashSet<Long>();
        Long l = null;
        Set set = this.blsrSpans;
        synchronized (set) {
            iterator = this.blsrSpans.iterator();
            while (iterator.hasNext()) {
                blsrSpan = (BlsrSpan)iterator.next();
                l = new Long(blsrSpan.getOspfAreaId());
                hashSet.add(l);
                if (hashSet.size() <= 1) continue;
                break;
            }
        }
        if (hashSet.size() > 1) {
            this.ospfArea = OSPF_AREA_INCONSISTENT;
            if (db.on()) {
                db.println("BLSR spans are NOT in same OSPF Area:");
                set = this.blsrSpans;
                synchronized (set) {
                    iterator = this.blsrSpans.iterator();
                    while (iterator.hasNext()) {
                        blsrSpan = (BlsrSpan)iterator.next();
                        db.println(blsrSpan + " has OSPF Area ID of " + blsrSpan.getOspfAreaId());
                    }
                }
            }
            return false;
        }
        this.ospfArea = l;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sanityCheck() throws NodeUnreachableException, TooManyBlsrException, BlsrRingIdInUseException, SpanNoLongerPresentException, PathSelectorOnSpanException, InvalidProtectPortsSpecifiedException, CircuitOnHighAndLowHOException, SpanAlreadyInBlsrException, PortsNotSpecifiedException, PortsSdccTerminatedException, PortsNotEnabledException, TimingReferenceException, PortsWithOrderwireException, PortsInProtectionGroupException, InconsistentMediumTypeException, OspfAreaException, WigglingCircuitException, IncompatibleBlsrNodesException, TopoUpgradeNotSupportedException {
        Object object;
        HashSet hashSet;
        db.fine("Blsr wizard sanity check called.");
        if (!this.areAllSpansInSameOSPFArea()) {
            throw new OspfAreaException(this.blsrTerm);
        }
        Collection collection = this.getInitedNodes(this.blsrNodes);
        HashSet<BlsrSpan> hashSet2 = this.blsrNodes;
        synchronized (hashSet2) {
            hashSet = new HashSet(this.blsrNodes);
        }
        hashSet.removeAll(collection);
        if (hashSet.size() > 0) {
            if (db.on()) {
                db.println("Sanity check failed.  Throwing NodeUnreachableException.");
            }
            throw new NodeUnreachableException(BlsrRingModel.toBlsrNodeArray(hashSet), this.blsrTerm);
        }
        hashSet2 = new HashSet<BlsrSpan>(Arrays.asList(this.getAllSpansOfRightSpeed()));
        HashSet hashSet3 = null;
        Set set = this.blsrSpans;
        synchronized (set) {
            hashSet3 = new HashSet(this.blsrSpans);
        }
        if (!hashSet2.containsAll(hashSet3)) {
            hashSet3.removeAll(hashSet2);
            if (db.on()) {
                db.println("Sanity check failed.  Throwing SpanNoLongerPresentException.");
            }
            throw new SpanNoLongerPresentException(BlsrRingModel.toBlsrSpanArray(hashSet3), this.blsrTerm);
        }
        set = this.getAllSpansWithoutTopoUpgradeSupport(BlsrRingModel.toBlsrSpanArray(this.blsrSpans));
        if (((HashSet)set).size() > 0) {
            if (db.on()) {
                db.println("Sanity check failed. Throwing TopoUpgradeNotSupportedException.");
            }
            INodeModel[] iNodeModelArray = new INodeModel[((HashSet)set).size()];
            ((HashSet)set).toArray(iNodeModelArray);
            throw new TopoUpgradeNotSupportedException(iNodeModelArray);
        }
        HashSet hashSet4 = new HashSet();
        this.getAllSpansWithCompatibleFeatureVersions(BlsrRingModel.toBlsrSpanArray(this.blsrSpans), hashSet4);
        if (hashSet4.size() > 0) {
            if (db.on()) {
                db.println("Sanity check failed. Throwing IncompatibleBlsrNodesException.");
            }
            throw new IncompatibleBlsrNodesException(this.blsrTerm, BlsrRingModel.toBundleArray(hashSet4));
        }
        if (this.state != 7 && !this.getWigglingCircuits().isEmpty()) {
            db.warning("Sanity check failed.  Throwing WigglingCircuitException.");
            throw new WigglingCircuitException(this.blsrTerm);
        }
        if (this.state != 7 && !(object = new HashSet<BlsrSpan>(Arrays.asList(BlsrRingModel.getAllSpansWithOutPathSelectors(BlsrRingModel.toBlsrSpanArray(hashSet2))))).containsAll(hashSet3)) {
            hashSet3.removeAll((Collection<?>)object);
            if (db.on()) {
                db.println("Sanity check failed. Throwing PathSelectorOnSpanException.");
            }
            throw new PathSelectorOnSpanException(BlsrRingModel.toBlsrSpanArray(hashSet3), this.blsrTerm);
        }
        if (!this.getBlsrRingInfo().isFourFiber() && !(object = this.getHighLowSpans(hashSet3)).isEmpty()) {
            if (db.on()) {
                db.println("Sanity check failed. Throwing CircuitUsingHighHOOnSpanException.");
            }
            throw new CircuitOnHighAndLowHOException(BlsrRingModel.toBlsrSpanArray(object.keySet()), this.blsrTerm);
        }
        object = this.getNodesWithBlsrOfSameRingName(this.blsrNodes);
        if (object.size() > 0) {
            if (db.on()) {
                db.println("Sanity check failed.  Throwing BlsrRingIdInUseException");
            }
            throw new BlsrRingIdInUseException(BlsrRingModel.toBlsrNodeArray((Collection)object), this.ringInfo.getRingName(), this.blsrTerm);
        }
        HashSet<BlsrSpan> hashSet5 = new HashSet<BlsrSpan>(Arrays.asList(BlsrRingModel.getAllSpansNotParticipatingInABlsr(BlsrRingModel.toBlsrSpanArray(hashSet2))));
        if (!hashSet5.containsAll(hashSet3)) {
            hashSet3.removeAll(hashSet5);
            if (db.on()) {
                db.println("Sanity check failed.  Throwing SpanAlreadyInBlsrException.");
            }
            throw new SpanAlreadyInBlsrException(BlsrRingModel.toBlsrSpanArray(hashSet3), this.blsrTerm);
        }
        HashSet<BlsrSpan> hashSet6 = new HashSet<BlsrSpan>(Arrays.asList(BlsrRingModel.getAllSpansOfConsistentMediumType(BlsrRingModel.toBlsrSpanArray(hashSet2), null)));
        if (!hashSet6.containsAll(hashSet3)) {
            hashSet3.removeAll(hashSet6);
            if (db.on()) {
                db.println("Sanity check failed.  Throwing InconsistentMediumTypeException.");
            }
            throw new InconsistentMediumTypeException(new HashSet(hashSet3));
        }
        Set set2 = this.getNodesWithTooManyBlsrs(this.blsrNodes);
        if (set2.size() > 0) {
            if (db.on()) {
                db.println("Sanity check failed.  Throwing TooManyBlsrException");
            }
            throw new TooManyBlsrException(BlsrRingModel.toBlsrNodeArray(set2), this.blsrTerm);
        }
        Set set3 = this.getNodesWithWorkingPortsInProtectionGroup(this.blsrNodes);
        if (!set3.isEmpty()) {
            if (db.on()) {
                db.println("Sanity check failed.  Nodes have ports in protection groups.");
            }
            throw new PortsInProtectionGroupException(set3);
        }
        if (this.ringInfo.isFourFiber()) {
            HashSet<BlsrNode> hashSet7 = new HashSet<BlsrNode>();
            BlsrNode blsrNode = null;
            ITdmPortModel[] iTdmPortModelArray = null;
            Set set4 = this.blsrNodes;
            synchronized (set4) {
                Iterator iterator = this.blsrNodes.iterator();
                while (iterator.hasNext()) {
                    blsrNode = (BlsrNode)iterator.next();
                    iTdmPortModelArray = this.getPotentialProtectPorts(blsrNode.getNodeModel());
                    boolean bl = false;
                    boolean bl2 = false;
                    for (int i = 0; i < iTdmPortModelArray.length; ++i) {
                        if (iTdmPortModelArray[i].equals(blsrNode.getEastProtectPort())) {
                            bl = true;
                        }
                        if (!iTdmPortModelArray[i].equals(blsrNode.getWestProtectPort())) continue;
                        bl2 = true;
                    }
                    if (bl2 || bl) continue;
                    hashSet7.add(blsrNode);
                }
            }
            if (hashSet7.size() > 0) {
                if (db.on()) {
                    db.println("Sanity check has failed.  Throwing InvalidProtectPortsSpecifiedException");
                }
                throw new InvalidProtectPortsSpecifiedException(BlsrRingModel.toBlsrNodeArray(hashSet7), this.blsrTerm);
            }
            this.sanityCheckUpgrade();
        }
        if (db.on()) {
            db.println("Sanity check passes!!!  Hoorah!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sanityCheckUpgrade() throws TimingReferenceException, PortsNotSpecifiedException, PortsNotEnabledException, PortsSdccTerminatedException, PortsWithOrderwireException {
        HashSet<BlsrNode> hashSet = new HashSet<BlsrNode>();
        Set set = this.blsrNodes;
        synchronized (set) {
            BlsrNode blsrNode;
            Iterator iterator = this.blsrNodes.iterator();
            while (iterator.hasNext()) {
                blsrNode = (BlsrNode)iterator.next();
                if (blsrNode.isProtectPortsSpecified()) continue;
                hashSet.add(blsrNode);
            }
            if (!hashSet.isEmpty()) {
                throw new PortsNotSpecifiedException(hashSet);
            }
            iterator = this.blsrNodes.iterator();
            while (iterator.hasNext()) {
                blsrNode = (BlsrNode)iterator.next();
                if (blsrNode.isProtectPortsEnabled()) continue;
                hashSet.add(blsrNode);
            }
            if (!hashSet.isEmpty()) {
                throw new PortsNotEnabledException(hashSet);
            }
            iterator = this.blsrNodes.iterator();
            while (iterator.hasNext()) {
                blsrNode = (BlsrNode)iterator.next();
                if (!blsrNode.isProtectPortsSdccEnabled()) continue;
                hashSet.add(blsrNode);
            }
            if (!hashSet.isEmpty()) {
                throw new PortsSdccTerminatedException(hashSet);
            }
            iterator = this.blsrNodes.iterator();
            while (iterator.hasNext()) {
                blsrNode = (BlsrNode)iterator.next();
                if (!blsrNode.isProtectPortsTimingReference()) continue;
                hashSet.add(blsrNode);
            }
            if (!hashSet.isEmpty()) {
                throw new TimingReferenceException(hashSet);
            }
            iterator = this.blsrNodes.iterator();
            while (iterator.hasNext()) {
                blsrNode = (BlsrNode)iterator.next();
                if (!blsrNode.isOrderwireOnProtectPorts()) continue;
                hashSet.add(blsrNode);
            }
            if (!hashSet.isEmpty()) {
                throw new PortsWithOrderwireException(hashSet);
            }
        }
    }

    private void resetNodeId() {
        this.nodeId = 0;
    }

    private short generatedNodeId() {
        if (this.nodeId >= 32) {
            this.resetNodeId();
        }
        short s = this.nodeId;
        this.nodeId = (short)(s + 1);
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementNodeId() {
        Set set = this.blsrNodes;
        synchronized (set) {
            Iterator iterator = this.blsrNodes.iterator();
            BlsrNode blsrNode = null;
            this.resetNodeId();
            while (iterator.hasNext()) {
                blsrNode = (BlsrNode)iterator.next();
                try {
                    blsrNode.setNodeId(this.generatedNodeId());
                }
                catch (DuplicateNodeId duplicateNodeId) {
                    if (BlsrRingModel.db.on) {
                        db.println("DuplicateNodeId caught in decrementNodeId()");
                    }
                    SDebug.printStackTrace((Throwable)duplicateNodeId);
                }
                catch (BlsrSpanSwitched blsrSpanSwitched) {
                    db.fine("BlsrSpanSwitched caught in decrementNodeId()");
                    SDebug.printStackTrace((Throwable)blsrSpanSwitched);
                }
            }
        }
    }

    public void addBlsrSpan(BlsrSpan blsrSpan) throws ParallelSpanAlreadyPresentException, MultipleSpansInCardException, OspfAreaException, WigglingCircuitException, RingTooLargeException, IllegalStateException, InvalidRingNameException {
        if (this.state != 5 && this.state != 4 && this.state != 7) {
            throw new IllegalStateException("Trying to add span while ring is not in CREATING, EDITING, or UPSR2BLSR_CONVERSION state.");
        }
        this.wizardAddBlsrSpan(blsrSpan);
    }

    private boolean isRingNameValid(BlsrSpan blsrSpan) {
        boolean bl = false;
        BlsrNode blsrNode = this.unprovisionedBlsrNodeLookUp(blsrSpan.getOriginalLink().getSrc().getNodeModel());
        BlsrNode blsrNode2 = this.unprovisionedBlsrNodeLookUp(blsrSpan.getOriginalLink().getDst().getNodeModel());
        short s = blsrNode.getNodeModel().getIElementModels().getBlsrLimits().getRingNameLength();
        short s2 = blsrNode2.getNodeModel().getIElementModels().getBlsrLimits().getRingNameLength();
        if (!blsrNode.getNodeModel().provides(Feature.BLSR_PATRIOT_EXTENSIONS) || !blsrNode2.getNodeModel().provides(Feature.BLSR_PATRIOT_EXTENSIONS)) {
            try {
                short s3 = Short.parseShort(this.ringInfo.getRingName());
                bl = s3 >= 0 && s3 <= 9999;
            }
            catch (NumberFormatException numberFormatException) {
                if (db.on()) {
                    db.println(blsrNode + " and " + blsrNode2 + " do not support alphanumeric ring IDs.");
                }
            }
        } else {
            bl = this.ringInfo.getRingName().length() <= Math.min(s, s2);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxRingNameLength() {
        int n = Integer.MAX_VALUE;
        Set set = this.blsrNodes;
        synchronized (set) {
            Iterator iterator = this.blsrNodes.iterator();
            while (iterator.hasNext()) {
                n = Math.min(n, ((BlsrNode)iterator.next()).getNodeModel().getIElementModels().getBlsrLimits().getRingNameLength());
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRingTooBig(BlsrSpan blsrSpan) {
        int n;
        BlsrNode blsrNode = this.unprovisionedBlsrNodeLookUp(blsrSpan.getOriginalLink().getSrc().getNodeModel());
        BlsrNode blsrNode2 = this.unprovisionedBlsrNodeLookUp(blsrSpan.getOriginalLink().getDst().getNodeModel());
        int n2 = Math.min(blsrNode.getNodeModel().getIElementModels().getBlsrLimits().getMaxNodesIn2FiberRing(), blsrNode2.getNodeModel().getIElementModels().getBlsrLimits().getMaxNodesIn2FiberRing());
        int n3 = Math.min(blsrNode.getNodeModel().getIElementModels().getBlsrLimits().getMaxNodesIn4FiberRing(), blsrNode2.getNodeModel().getIElementModels().getBlsrLimits().getMaxNodesIn4FiberRing());
        Set set = this.blsrNodes;
        synchronized (set) {
            HashSet<BlsrNode> hashSet = new HashSet<BlsrNode>(this.blsrNodes);
            hashSet.add(blsrNode);
            hashSet.add(blsrNode2);
            n = hashSet.size();
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                BlsrNode blsrNode3 = (BlsrNode)iterator.next();
                n2 = Math.min(n2, blsrNode3.getNodeModel().getIElementModels().getBlsrLimits().getMaxNodesIn2FiberRing());
                n3 = Math.min(n3, blsrNode3.getNodeModel().getIElementModels().getBlsrLimits().getMaxNodesIn4FiberRing());
            }
        }
        if (db.on()) {
            db.println("The maximum number of nodes in a ring is " + n2);
            db.println("The maximum number of nodes in a 4F ring is " + n3);
        }
        if (this.ringInfo.isFourFiber()) {
            return n > n3;
        }
        return n > n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wizardAddBlsrSpan(BlsrSpan blsrSpan) throws ParallelSpanAlreadyPresentException, MultipleSpansInCardException, OspfAreaException, WigglingCircuitException, RingTooLargeException, InvalidRingNameException {
        int n;
        int n2;
        ITdmPortModel iTdmPortModel;
        HashSet hashSet;
        BlsrNode blsrNode;
        BlsrNode blsrNode2;
        block67: {
            INetLink iNetLink = blsrSpan.getOriginalLink();
            INodeModel iNodeModel = iNetLink.getSrc().getNodeModel();
            INodeModel iNodeModel2 = iNetLink.getDst().getNodeModel();
            blsrNode2 = this.unprovisionedBlsrNodeLookUp(iNodeModel);
            blsrNode = this.unprovisionedBlsrNodeLookUp(iNodeModel2);
            db.fine("srcNode: " + blsrNode2 + " dstNode: " + blsrNode);
            db.fine("----- Checking ring size ...");
            if (this.isRingTooBig(blsrSpan)) {
                db.warning("Ring is too big!");
                throw new RingTooLargeException(this.blsrTerm);
            }
            db.fine("----- Checking ring name ...");
            if (!this.isRingNameValid(blsrSpan)) {
                db.warning("Ring name '" + this.ringInfo.getRingName() + "' is invalid!");
                throw new InvalidRingNameException(this.ringInfo.getRingName());
            }
            db.fine("----- Checking OSPF Area ...");
            long l = blsrSpan.getOspfAreaId();
            if (this.blsrSpans.isEmpty()) {
                this.ospfArea = new Long(l);
            } else if (this.ospfArea != l) {
                db.warning("Span " + blsrSpan + " is in different OSPF Area!");
                throw new OspfAreaException(blsrSpan);
            }
            db.fine("----- Checking for wiggling circuits ...");
            HashSet<BlsrSpan> hashSet2 = null;
            hashSet = this.blsrSpans;
            synchronized (hashSet) {
                hashSet2 = new HashSet<BlsrSpan>(this.blsrSpans);
            }
            hashSet2.add(blsrSpan);
            if (this.state != 7 && !this.getWigglers(hashSet2).isEmpty()) {
                db.warning("Can't add " + blsrSpan + " to the ring.  It will introduce wigglers.");
                if (db.on()) {
                    hashSet = new HashSet();
                    BlsrRingModel.getLinkCircuits(hashSet, blsrSpan.getOriginalLink(), null);
                    BlsrRingModel.getLinkCircuits(hashSet, blsrSpan.getReverseLink(), null);
                    Iterator iterator = hashSet.iterator();
                    while (iterator.hasNext()) {
                        SpanRow spanRow = (SpanRow)iterator.next();
                        INetCircuit iNetCircuit = spanRow.getCircuit();
                        String string = spanRow.getSpan().getLink().getLinkModel().blsrRingName();
                        db.fine("\t" + iNetCircuit + " on span " + spanRow + (string != "" ? " (part of BLSR " + string + ")" : ""));
                    }
                }
                throw new WigglingCircuitException(this.blsrTerm);
            }
            hashSet = null;
            iTdmPortModel = null;
            try {
                int n3 = iNetLink.getSrcEntityIndex();
                hashSet = (ITdmPortModel)iNodeModel.getEntityTable().getEntityModelByIndex(n3);
                n2 = hashSet.getSlot();
                n3 = iNetLink.getDstEntityIndex();
                iTdmPortModel = (ITdmPortModel)iNodeModel2.getEntityTable().getEntityModelByIndex(n3);
                n = iTdmPortModel.getSlot();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                n2 = -1;
                n = -1;
                if (!db.on()) break block67;
                db.println("[wizardAddBlsrSpan] " + (Object)((Object)abstractCmsNoSuchEntityException));
            }
        }
        if (!this.blsrNodes.contains(blsrNode2) && !this.blsrNodes.contains(blsrNode)) {
            if (db.on()) {
                db.println("Ring does not contain any of the nodes.");
            }
            if (n2 < n) {
                this.setSourceWestDestEast(blsrSpan, blsrNode2, blsrNode, (ITdmPortModel)hashSet, iTdmPortModel);
            } else {
                this.setSourceEastDestWest(blsrSpan, blsrNode2, blsrNode, (ITdmPortModel)hashSet, iTdmPortModel);
            }
            try {
                blsrNode2.setNodeId(this.generatedNodeId());
                blsrNode.setNodeId(this.generatedNodeId());
            }
            catch (DuplicateNodeId duplicateNodeId) {
                if (db.on()) {
                    db.println("DuplicateNodeId exception : " + (Object)((Object)duplicateNodeId));
                }
            }
            catch (BlsrSpanSwitched blsrSpanSwitched) {
                db.fine("BlsrSpanSwitched exception : " + (Object)((Object)blsrSpanSwitched));
            }
            this.blsrNodes.add(blsrNode2);
            this.blsrNodes.add(blsrNode);
        } else if (this.blsrNodes.contains(blsrNode2) && !this.blsrNodes.contains(blsrNode)) {
            if (db.on()) {
                db.println("Ring contains " + blsrNode2 + " but not " + blsrNode);
            }
            if (blsrNode2.getEastMain() == null) {
                int n4 = n2;
                int n5 = blsrNode2.getWestPort().getSlot();
                if (n5 == n4) {
                    throw new MultipleSpansInCardException(blsrSpan);
                }
                this.setSourceEastDestWest(blsrSpan, blsrNode2, blsrNode, (ITdmPortModel)hashSet, iTdmPortModel);
            } else if (blsrNode2.getWestMain() == null) {
                int n6 = n2;
                int n7 = blsrNode2.getEastPort().getSlot();
                if (n6 == n7) {
                    throw new MultipleSpansInCardException(blsrSpan);
                }
                this.setSourceWestDestEast(blsrSpan, blsrNode2, blsrNode, (ITdmPortModel)hashSet, iTdmPortModel);
            } else {
                throw new ParallelSpanAlreadyPresentException(blsrSpan);
            }
            try {
                blsrNode.setNodeId(this.generatedNodeId());
            }
            catch (DuplicateNodeId duplicateNodeId) {
                if (db.on()) {
                    db.println("DuplcateNodeId caught: " + (Object)((Object)duplicateNodeId));
                }
            }
            catch (BlsrSpanSwitched blsrSpanSwitched) {
                db.fine("BlsrSpanSwitched caught : " + (Object)((Object)blsrSpanSwitched));
            }
            this.blsrNodes.add(blsrNode);
        } else if (!this.blsrNodes.contains(blsrNode2) && this.blsrNodes.contains(blsrNode)) {
            if (db.on()) {
                db.println("Ring does not contain " + blsrNode2 + " but contains " + blsrNode);
            }
            if (blsrNode.getEastMain() == null) {
                int n8 = n;
                int n9 = blsrNode.getWestPort().getSlot();
                if (n9 == n8) {
                    throw new MultipleSpansInCardException(blsrSpan);
                }
                this.setSourceWestDestEast(blsrSpan, blsrNode2, blsrNode, (ITdmPortModel)hashSet, iTdmPortModel);
            } else if (blsrNode.getWestMain() == null) {
                int n10 = n;
                int n11 = blsrNode.getEastPort().getSlot();
                if (n10 == n11) {
                    throw new MultipleSpansInCardException(blsrSpan);
                }
                this.setSourceEastDestWest(blsrSpan, blsrNode2, blsrNode, (ITdmPortModel)hashSet, iTdmPortModel);
            } else {
                throw new ParallelSpanAlreadyPresentException(blsrSpan);
            }
            try {
                blsrNode2.setNodeId(this.generatedNodeId());
            }
            catch (DuplicateNodeId duplicateNodeId) {
                if (db.on()) {
                    db.println("DuplcateNodeId caught: " + (Object)((Object)duplicateNodeId));
                }
            }
            catch (BlsrSpanSwitched blsrSpanSwitched) {
                db.fine("BlsrSpanSwitched caught : " + (Object)((Object)blsrSpanSwitched));
            }
            this.blsrNodes.add(blsrNode2);
        } else {
            if (db.on()) {
                db.println("Ring contains both nodes, " + blsrNode2 + " and " + blsrNode);
            }
            if (this.blsrSpans.contains(blsrSpan)) {
                if (db.on()) {
                    db.println("In addSpan and attempting to add " + blsrSpan + ".  Throwing parallelSpanException as " + "this span was already added.");
                }
                throw new ParallelSpanAlreadyPresentException(blsrSpan);
            }
            if (blsrNode2.getEastMain() == null && blsrNode.getWestMain() == null) {
                if (n2 == blsrNode2.getWestPort().getSlot() || n == blsrNode.getEastPort().getSlot()) {
                    throw new MultipleSpansInCardException(blsrSpan);
                }
                this.setSourceEastDestWest(blsrSpan, blsrNode2, blsrNode, (ITdmPortModel)hashSet, iTdmPortModel);
            } else if (blsrNode2.getWestMain() == null && blsrNode.getEastMain() == null) {
                if (n2 == blsrNode2.getEastPort().getSlot() || n == blsrNode.getWestPort().getSlot()) {
                    throw new MultipleSpansInCardException(blsrSpan);
                }
                this.setSourceWestDestEast(blsrSpan, blsrNode2, blsrNode, (ITdmPortModel)hashSet, iTdmPortModel);
            } else if (blsrNode2.getWestMain() == null && blsrNode.getWestMain() == null) {
                if (n2 == blsrNode2.getEastPort().getSlot() || n == blsrNode.getEastPort().getSlot()) {
                    throw new MultipleSpansInCardException(blsrSpan);
                }
                if (db.on()) {
                    db.println("Reversed span " + blsrNode2.getEastMain());
                }
                this.reverseSpanDirection(blsrNode2.getEastMain());
                this.setSourceEastDestWest(blsrSpan, blsrNode2, blsrNode, (ITdmPortModel)hashSet, iTdmPortModel);
            } else if (blsrNode2.getEastMain() == null && blsrNode.getEastMain() == null) {
                if (n2 == blsrNode2.getWestPort().getSlot() || n == blsrNode.getWestPort().getSlot()) {
                    throw new MultipleSpansInCardException(blsrSpan);
                }
                if (db.on()) {
                    db.println("Reversed span " + blsrNode2.getWestMain());
                }
                this.reverseSpanDirection(blsrNode2.getWestMain());
                this.setSourceWestDestEast(blsrSpan, blsrNode2, blsrNode, (ITdmPortModel)hashSet, iTdmPortModel);
            } else {
                if (db.on()) {
                    db.println("Trying to add " + blsrSpan + " in addSpan.  The addition of this span would over define some nodes and " + " so a parallelSpanException is being thrown.");
                }
                throw new ParallelSpanAlreadyPresentException(blsrSpan);
            }
        }
        this.blsrSpans.add(blsrSpan);
        BlsrRingManager blsrRingManager = BlsrRingManager.instance();
        blsrRingManager.registerBlsrNetLink(blsrSpan.getOriginalLink());
        if (db.on()) {
            db.println(blsrNode2 + " is connected to " + blsrNode);
            db.println("The ring has " + this.blsrNodes.size() + " nodes.");
            db.println("The ring has " + this.blsrSpans.size() + " spans.");
        }
    }

    private void setSourceWestDestEast(BlsrSpan blsrSpan, BlsrNode blsrNode, BlsrNode blsrNode2, ITdmPortModel iTdmPortModel, ITdmPortModel iTdmPortModel2) {
        blsrNode.setWestMain(blsrSpan);
        blsrNode.setWestPort(iTdmPortModel);
        blsrSpan.setWestSide(blsrNode);
        blsrNode2.setEastMain(blsrSpan);
        blsrNode2.setEastPort(iTdmPortModel2);
        blsrSpan.setEastSide(blsrNode2);
    }

    private void setSourceEastDestWest(BlsrSpan blsrSpan, BlsrNode blsrNode, BlsrNode blsrNode2, ITdmPortModel iTdmPortModel, ITdmPortModel iTdmPortModel2) {
        blsrNode.setEastMain(blsrSpan);
        blsrNode.setEastPort(iTdmPortModel);
        blsrSpan.setEastSide(blsrNode);
        blsrNode2.setWestMain(blsrSpan);
        blsrNode2.setWestPort(iTdmPortModel2);
        blsrSpan.setWestSide(blsrNode2);
    }

    private void addDiscoveredBlsrSpan(BlsrSpan blsrSpan) {
        if (this.state != 666 && blsrSpan != null && !this.blsrSpans.contains(blsrSpan)) {
            if (db.on()) {
                db.println("[addDiscoveredBlsrSpan] Added DeathNotifier for span: " + blsrSpan);
            }
            UObservable.addObserver((Object)blsrSpan.getDeathNotifier(), (Object)this.spanObserver, (String)className);
            this.blsrSpans.add(blsrSpan);
            this.spanAddedNotifier.notifyObservers(blsrSpan);
            this.spanAddedNotifier.notifyObservers(blsrSpan.getParallelProtectSpan());
            if (db.on()) {
                db.println("[addDiscoveredBlsrSpan] Added span: " + blsrSpan);
                db.println("[addDiscoveredBlsrSpan] Added protect span: " + blsrSpan.getParallelProtectSpan());
            }
            if (this.isLoopComplete()) {
                this.setState(3, 3);
            }
            this.syncRingReversion();
            this.syncSpanReversion();
            if (!this.areAllSpansInSameOSPFArea() && db.on()) {
                db.println("Span added that has wrong OSPF Area id!  Span:" + blsrSpan);
            }
        } else if (db.on() && this.blsrSpans.contains(blsrSpan)) {
            db.println("[addDiscoveredBlsrSpan] " + blsrSpan + " is already present in the ring.  Ignored.");
        }
    }

    synchronized void addDiscoveredBlsrSpans(BlsrSpan[] blsrSpanArray) {
        if (db.isInfoEnabled()) {
            db.info("[addDiscoveredBlsrSpans]:" + Thread.currentThread().getName());
        }
        if (blsrSpanArray != null) {
            for (int i = 0; i < blsrSpanArray.length; ++i) {
                this.addDiscoveredBlsrSpan(blsrSpanArray[i]);
            }
        }
    }

    public void removeBlsrSpan(BlsrSpan blsrSpan) throws IllegalStateException {
        if (this.state != 5 && this.state != 4 && this.state != 7) {
            throw new IllegalStateException("Trying to remove span while ring is not in CREATING, EDITING, or UPSR2BLSR_CONVERSION state.");
        }
        this.wizardRemoveBlsrSpan(blsrSpan);
    }

    private void wizardRemoveBlsrSpan(BlsrSpan blsrSpan) {
        if (db.on()) {
            db.println("[wizardRemoveBlsrSpan] called with: " + blsrSpan);
        }
        BlsrNode blsrNode = blsrSpan.getEastSide();
        BlsrNode blsrNode2 = blsrSpan.getWestSide();
        blsrNode.setEastMain(null);
        blsrNode2.setWestMain(null);
        blsrNode.setEastPort(null);
        blsrNode2.setWestPort(null);
        if (blsrNode.getWestMain() == null) {
            if (this.blsrNodes.remove(blsrNode)) {
                db.println("[wizardRemoveBlsrSpan] removed node: " + blsrNode);
            }
            try {
                blsrNode.setNodeId((short)-1);
            }
            catch (DuplicateNodeId duplicateNodeId) {
                if (db.on()) {
                    db.println("DuplicateNodeId caught: " + (Object)((Object)duplicateNodeId));
                }
            }
            catch (BlsrSpanSwitched blsrSpanSwitched) {
                db.fine("BlsrSpanSwitched caught : " + (Object)((Object)blsrSpanSwitched));
            }
            this.decrementNodeId();
        }
        if (blsrNode2.getEastMain() == null) {
            if (this.blsrNodes.remove(blsrNode2)) {
                db.println("[wizardRemoveBlsrSpan] removed node: " + blsrNode2);
            }
            try {
                blsrNode2.setNodeId((short)-1);
            }
            catch (DuplicateNodeId duplicateNodeId) {
                if (db.on()) {
                    db.println("DuplicateNodeId caught: " + (Object)((Object)duplicateNodeId));
                }
            }
            catch (BlsrSpanSwitched blsrSpanSwitched) {
                db.fine("BlsrSpanSwitched caught : " + (Object)((Object)blsrSpanSwitched));
            }
            this.decrementNodeId();
        }
        if (this.blsrSpans.remove(blsrSpan) && db.on()) {
            db.println("Span was removed: " + blsrSpan);
        }
        this.areAllSpansInSameOSPFArea();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDiscoveredBlsrSpan(BlsrSpan blsrSpan) {
        BlsrNode[] blsrNodeArray = null;
        BlsrRingModel blsrRingModel = this;
        synchronized (blsrRingModel) {
            if (db.isInfoEnabled()) {
                db.info("[removeDiscoveredBlsrSpan]:" + Thread.currentThread().getName());
            }
            if (this.blsrSpans.remove(blsrSpan)) {
                this.areAllSpansInSameOSPFArea();
                this.spanRemovedNotifier.notifyObservers(blsrSpan);
                UObservable.deleteObserver((Object)blsrSpan.getDeathNotifier(), (Object)this.spanObserver, (String)className);
                BlsrNode blsrNode = blsrSpan.getEastSide();
                BlsrNode blsrNode2 = blsrSpan.getWestSide();
                if (blsrNode.getEastProtectPort() != null && blsrNode2.getWestProtectPort() != null) {
                    this.spanRemovedNotifier.notifyObservers(blsrSpan.getParallelProtectSpan());
                }
                if (blsrNode != null) {
                    blsrNode.setEastMain(null);
                }
                if (blsrNode2 != null) {
                    blsrNode2.setWestMain(null);
                }
                if (this.state == 3) {
                    db.finest("ring is now incomplete due to " + blsrSpan + " removal.");
                    this.setState(2, 5);
                } else if (!this.isNodeReachable(blsrNode2, blsrNode)) {
                    db.finest("ring is now incomplete due to " + blsrSpan + " down.");
                    this.setState(2, 6);
                } else {
                    db.finest("ring is now partitioned due to " + blsrSpan + " removal.");
                    blsrNodeArray = this.disuniteRing();
                }
            } else {
                db.fine("[removeDiscoveredBlsrSpan] blsrSpan: " + blsrSpan + " ignored.");
            }
        }
        this.stitchNodes(blsrNodeArray);
    }

    public void reverseSpanDirection(BlsrSpan blsrSpan) {
        BlsrNode blsrNode;
        HashSet<BlsrSpan> hashSet = new HashSet<BlsrSpan>();
        HashSet<BlsrNode> hashSet2 = new HashSet<BlsrNode>();
        if (db.on()) {
            db.println("\nThis ring has " + this.blsrSpans.size() + " spans");
        }
        BlsrNode blsrNode2 = blsrSpan.getEastSide();
        BlsrNode blsrNode3 = blsrSpan.getWestSide();
        hashSet.add(blsrSpan);
        hashSet2.add(blsrNode2);
        hashSet2.add(blsrNode3);
        BlsrSpan blsrSpan2 = blsrNode2.getWestMain();
        while (blsrSpan2 != null && !hashSet.contains(blsrSpan2)) {
            hashSet.add(blsrSpan2);
            blsrNode = blsrSpan2.getEastSide();
            if (blsrNode != null) {
                blsrSpan2 = blsrNode.getWestMain();
                hashSet2.add(blsrNode);
                continue;
            }
            blsrSpan2 = null;
        }
        blsrSpan2 = blsrNode3.getEastMain();
        while (blsrSpan2 != null && !hashSet.contains(blsrSpan2)) {
            hashSet.add(blsrSpan2);
            blsrNode = blsrSpan2.getWestSide();
            if (blsrNode != null) {
                blsrSpan2 = blsrNode.getEastMain();
                hashSet2.add(blsrNode);
                continue;
            }
            blsrSpan2 = null;
        }
        Iterator iterator = hashSet2.iterator();
        if (db.on()) {
            db.println("Before reversal:");
            db.println(((Object)hashSet).toString());
            db.println(((Object)hashSet2).toString());
        }
        while (iterator.hasNext()) {
            ((BlsrNode)iterator.next()).reverseDirection();
        }
        if (db.on()) {
            db.println("nodes only reversed:");
            db.println(((Object)hashSet).toString());
            db.println(((Object)hashSet2).toString());
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ((BlsrSpan)iterator.next()).reverseDirection();
        }
        if (db.on()) {
            db.println("After reversal:");
            db.println(((Object)hashSet).toString());
            db.println(((Object)hashSet2).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlsrNode[] disuniteRing() {
        HashSet hashSet;
        BlsrRingManager blsrRingManager = BlsrRingManager.instance();
        boolean bl = true;
        BlsrNode blsrNode = null;
        Object object = this.blsrNodes;
        synchronized (object) {
            hashSet = new HashSet(this.blsrNodes);
        }
        this.destroy();
        object = hashSet.iterator();
        BlsrNode[] blsrNodeArray = new BlsrNode[hashSet.size()];
        int n = 0;
        while (object.hasNext()) {
            blsrNode = (BlsrNode)object.next();
            blsrNode.setEastMain(null);
            blsrNode.setWestMain(null);
            blsrNodeArray[n] = blsrNode;
            ++n;
        }
        return blsrNodeArray;
    }

    private void stitchNodes(BlsrNode[] blsrNodeArray) {
        db.fine("stitchNodes(" + blsrNodeArray + ")");
        if (blsrNodeArray != null) {
            int n = blsrNodeArray.length;
            BlsrRingManager blsrRingManager = BlsrRingManager.instance();
            for (int i = 0; i < n; ++i) {
                BlsrNode blsrNode = blsrNodeArray[i];
                db.fine("[BlsrRingModel] Stitching IBlsrModel " + i);
                if (blsrNode.getBlsrModel() == null || blsrNode.getNodeModel() == null) continue;
                blsrRingManager.stitchBlsrModel(blsrNode.getBlsrModel(), blsrNode.getNodeModel());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasDuplicateNodeId() {
        HashSet hashSet = null;
        boolean bl = false;
        Object object = this.blsrNodes;
        synchronized (object) {
            hashSet = new HashSet(this.blsrNodes);
        }
        object = hashSet.iterator();
        while (!bl && object.hasNext()) {
            BlsrNode blsrNode = (BlsrNode)object.next();
            short s = blsrNode.getNodeId();
            Iterator iterator = hashSet.iterator();
            while (!bl && iterator.hasNext()) {
                BlsrNode blsrNode2 = (BlsrNode)iterator.next();
                if (blsrNode2 == blsrNode || s != blsrNode2.getNodeId()) continue;
                bl = true;
                db.fine("Duplicate NodeID found: " + blsrNode + " (" + s + ") and " + blsrNode2 + " (" + blsrNode2.getNodeId() + ")");
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isNodeReachable(BlsrNode blsrNode, BlsrNode blsrNode2) {
        HashSet hashSet;
        boolean bl = false;
        boolean bl2 = false;
        BlsrNode blsrNode3 = blsrNode;
        String string = "";
        HashSet<BlsrNode> hashSet2 = this.blsrNodes;
        synchronized (hashSet2) {
            hashSet = new HashSet(this.blsrNodes);
        }
        hashSet2 = new HashSet<BlsrNode>();
        if (BlsrRingModel.db.on) {
            db.println("[isNodeReachable] Nodes to visit: " + hashSet);
        }
        hashSet.remove(blsrNode);
        if (blsrNode.getEastMain() == null) {
            bl2 = true;
        }
        if (db.on()) {
            db.println("[isNodeReachable] Direction is west? " + bl2);
            string = string + blsrNode.getNodeModel().getName() + " -> ";
        }
        int n = hashSet.size();
        do {
            BlsrSpan blsrSpan;
            BlsrSpan blsrSpan2 = blsrSpan = bl2 ? blsrNode3.getWestMain() : blsrNode3.getEastMain();
            if (blsrSpan != null && blsrSpan.getOriginalLink().state() != 2) {
                BlsrNode blsrNode4 = blsrSpan.getEastSide();
                BlsrNode blsrNode5 = blsrSpan.getWestSide();
                blsrNode3 = blsrNode4 == blsrNode3 ? blsrNode5 : blsrNode4;
                hashSet.remove(blsrNode3);
                if (!hashSet2.add(blsrNode3)) {
                    if (!db.on()) break;
                    db.println("[isNodeReachable] Quitting; already visited " + blsrNode3);
                    break;
                }
                if (!db.on()) continue;
                string = string + blsrNode3.getNodeModel().getName();
                if (blsrNode2.equals(blsrNode3)) {
                    string = string + " [done]";
                    continue;
                }
                string = string + " -> ";
                continue;
            }
            blsrNode3 = null;
            if (!db.on()) continue;
            string = string + "<null>";
        } while (--n >= 0 && blsrNode3 != null && !blsrNode2.equals(blsrNode3));
        boolean bl3 = bl = blsrNode2.equals(blsrNode3) && hashSet.isEmpty();
        if (db.on()) {
            db.println("[isNodeReachable] " + blsrNode.getNodeModel().getName() + " to " + blsrNode2.getNodeModel().getName() + ": " + bl);
            db.println("[isNodeReachable] " + string);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isProtectionSwitched() {
        boolean bl = false;
        Set set = this.blsrNodes;
        synchronized (set) {
            Iterator iterator = this.blsrNodes.iterator();
            while (iterator.hasNext()) {
                if (!((BlsrNode)iterator.next()).anyChannelStateOnStandby()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public boolean hasProtectionOp() {
        BlsrNode[] blsrNodeArray = this.getBlsrNodes();
        for (int i = 0; i < blsrNodeArray.length; ++i) {
            if (blsrNodeArray[i].isEastProtOpClear() && blsrNodeArray[i].isWestProtOpClear()) continue;
            return true;
        }
        return false;
    }

    public void delete() throws ExistingProtectionSwitchException, LockOutSpanException, BlsrUnprovisionException {
        if (this.isProtectionSwitched()) {
            throw new ExistingProtectionSwitchException();
        }
        if (this.hasProtectionOp()) {
            throw new LockOutSpanException();
        }
        this.setState(6, 7);
        this.unprovision();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        db.fine("destroy");
        if (this.state != 5 && this.state != 7) {
            Iterator iterator;
            this.setState(666, 8);
            this.reversionChangeNotifier.deleteObservers();
            this.stateChangeNotifier.deleteObservers();
            Set set = this.blsrNodes;
            synchronized (set) {
                iterator = this.blsrNodes.iterator();
                while (iterator.hasNext()) {
                    UObservable.deleteObserver((Object)((BlsrNode)iterator.next()), (Object)this.nodeObserver, (String)className);
                }
            }
            set = this.blsrSpans;
            synchronized (set) {
                iterator = this.blsrSpans.iterator();
                while (iterator.hasNext()) {
                    UObservable.deleteObserver((Object)((BlsrSpan)iterator.next()).getDeathNotifier(), (Object)this.spanObserver, (String)className);
                }
            }
        }
        this.blsrNodes = new HashSet();
        this.blsrSpans = new HashSet();
        this.brmdb.destroy();
        this.brmdb = null;
        if (db.on()) {
            db.println(this + " destroyed...");
        }
    }

    public BlsrRingInfo getBlsrRingInfo() {
        return this.ringInfo;
    }

    public int getState() {
        return this.state;
    }

    public String getStateString() {
        String string = "";
        switch (this.state) {
            case 3: {
                string = COMPLETE_DISPLAY;
                break;
            }
            case 4: {
                string = EDITING_DISPLAY;
                break;
            }
            case 2: {
                string = INCOMPLETE_DISPLAY;
                break;
            }
            case 5: {
                string = CREATING_DISPLAY;
                break;
            }
            case 6: {
                string = DELETING_DISPLAY;
                break;
            }
            case 666: {
                string = DEAD_DISPLAY;
                break;
            }
            case 7: {
                string = UPSR2BLSR_CONVERSION_DISPLAY;
                break;
            }
            default: {
                string = UNKNOWN_DISPLAY;
            }
        }
        return string;
    }

    private void setState(int n, int n2) {
        db.finest("setState(" + n + ")");
        this.oldState[this.history] = this.state;
        this.oldStateReason[this.history] = this.stateReason;
        ++this.history;
        this.history %= this.oldState.length;
        this.state = n;
        this.stateReason = n2;
        this.stateChangeNotifier.notifyObservers(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLoopComplete() {
        boolean bl = false;
        Set set = this.blsrNodes;
        synchronized (set) {
            Iterator iterator = this.blsrNodes.iterator();
            if (iterator.hasNext()) {
                BlsrNode blsrNode = (BlsrNode)iterator.next();
                bl = this.isNodeReachable(blsrNode, blsrNode);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isProvisioned() {
        boolean bl = !this.blsrNodes.isEmpty();
        Set set = this.blsrNodes;
        synchronized (set) {
            Iterator iterator = this.blsrNodes.iterator();
            while (bl && iterator.hasNext()) {
                bl = ((BlsrNode)iterator.next()).isProvisioned();
            }
        }
        return bl;
    }

    public void provision() throws BlsrProvisionException {
        this.provision(this.blsrNodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void provision(Set set) throws BlsrProvisionException {
        Iterator iterator;
        IJobControl[] iJobControlArray = new IJobControl[set.size()];
        Set set2 = set;
        synchronized (set2) {
            iterator = set.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                iJobControlArray[n] = new BlsrProvisionAgent((BlsrNode)iterator.next());
                ++n;
            }
        }
        if (iJobControlArray.length > 0) {
            int n = 4;
            JobController jobController = JobControllerFactory.createJC((int)n);
            BlsrJobGroupListener blsrJobGroupListener = new BlsrJobGroupListener();
            JobGroup jobGroup = new JobGroup(iJobControlArray, (IJobGroupListener)blsrJobGroupListener, (Object)jobController);
            jobController.submitJob(jobGroup);
            blsrJobGroupListener.waitForCompletion();
            JobStatus[] jobStatusArray = jobGroup.getJobStatusList();
            boolean bl = false;
            HashSet<BlsrNode> hashSet = new HashSet<BlsrNode>();
            for (int i = 0; i < jobStatusArray.length; ++i) {
                if (!bl) {
                    boolean bl2 = bl = jobStatusArray[i].value() == 2;
                }
                if (jobStatusArray[i].value() != 4) continue;
                hashSet.add((BlsrNode)jobStatusArray[i].getResult());
            }
            if (bl) {
                BlsrRingManager blsrRingManager = BlsrRingManager.instance();
                iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    blsrRingManager.queueForRemoval((BlsrNode)iterator.next());
                }
                set.removeAll(hashSet);
                BlsrNode[] blsrNodeArray = BlsrRingModel.toBlsrNodeArray(set);
                if (db.on()) {
                    db.println("Provision failed on nodes: " + set);
                }
                throw new BlsrProvisionException(blsrNodeArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgradeTo4Fiber(IRevertiveBehavior iRevertiveBehavior, boolean bl, boolean bl2, boolean bl3) throws BlsrUpgradeException, LockOutSpanException, ExistingProtectionSwitchException, ExistingPCAException, IllegalStateException {
        if (this.ringInfo.isFourFiber()) {
            throw new IllegalStateException("Ring is already a 4-Fiber ring!  Can't upgrade.");
        }
        HashSet hashSet = new HashSet(this.blsrNodes);
        IJobControl[] iJobControlArray = new IJobControl[hashSet.size()];
        BlsrNode blsrNode = null;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        Set set = this.blsrNodes;
        synchronized (set) {
            int n;
            Iterator iterator;
            if (!(bl && bl2 && bl3)) {
                iterator = this.blsrNodes.iterator();
                n = 0;
                while (iterator.hasNext()) {
                    blsrNode = (BlsrNode)iterator.next();
                    if (!blsrNode.canPortsBeLockedout()) {
                        bl4 = true;
                        if (bl) {
                            blsrNode.clearWorkingPorts();
                        }
                    }
                    if (blsrNode.hasPCAConnections()) {
                        bl5 = true;
                    }
                    if (blsrNode.anyChannelStateOnStandby()) {
                        bl6 = true;
                    }
                    ++n;
                }
            }
            if (!bl && bl4) {
                throw new LockOutSpanException();
            }
            if (!bl2 && bl6) {
                throw new ExistingProtectionSwitchException();
            }
            if (!bl3 && bl5) {
                throw new ExistingPCAException();
            }
            iterator = this.blsrNodes.iterator();
            n = 0;
            while (iterator.hasNext()) {
                blsrNode = (BlsrNode)iterator.next();
                blsrNode.lockoutPorts();
                iJobControlArray[n] = new BlsrUpgradeAgent(blsrNode, iRevertiveBehavior);
                ++n;
            }
        }
        if (iJobControlArray.length > 0) {
            int n = 1;
            JobController jobController = JobControllerFactory.createJC((int)n);
            BlsrJobGroupListener blsrJobGroupListener = new BlsrJobGroupListener();
            JobGroup jobGroup = new JobGroup(iJobControlArray, (IJobGroupListener)blsrJobGroupListener, (Object)jobController);
            jobController.submitJob(jobGroup);
            blsrJobGroupListener.waitForCompletion();
            HashSet<Object> hashSet2 = new HashSet<Object>();
            JobStatus[] jobStatusArray = jobGroup.getJobStatusList();
            for (int i = 0; i < jobStatusArray.length; ++i) {
                int n2 = jobStatusArray[i].value();
                if (n2 != 2) continue;
                hashSet2.add(jobStatusArray[i].getResult());
            }
            if (!hashSet2.isEmpty()) {
                HashSet<BlsrNode> hashSet3 = new HashSet<BlsrNode>();
                Set set2 = this.blsrNodes;
                synchronized (set2) {
                    Iterator iterator = this.blsrNodes.iterator();
                    while (iterator.hasNext()) {
                        blsrNode = (BlsrNode)iterator.next();
                        if (hashSet2.contains(blsrNode)) continue;
                        hashSet3.add(blsrNode);
                    }
                }
                throw new BlsrUpgradeException(BlsrRingModel.toBlsrNodeArray(hashSet2), BlsrRingModel.toBlsrNodeArray(hashSet3), this.blsrTerm);
            }
        }
    }

    public void switchTrafficToShortestPath() throws SanityCheckFailed, InServiceUpgradeError {
        BlsrSpan[] blsrSpanArray = this.getWorkingBlsrSpans();
        ArrayList<INetLink> arrayList = new ArrayList<INetLink>();
        for (int i = 0; i < blsrSpanArray.length; ++i) {
            arrayList.add(blsrSpanArray[i].getOriginalLink());
        }
        this.upsr2BlsrUpgradeMgr.setUpsrRingLinks(arrayList);
        this.upsr2BlsrUpgradeMgr.upsr2BlsrConversionCheck();
        this.upsr2BlsrUpgradeMgr.switchTraffic2ShortestPaths();
    }

    public void upgradeUpsr2Blsr() throws SanityCheckFailed, InServiceUpgradeError {
        this.upsr2BlsrUpgradeMgr.convert();
    }

    public void clearUpsr2BlsrUpgrade() throws InServiceUpgradeError {
        this.upsr2BlsrUpgradeMgr.cancel();
    }

    boolean isNodeUpgradableTo4Fiber(BlsrNode blsrNode) {
        boolean bl = false;
        NodeModel nodeModel = null;
        if (this.state != 6 && !blsrNode.isDestroyed() && (nodeModel = blsrNode.getNodeModel()) != null) {
            bl = blsrNode.isProvisioned() && !blsrNode.isFourFiber() && this.getAvailableProtectPorts(nodeModel).size() >= 2;
            IBlsrModel[] iBlsrModelArray = BlsrRingModel.getBlsrModels(nodeModel);
            int n = 0;
            for (int i = 0; bl && i < iBlsrModelArray.length; ++i) {
                if (!new BlsrRingInfo(iBlsrModelArray[i]).isFourFiber()) continue;
                ++n;
            }
            bl &= n <= nodeModel.getIElementModels().getBlsrLimits().getMax4FBlsr();
        }
        if (db.on()) {
            db.println("[isNodeUpgradableTo4Fiber] " + blsrNode + " is upgradable? " + bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPCAConnections() throws IllegalStateException {
        boolean bl = false;
        Set set = this.blsrNodes;
        synchronized (set) {
            Iterator iterator = this.blsrNodes.iterator();
            BlsrNode blsrNode = null;
            while (iterator.hasNext()) {
                blsrNode = (BlsrNode)iterator.next();
                if (!blsrNode.hasPCAConnections()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDriConnections() throws IllegalStateException {
        boolean bl = false;
        Set set = this.blsrNodes;
        synchronized (set) {
            Iterator iterator = this.blsrNodes.iterator();
            BlsrNode blsrNode = null;
            while (iterator.hasNext()) {
                blsrNode = (BlsrNode)iterator.next();
                if (!blsrNode.hasDriConnections()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public boolean isRingInUpgradeableState() throws IllegalStateException {
        if (this.state == 5 || this.state == 7) {
            throw new IllegalStateException("Can only upgrade provisioned rings");
        }
        return this.state != 6;
    }

    public boolean isRingSpeedAdequateForUpgrade() {
        return this.ringInfo.getRingSpeed() >= 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlsrNode[] getNonUpgradableNodes() {
        ArrayList<BlsrNode> arrayList = new ArrayList<BlsrNode>();
        BlsrNode blsrNode = null;
        Set set = this.blsrNodes;
        synchronized (set) {
            Iterator iterator = this.blsrNodes.iterator();
            while (iterator.hasNext()) {
                blsrNode = (BlsrNode)iterator.next();
                if (this.isNodeUpgradableTo4Fiber(blsrNode)) continue;
                arrayList.add(blsrNode);
            }
        }
        return BlsrRingModel.toBlsrNodeArray(arrayList);
    }

    public boolean isUpgradableTo4Fiber() throws IllegalStateException {
        return this.isRingInUpgradeableState() && this.isRingSpeedAdequateForUpgrade() && this.getNonUpgradableNodes().length <= 0 && !this.ringInfo.isFourFiber();
    }

    public void unprovision() throws BlsrUnprovisionException {
        this.unprovision(this.blsrNodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unprovision(Set set) throws BlsrUnprovisionException {
        JobController jobController;
        IJobControl[] iJobControlArray = new IJobControl[set.size()];
        Set set2 = set;
        synchronized (set2) {
            jobController = set.iterator();
            int n = 0;
            while (jobController.hasNext()) {
                iJobControlArray[n] = new BlsrUnprovisionAgent((BlsrNode)jobController.next());
                ++n;
            }
        }
        if (iJobControlArray.length > 0) {
            int n = 4;
            jobController = JobControllerFactory.createJC((int)n);
            BlsrJobGroupListener blsrJobGroupListener = new BlsrJobGroupListener();
            JobGroup jobGroup = new JobGroup(iJobControlArray, (IJobGroupListener)blsrJobGroupListener, (Object)jobController);
            jobController.submitJob(jobGroup);
            blsrJobGroupListener.waitForCompletion();
            JobStatus[] jobStatusArray = jobGroup.getJobStatusList();
            boolean bl = false;
            HashSet<BlsrNode> hashSet = new HashSet<BlsrNode>();
            for (int i = 0; i < jobStatusArray.length; ++i) {
                if (!bl) {
                    boolean bl2 = bl = jobStatusArray[i].value() == 2;
                }
                if (jobStatusArray[i].value() != 2) continue;
                hashSet.add((BlsrNode)jobStatusArray[i].getResult());
            }
            if (bl) {
                this.setState(this.isLoopComplete() ? 3 : 2, 9);
                throw new BlsrUnprovisionException(BlsrRingModel.toBlsrNodeArray(hashSet));
            }
        }
    }

    public synchronized boolean isRingProtectionClear() {
        BlsrNode[] blsrNodeArray = this.getBlsrNodes();
        boolean bl = true;
        if (this.isProvisioned()) {
            for (int i = 0; bl && i < blsrNodeArray.length; ++i) {
                bl = blsrNodeArray[i].getEastProtectChannelState() != 0 && blsrNodeArray[i].getWestProtectChannelState() != 0;
            }
        }
        return bl;
    }

    public Observable getStateChangeNotifier() {
        return this.stateChangeNotifier;
    }

    public Observable getReversionChangeNotifier() {
        return this.reversionChangeNotifier;
    }

    public Observable getNodeAddedNotifier() {
        return this.nodeAddedNotifier;
    }

    public Observable getNodeRemovedNotifier() {
        return this.nodeRemovedNotifier;
    }

    public Observable getSpanAddedNotifier() {
        return this.spanAddedNotifier;
    }

    public Observable getSpanRemovedNotifier() {
        return this.spanRemovedNotifier;
    }

    public Observable getProtectionSwitchClearNotifier() {
        return this.switchClearNotifier;
    }

    public void update(Observable observable, Object object) {
    }

    public INodeModel getNodeModel() {
        INodeModel iNodeModel = null;
        Iterator iterator = this.blsrNodes.iterator();
        if (iterator.hasNext()) {
            iNodeModel = ((BlsrNode)iterator.next()).getBlsrModel().getNodeModel();
        }
        return iNodeModel;
    }

    public BlsrNode unprovisionedBlsrNodeLookUp(INodeModel iNodeModel) {
        if (this.isProvisioned()) {
            throw new IllegalStateException("This method is only callable on unprovisioned BlsrRingModels.");
        }
        BlsrRingInfo blsrRingInfo = this.getBlsrRingInfo();
        UnprovisionedBlsrNodeKey unprovisionedBlsrNodeKey = new UnprovisionedBlsrNodeKey((NodeModel)iNodeModel, blsrRingInfo);
        if (this.unprovisionedBlsrNodes.containsKey(unprovisionedBlsrNodeKey)) {
            if (db.on()) {
                db.println("Found an unprovisioned BlsrNode tied to the key: " + unprovisionedBlsrNodeKey);
            }
            return (BlsrNode)this.unprovisionedBlsrNodes.get(unprovisionedBlsrNodeKey);
        }
        if (db.on()) {
            db.println("Could not find a Blsr Node for the key: " + unprovisionedBlsrNodeKey);
        }
        BlsrNode blsrNode = new BlsrNode((NodeModel)iNodeModel, blsrRingInfo);
        this.unprovisionedBlsrNodes.put(unprovisionedBlsrNodeKey, blsrNode);
        if (db.on()) {
            db.println("Added a new BlsrNode to the map.");
        }
        return blsrNode;
    }

    public static class BRMDebug
    extends SDebug {
        private BlsrRingModel brm;
        public static final String HospfCheck = "Determines if all of the OSPF Area IDs are identical in the BLSR ring.";

        public BRMDebug(String string, BlsrRingModel blsrRingModel) {
            super(string);
            this.brm = blsrRingModel;
        }

        public final void ospfCheck() {
            if (this.brm != null) {
                BRMDebug bRMDebug = this;
                db.set(true);
                this.brm.areAllSpansInSameOSPFArea();
                BRMDebug bRMDebug2 = this;
                db.set(false);
                if (this.brm.ospfArea != OSPF_AREA_INCONSISTENT) {
                    this.println("All BLSR spans in " + this.brm.ringInfo.getRingName() + " are in the same OSPF Area.");
                }
            } else {
                this.println("BlsrRingModel is destroyed.");
            }
        }

        void destroy() {
            this.brm = null;
            root.removeChild((KDebug)this);
        }
    }

    public static final class BedEliminationReason {
        String reason;
        public static final BedEliminationReason DOES_NOT_PROVIDE = new BedEliminationReason("DOES_NOT_PROVIDE\n");
        public static final BedEliminationReason PATH_SELECTOR = new BedEliminationReason("PATH_SELECTOR\n");
        public static final BedEliminationReason BLSR_LIMIT_REACHED = new BedEliminationReason("BLSR_LIMIT_REACHED\n");
        public static final BedEliminationReason BLSR_WITH_SAME_RING_ID = new BedEliminationReason("BLSR_WITH_SAME_RING_ID\n");
        public static final BedEliminationReason FOUR_FIBER_LIMIT_REACHED = new BedEliminationReason("FOUR_FIBER_LIMIT_REACHED\n");
        public static final BedEliminationReason NEEDED_SPAN_IN_BLSR = new BedEliminationReason("NEEDED_SPAN_IN_BLSR\n");
        public static final BedEliminationReason NOT_IN_LOOP = new BedEliminationReason("NOT_IN_LOOP\n");
        public static final BedEliminationReason NOT_ENOUGH_PROTECT_PORTS = new BedEliminationReason("NOT_ENOUGH_PROTECT_PORTS\n");
        public static final BedEliminationReason HIGH_LOW_HO_CIRCUIT = new BedEliminationReason("HIGH_LOW_HO_CIRCUIT\n");
        public static final BedEliminationReason ORDER_WIRE_ON_PROTECT_PORT = new BedEliminationReason("ORDER_WIRE_ON_PROTECT_PORT\n");
        public static final BedEliminationReason OPTICAL_PROTECTION_GROUP = new BedEliminationReason("OPTICAL_PROTECTION_GROUP\n");
        public static final BedEliminationReason NOT_ENOUGH_SPANS_OF_RIGHT_SPEED = new BedEliminationReason("NOT_ENOUGH_SPANS_OF_RIGHT_SPEED\n");
        public static final BedEliminationReason FOUR_FIBER_INCAPABLE_NODE = new BedEliminationReason("FOUR_FIBER_INCAPABLE_NODE\n");
        public static final BedEliminationReason INSUFFICIENT_SECURITY_PERMISSION = new BedEliminationReason("INSUFFICIENT_SECURITY_PERMISSION\n");
        public static final BedEliminationReason NODE_NOT_INITED = new BedEliminationReason("NODE_NOT_INITED\n");
        public static final BedEliminationReason ALL_LINKS_ON_SAME_CARD = new BedEliminationReason("ALL_LINKS_ON_SAME_CARD\n");
        public static final BedEliminationReason INCONSISTENT_MEDIUM_TYPE = new BedEliminationReason("INCONISTENT_MEDIUM_TYPE\n");
        public static final BedEliminationReason INCOMPATIBLE_FEATURE_VERSION = new BedEliminationReason("INCOMPATIBLE_FEATURE_VERSION\n");
        public static final BedEliminationReason INVALID_OSPF_AREA = new BedEliminationReason("INVALID_OSPF_AREA\n");
        public static final BedEliminationReason WIGGLING_CIRCUITS = new BedEliminationReason("WIGGLING_CIRCUITS\n");
        public static final BedEliminationReason NO_BLSR_SUPPORT = new BedEliminationReason("NO_BLSR_SUPPORT\n");
        public static final BedEliminationReason NOT_ENOUGH_SPANS_WITHOUT_LDCC = new BedEliminationReason("NOT_ENOUGH_SPANS_WITHOUT_LDCC\n");

        private BedEliminationReason(String string) {
            this.reason = string;
        }

        public String toString() {
            return this.reason;
        }
    }

    private static class UnprovisionedBlsrNodeKey {
        public BlsrRingInfo ringInfo;
        public INodeModel nodeModel;

        UnprovisionedBlsrNodeKey(INodeModel iNodeModel, BlsrRingInfo blsrRingInfo) {
            this.nodeModel = iNodeModel;
            this.ringInfo = blsrRingInfo;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object object) {
            if (!(object instanceof UnprovisionedBlsrNodeKey)) {
                return false;
            }
            UnprovisionedBlsrNodeKey unprovisionedBlsrNodeKey = (UnprovisionedBlsrNodeKey)object;
            return BlsrNode.compareNodeModels(this.nodeModel, unprovisionedBlsrNodeKey.nodeModel) && this.ringInfo.equals(unprovisionedBlsrNodeKey.ringInfo);
        }

        public String toString() {
            return "The NodeModel is " + this.nodeModel + ", and the Ring Info is " + this.ringInfo;
        }
    }

    class BlsrJobGroupListener
    implements IJobGroupListener {
        public boolean jobDone = false;
        public Object lock = new Object();

        BlsrJobGroupListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void jobGroupFinished(JobGroup jobGroup) {
            Object object = this.lock;
            synchronized (object) {
                this.jobDone = true;
                this.lock.notifyAll();
                JobController jobController = (JobController)jobGroup.getUserObject();
                if (jobController.isIdle()) {
                    JobControllerFactory.disposeJC((JobController)jobController);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForCompletion() {
            while (!this.jobDone) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    class BlsrRingSpanRemovedNotifier
    extends UObservable {
        BlsrRingSpanRemovedNotifier() {
        }

        public void notifyObservers(Object object) {
            this.setChanged();
            super.notifyObservers(object);
        }

        public void notifyObservers() {
        }
    }

    class BlsrRingSpanAddedNotifier
    extends UObservable {
        BlsrRingSpanAddedNotifier() {
        }

        public void notifyObservers(Object object) {
            this.setChanged();
            super.notifyObservers(object);
        }

        public void notifyObservers() {
        }
    }

    class BlsrRingNodeRemovedNotifier
    extends UObservable {
        BlsrRingNodeRemovedNotifier() {
        }

        public void notifyObservers(Object object) {
            this.setChanged();
            super.notifyObservers(object);
        }

        public void notifyObservers() {
        }
    }

    class BlsrRingNodeAddedNotifier
    extends UObservable {
        BlsrRingNodeAddedNotifier() {
        }

        public void notifyObservers(Object object) {
            this.setChanged();
            super.notifyObservers(object);
        }

        public void notifyObservers() {
        }
    }

    class BlsrRingReversionChangeNotifier
    extends UObservable {
        BlsrRingReversionChangeNotifier() {
        }

        public void notifyObservers(Object object) {
            this.setChanged();
            super.notifyObservers(object);
        }

        public void notifyObservers() {
        }
    }

    public class BlsrRingStateChangeNotifier
    extends UObservable {
        public void notifyObservers(Object object) {
            this.setChanged();
            super.notifyObservers(object);
        }

        public void notifyObservers() {
        }
    }

    class BlsrSpanDeathObserver
    implements Observer,
    IObserver {
        BlsrSpanDeathObserver() {
        }

        public void update(Observable observable, Object object) {
            this._update(observable, object);
        }

        public void update(IObservable iObservable, Object object) {
            this._update(iObservable, object);
        }

        private synchronized void _update(Object object, Object object2) {
            BlsrSpan blsrSpan = (BlsrSpan)object2;
            BlsrRingModel.this.removeDiscoveredBlsrSpan(blsrSpan);
            if (db.on()) {
                db.println("[deathObserver.update] Removed span: " + blsrSpan);
            }
        }
    }

    class ProtectionSwitchClearObserver
    implements Observer,
    IObserver {
        ProtectionSwitchClearObserver() {
        }

        public void update(Observable observable, Object object) {
            this._update(observable, object);
        }

        public void update(IObservable iObservable, Object object) {
            this._update(iObservable, object);
        }

        private synchronized void _update(Object object, Object object2) {
            short s = (Short)object2;
            if ((s == 10 || s == 12) && BlsrRingModel.this.isRingProtectionClear()) {
                BlsrRingModel.this.switchClearNotifier.notifyObservers(BlsrRingModel.this);
            }
        }
    }

    class ProtectionSwitchClearNotifier
    extends UObservable {
        ProtectionSwitchClearNotifier() {
        }

        public void notifyObservers(Object object) {
            this.setChanged();
            super.notifyObservers(object);
        }

        public void notifyObservers() {
        }
    }

    class BlsrNodeChangeObserver
    implements Observer,
    IObserver {
        BlsrNodeChangeObserver() {
        }

        public void update(Observable observable, Object object) {
            this._update(observable, object);
        }

        public void update(IObservable iObservable, Object object) {
            this._update(iObservable, object);
        }

        private synchronized void _update(Object object, Object object2) {
            db.fine("_update(" + object + ", " + object2 + ")");
            BlsrRingManager blsrRingManager = BlsrRingManager.instance();
            BlsrNode blsrNode = (BlsrNode)object;
            short s = (Short)object2;
            switch (s) {
                case 2: {
                    db.fine("NODE_ID_CHANGED");
                    if (BlsrRingModel.this.state == 2) {
                        if (BlsrRingModel.this.hasDuplicateNodeId() || !BlsrRingModel.this.isLoopComplete()) break;
                        BlsrRingModel.this.setState(3, 10);
                        break;
                    }
                    if (BlsrRingModel.this.state != 3 || !BlsrRingModel.this.hasDuplicateNodeId()) break;
                    BlsrRingModel.this.setState(2, 10);
                    break;
                }
                case 3: {
                    db.fine("RING_ID_CHANGED");
                    IBlsrModel iBlsrModel = blsrNode.getBlsrModel();
                    NodeModel nodeModel = blsrNode.getNodeModel();
                    BlsrRingModel.this.removeBlsrNode(blsrNode);
                    blsrRingManager.stitchBlsrModel(iBlsrModel, nodeModel);
                    break;
                }
                case 4: {
                    db.fine("RING_REVERSION_CHANGED");
                    BlsrRingModel.this.syncRingReversion();
                    break;
                }
                case 5: {
                    db.fine("SPAN_REVERSION_CHANGED");
                    BlsrRingModel.this.syncSpanReversion();
                    break;
                }
                case 13: {
                    db.fine("BLSR_SPEED_CHANGED");
                    IBlsrModel iBlsrModel = blsrNode.getBlsrModel();
                    NodeModel nodeModel = blsrNode.getNodeModel();
                    BlsrRingModel.this.removeBlsrNode(blsrNode);
                    blsrRingManager.stitchBlsrModel(iBlsrModel, nodeModel);
                    break;
                }
                case 6: {
                    db.fine("UPGRADE_2_TO_4");
                    IBlsrModel iBlsrModel = blsrNode.getBlsrModel();
                    NodeModel nodeModel = blsrNode.getNodeModel();
                    BlsrRingModel.this.removeBlsrNode(blsrNode);
                    BlsrRingModel.this.setState(2, 10);
                    blsrRingManager.stitchBlsrModel(iBlsrModel, nodeModel);
                    break;
                }
                case 7: {
                    db.fine("WEST_PROTECTION_OP_CHANGED");
                    break;
                }
                case 8: {
                    db.fine("EAST_PROTECTION_OP_CHANGED");
                    break;
                }
                case 666: {
                    db.fine(BlsrRingModel.DEAD_DISPLAY);
                    BlsrRingModel.this.removeBlsrNode(blsrNode);
                    break;
                }
                default: {
                    db.fine("No action for message " + s + " from " + blsrNode + "- probably a channel state (9-12) or " + "extended ring (0) change.");
                }
            }
        }
    }
}

