/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.circuits;

import cerent.cms.model.FramingType;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.IFramingType;
import cerent.cms.model.circuits.SpanRow;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitSpan;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.topo.AbstractNetLink;
import cerent.cms.topo.CompositeNetLink;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.cms.ui.circuits.SpanCircuitsPane;
import cerent.util.HoLoComparator;
import cerent.util.HoLoFactory;
import cerent.util.IHoLoNum;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractRowDataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeSet;

public class SpanDataSource
extends AbstractRowDataSource
implements Observer {
    private final NetCircuitManager ncm = NetCircuitManager.instance();
    private static final HoLoComparator holoComp = HoLoComparator.instance();
    private final Network net = Network.instance();
    private INetLink forwardLink;
    private INetLink reverseLink;
    private List allCircuits = new ArrayList();
    private List circuits = new ArrayList();
    private List spanRows = Collections.synchronizedList(new ArrayList());
    boolean atLeastOneUpsrInPreviousSpanRows = false;
    private SpanCircuitsPane scp;
    private static SDebug db = new SDebug("SpanDataSource");
    private SdsDebug dumpDebug = new SdsDebug("SpanDataSourceDump");

    public SpanDataSource(SpanCircuitsPane spanCircuitsPane) {
        this.ncm.addObserver(this);
        this.scp = spanCircuitsPane;
    }

    public void setNetLink(INetLink iNetLink) {
        this.forwardLink = iNetLink;
        this.reverseLink = this.net.findReverseLink(iNetLink);
        this.update((Observable)((Object)this.ncm), null);
    }

    public Set TestUnusedSpanRows(Set set) {
        INetLink iNetLink = null;
        return SpanDataSource.createUnusedSpanRows(set, iNetLink);
    }

    public void dispose() {
        this.dumpDebug.dispose();
        this.spanRows.clear();
        this.deleteCircuitObservers();
        this.circuits = new ArrayList();
        this.ncm.deleteObserver(this);
    }

    public synchronized void update(Observable observable, Object object) {
        if (observable == this.ncm) {
            this.refreshCircuits();
            this.registerWithAllCircuits();
        } else if (observable instanceof INetCircuit) {
            this.refreshCircuits();
        }
    }

    private void registerWithAllCircuits() {
        this.deleteCircuitObservers();
        this.allCircuits = this.ncm.getCircuits();
        Iterator iterator = this.allCircuits.iterator();
        while (iterator.hasNext()) {
            INetCircuit iNetCircuit = (INetCircuit)iterator.next();
            iNetCircuit.addObserver(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshCircuits() {
        TreeSet treeSet = new TreeSet();
        if (SpanDataSource.db.on) {
            db.println("refreshCircuits: processing forward link");
        }
        this.getLinkCircuits(treeSet, this.forwardLink, null);
        if (SpanDataSource.db.on) {
            db.println("refreshCircuits: processing reverse link");
        }
        this.getLinkCircuits(treeSet, this.reverseLink, null);
        Set set = SpanDataSource.createUnusedSpanRows(treeSet, this.forwardLink);
        if (!set.isEmpty()) {
            treeSet.addAll(set);
        }
        boolean bl = false;
        ArrayList arrayList = new ArrayList(treeSet);
        if (((Object)this.spanRows).equals(arrayList)) {
            if (SpanDataSource.db.on) {
                db.println("no change in spanRows, returning");
            }
            List list = this.spanRows;
            synchronized (list) {
                Iterator iterator = this.spanRows.iterator();
                while (iterator.hasNext()) {
                    SpanRow spanRow = (SpanRow)iterator.next();
                    INetCircuitSpan iNetCircuitSpan = spanRow.getSpan();
                    if (iNetCircuitSpan == null || !iNetCircuitSpan.isUpsr()) continue;
                    bl = true;
                    break;
                }
            }
        }
        this.spanRows.clear();
        this.spanRows.addAll(arrayList);
        this.circuits = new ArrayList(this.spanRows.size());
        List list = this.spanRows;
        synchronized (list) {
            Iterator iterator = this.spanRows.iterator();
            while (iterator.hasNext()) {
                SpanRow spanRow = (SpanRow)iterator.next();
                INetCircuitSpan iNetCircuitSpan = spanRow.getSpan();
                if (iNetCircuitSpan != null && iNetCircuitSpan.isUpsr()) {
                    bl = true;
                }
                this.circuits.add(spanRow.circuit);
            }
        }
        this.fireDataChanged(bl);
    }

    private void fireDataChanged(boolean bl) {
        if (this.atLeastOneUpsrInPreviousSpanRows != bl) {
            if (db.on()) {
                db.println("spanRows changed, plus the selector flag will no longer be " + this.atLeastOneUpsrInPreviousSpanRows);
            }
            this.atLeastOneUpsrInPreviousSpanRows = bl;
            this.scp.showUpsrObjects(bl);
            this.fireDataStructureChanged();
        } else {
            if (db.on()) {
                db.println("spanRows changed, but the selector flag will remain " + this.atLeastOneUpsrInPreviousSpanRows);
            }
            this.fireDataSourceChanged();
        }
    }

    public boolean hasAtLeastOneSelector() {
        return this.atLeastOneUpsrInPreviousSpanRows;
    }

    private static void addFoundRows(Set set, Set set2) {
        if (!set2.isEmpty()) {
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                SpanRow spanRow = (SpanRow)iterator.next();
                set.add(spanRow);
            }
        }
    }

    static Set createUnusedSpanRows(Set set, INetLink iNetLink) {
        return SpanDataSource.createUnusedSpanRows(set, null, iNetLink);
    }

    static Set createUnusedSpanRows(Set set, IHoNum iHoNum) {
        return SpanDataSource.createUnusedSpanRows(set, iHoNum, null);
    }

    static Set createUnusedSpanRows(Set set, IHoNum iHoNum, INetLink iNetLink) {
        AbstractNetLink abstractNetLink;
        TreeSet treeSet = new TreeSet();
        IHoNum iHoNum2 = null;
        IHoNum iHoNum3 = iHoNum;
        if (iNetLink != null) {
            abstractNetLink = (AbstractNetLink)iNetLink;
            int n = abstractNetLink.getSrc().getNodeModel().getFramingType();
            if (holoComp.compare(HoLoFactory.createFirstHoNum(n), abstractNetLink.getFirstValidSrcHo()) < 0) {
                iHoNum2 = HoLoFactory.addOffset(abstractNetLink.getFirstValidSrcHo(), -1);
            }
            iHoNum3 = HoLoFactory.addOffset(abstractNetLink.getLastValidSrcHo(), 1);
        }
        abstractNetLink = HoLoFactory.createHoLoNum(iHoNum2, null);
        Set set2 = new HashSet();
        if (db.on()) {
            db.fine("total circuit rows=" + set.size());
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            SpanRow spanRow = (SpanRow)iterator.next();
            if (db.on()) {
                db.fine("usedSpanRow=" + spanRow.prettyString() + " " + "prevlastHoLo=" + abstractNetLink.prettyString("-"));
            }
            set2 = spanRow.findUnusedSpanRow((IHoLoNum)abstractNetLink);
            if (db.on()) {
                db.fine("found " + set2.size() + " unused rows");
                Iterator iterator2 = set2.iterator();
                while (iterator2.hasNext()) {
                    db.fine("unusedSpanRow=" + ((SpanRow)iterator2.next()).prettyString());
                }
            }
            treeSet.addAll(set2);
            abstractNetLink = HoLoFactory.createHoLoNum(spanRow.getLast());
        }
        if (iHoNum3 != null && abstractNetLink.getHoNum() != null) {
            set2 = SpanRow.findUnusedSpanRow(iHoNum3, null, (IHoLoNum)abstractNetLink);
            if (db.on()) {
                db.fine("found " + set2.size() + " unused rows");
                iterator = set2.iterator();
                while (iterator.hasNext()) {
                    db.fine("unusedSpanRow=" + ((SpanRow)iterator.next()).prettyString());
                }
            }
            treeSet.addAll(set2);
        }
        return treeSet;
    }

    private void deleteCircuitObservers() {
        Iterator iterator = this.allCircuits.iterator();
        while (iterator.hasNext()) {
            INetCircuit iNetCircuit = (INetCircuit)iterator.next();
            iNetCircuit.deleteObserver(this);
        }
    }

    private void getLinkCircuits(Set set, INetLink iNetLink, IHoNum iHoNum) {
        Object object;
        Object object2;
        ILoNum iLoNum;
        ILoNum iLoNum2;
        IHoNum iHoNum2;
        IHoNum iHoNum3;
        INetCircuit iNetCircuit;
        Object object3;
        List list;
        List list2;
        if (iNetLink == null) {
            return;
        }
        CompositeNetLink compositeNetLink = CompositeNetLink.getCompositeLink(iNetLink);
        if (compositeNetLink != null) {
            list2 = this.ncm.getCircuitSpans(compositeNetLink);
            list = this.ncm.getEndpointsUseLink(compositeNetLink);
        } else {
            list2 = this.ncm.getCircuitSpans(iNetLink);
            list = this.ncm.getEndpointsUseLink(iNetLink);
        }
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            object3 = (INetCircuitSpan)iterator.next();
            iNetCircuit = object3.getCircuit();
            if (iNetCircuit.getCircuitTypeObj().isLoCircuitType()) {
                iHoNum2 = iHoNum != null ? (iHoNum3 = iHoNum) : (iHoNum3 = object3.getSrcHoNum());
                iLoNum = iLoNum2 = object3.getLoNum();
            } else {
                iHoNum2 = object3.getSrcHoNum();
                object2 = FramingType.getFramingType((int)iHoNum2.getFramingType());
                iHoNum3 = SpanDataSource.determineLastHo(iHoNum2, iNetCircuit.getCircuitSizeObj(), object2);
                iLoNum2 = null;
                iLoNum = null;
            }
            if (SpanDataSource.db.on) {
                db.println("adding new SpanRow(" + iHoNum2 + ", " + iHoNum3 + ", " + iNetCircuit.getCircuitName() + ")");
            }
            if (!set.add(object2 = new SpanRow(iHoNum2, iLoNum, iHoNum3, iLoNum2, iNetCircuit, (INetCircuitSpan)object3)) && SpanDataSource.db.on) {
                db.println("last add was a duplicate");
            }
            if (iNetCircuit.getCircuitTypeObj().isTunnelCircuitType()) {
                this.getLinkCircuits(set, iNetCircuit.getLotLink(), iHoNum2);
                this.getLinkCircuits(set, iNetCircuit.getReverseLotLink(), iHoNum2);
            }
            if (!iNetCircuit.getCircuitTypeObj().isLAPCircuitType()) continue;
            object = this.ncm.getCircuitsUseLAP(iNetCircuit).iterator();
            while (object.hasNext()) {
                INetCircuitSpan iNetCircuitSpan;
                INetCircuit iNetCircuit2 = (INetCircuit)object.next();
                iHoNum2 = iHoNum != null ? (iHoNum3 = iHoNum) : (iHoNum3 = object3.getSrcHoNum());
                iLoNum = iLoNum2 = iNetCircuit2.getLoOverHo();
                if (SpanDataSource.db.on) {
                    db.println("adding new SpanRow(" + iHoNum2 + ", " + iHoNum3 + ", " + iNetCircuit2.getCircuitName() + ")");
                }
                if ((iNetCircuitSpan = iNetCircuit2.getCircuitSpanFromNetLink(iNetCircuit.getLapLink())) == null) {
                    iNetCircuitSpan = iNetCircuit2.getCircuitSpanFromNetLink(iNetCircuit.getReverseLapLink());
                }
                if (set.add(new SpanRow(iHoNum2, iLoNum, iHoNum3, iLoNum2, iNetCircuit2, iNetCircuitSpan)) || !SpanDataSource.db.on) continue;
                db.println("last add was a duplicate");
            }
        }
        iterator = list.iterator();
        while (iterator.hasNext()) {
            object3 = (INetCircuitEnd)iterator.next();
            iNetCircuit = this.ncm.getCircuitFromCircuitEnd((INetCircuitEnd)object3);
            if (iNetCircuit == null) {
                if (db.on()) {
                    db.println("No circuit found with cktEnd = " + ((NetCircuitEnd)object3).prettyString());
                }
                return;
            }
            if (iNetCircuit.getCircuitTypeObj().isLoCircuitType()) {
                iHoNum2 = iHoNum != null ? (iHoNum3 = iHoNum) : (iHoNum3 = object3.getHoNum());
                iLoNum = iLoNum2 = object3.getLoNum();
            } else {
                iHoNum2 = object3.getHoNum();
                object2 = FramingType.getFramingType((int)iHoNum2.getFramingType());
                object = iNetCircuit.getCircuitSizeObj();
                iHoNum3 = SpanDataSource.determineLastHo(iHoNum2, (ICircuitSize)object, object2);
                iLoNum2 = null;
                iLoNum = null;
            }
            if (SpanDataSource.db.on) {
                db.println("adding new SpanRow(" + iHoNum2 + ", " + iHoNum3 + ", " + iNetCircuit.getCircuitName() + ")");
            }
            if (set.add(new SpanRow(iHoNum2, iLoNum, iHoNum3, iLoNum2, iNetCircuit, null)) || !SpanDataSource.db.on) continue;
            db.println("last add was a duplicate");
        }
    }

    private static IHoNum determineLastHo(IHoNum iHoNum, ICircuitSize iCircuitSize, IFramingType iFramingType) {
        int n = iFramingType.getFramingTypeHoPathWidth(iCircuitSize.getHoPathWidth());
        IHoNum iHoNum2 = HoLoFactory.addOffset(iHoNum, n - 1);
        return iHoNum2;
    }

    private static void addEmptySpanRow(Set set, IHoLoNum iHoLoNum, IHoLoNum iHoLoNum2) {
        if (SpanDataSource.db.on) {
            db.println("adding empty SpanRow(" + iHoLoNum + ", " + iHoLoNum2 + ", null, null)");
        }
        set.add(new SpanRow(iHoLoNum, iHoLoNum2, null, null));
    }

    private static int getUsableStsCount(INetLink iNetLink) {
        int n = 1;
        if (iNetLink.getLinkType() == 1 || iNetLink.getLinkType() == 4) {
            switch (iNetLink.getPhysicalType()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    n = iNetLink.getPhysicalTypeObj().getStsCapacity();
                }
            }
            if (iNetLink.getProtectionType() == 0) {
                n /= 2;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getAllObjects() {
        HashSet hashSet;
        List list = this.spanRows;
        synchronized (list) {
            hashSet = new HashSet(this.spanRows);
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObjectAtRow(int n) {
        List list = this.spanRows;
        synchronized (list) {
            if (n >= 0 && n < this.spanRows.size()) {
                return this.spanRows.get(n);
            }
            return null;
        }
    }

    public int getRowCount() {
        return this.spanRows.size();
    }

    public Class getRowObjectClass() {
        return SpanRow.class;
    }

    public class SdsDebug
    extends SDebug {
        SdsDebug(String string) {
            super(string);
        }

        public final void dump() {
            Iterator iterator = SpanDataSource.this.circuits.iterator();
            while (iterator.hasNext()) {
                INetCircuit iNetCircuit = (INetCircuit)iterator.next();
                if (iNetCircuit == null) continue;
                iNetCircuit.prettyPrint(db);
            }
        }
    }
}

