/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.event;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.event.AbstractAlarmStore;
import cerent.cms.model.event.AlarmStatus;
import cerent.cms.model.event.EventInfo;
import cerent.cms.model.event.IAlarmStore;
import cerent.cms.model.event.SimpleAlarmCorrelator;
import cerent.cms.model.event.StoreObservable;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.util.SDebug;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Observable;
import java.util.Set;

public class NetworkAlarmStore
extends AbstractAlarmStore {
    private static NetworkAlarmStore netAlarmStore;
    protected HashMap netChildren;
    protected HashMap storeObsToKey;
    protected HashMap allNodeKeys;

    public static synchronized NetworkAlarmStore instance() {
        if (netAlarmStore == null) {
            netAlarmStore = new NetworkAlarmStore("NetworkAlarmStore");
        }
        return netAlarmStore;
    }

    public void update(Observable observable, Object object) {
        if (object instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)object;
            if (arrayList.size() != 0) {
                EventInfo eventInfo = (EventInfo)arrayList.get(0);
                NodeKey nodeKey = this.addNodeKey(eventInfo.getNodeHostName(), eventInfo.getNodeId());
                this.mapStoreObservable(observable, nodeKey);
                if (this.netChildren.containsKey(nodeKey)) {
                    this.processAlarms(arrayList);
                }
            }
        } else if (object instanceof Set) {
            if (this.db.on()) {
                this.db.println("update: removeAlarms (TR)");
            }
            this.removeAlarms((AbstractCollection)object);
        } else if (object instanceof Integer) {
            Integer n = (Integer)object;
            if (n.equals(DELETE_CLEARED_ALARM_BUTTON)) {
                NodeKey nodeKey = (NodeKey)this.storeObsToKey.get(observable);
                if (this.netChildren.containsKey(nodeKey)) {
                    this.removeClearedAlarms(nodeKey);
                }
            } else {
                NodeKey nodeKey = this.getNodeKey(n);
                if (this.netChildren.containsKey(nodeKey)) {
                    this.flushAlarmStore(nodeKey);
                }
            }
        } else if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            if (objectArray.length != 2) {
                return;
            }
            Integer n = (Integer)objectArray[0];
            if (n.equals(DELETE_CLEARED_ALARM_BUTTON)) {
                if (this.db.on()) {
                    this.db.println("update: removeClearedAlarms()");
                }
                this.removeClearedAlarms(this.getNodeKey((Integer)objectArray[1]));
            } else if (n.equals(SYNC_ALARM_BUTTON)) {
                NodeKey nodeKey;
                if (this.db.on()) {
                    this.db.println("update: flushAlarmStore()");
                }
                if (this.netChildren.containsKey(nodeKey = this.getNodeKey((Integer)objectArray[1]))) {
                    this.flushAlarmStore(this.getNodeKey((Integer)objectArray[1]));
                }
            } else if (n.equals(ModelUpdateType.DELETED)) {
                observable.deleteObserver(this);
                if (this.db.on()) {
                    this.db.println("Removing storeObsToKey entry for " + observable);
                }
                this.storeObsToKey.remove(observable);
                ArrayList arrayList = (ArrayList)objectArray[1];
                if (this.db.on()) {
                    this.db.println("update: EAS deleted, size=" + arrayList.size());
                }
                this.removeAlarms(arrayList);
            }
        }
    }

    public void removeClearedAlarms(int n) {
        this.removeClearedAlarms(this.getNodeKey(n));
    }

    private void removeClearedAlarms(NodeKey nodeKey) {
        if (nodeKey == null) {
            return;
        }
        boolean bl = this.removeClearedAlarms(this.arrayList, nodeKey);
        if (bl) {
            this.removeClearedAlarms(this.filteredArrayList, nodeKey);
        }
        if (bl) {
            this.fireDataSourceChanged();
        }
    }

    private synchronized boolean removeClearedAlarms(ArrayList arrayList, NodeKey nodeKey) {
        boolean bl = false;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            EventInfo eventInfo = (EventInfo)iterator.next();
            try {
                eventInfo.setNewAlm(false);
                if (!nodeKey.belongsToMe(eventInfo) || eventInfo.getState() != 'C') continue;
                iterator.remove();
                bl = true;
            }
            catch (Exception exception) {
                if (!this.db.on()) continue;
                this.db.println("Caught exception in removeClearedAlarms()");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return bl;
    }

    public synchronized void removeClearedAlarms() {
        if (!this.allNodeKeys.isEmpty()) {
            Iterator iterator = this.allNodeKeys.values().iterator();
            while (iterator.hasNext()) {
                NodeKey nodeKey = (NodeKey)iterator.next();
                IAlarmStore iAlarmStore = (IAlarmStore)this.netChildren.get(nodeKey);
                try {
                    if (iAlarmStore != null) {
                        iAlarmStore.removeClearedAlarms();
                        continue;
                    }
                    this.removeClearedAlarms(nodeKey);
                }
                catch (Exception exception) {
                    if (!this.db.on()) continue;
                    this.db.println("Caught exception in removeClearedAlarms()");
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
    }

    public void flushAlarmStore(int n) {
        this.flushAlarmStore(this.getNodeKey(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushAlarmStore(NodeKey nodeKey) {
        if (nodeKey == null) {
            return;
        }
        boolean bl = false;
        NetworkAlarmStore networkAlarmStore = this;
        synchronized (networkAlarmStore) {
            bl = this.flushAlarmStore(this.arrayList, nodeKey, true);
            if (bl) {
                this.flushAlarmStore(this.filteredArrayList, nodeKey, false);
            }
        }
        if (bl) {
            this.fireDataSourceChanged();
            this.localUpdateView();
        }
    }

    private synchronized boolean flushAlarmStore(ArrayList arrayList, NodeKey nodeKey, boolean bl) {
        boolean bl2 = false;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            EventInfo eventInfo = (EventInfo)iterator.next();
            try {
                if (nodeKey.belongsToMe(eventInfo)) {
                    if (this.db.on()) {
                        this.db.println("Event " + eventInfo + " belongs to key " + nodeKey);
                    }
                    iterator.remove();
                    bl2 = true;
                    if (!bl || eventInfo.getState() != 'R') continue;
                    this.alrStatus.decrementSeverity(eventInfo.getSeverity());
                    continue;
                }
                if (!this.db.on()) continue;
                this.db.println("Event " + eventInfo + " does not belong to key " + nodeKey);
            }
            catch (Exception exception) {
                if (!this.db.on()) continue;
                this.db.println("Caught exception in flushAlarmStore()");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushAlarmStore() {
        super.flushStore();
        NetworkAlarmStore networkAlarmStore = this;
        synchronized (networkAlarmStore) {
            if (!this.allNodeKeys.isEmpty() && !this.netChildren.isEmpty()) {
                Iterator iterator = this.allNodeKeys.values().iterator();
                while (iterator.hasNext()) {
                    NodeKey nodeKey = (NodeKey)iterator.next();
                    IAlarmStore iAlarmStore = (IAlarmStore)this.netChildren.get(nodeKey);
                    try {
                        if (iAlarmStore == null) continue;
                        iAlarmStore.flushAlarmStore();
                    }
                    catch (Exception exception) {
                        if (!this.db.on()) continue;
                        this.db.println("Caught exception in flushAlarmStore()");
                        SDebug.printStackTrace((Throwable)exception);
                    }
                }
            }
        }
        this.localUpdateView();
    }

    public void getAllPendingAlarms() throws AbstractCmsIOException {
        Iterator iterator = Network.instance().getElements().iterator();
        while (iterator.hasNext()) {
            try {
                ((INetElement)iterator.next()).getNodeModel().synchronizeAlarm();
            }
            catch (Exception exception) {
                if (!this.db.on()) continue;
                this.db.println("Caught exception in getAllPendingAlarms()");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public synchronized void addChild(String string, int n, IAlarmStore iAlarmStore) {
        NodeKey nodeKey = this.addNodeKey(string, n);
        if (this.db.on()) {
            this.db.println("Adding child with key " + nodeKey);
        }
        this.netChildren.put(nodeKey, iAlarmStore);
    }

    public synchronized void deleteChild(int n) {
        NodeKey nodeKey = this.getNodeKey(n);
        if (this.db.on()) {
            this.db.println("Deleting child with key " + nodeKey);
        }
        this.netChildren.remove(nodeKey);
        this.flushAlarmStore(nodeKey);
    }

    public synchronized void swapNodeId(int n, int n2) {
        for (int i = 0; i < this.arrayList.size(); ++i) {
            EventInfo eventInfo = (EventInfo)this.arrayList.get(i);
            if (eventInfo.getNodeId() != n) continue;
            eventInfo.setNodeId(n2);
            if (!this.db.on()) continue;
            this.db.println("swapping nodeID for " + eventInfo.getCondCode());
        }
    }

    protected void localUpdateStatus(EventInfo eventInfo) {
    }

    private NetworkAlarmStore(String string) {
        super(string);
        this.children = null;
        this.netChildren = new HashMap();
        this.storeObsToKey = new HashMap();
        this.allNodeKeys = new HashMap();
        this.name = string;
        this.db = new AbstractAlarmStore.AsDebug(null, this.name);
        this.alarmStatusObservable = new StoreObservable(this.name);
        this.storeObservable = new StoreObservable(this.name);
        this.correlator = new SimpleAlarmCorrelator();
        this.alrStatus = new AlarmStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAlarms(ArrayList arrayList) {
        boolean bl = false;
        NetworkAlarmStore networkAlarmStore = this;
        synchronized (networkAlarmStore) {
            block6: for (int i = 0; i < arrayList.size(); ++i) {
                EventInfo eventInfo = (EventInfo)arrayList.get(i);
                switch (eventInfo.getCondition()) {
                    case 1024: 
                    case 1025: 
                    case 1028: {
                        continue block6;
                    }
                    default: {
                        this.correlateAlarm(eventInfo, eventInfo.getCorrelated());
                    }
                }
            }
            bl = arrayList.size() > 0;
        }
        if (bl) {
            this.storeObservable.setChanged();
            this.storeObservable.notifyObservers(arrayList);
        }
        this.updateView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventInfo postNetworkAlarm(EventInfo eventInfo) {
        EventInfo eventInfo2;
        Object object = this;
        synchronized (object) {
            eventInfo2 = this.storeEvent(eventInfo);
        }
        if (eventInfo2 == null || eventInfo2.getState() != eventInfo.getState()) {
            object = new ArrayList(1);
            ((ArrayList)object).add(eventInfo);
            this.storeObservable.setChanged();
            this.storeObservable.notifyObservers(object);
            this.updateView();
        }
        return eventInfo2;
    }

    private synchronized void mapStoreObservable(Observable observable, NodeKey nodeKey) {
        if (!this.storeObsToKey.containsKey(observable)) {
            if (this.db.on()) {
                this.db.println("Mapping storeObs=" + observable + " to " + nodeKey);
            }
            this.storeObsToKey.put(observable, nodeKey);
        }
    }

    public synchronized NodeKey addNodeKey(String string, int n) {
        NodeKey nodeKey = new NodeKey(string, n);
        if (!this.allNodeKeys.containsKey(nodeKey)) {
            if (this.db.on()) {
                this.db.println("Adding " + nodeKey);
            }
            this.allNodeKeys.put(nodeKey, nodeKey);
        }
        return nodeKey;
    }

    public NodeKey getNodeKey(int n) {
        if (this.db.on()) {
            this.db.println("Getting NodeKey with hostName = null, nodeId=" + n);
        }
        return (NodeKey)this.allNodeKeys.get(new NodeKey(null, n));
    }

    private class NodeKey {
        private String _hostName;
        private int _nodeId;

        public NodeKey(String string, int n) {
            this._hostName = string;
            this._nodeId = n == 0 ? -1 : n;
        }

        public boolean equals(Object object) {
            if (object instanceof NodeKey) {
                NodeKey nodeKey = (NodeKey)object;
                if (this._nodeId == -1 || nodeKey.nodeId() == -1) {
                    if (this._hostName != null && nodeKey.hostName() != null) {
                        return this._hostName.equals(nodeKey.hostName());
                    }
                } else {
                    return this._nodeId == nodeKey.nodeId();
                }
            }
            return false;
        }

        public int hashCode() {
            return this._nodeId;
        }

        public String hostName() {
            return this._hostName;
        }

        public int nodeId() {
            return this._nodeId;
        }

        public boolean belongsToMe(EventInfo eventInfo) {
            return this.equals(new NodeKey(eventInfo.getNodeHostName(), eventInfo.getNodeId()));
        }

        public String toString() {
            return "NodeKey(" + this._hostName + ", " + this._nodeId + ")";
        }
    }
}

