/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.CircuitEnd;
import cerent.cms.model.ICircuitEnd;
import cerent.cms.model.ILoAditModel;
import cerent.cms.ncp.CircuitMergeError;
import cerent.cms.ncp.CircuitMergeSplicer;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitSpan;
import cerent.cms.ncp.LoTunnelNode;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitEndFactory;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitMergeOperator;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.util.HoLoComparator;
import cerent.util.IHoNum;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class CircuitMergeFilter {
    private static SDebug db = new SDebug("CircuitMergeFilter");
    private static CircuitEndComparator cktEndComp = new CircuitEndComparator();
    private static HoLoComparator holoComp = HoLoComparator.instance();
    private static Network net = Network.instance();
    private static NetCircuitManager ncm = NetCircuitManager.instance();
    private NetCircuit masterCkt;
    private boolean stopRequired;

    public CircuitMergeFilter(INetCircuit iNetCircuit) {
        this.masterCkt = (NetCircuit)iNetCircuit;
    }

    public boolean isMergeable(INetCircuit iNetCircuit) {
        NetCircuit netCircuit = (NetCircuit)iNetCircuit;
        if (netCircuit.getCircuitSize() != this.masterCkt.getCircuitSize()) {
            return false;
        }
        try {
            NetCircuitMergeOperator.validateForMerge(netCircuit);
            CircuitMergeSplicer.checkOchnc(this.masterCkt, netCircuit, this.masterCkt);
            CircuitMergeSplicer.checkVlan(this.masterCkt, netCircuit, this.masterCkt);
            CircuitMergeSplicer.checkSla(this.masterCkt, netCircuit, this.masterCkt);
            CircuitMergeSplicer.checkMonitor(this.masterCkt, netCircuit, this.masterCkt);
            return true;
        }
        catch (CircuitMergeError circuitMergeError) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)circuitMergeError);
            }
            return false;
        }
    }

    public void stopLinedupCircuitsSearch() {
        this.stopRequired = true;
    }

    public List findLinedupCircuits() {
        return this.findLinedupCircuits(ncm.getCircuits());
    }

    public List findLinedupCircuits(List list) {
        boolean bl;
        Set set;
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            object = (INetCircuit)object2.next();
            if (object == this.masterCkt || !this.isMergeable((INetCircuit)object) || (set = this.findFreeCircuitEndSet((INetCircuit)object)).isEmpty()) continue;
            arrayList.add(object);
        }
        object2 = new ArrayList();
        object = new ArrayList();
        set = new TreeSet(cktEndComp);
        set.addAll(this.getPeerCircuitEnds(this.findFreeCircuitEndSet(this.masterCkt)));
        this.stopRequired = false;
        block1: do {
            bl = false;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                INetCircuit iNetCircuit = (INetCircuit)iterator.next();
                Set set2 = this.findFreeCircuitEndSet(iNetCircuit);
                if (set2.isEmpty()) continue;
                TreeSet treeSet = new TreeSet(cktEndComp);
                treeSet.addAll(set2);
                treeSet.retainAll(set);
                if (treeSet.isEmpty()) continue;
                if (db.on()) {
                    db.println("size of waiting/free/intersect cktEnd set are: " + set.size() + "/" + set2.size() + "/" + treeSet.size());
                }
                object2.add(iNetCircuit);
                set.removeAll(treeSet);
                set2.removeAll(treeSet);
                set.addAll(this.getPeerCircuitEnds(set2));
                iterator.remove();
                bl = true;
                continue block1;
            }
        } while (bl && !this.stopRequired);
        return object2;
    }

    private Set findFreeCircuitEndSet(INetCircuit iNetCircuit) {
        TreeSet<ICircuitEnd> treeSet = new TreeSet<ICircuitEnd>(cktEndComp);
        Iterator iterator = CircuitMergeFilter.findFreeCircuitEnds(iNetCircuit).iterator();
        while (iterator.hasNext()) {
            treeSet.add(((NetCircuitEnd)iterator.next()).getCircuitEnd());
        }
        return treeSet;
    }

    public static List findFreeCircuitEnds(INetCircuit iNetCircuit) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = iNetCircuit.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            if (netCircuitNode.completeCheck() && netCircuitNode.sources().isEmpty() && netCircuitNode.drops().isEmpty()) continue;
            arrayList.addAll(CircuitMergeFilter.findFreeCircuitEnds(netCircuitNode));
        }
        return arrayList;
    }

    public static List findFreeCircuitEnds(NetCircuitNode netCircuitNode) {
        ArrayList<NetCircuitEnd> arrayList = new ArrayList<NetCircuitEnd>();
        Object[] objectArray = netCircuitNode instanceof LoTunnelNode ? new Object[]{((ILoAditModel)netCircuitNode.getConn()).getHo()} : netCircuitNode.getPathsFromConnModel();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createCircuitEndFromConn(netCircuitNode.getNetElement(), object);
            Iterator iterator = netCircuitNode.getAllSpans().keySet().iterator();
            while (iterator.hasNext()) {
                INetCircuitSpan iNetCircuitSpan = (INetCircuitSpan)iterator.next();
                if (!CircuitMergeFilter.isSpanEnd(iNetCircuitSpan, netCircuitEnd)) continue;
            }
            if (db.on()) {
                db.println("find free cktEnd - " + netCircuitEnd.prettyString());
            }
            arrayList.add(netCircuitEnd);
        }
        return arrayList;
    }

    private static boolean isSpanEnd(INetCircuitSpan iNetCircuitSpan, NetCircuitEnd netCircuitEnd) {
        INetLink iNetLink = iNetCircuitSpan.getLink();
        return iNetLink.getSrc() == netCircuitEnd.getNetElement() && iNetLink.getSrcEntityIndex() == netCircuitEnd.getEntityIndex() && holoComp.isEqual(iNetLink.getSrcHo(), netCircuitEnd.getHoNum()) && holoComp.isEqual(iNetCircuitSpan.getLoNum(), netCircuitEnd.getLoNum()) || iNetLink.getDst() == netCircuitEnd.getNetElement() && iNetLink.getDstEntityIndex() == netCircuitEnd.getEntityIndex() && holoComp.isEqual(iNetLink.getDstHo(), netCircuitEnd.getHoNum()) && holoComp.isEqual(iNetCircuitSpan.getLoNum(), netCircuitEnd.getLoNum());
    }

    private Set getPeerCircuitEnds(Set set) {
        TreeSet<CircuitEnd> treeSet = new TreeSet<CircuitEnd>(cktEndComp);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            CircuitEnd circuitEnd = CircuitMergeFilter.getPeerCircuitEnd((ICircuitEnd)iterator.next());
            if (circuitEnd == null) continue;
            treeSet.add(circuitEnd);
        }
        return treeSet;
    }

    public static CircuitEnd getPeerCircuitEnd(ICircuitEnd iCircuitEnd) {
        INetLink iNetLink = null;
        INetElement iNetElement = net.getNetElem(iCircuitEnd.getNodeId());
        IHoNum iHoNum = null;
        if (iNetElement == null || iCircuitEnd.getHoLoNum() == null) {
            return null;
        }
        if (iCircuitEnd.getHoLoNum().getLoNum() != null && (iNetLink = net.findNetLinkFromSource(true, iNetElement, iCircuitEnd.getPortNum(), iCircuitEnd.getHoLoNum().getHoNum())) != null) {
            iHoNum = iNetLink.getDstHo();
        }
        if (iNetLink == null && (iNetLink = Network.instance().findNetLinkFromSource(false, iNetElement, iCircuitEnd.getPortNum(), iCircuitEnd.getHoLoNum().getHoNum())) != null) {
            iHoNum = iCircuitEnd.getHoLoNum().getHoNum();
        }
        if (iNetLink == null || iNetLink.state() != 1) {
            return null;
        }
        CircuitEnd circuitEnd = new CircuitEnd(iNetLink.getDst().getNodeId(), iNetLink.getDstEntityIndex(), iHoNum, iCircuitEnd.getHoLoNum().getLoNum(), false, 0);
        if (db.on()) {
            db.println("create peer end: " + CircuitMergeFilter.prettyString(circuitEnd));
        }
        return circuitEnd;
    }

    private static String prettyString(CircuitEnd circuitEnd) {
        return "[ " + circuitEnd.getNodeId() + ", " + Integer.toHexString(circuitEnd.getPortNum()) + ", " + (circuitEnd.getHoLoNum() == null ? "null" : circuitEnd.getHoLoNum().getHoNum() + ", " + circuitEnd.getHoLoNum().getLoNum());
    }

    private static class CircuitEndComparator
    implements Comparator {
        private CircuitEndComparator() {
        }

        public int compare(Object object, Object object2) {
            CircuitEnd circuitEnd = (CircuitEnd)object;
            CircuitEnd circuitEnd2 = (CircuitEnd)object2;
            if (circuitEnd.getNodeId() != circuitEnd2.getNodeId()) {
                return circuitEnd.getNodeId() - circuitEnd2.getNodeId();
            }
            if (circuitEnd.getPortNum() != circuitEnd2.getPortNum()) {
                return circuitEnd.getPortNum() - circuitEnd2.getPortNum();
            }
            return holoComp.compare(circuitEnd.getHoLoNum(), circuitEnd2.getHoLoNum());
        }
    }
}

