/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CircuitEnd;
import cerent.cms.model.DuplicateCircuit;
import cerent.cms.model.ICircuitEnd;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IEtherBridgeModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IVlanModel;
import cerent.cms.model.NoMoreEtherCircuit;
import cerent.cms.model.NoMoreSpanningTree;
import cerent.cms.model.NoSuchCircuit;
import cerent.cms.model.NoSuchVlan;
import cerent.cms.model.VlanInUse;
import cerent.cms.model.VlanSpanningTreeViolation;
import cerent.cms.ncp.HoCircuitEnd;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.topo.INetElement;
import cerent.cms.vlan.IoError;
import cerent.cms.vlan.VlanSetManager;
import cerent.util.SDebug;

public class EtherP2PCircuitEnd
extends HoCircuitEnd {
    private static SDebug db = new SDebug("EtherP2PCircuitEnd");

    public EtherP2PCircuitEnd() {
    }

    public EtherP2PCircuitEnd(INodeModel iNodeModel, ICircuitEnd iCircuitEnd) {
        super(iNodeModel, iCircuitEnd);
    }

    public EtherP2PCircuitEnd(INetCircuitEnd iNetCircuitEnd) {
        super(iNetCircuitEnd);
    }

    public EtherP2PCircuitEnd(INetElement iNetElement, int n) {
        this.setCircuitEnd(new CircuitEnd(iNetElement.getNodeModel().getNodeId(), n, null, null, false, 0));
        this.setStage(4);
    }

    protected void createEtherBridge(ICircuitId iCircuitId, IVlanModel[] iVlanModelArray) throws NoMoreEtherCircuit, NoMoreSpanningTree, NoSuchVlan, VlanSpanningTreeViolation, DuplicateCircuit, AbstractCmsIOException {
        INodeModel iNodeModel = this.getNodeModel();
        IEtherBridgeModel iEtherBridgeModel = iNodeModel.getEtherBridgeModel();
        if (this.dbgOn()) {
            db.println("bridge.createCircuit() at node " + iNodeModel.getName());
        }
        String string = "Got exception from etherBridge at NE " + iNodeModel.getName();
        try {
            iEtherBridgeModel.createCircuit(iCircuitId, iVlanModelArray);
        }
        catch (NoMoreEtherCircuit noMoreEtherCircuit) {
            if (this.dbgOn()) {
                db.println(string);
                db.println(noMoreEtherCircuit.getPrettyMessage());
            }
            throw noMoreEtherCircuit;
        }
        catch (NoMoreSpanningTree noMoreSpanningTree) {
            if (this.dbgOn()) {
                db.println(string);
                db.println(noMoreSpanningTree.getPrettyMessage());
            }
            throw noMoreSpanningTree;
        }
        catch (NoSuchVlan noSuchVlan) {
            if (this.dbgOn()) {
                db.println(string);
                db.println(noSuchVlan.getPrettyMessage());
            }
            throw noSuchVlan;
        }
        catch (VlanSpanningTreeViolation vlanSpanningTreeViolation) {
            if (this.dbgOn()) {
                db.println(string);
                db.println(vlanSpanningTreeViolation.getPrettyMessage());
            }
            throw vlanSpanningTreeViolation;
        }
        catch (DuplicateCircuit duplicateCircuit) {
            if (this.dbgOn()) {
                db.println(string);
                db.println(duplicateCircuit.getPrettyMessage());
            }
            throw duplicateCircuit;
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            if (this.dbgOn()) {
                db.println("Got I/O exception at " + iNodeModel.getName());
            }
            throw abstractCmsIOException;
        }
    }

    protected void destroySanityCheck(ICircuitId iCircuitId) throws SanityCheckFailed {
        INodeModel iNodeModel = this.getNodeModel();
        IEtherBridgeModel iEtherBridgeModel = iNodeModel.getEtherBridgeModel();
        if (iEtherBridgeModel == null) {
            throw new SanityCheckFailed("Unable to contact " + iNodeModel.getName() + " to approve deletion of Ethernet circuit ");
        }
        boolean bl = true;
        try {
            if (this.dbgOn()) {
                db.println("bridge.deleteCircuitTest() at node " + iNodeModel.getName());
            }
            bl = iEtherBridgeModel.deleteCircuitTest(iCircuitId);
        }
        catch (VlanInUse vlanInUse) {
            bl = false;
        }
        catch (NoSuchCircuit noSuchCircuit) {
            bl = false;
        }
        if (!bl) {
            throw new SanityCheckFailed("Deleting Ethernet Circuit disallowed at " + iNodeModel.getName() + ".\n VLANs may be in use at this node");
        }
    }

    protected void destroyEtherBridge(ICircuitId iCircuitId) throws SanityCheckFailed {
        block8: {
            INodeModel iNodeModel;
            IEtherBridgeModel iEtherBridgeModel;
            if (this.dbgOn()) {
                db.println("destroyEtherBridge() called");
            }
            if ((iEtherBridgeModel = (iNodeModel = this.getNodeModel()).getEtherBridgeModel()) == null) {
                if (this.dbgOn()) {
                    db.println("destroyEtherBridge: FAILURE- unable to get EtherBridgeModel");
                }
                return;
            }
            try {
                if (this.dbgOn()) {
                    db.println("bridge.deleteCircuit() at node " + iNodeModel.getName());
                }
                iEtherBridgeModel.deleteCircuit(iCircuitId);
            }
            catch (VlanInUse vlanInUse) {
                if (this.dbgOn()) {
                    db.println("bridge.deleteCircuit() failed (VlanInUse) at node " + iNodeModel.getName());
                }
                throw new SanityCheckFailed("VLAN is in use at node " + iNodeModel.getName());
            }
            catch (NoSuchCircuit noSuchCircuit) {
                if (!this.dbgOn()) break block8;
                db.println("bridge.deleteCircuit() failed (NoSuchCircuit) at node " + iNodeModel.getName());
            }
        }
    }

    protected void changeVlanSet(ICircuitId iCircuitId, IVlanModel[] iVlanModelArray) {
        block5: {
            INodeModel iNodeModel = this.getNodeModel();
            if (iNodeModel == null) {
                if (this.dbgOn()) {
                    db.println("bridge.changeVlanSet for cktEnd " + this.prettyString() + " could not find node model");
                }
                return;
            }
            IEtherBridgeModel iEtherBridgeModel = null;
            iEtherBridgeModel = iNodeModel.getEtherBridgeModel();
            if (this.dbgOn()) {
                db.println("bridge.changeCircuit() at node " + iNodeModel.getName());
            }
            try {
                iEtherBridgeModel.changeCircuit(iCircuitId, iVlanModelArray);
            }
            catch (CTCUserException cTCUserException) {
                if (!this.dbgOn()) break block5;
                db.println("Warning! unable to change VLAN set at " + iNodeModel.getName());
            }
        }
    }

    protected boolean changeVlanSetCheck(ICircuitId iCircuitId, IVlanModel[] iVlanModelArray) {
        INodeModel iNodeModel = this.getNodeModel();
        if (iNodeModel == null) {
            if (this.dbgOn()) {
                db.println("bridge.changeVlanSetCheck for cktEnd " + this.prettyString() + " could not find node model");
            }
            return true;
        }
        IEtherBridgeModel iEtherBridgeModel = null;
        VlanSetManager vlanSetManager = VlanSetManager.instance();
        if (vlanSetManager != null) {
            try {
                if (this.dbgOn()) {
                    db.println("vsm.ensureVlansExist() at " + iNodeModel.getName());
                }
                vlanSetManager.ensureVlansExist(iNodeModel, iVlanModelArray);
            }
            catch (IoError ioError) {
                if (this.dbgOn()) {
                    db.println("IO error ensuring VLAN set at " + iNodeModel.getName());
                }
                return false;
            }
        }
        if ((iEtherBridgeModel = iNodeModel.getEtherBridgeModel()) == null) {
            if (this.dbgOn()) {
                db.println("Null bridge!!");
            }
            return false;
        }
        boolean bl = true;
        try {
            if (this.dbgOn()) {
                db.println("bridge.changeCircuitTest() at node " + iNodeModel.getName());
            }
            bl = iEtherBridgeModel.changeCircuitTest(iCircuitId, iVlanModelArray);
        }
        catch (NoSuchVlan noSuchVlan) {
            bl = false;
        }
        catch (NoSuchCircuit noSuchCircuit) {
            bl = false;
        }
        catch (NoMoreSpanningTree noMoreSpanningTree) {
            bl = false;
        }
        catch (VlanSpanningTreeViolation vlanSpanningTreeViolation) {
            bl = false;
        }
        return bl;
    }

    protected boolean isEtherP2PCircuitEnd() {
        return true;
    }

    protected boolean dbgOn() {
        return db.on() || super.dbgOn();
    }

    private void debug(String string) {
        db.println(string);
    }
}

