/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.AllocFailed;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CannotDeleteLastDrop;
import cerent.cms.model.CircuitType;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.ICircuitModel;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IVlanModel;
import cerent.cms.model.LinkModel;
import cerent.cms.model.ObjDuplicate;
import cerent.cms.model.ObjNotFound;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.CircuitDropOutstanding;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.ConnTypeUnsupported;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.DualConnectionCircuitNode;
import cerent.cms.ncp.HoCircuitEnd;
import cerent.cms.ncp.HoCircuitNode;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ncp.LoTunnelNode;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitEndFactory;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitNodeFactory;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.NetCircuitSpanFactory;
import cerent.cms.ncp.NetCircuitSplicer;
import cerent.cms.ncp.NetCircuitWatchDog;
import cerent.cms.ncp.PortGrouping;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ncp.VlanStpSanityCheckFailed;
import cerent.cms.ncp.eSpanDirection;
import cerent.cms.route.INetLinkSpan;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.route.NoRoute;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetLink;
import cerent.cms.topo.NetLinkFactory;
import cerent.cms.vlan.NetVlanInfo;
import cerent.cms.vlan.VlanSetManager;
import cerent.util.AnnotatedException;
import cerent.util.IHoNum;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class HoCcatCircuit
extends NetCcatCircuit {
    private static final SDebug db = new SDebug("HoCcatCircuit");
    private IVlanModel[] circuitInfoVlanModels = new IVlanModel[0];
    private NetLink lotLink = null;
    private NetLink revLotLink = null;
    private boolean createWithStpEnabled;
    private INetCircuitEnd[] xmCircuitEnds;
    private NetLink lapLink = null;
    private NetLink revLapLink = null;

    protected HoCcatCircuit(CircuitCreatInfo circuitCreatInfo) {
        super(circuitCreatInfo);
        this.createWithStpEnabled = true;
        this.xmCircuitEnds = new INetCircuitEnd[0];
    }

    protected HoCcatCircuit(CircuitCreatInfo circuitCreatInfo, INetCircuitEnd iNetCircuitEnd, INetCircuitEnd iNetCircuitEnd2) {
        super(circuitCreatInfo, iNetCircuitEnd, iNetCircuitEnd2);
        this.xmCircuitEnds = new INetCircuitEnd[0];
    }

    protected HoCcatCircuit(CircuitCreatInfo circuitCreatInfo, INetElement iNetElement) {
        this(circuitCreatInfo);
        NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createNodeDrop(circuitCreatInfo.type(), iNetElement);
        this.circuitInfo.setSrcPoint(netCircuitEnd.getCircuitEnd());
        this.insertSource(netCircuitEnd);
        NetCircuitDropInfo netCircuitDropInfo = new NetCircuitDropInfo(netCircuitEnd, 2);
        this.srcCircuitNode = NetCircuitNodeFactory.createCircuitNode(iNetElement, this);
        this.setSrcNodeModel(iNetElement.getNodeModel());
        this.insertCktNode(this.srcCircuitNode);
        this.srcCircuitNode.addDropInfo(netCircuitDropInfo);
    }

    protected HoCcatCircuit(CircuitCreatInfo circuitCreatInfo, INetElement iNetElement, Object object) {
        super(circuitCreatInfo, iNetElement, object);
        this.xmCircuitEnds = new INetCircuitEnd[0];
        this.clearChanged();
    }

    protected HoCcatCircuit(CircuitCreatInfo circuitCreatInfo, INodeModel iNodeModel, ICircuitModel iCircuitModel) throws AbstractCmsObjectNotExistException {
        this(circuitCreatInfo);
        this.initState(4);
        this.addDiscoveredCircuitInfo(iNodeModel, iCircuitModel);
        this.clearChanged();
    }

    protected boolean isRepairable() {
        if (this.isStitchedEthernet()) {
            if (this.dbgOn()) {
                db.println("Stitched Ethernet Circuit cannot be repaired");
            }
            return false;
        }
        return super.isRepairable();
    }

    protected void checkAndUpdateCircuit() {
        this.deleteLoTunnelNetLink();
        this.deleteLAPNetLink();
        super.checkAndUpdateCircuit();
    }

    protected void deleteLAPLink(ICircuitModel iCircuitModel) {
        ICircuitType iCircuitType;
        if (this.getCircuitTypeObj().isLAPCircuitType() && (iCircuitType = CircuitType.getCircuitType((int)iCircuitModel.getType())).isTunnelCircuitType()) {
            this.deleteLAPNetLink();
            this.ncMgr.removeCircuitIfLAP(this);
        }
    }

    protected boolean validateCircuitTopology() {
        if (this.getCircuitTypeObj().isEthernetCircuitType()) {
            if (this.getCktNodeListSize() == 0 || this.getSourcesSize() != 1) {
                if (this.dbgOn()) {
                    db.println("Circuit has invalid nodes/sources");
                }
                return false;
            }
            return true;
        }
        if (this.getCircuitTypeObj().isTunnelCircuitType()) {
            if (this.getCktNodeListSize() < 2 || this.getTunnelNodeNum() != 2 || this.getSourcesSize() != 1 || this.getDropsSize() != 1) {
                if (this.dbgOn()) {
                    db.println("LOT circuit has invalid nodes/drops/sources");
                }
                return false;
            }
            return true;
        }
        if (this.getCircuitTypeObj().isLAPCircuitType()) {
            if (this.getCktNodeListSize() < 2 || this.getSourcesSize() != 1 || this.getDropsSize() != 1) {
                if (this.dbgOn()) {
                    db.println("LAP circuit has invalid nodes/drops/sources");
                }
                return false;
            }
            return true;
        }
        return super.validateCircuitTopology();
    }

    private int getTunnelNodeNum() {
        int n = 0;
        Iterator iterator = this.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof LoTunnelNode)) continue;
            ++n;
        }
        return n;
    }

    protected void getNodeLevelSourcesAndDrops(List list, List list2) {
        super.getNodeLevelSourcesAndDrops(list, list2);
        if (this.circuitInfoActive()) {
            return;
        }
        if (!(this.getCircuitTypeObj().isTunnelCircuitType() || this.getCircuitTypeObj().isLAPCircuitType() || this.getCircuitTypeObj().isEthernetCircuitType())) {
            return;
        }
        Iterator iterator = this.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            if (!netCircuitNode.hasAggregation() && netCircuitNode.getConnectionType() != 8) continue;
            NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createNodeDrop(this.getCircuitType(), netCircuitNode.getNetElement());
            int n = netCircuitNode.countNumTermSpans();
            int n2 = netCircuitNode.countNumOrigSpans();
            if (n == 0 && n2 > 0) {
                list.add(netCircuitEnd);
                continue;
            }
            if (n > 0 && n2 == 0) {
                list2.add(netCircuitEnd);
                continue;
            }
            if (n > 0 && n2 > 0 && netCircuitNode.getConnectionType() == 8) {
                list2.add(netCircuitEnd);
                continue;
            }
            if (n != 0 || n2 != 0) continue;
            if (list.size() == 0) {
                list.add(netCircuitEnd);
                continue;
            }
            list2.add(netCircuitEnd);
        }
    }

    protected boolean completeCheck() {
        if (super.completeCheck()) {
            if (this.getCircuitTypeObj().isTunnelCircuitType()) {
                this.addTunnelNetLink();
            }
            if (this.getCircuitTypeObj().isLAPCircuitType()) {
                this.addLAPNetLink();
            }
            return true;
        }
        return false;
    }

    protected boolean tl1CircuitCompleteCheck() {
        if (super.tl1CircuitCompleteCheck()) {
            if (this.getCircuitTypeObj().isTunnelCircuitType()) {
                this.addTunnelNetLink();
            }
            if (this.getCircuitTypeObj().isLAPCircuitType()) {
                this.addLAPNetLink();
            }
            return true;
        }
        return false;
    }

    protected boolean isStitchedEthernet() {
        return this.getCircuitTypeObj().isEthernetCircuitType();
    }

    protected boolean isEthernet() {
        boolean bl = false;
        try {
            bl = this.isVlanCapable();
        }
        catch (IncorrectCircuitState incorrectCircuitState) {
            bl = false;
        }
        return bl;
    }

    public boolean isVlanCapable() throws IncorrectCircuitState {
        if (this.getCircuitTypeObj().isEthernetCircuitType()) {
            return true;
        }
        if (this.getSourcesSize() == 0 || this.getDropsSize() == 0) {
            throw new IncorrectCircuitState("Can't determine if Vlan capable yet.");
        }
        Iterator iterator = this.getCktSources().iterator();
        while (iterator.hasNext()) {
            NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
            if (!netCircuitEnd.isEtherP2PCircuitEnd()) continue;
            return true;
        }
        iterator = this.getCktDrops().iterator();
        while (iterator.hasNext()) {
            NetCircuitDropInfo netCircuitDropInfo = (NetCircuitDropInfo)iterator.next();
            if (!netCircuitDropInfo.getNetCktEnd().isEtherP2PCircuitEnd()) continue;
            return true;
        }
        return false;
    }

    public boolean mustDisableStp() throws IncorrectCircuitState {
        boolean bl = true;
        if (this.getSourcesSize() == 0 || this.getDropsSize() == 0) {
            throw new IncorrectCircuitState("Can't determine if Vlan capable yet.");
        }
        Iterator iterator = this.getCktSources().iterator();
        while (iterator.hasNext()) {
            NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
            if (netCircuitEnd.isEtherP2PCircuitEnd()) continue;
            bl = false;
            break;
        }
        iterator = this.getCktDrops().iterator();
        while (iterator.hasNext()) {
            NetCircuitDropInfo netCircuitDropInfo = (NetCircuitDropInfo)iterator.next();
            if (netCircuitDropInfo.getNetCktEnd().isEtherP2PCircuitEnd()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public IVlanModel[] getVlans() {
        return this.circuitInfoVlanModels;
    }

    public NetVlanInfo[] getNetVlans() {
        IVlanModel[] iVlanModelArray = this.getVlans();
        NetVlanInfo[] netVlanInfoArray = new NetVlanInfo[iVlanModelArray.length];
        if (iVlanModelArray.length == 0 || this.getSrcCircuitNode() == null) {
            return netVlanInfoArray;
        }
        int n = this.getSrcCircuitNode().getNetElement().getTopoId();
        for (int i = 0; i < iVlanModelArray.length; ++i) {
            IVlanModel iVlanModel = iVlanModelArray[i];
            netVlanInfoArray[i] = new NetVlanInfo(iVlanModel, n);
        }
        return netVlanInfoArray;
    }

    public INetLink getLotLink() {
        return this.lotLink;
    }

    public INetLink getReverseLotLink() {
        return this.revLotLink;
    }

    public INetLink getLapLink() {
        return this.lapLink;
    }

    public INetLink getReverseLapLink() {
        return this.revLapLink;
    }

    protected void addTunnelNetLink() {
        block27: {
            LinkModel linkModel;
            int n;
            LinkedList<INetLink> linkedList;
            LinkedList<INetElement> linkedList2;
            int n2;
            IHoNum iHoNum;
            IHoNum iHoNum2;
            int n3;
            int n4;
            INetElement iNetElement;
            INodeModel iNodeModel;
            INetElement iNetElement2;
            INodeModel iNodeModel2;
            block26: {
                Object object;
                if (this.lotLink != null && this.revLotLink != null) {
                    return;
                }
                if (this.dbgOn()) {
                    db.println("adding LO tunnel to network topology");
                }
                if (this.getDropsSize() != 1 || this.getSourcesSize() != 1) {
                    if (this.dbgOn()) {
                        db.println("Warning! number of Tunnel ends != 2");
                    }
                    return;
                }
                NetCircuitEnd netCircuitEnd = (NetCircuitEnd)this.getPrimarySource();
                iNodeModel2 = netCircuitEnd.getNodeModel();
                if (iNodeModel2 == null) {
                    if (this.dbgOn()) {
                        db.println("Warning! unable to get node model of source ckt. end");
                    }
                    return;
                }
                iNetElement2 = this.getNetwork().findNetElem(iNodeModel2);
                if (iNetElement2 == null) {
                    if (this.dbgOn()) {
                        db.println("Warning! unable to find srcNE");
                    }
                    return;
                }
                NetCircuitNode netCircuitNode = (NetCircuitNode)this.getCircuitNodeFromNE(iNetElement2);
                if (netCircuitNode == null) {
                    if (this.dbgOn()) {
                        db.println("Warning! unable to find source ckt. node");
                    }
                    return;
                }
                NetCircuitDropInfo netCircuitDropInfo = (NetCircuitDropInfo)this.getCktDrops().get(0);
                netCircuitEnd = netCircuitDropInfo.getNetCktEnd();
                iNodeModel = netCircuitEnd.getNodeModel();
                if (iNodeModel == null) {
                    if (this.dbgOn()) {
                        db.println("Warning! unable to get node model of destn. ckt. end");
                    }
                    return;
                }
                iNetElement = this.getNetwork().findNetElem(iNodeModel);
                if (iNetElement == null) {
                    if (this.dbgOn()) {
                        db.println("Warning! unable to find dstNE");
                    }
                    return;
                }
                NetCircuitNode netCircuitNode2 = (NetCircuitNode)this.getCircuitNodeFromNE(iNetElement);
                if (netCircuitNode2 == null) {
                    if (this.dbgOn()) {
                        db.println("Warning! unable to find destination ckt. node");
                    }
                    return;
                }
                try {
                    n4 = netCircuitNode.getTunnelEntityIndex();
                    n3 = netCircuitNode2.getTunnelEntityIndex();
                    iHoNum2 = netCircuitNode.getLotHo();
                    iHoNum = netCircuitNode2.getLotHo();
                }
                catch (SanityCheckFailed sanityCheckFailed) {
                    if (this.dbgOn()) {
                        db.println("Sanity check failed while getting endpoint information");
                    }
                    return;
                }
                n2 = this.getProtType();
                linkedList2 = new LinkedList<INetElement>();
                Iterator iterator = this.getCircuitNodes().iterator();
                while (iterator.hasNext()) {
                    object = (NetCircuitNode)iterator.next();
                    linkedList2.add(((NetCircuitNode)object).getNetElement());
                    if (!this.dbgOn()) continue;
                    this.debug("Adding a Node to LOTNEs ");
                }
                object = new LinkedList();
                linkedList = new LinkedList<INetLink>();
                n = 0;
                Iterator iterator2 = this.getCircuitSpans().iterator();
                while (iterator2.hasNext()) {
                    NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator2.next();
                    ((LinkedList)object).add(netCircuitSpan.getLink());
                    linkedList.add(netCircuitSpan.getReverseLink());
                    n += netCircuitSpan.getLink().getCost();
                    if (!this.dbgOn()) continue;
                    this.debug("Adding a span to LOTLinks ");
                }
                linkModel = new LinkModel(iNodeModel2, n4, iHoNum2, iNodeModel, n3, iHoNum, 2, -1, -1, true, true, -1, -1, n2, "", 0, 0, 1, n, 0, 0);
                this.lotLink = (NetLink)NetLinkFactory.createNetLink(this.getNetwork(), linkModel, iNetElement2, iNetElement, iNetElement2.getTopology(), linkedList2, (LinkedList)object, this);
                try {
                    this.getNetwork().addNetLink(this.lotLink);
                    NetCircuitSplicer.instance().newNetLink(this.lotLink);
                }
                catch (ObjDuplicate objDuplicate) {
                    if (!this.dbgOn()) break block26;
                    db.println("duplicate LO tunnel");
                }
            }
            linkModel = new LinkModel(iNodeModel, n3, iHoNum, iNodeModel2, n4, iHoNum2, 2, -1, -1, true, true, -1, -1, n2, "", 0, 0, 1, n, 0, 0);
            this.revLotLink = (NetLink)NetLinkFactory.createNetLink(this.getNetwork(), linkModel, iNetElement, iNetElement2, iNetElement.getTopology(), linkedList2, linkedList, this);
            try {
                this.getNetwork().addNetLink(this.revLotLink);
                NetCircuitSplicer.instance().newNetLink(this.revLotLink);
            }
            catch (ObjDuplicate objDuplicate) {
                if (!this.dbgOn()) break block27;
                db.println("duplicate LO tunnel (reverse link)");
            }
        }
        if (this.getSla() != 0) {
            this.lotLink.setSla(this.getSla());
            this.revLotLink.setSla(this.getSla());
        }
    }

    protected void deleteLoTunnelNetLink() {
        if (this.lotLink != null) {
            if (this.dbgOn()) {
                this.debug("Deleting LOT link");
            }
            this.getNetwork().deleteNetLink(this.lotLink);
            this.lotLink = null;
        }
        if (this.revLotLink != null) {
            if (this.dbgOn()) {
                this.debug("Deleting reverse LOT link");
            }
            this.getNetwork().deleteNetLink(this.revLotLink);
            this.revLotLink = null;
        }
    }

    protected void addLAPNetLink() {
        block28: {
            LinkModel linkModel;
            int n;
            LinkedList<INetLink> linkedList;
            LinkedList<INetElement> linkedList2;
            int n2;
            IHoNum iHoNum;
            IHoNum iHoNum2;
            int n3;
            int n4;
            INetElement iNetElement;
            INodeModel iNodeModel;
            INetElement iNetElement2;
            INodeModel iNodeModel2;
            block27: {
                Object object;
                if (this.lapLink != null && this.revLapLink != null) {
                    if (this.lapLink.getSrc() == this.getPrimarySource().getNetElement() && this.lapLink.getDst() == this.getPrimaryDrop().getNetElement()) {
                        return;
                    }
                    this.getNetwork().deleteNetLink(this.lapLink);
                    this.getNetwork().deleteNetLink(this.revLapLink);
                    this.lapLink = null;
                    this.revLapLink = null;
                }
                if (this.dbgOn()) {
                    db.println("adding LAP to network topology");
                }
                if (this.getUniqueNumSrcDstNodes() != 2) {
                    if (this.dbgOn()) {
                        db.println("Warning! number of LAP ends != 2");
                    }
                    return;
                }
                NetCircuitEnd netCircuitEnd = (NetCircuitEnd)this.getPrimarySource();
                iNodeModel2 = netCircuitEnd.getNodeModel();
                if (iNodeModel2 == null) {
                    if (this.dbgOn()) {
                        db.println("Warning! unable to get node model of source ckt. end");
                    }
                    return;
                }
                iNetElement2 = this.getNetwork().findNetElem(iNodeModel2);
                if (iNetElement2 == null) {
                    if (this.dbgOn()) {
                        db.println("Warning! unable to find srcNE");
                    }
                    return;
                }
                NetCircuitNode netCircuitNode = (NetCircuitNode)this.getCircuitNodeFromNE(iNetElement2);
                if (netCircuitNode == null) {
                    if (this.dbgOn()) {
                        db.println("Warning! unable to find source ckt. node");
                    }
                    return;
                }
                NetCircuitDropInfo netCircuitDropInfo = (NetCircuitDropInfo)this.getCktDrops().get(0);
                netCircuitEnd = netCircuitDropInfo.getNetCktEnd();
                iNodeModel = netCircuitEnd.getNodeModel();
                if (iNodeModel == null) {
                    if (this.dbgOn()) {
                        db.println("Warning! unable to get node model of destn. ckt. end");
                    }
                    return;
                }
                iNetElement = this.getNetwork().findNetElem(iNodeModel);
                if (iNetElement == null) {
                    if (this.dbgOn()) {
                        db.println("Warning! unable to find dstNE");
                    }
                    return;
                }
                NetCircuitNode netCircuitNode2 = (NetCircuitNode)this.getCircuitNodeFromNE(iNetElement);
                if (netCircuitNode2 == null) {
                    if (this.dbgOn()) {
                        db.println("Warning! unable to find destination ckt. node");
                    }
                    return;
                }
                try {
                    n4 = this.getPrimarySource().getEntityIndex();
                    n3 = netCircuitNode2.getTunnelEntityIndex();
                    iHoNum2 = this.getPrimarySource().getHoNum();
                    iHoNum = netCircuitNode2.getLotHo();
                }
                catch (SanityCheckFailed sanityCheckFailed) {
                    if (this.dbgOn()) {
                        db.println("Sanity check failed while getting endpoint information");
                    }
                    return;
                }
                n2 = this.getProtType();
                linkedList2 = new LinkedList<INetElement>();
                Iterator iterator = this.getCircuitNodes().iterator();
                while (iterator.hasNext()) {
                    object = (NetCircuitNode)iterator.next();
                    linkedList2.add(((NetCircuitNode)object).getNetElement());
                    if (!this.dbgOn()) continue;
                    this.debug("Adding a Node to LAPNEs ");
                }
                object = new LinkedList();
                linkedList = new LinkedList<INetLink>();
                n = 0;
                Iterator iterator2 = this.getCircuitSpans().iterator();
                while (iterator2.hasNext()) {
                    NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator2.next();
                    ((LinkedList)object).add(netCircuitSpan.getLink());
                    linkedList.add(netCircuitSpan.getLink().getReverseLink());
                    n += netCircuitSpan.getLink().getCost();
                    if (!this.dbgOn()) continue;
                    this.debug("Adding a span to LAPLinks ");
                }
                linkModel = new LinkModel(iNodeModel2, n4, iHoNum2, iNodeModel, n3, iHoNum, 7, -1, -1, true, true, -1, -1, n2, "", 0, 0, 1, n, 0, 0);
                this.lapLink = (NetLink)NetLinkFactory.createNetLink(this.getNetwork(), linkModel, iNetElement2, iNetElement, iNetElement2.getTopology(), linkedList2, (LinkedList)object, false, true, this);
                try {
                    this.getNetwork().addNetLink(this.lapLink);
                    NetCircuitSplicer.instance().newNetLink(this.lapLink);
                }
                catch (ObjDuplicate objDuplicate) {
                    if (!this.dbgOn()) break block27;
                    db.println("duplicate LO tunnel");
                }
            }
            linkModel = new LinkModel(iNodeModel, n3, iHoNum, iNodeModel2, n4, iHoNum2, 7, -1, -1, true, true, -1, -1, n2, "", 0, 0, 1, n, 0, 0);
            this.revLapLink = (NetLink)NetLinkFactory.createNetLink(this.getNetwork(), linkModel, iNetElement, iNetElement2, iNetElement.getTopology(), linkedList2, linkedList, true, false, this);
            try {
                this.getNetwork().addNetLink(this.revLapLink);
                NetCircuitSplicer.instance().newNetLink(this.revLapLink);
            }
            catch (ObjDuplicate objDuplicate) {
                if (!this.dbgOn()) break block28;
                db.println("duplicate LO tunnel (reverse link)");
            }
        }
        if (this.getSla() != 0) {
            this.lapLink.setSla(this.getSla());
            this.revLapLink.setSla(this.getSla());
        }
    }

    protected void deleteLAPNetLink() {
        if (this.lapLink != null) {
            if (this.dbgOn()) {
                this.debug("Deleting LAP link");
            }
            this.getNetwork().deleteNetLink(this.lapLink);
            this.lapLink = null;
        }
        if (this.revLapLink != null) {
            if (this.dbgOn()) {
                this.debug("Deleting reverse LAP link");
            }
            this.getNetwork().deleteNetLink(this.revLapLink);
            this.revLapLink = null;
        }
    }

    protected boolean setProtType() {
        if (super.setProtType()) {
            if (this.lotLink != null) {
                this.lotLink.setProtectionType(this.getProtType());
                this.lotLink.setPcaRevertMode(this.isNonRevertivePca());
            }
            if (this.revLotLink != null) {
                this.revLotLink.setProtectionType(this.getProtType());
                this.revLotLink.setPcaRevertMode(this.isNonRevertivePca());
            }
            if (this.lapLink != null) {
                if (this.getProtType() == 10) {
                    this.lapLink.setProtectionType(2);
                } else {
                    this.lapLink.setProtectionType(this.getProtType());
                }
                this.lapLink.setPcaRevertMode(this.isNonRevertivePca());
            }
            if (this.revLapLink != null) {
                if (this.getProtType() == 10) {
                    this.revLapLink.setProtectionType(2);
                } else {
                    this.revLapLink.setProtectionType(this.getProtType());
                }
                this.revLapLink.setPcaRevertMode(this.isNonRevertivePca());
            }
            return true;
        }
        return false;
    }

    public synchronized List getEtherCircuitNodes() throws IncorrectCircuitState {
        LinkedList<INetCircuitNode> linkedList = new LinkedList<INetCircuitNode>();
        if (!this.isCircuitRefValid()) {
            throw new IncorrectCircuitState("Circuit already destroyed");
        }
        Iterator iterator = this.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            HoCircuitNode hoCircuitNode;
            INetCircuitNode iNetCircuitNode = (INetCircuitNode)iterator.next();
            if (!(iNetCircuitNode instanceof HoCircuitNode) || !(hoCircuitNode = (HoCircuitNode)iNetCircuitNode).isEtherStitched()) continue;
            linkedList.add(iNetCircuitNode);
        }
        return linkedList;
    }

    public synchronized List getEtherAddDropCircuitNodes() throws IncorrectCircuitState {
        LinkedList<INetCircuitNode> linkedList = new LinkedList<INetCircuitNode>();
        if (!this.isCircuitRefValid()) {
            throw new IncorrectCircuitState("Circuit already destroyed");
        }
        Iterator iterator = this.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            INetCircuitNode iNetCircuitNode = (INetCircuitNode)iterator.next();
            if (!iNetCircuitNode.eligibleForEtherHoDropAdd()) continue;
            linkedList.add(iNetCircuitNode);
        }
        return linkedList;
    }

    protected synchronized void updateCircuitInfo(ICircuitModel iCircuitModel, boolean bl) {
        super.updateCircuitInfo(iCircuitModel, bl);
        if (this.circuitModel() == null) {
            return;
        }
        try {
            this.circuitInfoVlanModels = this.circuitModel().getVlanList();
            VlanSetManager.instance();
            this.circuitInfo.setVlans(VlanSetManager.vlanModelToVlanInfo(this.circuitInfoVlanModels));
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
            if (this.dbgOn()) {
                db.println("updateCircuitInfo: circuitModel object does not exist");
            }
            this.disposeCircuitInfo(true);
            return;
        }
        Iterator iterator = this.getCktDrops().iterator();
        while (iterator.hasNext()) {
            NetCircuitEnd netCircuitEnd = ((NetCircuitDropInfo)iterator.next()).getNetCktEnd();
            if (!this.getCircuitTypeObj().isTunnelCircuitType()) continue;
            INetElement iNetElement = netCircuitEnd.getNetElement();
            if (iNetElement == null) {
                if (this.dbgOn()) {
                    db.println("updateCircuitInfo: Cannot find NE with node id " + netCircuitEnd.getNodeId() + " in network");
                }
                return;
            }
            if (this.getCircuitNodeFromNE(iNetElement) != null) continue;
            NetCircuitWatchDog.instance().reloadConnections(iNetElement);
            if (!this.dbgOn()) continue;
            this.debug("updateCircuitInfo: reloading connections for Tunnel drop");
        }
    }

    public synchronized void sanityCheck() throws SanityCheckFailed {
        if (this.isEthernet() && !this.isBidirectional() && !this.isMonitorCircuit()) {
            throw new SanityCheckFailed("Ethernet circuits must be bidirectional");
        }
        if (this.getCircuitTypeObj().isLAPCircuitType()) {
            try {
                if (this.getPrimarySource().getEntityModel().getPayloadType() == 3 && this.getXmCircuitEnds().isEmpty()) {
                    throw new SanityCheckFailed("Can not provision a LAP on DS3 port unless choose a pair of DS3XM-12 portless ports for circuit path");
                }
            }
            catch (ObjNotFound objNotFound) {
                // empty catch block
            }
        }
        super.sanityCheck();
    }

    public synchronized void provision() throws NoRoute, ConnTypeUnsupported, SanityCheckFailed, CircuitProvError, AnnotatedException {
        super.provision();
        if (this.getCircuitTypeObj().isTunnelCircuitType() && (this.getCktNodeListSize() > 2 || PortGrouping.getInstance().isInCreation())) {
            this.addTunnelNetLink();
        } else if (this.getCircuitTypeObj().isLAPCircuitType()) {
            this.addLAPNetLink();
        }
    }

    protected boolean isTunnelFull(NetCcatCircuit netCcatCircuit) {
        if (this.getState() != 1) {
            return true;
        }
        if (this.lotLink == null) {
            if (this.dbgOn()) {
                db.println("Warning! Active Tunnel does not have a netlink");
            }
            return true;
        }
        if (this.lotLink.getAvailSpan(netCcatCircuit.getCircuitSize(), netCcatCircuit.getCircuitType()) == null) {
            if (this.dbgOn()) {
                db.println("Tunnel is not full");
            }
            return false;
        }
        if (this.dbgOn()) {
            db.println("Tunnel is full");
        }
        return true;
    }

    protected synchronized void lotReuseLoAdits(boolean bl) {
        Iterator iterator = this.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            netCircuitNode.lotReuseLoAdit(bl);
        }
    }

    public synchronized void addNetElement(INetElement iNetElement, RoutePrefs routePrefs) throws IncorrectCircuitState {
        if (this.dbgOn()) {
            db.println("Adding a Network Element to circuit. NE = " + iNetElement.getName());
        }
        if (!this.isCircuitRefValid()) {
            throw new IncorrectCircuitState("Circuit already destroyed");
        }
        if (this.getState() != 1 && this.getState() != 0) {
            throw new IncorrectCircuitState("Circuit should have DISCOVERED or CREATING status when adding a Network Element");
        }
        if (this.getCircuitTypeObj().isTunnelCircuitType() && this.getState() == 1) {
            throw new IncorrectCircuitState("Cannot add a Node to a DISCOVERED Tunnel");
        }
        if (this.getCircuitTypeObj().isLAPCircuitType() && this.getState() == 1) {
            throw new IncorrectCircuitState("Cannot add a Node to a DISCOVERED Low Order Aggregation Circuit");
        }
        if (routePrefs != null) {
            this.setMemberPrefs(routePrefs.getFwdDropPrefs().getFirstMemberGroupPrefs().getMemberPrefs());
        }
        this.setMemberPrefs(routePrefs.getFwdDropPrefs().getFirstMemberGroupPrefs().getMemberPrefs());
        NetCircuitNode netCircuitNode = (NetCircuitNode)this.getCircuitNodeFromNE(iNetElement);
        if (netCircuitNode == null) {
            if (this.getCircuitTypeObj().isEthernetCircuitType() && this.getState() == 1) {
                throw new IncorrectCircuitState("Cannot add a ckt node to a DISCOVERED Ethernet circuit");
            }
            netCircuitNode = this.xmCircuitEnds.length == 0 || this.xmCircuitEnds[0].getNodeId() != iNetElement.getNodeId() ? NetCircuitNodeFactory.createCircuitNode(iNetElement, this) : NetCircuitNodeFactory.createDualConnectionCircuitNode(iNetElement, this.getCircuitTypeObj(), this);
            this.insertCktNode(netCircuitNode);
        } else if (this.getCircuitTypeObj().isEthernetCircuitType() && netCircuitNode.getConnectionType() == 8) {
            throw new IncorrectCircuitState("Node " + iNetElement.getName() + " already exists in Ethernet circuit");
        }
        NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createNodeDrop(this.getCircuitType(), iNetElement);
        NetCircuitDropInfo netCircuitDropInfo = routePrefs == null ? new NetCircuitDropInfo(netCircuitEnd, 2) : (this.getCircuitTypeObj().isLAPCircuitType() ? new NetCircuitDropInfo(netCircuitEnd, this.convertPathProt(routePrefs.getPathProt())) : new NetCircuitDropInfo(netCircuitEnd, 2));
        netCircuitNode.addDropInfo(netCircuitDropInfo);
        this.insertDrop(netCircuitDropInfo);
        if (this.getState() != 0) {
            this.setState(3);
        }
    }

    public synchronized void routeDrop(INetCircuitEnd iNetCircuitEnd, RoutePrefs routePrefs) throws AllocFailed, ObjNotFound, NoRoute, CircuitDropOutstanding, IncorrectCircuitState, SanityCheckFailed, AbstractCmsIOException {
        RoutePrefs routePrefs2;
        block3: {
            routePrefs2 = new RoutePrefs(routePrefs);
            if (this.xmCircuitEnds.length != 0 && !routePrefs2.getRequiredNodes().contains(this.xmCircuitEnds[0].getNetElement()) && this.xmCircuitEnds[0].getNetElement() != this.getPrimarySource().getNetElement() && this.xmCircuitEnds[0].getNetElement() != iNetCircuitEnd.getNetElement()) {
                LinkedList<INetElement> linkedList = new LinkedList<INetElement>();
                linkedList.add(this.xmCircuitEnds[0].getNetElement());
                try {
                    routePrefs2.setReqEntityList(linkedList);
                }
                catch (ObjDuplicate objDuplicate) {
                    if (!this.dbgOn()) break block3;
                    db.println("routeDrop: hit ObjDuplicate exception");
                }
            }
        }
        super.routeDrop(iNetCircuitEnd, routePrefs2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNetElement(INetElement iNetElement) throws ObjNotFound, CannotDeleteLastDrop, IncorrectCircuitState, DeletionError, SanityCheckFailed {
        if (this.dbgOn()) {
            db.println("Deleting Net Element from circuit. Node = " + iNetElement.getName());
        }
        HoCcatCircuit hoCcatCircuit = this;
        synchronized (hoCcatCircuit) {
            block12: {
                NetCircuitNode netCircuitNode = (NetCircuitNode)this.getCircuitNodeFromNE(iNetElement);
                if (netCircuitNode == null) {
                    if (this.dbgOn()) {
                        db.println("Warning! unable to find circuit node");
                    }
                    throw new ObjNotFound("Unable to find the Network Element");
                }
                if (netCircuitNode == this.srcCircuitNode) {
                    if (this.dbgOn()) {
                        db.println("Cannot delete source circuit node");
                    }
                    throw new SanityCheckFailed("Cannot delete Source circuit node");
                }
                if (this.getCircuitTypeObj().isEthernetCircuitType() && netCircuitNode.getDrops().size() > 0) {
                    if (this.dbgOn()) {
                        db.println("Cannot delete Ethernet circuit node with HO drops.");
                    }
                    throw new SanityCheckFailed("Node with drops cannot be deleted. \nPlease delete drops first");
                }
                NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createNodeDrop(this.getCircuitType(), iNetElement);
                try {
                    this.deleteDropCktEnd(netCircuitEnd);
                }
                catch (CircuitDropOutstanding circuitDropOutstanding) {
                    if (!this.dbgOn()) break block12;
                    db.println("deleteNetElement- circuit drop outstanding " + circuitDropOutstanding);
                }
            }
        }
        this.notifyChanged();
    }

    public synchronized void routeNetElement(INetElement iNetElement, RoutePrefs routePrefs) throws SanityCheckFailed, IncorrectCircuitState, CTCUserException, AbstractCmsIOException {
        if (this.dbgOn()) {
            db.println("routeNetElement called for circuit " + this.getCircuitName() + ". NE = " + iNetElement.getName());
        }
        if (!(this.getCircuitTypeObj().isTunnelCircuitType() || this.getCircuitTypeObj().isEthernetCircuitType() || this.getCircuitTypeObj().isLAPCircuitType())) {
            throw new SanityCheckFailed("Cannot add a Network Element to circuits of types other than Ethernet or Tunnel");
        }
        NetCircuitNode netCircuitNode = (NetCircuitNode)this.getCircuitNodeFromNE(iNetElement);
        if (this.getCircuitTypeObj().isEthernetCircuitType() && this.getState() == 1 && netCircuitNode == null) {
            throw new SanityCheckFailed("Automatic routing supported for only the first Network Element of an Ethernet Circuit");
        }
        this.addNetElement(iNetElement, routePrefs);
        if (netCircuitNode != null) {
            return;
        }
        try {
            this.routeCurrentDrop(iNetElement, routePrefs, true);
        }
        catch (NoRoute noRoute) {
            block9: {
                if (this.dbgOn()) {
                    db.println("routeCurrentDrop failed. deleting the net element");
                }
                try {
                    this.deleteNetElement(iNetElement);
                }
                catch (DeletionError deletionError) {
                    if (!this.dbgOn()) break block9;
                    db.println("unable to reverse as deleting routed drop encountered exception " + deletionError.getMessage());
                }
            }
            throw noRoute;
        }
    }

    public synchronized void routeNetElement(INetElement iNetElement, INetElement iNetElement2, RoutePrefs routePrefs) throws SanityCheckFailed, IncorrectCircuitState, CTCUserException, AbstractCmsIOException {
        RoutePrefs routePrefs2 = new RoutePrefs(routePrefs);
        routePrefs2.setDst(iNetElement);
        if (iNetElement.getNodeId() != iNetElement2.getNodeId()) {
            routePrefs2.setSecDst(iNetElement2);
        }
        if (iNetElement.getNodeId() != iNetElement2.getNodeId()) {
            this.addNetElement(iNetElement2, routePrefs2);
        }
        try {
            this.routeNetElement(iNetElement, routePrefs2);
        }
        catch (NoRoute noRoute) {
            block6: {
                try {
                    this.deleteNetElement(iNetElement2);
                }
                catch (DeletionError deletionError) {
                    if (!this.dbgOn()) break block6;
                    db.println("unable to reverse as deleting routed drop encountered exception " + deletionError.getMessage());
                }
            }
            throw noRoute;
        }
    }

    public void assignVlanSet(NetVlanInfo[] netVlanInfoArray) throws IncorrectCircuitState, SanityCheckFailed {
        IVlanModel[] iVlanModelArray = new IVlanModel[netVlanInfoArray.length];
        for (int i = 0; i < netVlanInfoArray.length; ++i) {
            iVlanModelArray[i] = netVlanInfoArray[i].getVlan();
        }
        this.assignVlanSet(iVlanModelArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignVlanSet(IVlanModel[] iVlanModelArray) throws IncorrectCircuitState, SanityCheckFailed {
        if (this.tl1Compatible()) {
            throw new SanityCheckFailed("TL1 compatible circuits cannot have VLANs.");
        }
        HoCcatCircuit hoCcatCircuit = this;
        synchronized (hoCcatCircuit) {
            if (this.getState() != 1 && this.getState() != 0) {
                throw new IncorrectCircuitState("Circuit should be in DISCOVERED or CREATING\nstate while changing VLAN set.");
            }
            if (iVlanModelArray == null || iVlanModelArray.length == 0) {
                iVlanModelArray = new IVlanModel[]{VlanSetManager.instance().defaultVlan()};
            }
            if (this.circuitInfoActive()) {
                HoCircuitEnd hoCircuitEnd;
                int n;
                ICircuitId iCircuitId;
                if (this.dbgOn()) {
                    db.println("assignVlanSet: circuitInfoActive");
                }
                if (HoCcatCircuit.isNullCircuitId(iCircuitId = this.getCircuitId())) {
                    iCircuitId = NetCircuitNode.getConnCircuitId(this.srcCircuitNode.getConn());
                }
                Iterator iterator = this.getCktSources().iterator();
                for (n = 0; n < 2; ++n) {
                    while (iterator.hasNext()) {
                        hoCircuitEnd = (HoCircuitEnd)iterator.next();
                        if (!hoCircuitEnd.isNodeDrop() && !hoCircuitEnd.isEtherP2PCircuitEnd() || hoCircuitEnd.changeVlanSetCheck(iCircuitId, iVlanModelArray)) continue;
                        throw new VlanStpSanityCheckFailed(hoCircuitEnd.getNodeModel());
                    }
                    iterator = this.getDropCktEnds().iterator();
                }
                iterator = this.getCktSources().iterator();
                for (n = 0; n < 2; ++n) {
                    while (iterator.hasNext()) {
                        hoCircuitEnd = (HoCircuitEnd)iterator.next();
                        if (!hoCircuitEnd.isNodeDrop() && !hoCircuitEnd.isEtherP2PCircuitEnd()) continue;
                        hoCircuitEnd.changeVlanSet(iCircuitId, iVlanModelArray);
                    }
                    iterator = this.getDropCktEnds().iterator();
                }
                this.circuitModel().updateVlanList(iVlanModelArray);
            } else {
                if (this.dbgOn()) {
                    db.println("assignVlanSet: !circuitInfoActive");
                }
                VlanSetManager.instance();
                this.circuitInfo.setVlans(VlanSetManager.vlanModelToVlanInfo(iVlanModelArray));
            }
            this.circuitInfoVlanModels = iVlanModelArray;
            this.setChanged();
        }
        this.notifyChanged();
    }

    protected boolean dbgOn() {
        return db.on() || super.dbgOn();
    }

    protected void debug(String string) {
        db.println(string);
    }

    public boolean createWithStpEnabled() {
        return this.createWithStpEnabled;
    }

    public void createWithStpEnabled(boolean bl) {
        this.createWithStpEnabled = bl;
    }

    public boolean isStpEnabled() {
        Iterator iterator = this.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            INetCircuitNode iNetCircuitNode = (INetCircuitNode)iterator.next();
            if (iNetCircuitNode.getSources().size() == 0 && iNetCircuitNode.getDrops().size() == 0 || iNetCircuitNode.getCktNodeStpEnabled()) continue;
            return false;
        }
        return true;
    }

    public List getLoTunnelNodes() {
        LinkedList<NetCircuitNode> linkedList = new LinkedList<NetCircuitNode>();
        Iterator iterator = this.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            if (netCircuitNode instanceof LoTunnelNode) {
                linkedList.add(netCircuitNode);
                continue;
            }
            if (!(netCircuitNode instanceof DualConnectionCircuitNode) || !netCircuitNode.hasAggregation()) continue;
            linkedList.add(((DualConnectionCircuitNode)netCircuitNode).getLoTunnelNode());
        }
        return linkedList;
    }

    public List getXmCircuitEnds() {
        return Arrays.asList(this.xmCircuitEnds);
    }

    public void setXmCircuitEnds(INetCircuitEnd[] iNetCircuitEndArray) {
        if (iNetCircuitEndArray == null) {
            this.unsetXmCircuitEnds();
            return;
        }
        if (iNetCircuitEndArray.length != 2 && this.dbgOn()) {
            db.println("setXmCircuitEnds: circuitEnds.length is not 2");
        }
        if (this.dbgOn()) {
            db.println("setXmCircuitEnds:");
        }
        this.xmCircuitEnds = iNetCircuitEndArray;
        for (int i = 0; i < iNetCircuitEndArray.length; ++i) {
            if (iNetCircuitEndArray[i] == null && this.dbgOn()) {
                db.println("setXmCircuitEnds: circuitEnd[" + i + "]" + " is null");
            }
            HoCircuitEnd hoCircuitEnd = new HoCircuitEnd(iNetCircuitEndArray[i]);
            if (this.dbgOn()) {
                db.println("  " + hoCircuitEnd.prettyString());
            }
            this.xmCircuitEnds[i] = hoCircuitEnd;
        }
        if (this.srcCircuitNode != null && this.srcCircuitNode.getNodeModel().getNodeId() == this.xmCircuitEnds[0].getNodeId() && !this.srcCircuitNode.hasDualConnections()) {
            NetCircuitNode netCircuitNode;
            NetCircuitNode netCircuitNode2 = NetCircuitNodeFactory.createHoCircuitNode(this.srcCircuitNode.getNetElement(), this);
            ((HoCircuitNode)this.srcCircuitNode).setIngressOnXm(true);
            this.srcCircuitNode = netCircuitNode = NetCircuitNodeFactory.createDualConnectionCircuitNode(this.srcCircuitNode, netCircuitNode2);
        }
    }

    public void setXmCircuitEnds(IEntityModel[] iEntityModelArray) {
        if (iEntityModelArray == null && !this.getXmCircuitEnds().isEmpty() && this.getState() == 0) {
            this.unsetXmCircuitEnds();
            return;
        }
        if (iEntityModelArray.length != 2) {
            if (this.dbgOn()) {
                db.println("setXmCircuitEnds: the given entities length incorrect");
            }
            return;
        }
        if (iEntityModelArray[0] == null || iEntityModelArray[1] == null) {
            if (this.dbgOn()) {
                db.println("setXmCircuitEnds: some element in the given entities is null");
            }
            return;
        }
        if (iEntityModelArray[0].getNodeModel().getNodeId() != iEntityModelArray[1].getNodeModel().getNodeId()) {
            if (this.dbgOn()) {
                db.println("setXmCircuitEnds: the two elements in the given entities are not on the same node");
            }
            return;
        }
        INodeModel iNodeModel = iEntityModelArray[0].getNodeModel();
        if (this.dbgOn()) {
            db.println("setXmCircuitEnds: on node " + iNodeModel);
        }
        LinkedList linkedList = new LinkedList();
        INetCircuitEnd[] iNetCircuitEndArray = new INetCircuitEnd[iEntityModelArray.length];
        for (int i = 0; i < iEntityModelArray.length; ++i) {
            linkedList.addAll(this.ncMgr.getAvailPortPaths(iNodeModel, iEntityModelArray[i], this.getCircuitType(), this.getCircuitSize(), this.getConfiguredForwardMemberSize(), new ArrayList()));
            if (linkedList.size() - i != 1) {
                if (this.dbgOn()) {
                    db.println("setXmCircuitEnds: on node " + iNodeModel + " could not derive corresponding net circuit end with given entities[" + i + "]");
                }
                return;
            }
            iNetCircuitEndArray[i] = (INetCircuitEnd)linkedList.get(i);
        }
        this.setXmCircuitEnds(iNetCircuitEndArray);
    }

    protected void unsetXmCircuitEnds() {
        if (!this.getXmCircuitEnds().isEmpty() && this.getState() == 0) {
            if (this.srcCircuitNode != null && this.srcCircuitNode.getNodeModel().getNodeId() == ((INetCircuitEnd)this.getXmCircuitEnds().get(0)).getNodeId() && this.srcCircuitNode.hasDualConnections()) {
                NetCircuitNode netCircuitNode;
                this.srcCircuitNode = netCircuitNode = NetCircuitNodeFactory.createCircuitNode(this.srcCircuitNode.getNetElement(), this);
            }
            this.xmCircuitEnds = new INetCircuitEnd[0];
        }
    }

    public synchronized void addCircuitSpan(INetLinkSpan iNetLinkSpan) {
        NetCircuitNode netCircuitNode;
        boolean bl;
        INetLink iNetLink = iNetLinkSpan.getLink();
        boolean bl2 = bl = this.getPrimarySource().getNodeId() == this.getPrimaryDrop().getNodeId() && this.getSources().size() == 1 && this.getDrops().size() == 1;
        if (this.dbgOn()) {
            db.println("addCircuitSpan " + ((NetLinkSpan)iNetLinkSpan).prettyString() + " to circuit " + HoCcatCircuit.prettyString(this.circuitId));
        }
        if (this.getCircuitSpanFromNetLink(iNetLink) != null) {
            if (this.dbgOn()) {
                db.println("addCircuitSpan: span already in list; ignored");
            }
            return;
        }
        NetCircuitNode netCircuitNode2 = (NetCircuitNode)this.getCircuitNodeFromNE(iNetLink.getSrc());
        NetCircuitNode netCircuitNode3 = (NetCircuitNode)this.getCircuitNodeFromNE(iNetLink.getDst());
        if (this.xmCircuitEnds.length == 0 && !bl || this.xmCircuitEnds.length != 0 && ((NetCircuitDropInfo)this.getDrops().get(0)).getNodeId() == this.xmCircuitEnds[0].getNodeId() || bl && netCircuitNode2 != this.srcCircuitNode && netCircuitNode3 != this.srcCircuitNode) {
            super.addCircuitSpan(iNetLinkSpan);
            return;
        }
        if (netCircuitNode2 == null) {
            netCircuitNode2 = NetCircuitNodeFactory.newNodeForAddSpan(iNetLink.getSrc(), this);
            if (!this.getXmCircuitEnds().isEmpty() && iNetLink.getSrc().getNodeId() == this.xmCircuitEnds[0].getNodeId()) {
                netCircuitNode = NetCircuitNodeFactory.newNodeForAddSpan(iNetLink.getSrc(), this);
                ((HoCircuitNode)netCircuitNode2).setIngressOnXm(true);
                ((HoCircuitNode)netCircuitNode).setIngressOnXm(false);
                netCircuitNode2 = NetCircuitNodeFactory.createDualConnectionCircuitNode(netCircuitNode2, netCircuitNode);
            }
            this.insertCktNode(netCircuitNode2);
        }
        if (netCircuitNode3 == null) {
            netCircuitNode3 = NetCircuitNodeFactory.newNodeForAddSpan(iNetLink.getDst(), this);
            if (!this.getXmCircuitEnds().isEmpty() && iNetLink.getDst().getNodeId() == this.xmCircuitEnds[0].getNodeId()) {
                netCircuitNode = NetCircuitNodeFactory.newNodeForAddSpan(iNetLink.getDst(), this);
                ((HoCircuitNode)netCircuitNode3).setIngressOnXm(true);
                ((HoCircuitNode)netCircuitNode).setIngressOnXm(false);
                netCircuitNode3 = NetCircuitNodeFactory.createDualConnectionCircuitNode(netCircuitNode3, netCircuitNode);
            }
            this.insertCktNode(netCircuitNode3);
        }
        if (bl) {
            if (this.dbgOn()) {
                db.println("addCircuitSpan: to STS around ring circuit");
            }
            if (!this.srcCircuitNode.hasDualConnections()) {
                Object object;
                netCircuitNode = NetCircuitNodeFactory.createHoCircuitNode(this.srcCircuitNode.getNetElement(), this);
                Iterator iterator = this.srcCircuitNode.getDrops().iterator();
                while (iterator.hasNext()) {
                    object = (NetCircuitEnd)iterator.next();
                    this.srcCircuitNode.removeDrop((NetCircuitEnd)object);
                    netCircuitNode.insertDrop((NetCircuitEnd)object);
                }
                this.srcCircuitNode = object = NetCircuitNodeFactory.createDualConnectionCircuitNode(this.srcCircuitNode, netCircuitNode);
                netCircuitNode2 = (NetCircuitNode)this.getCircuitNodeFromNE(iNetLink.getSrc());
                netCircuitNode3 = (NetCircuitNode)this.getCircuitNodeFromNE(iNetLink.getDst());
            }
        }
        NetCircuitSpan netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan(this, (NetLinkSpan)iNetLinkSpan);
        netCircuitSpan.setSrcState(2);
        netCircuitSpan.setDstState(2);
        this.insertCktSpan(netCircuitSpan);
        if (!this.isBidirectional()) {
            if (iNetLinkSpan.getOmni()) {
                netCircuitNode2.addRoutedSpan(netCircuitSpan, eSpanDirection.BIDIRECTIONAL);
                netCircuitNode3.addRoutedSpan(netCircuitSpan, eSpanDirection.BIDIRECTIONAL);
            } else {
                netCircuitNode2.addRoutedSpan(netCircuitSpan, eSpanDirection.ORIGINATING);
                netCircuitNode3.addRoutedSpan(netCircuitSpan, eSpanDirection.TERMINATING);
            }
        } else {
            netCircuitNode2.addRoutedSpan(netCircuitSpan, eSpanDirection.BIDIRECTIONAL);
            netCircuitNode3.addRoutedSpan(netCircuitSpan, eSpanDirection.BIDIRECTIONAL);
        }
    }
}

