/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.Busy;
import cerent.cms.model.CircuitEnd;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.Feature;
import cerent.cms.model.HoPathDefModel;
import cerent.cms.model.ICircuitEnd;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IConnectionModels;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.ILoAditModel;
import cerent.cms.model.ILoDefModel;
import cerent.cms.model.ILoPathInfo;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPoolModel;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.LoDefModel;
import cerent.cms.model.NoMoreLoCapableHo;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.PathInUse;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.topo.INetElement;
import cerent.util.IHoLoNum;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.SDebug;

public class LoCircuitEnd
extends NetCircuitEnd {
    private static SDebug db = new SDebug("LoCircuitEnd");
    private IHoNum aditHoNum;
    private boolean isTl1LapCktEnd;

    public LoCircuitEnd(INodeModel iNodeModel, ICircuitEnd iCircuitEnd) {
        super(iNodeModel, iCircuitEnd);
        this.aditHoNum = null;
        this.isTl1LapCktEnd = false;
    }

    public LoCircuitEnd(INodeModel iNodeModel, IEntityModel iEntityModel, IHoNum iHoNum, ILoNum iLoNum, boolean bl) {
        super(iNodeModel, iEntityModel, iHoNum, iLoNum, bl);
        this.aditHoNum = null;
        this.isTl1LapCktEnd = false;
    }

    public LoCircuitEnd(int n, int n2, IHoNum iHoNum, ILoNum iLoNum, boolean bl) {
        super(n, n2, iHoNum, iLoNum, bl);
        this.aditHoNum = null;
        this.isTl1LapCktEnd = false;
    }

    public LoCircuitEnd(INodeModel iNodeModel, IEntityModel iEntityModel, IHoLoNum iHoLoNum, boolean bl) {
        super(iNodeModel, iEntityModel, iHoLoNum, bl);
        this.aditHoNum = null;
        this.isTl1LapCktEnd = false;
    }

    public LoCircuitEnd(INetElement iNetElement, Object object) {
        int n;
        IEntityModel iEntityModel;
        IHoNum iHoNum = null;
        ILoNum iLoNum = null;
        IHoNum iHoNum2 = null;
        this.isTl1LapCktEnd = false;
        int n2 = 0;
        INodeModel iNodeModel = iNetElement.getNodeModel();
        int n3 = 0;
        int n4 = 0;
        if (object instanceof ILoDefModel) {
            ILoDefModel iLoDefModel = (ILoDefModel)object;
            n2 = NetCircuitNode.getEntityIndexFromLoDef(iNodeModel, iLoDefModel);
            iHoNum = LoDefModel.physicalHo(iLoDefModel);
            iLoNum = iLoDefModel.getLoNum();
            n3 = 4;
            iHoNum2 = iHoNum;
            n4 = Feature.provides((INodeModel)iNodeModel, (Feature)Feature.VCAT) ? (int)iLoDefModel.getPathIdentifier() : 0;
        } else if (this.dbgOn()) {
            this.debug("Warning! LoCircuitEnd constructor unknown object type");
        }
        this.setCircuitEnd(new CircuitEnd(iNodeModel.getNodeId(), n2, iHoNum, iLoNum, false, n4));
        try {
            iEntityModel = this.getEntityModel(n2);
        }
        catch (ObjNotFound objNotFound) {
            iEntityModel = null;
        }
        if (iEntityModel != null && ((n = iEntityModel.getPayloadType()) == 14 || n == 17 || n == 18)) {
            this.setHoNum(null);
            this.setLoNum(null);
        }
        this.setStage(n3);
        this.setAditHoNum(iHoNum2);
    }

    public LoCircuitEnd(INetCircuitEnd iNetCircuitEnd) {
        super(iNetCircuitEnd);
        if (iNetCircuitEnd instanceof LoCircuitEnd) {
            this.setAditHoNum(((LoCircuitEnd)iNetCircuitEnd).aditHoNum);
        } else {
            this.aditHoNum = null;
        }
        this.isTl1LapCktEnd = false;
    }

    public void cleanupLoAditIfOldNe() {
        if (!this.getNodeModel().provides(Feature.TCCU)) {
            this.cleanupLoAdit();
        }
    }

    public void cleanupLoAdit() {
        block12: {
            if (this.getHoNum() != null && this.getLoNum() == null) {
                if (this.dbgOn()) {
                    this.debug("cleanupLoAdit: ERROR-Not an LoCircuitEnd");
                }
                return;
            }
            IPoolModel iPoolModel = this.getHoPool();
            if (iPoolModel == null) {
                if (this.dbgOn()) {
                    this.debug("cleanupLoAdit: ERROR-Pool not found");
                }
                return;
            }
            ILoAditModel iLoAditModel = this.findLoAdit(iPoolModel, this.aditHoNum);
            if (iLoAditModel == null) {
                if (this.dbgOn()) {
                    this.debug("cleanupLoAdit: LoAdit not found for aditHoNum=" + this.aditHoNum + "; Assume deleted");
                }
                return;
            }
            try {
                ICircuitId iCircuitId = iLoAditModel.getCircuitId();
                if (iCircuitId.getUniquePart().getUniqueId() != 0) {
                    return;
                }
                if (this.dbgOn()) {
                    this.debug("Destroying LoAdit on LoCircuitEnd; aditHoNum = " + this.aditHoNum);
                }
                iLoAditModel.localDestroy();
            }
            catch (Busy busy) {
                if (this.dbgOn()) {
                    this.debug("cleaunupLoAdit: LoAdit in use");
                }
            }
            catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                if (!this.dbgOn()) break block12;
                this.debug("cleanupLoAdit: LoAdit object does not exist; Assume deleted");
            }
        }
    }

    public Object getPathDef(short s) throws ObjNotFound, PathInUse, InvalidPath, NoMoreLoCapableHo {
        IPoolModel iPoolModel = this.getHoPool();
        if (iPoolModel == null) {
            throw new ObjNotFound("not found hoPool");
        }
        ILoAditModel iLoAditModel = this.getLoAdit(iPoolModel, s);
        if (iLoAditModel == null) {
            try {
                iLoAditModel = this.createLoAdit(null, iPoolModel);
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (this.dbgOn()) {
                    this.debug("Unable to create LoAdit, Cms IO exception");
                }
                throw new ObjNotFound("Unable to create LoAdit, Cms IO exception");
            }
            if (iLoAditModel == null) {
                if (this.dbgOn()) {
                    this.debug("Unable to create LoAdit");
                }
                throw new ObjNotFound("Unable to creat LoAdit");
            }
        }
        this.setAditHoNum(HoPathDefModel.physicalHo(iLoAditModel.getHo()));
        return new LoDefModel(this.getNodeModel(), iLoAditModel, this.getLoNum(), s, (short)this.getPathIdentifier(), this.getEntityIndex());
    }

    private ILoAditModel getLoAdit(IPoolModel iPoolModel, short s) {
        if (this.getHoNum() != null) {
            return this.findLoAdit(iPoolModel, this.getHoNum());
        }
        INodeModel iNodeModel = this.getNodeModel();
        if (iNodeModel == null) {
            return null;
        }
        ILoAditModel[] iLoAditModelArray = iNodeModel.getConnectionModels().getLoAditsInPool(iPoolModel);
        if (iLoAditModelArray != null) {
            if (this.dbgOn()) {
                this.debug("getLoAdit(): " + iLoAditModelArray.length + " adits in pool for hoNum=" + this.getHoNum());
            }
            for (int i = 0; i < iLoAditModelArray.length; ++i) {
                try {
                    ILoPathInfo[] iLoPathInfoArray;
                    ILoAditModel iLoAditModel = iLoAditModelArray[i];
                    if (iLoAditModel != null && (iLoPathInfoArray = iLoAditModel.getAvailableLos((int)s)).length > 0) {
                        if (this.dbgOn()) {
                            IHoNum iHoNum = HoPathDefModel.physicalHo(iLoAditModel.getHo());
                            this.debug("getLoAdit(): Returning adit for HO number " + iHoNum);
                        }
                        return iLoAditModel;
                    }
                    continue;
                }
                catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    protected void setTl1LapCktEnd() {
        this.isTl1LapCktEnd = true;
    }

    protected boolean isTl1LapCktEnd() {
        return this.isTl1LapCktEnd;
    }

    private ILoAditModel createLoAdit(IPoolModel iPoolModel) throws PathInUse, InvalidPath, NoMoreLoCapableHo {
        IConnectionModels iConnectionModels = this.getNodeModel().getConnectionModels();
        int n = this.getNodeModel().getFramingType();
        short s = CircuitSize.getCircuitSize((int)CircuitSize.getLoTunnelSize((int)n).getEnum()).size2widthOfHoCircuit();
        IHoNum iHoNum = this.getRelativeHoNum(iPoolModel);
        HoPathDefModel hoPathDefModel = new HoPathDefModel(iPoolModel, s, iHoNum, (short)this.getPathIdentifier());
        if (this.dbgOn()) {
            this.debug("createLoAdit for circuit end. HoNum=" + this.getHoNum() + ", relativeHoNum=" + iHoNum + ", adminState=IS_AINS");
        }
        return iConnectionModels.createLoAdit(this.getCircuitId(), (IHoPathDefModel)hoPathDefModel, 3);
    }

    private void setAditHoNum(IHoNum iHoNum) {
        if (this.dbgOn()) {
            this.debug("Setting aditHoNum to " + iHoNum);
        }
        this.aditHoNum = iHoNum;
    }

    public boolean roughlyEquals(LoCircuitEnd loCircuitEnd) {
        int n = loCircuitEnd.getCircuitEnd().getPortNum() - this.getCircuitEnd().getPortNum();
        return loCircuitEnd.getCircuitEnd().getNodeId() == this.getCircuitEnd().getNodeId() && (n == 0 || n == 1 || n == -1) && LoCircuitEnd.areHoLoNumsEqual(loCircuitEnd.getCircuitEnd().getHoLoNum(), this.getCircuitEnd().getHoLoNum());
    }

    public boolean isPreVcatDaytonaCircuitEnd() {
        INodeModel iNodeModel = this.getNodeModel();
        if (iNodeModel != null) {
            if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.VCAT)) {
                return false;
            }
            IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
            if (iEntityTableModel != null) {
                IEntityModel iEntityModel;
                try {
                    iEntityModel = iNodeModel.getEntityTable().getEntityModelByIndex(this.getEntityIndex());
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    iEntityModel = null;
                }
                if (iEntityModel != null) {
                    return iEntityModel.getPayloadType() == 14;
                }
            }
        }
        return false;
    }

    protected boolean dbgOn() {
        return db.on() || super.dbgOn();
    }

    private void debug(String string) {
        db.println(string);
    }
}

