/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.CircuitId;
import cerent.cms.model.ILoAditModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPathDefModel;
import cerent.cms.model.IPoolModel;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.LoDefModel;
import cerent.cms.model.NoMoreLoCapableHo;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.PathInUse;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.topo.INetElement;
import cerent.util.SDebug;

public class LoCircuitSpan
extends NetCircuitSpan {
    private static final SDebug db = new SDebug("LoCircuitSpan");

    public LoCircuitSpan(NetCcatCircuit netCcatCircuit, NetLinkSpan netLinkSpan) {
        super(netCcatCircuit, netLinkSpan);
        if (this.dbgOn()) {
            db.println("LoCircuitSpan object instantiated");
        }
    }

    protected IPathDefModel getPathDef(INetElement iNetElement, short s) throws ObjNotFound, PathInUse, InvalidPath, NoMoreLoCapableHo {
        IPoolModel iPoolModel = this.getHoPool(iNetElement);
        CircuitId circuitId = new CircuitId(iNetElement.getNodeId(), 0);
        INodeModel iNodeModel = iNetElement.getNodeModel();
        if (iPoolModel == null) {
            throw new ObjNotFound("unable to find pool model");
        }
        ILoAditModel iLoAditModel = this.getLoAdit(iNetElement, iPoolModel);
        if (iLoAditModel == null && (iLoAditModel = this.createLoAdit(iNetElement, circuitId, iPoolModel)) == null) {
            if (this.dbgOn()) {
                this.debug("CircuitEnd: unable to create LoAdit");
            }
            throw new ObjNotFound("unable to find pool model");
        }
        LoDefModel loDefModel = null;
        loDefModel = new LoDefModel(iNodeModel, iLoAditModel, this.availSpan.getLoNum(), s, 0, this.getEntityIndex(iNetElement));
        return loDefModel;
    }

    public void dispose(boolean bl) {
        super.dispose(bl);
        if (this.getLink().isLAP()) {
            NetCcatCircuit netCcatCircuit = (NetCcatCircuit)this.getCircuit();
            if (netCcatCircuit.useLAP() == null) {
                if (this.dbgOn()) {
                    this.debug("LoCktSpan:useLAP is null ");
                }
                netCcatCircuit.tl1RemoveLapNode();
                return;
            }
            NetCircuitNode netCircuitNode = (NetCircuitNode)netCcatCircuit.getCircuitNodeFromNE(this.getLink().getSrc());
            if (netCircuitNode != null && netCircuitNode.getConn() == null) {
                netCcatCircuit.destroyLapNode(netCircuitNode);
            }
            if ((netCircuitNode = (NetCircuitNode)netCcatCircuit.getCircuitNodeFromNE(this.getLink().getDst())) != null && netCircuitNode.getConn() == null) {
                netCcatCircuit.destroyLapNode(netCircuitNode);
            }
        }
    }

    private boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    private void debug(String string) {
        db.println(string);
    }
}

