/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.Feature;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.ILoDefModel;
import cerent.cms.model.ILoRollModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IRollModel;
import cerent.cms.model.ModelIndirectObservable;
import cerent.cms.model.NoSuchConnection;
import cerent.cms.ncp.NetCircuitEndFactory;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetRoll;
import cerent.cms.topo.Network;
import cerent.util.IObservable;
import cerent.util.SDebug;

public class LoRoll
extends NetRoll {
    private ILoDefModel rollFromPath;
    private ILoDefModel rollToPath;
    private ILoDefModel rollPath;
    private ILoRollModel rollModel;
    private static SDebug db = new SDebug("LoRoll");

    protected boolean dbgOn() {
        return db.on() || super.dbgOn();
    }

    public LoRoll(INodeModel iNodeModel, ILoRollModel iLoRollModel) {
        block9: {
            try {
                this.node = iNodeModel;
                this.ne = Network.instance().getNetElem(iNodeModel.getNodeId());
                this.rollModel = iLoRollModel;
                this.rollFromPath = iLoRollModel.getRollFromPath();
                this.rollToPath = iLoRollModel.getRollToPath();
                this.rollPath = iLoRollModel.getRollPath();
                this.rollMode = iLoRollModel.getRollMode();
                this.rollCktEnd = NetCircuitEndFactory.createCircuitEndFromConn(this.ne, iLoRollModel.getRollPath());
                this.rollFromCktEnd = NetCircuitEndFactory.createCircuitEndFromConn(this.ne, iLoRollModel.getRollFromPath());
                this.rollToCktEnd = NetCircuitEndFactory.createCircuitEndFromConn(this.ne, iLoRollModel.getRollToPath());
                this.connIndex = iLoRollModel.getConnectionIndex();
                this.conn = iNodeModel.provides(Feature.BNR_CONN_RTRV) ? this.getConnection(iNodeModel, this.connIndex) : this.getConnection(iNodeModel, this.rollPath);
                this.rollCircuitSize = NetCircuitManager.instance().connCircuitSize(this.conn);
                this.circuitRollNumber = iLoRollModel.getCircuitRollNumber();
                this.circuitRollMode = this.circuitRollNumber == 0 ? (short)this.rollMode : iLoRollModel.getCircuitRollMode();
                ModelIndirectObservable.instance().addObserver((IObservable)this.rollModel, this);
                this.isRollRefValid = true;
                this.discoverCircuitInfo();
            }
            catch (Exception exception) {
                this.isRollRefValid = false;
                if (this.rollModel != null) {
                    try {
                        ModelIndirectObservable.instance().deleteObserver((IObservable)this.rollModel, this);
                    }
                    catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                        // empty catch block
                    }
                }
                if (this.rollFromCircuit != null) {
                    this.rollFromCircuit.deleteObserver(this);
                }
                if (this.rollToCircuit != null) {
                    this.rollToCircuit.deleteObserver(this);
                }
                if (this.rfCircuitBirthObserver != null) {
                    NetCircuitManager.instance().deleteObserver(this.rfCircuitBirthObserver);
                }
                if (this.rtCircuitBirthObserver != null) {
                    NetCircuitManager.instance().deleteObserver(this.rtCircuitBirthObserver);
                }
                if (!this.dbgOn()) break block9;
                db.println("Error creating roll");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    protected IConnectionModel getConnection(INodeModel iNodeModel, Object object) throws NoSuchConnection {
        return iNodeModel.getConnectionModels().getLoConnection((ILoDefModel)object);
    }

    protected IConnectionModel getConnection(INodeModel iNodeModel, int n) {
        return iNodeModel.getConnectionModels().findLoConnectionModel(n);
    }

    public IRollModel getRollModel() {
        return this.rollModel;
    }

    public void setRollModel(IRollModel iRollModel) {
        this.rollModel = (ILoRollModel)iRollModel;
        this.setChanged();
    }

    public Object getRollFromPath() {
        return this.rollFromPath;
    }

    public Object getRollToPath() {
        return this.rollToPath;
    }
}

