/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.Busy;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CircuitId;
import cerent.cms.model.ConnectionTypeError;
import cerent.cms.model.Feature;
import cerent.cms.model.FramingType;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IConnectionType;
import cerent.cms.model.IFramingType;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.ILoAditModel;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.NoMoreLoCapableHo;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.PathInUse;
import cerent.cms.ncp.AdminStateProvisioningError;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.HoCcatCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitNodeFactory;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.NetCircuitSplicer;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ncp.eSpanDirection;
import cerent.cms.topo.INetElement;
import cerent.util.EnumStrings;
import cerent.util.IHoNum;
import cerent.util.SDebug;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class LoTunnelNode
extends NetCircuitNode {
    private static final SDebug db = new SDebug("LoTunnelNode");
    private ILoAditModel loAdit;
    private boolean lotReuseLoAdit;

    public LoTunnelNode(INetElement iNetElement, HoCcatCircuit hoCcatCircuit) {
        super(iNetElement, hoCcatCircuit);
        this.cktId = new CircuitId(0, 0);
        this.serviceState = -2;
        this.pathWidth = hoCcatCircuit.getCircuitSizeObj().size2widthOfHoCircuit();
        this.lotReuseLoAdit = false;
    }

    public LoTunnelNode(INetElement iNetElement, HoCcatCircuit hoCcatCircuit, Object object) throws AbstractCmsObjectNotExistException {
        super(iNetElement, hoCcatCircuit, object);
        hoCcatCircuit.setChanged();
        this.pathWidth = hoCcatCircuit.getCircuitSizeObj().size2widthOfHoCircuit();
        this.lotReuseLoAdit = false;
    }

    protected boolean hasAggregation() {
        return true;
    }

    protected boolean updateNumberOfPaths() {
        this.numberOfPaths = 1;
        return false;
    }

    protected void sanityCheckConnModel() {
        if (this.loAdit != null) {
            this.loAdit.inUse();
        }
    }

    protected void handleTl1LoAditDeletion() {
        int n;
        int n2 = n = this.circuit.getCircuitType();
        if (this.dbgOn()) {
            db.println("loAditModel TCCU:  DELETED for cktType" + n + " at node" + this.getName());
        }
        if (!this.circuit.circuitInfoActive()) {
            int n3 = this.getNetElement().getNodeModel().getFramingType();
            IFramingType iFramingType = FramingType.getFramingType((int)n3);
            if (this.circuit.getCircuitTypeObj().isLAPCircuitType()) {
                n2 = iFramingType.getHoCircuitType();
                NetCircuitManager.instance().removeCircuitIfLAP(this.circuit);
                this.circuit.setCircuitType(n2);
            } else if (this.circuit.getCircuitTypeObj().isTunnelCircuitType()) {
                n2 = iFramingType.getAggCircuitType();
                this.circuit.setCircuitType(n2);
                NetCircuitManager.instance().insertCircuitIfLAP(this.circuit);
            }
        }
    }

    protected int getConnTypeFromConnModel() {
        if (this.loAdit != null) {
            return 1;
        }
        return 20;
    }

    protected Object[] getPathsFromConnModel() {
        return new Object[0];
    }

    protected Object[] getConnectionPathDefs() {
        Object[] objectArray = new Object[]{};
        if (this.loAdit != null) {
            objectArray = new Object[]{this.loAdit.getHo()};
        }
        return objectArray;
    }

    protected Object[] getActivePathsFromConnModel() {
        return new Object[0];
    }

    protected int getProtectionOpFromConnModel() {
        return this.protectionOp;
    }

    protected int getReverseProtectionOpFromConnModel() {
        return this.reverseProtectionOp;
    }

    protected void conformToPaths(Object[] objectArray, NetCircuitSplicer netCircuitSplicer) {
        this.numberOfPaths = 1;
        IHoPathDefModel iHoPathDefModel = this.loAdit.getHo();
        this.integratePath(iHoPathDefModel, eSpanDirection.BIDIRECTIONAL, eSpanDirection.TERMINATING, netCircuitSplicer);
    }

    protected int findBiDirectionalConnType() {
        int n;
        int n2 = this.countNumInputs();
        int n3 = n2 + (n = this.countNumOutputs());
        if (n3 == 0 && !this.onXm()) {
            return 20;
        }
        if (n3 > 1) {
            return 20;
        }
        return 1;
    }

    protected boolean onXm() {
        return !this.circuit.getXmCircuitEnds().isEmpty() && ((NetCircuitEnd)this.circuit.getXmCircuitEnds().get(0)).getNodeId() == this.getNodeModel().getNodeId();
    }

    protected boolean validateBiDirectionalConn() {
        int n = this.countNumInputs();
        int n2 = this.countNumOutputs();
        int n3 = n + n2;
        if (this.nodeDrop != null) {
            if (n3 == 1 && this.circuit.getCircuitTypeObj().isTunnelCircuitType()) {
                return true;
            }
            return n2 == 0 && n == 1 && this.circuit.getCircuitTypeObj().isLAPCircuitType();
        }
        return super.validateBiDirectionalConn();
    }

    protected void modifyConnection() throws CircuitProvError {
    }

    /*
     * Unable to fully structure code
     */
    protected void destroyCrossConnection() {
        if (this.loAdit != null) {
            if (!this.lotReuseLoAdit) {
                if (this.dbgOn()) {
                    LoTunnelNode.db.println("destroyCrossConnection(" + this.getName() + "): destroy VtAdit");
                }
                try {
                    this.loAdit.localDestroy();
                }
                catch (Busy var2_1) {
                    if (this.dbgOn()) {
                        LoTunnelNode.db.println("Unable to delete LO Adit for LoTunnel - xBusy");
                    }
                    return;
                }
                catch (AbstractCmsObjectNotExistException var2_2) {
                    if (!this.dbgOn()) ** GOTO lbl20
                    LoTunnelNode.db.println("loAdit already deleted");
                }
            } else {
                if (this.dbgOn()) {
                    LoTunnelNode.db.println("destroySonetConnection(" + this.getName() + "): clear circuitId on LoAdit");
                }
                var1_3 = new CircuitId(this.getNodeModel().getNodeId(), 0);
                this.loAdit.setCircuitId((ICircuitId)var1_3);
            }
        }
lbl20:
        // 6 sources

        this.updateConnectionPathEnds(new LinkedList<E>());
    }

    protected void cleanupLoAdits() {
        Object object;
        if (this.dbgOn()) {
            db.println("Cleanup LO Adits at " + this.getName());
        }
        int n = 0;
        LinkedList linkedList = this.inSpans;
        while (n < 3) {
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                object = (NetCircuitSpan)iterator.next();
                ((NetCircuitSpan)object).cleanupLoAdit(this.getNetElement());
            }
            linkedList = ++n == 1 ? this.outSpans : this.biSpans;
        }
        if (this.onXm()) {
            object = (NetCircuitEnd)this.circuit.getXmCircuitEnds().get(1);
            ((NetCircuitEnd)object).cleanupLoAdit();
        }
    }

    protected int getTunnelEntityIndex() throws SanityCheckFailed {
        if (this.biSpans.size() != 1 && !this.onXm()) {
            if (this.dbgOn()) {
                db.println("Warning! getTunnelEntityIndex: biSpans size != 1 and not on XM");
            }
            throw new SanityCheckFailed("Invalid Tunnel end at " + this.getName());
        }
        if (this.biSpans.size() == 1) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)this.biSpans.getFirst();
            if (this.getNetElement() == netCircuitSpan.getLink().getSrc()) {
                return netCircuitSpan.getLink().getSrcEntityIndex();
            }
            return netCircuitSpan.getLink().getDstEntityIndex();
        }
        NetCircuitEnd netCircuitEnd = (NetCircuitEnd)this.circuit.getXmCircuitEnds().get(1);
        return netCircuitEnd.getEntityIndex();
    }

    public IHoNum getLotHo() throws SanityCheckFailed {
        if (this.biSpans.size() != 1 && !this.onXm()) {
            if (this.dbgOn()) {
                db.println("Warning! getLoTunnelHo: biSpans size != 1 and not on XM");
            }
            throw new SanityCheckFailed("Invalid Tunnel end at " + this.getName() + ". Unable to get HO number");
        }
        if (this.biSpans.size() == 1) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)this.biSpans.getFirst();
            return netCircuitSpan.getHoNum(this.getNetElement());
        }
        NetCircuitEnd netCircuitEnd = (NetCircuitEnd)this.circuit.getXmCircuitEnds().get(1);
        return netCircuitEnd.getHoNum();
    }

    protected void createConnection() throws CircuitProvError {
        this.setConnectionType(this.findConnType());
        if (this.getConnectionType() == 20) {
            if (this.dbgOn()) {
                db.println("Warning! createConnection at " + this.getName() + " connection type is unknown");
            }
            throw new CircuitProvError("Invalid connection type at " + this.getName());
        }
        this.cktId = this.circuit.getCircuitId();
        if (this.dbgOn()) {
            db.println("createConnection: connection type " + EnumStrings.getString((Class)IConnectionType.class, (int)this.getConnectionType()) + " ckt Id: " + Integer.toHexString(this.cktId.getNodeId()) + ":" + this.cktId.getUniquePart().getUniqueId() + " at Node " + this.getName());
        }
        try {
            this.createLotConnection(this.cktId);
        }
        catch (CTCUserException cTCUserException) {
            if (this.dbgOn()) {
                db.println("Exception while creating LO adit at " + this.getName());
                SDebug.printStackTrace((Throwable)cTCUserException);
            }
            String string = "Unable to create lo connection at " + this.getName();
            if (cTCUserException instanceof NoMoreLoCapableHo) {
                string = string + "\n" + this.getNoLoCapableHoMessage() + " at " + this.getName();
            } else if (cTCUserException instanceof PathInUse) {
                string = string + "\nPath already in use";
            }
            throw new CircuitProvError(string);
        }
        catch (AdminStateProvisioningError adminStateProvisioningError) {
            if (this.dbgOn()) {
                db.println("Exception while creating LO adit at " + this.getName());
                SDebug.printStackTrace((Throwable)adminStateProvisioningError);
            }
            String string = "Unable to create connection at " + this.getName();
            string = string + "\nInvalid admin state";
            throw new CircuitProvError(string);
        }
        if (this.loAdit == null) {
            if (this.dbgOn()) {
                db.println("Connection Models returned NULL LO adit reference");
            }
            throw new CircuitProvError("Error while creating connection object at " + this.getName());
        }
        this.addConnectionObserver();
        this.setState(1);
        this.setCreateStage(3);
        this.numberOfPaths = this.countNumInputs() + this.countNumOutputs() + this.countNumOmniSpans();
        this.updateConnectionPathEnds(this.getPathEndsFromPathDefs(this.getConnectionPathDefs()));
    }

    protected void lotReuseLoAdit(boolean bl) {
        if (this.nodeDrop != null) {
            this.lotReuseLoAdit = bl;
            if (this.dbgOn()) {
                db.println("lotReuseLoAdit= " + (bl ? "true" : "false") + " at " + this.getName());
            }
            return;
        }
    }

    protected void createLotConnection(ICircuitId iCircuitId) throws CircuitProvError, ConnectionTypeError, ObjNotFound, PathInUse, InvalidPath, NoMoreLoCapableHo, AdminStateProvisioningError {
        NetCircuitSpan netCircuitSpan = null;
        if (!this.biSpans.isEmpty()) {
            netCircuitSpan = (NetCircuitSpan)this.biSpans.getFirst();
        }
        if (netCircuitSpan == null && !this.onXm()) {
            if (this.dbgOn()) {
                db.println("createLotConnection: null span and not on ds3Xm");
            }
            throw new CircuitProvError("Invalid tunnel/aggregation at " + this.getName());
        }
        if (this.dbgOn()) {
            db.println("Creating LOT connection at " + this.getName());
        }
        if (!this.lotReuseLoAdit) {
            if (this.dbgOn()) {
                db.println("Creating new LoAdit at " + this.getName());
            }
            if (netCircuitSpan != null) {
                this.loAdit = this.createLotConnOnNE(netCircuitSpan, iCircuitId);
            } else {
                NetCircuitEnd netCircuitEnd = (NetCircuitEnd)this.circuit.getXmCircuitEnds().get(1);
                this.loAdit = this.createLotConnOnNE(netCircuitEnd);
            }
        } else {
            this.loAdit = netCircuitSpan.getLoAdit(this.getNetElement());
            if (this.loAdit == null) {
                if (this.dbgOn()) {
                    db.println("createTunnelConnection: null loAdit");
                }
                throw new CircuitProvError("Invalid Tunnel at " + this.getName());
            }
            if (this.dbgOn()) {
                db.println("Setting circuitId on LoAdit");
            }
            this.loAdit.setCircuitId(iCircuitId);
        }
    }

    protected ILoAditModel createLotConnOnNE(NetCircuitSpan netCircuitSpan, ICircuitId iCircuitId) throws CircuitProvError, ConnectionTypeError, ObjNotFound, PathInUse, InvalidPath, NoMoreLoCapableHo, AdminStateProvisioningError {
        INetElement iNetElement = this.getNetElement();
        if (!iNetElement.getNodeModel().provides(Feature.ENHANCED_STATE_MODEL) && 0 != this.adminState) {
            db.info("PreOdin node " + this.getName() + " does not support admin state provisioning");
            throw new AdminStateProvisioningError("Node " + this.getName() + " does not support circuit state " + this.translateAdminState(this.adminState) + ": use " + this.translateAdminState(0));
        }
        ILoAditModel iLoAditModel = netCircuitSpan.createLoAdit(this.getNetElement(), iCircuitId);
        return iLoAditModel;
    }

    protected ILoAditModel createLotConnOnNE(NetCircuitEnd netCircuitEnd) throws PathInUse, InvalidPath, NoMoreLoCapableHo {
        ILoAditModel iLoAditModel = netCircuitEnd.createLoAdit(this.circuit.getCircuitId());
        return iLoAditModel;
    }

    public List getMonitorSourcePoints() throws SanityCheckFailed {
        if (this.dbgOn()) {
            db.println("getMonitorSourcePoints @ " + this.getName());
        }
        if (this.dbgOn()) {
            db.println("getMonitorSourcePoints: illegal call for Tunnel");
        }
        throw new SanityCheckFailed("Connection not found at " + this.getName());
    }

    protected void destroySanityCheck() throws SanityCheckFailed {
        if (this.loAdit == null) {
            return;
        }
        if (!this.hasConnection()) {
            return;
        }
        if (this.loAdit.inUse()) {
            throw new SanityCheckFailed("Tunnel or aggregation circuit is in use");
        }
    }

    protected void deleteNodeDrop() {
        if (this.dbgOn()) {
            db.println("Warning! cannot delete node drop for Tunnel");
        }
    }

    protected NetCircuitSpan findNextBiSpanOnRoute(NetCircuitSpan netCircuitSpan) {
        return null;
    }

    protected void deleteDrop(INetCircuitEnd iNetCircuitEnd) throws DeletionError, SanityCheckFailed {
        super.deleteDrop(iNetCircuitEnd);
    }

    public void setConnectionCircuitId(ICircuitId iCircuitId) {
        if (this.dbgOn()) {
            db.println("setting the connection circuit Id at " + this.getName() + " to " + NetCircuit.prettyString(iCircuitId));
        }
        if (this.loAdit != null) {
            this.loAdit.setCircuitId(iCircuitId);
            this.cktId = iCircuitId;
        }
    }

    public ICircuitId getConnectionCircuitId() {
        if (this.loAdit != null) {
            return this.loAdit.getCircuitId();
        }
        if (this.dbgOn()) {
            db.println("getConnectionCircuitId @ Node " + this.getName() + " with connection object deleted");
        }
        return null;
    }

    protected boolean isAnyChangeInUpsrSelector() {
        return false;
    }

    protected void markRoutedUpsrRing() {
    }

    protected void markRoutedUpsrSpan(NetCircuitSpan netCircuitSpan) {
    }

    protected void markSelectorInputPaths() {
    }

    protected boolean completeCheck() {
        return this.totalSpans() == 1 && this.biSpans().size() == 1;
    }

    public IConnectionModel getConn() {
        return this.loAdit;
    }

    protected void setConn(IConnectionModel iConnectionModel) {
        this.loAdit = (ILoAditModel)iConnectionModel;
    }

    protected void addRoutedSpan(NetCircuitSpan netCircuitSpan, eSpanDirection eSpanDirection2) {
        if (this.biSpans.isEmpty()) {
            this.addSpan(netCircuitSpan, eSpanDirection2);
            if (this.getState() != 0) {
                this.setState(3);
            }
        } else {
            boolean bl = false;
            if (this.circuit.srcCircuitNode.equals(this)) {
                bl = true;
            }
            NetCircuitNode netCircuitNode = NetCircuitNodeFactory.createCircuitNode(this.getNetElement(), (NetCcatCircuit)this.getCircuit());
            netCircuitNode.addRoutedSpan(netCircuitSpan, eSpanDirection2);
            netCircuitNode.insertDrop(this.getNodeDrop());
            NetCircuitNodeFactory.createDualConnectionCircuitNode((NetCircuitNode)this, netCircuitNode);
            if (bl) {
                this.circuit.setSrcCircuitNode();
            }
        }
    }

    protected boolean dbgOn() {
        return db.on() || super.dbgOn();
    }

    private void debug(String string) {
        db.println(string);
    }
}

