/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AllocFailed;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CannotDeleteLastDrop;
import cerent.cms.model.CircuitId;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.Feature;
import cerent.cms.model.FramingType;
import cerent.cms.model.HoUpsrAttributes;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IFramingType;
import cerent.cms.model.IHoUpsrAttributes;
import cerent.cms.model.ILoAditModel;
import cerent.cms.model.INetProtectionType;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOchTrailAditModel;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.IVlanModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NetAdminState;
import cerent.cms.model.NetProtectionType;
import cerent.cms.model.NetServiceState;
import cerent.cms.model.ObjNotFound;
import cerent.cms.ncp.AdminStateProvisioningError;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.CircuitDropOutstanding;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.ConnTypeUnsupported;
import cerent.cms.ncp.Connection;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.DualConnectionCircuitNode;
import cerent.cms.ncp.HoCcatCircuit;
import cerent.cms.ncp.HoCircuitNode;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.INetCircuitOperation;
import cerent.cms.ncp.INetCircuitSpan;
import cerent.cms.ncp.INetCircuitState;
import cerent.cms.ncp.INetVcatGroup;
import cerent.cms.ncp.INetVcatTermination;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ncp.LoCcatCircuit;
import cerent.cms.ncp.LoTunnelNode;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitCreateWorker;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitEndFactory;
import cerent.cms.ncp.NetCircuitFactory;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitNodeFactory;
import cerent.cms.ncp.NetCircuitPath;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.NetCircuitSpanFactory;
import cerent.cms.ncp.NetCircuitWatchDog;
import cerent.cms.ncp.NetVcatGroup;
import cerent.cms.ncp.NetVcatTermination;
import cerent.cms.ncp.NodeRoutingDirection;
import cerent.cms.ncp.OchTrailTunnelNode;
import cerent.cms.ncp.OchncCircuit;
import cerent.cms.ncp.OchncCircuitNode;
import cerent.cms.ncp.RouteValidator;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ncp.SelectorConnection;
import cerent.cms.ncp.SpliceListenerEntry;
import cerent.cms.ncp.UpdateEventCollector;
import cerent.cms.ncp.eSpanDirection;
import cerent.cms.route.DriNodePair;
import cerent.cms.route.DriNodes;
import cerent.cms.route.INetLinkSpan;
import cerent.cms.route.MemberPrefs;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.route.NoRoute;
import cerent.cms.route.RoutePrefs;
import cerent.cms.route.Spt;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetElemComparator;
import cerent.cms.topo.NetLink;
import cerent.cms.topo.NetLinkComparator;
import cerent.cms.vlan.NetVlanInfo;
import cerent.util.AnnotatedException;
import cerent.util.EnumStrings;
import cerent.util.HoLoComparator;
import cerent.util.HoLoFactory;
import cerent.util.ILoNum;
import cerent.util.IObservable;
import cerent.util.SDHTDMTerminology;
import cerent.util.SDebug;
import cerent.util.SONETTDMTerminology;
import cerent.util.job.IJobControl;
import cerent.util.job.IJobGroupListener;
import cerent.util.job.JobController;
import cerent.util.job.JobGroup;
import cerent.util.job.JobStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public abstract class NetCcatCircuit
extends NetCircuit
implements IJobGroupListener {
    protected static final HoLoComparator holoComp = HoLoComparator.instance();
    protected NetCircuitNode srcCircuitNode = null;
    protected NetCircuitNode secSrcCircuitNode = null;
    private Map cktNodeList;
    private Map cktSpanList;
    protected MemberPrefs memberPrefs;
    private boolean createDone = false;
    private Object threadWaitObject = new Object();
    protected IRevertiveBehavior upsrReversion;
    protected short upsrSfBerLevel;
    protected short upsrSdBerLevel;
    protected boolean upsrSwitchOnPdip;
    private boolean go_return_routing;
    protected boolean inCircuitMerge = false;
    private NetVcatGroup vcatGroup;
    private Map memberStatusMap;
    private List prevDropList;
    private boolean isInGroup = false;
    private boolean isDri = false;
    protected boolean driConfigurationError = false;
    private static int[][] bidirTable = new int[][]{{1, 1, 1, 1, 1}, {1, 1, 1, 1, 2}, {1, 2, 1, 1, 1}, {1, 2, 1, 1, 2}, {1, 2, 1, 2, 2}, {1, 2, 1, 2, 3}, {2, 1, 1, 1, 1}, {2, 1, 1, 1, 2}, {2, 1, 2, 1, 2}, {2, 1, 2, 1, 3}, {2, 2, 1, 1, 1}, {2, 2, 1, 1, 2}, {2, 2, 1, 2, 2}, {2, 2, 1, 2, 3}, {2, 2, 2, 1, 2}, {2, 2, 2, 1, 3}, {2, 2, 2, 2, 2}};
    private static final SDebug db = new SDebug("NetCcatCircuit");

    protected boolean dbgOn() {
        return db.on() || super.dbgOn();
    }

    protected void debug(String string) {
        db.println(string);
    }

    protected NetCcatCircuit(CircuitCreatInfo circuitCreatInfo) {
        super(circuitCreatInfo);
        this.cktNodeList = Collections.synchronizedMap(new TreeMap(new NetElemComparator()));
        this.cktSpanList = Collections.synchronizedMap(new TreeMap(new NetLinkComparator()));
        this.go_return_routing = circuitCreatInfo.getTrafficDir();
    }

    protected NetCcatCircuit(CircuitCreatInfo circuitCreatInfo, INetCircuitEnd iNetCircuitEnd, INetCircuitEnd iNetCircuitEnd2) {
        this(circuitCreatInfo);
        this.setCktOperation(1);
        this.addSources(circuitCreatInfo, iNetCircuitEnd, iNetCircuitEnd2);
    }

    protected void addSources(CircuitCreatInfo circuitCreatInfo, INetCircuitEnd iNetCircuitEnd, INetCircuitEnd iNetCircuitEnd2) {
        NetCircuitEnd netCircuitEnd = null;
        NetCircuitEnd netCircuitEnd2 = null;
        INetElement iNetElement = null;
        INetElement iNetElement2 = null;
        if (iNetCircuitEnd != null) {
            netCircuitEnd = NetCircuitEndFactory.createCircuitEnd(circuitCreatInfo.type(), iNetCircuitEnd);
            this.circuitInfo.setSrcPoint(netCircuitEnd.getCircuitEnd());
            this.insertSource(netCircuitEnd);
            try {
                iNetElement = netCircuitEnd.getNetElement();
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                db.println("i/o exception in NetCcatCircuit/findNetElem");
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
                iNetElement = null;
            }
        }
        if (iNetCircuitEnd2 != null) {
            netCircuitEnd2 = NetCircuitEndFactory.createCircuitEnd(circuitCreatInfo.type(), iNetCircuitEnd2);
            this.circuitInfo.setSecSrcPoint(netCircuitEnd2.getCircuitEnd());
            this.insertSource(netCircuitEnd2);
        }
        if (iNetElement == null) {
            if (this.dbgOn()) {
                db.println("Warning: unable to find Net Element in NetCcatCircuit()");
            }
            return;
        }
        this.srcCircuitNode = NetCircuitNodeFactory.createCircuitNode(iNetElement, this);
        this.setSrcNodeModel(iNetElement.getNodeModel());
        if (netCircuitEnd != null) {
            this.srcCircuitNode.addSource(netCircuitEnd);
            this.insertCktNode(this.srcCircuitNode);
        }
        if (netCircuitEnd2 == null) {
            return;
        }
        if (netCircuitEnd2.getNodeId() != netCircuitEnd.getNodeId()) {
            iNetElement2 = netCircuitEnd2.getNetElement();
            this.secSrcCircuitNode = NetCircuitNodeFactory.createCircuitNode(iNetElement2, this);
            this.secSrcCircuitNode.addSource(netCircuitEnd2);
            this.insertCktNode(this.secSrcCircuitNode);
        } else {
            this.srcCircuitNode.addSource(netCircuitEnd2);
        }
    }

    protected NetCcatCircuit(CircuitCreatInfo circuitCreatInfo, INetElement iNetElement, Object object) {
        this(circuitCreatInfo);
        ICircuitId iCircuitId = NetCircuitNode.getConnCircuitId(object);
        if (iCircuitId == null) {
            if (this.dbgOn()) {
                db.println("Warning! Unable to get circuit ID");
            }
            return;
        }
        this.updateCircuitId(iCircuitId);
        NetCircuitNode netCircuitNode = NetCircuitNodeFactory.createCircuitNode(iNetElement, this, object);
        if (netCircuitNode.getConnectionType() == 9) {
            this.circuitInfo.setMonitor(true);
        }
        this.insertCktNode(netCircuitNode);
        this.initSourcesAndDrops();
        if (!NetCcatCircuit.isNullCircuitId(iCircuitId)) {
            this.initState(4);
        } else {
            if (this.inRoll()) {
                this.initState(8);
            } else if (this.inConversion()) {
                this.initState(11);
            } else {
                this.initState(6);
            }
            this.tl1CircuitCompleteCheck();
        }
        this.serviceState = this.deriveServiceState();
        this.setProtType();
    }

    public boolean getDri() {
        return this.isDri;
    }

    public void setDri(boolean bl) {
        this.isDri = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(String string) throws CircuitProvError {
        NetCcatCircuit netCcatCircuit = this;
        synchronized (netCcatCircuit) {
            if (string.trim().equals("")) {
                throw new CircuitProvError("Circuit name cannot be blank");
            }
            this.renameCircuit(string);
            this.renameConnections(string);
        }
        this.notifyChanged();
    }

    protected void renameConnections(String string) throws CircuitProvError {
        if (this.getCktNodeListSize() != 0) {
            Iterator iterator = this.cktNodeList.values().iterator();
            while (iterator.hasNext()) {
                NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
                netCircuitNode.setConnName(string);
            }
        }
    }

    protected String getCircuitNameFromSrcNode() {
        String string = "";
        if (this.getCircuitTypeObj().isEthernetCircuitType()) {
            if (this.circuitInfoActive()) {
                return this.getCircuitName();
            }
            return "Unknown";
        }
        NetCircuitNode netCircuitNode = (NetCircuitNode)this.getSrcCircuitNode();
        if (netCircuitNode != null) {
            if (!(!netCircuitNode.isNodeDrop() || netCircuitNode instanceof DualConnectionCircuitNode && this.getCircuitTypeObj().isOchTrailTunnelCircuitType())) {
                return this.getCircuitName();
            }
            if (netCircuitNode.getNodeModel().provides(Feature.TCCU)) {
                NetCircuitNode netCircuitNode2;
                NetCircuitNode netCircuitNode3;
                NetCcatCircuit netCcatCircuit;
                if (netCircuitNode.getConn() != null) {
                    string = netCircuitNode.getConnName();
                } else if (this instanceof LoCcatCircuit && (netCcatCircuit = ((LoCcatCircuit)this).useLAPOnSource()) != null && (netCircuitNode3 = (NetCircuitNode)this.getCircuitNodeFromNE((netCircuitNode2 = (NetCircuitNode)netCcatCircuit.getLoTunnelNodes().get(0)).getNetElement())) != null) {
                    string = netCircuitNode3.getConnName();
                }
            }
        }
        if (string == null || string.equals("")) {
            string = this.circuitInfoActive() ? this.getCircuitName() : "Unknown";
        }
        if (this.dbgOn()) {
            this.debug("getCircuitNameFromSrcNode() returns \"" + string + "\"");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAdminState(int n) throws IncorrectCircuitState, AdminStateProvisioningError {
        if (!this.isCircuitRefValid()) {
            throw new IncorrectCircuitState("Invalid Circuit Reference");
        }
        if (this.state != 1 && this.state != 5 && this.state != 4 && this.state != 6) {
            throw new IncorrectCircuitState("Circuit status does not allow circuit state provisioning");
        }
        String string = this.validateAdminState(n);
        if (string != null) {
            db.severe("Validate admin state failed for requested admin state" + this.translateAdminState(n));
            throw new AdminStateProvisioningError(string);
        }
        NetCcatCircuit netCcatCircuit = this;
        synchronized (netCcatCircuit) {
            int n2;
            NetCircuitNode netCircuitNode;
            String string2 = "";
            Iterator iterator = this.getCircuitNodes().iterator();
            while (iterator.hasNext()) {
                netCircuitNode = (NetCircuitNode)iterator.next();
                n2 = n;
                if (this.isMemberOfVcat() && n == 4 && netCircuitNode.getNodeModel() != this.getPrimarySource().getNodeModel() && netCircuitNode.getNodeModel() != this.getPrimaryDrop().getNodeModel()) {
                    n2 = 2;
                }
                try {
                    netCircuitNode.setConnAdminState(n2);
                }
                catch (AdminStateProvisioningError adminStateProvisioningError) {
                    if (this.dbgOn()) {
                        db.println("Unable to set admin state on " + netCircuitNode.getName() + ": " + adminStateProvisioningError);
                        SDebug.printStackTrace((Throwable)adminStateProvisioningError);
                    }
                    string2 = adminStateProvisioningError.getMessage();
                    break;
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                    if (this.dbgOn()) {
                        db.println("Unable to set admin state on " + netCircuitNode.getName() + ": " + exception);
                    }
                    string2 = "Failed to set circuit state on " + netCircuitNode.getName();
                    break;
                }
            }
            String string3 = "Unable to provision circuit state";
            if (string2.length() > 0) {
                if (this.dbgOn()) {
                    db.println("invoking revertAdminState");
                }
                try {
                    this.revertAdminState();
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                    if (this.dbgOn()) {
                        db.println("Unable to revert admin state: " + exception);
                    }
                    string3 = string3 + " or revert to previous state";
                }
                this.setChanged();
                this.notifyChanged();
                throw new AdminStateProvisioningError(string3 + ":\n" + string2);
            }
            iterator = this.getCircuitNodes().iterator();
            while (iterator.hasNext()) {
                netCircuitNode = (NetCircuitNode)iterator.next();
                n2 = n;
                if (this.isMemberOfVcat() && n == 4 && netCircuitNode.getNodeModel() != this.getPrimarySource().getNodeModel() && netCircuitNode.getNodeModel() != this.getPrimaryDrop().getNodeModel()) {
                    n2 = 2;
                }
                netCircuitNode.setAdminState(n2);
                netCircuitNode.setState(2);
            }
            this.adminState = n;
            if (this.dbgOn()) {
                this.debug("setAdminState(): new admin state is " + this.translateAdminState(this.adminState));
            }
            this.setChanged();
        }
        this.notifyChanged();
    }

    private synchronized String validateAdminState(int n) throws AdminStateProvisioningError {
        Iterator iterator = this.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            String string;
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            int n2 = n;
            if (this.isMemberOfVcat() && n == 4 && netCircuitNode.getNodeModel() != this.getPrimarySource().getNodeModel() && netCircuitNode.getNodeModel() != this.getPrimaryDrop().getNodeModel()) {
                n2 = 2;
            }
            if ((string = netCircuitNode.validateConnAdminState(n2)) == null) continue;
            return string + netCircuitNode.getName();
        }
        return null;
    }

    private void deriveAdminState() {
        int n = -1;
        List list = this.getCircuitNodes();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            int n2 = netCircuitNode.getAdminState();
            if (NetCcatCircuit.getAdminStatePriority(n2) <= NetCcatCircuit.getAdminStatePriority(n)) continue;
            n = n2;
        }
        if (n != this.adminState) {
            if (this.dbgOn()) {
                this.debug("deriveAdminState(" + this.getCircuitName() + "): " + this.translateAdminState(this.adminState) + " --> " + this.translateAdminState(n));
            }
            this.adminState = n;
        }
    }

    public static int getAdminStatePriority(int n) {
        int n2;
        switch (n) {
            case 4: {
                n2 = 5;
                break;
            }
            case 0: {
                n2 = 4;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case -1: {
                n2 = 0;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDiscoveredConnection(INetElement iNetElement, Object object) {
        NetCcatCircuit netCcatCircuit = this;
        synchronized (netCcatCircuit) {
            if (!this.isCircuitRefValid()) {
                return;
            }
            NetCircuitNode netCircuitNode = (NetCircuitNode)this.getCircuitNodeFromNE(iNetElement);
            if (netCircuitNode != null) {
                if (netCircuitNode.deletedEventPending()) {
                    if (this.dbgOn()) {
                        this.debug("Processing connection delete event for " + this.getCircuitName() + "(" + NetCcatCircuit.prettyString(this.circuitId) + ")" + " at " + iNetElement.getName());
                    }
                    this.disposeConnection(netCircuitNode, false);
                } else if (netCircuitNode instanceof DualConnectionCircuitNode) {
                    if (netCircuitNode.getConn().equals(object) || ((DualConnectionCircuitNode)netCircuitNode).getSecConn().equals(object)) {
                        return;
                    }
                    if (this.dbgOn()) {
                        this.debug("something has gone wrong on this DualConnectionCircuitNode " + netCircuitNode.getName());
                    }
                } else if (!netCircuitNode.getConn().equals(object) && (this instanceof HoCcatCircuit || this instanceof OchncCircuit)) {
                    if (this.dbgOn()) {
                        this.debug("Adding discovered connection (same NE) to " + this.getCircuitName() + "(" + NetCcatCircuit.prettyString(this.circuitId) + ")" + " at " + iNetElement.getName());
                    }
                    this.checkForTunnelCktPromotion(object);
                    netCircuitNode = NetCircuitNodeFactory.createDualConnectionCircuitNode(netCircuitNode, object);
                    this.completeCheck();
                } else if (this.getState() != 0) {
                    netCircuitNode.setConnection(object);
                    return;
                }
            }
            if ((netCircuitNode = (NetCircuitNode)this.getCircuitNodeFromNE(iNetElement)) == null) {
                if (this.dbgOn()) {
                    this.debug("Adding discovered connection to " + this.getCircuitName() + "(" + NetCcatCircuit.prettyString(this.circuitId) + ")" + " at " + iNetElement.getName());
                }
                this.checkForTunnelCktPromotion(object);
                netCircuitNode = NetCircuitNodeFactory.createCircuitNode(iNetElement, this, object);
                if (netCircuitNode != null) {
                    this.insertCktNode(netCircuitNode);
                    this.completeCheck();
                }
            }
        }
        if (NetCircuitWatchDog.instance().dumpDb.isEventLogEnabled()) {
            UpdateEventCollector.instance().LogEvent("NCcatCkt::addDiscoveredConn : ckt: " + this.getCircuitName() + "node: " + iNetElement.getName());
        }
        this.notifyChanged();
    }

    private void checkForTunnelCktPromotion(Object object) {
        if (this.circuitInfoActive()) {
            return;
        }
        if (!(object instanceof ILoAditModel) && !(object instanceof IOchTrailAditModel)) {
            return;
        }
        IConnectionModel iConnectionModel = (IConnectionModel)object;
        int n = iConnectionModel.getNodeModel().getFramingType();
        IFramingType iFramingType = FramingType.getFramingType((int)n);
        ICircuitType iCircuitType = this.getCircuitTypeObj();
        if (iCircuitType.isHoCircuitType()) {
            if (this.dbgOn()) {
                this.debug("Promoting HO circuit to LAP");
            }
            this.setCircuitType(iFramingType.getAggCircuitType());
        } else if (iCircuitType.isOchncType()) {
            if (this.dbgOn()) {
                this.debug("Promoting OCHNC circuit to OCH-Trail Tunnel");
            }
            this.setCircuitType(15);
        } else if (iCircuitType.isLAPCircuitType()) {
            if (this.dbgOn()) {
                this.debug("Promoting LAP circuit to LOT");
            }
            this.setCircuitType(iFramingType.getTunnelCircuitType());
        }
    }

    protected synchronized void disposeConnection(NetCircuitNode netCircuitNode, boolean bl) {
        if (netCircuitNode == null) {
            if (this.dbgOn()) {
                db.println("disposeConnection: circuit node not known!");
            }
            return;
        }
        INetElement iNetElement = netCircuitNode.getNetElement();
        NetCircuitNode netCircuitNode2 = null;
        DualConnectionCircuitNode dualConnectionCircuitNode = null;
        boolean bl2 = false;
        NetCircuitNode netCircuitNode3 = (NetCircuitNode)this.getCircuitNodeFromNE(iNetElement);
        if (netCircuitNode3 != null) {
            bl2 = netCircuitNode3.hasDualConnections();
        }
        if (bl2) {
            dualConnectionCircuitNode = (DualConnectionCircuitNode)netCircuitNode3;
            netCircuitNode2 = dualConnectionCircuitNode.getOtherNode(netCircuitNode);
        }
        if (this.dbgOn()) {
            db.println("Disposing connection from " + NetCcatCircuit.prettyString(this.circuitId) + " at Node " + iNetElement.getName() + " for circuit " + this.getCircuitName());
        }
        netCircuitNode.destroy();
        this.removeCktNode(netCircuitNode);
        if (bl2) {
            this.removeCktNode(dualConnectionCircuitNode);
            dualConnectionCircuitNode.parentDispose();
            if (netCircuitNode2 != null) {
                netCircuitNode2.disposeActiveInternalSpliceLink(dualConnectionCircuitNode);
                this.insertCktNode(netCircuitNode2);
            }
        }
        if (bl) {
            if (!this.circuitInfoActive()) {
                if (!this.tl1CircuitCompleteCheck()) {
                    this.checkAndUpdateCircuit();
                }
            } else if (!this.completeCheck()) {
                this.checkAndUpdateCircuit();
            }
        }
    }

    protected synchronized void changeCircuitId(ICircuitId iCircuitId) {
        if (this.dbgOn()) {
            db.println("Changing CircuitId from " + NetCcatCircuit.prettyString(this.circuitId) + " to " + NetCcatCircuit.prettyString(iCircuitId) + " for " + this.getCircuitName());
        }
        Iterator iterator = this.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            netCircuitNode.setConnectionCircuitId(iCircuitId);
            this.disposeConnection(netCircuitNode, false);
            NetCircuitWatchDog.instance().reloadConnections(netCircuitNode.getNetElement());
        }
    }

    public Set getAffectedNodes(int n, int n2) {
        Object object;
        HashSet<INodeModel> hashSet = new HashSet<INodeModel>();
        if (NetCcatCircuit.isNullCircuitId(this.circuitId)) {
            return hashSet;
        }
        if (this.circuitId.getNodeId() == n) {
            INetElement iNetElement;
            Iterator iterator = this.getSources().iterator();
            while (iterator.hasNext()) {
                NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
                if (netCircuitEnd.getCircuitEnd().getNodeId() == n) {
                    iNetElement = this.net.findNetElem(n2);
                    if (iNetElement == null) {
                        if (this.dbgOn()) {
                            db.println("getAffectedNodes: NE not found for node " + Integer.toHexString(n2));
                        }
                        return hashSet;
                    }
                    hashSet.add(iNetElement.getNodeModel());
                    continue;
                }
                if (!this.dbgOn()) continue;
                db.println("getAffectedNodes: Source Matched with old node id: " + Integer.toHexString(netCircuitEnd.getCircuitEnd().getNodeId()));
            }
            iterator = this.getDrops().iterator();
            while (iterator.hasNext()) {
                NetCircuitDropInfo netCircuitDropInfo = (NetCircuitDropInfo)iterator.next();
                if (netCircuitDropInfo.getNetCktEnd().getCircuitEnd().getNodeId() != n) continue;
                iNetElement = this.net.findNetElem(n2);
                if (iNetElement == null) {
                    if (this.dbgOn()) {
                        db.println("getAffectedNodes: NE not found for node " + n2);
                    }
                    return hashSet;
                }
                hashSet.add(iNetElement.getNodeModel());
            }
            iterator = this.getCircuitNodes().iterator();
            while (iterator.hasNext()) {
                NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
                hashSet.add(netCircuitNode.getNodeModel());
            }
            return hashSet;
        }
        if (this.dbgOn()) {
            this.debug("getAffectedNodes(" + this.getCircuitName() + ", " + NetCcatCircuit.prettyString(this.circuitId) + ")" + ": Checking drops to see if they have old NodeId");
        }
        Iterator iterator = this.getDrops().iterator();
        while (iterator.hasNext()) {
            NetCircuitDropInfo netCircuitDropInfo = (NetCircuitDropInfo)iterator.next();
            if (netCircuitDropInfo.getNetCktEnd().getCircuitEnd().getNodeId() != n) continue;
            object = this.net.findNetElem(n2);
            if (object == null) {
                if (this.dbgOn()) {
                    db.println("getAffectedNodes: NE not found for node " + n2);
                }
                return hashSet;
            }
            hashSet.add(object.getNodeModel());
        }
        iterator = this.getSources().iterator();
        while (iterator.hasNext()) {
            NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
            if (netCircuitEnd.getCircuitEnd().getNodeId() == n) {
                object = this.net.findNetElem(n2);
                if (object == null) {
                    if (this.dbgOn()) {
                        db.println("getAffectedNodes: NE not found for node " + n2);
                    }
                    return hashSet;
                }
                hashSet.add(object.getNodeModel());
                continue;
            }
            object = this.getCircuitNodeFromCktEnd(netCircuitEnd);
            if (object == null) {
                if (this.dbgOn()) {
                    db.println("getAffectedNodes: Circuit node not found ");
                }
                return hashSet;
            }
            hashSet.add(this.getCircuitNodeFromCktEnd(netCircuitEnd).getNodeModel());
        }
        return hashSet;
    }

    private synchronized boolean allNodesInactive() {
        Iterator iterator = this.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            if (netCircuitNode.getState() == 0) continue;
            return false;
        }
        return this.getCktNodeListSize() > 0;
    }

    protected synchronized void checkAndUpdateCircuit() {
        if (this.dbgOn()) {
            this.debug("calling checkAndUpdateCircuit on " + this.getCircuitName());
        }
        if (this.getCktNodeListSize() == 0 && this.circuitModel == null) {
            this.finalDispose();
        } else if (this.allNodesInactive() && this.circuitModel == null) {
            this.dispose();
            this.finalDispose();
        } else {
            if (!this.circuitInfoActive()) {
                this.initSourcesAndDrops();
            }
            if (this.inRoll()) {
                this.setState(8);
            } else if (this.inConversion()) {
                this.setState(11);
            } else if (this.getState() == 8) {
                if (this.circuitInfoActive()) {
                    this.setState(4);
                } else {
                    this.setState(6);
                }
            } else if (this.getState() == 5 || this.getState() == 6) {
                this.setState(6);
            } else if (this.getState() != 2 && this.getState() != 0) {
                this.setState(4);
            }
        }
    }

    protected boolean validateCircuitTopology() {
        int[] nArray;
        if (this.dbgOn()) {
            db.println("validateCircuitTopology()");
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        Iterator iterator = this.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            if (netCircuitNode.getSources().size() != 0) {
                ++n;
                ++n3;
                bl = true;
            }
            if (netCircuitNode.getDrops().size() != 0) {
                ++n2;
                if (!bl) {
                    ++n3;
                }
            }
            bl = false;
        }
        if (this.getCktNodeListSize() != 0 && (this.isBidirectional() ? this.validateBidirSrcDropCombo(nArray = new int[]{this.getSourcesSize(), this.getDropsSize(), n, n2, n3}) : this.getSourcesSize() != 0 && this.getSourcesSize() < 3 && n < 3)) {
            return true;
        }
        if (this.dbgOn()) {
            db.println("validateCircuitTopology: Circuit " + this.getCircuitName() + " has invalid nodes/drops/sources");
            db.println("Number of nodes = " + this.getCktNodeListSize());
            db.println("Number of sources = " + this.getSourcesSize());
            db.println("Number of sourceNodes = " + n);
            db.println("Number of drops = " + this.getDropsSize());
            db.println("Number of dropNodes = " + n2);
            db.println("src plus drop nodes = " + n3);
        }
        return false;
    }

    private boolean validateCircuitEndsInTopology() {
        NetCircuitNode netCircuitNode;
        INetElement iNetElement;
        NetCircuitEnd netCircuitEnd;
        if (!this.circuitInfoActive()) {
            return true;
        }
        Iterator iterator = this.getCktSources().iterator();
        while (iterator.hasNext()) {
            netCircuitEnd = (NetCircuitEnd)iterator.next();
            iNetElement = netCircuitEnd.getNetElement();
            if (iNetElement == null) {
                if (this.dbgOn()) {
                    db.println("Circuit source " + netCircuitEnd.prettyString() + " is on a non-existing NE");
                }
                return false;
            }
            netCircuitNode = (NetCircuitNode)this.getCircuitNodeFromNE(iNetElement);
            if (netCircuitNode == null) {
                if (this.dbgOn()) {
                    db.println("The corresponding circuit node on circuit source " + netCircuitEnd.prettyString() + " does not exist");
                }
                return false;
            }
            if (netCircuitEnd.isNodeDrop() || netCircuitEnd.isEtherP2PCircuitEnd() || netCircuitNode.getConnectionPathEnd(netCircuitEnd) != null) continue;
            if (this.dbgOn()) {
                db.println("Circuit source " + netCircuitEnd.prettyString() + " does not have path on the circuit node " + iNetElement.getName());
            }
            return false;
        }
        iterator = this.getCktDrops().iterator();
        while (iterator.hasNext()) {
            netCircuitEnd = ((NetCircuitDropInfo)iterator.next()).getNetCktEnd();
            iNetElement = netCircuitEnd.getNetElement();
            if (iNetElement == null) {
                if (this.dbgOn()) {
                    db.println("Circuit drop " + netCircuitEnd.prettyString() + " is on a non-existing NE");
                }
                return false;
            }
            netCircuitNode = (NetCircuitNode)this.getCircuitNodeFromNE(iNetElement);
            if (netCircuitNode == null) {
                if (this.dbgOn()) {
                    db.println("The corresponding circuit node on circuit drop " + netCircuitEnd.prettyString() + " does not exist");
                }
                return false;
            }
            if (netCircuitEnd.isNodeDrop() || netCircuitEnd.isEtherP2PCircuitEnd() || netCircuitNode.getConnectionPathEnd(netCircuitEnd) != null) continue;
            if (this.dbgOn()) {
                db.println("Circuit drop " + netCircuitEnd.prettyString() + " does not have path on the circuit node " + iNetElement.getName());
            }
            return false;
        }
        return true;
    }

    private boolean validateBidirSrcDropCombo(int[] nArray) {
        for (int i = 0; i < bidirTable.length; ++i) {
            if (!Arrays.equals(nArray, bidirTable[i])) continue;
            return true;
        }
        return false;
    }

    protected synchronized boolean completeCheck() {
        if (this.dbgOn()) {
            db.println("completeCheck() for " + this.getCircuitName() + "; Number of cktNodes = " + this.getCktNodeListSize());
        }
        if (this.inRoll()) {
            this.setState(8);
        }
        if (this.inConversion()) {
            this.setState(11);
        }
        boolean bl = this.setCircuitRoutingDirection();
        if (!this.circuitInfoActive()) {
            if (this.dbgOn()) {
                db.println("Completeness check failed because Circuit Info is not active");
            }
            this.initSourcesAndDrops();
            return false;
        }
        if (!this.setSrcCircuitNode()) {
            return false;
        }
        if (!bl) {
            return false;
        }
        this.markUpsr();
        this.markDri();
        if (!this.validateCircuitEndsInTopology()) {
            if (this.dbgOn()) {
                db.println("The source and drop info in the circuit model can not completely show up in the circuit path");
            }
            return false;
        }
        if (!this.isNodesStructureComplete()) {
            return false;
        }
        if (this.state == 4) {
            this.cleanupSpliceListeners();
        }
        if (this.dbgOn()) {
            db.println("completeCheck passed. Setting the appropriate state");
        }
        if (this.inRoll() || this.inConversion()) {
            return true;
        }
        this.setState(1);
        if (this.getCircuitTypeObj().isLoCircuitType()) {
            ((LoCcatCircuit)this).setLap();
        }
        if (this.getCircuitTypeObj().isLAPCircuitType()) {
            this.connectLoCircuitsToLAP();
        }
        return true;
    }

    protected synchronized boolean tl1CircuitCompleteCheck() {
        if (this.dbgOn()) {
            db.println("tl1CircuitCompleteCheck() for " + this.getCircuitName() + "; Number of cktNodes = " + this.getCktNodeListSize());
        }
        if (this.circuitInfoActive()) {
            if (this.dbgOn()) {
                db.println("circuit Info is Active : CTC ckt.");
            }
            return false;
        }
        boolean bl = this.setCircuitRoutingDirection();
        if (!this.initSourcesAndDrops()) {
            return false;
        }
        if (!bl) {
            return false;
        }
        this.markUpsr();
        this.markDri();
        if (!this.isNodesStructureComplete()) {
            return false;
        }
        if (this.inRoll()) {
            this.setState(8);
        } else if (this.inConversion()) {
            this.setState(11);
        } else {
            try {
                if (this.isTl1Ckt()) {
                    this.setState(5);
                } else {
                    this.setState(4);
                }
            }
            catch (IncorrectCircuitState incorrectCircuitState) {
                // empty catch block
            }
        }
        return true;
    }

    private void markDriNodes() {
        NetCircuitNode netCircuitNode;
        NetCircuitNode[] netCircuitNodeArray = new NetCircuitNode[2];
        int n = 0;
        List list = this.getCircuitNodes();
        Connection[] connectionArray = new Connection[2];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        ArrayList<NetCircuitNode> arrayList = new ArrayList<NetCircuitNode>();
        if (this.dbgOn()) {
            this.debug("markDriNodes: marking circuit " + this.getCircuitName());
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            netCircuitNode = (NetCircuitNode)iterator.next();
            netCircuitNode.setDri(false);
            n3 += netCircuitNode.isBlsrDriHandoff() ? 1 : 0;
        }
        iterator = list.iterator();
        while (iterator.hasNext()) {
            netCircuitNode = (NetCircuitNode)iterator.next();
            n += netCircuitNode.markBlsrDriHandoffs();
            Iterator iterator2 = netCircuitNode.getSelectors().iterator();
            while (iterator2.hasNext()) {
                int n5;
                SelectorConnection selectorConnection = (SelectorConnection)iterator2.next();
                if (selectorConnection.handoffs.size() != 2) continue;
                for (n5 = 0; n5 < 2; ++n5) {
                    connectionArray[n5] = (Connection)selectorConnection.handoffs.get(n5);
                    netCircuitNodeArray[n5] = connectionArray[n5].getNode();
                    if (netCircuitNodeArray[n5] == null || netCircuitNodeArray[n5].getDri() || netCircuitNodeArray[n5].isBlsrDriHandoff()) continue;
                    ++n2;
                }
                if (!connectionArray[0].hasValidUpsrDriHandoffInterconnect(connectionArray[1]) || !connectionArray[1].hasValidUpsrDriHandoffInterconnect(connectionArray[0])) continue;
                for (n5 = 0; n5 < 2; ++n5) {
                    if (netCircuitNodeArray[n5] == null || netCircuitNodeArray[n5].getDri() || netCircuitNodeArray[n5].isBlsrDriHandoff()) continue;
                    arrayList.add(netCircuitNodeArray[n5]);
                }
            }
        }
        this.driConfigurationError = n3 != n;
        iterator = arrayList.iterator();
        while (iterator.hasNext() && !this.driConfigurationError) {
            ((NetCircuitNode)iterator.next()).setDri(true);
            ++n;
        }
        if (this.dbgOn()) {
            n4 = n2 + n3;
            db.println("markDriNodes: marked " + n + " of " + n4 + " DRI handoff nodes");
        }
    }

    protected void markUpsr() {
        if (this.dbgOn()) {
            db.println("markUpsr: marking circuit " + this.getCircuitName());
        }
        Iterator iterator = this.getCircuitSpans().iterator();
        while (iterator.hasNext()) {
            ((NetCircuitSpan)iterator.next()).setUpsrLink(false);
        }
        iterator = this.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            netCircuitNode.markSelectorInputPaths();
        }
    }

    protected void markDri() {
        if (this.dbgOn()) {
            db.println("markDri: marking circuit " + this.getCircuitName());
        }
        this.driConfigurationError = false;
        Iterator iterator = this.getCircuitSpans().iterator();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            netCircuitSpan.setDri(false);
            netCircuitSpan.setBlsrDriInterConnect(false);
            if (this.getState() == 0) continue;
            netCircuitSpan.getNetLinkSpan().setSecondaryCircuit(false);
        }
        this.markDriNodes();
        iterator = this.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            netCircuitNode.markSpansDri();
        }
    }

    private boolean isValidConnDir() {
        int n;
        if (this.dbgOn()) {
            db.println("isValidConnDir()");
        }
        NetCircuitNode netCircuitNode = null;
        boolean bl = true;
        boolean bl2 = true;
        int n2 = n = this.getCircuitDir();
        Iterator iterator = this.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            netCircuitNode = (NetCircuitNode)iterator.next();
            if (bl) {
                bl = false;
                n2 = n = netCircuitNode.getConnDir();
                continue;
            }
            n = netCircuitNode.getConnDir();
            if (n == n2) continue;
            bl2 = false;
        }
        if (bl2) {
            if (this.getCircuitDir() != n) {
                this.setCircuitDir(n);
                this.setChanged();
            }
            return true;
        }
        if (!this.circuitInfoActive() && this.getCircuitDir() == 1) {
            this.setCircuitDir(0);
            this.setChanged();
        }
        if (this.getCircuitDir() == 0 && this.isUpsrCircuit()) {
            return true;
        }
        if (this.dbgOn()) {
            db.println("isValidConnDir() failed");
        }
        return false;
    }

    public boolean isUpsrCircuit() {
        NetCircuitNode netCircuitNode = null;
        Iterator iterator = this.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            netCircuitNode = (NetCircuitNode)iterator.next();
            if (!netCircuitNode.upsrBridgeOrSelector()) continue;
            return true;
        }
        return false;
    }

    protected boolean hasUpsrConnection() {
        NetCircuitNode netCircuitNode = null;
        Iterator iterator = this.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            netCircuitNode = (NetCircuitNode)iterator.next();
            if (!netCircuitNode.isUpsrSelectorConn() && !netCircuitNode.isUpsrBridgeConn()) continue;
            return true;
        }
        return false;
    }

    protected NetCircuitSpan changeNetLinkDir(NetCircuitSpan netCircuitSpan) {
        NetLinkSpan netLinkSpan = (NetLinkSpan)netCircuitSpan.getNetLinkSpan();
        NetCircuitNode netCircuitNode = (NetCircuitNode)this.getCircuitNodeFromNE(netLinkSpan.getLink().getSrc());
        NetCircuitNode netCircuitNode2 = (NetCircuitNode)this.getCircuitNodeFromNE(netLinkSpan.getLink().getDst());
        eSpanDirection eSpanDirection2 = null;
        eSpanDirection eSpanDirection3 = null;
        if (netCircuitNode != null) {
            eSpanDirection2 = netCircuitNode.findDir(netCircuitSpan);
        }
        if (netCircuitNode2 != null) {
            eSpanDirection3 = netCircuitNode2.findDir(netCircuitSpan);
        }
        if (eSpanDirection2 == null || eSpanDirection3 == null) {
            if (this.dbgOn()) {
                this.debug("changeNetLinkDir: oldSpan has no src or dst NE");
            }
            netCircuitSpan.dispose(false);
            return null;
        }
        INetLink iNetLink = netLinkSpan.getReverseLink();
        if (iNetLink == null || !iNetLink.isValidSrcHoNumber(netCircuitSpan.getDstHoNum()) || !iNetLink.isValidDstHoNumber(netCircuitSpan.getSrcHoNum())) {
            if (this.dbgOn()) {
                this.debug("changeNetLinkDir: oldSpan has invalid reverse link");
            }
            netCircuitSpan.dispose(false);
            return null;
        }
        NetLinkSpan netLinkSpan2 = new NetLinkSpan(netLinkSpan.getReverseLink(), netLinkSpan.getLink(), netLinkSpan.getDstHoNum(), netLinkSpan.getSrcHoNum(), netLinkSpan.getLoNum());
        netLinkSpan2.setOmni(netLinkSpan.getOmni());
        NetCircuitSpan netCircuitSpan2 = NetCircuitSpanFactory.createCircuitSpan(this, netLinkSpan2);
        netCircuitSpan2.setUpsrLink(netCircuitSpan.getUpsrLink());
        netCircuitSpan2.setSrcState(netCircuitSpan.getDstState());
        netCircuitSpan2.setDstState(netCircuitSpan.getSrcState());
        if (this.dbgOn()) {
            this.debug("changeNetLinkDir:");
            this.debug("  oldSpan: " + netCircuitSpan.prettyString());
            this.debug("  newSpan: " + netCircuitSpan2.prettyString());
        }
        netCircuitSpan.dispose(true);
        if (netCircuitSpan2.getLink().isDeleted()) {
            if (this.dbgOn()) {
                this.debug("changeNetLinkDir: Link is deleted; ");
            }
            return null;
        }
        NetCircuitNode netCircuitNode3 = (NetCircuitNode)this.getCircuitNodeFromNE(netLinkSpan2.getLink().getSrc());
        NetCircuitNode netCircuitNode4 = (NetCircuitNode)this.getCircuitNodeFromNE(netLinkSpan2.getLink().getDst());
        boolean bl = false;
        if (netCircuitSpan.getLink().isLAP()) {
            this.restoreLapHoNode(netCircuitNode3, netCircuitNode4, netLinkSpan2);
            bl = true;
            netCircuitNode3 = (NetCircuitNode)this.getCircuitNodeFromNE(netLinkSpan2.getLink().getSrc());
            netCircuitNode4 = (NetCircuitNode)this.getCircuitNodeFromNE(netLinkSpan2.getLink().getDst());
        }
        if (netCircuitNode3 != null) {
            netCircuitNode3.addActiveSpan(netCircuitSpan2, eSpanDirection.reverse(eSpanDirection3));
        }
        if (netCircuitNode4 != null) {
            netCircuitNode4.addActiveSpan(netCircuitSpan2, eSpanDirection.reverse(eSpanDirection2));
        }
        if (this.inCircuitMerge && bl) {
            NetCircuitNode netCircuitNode5;
            NetCircuitNode netCircuitNode6 = netCircuitNode5 = netCircuitNode3 != null ? netCircuitNode3 : netCircuitNode4;
            if (netCircuitNode5 != null) {
                this.lapNodeCreated(netCircuitNode5);
            }
        }
        return netCircuitSpan2;
    }

    protected void restoreLapHoNode(NetCircuitNode netCircuitNode, NetCircuitNode netCircuitNode2, NetLinkSpan netLinkSpan) {
    }

    private void cleanupSpliceListeners() {
        Iterator iterator = this.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            netCircuitNode.cleanupSpliceListeners();
        }
    }

    protected synchronized boolean isNodesStructureComplete() {
        if (this.dbgOn()) {
            db.println("Node structure complete check");
        }
        if (!this.validateCircuitTopology()) {
            return false;
        }
        Iterator iterator = this.cktNodeList.values().iterator();
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            if (netCircuitNode.completeCheck()) continue;
            if (this.dbgOn()) {
                db.println("Completeness check failed at node " + netCircuitNode.getNetElement().getName());
            }
            return false;
        }
        if (!this.isValidConnDir()) {
            return false;
        }
        if (this.dbgOn()) {
            db.println("Node structure complete check passed");
        }
        return true;
    }

    protected boolean isStitchedEthernet() {
        return false;
    }

    protected boolean isEthernet() {
        return false;
    }

    public void setMemberPrefs(MemberPrefs memberPrefs) {
        this.memberPrefs = memberPrefs;
    }

    public MemberPrefs getMemberPrefs() {
        return this.memberPrefs;
    }

    protected boolean isDriMemberPref() {
        return this.memberPrefs.getPathProtection() == 5;
    }

    public void setInRoll(boolean bl) {
        block8: {
            if (bl) {
                this.setCktOperation(4);
            } else {
                this.setCktOperation(0);
            }
            try {
                if (!this.circuitInfoActive()) {
                    if (!this.tl1CircuitCompleteCheck()) {
                        this.checkAndUpdateCircuit();
                    }
                } else if (!this.completeCheck()) {
                    this.checkAndUpdateCircuit();
                }
                this.updateEvent.changed = true;
                NetCircuitWatchDog.instance().queueCircuitUpdate(this, this, "changed");
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (!db.on()) break block8;
                db.println("Error setting roll flag");
            }
        }
    }

    public boolean inRoll() {
        if (this.getCktOperation() == 4) {
            return true;
        }
        return this.anyNodeInRoll();
    }

    private boolean anyNodeInRoll() {
        try {
            Iterator iterator = this.getCircuitNodes().iterator();
            NetCircuitNode netCircuitNode = null;
            while (iterator.hasNext()) {
                netCircuitNode = (NetCircuitNode)iterator.next();
                boolean bl = netCircuitNode.inRoll();
                netCircuitNode.setCurrRollStatus(bl);
                if (!bl) continue;
                return true;
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            return false;
        }
        return false;
    }

    public boolean inConversion() {
        try {
            Iterator iterator = this.getCircuitNodes().iterator();
            NetCircuitNode netCircuitNode = null;
            while (iterator.hasNext()) {
                netCircuitNode = (NetCircuitNode)iterator.next();
                if (!netCircuitNode.inConnectionConversion()) continue;
                if (db.on()) {
                    db.println("In conversion on connection is true " + netCircuitNode.getName());
                }
                return true;
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            return false;
        }
        return false;
    }

    public int getConversionOperation() {
        if (!this.inConversion()) {
            return -1;
        }
        int n = -1;
        try {
            Iterator iterator = this.getCircuitNodes().iterator();
            NetCircuitNode netCircuitNode = null;
            while (iterator.hasNext()) {
                netCircuitNode = (NetCircuitNode)iterator.next();
                if (!netCircuitNode.inConnectionConversion()) continue;
                n = netCircuitNode.getConversionOp();
                break;
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            return -1;
        }
        return n;
    }

    protected void setInConnectionConversion(boolean bl) {
        if (db.on()) {
            db.println("setInConnectionConversion: flag => " + bl);
        }
        if (bl && (this.state == 1 || this.state == 5)) {
            this.setCktOperation(5);
            if (db.on()) {
                db.println("setInConnectionConversion: state => " + EnumStrings.getString((Class)INetCircuitOperation.class, (int)this.getCktOperation()));
            }
            this.setState(11);
        } else if (!bl && this.state == 11) {
            Iterator iterator = this.getCircuitNodes().iterator();
            while (iterator.hasNext()) {
                NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
                if (netCircuitNode.getState() != 4) continue;
                if (db.on()) {
                    db.println("setInConnectionConversion: found NCN " + netCircuitNode.getName() + " still in CONN_PEND");
                }
                return;
            }
            if (!this.completeCheck()) {
                this.checkAndUpdateCircuit();
            }
        }
    }

    protected void addActiveSpan(NetCircuitSpan netCircuitSpan) {
        this.insertCktSpan(netCircuitSpan);
    }

    protected void disposeActiveSpan(NetCircuitSpan netCircuitSpan) {
        this.removeCktSpan(netCircuitSpan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertCktSpan(NetCircuitSpan netCircuitSpan) {
        Map map = this.cktSpanList;
        synchronized (map) {
            if (this.cktSpanList.containsKey(netCircuitSpan.getLink())) {
                if (this.dbgOn()) {
                    db.println("insertCktSpan: span already in list; ignored");
                }
                return;
            }
            if (this.dbgOn()) {
                db.println("cktSpanList.put(" + netCircuitSpan.getLink().prettyString() + ") to circuit " + NetCcatCircuit.prettyString(this.circuitId));
            }
            this.cktSpanList.put(netCircuitSpan.getLink(), netCircuitSpan);
        }
        this.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeCktSpan(NetCircuitSpan netCircuitSpan) {
        Map map = this.cktSpanList;
        synchronized (map) {
            if (!this.cktSpanList.containsKey(netCircuitSpan.getLink())) {
                if (this.dbgOn()) {
                    db.println("removeCktSpan: span not found!");
                }
                return;
            }
            if (this.dbgOn()) {
                db.println("cktSpanList.remove(" + netCircuitSpan.getLink().prettyString() + ") from circuit " + NetCcatCircuit.prettyString(this.circuitId));
            }
            this.cktSpanList.remove(netCircuitSpan.getLink());
        }
        this.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertCktNode(NetCircuitNode netCircuitNode) {
        Map map = this.cktNodeList;
        synchronized (map) {
            if (this.dbgOn()) {
                db.println("insertCktNode(): " + netCircuitNode.getNameAndClass());
            }
            this.cktNodeList.put(netCircuitNode.getNetElement(), netCircuitNode);
        }
        this.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeCktNode(NetCircuitNode netCircuitNode) {
        if (this.srcCircuitNode == netCircuitNode) {
            this.srcCircuitNode = null;
        }
        if (this.secSrcCircuitNode == netCircuitNode) {
            this.secSrcCircuitNode = null;
        }
        Map map = this.cktNodeList;
        synchronized (map) {
            if (this.dbgOn()) {
                db.println("removeCktNode(): " + netCircuitNode.getNameAndClass());
            }
            this.cktNodeList.remove(netCircuitNode.getNetElement());
        }
        this.setChanged();
    }

    public LinkedList getRequiredSpans() {
        LinkedList<INetLinkSpan> linkedList = new LinkedList<INetLinkSpan>();
        Iterator iterator = this.getCircuitSpans().iterator();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            if (netCircuitSpan.getSrcState() != 4) continue;
            linkedList.add(netCircuitSpan.getNetLinkSpan());
        }
        return linkedList;
    }

    public LinkedList getRequiredSpans(INetElement iNetElement) {
        LinkedList<INetLinkSpan> linkedList = new LinkedList<INetLinkSpan>();
        Iterator iterator = this.getCircuitSpans().iterator();
        while (iterator.hasNext()) {
            INetLink iNetLink;
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            if (netCircuitSpan.getSrcState() != 4 || (iNetLink = netCircuitSpan.getNetLinkSpan().getLink()).getSrc() != iNetElement && iNetLink.getDst() != iNetElement) continue;
            linkedList.add(netCircuitSpan.getNetLinkSpan());
        }
        return linkedList;
    }

    protected void routeCurrentDrop(INetElement iNetElement, RoutePrefs routePrefs, boolean bl) throws SanityCheckFailed, NoRoute, AllocFailed, AbstractCmsIOException {
        RoutePrefs routePrefs2 = new RoutePrefs(routePrefs);
        LinkedList linkedList = new LinkedList(this.getRequiredSpans());
        linkedList.addAll(routePrefs2.getRequiredSpans());
        this.sanityCheckCircuitInputs(routePrefs2.getPathProt());
        if (routePrefs2.getSrc() == null) {
            routePrefs2.setSrc(this.srcCircuitNode.getNetElement());
        }
        if (this.getSecondarySource() != null) {
            routePrefs2.setSecSrc(this.getSecondarySource().getNetElement());
        }
        routePrefs2.setDst(iNetElement);
        routePrefs2.setCircuitSize(this.getCircuitSize());
        routePrefs2.setRequiredSpans(linkedList);
        routePrefs2.setCircuitType(this.getCircuitType());
        routePrefs2.setPathOnly(false);
        routePrefs2.setDir(this.getCircuitDir());
        routePrefs2.setSla(this.getSla());
        if (routePrefs2.getSecDst() != null && routePrefs2.getSecDst() != routePrefs2.getDst() && !this.isBidirectional()) {
            if (this.dbgOn()) {
                db.println("roueCurrentDrop: setPathProtection");
            }
            if (routePrefs2.getPathProt() != 5) {
                routePrefs2.setPathProt(0);
            }
        }
        NetCircuitPath netCircuitPath = new NetCircuitPath(routePrefs2, this);
        netCircuitPath.computeCircuitPath();
        this.setCircuitCosts(netCircuitPath.computePathCosts());
        if (bl) {
            LinkedList linkedList2 = netCircuitPath.getAvailSpans();
            Iterator iterator = linkedList2.iterator();
            while (iterator.hasNext()) {
                this.addCircuitSpan((INetLinkSpan)iterator.next());
            }
        }
    }

    protected void removeRoutedSpans() {
        if (this.dbgOn()) {
            db.println("removeRoutedSpans");
        }
        Iterator iterator = this.getCircuitSpans().iterator();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            if (netCircuitSpan.getSrcState() != 2) continue;
            if (netCircuitSpan.getDstState() != 2) {
                if (!this.dbgOn()) continue;
                db.println("span src. is routed, but dst. is not");
                continue;
            }
            if (this.dbgOn()) {
                db.println("removing ROUTED span: " + netCircuitSpan.prettyString());
            }
            this.removeCktSpan(netCircuitSpan);
            this.setChanged();
            NetCircuitNode netCircuitNode = (NetCircuitNode)this.getCircuitNodeFromNE(netCircuitSpan.getLink().getSrc());
            NetCircuitNode netCircuitNode2 = (NetCircuitNode)this.getCircuitNodeFromNE(netCircuitSpan.getLink().getDst());
            eSpanDirection eSpanDirection2 = null;
            if (this.isBidirectional() || netCircuitSpan.getNetLinkSpan().getOmni()) {
                eSpanDirection2 = eSpanDirection.BIDIRECTIONAL;
            }
            if (netCircuitNode == null) {
                if (this.dbgOn()) {
                    db.println("src circuit node not found");
                }
            } else {
                if (eSpanDirection2 == null) {
                    eSpanDirection2 = eSpanDirection.ORIGINATING;
                }
                netCircuitNode.removeRoutedSpan(netCircuitSpan, eSpanDirection2);
            }
            if (netCircuitNode2 == null) {
                if (!this.dbgOn()) continue;
                db.println("dst circuit node not found");
                continue;
            }
            if (eSpanDirection2 == null) {
                eSpanDirection2 = eSpanDirection.TERMINATING;
            }
            netCircuitNode2.removeRoutedSpan(netCircuitSpan, eSpanDirection2);
        }
    }

    protected void tentative2Routed() throws DeletionError, IncorrectCircuitState {
        if (this.getCktOperation() == 1 && this.circuitInfoActive()) {
            this.destroyCircuitInfo();
        }
        Iterator iterator = this.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            netCircuitNode.tentative2Routed();
        }
    }

    protected void tentative2Active() {
        Iterator iterator = this.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            netCircuitNode.tentative2Active();
        }
        if (this.getState() == 0) {
            if (this.tl1Compatible()) {
                this.setState(5);
                this.setTL1DropPathUnprot();
                this.tl1Compatible = false;
                this.markUpsr();
                this.markDri();
            } else {
                this.setState(4);
                this.completeCheck();
            }
            this.setProtType();
        } else if (!this.circuitInfoActive()) {
            this.setState(5);
            this.setTL1DropPathUnprot();
            this.markUpsr();
            this.markDri();
        } else {
            this.setState(4);
            this.completeCheck();
        }
        this.serviceState = this.deriveServiceState();
        this.setCktOperation(0);
    }

    private void setTL1DropPathUnprot() {
        Iterator iterator = this.getDrops().iterator();
        while (iterator.hasNext()) {
            NetCircuitDropInfo netCircuitDropInfo = (NetCircuitDropInfo)iterator.next();
            netCircuitDropInfo.setPathProt(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void revertAdminState() throws AdminStateProvisioningError {
        boolean bl = false;
        Iterator iterator = this.getCircuitNodes().iterator();
        NetCcatCircuit netCcatCircuit = this;
        synchronized (netCcatCircuit) {
            while (iterator.hasNext()) {
                NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
                if (netCircuitNode.getState() != 3) continue;
                try {
                    netCircuitNode.revertAdminState();
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                    if (this.dbgOn()) {
                        db.println("Unable to revert admin state on " + netCircuitNode.getName() + " " + exception);
                    }
                    bl = true;
                }
            }
        }
        if (bl) {
            throw new AdminStateProvisioningError("Reversion to previous state failed");
        }
    }

    private void removeInactiveNodesAndSpans() {
        if (this.dbgOn()) {
            db.println("removeInactiveNodesAndSpans");
        }
        Iterator iterator = this.getCircuitSpans().iterator();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            if (netCircuitSpan.getSrcState() != 0) continue;
            if (netCircuitSpan.getDstState() == 0) {
                if (this.dbgOn()) {
                    db.println("removing INACTIVE span: " + netCircuitSpan.prettyString());
                }
                this.removeCktSpan(netCircuitSpan);
                this.setChanged();
                continue;
            }
            if (!this.dbgOn()) continue;
            db.println("src of span inactive, but dst is not");
        }
        iterator = this.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            if (netCircuitNode == this.srcCircuitNode || netCircuitNode == this.secSrcCircuitNode || netCircuitNode.getSources().size() != 0 || netCircuitNode.getState() != 0 || netCircuitNode.getDrops().size() != 0 || netCircuitNode.isNodeDrop()) continue;
            if (this.dbgOn()) {
                db.println("Removing INACTIVE node: " + netCircuitNode.getNetElement().getName());
            }
            this.removeCktNode(netCircuitNode);
            this.setChanged();
        }
    }

    public synchronized void addDrop(INetCircuitEnd iNetCircuitEnd, RoutePrefs routePrefs) throws AllocFailed, CircuitDropOutstanding, ObjNotFound, SanityCheckFailed, IncorrectCircuitState {
        if (!this.isCircuitRefValid()) {
            throw new IncorrectCircuitState("Circuit already destroyed");
        }
        NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createCircuitEnd(this.getCircuitType(), iNetCircuitEnd);
        if (this.isMemberOfVcat()) {
            netCircuitEnd.setPathIdentifier(this.getPrimarySource().getPathIdentifier());
        }
        if (this.dbgOn()) {
            db.println("addDrop called. Drop = " + netCircuitEnd.prettyString());
        }
        if (!this.isMemberOfVcat()) {
            this.setMemberPrefs(routePrefs.getFwdDropPrefs().getFirstMemberGroupPrefs().getMemberPrefs());
        }
        int n = this.convertPathProt(this.memberPrefs == null ? 9 : this.memberPrefs.getPathProtection());
        this.addDropCheck(netCircuitEnd, n);
        NetCircuitDropInfo netCircuitDropInfo = new NetCircuitDropInfo(netCircuitEnd, n);
        if (this.getCktDrops().contains(netCircuitDropInfo)) {
            throw new SanityCheckFailed("Attempt to add duplicate drop to circuit");
        }
        INetElement iNetElement = null;
        try {
            iNetElement = netCircuitEnd.getNetElement();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            db.println("i/o exception in addDrop");
            SDebug.printStackTrace((Throwable)abstractCmsIOException);
            iNetElement = null;
        }
        if (iNetElement == null) {
            if (this.dbgOn()) {
                db.println("addDrop: unable to find NE");
            }
            throw new ObjNotFound("Unable to find Network Element");
        }
        NetCircuitNode netCircuitNode = (NetCircuitNode)this.getCircuitNodeFromNE(iNetElement);
        ICircuitType iCircuitType = this.getCircuitTypeObj();
        if (netCircuitNode == null) {
            if (iCircuitType.isEthernetCircuitType()) {
                throw new SanityCheckFailed("Cannot add Ethernet HO drop on node " + iNetElement.getName());
            }
            netCircuitNode = this.getXmCircuitEnds().isEmpty() || ((NetCircuitEnd)this.getXmCircuitEnds().get(0)).getNodeId() != iNetCircuitEnd.getNodeId() ? NetCircuitNodeFactory.createCircuitNode(iNetElement, this) : NetCircuitNodeFactory.createDualConnectionCircuitNode(iNetElement, iCircuitType, (HoCcatCircuit)this);
            this.insertCktNode(netCircuitNode);
        } else {
            if (this.isUpsr1wayTl1() && !this.sanityCheckRequestedDropProtection(netCircuitNode, n)) {
                if (this.dbgOn()) {
                    db.println("addDrop: ONEWAY connection on " + netCircuitNode.getName() + " does not support drop protection");
                }
                throw new SanityCheckFailed("ONEWAY connection on " + netCircuitNode.getName() + " does not support drop protection");
            }
            if (iCircuitType.isEthernetCircuitType() && !netCircuitNode.eligibleForEtherHoDropAdd()) {
                throw new SanityCheckFailed("Cannot add Ethernet HO drop on node " + iNetElement.getName());
            }
        }
        netCircuitNode.addDropInfo(netCircuitDropInfo);
        this.insertDrop(netCircuitDropInfo);
        if (this.getState() != 0) {
            this.setState(3);
        }
    }

    private boolean sanityCheckRequestedDropProtection(NetCircuitNode netCircuitNode, int n) {
        if ((netCircuitNode.getConnectionType() == 0 || netCircuitNode.getConnectionType() == 4) && n == 0) {
            if (netCircuitNode.connections.size() == 1) {
                Connection connection = (Connection)netCircuitNode.connections.get(0);
                List list = connection.getInSpans();
                NetCircuitSpan netCircuitSpan = list.size() == 0 ? null : (NetCircuitSpan)list.get(0);
                return connection.isInputLineProtected(netCircuitSpan);
            }
            db.println("sanityCheckRequestedDropProtection: Error in connection list on node " + netCircuitNode.getName());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDrop(INetCircuitEnd iNetCircuitEnd) throws CircuitDropOutstanding, ObjNotFound, CannotDeleteLastDrop, IncorrectCircuitState, SanityCheckFailed, DeletionError, AbstractCmsIOException {
        NetCcatCircuit netCcatCircuit = this;
        synchronized (netCcatCircuit) {
            this.deleteDropCktEnd(iNetCircuitEnd);
        }
        if (this.getCktOperation() != 1) {
            this.notifyChanged(false);
        }
    }

    protected void deleteDropCktEnd(INetCircuitEnd iNetCircuitEnd) throws CircuitDropOutstanding, ObjNotFound, CannotDeleteLastDrop, IncorrectCircuitState, SanityCheckFailed, DeletionError, AbstractCmsIOException {
        if (this.dbgOn()) {
            db.println("Deleting drop from circuit");
        }
        if (this.state != 0 && this.state != 1 && this.state != 5 && this.state != 3) {
            throw new IncorrectCircuitState("Circuit drop can be deleted only when status \nis CREATING, DISCOVERED, DISCOVERED_TL1 or DROP_PENDING");
        }
        NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createCircuitEnd(this.getCircuitType(), iNetCircuitEnd);
        if (this.isMemberOfVcat()) {
            netCircuitEnd.setPathIdentifier(this.getPrimarySource().getPathIdentifier());
        }
        Iterator iterator = this.getCktDrops().iterator();
        NetCircuitDropInfo netCircuitDropInfo = null;
        while (iterator.hasNext() && !(netCircuitDropInfo = (NetCircuitDropInfo)iterator.next()).getNetCktEnd().equals(netCircuitEnd)) {
            netCircuitDropInfo = null;
        }
        if (netCircuitDropInfo == null) {
            if (this.dbgOn()) {
                db.println("deleteDrop: unable to find drop");
            }
            throw new ObjNotFound("Unable to find the drop being deleted");
        }
        if (this.state == 1 && this.getDropsSize() == 1 && !this.isStitchedEthernet()) {
            throw new CannotDeleteLastDrop("Last circuit drop cannot be deleted. \nPlease destroy the circuit instead");
        }
        int n = netCircuitDropInfo.getNetCktEnd().getStage();
        if (this.state == 3 && n != 2) {
            throw new CircuitDropOutstanding("Cannot delete an existing drop when another drop is pending");
        }
        INetElement iNetElement = null;
        try {
            iNetElement = netCircuitDropInfo.getNetElement();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            db.println("i/o exception in deleteDrop");
            SDebug.printStackTrace((Throwable)abstractCmsIOException);
            iNetElement = null;
        }
        if (iNetElement == null) {
            throw new ObjNotFound("Net Element not found");
        }
        NetCircuitNode netCircuitNode = (NetCircuitNode)this.getCircuitNodeFromNE(iNetElement);
        if (netCircuitNode == null) {
            this.removeDrop(netCircuitDropInfo);
            return;
        }
        if (n == 2) {
            netCircuitNode.removeRoutedDrop(netCircuitDropInfo.getNetCktEnd());
            if (netCircuitNode.getDrops().size() == 0 && !netCircuitNode.isNodeDrop()) {
                this.removeRoutedSpans();
            }
        } else {
            netCircuitNode.deleteDrop(netCircuitDropInfo.getNetCktEnd());
            try {
                if (this.circuitInfoActive()) {
                    this.circuitModel.delDrop(netCircuitDropInfo.getNetCktEnd().getCircuitEnd());
                }
            }
            catch (CannotDeleteLastDrop cannotDeleteLastDrop) {
                if (this.dbgOn()) {
                    db.println("Cannot del. last drop: unexpected exception");
                }
                throw cannotDeleteLastDrop;
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (this.dbgOn()) {
                    db.println("Cannot del. last drop: unexpected exception");
                }
                throw abstractCmsIOException;
            }
        }
        if (netCircuitNode.getDrops().size() == 0 && !netCircuitNode.isNodeDrop()) {
            this.removeInactiveNodesAndSpans();
        }
        this.removeDrop(netCircuitDropInfo);
        if (this.getDropsSize() > 0 && this.state == 3) {
            if (!this.circuitInfoActive()) {
                if (this.isTl1Ckt()) {
                    this.setState(5);
                } else {
                    this.setState(4);
                }
            } else {
                this.setState(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getCircuitSpans() {
        LinkedList linkedList;
        Map map = this.cktSpanList;
        synchronized (map) {
            linkedList = new LinkedList(this.cktSpanList.values());
        }
        return linkedList;
    }

    public List getActiveCircuitSpans() {
        List list = this.getCircuitSpans();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            INetCircuitSpan iNetCircuitSpan = (INetCircuitSpan)iterator.next();
            if (iNetCircuitSpan.getSrcState() == 4 || iNetCircuitSpan.getDstState() == 4) continue;
            iterator.remove();
        }
        if (this.dbgOn()) {
            db.println("getActiveCircuitSpans: returning " + list.size() + " spans");
        }
        return list;
    }

    public List getRoutedCircuitSpans() {
        List list = this.getCircuitSpans();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            INetCircuitSpan iNetCircuitSpan = (INetCircuitSpan)iterator.next();
            if (iNetCircuitSpan.getSrcState() == 2 || iNetCircuitSpan.getDstState() == 2) continue;
            iterator.remove();
        }
        if (this.dbgOn()) {
            db.println("getRoutedCircuitSpans: returning " + list.size() + " spans");
        }
        return list;
    }

    public int getCircuitSpanNum() {
        return this.cktSpanList.size();
    }

    public INetCircuitNode getSrcCircuitNode() {
        return this.srcCircuitNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getCircuitNodes() {
        LinkedList linkedList;
        Map map = this.cktNodeList;
        synchronized (map) {
            linkedList = new LinkedList(this.cktNodeList.values());
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getCircuitNodesMap() {
        TreeMap treeMap = new TreeMap(new NetElemComparator());
        Map map = this.cktNodeList;
        synchronized (map) {
            treeMap.putAll(this.cktNodeList);
        }
        return treeMap;
    }

    protected int getCktNodeListSize() {
        return this.cktNodeList.size();
    }

    protected boolean usesNetElement(INetElement iNetElement) {
        return this.doesCircuitUseNetElem(iNetElement) || this.hasSourceWithNetElement(iNetElement);
    }

    public boolean doesCircuitUseNetElem(INetElement iNetElement) {
        return this.getCircuitNodeFromNE(iNetElement) != null;
    }

    protected boolean doesCircuitUseConn(INetElement iNetElement, IConnectionModel iConnectionModel) {
        NetCircuitNode netCircuitNode = (NetCircuitNode)this.getCircuitNodeFromNE(iNetElement);
        if (netCircuitNode == null) {
            return false;
        }
        return netCircuitNode.doesCircuitNodeUseConn(iConnectionModel);
    }

    public INetCircuitNode getCircuitNodeFromNE(INetElement iNetElement) {
        return (INetCircuitNode)this.cktNodeList.get(iNetElement);
    }

    public NetCircuitNode getCircuitNodeFromCktEnd(INetCircuitEnd iNetCircuitEnd) {
        INetElement iNetElement = iNetCircuitEnd.getNetElement();
        if (iNetElement == null) {
            if (this.dbgOn()) {
                db.println("getCircuitNodeFromCktEnd: NE not found for cktEnd");
            }
            return null;
        }
        return (NetCircuitNode)this.getCircuitNodeFromNE(iNetElement);
    }

    public boolean doesCircuitUseNetLink(INetLink iNetLink) {
        return this.getCircuitSpanFromNetLink(iNetLink) != null;
    }

    public INetCircuitSpan getCircuitSpanFromNetLink(INetLink iNetLink) {
        return (INetCircuitSpan)this.cktSpanList.get(iNetLink);
    }

    public NetCircuitSpan getCircuitSpanFromSrcCktEnd(INetCircuitEnd iNetCircuitEnd) {
        INetLink iNetLink = this.net.findNetLinkFromSourceCktEnd(this.getCircuitTypeObj().isLoCircuitType(), iNetCircuitEnd.getNetElement(), iNetCircuitEnd.getEntityIndex(), iNetCircuitEnd.getHoNum());
        if (iNetLink == null) {
            if (this.dbgOn()) {
                db.println("getCircuitSpanFromCktEnd: link not found for cktEnd");
            }
            return null;
        }
        return (NetCircuitSpan)this.getCircuitSpanFromNetLink(iNetLink);
    }

    public NetCircuitSpan getCircuitSpanFromDstCktEnd(INetCircuitEnd iNetCircuitEnd) {
        INetLink iNetLink = this.net.findNetLinkFromDestinationCktEnd(this.getCircuitTypeObj().isLoCircuitType(), iNetCircuitEnd.getNetElement(), iNetCircuitEnd.getEntityIndex(), iNetCircuitEnd.getHoNum());
        if (iNetLink == null) {
            if (this.dbgOn()) {
                db.println("getCircuitSpanFromCktEnd: link not found for cktEnd");
            }
            return null;
        }
        return (NetCircuitSpan)this.getCircuitSpanFromNetLink(iNetLink);
    }

    protected List getLinkEndpoints(INetLink iNetLink) {
        NetCircuitNode netCircuitNode;
        NetCircuitEnd netCircuitEnd;
        LinkedList<NetCircuitEnd> linkedList = new LinkedList<NetCircuitEnd>();
        if ((iNetLink.isLOTunnel() || iNetLink.isLAP()) && !this.getCircuitTypeObj().isLoCircuitType()) {
            return linkedList;
        }
        if (iNetLink.isOchTrailTunnel() && !this.getCircuitTypeObj().isOchccCircuitType()) {
            return linkedList;
        }
        if (iNetLink.isVirtual() && !this.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
            return linkedList;
        }
        Iterator iterator = this.getCktSources().iterator();
        for (int i = 0; i < 2; ++i) {
            while (iterator.hasNext()) {
                netCircuitEnd = (NetCircuitEnd)iterator.next();
                if ((netCircuitEnd.getEntityIndex() != iNetLink.getSrcEntityIndex() || netCircuitEnd.getNodeId() != iNetLink.getSrc().getNodeId() || !iNetLink.isValidSrcHoNumber(netCircuitEnd.getHoLoNum().getHoNum())) && (netCircuitEnd.getEntityIndex() != iNetLink.getDstEntityIndex() || netCircuitEnd.getNodeId() != iNetLink.getDst().getNodeId() || !iNetLink.isValidDstHoNumber(netCircuitEnd.getHoLoNum().getHoNum()))) continue;
                linkedList.add(netCircuitEnd);
            }
            iterator = this.getDropCktEnds().iterator();
        }
        if (this.getState() == 4) {
            iterator = this.getCircuitNodes().iterator();
            while (iterator.hasNext()) {
                netCircuitNode = (NetCircuitNode)iterator.next();
                netCircuitEnd = netCircuitNode.getLinkEndpoint(iNetLink);
                if (netCircuitEnd == null) continue;
                linkedList.add(netCircuitEnd);
            }
        }
        if (this.getState() == 8) {
            iterator = this.getCircuitNodes().iterator();
            while (iterator.hasNext()) {
                INetLink iNetLink2;
                netCircuitNode = (NetCircuitNode)iterator.next();
                netCircuitEnd = netCircuitNode.getRollToCktEnd();
                if (netCircuitEnd != null && ((iNetLink2 = this.net.findNetLinkFromSource(false, netCircuitEnd.getNetElement(), netCircuitEnd.getEntityIndex(), netCircuitEnd.getHoNum(), netCircuitEnd.getLoNum())) == iNetLink || iNetLink2 == iNetLink.getReverseLink())) {
                    linkedList.add(netCircuitEnd);
                }
                if ((netCircuitEnd = netCircuitNode.getRollFromCktEnd()) == null || netCircuitNode.getSpanFromCktEnd(netCircuitEnd) != null || (iNetLink2 = this.net.findNetLinkFromSource(false, netCircuitEnd.getNetElement(), netCircuitEnd.getEntityIndex(), netCircuitEnd.getHoNum(), netCircuitEnd.getLoNum())) != iNetLink && iNetLink2 != iNetLink.getReverseLink()) continue;
                linkedList.add(netCircuitEnd);
            }
        }
        return linkedList;
    }

    public synchronized void addCircuitSpan(INetLinkSpan iNetLinkSpan) {
        INetLink iNetLink = iNetLinkSpan.getLink();
        if (this.dbgOn()) {
            db.println("addCircuitSpan " + ((NetLinkSpan)iNetLinkSpan).prettyString() + " to circuit " + NetCcatCircuit.prettyString(this.circuitId));
        }
        if (this.cktSpanList.containsKey(iNetLink)) {
            if (this.dbgOn()) {
                db.println("addCircuitSpan: span already in list; ignored");
            }
            return;
        }
        NetCircuitNode netCircuitNode = (NetCircuitNode)this.getCircuitNodeFromNE(iNetLink.getSrc());
        NetCircuitNode netCircuitNode2 = (NetCircuitNode)this.getCircuitNodeFromNE(iNetLink.getDst());
        if (netCircuitNode == null) {
            netCircuitNode = NetCircuitNodeFactory.newNodeForAddSpan(iNetLink.getSrc(), this);
            this.insertCktNode(netCircuitNode);
        }
        if (netCircuitNode2 == null) {
            netCircuitNode2 = NetCircuitNodeFactory.newNodeForAddSpan(iNetLink.getDst(), this);
            this.insertCktNode(netCircuitNode2);
        }
        NetCircuitSpan netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan(this, (NetLinkSpan)iNetLinkSpan);
        netCircuitSpan.setSrcState(2);
        netCircuitSpan.setDstState(2);
        this.insertCktSpan(netCircuitSpan);
        if (!this.isBidirectional()) {
            if (iNetLinkSpan.getOmni()) {
                netCircuitNode.addRoutedSpan(netCircuitSpan, eSpanDirection.BIDIRECTIONAL);
                netCircuitNode2.addRoutedSpan(netCircuitSpan, eSpanDirection.BIDIRECTIONAL);
            } else {
                netCircuitNode.addRoutedSpan(netCircuitSpan, eSpanDirection.ORIGINATING);
                netCircuitNode2.addRoutedSpan(netCircuitSpan, eSpanDirection.TERMINATING);
            }
        } else if (this.getCircuitTypeObj().isOchncType() || this.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
            netCircuitNode.addRoutedSpan(netCircuitSpan, eSpanDirection.ORIGINATING);
            netCircuitNode2.addRoutedSpan(netCircuitSpan, eSpanDirection.TERMINATING);
        } else {
            netCircuitNode.addRoutedSpan(netCircuitSpan, eSpanDirection.BIDIRECTIONAL);
            netCircuitNode2.addRoutedSpan(netCircuitSpan, eSpanDirection.BIDIRECTIONAL);
        }
    }

    public synchronized void addCircuitSpan(NetLinkSpan netLinkSpan, NetCircuitNode netCircuitNode, eSpanDirection eSpanDirection2) {
        NetCircuitSpan netCircuitSpan = null;
        netCircuitSpan = (NetCircuitSpan)this.cktSpanList.get(netLinkSpan.getLink());
        if (netCircuitSpan == null) {
            netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan(this, netLinkSpan);
        }
        netCircuitSpan.setSrcState(2);
        netCircuitSpan.setDstState(2);
        this.insertCktSpan(netCircuitSpan);
        netCircuitNode.addRoutedSpan(netCircuitSpan, eSpanDirection2);
    }

    public synchronized void deleteCircuitSpan(NetLinkSpan netLinkSpan, NetCircuitNode netCircuitNode, eSpanDirection eSpanDirection2) {
        NetCircuitSpan netCircuitSpan = (NetCircuitSpan)this.cktSpanList.get(netLinkSpan.getLink());
        if (netCircuitSpan == null) {
            if (this.dbgOn()) {
                db.println("deleteCircuitSpan: WARNING - ckt span not found for link " + netLinkSpan.getLink().prettyString());
            }
            return;
        }
        this.removeCktSpan(netCircuitSpan);
        netCircuitNode.removeRoutedSpan(netCircuitSpan, eSpanDirection2);
    }

    public synchronized void deleteCircuitSpan(INetLinkSpan iNetLinkSpan) {
        this.removeRoutedCircuitSpan(iNetLinkSpan);
    }

    private synchronized void removeRoutedCircuitSpan(INetLinkSpan iNetLinkSpan) {
        int n;
        int n2;
        INetLink iNetLink = iNetLinkSpan.getLink();
        if (this.dbgOn()) {
            db.println("removeRoutedCircuitSpan " + iNetLinkSpan.getLink().prettyString() + " from circuit " + NetCcatCircuit.prettyString(this.circuitId));
        }
        NetCircuitNode netCircuitNode = (NetCircuitNode)this.getCircuitNodeFromNE(iNetLink.getSrc());
        NetCircuitNode netCircuitNode2 = (NetCircuitNode)this.getCircuitNodeFromNE(iNetLink.getDst());
        NetCircuitSpan netCircuitSpan = (NetCircuitSpan)this.getCircuitSpanFromNetLink(iNetLink);
        if (netCircuitSpan == null) {
            if (this.dbgOn()) {
                db.println("removeRoutedCircuitSpan: WARNING!! span not found");
            }
            return;
        }
        if (netCircuitSpan.getSrcState() != 2 && netCircuitSpan.getDstState() != 2) {
            if (this.dbgOn()) {
                db.println("removeRoutedCircuitSpan: WARNING span not ROUTED; skipping...");
            }
            return;
        }
        if (this.dbgOn()) {
            db.println("removeRoutedCircuitSpan: " + iNetLink.prettyString());
        }
        this.removeCktSpan(netCircuitSpan);
        if (!this.isBidirectional()) {
            if (netCircuitSpan.isUpsr() || netCircuitSpan.getNetLinkSpan().getOmni()) {
                netCircuitNode.removeRoutedSpan(netCircuitSpan, eSpanDirection.BIDIRECTIONAL);
                netCircuitNode2.removeRoutedSpan(netCircuitSpan, eSpanDirection.BIDIRECTIONAL);
            }
            n2 = netCircuitNode.removeRoutedSpan(netCircuitSpan, eSpanDirection.ORIGINATING);
            n = netCircuitNode2.removeRoutedSpan(netCircuitSpan, eSpanDirection.TERMINATING);
        } else {
            n2 = netCircuitNode.removeRoutedSpan(netCircuitSpan, eSpanDirection.BIDIRECTIONAL);
            n = netCircuitNode2.removeRoutedSpan(netCircuitSpan, eSpanDirection.BIDIRECTIONAL);
        }
        if (this.dbgOn()) {
            db.println("removeRoutedCircuitSpan: After remove, srcPaths=" + n2 + " dstPaths=" + n);
        }
        if (n2 == 0) {
            this.removeCktNode(netCircuitNode);
        }
        if (n == 0) {
            this.removeCktNode(netCircuitNode2);
        }
    }

    public synchronized void destroySanityCheck() throws SanityCheckFailed {
        Iterator iterator = this.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            netCircuitNode.destroySanityCheck();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyCircuit() throws IncorrectCircuitState, SanityCheckFailed, DeletionError {
        NetCcatCircuit netCcatCircuit = this;
        synchronized (netCcatCircuit) {
            if (!this.isCircuitRefValid()) {
                throw new IncorrectCircuitState("Circuit already destroyed");
            }
            List list = this.getCircuitNodes();
            NetCircuitNode netCircuitNode = null;
            if (this.dbgOn()) {
                this.debug("destroy(" + this.getCircuitName() + ", " + NetCcatCircuit.prettyString(this.circuitId) + ")");
            }
            Collections.shuffle(list);
            Iterator iterator = list.iterator();
            DeletionError deletionError = null;
            int n = 0;
            while (iterator.hasNext()) {
                netCircuitNode = (NetCircuitNode)iterator.next();
                if (this.dbgOn()) {
                    db.println("Deactivating " + netCircuitNode.getName());
                }
                try {
                    netCircuitNode.deactivate();
                }
                catch (DeletionError deletionError2) {
                    if (this.dbgOn()) {
                        db.println("deletion error exception in destroy");
                    }
                    ++n;
                    if (deletionError != null) continue;
                    deletionError = deletionError2;
                }
            }
            if (deletionError != null) {
                if (this.dbgOn()) {
                    db.println("Total of " + n + " catches");
                }
                throw deletionError;
            }
            if (this.circuitInfoActive()) {
                this.destroyCircuitInfo();
            }
        }
        this.notifyDeleted(false);
    }

    protected synchronized void dispose() {
        if (this.dbgOn()) {
            db.println("dispose circuit: " + this.getCircuitName());
        }
        super.destroy();
        this.deleteCircuitInfoObserver();
        List list = this.getCircuitNodes();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            netCircuitNode.destroy();
            this.removeCktNode(netCircuitNode);
        }
    }

    protected void sanityCheckCircuitInputs(int n) throws SanityCheckFailed {
        if (this.dbgOn()) {
            db.println("SanityCheckCircuitInputs: Circuit state: " + EnumStrings.getString((Class)INetCircuitState.class, (int)this.getState()));
        }
        if (this.getState() == 0) {
            Object object;
            INetLink iNetLink;
            int n2;
            int n3;
            Object object2;
            INetCircuitEnd iNetCircuitEnd;
            Object object3;
            int n4 = this.getUniqueNumSrcDstNodes();
            if (this.dbgOn()) {
                db.println("SanityCheckCircuitInputs:: Number of unique Nodes: " + n4);
            }
            if (n4 == 4) {
                throw new SanityCheckFailed("A Circuit cannot have 4 unique nodes  while creating the circuit");
            }
            if (n4 == 3) {
                if (this.getDrops().size() == 2 && ((NetCircuitDropInfo)this.getDrops().get(0)).getNodeId() != ((NetCircuitDropInfo)this.getDrops().get(1)).getNodeId() && !this.isBidirectional()) {
                    if (n == 0 && n == 5) {
                        throw new SanityCheckFailed("A unidirectional circuit with two drops on different nodes must be unprotected ");
                    }
                } else if (n != 9 && n != 0 && n != 5) {
                    throw new SanityCheckFailed("A Circuit must be protected,  if there are 3 unique nodes while creating the circuit");
                }
            }
            if (this.getPrimarySource() != null && this.getSecondarySource() != null && this.srcPayloadType() != this.secSrcPayloadType()) {
                throw new SanityCheckFailed("Payload types of Primary and Secondary Sources do not match");
            }
            if (this.getDropsSize() == 2) {
                object3 = this.getCktDrops();
                iNetCircuitEnd = (NetCircuitDropInfo)object3.get(0);
                object2 = (NetCircuitDropInfo)object3.get(1);
                if (this.getPayloadType(((NetCircuitDropInfo)iNetCircuitEnd).getNetCktEnd()) != this.getPayloadType(((NetCircuitDropInfo)object2).getNetCktEnd())) {
                    throw new SanityCheckFailed("Payload types of Primary and Secondary Destinations do not match");
                }
                if (((NetCircuitDropInfo)iNetCircuitEnd).getNodeId() == ((NetCircuitDropInfo)object2).getNodeId() && n == 5 && n4 != 1) {
                    throw new SanityCheckFailed("Two Drops on same node not allowed for DRI circuits");
                }
            }
            if (this.getSourcesSize() == 2) {
                int n5;
                int n6 = this.getPrimarySource().getNodeId();
                if (n6 != (n5 = this.getSecondarySource().getNodeId()) && this.useLAP() != null) {
                    throw new SanityCheckFailed("Utilizing a VC/VT aggregation circuit is not supported");
                }
                if (n6 == n5 && n == 5 && n4 != 1) {
                    throw new SanityCheckFailed("Two Sources on same node not allowed for DRI circuits");
                }
            }
            if (this.getDropsSize() == 2 && (n3 = ((NetCircuitDropInfo)(object3 = this.getCktDrops()).get(0)).getNodeId()) != (n2 = ((NetCircuitDropInfo)object3.get(1)).getNodeId()) && this.useLAP() != null) {
                throw new SanityCheckFailed("Utilizing a VC/VT aggregation circuit is not supported");
            }
            if (this.isMonitorCircuit()) {
                if (this.dbgOn()) {
                    db.println("SanityCheckCircuitInputs: Monitor Circuit");
                }
                return;
            }
            object3 = this.getPrimarySource();
            iNetCircuitEnd = this.getPrimaryDrop();
            object2 = null;
            INetLink iNetLink2 = null;
            if (object3 != null) {
                object2 = this.net.findNetLinkFromSource(false, object3.getNetElement(), object3.getEntityIndex(), object3.getHoNum(), object3.getLoNum());
            }
            if (iNetCircuitEnd != null) {
                iNetLink2 = this.net.findNetLinkFromSource(false, iNetCircuitEnd.getNetElement(), iNetCircuitEnd.getEntityIndex(), iNetCircuitEnd.getHoNum(), iNetCircuitEnd.getLoNum());
            }
            LinkedList<Object> linkedList = new LinkedList<Object>();
            if (object2 != null) {
                if (this.dbgOn()) {
                    db.println("Found a netLink for Source End point: " + object2.prettyString());
                }
                if ((iNetLink = this.net.findReverseLink((INetLink)object2)) != null) {
                    if (this.dbgOn()) {
                        db.println("Found reverse netLink for Source End point: " + iNetLink.prettyString());
                    }
                    if (object2.getProtectionType() == 4 || object2.getProtectionType() == 0) {
                        object = new NetLinkSpan((INetLink)object2, iNetLink, object3.getHoNum(), object3.getHoNum(), object3.getLoNum());
                        linkedList.add(object);
                        if (this.dbgOn()) {
                            db.println("SanityCheckCircuitInputs: Adding: " + ((NetLinkSpan)object).prettyString());
                        }
                    }
                }
            }
            if (iNetLink2 != null) {
                if (this.dbgOn()) {
                    db.println("Found a netLink for Destination End point: " + iNetLink2.prettyString());
                }
                if ((iNetLink = this.net.findReverseLink(iNetLink2)) != null) {
                    if (this.dbgOn()) {
                        db.println("Found reverse netLink for Destination End point: " + iNetLink.prettyString());
                    }
                    if (iNetLink2.getProtectionType() == 4 || iNetLink2.getProtectionType() == 0) {
                        if (object2 != null && ((NetLink)object2).blsrRingName().equals(((NetLink)iNetLink2).blsrRingName())) {
                            object = NetCircuitNode.getTDMTerminology(object3.getNodeModel()).getRingTerms(1);
                            if (!object3.getHoNum().equals(iNetCircuitEnd.getHoNum())) {
                                throw new SanityCheckFailed("Both end points are on same " + (String)object + " trunk ports. Time Slots must match");
                            }
                            if (object3.getLoNum() != null && iNetCircuitEnd.getLoNum() != null && !object3.getLoNum().equals(iNetCircuitEnd.getLoNum())) {
                                throw new SanityCheckFailed("Both end points are on same " + (String)object + " trunk ports. Time Slots must match");
                            }
                        }
                        object = new NetLinkSpan(iNetLink2, iNetLink, iNetCircuitEnd.getHoNum(), iNetCircuitEnd.getHoNum(), iNetCircuitEnd.getLoNum());
                        linkedList.add(object);
                        if (this.dbgOn()) {
                            db.println("SanityCheckCircuitInputs: Adding: " + ((NetLinkSpan)object).prettyString());
                        }
                    }
                }
            }
            if (linkedList.size() > 0) {
                if (this.dbgOn()) {
                    db.println("SanityCheckCircuitInputs:: Adding Spans: " + linkedList.size());
                }
                this.memberPrefs.addRequiredSpans(linkedList);
            }
        }
    }

    protected void sanityCheckBlsrDri(Map map) throws SanityCheckFailed {
        ArrayList arrayList = new ArrayList();
        boolean bl = false;
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            if (netCircuitNode.getState() == 3 && netCircuitNode.isBlsrDriHandoff()) {
                throw new SanityCheckFailed("BLSR DRI handoff connection modification unsupported on node " + netCircuitNode.getName());
            }
            if (netCircuitNode.hasInvalidBlsrDriSelector() || netCircuitNode.hasInvalidOpenEndedOnewayBlsrDri()) {
                throw new SanityCheckFailed("DRI handoff " + netCircuitNode.getName() + " failed protection validation");
            }
            netCircuitNode.validateBlsrDriPcaSpans(arrayList);
            bl |= netCircuitNode.hasBlsrDriSelector();
        }
        if (!bl && this.hasBlsrDri() && this.getSourcesSize() == 1 && this.getDropsSize() == 1) {
            throw new SanityCheckFailed("BLSR DRI handoff lacks BLSR input protection");
        }
    }

    public synchronized LinkedList sanityCheckSRGs() throws SanityCheckFailed {
        if (this.dbgOn()) {
            db.println("calling sanityCheckSRGs");
        }
        if (!this.isCircuitRefValid()) {
            throw new SanityCheckFailed("Circuit already destroyed");
        }
        LinkedList linkedList = new LinkedList();
        if (!this.srcNodeModel.provides(Feature.UPSR_SLOTDIV_NR)) {
            linkedList = RouteValidator.instance().getSrgFailureList(this.getCircuitSpans());
        }
        if (this.dbgOn()) {
            db.println("sanityCheckSRGs got " + linkedList.size() + " violations");
        }
        return linkedList;
    }

    public synchronized LinkedList sanityCheckBridgeRollSRGs(List list) throws SanityCheckFailed {
        if (this.dbgOn()) {
            db.println("calling sanityCheckBridgeRollSRGs");
        }
        if (!this.isCircuitRefValid()) {
            throw new SanityCheckFailed("Circuit already destroyed");
        }
        LinkedList linkedList = new LinkedList();
        if (!this.srcNodeModel.provides(Feature.UPSR_SLOTDIV_NR)) {
            linkedList = RouteValidator.instance().getSrgFailureList(list);
        }
        if (this.dbgOn()) {
            db.println("sanityCheckSRGs got " + linkedList.size() + " violations");
        }
        return linkedList;
    }

    public synchronized void sanityCheckManualRouting() throws SanityCheckFailed {
        if (this.dbgOn()) {
            db.println("calling sanityCheckManualRouting");
        }
        try {
            NetCircuitNode netCircuitNode;
            if (!this.isCircuitRefValid()) {
                throw new SanityCheckFailed("Circuit already destroyed");
            }
            if (this.getRoutedCircuitSpans().size() == 0 && this.getCircuitNodes().size() != 1) {
                throw new SanityCheckFailed("The \"Included Spans\" list does not route to the drop");
            }
            int n = this.memberPrefs == null ? 9 : this.memberPrefs.getPathProtection();
            this.sanityCheckCircuitInputs(n);
            this.sanityCheckBlsrDriHandoffs();
            Iterator iterator = this.getCircuitNodes().iterator();
            while (iterator.hasNext()) {
                netCircuitNode = (NetCircuitNode)iterator.next();
                int n2 = netCircuitNode.sanityCheckGetConnType();
                netCircuitNode.setConnectionType(n2);
                netCircuitNode.setupConnListOnCreation(n2);
            }
            iterator = this.getCircuitNodes().iterator();
            while (iterator.hasNext()) {
                netCircuitNode = (NetCircuitNode)iterator.next();
                netCircuitNode.findUpsrHeads();
            }
            this.sanityCheckBlsrDri(this.cktNodeList);
            RouteValidator.instance().validateRoute(this);
        }
        catch (SanityCheckFailed sanityCheckFailed) {
            if (this.getState() != 3) {
                Iterator iterator = this.getCircuitNodes().iterator();
                while (iterator.hasNext()) {
                    NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
                    netCircuitNode.resetDriNodeType();
                    if (!this.dbgOn()) continue;
                    db.println("resetting DRI node type of " + netCircuitNode);
                }
            }
            throw sanityCheckFailed;
        }
    }

    public synchronized void sanityCheckBridgeRollRouting(List list, List list2, List list3, RoutePrefs routePrefs) throws SanityCheckFailed {
        Object object;
        if (!this.routeEqual(list)) {
            if (this.dbgOn()) {
                db.println("calling sanityCheckBridgeRollRouting");
            }
            if (!this.isCircuitRefValid()) {
                throw new SanityCheckFailed("Circuit already destroyed");
            }
            this.setMemberPrefs(routePrefs.getFwdDropPrefs().getFirstMemberGroupPrefs().getMemberPrefs());
            Map<INetElement, NetCircuitNode> map = Collections.synchronizedMap(new TreeMap(new NetElemComparator()));
            Iterator iterator = list3.iterator();
            while (iterator.hasNext()) {
                NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
                map.put(netCircuitNode.getNetElement(), netCircuitNode);
            }
            this.sanityCheckBlsrDri(map);
            RouteValidator.instance().validateRoute(this, list2, list3, this.getMemberPrefs());
            if (this.isMemberOfVcat()) {
                this.getVcatGroup().sanityCheckVcatRoutingPref(this, list2);
            }
            if (this.getMemberPrefs().getPathProtection() == 0) {
                boolean bl = this.isOldRouteUPSR(list);
                iterator = list2.iterator();
                while (iterator.hasNext()) {
                    NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
                    if (bl) {
                        if (netCircuitSpan.isUpsr()) continue;
                        throw new SanityCheckFailed("Path specified is not UPSR protected. Check span " + netCircuitSpan.getLink().prettyString());
                    }
                    if (NetProtectionType.isProtectedType(netCircuitSpan.getProtectionType())) continue;
                    throw new SanityCheckFailed("Path specified is not protected. Check span " + netCircuitSpan.getLink().prettyString());
                }
            }
            return;
        }
        if (this.dbgOn()) {
            db.println("calling sanityCheckBridgeRollRouting on end-to-end circuit roll");
        }
        CircuitCreatInfo circuitCreatInfo = new CircuitCreatInfo(this.getCircuitType(), this.getCircuitSize(), this.getCircuitDir());
        NetCcatCircuit netCcatCircuit = (NetCcatCircuit)NetCircuitFactory.newCircuit(circuitCreatInfo, this.getPrimarySource());
        try {
            netCcatCircuit.addDrop(this.getPrimaryDrop(), routePrefs);
        }
        catch (Exception exception) {
            if (this.dbgOn()) {
                db.println("sanityCheckBridgeRollRouting: clone a new circuit hits exception when adding drop");
            }
            throw new SanityCheckFailed("clone a new circuit on adding drop failed");
        }
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            object = (NetCircuitSpan)iterator.next();
            netCcatCircuit.insertCktSpan((NetCircuitSpan)object);
            ((NetCircuitSpan)object).setCircuit(netCcatCircuit);
        }
        iterator = list3.iterator();
        while (iterator.hasNext()) {
            object = (NetCircuitNode)iterator.next();
            netCcatCircuit.insertCktNode((NetCircuitNode)object);
            ((NetCircuitNode)object).setCircuit(netCcatCircuit);
        }
        netCcatCircuit.setMemberPrefs(routePrefs.getFwdDropPrefs().getFirstMemberGroupPrefs().getMemberPrefs());
        netCcatCircuit.sanityCheckBlsrDriHandoffs();
        iterator = list3.iterator();
        while (iterator.hasNext()) {
            object = (NetCircuitNode)iterator.next();
            int n = ((NetCircuitNode)object).sanityCheckGetConnType();
            ((NetCircuitNode)object).setConnectionType(n);
            ((NetCircuitNode)object).setupConnListOnCreation(n);
        }
        iterator = list3.iterator();
        while (iterator.hasNext()) {
            object = (NetCircuitNode)iterator.next();
            ((NetCircuitNode)object).findUpsrHeads();
        }
        object = new TreeMap(new NetElemComparator());
        iterator = list3.iterator();
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            object.put(netCircuitNode.getNetElement(), netCircuitNode);
        }
        netCcatCircuit.sanityCheckBlsrDri((Map)object);
        RouteValidator.instance().validateRoute(netCcatCircuit, list2, list3, this.getMemberPrefs());
        if (this.isMemberOfVcat()) {
            this.getVcatGroup().sanityCheckVcatRoutingPref(netCcatCircuit, list2);
        }
        netCcatCircuit.sanityCheck();
    }

    public boolean isOldRouteUPSR(List list) {
        boolean bl = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            if (netCircuitSpan.getProtectionType() == 12 || netCircuitSpan.getProtectionType() == 17 && netCircuitSpan.getLink().getProtectionType() == 3) {
                bl = true;
                continue;
            }
            bl = false;
            break;
        }
        return bl;
    }

    private boolean canNodeBeRemoved(NetCircuitNode netCircuitNode, List list) {
        List list2 = netCircuitNode.getAllSpansList();
        Iterator iterator = list2.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            if (list.contains(netCircuitSpan)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private void consolidateOldAndNewNode(NetCircuitNode netCircuitNode, HashMap hashMap, NetCircuitNode netCircuitNode2) {
        if (this.dbgOn()) {
            this.debug("consolidateOldAndNewNode, oldNode = " + netCircuitNode.getName() + " newNode = " + netCircuitNode2.getName());
        }
        HashMap hashMap2 = netCircuitNode.getAllSpans();
        Iterator iterator = hashMap2.keySet().iterator();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            if (hashMap.containsKey(netCircuitSpan.getLink())) continue;
            if (netCircuitSpan.getOmni()) {
                netCircuitNode2.addRoutedSpan(netCircuitSpan, eSpanDirection.BIDIRECTIONAL);
                continue;
            }
            if (!this.isBidirectional() && !netCircuitNode.isDriSpan(netCircuitSpan) && (eSpanDirection)hashMap2.get(netCircuitSpan) == eSpanDirection.BIDIRECTIONAL) {
                if (netCircuitSpan.getLink().getDst() == netCircuitNode.getNetElement()) {
                    netCircuitNode2.addRoutedSpan(netCircuitSpan, eSpanDirection.TERMINATING);
                    continue;
                }
                netCircuitNode2.addRoutedSpan(netCircuitSpan, eSpanDirection.ORIGINATING);
                continue;
            }
            netCircuitNode2.addRoutedSpan(netCircuitSpan, (eSpanDirection)hashMap2.get(netCircuitSpan));
        }
        if (this.dbgOn()) {
            this.debug("old node has num of inSpans " + netCircuitNode.inSpans().size());
            this.debug("new node has total num of inSpans " + netCircuitNode2.inSpans().size());
            this.debug("old node has num of outSpans " + netCircuitNode.outSpans().size());
            this.debug("new node has total num of outSpans " + netCircuitNode2.outSpans().size());
            this.debug("old node has num of biSpans " + netCircuitNode.biSpans().size());
            this.debug("new node has total num of biSpans " + netCircuitNode2.biSpans().size());
        }
    }

    public synchronized void getNewSpanAndNodeList(List list, List list2, List list3, List list4) {
        NetCircuitNode netCircuitNode;
        NetCircuitNode netCircuitNode2;
        Iterator<Object> iterator;
        Object object;
        Object object2;
        if (this.dbgOn()) {
            int n;
            db.println("calling getNewSpanAndNodeList with newRoute and oldRoute");
            db.println("new route contains following spans : ");
            for (n = 0; n < list.size(); ++n) {
                object2 = (NetCircuitSpan)list.get(n);
                db.println("span " + n + " is : " + ((NetCircuitSpan)object2).prettyString());
            }
            db.println("old route contains following spans : ");
            for (n = 0; n < list2.size(); ++n) {
                object2 = (NetCircuitSpan)list2.get(n);
                db.println("span " + n + " is : " + ((NetCircuitSpan)object2).prettyString());
            }
        }
        HashMap<INetLink, NetCircuitSpan> hashMap = new HashMap<INetLink, NetCircuitSpan>();
        object2 = new HashMap();
        NetCircuitNode netCircuitNode3 = null;
        NetCircuitNode netCircuitNode4 = null;
        NetCircuitSpan netCircuitSpan = null;
        INetLink iNetLink = null;
        Iterator iterator2 = list.iterator();
        while (iterator2.hasNext()) {
            netCircuitSpan = (NetCircuitSpan)iterator2.next();
            iNetLink = netCircuitSpan.getLink();
            netCircuitSpan.setSrcState(2);
            netCircuitSpan.setDstState(2);
            netCircuitNode3 = (NetCircuitNode)((HashMap)object2).get(iNetLink.getSrc());
            if (netCircuitNode3 == null) {
                netCircuitNode3 = NetCircuitNodeFactory.newNodeForAddSpan(iNetLink.getSrc(), this);
                ((HashMap)object2).put(iNetLink.getSrc(), netCircuitNode3);
            }
            if ((netCircuitNode4 = (NetCircuitNode)((HashMap)object2).get(iNetLink.getDst())) == null) {
                netCircuitNode4 = NetCircuitNodeFactory.newNodeForAddSpan(iNetLink.getDst(), this);
                ((HashMap)object2).put(iNetLink.getDst(), netCircuitNode4);
            }
            if (!this.isBidirectional()) {
                if (netCircuitSpan.getOmni()) {
                    netCircuitNode3.addRoutedSpan(netCircuitSpan, eSpanDirection.BIDIRECTIONAL);
                    netCircuitNode4.addRoutedSpan(netCircuitSpan, eSpanDirection.BIDIRECTIONAL);
                } else {
                    netCircuitNode3.addRoutedSpan(netCircuitSpan, eSpanDirection.ORIGINATING);
                    netCircuitNode4.addRoutedSpan(netCircuitSpan, eSpanDirection.TERMINATING);
                }
            } else {
                netCircuitNode3.addRoutedSpan(netCircuitSpan, eSpanDirection.BIDIRECTIONAL);
                netCircuitNode4.addRoutedSpan(netCircuitSpan, eSpanDirection.BIDIRECTIONAL);
            }
            hashMap.put(iNetLink, netCircuitSpan);
        }
        HashMap<INetLink, NetCircuitSpan> hashMap2 = new HashMap<INetLink, NetCircuitSpan>();
        HashMap<INetElement, INetCircuitNode> hashMap3 = new HashMap<INetElement, INetCircuitNode>();
        NetCircuitNode netCircuitNode5 = null;
        NetCircuitNode netCircuitNode6 = null;
        NetCircuitSpan netCircuitSpan2 = null;
        iterator2 = list2.iterator();
        while (iterator2.hasNext()) {
            netCircuitSpan2 = (NetCircuitSpan)iterator2.next();
            iNetLink = netCircuitSpan2.getLink();
            netCircuitNode5 = (NetCircuitNode)hashMap3.get(iNetLink.getSrc());
            if (netCircuitNode5 == null) {
                hashMap3.put(iNetLink.getSrc(), this.getCircuitNodeFromNE(iNetLink.getSrc()));
            }
            if ((netCircuitNode6 = (NetCircuitNode)hashMap3.get(iNetLink.getDst())) == null) {
                hashMap3.put(iNetLink.getDst(), this.getCircuitNodeFromNE(iNetLink.getDst()));
            }
            hashMap2.put(iNetLink, netCircuitSpan2);
        }
        List list5 = this.getCircuitSpans();
        Iterator<Object> iterator3 = list5.iterator();
        while (iterator3.hasNext()) {
            object = (NetCircuitSpan)iterator3.next();
            if (!list2.contains(object)) continue;
            iterator3.remove();
        }
        iterator3 = list5.iterator();
        while (iterator3.hasNext()) {
            object = (NetCircuitSpan)iterator3.next();
            if (this.dbgOn()) {
                this.debug("remaining span " + ((NetCircuitSpan)object).prettyString() + " is added to spanlist");
            }
            iterator = NetCircuitSpanFactory.createCircuitSpan(this, (NetLinkSpan)((NetCircuitSpan)object).getNetLinkSpan());
            netCircuitNode2 = (NetCircuitNode)this.getCircuitNodeFromNE(((NetCircuitSpan)object).getLink().getSrc());
            netCircuitNode = (NetCircuitNode)this.getCircuitNodeFromNE(((NetCircuitSpan)object).getLink().getDst());
            if (((NetCircuitSpan)object).getLink().getProtectionType() == 3) {
                if (netCircuitNode2.getDri() && netCircuitNode2.isDriSpan((NetCircuitSpan)object) || netCircuitNode.getDri() && netCircuitNode.isDriSpan((NetCircuitSpan)object)) {
                    if (this.dbgOn()) {
                        this.debug("set span " + ((NetCircuitSpan)object).prettyString() + " as omni");
                    }
                    ((NetCircuitSpan)object).getNetLinkSpan().setOmni(true);
                }
                ((NetCircuitSpan)((Object)iterator)).setUpsrLink(((NetCircuitSpan)object).getUpsrLink());
            }
            ((NetCircuitSpan)((Object)iterator)).setSrcState(2);
            ((NetCircuitSpan)((Object)iterator)).setDstState(2);
            list3.add(iterator);
        }
        iterator3 = hashMap.values().iterator();
        while (iterator3.hasNext()) {
            object = (NetCircuitSpan)iterator3.next();
            if (this.dbgOn()) {
                this.debug("new span " + ((NetCircuitSpan)object).prettyString() + " is added to spanlist");
            }
            list3.add(object);
        }
        object = this.getCircuitNodes();
        iterator = object.iterator();
        while (iterator.hasNext()) {
            netCircuitNode2 = (NetCircuitNode)iterator.next();
            if (!this.canNodeBeRemoved(netCircuitNode2, list2)) continue;
            iterator.remove();
        }
        iterator = object.iterator();
        while (iterator.hasNext()) {
            netCircuitNode2 = (NetCircuitNode)iterator.next();
            netCircuitNode = (NetCircuitNode)((HashMap)object2).get(netCircuitNode2.getNetElement());
            if (netCircuitNode != null) {
                this.consolidateOldAndNewNode(netCircuitNode2, hashMap2, netCircuitNode);
                continue;
            }
            if (this.dbgOn()) {
                this.debug("orig node " + netCircuitNode2.getName() + " is added to nodelist");
            }
            list4.add(netCircuitNode2);
        }
        iterator = ((HashMap)object2).values().iterator();
        while (iterator.hasNext()) {
            netCircuitNode2 = (NetCircuitNode)iterator.next();
            netCircuitNode = (NetCircuitNode)hashMap3.get(netCircuitNode2.getNetElement());
            if (netCircuitNode != null) {
                NetCircuitEnd netCircuitEnd;
                Iterator iterator4 = netCircuitNode.getSources().iterator();
                while (iterator4.hasNext()) {
                    netCircuitEnd = (NetCircuitEnd)iterator4.next();
                    netCircuitNode2.insertSource(netCircuitEnd);
                }
                iterator4 = netCircuitNode.getDrops().iterator();
                while (iterator4.hasNext()) {
                    netCircuitEnd = (NetCircuitEnd)iterator4.next();
                    netCircuitNode2.insertDrop(netCircuitEnd);
                }
            }
            if (this.dbgOn()) {
                this.debug("new node " + netCircuitNode2.getName() + " is added to nodelist");
            }
            list4.add(netCircuitNode2);
        }
    }

    public synchronized void sanityCheck() throws SanityCheckFailed {
        NetCircuitNode netCircuitNode;
        boolean bl = false;
        if (this.dbgOn()) {
            this.debug("sanityCheck: called for " + this.getCircuitName());
        }
        if (!this.isCircuitRefValid()) {
            throw new SanityCheckFailed("Circuit already destroyed");
        }
        int n = 0;
        int n2 = 0;
        Iterator iterator = this.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            netCircuitNode = (NetCircuitNode)iterator.next();
            int n3 = netCircuitNode.sanityCheck();
            netCircuitNode.setupConnListOnCreation(n3);
            if (n3 == 10) {
                if (netCircuitNode.isConnPartofBlsrDri()) continue;
                ++n;
                continue;
            }
            if (n3 != 11) continue;
            ++n2;
        }
        this.markUpsr();
        this.markDri();
        if (n % 2 != 0 || n2 % 2 != 0) {
            throw new SanityCheckFailed("Invalid number of DRI/IDRI nodes. DRI=" + n + ". IDRI=" + n2);
        }
        if (this.getDropsSize() == 1 && this.getSourcesSize() == 1 && !this.hasBlsrDri() && n % 4 != 0) {
            throw new SanityCheckFailed("Invalid number of DRI nodes " + n + ". Single source, single destination circuits should have multiple of 4 DRI Nodes");
        }
        iterator = this.getCktDrops().iterator();
        while (iterator.hasNext()) {
            NetCircuitDropInfo netCircuitDropInfo = (NetCircuitDropInfo)iterator.next();
            if (this.getCktOperation() != 5 && netCircuitDropInfo.getNetCktEnd().getStage() != 2 || netCircuitDropInfo.getPathProt() != 0) continue;
            bl = true;
            break;
        }
        if (!bl) {
            if (this.dbgOn()) {
                db.println("SanityCheck: passed for unprotected circuit " + this.getCircuitName());
            }
            return;
        }
        if (this.isUpsr1wayTl1()) {
            this.sanityCheckSelectorDropProtection();
        }
        iterator = this.getCircuitSpans().iterator();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            int n4 = netCircuitSpan.getProtectionType();
            if (NetProtectionType.isProtectedType(n4)) continue;
            if (this.dbgOn()) {
                db.println("SanityCheck: Path protection not available to outstanding drops. Protection type " + EnumStrings.getString((Class)INetProtectionType.class, (int)n4));
            }
            throw new SanityCheckFailed("Path specified is not protected. Check span " + netCircuitSpan.getLink().prettyString());
        }
        iterator = this.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            netCircuitNode = (NetCircuitNode)iterator.next();
            if (!netCircuitNode.hasUnprotectedSelector()) continue;
            throw new SanityCheckFailed("Selector connection on node " + netCircuitNode.getName() + " is unprotected");
        }
        if (this.dbgOn()) {
            db.println("SanityCheck: passed for " + this.getCircuitName());
        }
    }

    protected void sanityCheckSelectorDropProtection() throws SanityCheckFailed {
        Iterator iterator = this.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            if (netCircuitNode.getState() != 0 && netCircuitNode.getState() != 3 || netCircuitNode.sanityCheckSelectorDropProtection()) continue;
            throw new SanityCheckFailed("Selector drop on " + netCircuitNode.getName() + " lacks two valid input paths");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void provision() throws NoRoute, ConnTypeUnsupported, SanityCheckFailed, CircuitProvError, AnnotatedException {
        boolean bl = false;
        NetCcatCircuit netCcatCircuit = this;
        synchronized (netCcatCircuit) {
            List list = this.getCircuitNodes();
            if (this.dbgOn()) {
                db.println("provision called for " + this.getCircuitName() + ". Id = " + NetCcatCircuit.prettyString(this.circuitId));
            }
            if (!this.isCircuitRefValid()) {
                throw new CircuitProvError("Circuit already destroyed");
            }
            if (this.state != 0 && this.state != 3 && this.state != 11) {
                throw new CircuitProvError("Invalid state for provision");
            }
            JobController jobController = this.ncMgr.getCreateJc();
            if (jobController == null) {
                throw new CircuitProvError("Unable to get Job Controller");
            }
            if (!jobController.isIdle()) {
                throw new CircuitProvError("Job Controller not idle!");
            }
            if (this.getState() == 0) {
                if (this.tl1Compatible()) {
                    if (!this.tl1InfoActive()) {
                        this.createTl1Info();
                        bl = true;
                    }
                } else if (!this.circuitInfoActive()) {
                    this.createCircuitInfo(this.srcNodeModel, this.circuitInfo);
                    bl = true;
                }
            }
            if (this.isMemberOfVcat() && this.adminState == 4) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
                    if (netCircuitNode.getNodeModel() == this.getPrimarySource().getNodeModel() || netCircuitNode.getNodeModel() == this.getPrimaryDrop().getNodeModel()) continue;
                    netCircuitNode.adminState = 2;
                }
            }
            Object[] objectArray = list.toArray();
            IJobControl[] iJobControlArray = new IJobControl[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                iJobControlArray[i] = new NetCircuitCreateWorker((NetCircuitNode)objectArray[i]);
            }
            JobGroup jobGroup = new JobGroup(iJobControlArray, (IJobGroupListener)this, null);
            this.createDone = false;
            jobController.submitJob(jobGroup);
            while (!this.createDone) {
                Object object = this.threadWaitObject;
                synchronized (object) {
                    block40: {
                        try {
                            this.threadWaitObject.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            if (!this.dbgOn()) break block40;
                            db.println("provision: InterruptedException");
                        }
                    }
                }
            }
            JobStatus[] jobStatusArray = jobGroup.getJobStatusList();
            for (int i = 0; i < jobStatusArray.length; ++i) {
                block41: {
                    if (jobStatusArray[i].value() != 2) continue;
                    try {
                        if (!this.isMemberOfVcat()) {
                            this.tentative2Routed();
                        }
                    }
                    catch (DeletionError deletionError) {
                        if (this.dbgOn()) {
                            db.println("tentative2Routed encountered exception " + deletionError.getMessage());
                        }
                    }
                    catch (IncorrectCircuitState incorrectCircuitState) {
                        if (!this.dbgOn()) break block41;
                        db.println("tentative2Routed encountered exception " + incorrectCircuitState.getMessage());
                    }
                }
                throw (AnnotatedException)((Object)jobStatusArray[i].getResult());
            }
            if (this.circuitInfoActive()) {
                try {
                    this.addDropToCircuitInfo();
                }
                catch (CircuitProvError circuitProvError) {
                    block42: {
                        try {
                            if (!this.isMemberOfVcat()) {
                                this.tentative2Routed();
                            }
                        }
                        catch (DeletionError deletionError) {
                            if (this.dbgOn()) {
                                db.println("tentative2Routed encountered exception " + deletionError.getMessage());
                            }
                        }
                        catch (IncorrectCircuitState incorrectCircuitState) {
                            if (!this.dbgOn()) break block42;
                            db.println("tentative2Routed encountered exception " + incorrectCircuitState.getMessage());
                        }
                    }
                    throw circuitProvError;
                }
            }
            if (!this.isMemberOfVcat()) {
                this.tentative2Active();
            }
        }
        if (bl) {
            this.clearChanged();
            if (!this.isMemberOfVcat()) {
                this.ncMgr.notifyChanged(this);
            }
        } else {
            this.notifyChanged(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List addDropToCircuitInfo() throws CircuitProvError {
        List list = super.addDropToCircuitInfo();
        if (this.isMemberOfVcat()) {
            List list2 = this.prevDropList;
            synchronized (list2) {
                Iterator iterator = this.prevDropList.iterator();
                while (iterator.hasNext()) {
                    NetCircuitDropInfo netCircuitDropInfo = (NetCircuitDropInfo)iterator.next();
                    try {
                        if (this.dbgOn()) {
                            db.println("try to cleanup previously added circuit drop from member circuit (" + this.getCircuitName() + ", " + NetCcatCircuit.prettyString(this.circuitId) + ")");
                        }
                        this.circuitModel.delDrop(netCircuitDropInfo.getNetCktEnd().getCircuitEnd());
                        iterator.remove();
                    }
                    catch (CannotDeleteLastDrop cannotDeleteLastDrop) {
                        if (!this.dbgOn()) continue;
                        db.println("Cannot del. last drop while deleting drop from prevDropList");
                    }
                    catch (AbstractCmsIOException abstractCmsIOException) {
                        if (!this.dbgOn()) continue;
                        db.println("Unexpected exception while deleting drop from prevDropList");
                    }
                }
                this.prevDropList.addAll(list);
            }
        }
        return list;
    }

    protected boolean setSrcCircuitNode() {
        if (this.dbgOn()) {
            db.println("setSrcCircuitNode()");
        }
        if (this.getSourcesSize() == 0) {
            if (this.dbgOn()) {
                db.println("setSrcCircuitNode: source list is empty!");
            }
            this.srcCircuitNode = null;
            return false;
        }
        NetCircuitEnd netCircuitEnd = (NetCircuitEnd)this.getPrimarySource();
        INetElement iNetElement = netCircuitEnd.getNetElement();
        if (iNetElement == null) {
            if (this.dbgOn()) {
                db.println("setSrcCircuitNode: Unable to find NE in the network");
            }
            this.srcCircuitNode = null;
            return false;
        }
        this.srcNodeModel = iNetElement.getNodeModel();
        this.srcCircuitNode = (NetCircuitNode)this.getCircuitNodeFromNE(iNetElement);
        if (this.srcCircuitNode == null) {
            if (this.dbgOn()) {
                db.println("setSrcCircuitNode: Unable to find srcCircuitNode => " + iNetElement.getHostName());
            }
            return false;
        }
        String string = this.getCircuitNameFromSrcNode();
        this.updateCircuitName(string);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List createNewCircuitModel(String string) throws CircuitProvError, SanityCheckFailed {
        NetCcatCircuit netCcatCircuit = this;
        synchronized (netCcatCircuit) {
            if (!this.setSrcCircuitNode()) {
                throw new SanityCheckFailed("Source of circuit unknown.");
            }
            int n = this.isCircuitProtected() ? 0 : 2;
            Iterator iterator = this.getCktDrops().iterator();
            while (iterator.hasNext()) {
                NetCircuitDropInfo netCircuitDropInfo = (NetCircuitDropInfo)iterator.next();
                netCircuitDropInfo.setPathProt(n);
            }
            this.updateCircuitDropInfo();
            if (string != null) {
                this.setCircuitName(string);
            }
            this.createCircuitInfo(this.srcNodeModel, this.circuitInfo);
            if (this.dbgOn()) {
                this.debug("upgrade(): Allocated circuitID: " + NetCcatCircuit.prettyString(this.circuitId));
            }
            LinkedList<NetCircuitNode> linkedList = new LinkedList<NetCircuitNode>();
            iterator = this.getCircuitNodes().iterator();
            HashMap<NetCircuitNode, Object[]> hashMap = new HashMap<NetCircuitNode, Object[]>();
            while (iterator.hasNext()) {
                NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
                Object[] objectArray = new Object[2];
                objectArray[0] = NetCircuitNode.getConnCircuitId(netCircuitNode.getConn());
                objectArray[1] = netCircuitNode.getConnName();
                hashMap.put(netCircuitNode, objectArray);
                try {
                    netCircuitNode.setConnectionCircuitId(this.circuitId);
                    netCircuitNode.cleanupSpliceListeners();
                    if (string == null) continue;
                    netCircuitNode.setConnName(string);
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    linkedList.add(netCircuitNode);
                    Iterator iterator2 = hashMap.keySet().iterator();
                    while (iterator2.hasNext()) {
                        NetCircuitNode netCircuitNode2 = (NetCircuitNode)iterator2.next();
                        if (netCircuitNode2 == netCircuitNode) continue;
                        Object[] objectArray2 = (Object[])hashMap.get(netCircuitNode2);
                        netCircuitNode2.setConnectionCircuitId((ICircuitId)objectArray2[0]);
                        netCircuitNode2.setConnName((String)objectArray2[1]);
                    }
                    return linkedList;
                }
            }
            if (linkedList.size() != 0) {
                return linkedList;
            }
            this.setState(1);
            this.setCktOperation(0);
            this.completeCheck();
            if (this.dbgOn()) {
                this.debug("createNewCircuitModel() successful for " + this.getCircuitName());
            }
        }
        this.notifyChanged();
        return new LinkedList();
    }

    protected void addNeForAddNode(INetElement iNetElement) throws IncorrectCircuitState {
        if (this.dbgOn()) {
            db.println("Adding a Network Element to circuit");
        }
        if (this.getState() != 4 && this.getState() != 5 && this.getState() != 6) {
            throw new IncorrectCircuitState("Invalid circuit state for addition of new node");
        }
        NetCircuitNode netCircuitNode = (NetCircuitNode)this.getCircuitNodeFromNE(iNetElement);
        if (netCircuitNode == null) {
            netCircuitNode = NetCircuitNodeFactory.newNodeForAddSpan(iNetElement, this);
            if (netCircuitNode.getAdminState() == 4) {
                netCircuitNode.setAdminState(2);
            }
        } else {
            throw new IncorrectCircuitState("Circuit node already in circuit");
        }
        this.insertCktNode(netCircuitNode);
    }

    protected boolean isBiDirSpanKnown(NetCircuitSpan netCircuitSpan) {
        return this.cktSpanList.containsKey(netCircuitSpan.getLink()) || this.cktSpanList.containsKey(netCircuitSpan.getReverseLink());
    }

    protected synchronized void updateCircuitNodeConnectionPaths() {
        Iterator iterator = this.getCircuitNodes().iterator();
        if (this.dbgOn()) {
            db.println("updateCircuitNodeConnectionPaths: updating NCN Connection Paths");
        }
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            netCircuitNode.updateConnectionPathEnds();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected synchronized boolean unify(NetCcatCircuit netCcatCircuit) {
        NetCircuitNode netCircuitNode;
        Object object;
        block37: {
            block38: {
                NetCcatCircuit netCcatCircuit2 = netCcatCircuit;
                // MONITORENTER : netCcatCircuit2
                if (this.dbgOn()) {
                    db.println("Unify method called for two CCAT circuits");
                }
                if (!(NetCcatCircuit.isNullCircuitId(this.circuitId) || NetCcatCircuit.isNullCircuitId(netCcatCircuit.circuitId) || this.circuitId.equals(netCcatCircuit.circuitId))) {
                    if (this.dbgOn()) {
                        db.println("Cannot Unify two circuits with different circuit Ids");
                    }
                    // MONITOREXIT : netCcatCircuit2
                    return false;
                }
                if (!this.circuitInfoActive()) {
                    int n = this.getSrcNetElement().getNodeModel().getFramingType();
                    IFramingType iFramingType = FramingType.getFramingType((int)n);
                    if (netCcatCircuit.getCircuitTypeObj().isLAPCircuitType()) {
                        if (this.getCircuitTypeObj().isLAPCircuitType()) {
                            this.setCircuitType(iFramingType.getTunnelCircuitType());
                        } else {
                            this.setCircuitType(netCcatCircuit.getCircuitType());
                        }
                    } else if (netCcatCircuit.getCircuitTypeObj().isTunnelCircuitType() || netCcatCircuit.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
                        this.setCircuitType(netCcatCircuit.getCircuitType());
                    }
                }
                if (!this.isMemberOfVcat()) break block38;
                if (netCcatCircuit.isMemberOfVcat()) {
                    if (this.getVcatGroup() != netCcatCircuit.getVcatGroup()) {
                        if (this.dbgOn()) {
                            db.println("Two circuits belong to two different VCAT circuits");
                            db.println("copy the content of the other vcat group to this circuit");
                            db.println("destroy the other vcat circuit");
                        }
                        if (!this.getVcatGroup().unify(netCcatCircuit.getVcatGroup(), false)) {
                            // MONITOREXIT : netCcatCircuit2
                            return false;
                        }
                        this.memberStatusMap.putAll(netCcatCircuit.memberStatusMap);
                        break block37;
                    } else {
                        if (this.dbgOn()) {
                            db.println("Two circuits belong to the same VCAT circuit");
                            db.println("remove the other circuit from the vcat group");
                        }
                        this.memberStatusMap.putAll(netCcatCircuit.memberStatusMap);
                    }
                    break block37;
                } else if (this.dbgOn()) {
                    db.println("This circuit is part of a VCAT circuit, but the other circuit is not");
                    db.println("just unify the two member circuits");
                }
                break block37;
            }
            if (netCcatCircuit.isMemberOfVcat()) {
                if (this.dbgOn()) {
                    db.println("The other circuit is part of a VCAT circuit, but this circuit is not");
                    db.println("add this circuit to the vcat group and remove the other circuit from the vcat group");
                }
                this.initVcatGroup(netCcatCircuit.getVcatGroup());
                this.getVcatGroup().insertMemberCircuit(this);
                this.memberStatusMap.putAll(netCcatCircuit.memberStatusMap);
                this.ncMgr.convertCcatToMember(this);
            } else if (this.dbgOn()) {
                db.println("Neither circuit is part of a VCAT circuit");
            }
        }
        INetElement iNetElement = null;
        Object var4_7 = null;
        NetCircuitNode netCircuitNode2 = null;
        Iterator<Object> iterator = netCcatCircuit.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            object = (NetCircuitNode)iterator.next();
            if (this.getCircuitNodeFromNE(((NetCircuitNode)object).getNetElement()) == null) continue;
            iNetElement = ((NetCircuitNode)object).getNetElement();
            break;
        }
        if (iNetElement != null) {
            NetCircuitNode netCircuitNode3 = (NetCircuitNode)this.getCircuitNodeFromNE(iNetElement);
            if (!this.sameNEUnifyAllowed(netCircuitNode3, netCircuitNode2 = (NetCircuitNode)netCcatCircuit.getCircuitNodeFromNE(iNetElement))) {
                // MONITOREXIT : netCcatCircuit2
                return false;
            }
            object = NetCircuitNodeFactory.createDualConnectionCircuitNode(netCircuitNode3, netCircuitNode2);
            netCircuitNode2.setCircuit(this);
            this.insertCktNode((NetCircuitNode)object);
            iterator = netCcatCircuit.cktNodeList.values().iterator();
            while (iterator.hasNext()) {
                netCircuitNode = (NetCircuitNode)iterator.next();
                if (netCircuitNode == netCircuitNode2) continue;
                this.cktNodeList.put(netCircuitNode.getNetElement(), netCircuitNode);
            }
        } else {
            this.cktNodeList.putAll(netCcatCircuit.cktNodeList);
        }
        netCcatCircuit.cktNodeList.clear();
        this.cktSpanList.putAll(netCcatCircuit.cktSpanList);
        netCcatCircuit.cktSpanList.clear();
        this.setChanged();
        if (this.dbgOn()) {
            db.println("Unified ckt has " + this.cktNodeList.values().size() + " nodes, and " + this.cktSpanList.values().size() + " spans");
        }
        object = this.getCircuitNodes().iterator();
        while (object.hasNext()) {
            netCircuitNode = (NetCircuitNode)object.next();
            netCircuitNode.setCircuit(this);
            netCircuitNode.setInternalSpliceLinkEnds();
        }
        this.conformToCircuitInfo();
        netCcatCircuit.finalDispose();
        // MONITOREXIT : netCcatCircuit2
        if (!this.circuitInfoActive()) {
            if (this.tl1CircuitCompleteCheck()) return true;
            try {
                if (this.inRoll()) {
                    this.setState(8);
                    return true;
                }
                if (this.isTl1Ckt()) {
                    this.setState(6);
                    return true;
                }
                this.setState(4);
                return true;
            }
            catch (IncorrectCircuitState incorrectCircuitState) {
                return true;
            }
        }
        if (this.completeCheck()) return true;
        if (this.inRoll()) {
            this.setState(8);
            return true;
        }
        this.setState(4);
        return true;
    }

    boolean sameNEUnifyAllowed(NetCircuitNode netCircuitNode, NetCircuitNode netCircuitNode2) {
        if (netCircuitNode.hasDualConnections() || netCircuitNode2.hasDualConnections()) {
            if (this.dbgOn()) {
                db.println("Can not unify: more than 2 conns on same NE");
            }
            return false;
        }
        if (!((netCircuitNode instanceof HoCircuitNode || netCircuitNode instanceof LoTunnelNode || netCircuitNode instanceof OchncCircuitNode || netCircuitNode instanceof OchTrailTunnelNode) && (netCircuitNode2 instanceof HoCircuitNode || netCircuitNode2 instanceof LoTunnelNode || netCircuitNode2 instanceof OchncCircuitNode || netCircuitNode2 instanceof OchTrailTunnelNode))) {
            if (this.dbgOn()) {
                db.println("Can not unify: xconn type does not support 2 conns on same NE");
            }
            return false;
        }
        if (netCircuitNode instanceof HoCircuitNode && netCircuitNode2 instanceof HoCircuitNode) {
            if (netCircuitNode.getTotalInOuts() != 2) {
                return false;
            }
            if (netCircuitNode.getSources().isEmpty() && netCircuitNode.getDrops().isEmpty()) {
                return false;
            }
            if (netCircuitNode2.getTotalInOuts() != 2) {
                return false;
            }
            if (netCircuitNode2.getSources().isEmpty() && netCircuitNode2.getDrops().isEmpty()) {
                return false;
            }
        }
        return true;
    }

    protected void reloadTl1Objects() {
        if (!this.isMemberOfVcat()) {
            if (this.dbgOn()) {
                db.println("Calling reloadTl1Objects() for ckt : " + this.getCircuitName());
            }
            LinkedList linkedList = this.getCktInfoEndPoints();
            Iterator iterator = this.getCircuitNodes().iterator();
            while (iterator.hasNext()) {
                NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
                if (!NetCcatCircuit.isNullCircuitId(netCircuitNode.getCircuitId()) || netCircuitNode.connEndsPartOfCktEnd(linkedList)) continue;
                if (this.dbgOn()) {
                    db.println("Reloading TL1 connection on node : " + netCircuitNode.getName());
                }
                this.disposeConnection(netCircuitNode, false);
                NetCircuitWatchDog.instance().reloadConnections(netCircuitNode.getNetElement());
            }
        }
    }

    protected void disposeCircuitInfoAtNodes() {
        if (this.circuitInfoActive()) {
            if (this.dbgOn()) {
                this.debug("disposeCircuitInfoAtNodes: FAILURE! circuitInfo is active");
            }
            return;
        }
        if (!this.isMemberOfVcat()) {
            if (this.dbgOn()) {
                this.debug("disposeCircuitInfoAtNodes() called for " + this.getCircuitName());
            }
            Iterator iterator = this.getCircuitNodes().iterator();
            while (iterator.hasNext()) {
                NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
                netCircuitNode.disposeCircuitInfo();
            }
        }
    }

    protected boolean isTl1Ckt() throws IncorrectCircuitState {
        NetCircuitNode netCircuitNode;
        if (this.circuitInfoActive()) {
            if (this.dbgOn()) {
                this.debug("isTl1Ckt: " + this.getCircuitName() + ": CircuitInfo is ACTIVE !!");
            }
            throw new IncorrectCircuitState("CircuitInfo has been discovered");
        }
        ArrayList<NetCircuitNode> arrayList = new ArrayList<NetCircuitNode>();
        Iterator iterator = this.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            netCircuitNode = (NetCircuitNode)iterator.next();
            if (netCircuitNode instanceof DualConnectionCircuitNode) {
                DualConnectionCircuitNode dualConnectionCircuitNode = (DualConnectionCircuitNode)netCircuitNode;
                arrayList.add(dualConnectionCircuitNode.getFstCircuitNode());
                arrayList.add(dualConnectionCircuitNode.getSecCircuitNode());
                continue;
            }
            arrayList.add(netCircuitNode);
        }
        CircuitId circuitId = new CircuitId(0, 0);
        CircuitId circuitId2 = new CircuitId(0, 0);
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            netCircuitNode = (NetCircuitNode)iterator.next();
            if (netCircuitNode == null || netCircuitNode.getConn() == null) continue;
            bl2 = false;
            circuitId = netCircuitNode.getCircuitId();
            if ((netCircuitNode instanceof LoTunnelNode || netCircuitNode instanceof OchTrailTunnelNode) && circuitId.getUniquePart().getUniqueId() == 0) {
                circuitId = new CircuitId(0, 0);
            }
            if (NetCcatCircuit.isNullCircuitId(circuitId)) {
                bl3 = true;
                continue;
            }
            if (bl) {
                if (((Object)circuitId).equals(circuitId2)) continue;
                if (this.dbgOn()) {
                    this.debug("isTl1Ckt: " + this.getCircuitName() + " failed:Found two circuitIds " + circuitId2 + " and " + circuitId);
                }
                throw new IncorrectCircuitState("Circuit has multiple circuit IDs");
            }
            bl = true;
            circuitId2 = circuitId;
        }
        if (bl2) {
            if (this.dbgOn()) {
                this.debug("All nodes were skipped.");
            }
            return bl3;
        }
        if (this.dbgOn()) {
            this.debug("isTl1Ckt: " + bl3 + " for " + this.getCircuitName() + ", cktId = " + NetCcatCircuit.prettyString(circuitId2));
        }
        if (NetCcatCircuit.isNullCircuitId(this.circuitId) ^ NetCcatCircuit.isNullCircuitId(circuitId2)) {
            this.ncMgr.removeCircuit(this);
            this.updateCircuitId(circuitId2);
            this.ncMgr.insertCircuit(this, false);
        }
        return bl3;
    }

    protected boolean initSourcesAndDrops() {
        INetCircuitEnd iNetCircuitEnd;
        if (this.circuitInfoActive()) {
            return false;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        boolean bl = this.setCircuitLevelSourcesAndDrops(arrayList, arrayList2);
        if (this.dbgOn()) {
            db.println("initSourcesAndDrops():");
            db.println(" Node-level sources: ");
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                iNetCircuitEnd = (NetCircuitEnd)iterator.next();
                db.println("   " + ((NetCircuitEnd)iNetCircuitEnd).prettyString());
            }
            db.println(" Node-level drops: ");
            iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                iNetCircuitEnd = (NetCircuitEnd)iterator.next();
                db.println("   " + ((NetCircuitEnd)iNetCircuitEnd).prettyString());
            }
        }
        boolean bl2 = false;
        if (arrayList.size() == 0 && arrayList2.size() != 0 && this.isBidirectional()) {
            bl2 = true;
        } else if (this.getCircuitTypeObj().isLAPCircuitType() && arrayList.size() > 0 && (iNetCircuitEnd = (INetCircuitEnd)arrayList.get(0)) != null && iNetCircuitEnd.isNodeDrop()) {
            bl2 = true;
        }
        if (bl2) {
            try {
                bl = this.reverseRoutingDir();
            }
            catch (IncorrectCircuitState incorrectCircuitState) {
                if (this.dbgOn()) {
                    this.debug("InitSourcesDrops: Error during circuit reversal");
                }
                bl = false;
            }
        }
        return bl;
    }

    public boolean setCircuitLevelSourcesAndDrops() {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        return this.setCircuitLevelSourcesAndDrops(arrayList, arrayList2);
    }

    public boolean setCircuitLevelSourcesAndDrops(List list, List list2) {
        NetCircuitEnd netCircuitEnd;
        NetCircuitNode netCircuitNode;
        Iterator iterator;
        this.setSources(null);
        this.setDrops(null);
        this.setChanged();
        this.getNodeLevelSourcesAndDrops(list, list2);
        if (list.size() == 0) {
            iterator = this.getCircuitNodes().iterator();
            while (iterator.hasNext()) {
                netCircuitNode = (NetCircuitNode)iterator.next();
                netCircuitEnd = netCircuitNode.convertSpliceListenerToSourceOrDrop(eSpanDirection.TERMINATING);
                if (netCircuitEnd == null) continue;
                list.add(netCircuitEnd);
                break;
            }
        }
        if (list2.size() == 0) {
            iterator = this.getCircuitNodes().iterator();
            while (iterator.hasNext()) {
                netCircuitNode = (NetCircuitNode)iterator.next();
                netCircuitEnd = netCircuitNode.convertSpliceListenerToSourceOrDrop(eSpanDirection.ORIGINATING);
                if (netCircuitEnd == null) continue;
                list2.add(netCircuitEnd);
                break;
            }
        }
        iterator = list.iterator();
        while (iterator.hasNext()) {
            this.insertSource((NetCircuitEnd)iterator.next());
        }
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            this.insertDrop(new NetCircuitDropInfo((NetCircuitEnd)iterator.next(), 2));
        }
        this.updateCircuitSourceInfo();
        this.updateCircuitDropInfo();
        return this.setSrcCircuitNode();
    }

    protected void tl1RemoveLapNode() {
    }

    protected void setPathProtForDrops(boolean bl) {
        Iterator iterator = this.getCktDrops().iterator();
        while (iterator.hasNext()) {
            NetCircuitDropInfo netCircuitDropInfo = (NetCircuitDropInfo)iterator.next();
            if (bl) {
                netCircuitDropInfo.setPathProt(0);
                continue;
            }
            netCircuitDropInfo.setPathProt(2);
        }
        this.updateCircuitDropInfo();
    }

    protected void getNodeLevelSourcesAndDrops(List list, List list2) {
        Iterator iterator = this.cktNodeList.values().iterator();
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            list.addAll(netCircuitNode.getSources());
            list2.addAll(netCircuitNode.getDrops());
        }
    }

    protected NetCircuitEnd getNodeDrop() {
        Iterator iterator = this.cktNodeList.values().iterator();
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            if (!netCircuitNode.isNodeDrop()) continue;
            return netCircuitNode.getNodeDrop();
        }
        return null;
    }

    protected void conformToCircuitInfo() {
        if (!this.circuitInfoActive()) {
            return;
        }
        Iterator iterator = this.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            ((NetCircuitNode)iterator.next()).conformToCircuitInfo();
        }
    }

    protected void runChildUpdate() {
        List list = this.getCircuitNodes();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                ((NetCircuitNode)iterator.next()).runUpdate();
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                db.println("AbstractCmsIOException during node update");
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
            }
        }
        list = this.getCircuitSpans();
        iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                ((NetCircuitSpan)iterator.next()).runUpdate();
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                db.println("AbstractCmsIOException during span update");
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
            }
        }
    }

    protected boolean okToDeleteNe(INetElement iNetElement) {
        if (this.dbgOn()) {
            db.println("okToDeleteNe called on circuit " + this.getCircuitName());
        }
        if (!this.isCircuitProtected()) {
            return false;
        }
        NetCircuitNode netCircuitNode = (NetCircuitNode)this.getCircuitNodeFromNE(iNetElement);
        return netCircuitNode.okToDeleteNe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobGroupFinished(JobGroup jobGroup) {
        Object object = this.threadWaitObject;
        synchronized (object) {
            this.createDone = true;
            this.threadWaitObject.notifyAll();
        }
    }

    private void sanityCheckBlsrDriHandoffs() throws SanityCheckFailed {
        MemberPrefs memberPrefs = this.getMemberPrefs();
        if (memberPrefs == null) {
            return;
        }
        if (memberPrefs.getDriNodePrefs().size() == 0) {
            return;
        }
        NetCircuitNode netCircuitNode = null;
        NetCircuitNode netCircuitNode2 = null;
        Object var7_4 = null;
        List list = memberPrefs.getDriNodePrefs();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            DriNodes driNodes = (DriNodes)iterator.next();
            List list2 = driNodes.getNodePairs();
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                DriNodePair driNodePair = (DriNodePair)iterator2.next();
                netCircuitNode = (NetCircuitNode)this.getCircuitNodeFromNE(driNodePair.getPrimary());
                netCircuitNode2 = (NetCircuitNode)this.getCircuitNodeFromNE(driNodePair.getSecondary());
                if (netCircuitNode == null) {
                    throw new SanityCheckFailed("Primary node is missing from circuit path");
                }
                if (netCircuitNode2 == null) {
                    throw new SanityCheckFailed("Secondary node is missing from circuit path");
                }
                if (this.dbgOn()) {
                    db.println("sanityCheckBlsrDriHandoffs: primary " + netCircuitNode.getName() + " secondary " + netCircuitNode2.getName());
                }
                netCircuitNode.sanityCheckBlsrDriPrimaryNode();
                this.markBlsrDriInterConnectSpans(netCircuitNode, netCircuitNode2, driNodes.getDriType());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void markBlsrDriInterConnectSpans(NetCircuitNode netCircuitNode, NetCircuitNode netCircuitNode2, int n) throws SanityCheckFailed {
        NetCircuitSpan netCircuitSpan;
        Object object;
        LinkedList linkedList = new LinkedList();
        NetCircuitNode netCircuitNode3 = null;
        if (n == 1 || netCircuitNode.getTotalInOuts() == 3) {
            if (netCircuitNode.countNumInputs() == 2) {
                linkedList = netCircuitNode2.getOrigSpans();
                netCircuitNode3 = netCircuitNode2;
            } else if (netCircuitNode.countNumOutputs() == 2) {
                linkedList = netCircuitNode2.getTermSpans();
                netCircuitNode3 = netCircuitNode2;
            } else {
                if (netCircuitNode.countNumOmniSpans() != 1) throw new SanityCheckFailed("Traditional handoff " + netCircuitNode.getName() + " has an invalid span combination");
                if (netCircuitNode.getOrigSpans().size() == 1 && netCircuitNode.getTermSpans().size() == 1) {
                    if (((NetCircuitSpan)netCircuitNode.getTermSpans().get(0)).getLink().inBLSR()) {
                        linkedList.add(netCircuitNode.getTermSpans().get(0));
                    } else if (((NetCircuitSpan)netCircuitNode.getOrigSpans().get(0)).getLink().inBLSR()) {
                        linkedList.add(netCircuitNode.getOrigSpans().get(0));
                    }
                }
                netCircuitNode3 = netCircuitNode;
            }
            object = linkedList.iterator();
            while (object.hasNext()) {
                netCircuitSpan = (NetCircuitSpan)object.next();
                if (netCircuitSpan.getLink().inBLSR()) continue;
                object.remove();
            }
        } else {
            if (n != 2 || netCircuitNode.getTotalInOuts() != 4) throw new SanityCheckFailed("BLSR DRI handoff " + netCircuitNode.getName() + " has an invalid span combination");
            if (netCircuitNode2.getOmniSpans().size() == 1) {
                if (netCircuitNode2.getOrigSpans().size() == 2) {
                    if (((NetCircuitSpan)netCircuitNode2.getOrigSpans().get(0)).getLink().inBLSR()) {
                        linkedList.add(netCircuitNode2.getOrigSpans().get(0));
                    } else if (((NetCircuitSpan)netCircuitNode2.getOrigSpans().get(1)).getLink().inBLSR()) {
                        linkedList.add(netCircuitNode2.getOrigSpans().get(1));
                    }
                } else if (netCircuitNode2.getTermSpans().size() == 2) {
                    if (((NetCircuitSpan)netCircuitNode2.getTermSpans().get(0)).getLink().inBLSR()) {
                        linkedList.add(netCircuitNode2.getTermSpans().get(0));
                    } else if (((NetCircuitSpan)netCircuitNode2.getTermSpans().get(1)).getLink().inBLSR()) {
                        linkedList.add(netCircuitNode2.getTermSpans().get(1));
                    }
                } else {
                    if (netCircuitNode2.getOrigSpans().size() != 1 || netCircuitNode2.getTermSpans().size() != 1) throw new SanityCheckFailed("Integrated handoff " + netCircuitNode2.getName() + " requires three spans");
                    if (((NetCircuitSpan)netCircuitNode2.getTermSpans().get(0)).getLink().inBLSR()) {
                        linkedList.add(netCircuitNode2.getTermSpans().get(0));
                    } else if (((NetCircuitSpan)netCircuitNode2.getOrigSpans().get(0)).getLink().inBLSR()) {
                        linkedList.add(netCircuitNode2.getOrigSpans().get(0));
                    }
                }
            } else {
                if (netCircuitNode2.getTotalInOuts() != 2 || netCircuitNode2.getOmniSpans().size() != 0) throw new SanityCheckFailed("Integrated handoff " + netCircuitNode.getName() + " has an invalid span combination");
                linkedList.addAll(netCircuitNode2.getAllSpansList());
            }
            netCircuitNode3 = netCircuitNode2;
        }
        if (netCircuitNode3.getNetElement().equals(netCircuitNode.getNetElement())) {
            object = netCircuitNode2;
            ((NetCircuitNode)object).driNodeType = 2;
            netCircuitNode3.driNodeType = 1;
        } else {
            object = netCircuitNode;
            ((NetCircuitNode)object).driNodeType = 1;
            netCircuitNode3.driNodeType = 2;
        }
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            netCircuitSpan = (NetCircuitSpan)iterator.next();
            NetCircuitNode netCircuitNode4 = netCircuitNode3;
            while (!((NetCircuitNode)object).getNetElement().equals(netCircuitNode4.getNetElement())) {
                if (this.dbgOn()) {
                    db.println("markBlsrDriInterConnectSpans: node " + netCircuitNode4.getName() + " span " + netCircuitSpan.prettyString());
                }
                netCircuitSpan.setBlsrDriInterConnect(true);
                NetCircuitNode netCircuitNode5 = netCircuitNode4.spanGetPeer(netCircuitSpan);
                if (netCircuitNode5 == null) {
                    throw new SanityCheckFailed("DRI node " + netCircuitNode4.getName() + " has no peer");
                }
                netCircuitNode4 = netCircuitNode5;
                List list = netCircuitNode4.getAllSpansList();
                if (((NetCircuitNode)object).getNetElement().equals(netCircuitNode4.getNetElement())) continue;
                netCircuitNode4.driNodeType = 3;
                if (list.size() < 2) {
                    throw new SanityCheckFailed("Intermediate handoff interconnect " + netCircuitNode4.getName() + " must have two spans");
                }
                if (netCircuitSpan.equals((NetCircuitSpan)list.get(0))) {
                    netCircuitSpan = (NetCircuitSpan)list.get(1);
                    continue;
                }
                netCircuitSpan = (NetCircuitSpan)list.get(0);
            }
        }
    }

    protected Connection findBlsrDriPrimary(Connection connection) {
        Iterator iterator = this.getCircuitNodes().iterator();
        if (this.dbgOn()) {
            db.println("findBlsrDriPrimary: starting search for the primary handoff connection that feeds " + connection.getName() + " on node " + connection.getNodeName());
        }
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            if (!netCircuitNode.isBlsrDriPrimary()) continue;
            Iterator iterator2 = netCircuitNode.connections.iterator();
            while (iterator2.hasNext()) {
                Connection connection2 = (Connection)iterator2.next();
                if (!connection.isFedBy(connection2)) continue;
                return connection2;
            }
        }
        return null;
    }

    public void getNodeAndSpanListWithCktEnd(INetCircuitEnd iNetCircuitEnd, INetCircuitEnd iNetCircuitEnd2, List list, List list2) {
        if (this.dbgOn()) {
            db.println("getNodeAndSpanListWithCktEnd with fromEnd: " + ((NetCircuitEnd)iNetCircuitEnd).prettyString() + " toEnd: " + (iNetCircuitEnd2 == null ? " " : ((NetCircuitEnd)iNetCircuitEnd2).prettyString()));
        }
        if (this.isSource((NetCircuitEnd)iNetCircuitEnd) || this.isDrop((NetCircuitEnd)iNetCircuitEnd)) {
            return;
        }
        INetLink iNetLink = null;
        INetLink iNetLink2 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        iNetLink = this.net.findNetLinkFromSourceCktEnd(this.getCircuitTypeObj().isLoCircuitType(), iNetCircuitEnd.getNetElement(), iNetCircuitEnd.getEntityIndex(), iNetCircuitEnd.getHoNum());
        if (iNetLink == null) {
            return;
        }
        bl = this.doesCircuitUseNetLink(iNetLink);
        if (!bl) {
            iNetLink = iNetLink.getReverseLink();
            bl = this.doesCircuitUseNetLink(iNetLink);
            bl3 = true;
        }
        if (iNetCircuitEnd2 == null) {
            if (bl) {
                this.getOrderedNodeAndSpanList(iNetLink, null, list, list2);
            }
            return;
        }
        iNetLink2 = this.net.findNetLinkFromDestinationCktEnd(this.getCircuitTypeObj().isLoCircuitType(), iNetCircuitEnd2.getNetElement(), iNetCircuitEnd2.getEntityIndex(), iNetCircuitEnd2.getHoNum());
        if (iNetLink2 == null) {
            return;
        }
        bl2 = this.doesCircuitUseNetLink(iNetLink2);
        if (!bl2) {
            iNetLink2 = iNetLink2.getReverseLink();
            bl2 = this.doesCircuitUseNetLink(iNetLink2);
            bl4 = true;
        }
        if (bl && bl2) {
            if (bl3 && bl4) {
                this.getOrderedNodeAndSpanList(iNetLink2, iNetLink, list, list2);
            } else {
                this.getOrderedNodeAndSpanList(iNetLink, iNetLink2, list, list2);
            }
            if (list2.isEmpty()) {
                return;
            }
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)list2.get(0);
            NetCircuitSpan netCircuitSpan2 = (NetCircuitSpan)list2.get(list2.size() - 1);
            INetElement iNetElement = netCircuitSpan.getLink().getSrc();
            NetCircuitEnd netCircuitEnd = new NetCircuitEnd(iNetElement.getNodeId(), netCircuitSpan.getEntityIndex(iNetElement), netCircuitSpan.getHoNum(iNetElement), netCircuitSpan.getLoNum(), false);
            INetElement iNetElement2 = netCircuitSpan2.getLink().getDst();
            NetCircuitEnd netCircuitEnd2 = new NetCircuitEnd(iNetElement2.getNodeId(), netCircuitSpan2.getEntityIndex(iNetElement2), netCircuitSpan2.getHoNum(iNetElement2), netCircuitSpan2.getLoNum(), false);
            if (bl3 && bl4) {
                if (!netCircuitEnd.equals(iNetCircuitEnd2) || !netCircuitEnd2.equals(iNetCircuitEnd)) {
                    list.clear();
                    list2.clear();
                }
            } else if (!netCircuitEnd.equals(iNetCircuitEnd) || !netCircuitEnd2.equals(iNetCircuitEnd2)) {
                list.clear();
                list2.clear();
            }
        }
    }

    protected boolean getOrderedNodeAndSpanList(INetLink iNetLink, INetLink iNetLink2, List list, List list2) {
        INetCircuitSpan iNetCircuitSpan;
        int n;
        IObservable iObservable;
        Object object;
        Object object2;
        LinkedList<INetLink> linkedList = new LinkedList<INetLink>();
        if (this.dbgOn()) {
            db.println("getOrderedNodeAndSpanList: ");
        }
        Iterator iterator = this.getCircuitSpans().iterator();
        while (iterator.hasNext()) {
            object2 = (NetCircuitSpan)iterator.next();
            linkedList.add(((NetCircuitSpan)object2).getLink());
        }
        if (this.dbgOn()) {
            db.println("Spt.getLinksBtwTwoLinks fromLink  " + (iNetLink == null ? " " : iNetLink.prettyString()) + " toLink " + (iNetLink2 == null ? " " : iNetLink2.prettyString()) + " starting from node " + this.srcCircuitNode.getName());
        }
        object2 = null;
        if (this.getSecondarySource() != null && this.getSecondarySource().getNetElement() != this.srcCircuitNode.getNetElement()) {
            object2 = this.getSecondarySource().getNetElement();
        }
        List list3 = Spt.getLinksBtwTwoLinks(this.srcCircuitNode.getNetElement(), (INetElement)object2, linkedList, iNetLink, iNetLink2);
        iterator = list3.iterator();
        iterator = list3.iterator();
        while (iterator.hasNext()) {
            object = (INetLink)iterator.next();
            iObservable = (NetCircuitNode)this.getCircuitNodeFromNE(object.getSrc());
            for (n = 0; n < 2; ++n) {
                if (!list.contains(iObservable)) {
                    list.add(iObservable);
                }
                iObservable = (NetCircuitNode)this.getCircuitNodeFromNE(object.getDst());
            }
            iNetCircuitSpan = this.getCircuitSpanFromNetLink((INetLink)object);
            if (list2.contains(iNetCircuitSpan)) continue;
            list2.add(iNetCircuitSpan);
        }
        if (!list2.isEmpty() && (object = ((NetCircuitSpan)list2.get(0)).getLink()) != (iObservable = ((NetCircuitSpan)list2.get(list2.size() - 1)).getLink()) && object.getSrc() == this.getPrimarySource().getNetElement() && iObservable.getDst() == this.getPrimaryDrop().getNetElement() && object.inBLSR() && iObservable.inBLSR() && this.isDri()) {
            iterator = this.getCircuitSpans().iterator();
            while (iterator.hasNext()) {
                iNetCircuitSpan = (NetCircuitSpan)iterator.next();
                if (list2.contains(iNetCircuitSpan)) continue;
                list2.add(list2.size() - 1, iNetCircuitSpan);
                NetCircuitNode netCircuitNode = (NetCircuitNode)this.getCircuitNodeFromNE(((NetCircuitSpan)iNetCircuitSpan).getLink().getSrc());
                for (n = 0; n < 2; ++n) {
                    if (!list.contains(netCircuitNode)) {
                        list.add(list.size() - 1, netCircuitNode);
                    }
                    netCircuitNode = (NetCircuitNode)this.getCircuitNodeFromNE(((NetCircuitSpan)iNetCircuitSpan).getLink().getDst());
                }
            }
        }
        if (this.dbgOn()) {
            db.println("getOrderedNodeAndSpanList find " + list.size() + " nodes and " + list2.size() + " spans");
            object = list.iterator();
            db.print("found: source --> ");
            while (object.hasNext()) {
                db.print(((NetCircuitNode)object.next()).getName() + " --> ");
            }
            db.println(" destination");
        }
        return list3.size() > 0;
    }

    public synchronized boolean containsCktEnd(INetCircuitEnd iNetCircuitEnd) {
        Object object;
        Iterator<Object> iterator = this.cktNodeList.values().iterator();
        while (iterator.hasNext()) {
            object = (NetCircuitNode)iterator.next();
            if (!((NetCircuitNode)object).containsCktEnd((NetCircuitEnd)iNetCircuitEnd)) continue;
            return true;
        }
        iterator = this.getSources().iterator();
        while (iterator.hasNext()) {
            object = (NetCircuitEnd)iterator.next();
            if (!((NetCircuitEnd)object).equals(iNetCircuitEnd)) continue;
            return true;
        }
        iterator = this.getDrops().iterator();
        while (iterator.hasNext()) {
            object = ((NetCircuitDropInfo)iterator.next()).getNetCktEnd();
            if (!((NetCircuitEnd)object).equals(iNetCircuitEnd)) continue;
            return true;
        }
        return false;
    }

    public synchronized List findRouteForBridgeRoll(RoutePrefs routePrefs, boolean bl) throws AllocFailed, ObjNotFound, NoRoute, CircuitDropOutstanding, IncorrectCircuitState, SanityCheckFailed, AbstractCmsIOException {
        if (this.dbgOn()) {
            db.println("findRouteForBridgeRoll called for " + this.getCircuitName());
        }
        if (!this.isCircuitRefValid()) {
            throw new IncorrectCircuitState("Circuit already destroyed");
        }
        routePrefs.setCircuitSize(this.getCircuitSize());
        routePrefs.setCircuitType(this.getCircuitType());
        routePrefs.setPathOnly(false);
        RoutePrefs routePrefs2 = new RoutePrefs(routePrefs);
        if (bl) {
            routePrefs2.setPathProt(3);
        } else if (routePrefs.getPathProt() == 0) {
            routePrefs2.setPathProt(7);
        }
        NetCircuitPath netCircuitPath = new NetCircuitPath(routePrefs2, this);
        netCircuitPath.computeCircuitPath();
        return netCircuitPath.getAvailSpans();
    }

    public boolean createWithStpEnabled() {
        return true;
    }

    public boolean hasLoopback() {
        List list = this.getCircuitNodes();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            if (!netCircuitNode.hasLoopback()) continue;
            return true;
        }
        return false;
    }

    protected boolean hasOmniSpans() {
        Iterator iterator = this.getCircuitSpans().iterator();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            if (!netCircuitSpan.getNetLinkSpan().getOmni()) continue;
            return true;
        }
        return false;
    }

    public boolean hasXcLoopback() {
        List list = this.getCircuitNodes();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            if (!netCircuitNode.hasXcLoopback()) continue;
            return true;
        }
        return false;
    }

    public INetCircuitNode getUpsrSrcNode(List list, INetElement iNetElement) {
        INetCircuitNode iNetCircuitNode = this.getCircuitNodeFromNE(iNetElement);
        int n = list.indexOf(iNetCircuitNode);
        for (int i = n - 1; i >= 0; --i) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)list.get(i);
            if (!netCircuitNode.isUpsrBridge()) continue;
            return netCircuitNode;
        }
        return null;
    }

    public INetCircuitNode getUpsrDstNode(List list, INetElement iNetElement) {
        INetCircuitNode iNetCircuitNode = this.getCircuitNodeFromNE(iNetElement);
        int n = list.indexOf(iNetCircuitNode);
        for (int i = n + 1; i < list.size(); ++i) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)list.get(i);
            if (!netCircuitNode.isUpsrSelector()) continue;
            return netCircuitNode;
        }
        return null;
    }

    public INetCircuitNode getDropNode(List list, INetElement iNetElement) {
        INetCircuitNode iNetCircuitNode = this.getCircuitNodeFromNE(iNetElement);
        int n = list.indexOf(iNetCircuitNode);
        for (int i = n + 1; i < list.size(); ++i) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)list.get(i);
            if (netCircuitNode.getDrops().isEmpty() && !netCircuitNode.isNodeDrop()) continue;
            return netCircuitNode;
        }
        return null;
    }

    public void setUpsrSelectorAttributes(IRevertiveBehavior iRevertiveBehavior, short s, short s2, boolean bl) {
        if (this.dbgOn()) {
            db.println("setUpsrSelectorAttributes " + this.getCircuitName());
        }
        this.upsrReversion = iRevertiveBehavior;
        this.upsrSfBerLevel = s;
        this.upsrSdBerLevel = s2;
        this.upsrSwitchOnPdip = bl;
    }

    public IHoUpsrAttributes getUpsrAttributes() {
        if (this.upsrReversion == null) {
            return null;
        }
        HoUpsrAttributes hoUpsrAttributes = new HoUpsrAttributes(this.upsrSfBerLevel, this.upsrSdBerLevel, this.upsrReversion, this.upsrSwitchOnPdip);
        return hoUpsrAttributes;
    }

    protected IRevertiveBehavior getRevertiveBehavior() {
        return this.upsrReversion;
    }

    protected boolean getTrafficDir() {
        return this.go_return_routing;
    }

    protected boolean isInStsUpperHalf(NetCircuitSpan netCircuitSpan) {
        NetCircuit netCircuit;
        INetLink iNetLink = netCircuitSpan.getLink();
        int n = iNetLink.getSrc().getFramingType();
        if (iNetLink.isPhysical()) {
            int n2 = iNetLink.getPhysicalTypeObj().getStsCapacity();
            int n3 = n2 / 2 + 1;
            return holoComp.compare(netCircuitSpan.getSrcHoNum(), HoLoFactory.idlSts2HoNum(n, n3)) >= 0;
        }
        if (iNetLink.isLOTunnel() && (netCircuit = this.ncMgr.findLoTunnel(iNetLink, netCircuitSpan.getSrcHoNum(), netCircuitSpan.getDstHoNum())) != null) {
            Iterator iterator = netCircuit.getCircuitSpans().iterator();
            while (iterator.hasNext()) {
                NetCircuitSpan netCircuitSpan2 = (NetCircuitSpan)iterator.next();
                INetLink iNetLink2 = netCircuitSpan2.getLink();
                int n4 = iNetLink2.getPhysicalTypeObj().getStsCapacity();
                int n5 = n4 / 2 + 1;
                if (holoComp.compare(netCircuitSpan2.getSrcHoNum(), HoLoFactory.idlSts2HoNum(n, n5)) < 0) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected void connectLoCircuitsToLAP() {
        this.ncMgr.getCircuitsUseLAP(this);
    }

    protected synchronized void lotReuseLoAdits(boolean bl) {
    }

    public void addNetElement(INetElement iNetElement, RoutePrefs routePrefs) throws IncorrectCircuitState {
    }

    public void deleteNetElement(INetElement iNetElement) throws ObjNotFound, CannotDeleteLastDrop, IncorrectCircuitState, DeletionError, SanityCheckFailed {
    }

    public void routeNetElement(INetElement iNetElement, RoutePrefs routePrefs) throws SanityCheckFailed, IncorrectCircuitState, CTCUserException, AbstractCmsIOException {
    }

    public void routeNetElement(INetElement iNetElement, INetElement iNetElement2, RoutePrefs routePrefs) throws SanityCheckFailed, IncorrectCircuitState, CTCUserException, AbstractCmsIOException {
    }

    public INetLink getLotLink() {
        return null;
    }

    public INetLink getReverseLotLink() {
        return null;
    }

    public INetLink getLapLink() {
        return null;
    }

    public INetLink getReverseLapLink() {
        return null;
    }

    public boolean isVlanCapable() throws IncorrectCircuitState {
        return false;
    }

    public boolean mustDisableStp() throws IncorrectCircuitState {
        return false;
    }

    public IVlanModel[] getVlans() {
        return new IVlanModel[0];
    }

    public NetVlanInfo[] getNetVlans() {
        return new NetVlanInfo[0];
    }

    public void assignVlanSet(IVlanModel[] iVlanModelArray) throws IncorrectCircuitState, SanityCheckFailed {
    }

    public void assignVlanSet(NetVlanInfo[] netVlanInfoArray) throws IncorrectCircuitState, SanityCheckFailed {
    }

    public INetCircuit useLAP() {
        return null;
    }

    protected void destroyLapNode(NetCircuitNode netCircuitNode) {
    }

    protected void lapNodeCreated(NetCircuitNode netCircuitNode) {
    }

    public List getLoTunnelNodes() {
        return new LinkedList();
    }

    public ILoNum getLoOverHo() {
        return null;
    }

    public void createWithStpEnabled(boolean bl) {
    }

    public boolean isStpEnabled() {
        return false;
    }

    public List getXmCircuitEnds() {
        return new LinkedList();
    }

    public List getSrcInternalSpliceLinkEnds() {
        return new LinkedList();
    }

    public List getDstInternalSpliceLinkEnds() {
        return new LinkedList();
    }

    public void setXmCircuitEnds(INetCircuitEnd[] iNetCircuitEndArray) {
    }

    public void setXmCircuitEnds(IEntityModel[] iEntityModelArray) {
    }

    protected boolean circuitInfoActive() {
        return !this.inCircuitMerge && this.circuitInfoActive;
    }

    public void setInCircuitMerge(boolean bl) {
        this.inCircuitMerge = bl;
    }

    public boolean supportsISTU() {
        return true;
    }

    public boolean isUpsr1wayTl1() {
        Iterator iterator = this.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            if (!netCircuitNode.is1wayUpsrConnType()) continue;
            if (this.dbgOn()) {
                db.println("isUpsr1wayTl1: found true on node " + netCircuitNode.getName());
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int deriveServiceState() {
        if (this.dbgOn()) {
            this.debug("deriveServiceState(" + this.getCircuitName() + ", " + NetCcatCircuit.prettyString(this.circuitId) + ")");
        }
        boolean bl = true;
        boolean bl2 = true;
        int n = 0;
        boolean bl3 = false;
        boolean bl4 = false;
        NetCcatCircuit netCcatCircuit = this;
        synchronized (netCcatCircuit) {
            INodeModel iNodeModel = null;
            NetCircuitEnd netCircuitEnd = null;
            NetVcatTermination netVcatTermination = null;
            NetCircuitNode netCircuitNode = null;
            Iterator iterator = this.cktNodeList.values().iterator();
            while (iterator.hasNext()) {
                int n2;
                netCircuitNode = (NetCircuitNode)iterator.next();
                iNodeModel = netCircuitNode.getNodeModel();
                if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.EXTENDED_ESM)) {
                    n2 = netCircuitNode.getServiceState();
                    if (n2 < 0) {
                        bl = false;
                        continue;
                    }
                    ++n;
                    if (!NetServiceState.isFormOfIS(n2)) {
                        bl = false;
                    }
                    if (!NetServiceState.isFormOfOOS(n2)) {
                        bl2 = false;
                    }
                    if (!this.isMemberOfVcat()) continue;
                    netCircuitEnd = this.getTermEndFromCktEnd(this.getPrimarySource());
                    netVcatTermination = this.getVcatGroup().getVcatTermFromCktEnd(netCircuitEnd);
                    if (netVcatTermination != null && netVcatTermination.getNodeModel() == iNodeModel && !NetServiceState.isFormOfOOSOOG(n2)) {
                        bl3 = true;
                    }
                    netCircuitEnd = this.getTermEndFromCktEnd(this.getPrimaryDrop());
                    netVcatTermination = this.getVcatGroup().getVcatTermFromCktEnd(netCircuitEnd);
                    if (netVcatTermination == null || netVcatTermination.getNodeModel() != iNodeModel || NetServiceState.isFormOfOOSOOG(n2)) continue;
                    bl4 = true;
                    continue;
                }
                n2 = netCircuitNode.getAdminState();
                if (n2 < 0) {
                    bl = false;
                    continue;
                }
                ++n;
                if (!NetAdminState.isFormOfIS(n2)) {
                    bl = false;
                }
                if (!NetAdminState.isFormOfOOS(n2)) {
                    bl2 = false;
                }
                if (!this.isMemberOfVcat()) continue;
                netCircuitEnd = this.getTermEndFromCktEnd(this.getPrimarySource());
                netVcatTermination = this.getVcatGroup().getVcatTermFromCktEnd(netCircuitEnd);
                if (netVcatTermination != null && netVcatTermination.getNodeModel() == iNodeModel) {
                    bl3 = true;
                }
                netCircuitEnd = this.getTermEndFromCktEnd(this.getPrimaryDrop());
                netVcatTermination = this.getVcatGroup().getVcatTermFromCktEnd(netCircuitEnd);
                if (netVcatTermination == null || netVcatTermination.getNodeModel() != iNodeModel) continue;
                bl4 = true;
            }
        }
        this.isInGroup = bl3 || bl4;
        if (this.getState() == 4 || this.getState() == 6) {
            return -1;
        }
        if (n == 0) {
            return -1;
        }
        if (bl) {
            return 0;
        }
        if (bl2) {
            return 1;
        }
        return 2;
    }

    protected void notifyChanged() {
        this.notifyChanged(true);
    }

    protected void notifyChanged(boolean bl) {
        if (!this.isCircuitRefValid()) {
            return;
        }
        if (this.hasChanged()) {
            if (this.dbgOn()) {
                this.debug("notifyChanged(" + this.getCircuitName() + ", " + NetCcatCircuit.prettyString(this.circuitId) + ")" + ", notifyParent flag is " + bl);
            }
            int n = this.serviceState;
            this.serviceState = this.deriveServiceState();
            if (this.serviceState != n && this.dbgOn()) {
                this.debug("notifyChanged(): serviceState changed from " + this.translateServiceState(n) + " to " + this.translateServiceState(this.serviceState));
            }
            this.deriveAdminState();
            this.markUpsr();
            this.markDri();
            this.setProtType();
            if (this.isMemberOfVcat() && bl) {
                if (this.dbgOn()) {
                    this.debug("notifyChanged: notify VCAT circuit about the change");
                }
                this.getVcatGroup().memberChanged();
            }
        }
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    protected void notifyDeleted() {
        this.notifyDeleted(true);
    }

    protected void notifyDeleted(boolean bl) {
        if (this.dbgOn()) {
            this.debug("notifyDeleted(" + this.getCircuitName() + ", " + NetCcatCircuit.prettyString(this.circuitId) + ")" + ", notifyParent flag is " + bl);
        }
        this.setChanged();
        if (this.isMemberOfVcat()) {
            if (this.dbgOn()) {
                this.debug("notifyDeleted: remove the circuit from VCAT circuit group");
            }
            this.getVcatGroup().removeMemberCircuit(this);
            if (bl) {
                if (this.dbgOn()) {
                    this.debug("notify VCAT circuit about the deletion");
                }
                this.getVcatGroup().memberChanged();
            }
            this.deleteVcatGroup();
        }
        this.notifyObservers(ModelUpdateType.DELETED);
    }

    protected String deriveDefaultName() {
        String string;
        String string2 = this.srcNodeModel.getName();
        if (string2.length() > 16) {
            string2 = string2.substring(0, 15);
        }
        int n = this.circuitId.getUniquePart().getUniqueId();
        if (this.getCircuitTypeObj().isEthernetCircuitType()) {
            INetElement iNetElement = this.getSrcNetElement();
            IFramingType iFramingType = iNetElement.getFramingTypeObj();
            if (iFramingType.isSonet()) {
                string = SONETTDMTerminology.instance().getEthernetTypeTerm() + "_Ether-" + string2 + "::" + n;
            } else if (iFramingType.isSdh()) {
                string = SDHTDMTerminology.instance().getEthernetTypeTerm() + "_Ether-" + string2 + "::" + n;
            } else {
                if (this.dbgOn()) {
                    this.debug("deriveDefaultName: can not determine TDM terminology");
                }
                string = "_Ether-" + string2 + "::" + n;
            }
        } else {
            string = this.isMemberOfVcat() ? this.getVcatGroup().getCircuitName() + "_" + this.getMemberNumber() : this.getCircuitTypeObj().getProtocolIndepCktTypeShortStr() + "_" + string2 + (n != 0 ? "::" + n : "_TL1");
        }
        return string;
    }

    protected boolean setCircuitRoutingDirection() {
        ArrayList arrayList = new ArrayList();
        if (this.dbgOn()) {
            this.debug("setCircuitRoutingDirection() for " + this.getCircuitName());
        }
        this.alignSpansToRoutingDirection();
        boolean bl = this.validateRoutingDirection(arrayList);
        if (bl && arrayList.size() != 0) {
            this.realignOmniSpans(arrayList);
        }
        return bl;
    }

    private void alignSpansToRoutingDirection() {
        NodeRoutingDirection nodeRoutingDirection;
        NetCircuitNode netCircuitNode;
        List list = this.getCircuitNodes();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            netCircuitNode = (NetCircuitNode)iterator.next();
            nodeRoutingDirection = netCircuitNode.nodeRoutingDir;
            nodeRoutingDirection.start();
        }
        int n = 1;
        block7: while (list.size() != 0) {
            int n2 = 0;
            iterator = list.iterator();
            while (iterator.hasNext()) {
                netCircuitNode = (NetCircuitNode)iterator.next();
                nodeRoutingDirection = netCircuitNode.nodeRoutingDir;
                if (n == 1) {
                    if (nodeRoutingDirection.connectionlessLapLinkNode()) {
                        nodeRoutingDirection.finish();
                        iterator.remove();
                        continue;
                    }
                    if (!nodeRoutingDirection.hasCiLockedSource() && !nodeRoutingDirection.hasCiLockedDrop() && !nodeRoutingDirection.hasLockedConn()) continue;
                    if (!nodeRoutingDirection.hasLockedConn()) {
                        if (nodeRoutingDirection.hasCiLockedSource()) {
                            nodeRoutingDirection.setNodeRoutingDirToCiSource();
                        } else if (nodeRoutingDirection.hasCiLockedDrop()) {
                            nodeRoutingDirection.setNodeRoutingDirToCiDrop();
                        }
                        nodeRoutingDirection.setEndpointsToRoutingDir();
                        nodeRoutingDirection.setSpansToRoutingDir();
                    }
                    nodeRoutingDirection.lockSpansAtPeerNodes();
                    nodeRoutingDirection.finish();
                    iterator.remove();
                    continue;
                }
                if (n == 2) {
                    if (!nodeRoutingDirection.hasLockedSpan()) continue;
                    ++n2;
                    nodeRoutingDirection.setNodeRoutingDirToLockedSpan();
                    nodeRoutingDirection.setEndpointsToRoutingDir();
                    nodeRoutingDirection.setSpansToRoutingDir();
                    nodeRoutingDirection.lockSpansAtPeerNodes();
                    nodeRoutingDirection.finish();
                    iterator.remove();
                    continue;
                }
                if (n != 3 && n != 4 || n == 3 && (netCircuitNode.getConnectionType() != 1 && netCircuitNode.getConnectionType() != 3 && netCircuitNode.getConnectionType() != 11 && netCircuitNode.getConnectionType() != 13 || netCircuitNode instanceof LoTunnelNode)) continue;
                ++n2;
                nodeRoutingDirection.setEndpointsToRoutingDir();
                nodeRoutingDirection.setSpansToRoutingDir();
                nodeRoutingDirection.lockSpansAtPeerNodes();
                nodeRoutingDirection.finish();
                iterator.remove();
                break;
            }
            switch (n) {
                case 1: {
                    n = 2;
                    continue block7;
                }
                case 2: {
                    if (n2 != 0) continue block7;
                    n = 3;
                    continue block7;
                }
                case 3: {
                    if (n2 != 0) {
                        n = 2;
                        continue block7;
                    }
                    n = 4;
                    continue block7;
                }
                case 4: {
                    n = 2;
                    continue block7;
                }
            }
        }
    }

    private void realignOmniSpans(ArrayList arrayList) {
        if (this.dbgOn()) {
            this.debug("realignOmniSpans: " + arrayList.size() + " invalid UPSR_DC nodes for " + this.getCircuitName());
        }
        while (arrayList.size() != 0) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)arrayList.remove(0);
            NodeRoutingDirection nodeRoutingDirection = netCircuitNode.nodeRoutingDir;
            nodeRoutingDirection.realignUpsrDcNode();
        }
    }

    private boolean validateRoutingDirection(ArrayList arrayList) {
        boolean bl = true;
        Iterator iterator = this.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            NodeRoutingDirection nodeRoutingDirection = netCircuitNode.nodeRoutingDir;
            if (nodeRoutingDirection.illegalUpsrDcNode()) {
                arrayList.add(netCircuitNode);
            }
            if (nodeRoutingDirection.allSpansAreValid()) continue;
            bl = false;
        }
        return bl;
    }

    protected synchronized boolean reverseRoutingDir() throws IncorrectCircuitState {
        if (this.dbgOn()) {
            this.debug("Reversing routing direction for circuit " + this.getCircuitName());
        }
        List list = this.getCircuitNodes();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            netCircuitNode.nodeRoutingDir.reverseRoutingDir();
        }
        return this.setCircuitLevelSourcesAndDrops();
    }

    public List getDriNodes() {
        Object object;
        LinkedList<INetElement> linkedList = new LinkedList<INetElement>();
        LinkedList linkedList2 = new LinkedList();
        LinkedList linkedList3 = new LinkedList();
        this.getOrderedNodeAndSpanList(null, null, linkedList2, linkedList3);
        Iterator iterator = linkedList2.iterator();
        boolean bl = false;
        boolean bl2 = false;
        while (iterator.hasNext()) {
            object = (NetCircuitNode)iterator.next();
            if (!((NetCircuitNode)object).getDri() || ((NetCircuitNode)object).getDriNodeTypeFromModelLayer() != 1) continue;
            linkedList.add(((NetCircuitNode)object).getNetElement());
        }
        if (linkedList.isEmpty()) {
            return linkedList;
        }
        if (linkedList.size() == 1) {
            iterator = linkedList2.iterator();
            while (iterator.hasNext()) {
                object = (NetCircuitNode)iterator.next();
                if (!((NetCircuitNode)object).getDri() || ((NetCircuitNode)object).getDriNodeTypeFromModelLayer() != 2) continue;
                linkedList.add(((NetCircuitNode)object).getNetElement());
                break;
            }
        } else if (linkedList.size() == 2) {
            CmsObservable cmsObservable;
            object = "";
            INetElement iNetElement = (INetElement)linkedList.get(0);
            iterator = linkedList3.iterator();
            while (iterator.hasNext()) {
                cmsObservable = (NetCircuitSpan)iterator.next();
                if (((NetCircuitSpan)cmsObservable).getLink().getDst() != iNetElement || !((NetCircuitSpan)cmsObservable).getLink().inBLSR()) continue;
                object = ((NetCircuitSpan)cmsObservable).getLink().blsrRingName();
                break;
            }
            iterator = linkedList2.iterator();
            while (iterator.hasNext()) {
                cmsObservable = (NetCircuitNode)iterator.next();
                if (!((NetCircuitNode)cmsObservable).getDri() || ((NetCircuitNode)cmsObservable).getDriNodeTypeFromModelLayer() != 2) continue;
                boolean bl3 = false;
                Iterator iterator2 = ((NetCircuitNode)cmsObservable).getAllSpansList().iterator();
                while (iterator2.hasNext()) {
                    NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator2.next();
                    if (!netCircuitSpan.getLink().inBLSR() || !netCircuitSpan.getLink().blsrRingName().equals(object)) continue;
                    bl3 = true;
                    break;
                }
                if (bl3) {
                    linkedList.add(1, ((NetCircuitNode)cmsObservable).getNetElement());
                    continue;
                }
                linkedList.addLast(((NetCircuitNode)cmsObservable).getNetElement());
            }
        }
        if (this.dbgOn()) {
            this.debug("getDriNodes returns " + linkedList.size() + " Dri nodes");
            iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                this.debug("dri node " + ((INetElement)iterator.next()).getName());
            }
        }
        return linkedList;
    }

    public List getRingNames() {
        LinkedList<String> linkedList = new LinkedList<String>();
        boolean bl = false;
        linkedList.add("");
        linkedList.add("");
        if (this.getProtType() == 17) {
            if (this.getDriNodes().isEmpty()) {
                return linkedList;
            }
            LinkedList linkedList2 = new LinkedList();
            LinkedList linkedList3 = new LinkedList();
            this.getOrderedNodeAndSpanList(null, null, linkedList2, linkedList3);
            Iterator iterator = linkedList3.iterator();
            while (iterator.hasNext()) {
                NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
                if (!netCircuitSpan.getDri()) continue;
                if (!bl) {
                    bl = true;
                    if (netCircuitSpan.getLink().getProtectionType() != 0 && netCircuitSpan.getLink().getProtectionType() != 4) continue;
                    if (this.dbgOn()) {
                        this.debug("getRingNames set first ring name to " + netCircuitSpan.getLink().blsrRingName());
                    }
                    linkedList.set(0, netCircuitSpan.getLink().blsrRingName());
                    continue;
                }
                String string = (String)linkedList.get(0);
                if (netCircuitSpan.getLink().getProtectionType() != 0 && netCircuitSpan.getLink().getProtectionType() != 4 || netCircuitSpan.getLink().blsrRingName().equals(string)) continue;
                if (this.dbgOn()) {
                    this.debug("getRingNames set second ring name to " + netCircuitSpan.getLink().blsrRingName());
                }
                linkedList.set(1, netCircuitSpan.getLink().blsrRingName());
                break;
            }
        }
        return linkedList;
    }

    public boolean routeEqual(List list) {
        if (list.size() != this.getCircuitSpans().size()) {
            return false;
        }
        Iterator iterator = list.iterator();
        TreeMap<INetLink, NetCircuitSpan> treeMap = new TreeMap<INetLink, NetCircuitSpan>(new NetLinkComparator());
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            treeMap.put(netCircuitSpan.getLink(), netCircuitSpan);
        }
        return ((Object)treeMap).equals(this.cktSpanList);
    }

    public void addSpansAndNodes(List list, Map map) {
        CmsObservable cmsObservable;
        Object object;
        Object object2;
        INetElement iNetElement = this.srcCircuitNode.getNetElement();
        this.removeCktNode(this.srcCircuitNode);
        this.insertCktNode((NetCircuitNode)map.get(iNetElement));
        ((NetCircuitNode)map.get(iNetElement)).setCircuit(this);
        this.srcCircuitNode = (NetCircuitNode)map.get(iNetElement);
        this.srcCircuitNode.setAdminState(this.getAdminState());
        this.setSrcNodeModel(iNetElement.getNodeModel());
        Iterator<Object> iterator = this.srcCircuitNode.getAllSpansList().iterator();
        while (iterator.hasNext()) {
            object2 = (NetCircuitSpan)iterator.next();
            if (list.contains(object2)) continue;
            if (this.srcCircuitNode.biSpans.contains(object2)) {
                this.srcCircuitNode.biSpans.remove(object2);
                break;
            }
            this.srcCircuitNode.inSpans.remove(object2);
            break;
        }
        this.srcCircuitNode.insertSource((NetCircuitEnd)this.getPrimarySource());
        this.srcCircuitNode.setupConnListOnCreation();
        object2 = this.getPrimaryDrop().getNetElement();
        NetCircuitNode netCircuitNode = (NetCircuitNode)this.getCircuitNodeFromNE((INetElement)object2);
        this.removeCktNode(netCircuitNode);
        netCircuitNode = (NetCircuitNode)map.get(object2);
        this.insertCktNode(netCircuitNode);
        netCircuitNode.setCircuit(this);
        netCircuitNode.setAdminState(this.getAdminState());
        iterator = netCircuitNode.getAllSpansList().iterator();
        while (iterator.hasNext()) {
            object = (NetCircuitSpan)iterator.next();
            if (list.contains(object)) continue;
            if (netCircuitNode.biSpans.contains(object)) {
                netCircuitNode.biSpans.remove(object);
                break;
            }
            netCircuitNode.outSpans.remove(object);
            break;
        }
        netCircuitNode.insertDrop((NetCircuitEnd)this.getPrimaryDrop());
        netCircuitNode.setupConnListOnCreation();
        iterator = list.iterator();
        object = new LinkedList();
        while (iterator.hasNext()) {
            cmsObservable = (NetCircuitSpan)iterator.next();
            this.insertCktSpan((NetCircuitSpan)cmsObservable);
            ((NetCircuitSpan)cmsObservable).setCircuit(this);
            if (!((LinkedList)object).contains(((NetCircuitSpan)cmsObservable).getLink().getSrc())) {
                ((LinkedList)object).add(((NetCircuitSpan)cmsObservable).getLink().getSrc());
            }
            if (((LinkedList)object).contains(((NetCircuitSpan)cmsObservable).getLink().getDst())) continue;
            ((LinkedList)object).add(((NetCircuitSpan)cmsObservable).getLink().getDst());
        }
        iterator = map.values().iterator();
        while (iterator.hasNext()) {
            cmsObservable = (NetCircuitNode)iterator.next();
            if (this.getCircuitNodes().contains((Object)cmsObservable) || !((LinkedList)object).contains(((NetCircuitNode)cmsObservable).getNetElement())) continue;
            this.insertCktNode((NetCircuitNode)cmsObservable);
            ((NetCircuitNode)cmsObservable).setCircuit(this);
            ((NetCircuitNode)cmsObservable).setAdminState(this.getAdminState());
        }
    }

    protected void initVcatGroup(NetVcatGroup netVcatGroup) {
        this.setVcatGroup(netVcatGroup);
        this.memberStatusMap = Collections.synchronizedMap(new HashMap());
        this.prevDropList = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteVcatGroup() {
        this.setVcatGroup(null);
        Object object = this.memberStatusMap;
        synchronized (object) {
            if (this.memberStatusMap != null) {
                this.memberStatusMap.clear();
            }
            this.memberStatusMap = null;
        }
        object = this.prevDropList;
        synchronized (object) {
            if (this.prevDropList != null) {
                this.prevDropList.clear();
            }
            this.prevDropList = null;
        }
    }

    protected void setVcatGroup(NetVcatGroup netVcatGroup) {
        this.vcatGroup = netVcatGroup;
        this.setChanged();
    }

    protected NetVcatGroup getVcatGroup() {
        return this.vcatGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMemberStatus(INetCircuitEnd iNetCircuitEnd) {
        Map map = this.memberStatusMap;
        synchronized (map) {
            Integer n = (Integer)this.memberStatusMap.get(iNetCircuitEnd);
            if (n != null) {
                return n;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMemberStatus(INetCircuitEnd iNetCircuitEnd, int n) {
        Map map = this.memberStatusMap;
        synchronized (map) {
            this.memberStatusMap.put(iNetCircuitEnd, new Integer(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMemberStatus(INetCircuitEnd iNetCircuitEnd) {
        Map map = this.memberStatusMap;
        synchronized (map) {
            this.memberStatusMap.remove(iNetCircuitEnd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map getMemberStatusMap() {
        HashMap hashMap;
        Map map = this.memberStatusMap;
        synchronized (map) {
            hashMap = new HashMap(this.memberStatusMap);
        }
        return hashMap;
    }

    public boolean isMemberOfVcat() {
        return this.vcatGroup != null;
    }

    public int getMemberNumber() {
        int n = this.getPrimarySource().getPathIdentifier();
        if (n != 0) {
            return n;
        }
        n = this.getPrimaryDrop().getPathIdentifier();
        return n;
    }

    public void setMemberNumber(int n) {
        Iterator iterator = this.getCktSources().iterator();
        while (iterator.hasNext()) {
            ((NetCircuitEnd)iterator.next()).setPathIdentifier(n);
        }
        iterator = this.getCktDrops().iterator();
        while (iterator.hasNext()) {
            ((NetCircuitDropInfo)iterator.next()).setPathIdentifier(n);
        }
    }

    public String getFullCircuitName() {
        if (this.isMemberOfVcat()) {
            return this.getVcatGroup().getCircuitName() + " (" + this.getCircuitName() + ")";
        }
        return this.getCircuitName();
    }

    protected NetCircuitEnd getCktEndFromTermEnd(INetCircuitEnd iNetCircuitEnd) {
        NetCircuitEnd netCircuitEnd;
        Iterator iterator = this.getSources().iterator();
        while (iterator.hasNext()) {
            netCircuitEnd = (NetCircuitEnd)iterator.next();
            if (netCircuitEnd.getNetElement() != iNetCircuitEnd.getNetElement() || netCircuitEnd.getEntityIndex() != iNetCircuitEnd.getEntityIndex()) continue;
            return NetCircuitEndFactory.createCircuitEnd(this.getCircuitType(), netCircuitEnd);
        }
        iterator = this.getDrops().iterator();
        while (iterator.hasNext()) {
            netCircuitEnd = ((NetCircuitDropInfo)iterator.next()).getNetCktEnd();
            if (netCircuitEnd.getNetElement() != iNetCircuitEnd.getNetElement() || netCircuitEnd.getEntityIndex() != iNetCircuitEnd.getEntityIndex()) continue;
            return NetCircuitEndFactory.createCircuitEnd(this.getCircuitType(), netCircuitEnd);
        }
        return null;
    }

    protected NetCircuitEnd getTermEndFromCktEnd(INetCircuitEnd iNetCircuitEnd) {
        NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createCircuitEnd(this.getCircuitType(), iNetCircuitEnd);
        netCircuitEnd.setPathIdentifier(0);
        return netCircuitEnd;
    }

    protected void initSourcesAndDrops(NetCircuitEnd netCircuitEnd, NetCircuitEnd netCircuitEnd2) {
        block11: {
            NetCircuitEnd netCircuitEnd3;
            Iterator iterator;
            if (this.circuitInfoActive()) {
                return;
            }
            if (this.dbgOn()) {
                db.println("initSourcesAndDrops(srcTerm, dstTerm) called");
            }
            if (netCircuitEnd != null) {
                iterator = this.getCktSources().iterator();
                while (iterator.hasNext()) {
                    netCircuitEnd3 = (NetCircuitEnd)iterator.next();
                    if (netCircuitEnd3.getNetElement() != netCircuitEnd.getNetElement() || netCircuitEnd3.getEntityIndex() != netCircuitEnd.getEntityIndex()) continue;
                    if (this.dbgOn()) {
                        db.println("this member ckt (" + this.getCircuitName() + ") already matches src vcat term, no need to swap");
                    }
                    return;
                }
            }
            if (netCircuitEnd2 != null) {
                iterator = this.getCktDrops().iterator();
                while (iterator.hasNext()) {
                    netCircuitEnd3 = ((NetCircuitDropInfo)iterator.next()).getNetCktEnd();
                    if (netCircuitEnd3.getNetElement() != netCircuitEnd2.getNetElement() || netCircuitEnd3.getEntityIndex() != netCircuitEnd2.getEntityIndex()) continue;
                    if (this.dbgOn()) {
                        db.println("this member (" + this.getCircuitName() + ") ckt already matches dst vcat term, no need to swap");
                    }
                    return;
                }
            }
            if (this.dbgOn()) {
                db.println("this member ckt (" + this.getCircuitName() + ") didn't match for either src or dst vcat term, need to swap sources and drops");
            }
            try {
                this.reverseRoutingDir();
            }
            catch (IncorrectCircuitState incorrectCircuitState) {
                if (!this.dbgOn()) break block11;
                db.println("NodeRoutingDirection doesn't allow to reverse the routing dir");
            }
        }
    }

    protected void deleteSpliceListener(INetCircuitEnd iNetCircuitEnd) {
        NetCircuitNode netCircuitNode = (NetCircuitNode)this.getCircuitNodeFromNE(iNetCircuitEnd.getNetElement());
        if (netCircuitNode == null) {
            if (this.dbgOn()) {
                this.debug("deleteSpliceListener(): WARNING: cannot find cktNode for termEnd");
            }
            return;
        }
        NetCircuitEnd netCircuitEnd = this.getCktEndFromTermEnd(iNetCircuitEnd);
        if (netCircuitEnd == null) {
            if (this.dbgOn()) {
                this.debug("deleteSpliceListener(): WARNING: cannot find cktEnd for termEnd");
            }
            return;
        }
        SpliceListenerEntry spliceListenerEntry = netCircuitNode.getSpliceListener(netCircuitEnd, false);
        if (spliceListenerEntry != null) {
            netCircuitNode.deleteSpliceListener(spliceListenerEntry);
        }
        if (netCircuitEnd.getLoNum() != null && (spliceListenerEntry = netCircuitNode.getSpliceListener(netCircuitEnd, true)) != null) {
            netCircuitNode.deleteSpliceListener(spliceListenerEntry);
        }
    }

    protected boolean requireForceDeletion() {
        if (!this.isMemberOfVcat()) {
            return false;
        }
        INodeModel iNodeModel = null;
        NetCircuitEnd netCircuitEnd = null;
        NetVcatTermination netVcatTermination = null;
        NetVcatTermination netVcatTermination2 = null;
        NetCircuitNode netCircuitNode = null;
        List list = this.getCircuitNodes();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int n;
            netCircuitNode = (NetCircuitNode)iterator.next();
            iNodeModel = netCircuitNode.getNodeModel();
            if (!Feature.provides((INodeModel)iNodeModel.getNodeModel(), (Feature)Feature.EXTENDED_ESM) || (n = netCircuitNode.getServiceState()) < 0) continue;
            netCircuitEnd = this.getTermEndFromCktEnd(this.getPrimarySource());
            netVcatTermination = this.getVcatGroup().getVcatTermFromCktEnd(netCircuitEnd);
            netCircuitEnd = this.getTermEndFromCktEnd(this.getPrimaryDrop());
            netVcatTermination2 = this.getVcatGroup().getVcatTermFromCktEnd(netCircuitEnd);
            if ((netVcatTermination == null || netVcatTermination.getNodeModel() != iNodeModel) && (netVcatTermination2 == null || netVcatTermination2.getNodeModel() != iNodeModel) || !NetServiceState.isFormOfIS(n) && !NetServiceState.isFormOfAINS(n)) continue;
            return true;
        }
        return false;
    }

    public boolean isMemberInGroup() {
        return this.isInGroup;
    }

    public boolean isOpenEndedVcatCircuit() {
        return this.vcatGroup.getVcatTermsSize() == 1;
    }

    protected void printChild(SDebug sDebug) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Iterator<Object> iterator;
        if (this.isMemberOfVcat()) {
            sDebug.println("");
            sDebug.println("Member Status Map :");
            iterator = this.getMemberStatusMap().keySet().iterator();
            while (iterator.hasNext()) {
                object4 = (NetCircuitEnd)iterator.next();
                sDebug.println(" " + ((NetCircuitEnd)object4).prettyString());
            }
        }
        sDebug.println("");
        sDebug.println("Circuit Span(s) :");
        iterator = this.getCircuitSpans().iterator();
        while (iterator.hasNext()) {
            object4 = (NetCircuitSpan)iterator.next();
            sDebug.println(" " + ((NetCircuitSpan)object4).prettyString());
            sDebug.println(" " + ((NetCircuitSpan)object4).prettyStringSpanState());
        }
        List list = this.getXmCircuitEnds();
        if (!list.isEmpty()) {
            sDebug.println("");
            sDebug.println("XmCircuitEnds :");
            iterator = list.iterator();
            while (iterator.hasNext()) {
                object3 = (NetCircuitEnd)iterator.next();
                sDebug.println("   " + ((NetCircuitEnd)object3).prettyString());
            }
        }
        if (!(object3 = this.getSrcInternalSpliceLinkEnds()).isEmpty()) {
            sDebug.println("");
            sDebug.println("Source OTT internal splice link endpoints:");
            iterator = object3.iterator();
            while (iterator.hasNext()) {
                object2 = (NetCircuitEnd)iterator.next();
                sDebug.println("   " + ((NetCircuitEnd)object2).prettyString());
            }
        }
        object2 = this.getDstInternalSpliceLinkEnds();
        if (!object3.isEmpty()) {
            sDebug.println("");
            sDebug.println("Destination OTT internal splice link endpoints:");
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (NetCircuitEnd)iterator.next();
                sDebug.println("   " + ((NetCircuitEnd)object).prettyString());
            }
        }
        sDebug.println("");
        sDebug.println("Circuit Node(s) :");
        iterator = this.getCircuitNodes().iterator();
        if (iterator.hasNext()) {
            object = new TreeSet(NetCircuitNode.NetCircuitNodeByNodeNameComparator.instance());
            while (iterator.hasNext()) {
                ((TreeSet)object).add(iterator.next());
            }
            iterator = ((TreeSet)object).iterator();
            while (iterator.hasNext()) {
                NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
                netCircuitNode.prettyPrint(sDebug);
                sDebug.println("");
            }
        }
    }

    public void printDeconstructedConnections(SDebug sDebug) {
        sDebug.println("");
        Iterator iterator = this.getCircuitNodes().iterator();
        if (iterator.hasNext()) {
            TreeSet treeSet = new TreeSet(NetCircuitNode.NetCircuitNodeByNodeNameComparator.instance());
            while (iterator.hasNext()) {
                treeSet.add(iterator.next());
            }
            iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
                netCircuitNode.prettyPrintConnectionList(sDebug);
                sDebug.println("");
            }
        }
    }

    public INetVcatGroup getForwardVcatGroup() {
        return null;
    }

    public INetVcatGroup getReverseVcatGroup() {
        return null;
    }

    public INetVcatTermination getVcatTermFromCktEnd(INetCircuitEnd iNetCircuitEnd) {
        return null;
    }

    public int getConfiguredForwardMemberSize() {
        return 0;
    }

    public int getConfiguredReverseMemberSize() {
        return 0;
    }

    public boolean isSplitRoutingAllowed() {
        return false;
    }

    public boolean useLink(INetLink iNetLink) {
        if (this.getCircuitSpanFromNetLink(iNetLink) != null) {
            return true;
        }
        if (!this.getLinkEndpoints(iNetLink).isEmpty()) {
            return true;
        }
        if (this.getCircuitTypeObj().isLoCircuitType()) {
            INetCircuit iNetCircuit = this.useLAP();
            if (iNetCircuit != null && iNetCircuit.useLink(iNetLink)) {
                return true;
            }
            Iterator iterator = this.getCircuitSpans().iterator();
            while (iterator.hasNext()) {
                INetCircuit iNetCircuit2;
                INetCircuitSpan iNetCircuitSpan = (INetCircuitSpan)iterator.next();
                INetLink iNetLink2 = iNetCircuitSpan.getLink();
                if (!iNetLink2.isLOTunnel() || (iNetCircuit2 = ((NetLink)iNetLink2).getLotCircuit()) == null || !iNetCircuit2.useLink(iNetLink)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isDualConnectionNode(INetElement iNetElement) {
        NetCircuitNode netCircuitNode = (NetCircuitNode)this.getCircuitNodeFromNE(iNetElement);
        return netCircuitNode != null && netCircuitNode instanceof DualConnectionCircuitNode;
    }
}

