/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsCommFailException;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.AllocFailed;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CannotDeleteLastDrop;
import cerent.cms.model.CircuitDropInfo;
import cerent.cms.model.CircuitEnd;
import cerent.cms.model.CircuitId;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.CircuitType;
import cerent.cms.model.CktInfo;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.Feature;
import cerent.cms.model.FramingType;
import cerent.cms.model.IAdminState;
import cerent.cms.model.ICircuitDirection;
import cerent.cms.model.ICircuitDropInfo;
import cerent.cms.model.ICircuitEnd;
import cerent.cms.model.ICircuitFactoryModel;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.ICircuitInfo;
import cerent.cms.model.ICircuitModel;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IFramingType;
import cerent.cms.model.IL2scModuleModel;
import cerent.cms.model.IL2scPosPortModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPathProtection;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IVcatRoutePreference;
import cerent.cms.model.IVlanInfo;
import cerent.cms.model.InvalidCircuitName;
import cerent.cms.model.ModelIndirectObservable;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.OnlyOneDropPerBidirCktAllowed;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.CircuitDropOutstanding;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitDropInfo;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.INetCircuitOperation;
import cerent.cms.ncp.INetCircuitServiceState;
import cerent.cms.ncp.INetCircuitState;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitEndFactory;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitProtType;
import cerent.cms.ncp.NetCircuitWatchDog;
import cerent.cms.ncp.PayloadTypeCompatibility;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ncp.UpdateEventCollector;
import cerent.cms.route.NoRoute;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.cms.vlan.VlanSetManager;
import cerent.util.EnumStrings;
import cerent.util.IHoLoNum;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public abstract class NetCircuit
extends CmsObservable
implements INetCircuit,
IObserver {
    protected Network net = Network.instance();
    protected NetCircuitManager ncMgr = NetCircuitManager.instance();
    protected ICircuitId circuitId;
    protected ICircuitId previousCircuitId;
    protected ICircuitInfo circuitInfo;
    protected ICircuitModel circuitModel;
    protected boolean isCircuitRefValid;
    protected boolean circuitInfoActive;
    protected boolean tl1InfoActive;
    protected boolean tl1Compatible;
    protected int state;
    protected int cktOperation;
    protected int adminState;
    protected int serviceState;
    protected INodeModel srcNodeModel;
    protected NetCircuitProtType protType;
    protected LinkedList pathCosts;
    boolean isDiag = false;
    private List sources;
    private List drops;
    protected UpdateEvent updateEvent;
    protected boolean updateEventQueued;
    private static final SDebug db = new SDebug("NetCircuit");
    static /* synthetic */ Class class$cerent$cms$ncp$INetCircuitCreatStage;

    protected boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    protected void debug(String string) {
        db.println(string);
    }

    protected NetCircuit(CircuitCreatInfo circuitCreatInfo) {
        this.adminState = circuitCreatInfo.adminState();
        this.serviceState = -1;
        this.circuitId = null;
        this.previousCircuitId = null;
        this.circuitInfo = new CktInfo();
        this.circuitModel = null;
        this.pathCosts = new LinkedList();
        this.circuitInfoActive = false;
        this.tl1InfoActive = false;
        this.tl1Compatible = circuitCreatInfo.tl1Compatible();
        this.cktOperation = 0;
        this.circuitInfo.setSrcPoint((ICircuitEnd)NetCircuit.createNullCircuitEnd());
        this.circuitInfo.setSecSrcPoint((ICircuitEnd)NetCircuit.createNullCircuitEnd());
        this.circuitInfo.setDropInfo(new ICircuitDropInfo[0]);
        this.circuitInfo.setVlans(new IVlanInfo[0]);
        this.circuitInfo.setMonitor(circuitCreatInfo.monitor());
        this.circuitInfo.setCircuitSize(circuitCreatInfo.size());
        this.circuitInfo.setCircuitType(circuitCreatInfo.type());
        this.circuitInfo.setDir(circuitCreatInfo.dir());
        this.circuitInfo.setSla(circuitCreatInfo.sla());
        this.circuitInfo.setCircuitName(circuitCreatInfo.name());
        this.circuitInfo.setVcatRoutingPref(0);
        this.protType = new NetCircuitProtType(this);
        this.srcNodeModel = null;
        this.sources = Collections.synchronizedList(new LinkedList());
        this.drops = Collections.synchronizedList(new LinkedList());
        this.initState(0);
        this.isCircuitRefValid = true;
        this.updateEvent = new UpdateEvent();
        this.updateEventQueued = false;
        this.circuitInfo.setCktOptDir(circuitCreatInfo.cktOptDir());
        this.circuitInfo.setCktOptChannel(circuitCreatInfo.cktOptChannel());
        this.isDiag = circuitCreatInfo.isDiag();
        if (this.dbgOn()) {
            this.debug("Creating " + (this.tl1Compatible() ? "TL1-like " : "") + (this.isBidirectional() ? "bidirectional " : "unidirectional ") + (this.isMonitorCircuit() ? "monitor " : "") + EnumStrings.getString((Class)ICircuitType.class, (int)circuitCreatInfo.type()) + ", " + EnumStrings.getString((Class)ICircuitSize.class, (int)circuitCreatInfo.size()) + ", " + "adminState=" + this.translateAdminState(circuitCreatInfo.adminState()) + ", " + "SLA " + circuitCreatInfo.sla());
        }
    }

    public boolean tl1Compatible() {
        return this.tl1Compatible;
    }

    public boolean isDiag() {
        return this.isDiag;
    }

    protected void isDiag(boolean bl) {
        this.isDiag = bl;
    }

    public int getState() {
        return this.state;
    }

    protected void initState(int n) {
        if (this.dbgOn()) {
            db.println("Circuit state init: " + EnumStrings.getString((Class)INetCircuitState.class, (int)n));
        }
        this.state = n;
    }

    public void setState(int n) {
        if (this.state != n) {
            if (this.dbgOn()) {
                db.println("Circuit state change: old = " + EnumStrings.getString((Class)INetCircuitState.class, (int)this.state) + "; new = " + EnumStrings.getString((Class)INetCircuitState.class, (int)n));
            }
            this.state = n;
            this.setChanged();
        }
    }

    public void setDeletionFailureState() {
        if (this.dbgOn()) {
            this.debug("Setting deletion failure state for " + this.getCircuitName() + "(" + NetCircuit.prettyString(this.circuitId) + ")");
        }
        if (!this.circuitInfoActive()) {
            try {
                if (this.isTl1Ckt()) {
                    this.setState(6);
                }
            }
            catch (IncorrectCircuitState incorrectCircuitState) {}
        } else {
            this.setState(4);
        }
    }

    public int getAdminState() {
        return this.adminState;
    }

    public int getServiceState() {
        return this.serviceState;
    }

    protected void setCktOperation(int n) {
        int n2 = this.cktOperation;
        this.cktOperation = n;
        if (this.dbgOn()) {
            db.println("setCktOperation: " + this.getCircuitName() + " old cktOp => " + EnumStrings.getString((Class)INetCircuitOperation.class, (int)n2) + " new cktOp => " + EnumStrings.getString((Class)INetCircuitOperation.class, (int)this.cktOperation));
        }
    }

    protected int getCktOperation() {
        return this.cktOperation;
    }

    public int getProtType() {
        return this.protType.getProtectionType();
    }

    protected boolean setProtType() {
        return this.protType.setProtectionType();
    }

    public int getProtType(List list, List list2) {
        return this.protType.getProtectionType(list, list2);
    }

    public boolean isCircuitProtected() {
        return this.protType.isProtected();
    }

    public boolean isPca() {
        return this.protType.isPca();
    }

    public boolean hasBlsrDri() {
        List list = this.getCircuitNodes();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            INetCircuitNode iNetCircuitNode = (INetCircuitNode)iterator.next();
            if (iNetCircuitNode.getDriNodeType() == 0) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean isNonRevertivePca() {
        return this.protType.isNonRevertivePca(this.getState() == 0);
    }

    public boolean isDri() {
        return this.protType.isDri();
    }

    protected int convertPathProt(int n) {
        if (n == 9) {
            return n;
        }
        int n2 = NetCircuit.isPathFullyProtected(n) ? 0 : 2;
        return n2;
    }

    public int getDropPathProtection() {
        if (this.getDropsSize() == 0) {
            return 2;
        }
        NetCircuitDropInfo netCircuitDropInfo = (NetCircuitDropInfo)this.getCktDrops().get(0);
        int n = netCircuitDropInfo.getPathProt();
        return n;
    }

    public boolean dropsArePathFullyProtected() {
        return this.getDropPathProtection() == 0;
    }

    protected boolean hasOpenEndedSelector() {
        return this.isBidirectional() && this.getDropsSize() == 2 || this.getSourcesSize() == 2;
    }

    public boolean isCircuitRefValid() {
        return this.isCircuitRefValid;
    }

    protected boolean tl1InfoActive() {
        return this.tl1InfoActive;
    }

    protected synchronized void updateCircuitInfo(ICircuitModel iCircuitModel, boolean bl) {
        LinkedList linkedList;
        LinkedList linkedList2;
        if (iCircuitModel == null) {
            return;
        }
        this.circuitModel = iCircuitModel;
        this.circuitInfoActive = true;
        if (this.dbgOn()) {
            this.debug("updateCircuitInfo(" + this.getCircuitName() + ", " + NetCircuit.prettyString(this.circuitId) + ")");
        }
        if (bl) {
            this.addCircuitInfoObserver();
        }
        try {
            if (this.dbgOn()) {
                this.debug("updateCircuitInfo(" + this.getCircuitName() + ", Old Circuit ID " + NetCircuit.prettyString(this.circuitId) + "New Circuit ID " + NetCircuit.prettyString(this.circuitModel.getId()) + "):");
            }
            if (this.circuitId != null && !this.circuitId.equals(this.circuitModel.getId())) {
                INetElement iNetElement;
                if (this.dbgOn()) {
                    this.debug("updateCircuitInfo(" + this.getCircuitName() + ", Old Circuit ID " + NetCircuit.prettyString(this.circuitId) + "New Circuit ID " + NetCircuit.prettyString(this.circuitModel.getId()) + "): Circuit ID Changed. Reloading Circuit Infos");
                }
                if ((iNetElement = this.getSrcNetElement()) == null) {
                    if (this.dbgOn()) {
                        db.println("i/o exception in updating circuit id");
                    }
                    return;
                }
                this.disposeCircuitInfo(true);
                NetCircuitWatchDog.instance().reloadCircuitInfos(iNetElement);
                return;
            }
            this.updateCircuitId(this.circuitModel.getId());
            this.updateCircuitName(this.circuitModel.getName());
            this.circuitInfo.setMonitor(this.circuitModel.getMonitor());
            this.circuitInfo.setCircuitSize(this.circuitModel.getSize());
            if (this.getCircuitTypeObj().isLAPCircuitType()) {
                this.deleteLAPLink(this.circuitModel);
            }
            this.circuitInfo.setCircuitType(this.circuitModel.getType());
            this.circuitInfo.setDir(this.circuitModel.getDirection());
            if (this.srcNodeModel != null && this.srcNodeModel.provides(Feature.UCP_UNIC)) {
                this.circuitInfo.setSla(this.circuitModel.getSla());
            } else {
                this.circuitInfo.setSla((short)0);
            }
            if (this.srcNodeModel != null && this.srcNodeModel.provides(Feature.OCHNC_PROVISIONING)) {
                this.circuitInfo.setCktOptChannel(this.circuitModel.getCktOptChannel());
                this.circuitInfo.setCktOptDir(this.circuitModel.getCktOptDir());
            }
            if (this.srcNodeModel != null && this.srcNodeModel.provides(Feature.VCAT)) {
                this.circuitInfo.setVcatRoutingPref(this.circuitModel.getVcatRoutingPref());
            }
            linkedList2 = new LinkedList();
            linkedList = new LinkedList();
            this.fetchSourcesAndDropsFromCircuitModel(this.circuitModel, linkedList2, linkedList);
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
            if (this.dbgOn()) {
                db.println("updateCircuitInfo: circuitModel object does not exist");
            }
            this.disposeCircuitInfo(true);
            throw abstractCmsObjectNotExistException;
        }
        boolean bl2 = false;
        if (linkedList2.size() == this.getSourcesSize() && linkedList.size() == this.getDropsSize()) {
            Iterator iterator = linkedList2.iterator();
            while (iterator.hasNext()) {
                if (this.isSource((NetCircuitEnd)iterator.next())) continue;
                bl2 = true;
                break;
            }
            iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                NetCircuitDropInfo netCircuitDropInfo = (NetCircuitDropInfo)iterator.next();
                if (this.isDrop(netCircuitDropInfo.getNetCktEnd())) continue;
                bl2 = true;
                break;
            }
        } else {
            bl2 = true;
        }
        if (bl2) {
            if (this.dbgOn()) {
                db.println("updateCircuitInfo: source/drop change:");
                db.println(" sources: old = " + this.getSourcesSize() + ", new = " + linkedList2.size());
                db.println(" drops  : old = " + this.getDropsSize() + ", new = " + linkedList.size());
            }
            this.setSources(linkedList2);
            this.setDrops(linkedList);
            this.updateCircuitSourceInfo();
            this.updateCircuitDropInfo();
            this.conformToCircuitInfo();
        }
        this.completeCheck();
        this.setChanged();
    }

    protected void updateCircuitId(ICircuitId iCircuitId) {
        if (!iCircuitId.equals(this.circuitId)) {
            if (this.dbgOn()) {
                this.debug("updateCircuitId(" + NetCircuit.prettyString(this.circuitId) + "->" + NetCircuit.prettyString(iCircuitId) + ") for " + this.getCircuitName());
            }
            this.previousCircuitId = this.circuitId;
            this.circuitId = iCircuitId;
            this.setChanged();
        }
    }

    protected void deleteLAPLink(ICircuitModel iCircuitModel) {
    }

    protected void fetchSourcesAndDropsFromCircuitModel(ICircuitModel iCircuitModel, List list, List list2) throws AbstractCmsObjectNotExistException {
        NetCircuitEnd netCircuitEnd;
        if (iCircuitModel == null) {
            return;
        }
        if (iCircuitModel.getSrcPoint().getNodeId() != 0 && (netCircuitEnd = NetCircuitEndFactory.createCircuitEnd(iCircuitModel, iCircuitModel.getSrcPoint())) != null) {
            netCircuitEnd.setStage(4);
            list.add(netCircuitEnd);
        }
        if (iCircuitModel.getSecSrcPoint().getNodeId() != 0 && (netCircuitEnd = NetCircuitEndFactory.createCircuitEnd(iCircuitModel, iCircuitModel.getSecSrcPoint())) != null) {
            netCircuitEnd.setStage(4);
            list.add(netCircuitEnd);
        }
        Iterator<ICircuitDropInfo> iterator = Arrays.asList(iCircuitModel.getDropInfo()).iterator();
        while (iterator.hasNext()) {
            ICircuitDropInfo iCircuitDropInfo = iterator.next();
            netCircuitEnd = !this.getCircuitTypeObj().isLAPCircuitType() ? NetCircuitEndFactory.createCircuitEnd(iCircuitModel, iCircuitDropInfo.getDropPoint()) : NetCircuitEndFactory.createLoTunnelCircuitEnd(iCircuitModel, iCircuitDropInfo.getDropPoint());
            if (netCircuitEnd == null) continue;
            netCircuitEnd.setStage(4);
            NetCircuitDropInfo netCircuitDropInfo = new NetCircuitDropInfo(netCircuitEnd, iCircuitDropInfo.getPathProt());
            list2.add(netCircuitDropInfo);
        }
    }

    protected boolean isRepairable() {
        if (this.circuitModel == null) {
            if (this.dbgOn()) {
                db.println("Circuit Model does not exist. It cannot be repaired");
            }
            return false;
        }
        return !NetCircuit.isNullCircuitId(this.circuitId);
    }

    protected synchronized boolean repairCircuit(int n, int n2) throws CircuitProvError {
        INodeModel iNodeModel;
        INetElement iNetElement = this.getNetwork().findNetElem(n2);
        INodeModel iNodeModel2 = iNodeModel = iNetElement == null ? null : iNetElement.getNodeModel();
        if (this.dbgOn()) {
            this.debug("repairCircuit(" + this.getCircuitName() + ", " + NetCircuit.prettyString(this.circuitId) + ")");
        }
        if (!this.isRepairable()) {
            return false;
        }
        if (this.circuitId.getNodeId() == n) {
            ICircuitId iCircuitId;
            ICircuitModel iCircuitModel;
            NetCircuitDropInfo netCircuitDropInfo;
            NetCircuitEnd netCircuitEnd;
            Iterator iterator = this.getCktSources().iterator();
            while (iterator.hasNext()) {
                netCircuitEnd = (NetCircuitEnd)iterator.next();
                netCircuitEnd.setNode(n2);
            }
            iterator = this.getCktDrops().iterator();
            while (iterator.hasNext()) {
                netCircuitDropInfo = (NetCircuitDropInfo)iterator.next();
                if (netCircuitDropInfo.getNetCktEnd().getCircuitEnd().getNodeId() != n) continue;
                netCircuitDropInfo.getNetCktEnd().setNode(n2);
            }
            CktInfo cktInfo = new CktInfo();
            iterator = this.getCktSources().iterator();
            int n3 = 0;
            while (iterator.hasNext()) {
                netCircuitEnd = (NetCircuitEnd)iterator.next();
                if (n3 == 0) {
                    cktInfo.setSrcPoint(netCircuitEnd.getCircuitEnd());
                    ++n3;
                    continue;
                }
                if (n3 != true) continue;
                cktInfo.setSecSrcPoint(netCircuitEnd.getCircuitEnd());
                break;
            }
            if (cktInfo.getSecSrcPoint() == null) {
                cktInfo.setSecSrcPoint(NetCircuit.createNullCircuitEnd());
            }
            ICircuitDropInfo[] iCircuitDropInfoArray = new ICircuitDropInfo[this.getDropsSize()];
            iterator = this.getCktDrops().iterator();
            int n4 = 0;
            while (iterator.hasNext()) {
                netCircuitDropInfo = (NetCircuitDropInfo)iterator.next();
                iCircuitDropInfoArray[n4++] = netCircuitDropInfo.getCircuitDropInfo();
            }
            cktInfo.setDropInfo(iCircuitDropInfoArray);
            VlanSetManager.instance();
            cktInfo.setVlans(VlanSetManager.vlanModelToVlanInfo(this.getVlans()));
            cktInfo.setMonitor(this.isMonitorCircuit());
            cktInfo.setCircuitSize(this.getCircuitSize());
            cktInfo.setCircuitType(this.getCircuitType());
            cktInfo.setDir(this.getCircuitDir());
            cktInfo.setCircuitName(this.getCircuitName());
            cktInfo.setSla(this.getSla());
            if (this.dbgOn()) {
                this.debug("repairCircuit(" + this.getCircuitName() + ", " + NetCircuit.prettyString(this.circuitId) + "): " + "Creating new circuit");
            }
            ICircuitFactoryModel iCircuitFactoryModel = this.srcNodeModel.getCircuitFactoryModel();
            try {
                iCircuitModel = iCircuitFactoryModel.createCircuit((ICircuitInfo)cktInfo);
            }
            catch (CTCUserException cTCUserException) {
                if (this.dbgOn()) {
                    db.println("Unable to create circuit info: " + (Object)((Object)cTCUserException));
                }
                String string = "Unable to create new circuit info";
                if (cTCUserException instanceof InvalidCircuitName) {
                    string = string + "\nInvalid circuit name";
                }
                throw new CircuitProvError(string);
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (this.dbgOn()) {
                    db.println("Unable to create circuit info: " + (Object)((Object)abstractCmsIOException));
                }
                throw new CircuitProvError("Unable to create new circuit info due to IO exception");
            }
            try {
                iCircuitId = iCircuitModel.getId();
            }
            catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                if (this.dbgOn()) {
                    db.println("New CircuitModel disappeared");
                }
                throw new CircuitProvError("New Circuit model disappeared");
            }
            if (this.dbgOn()) {
                this.debug("repairCircuit(" + this.getCircuitName() + ", " + NetCircuit.prettyString(this.circuitId) + ")" + ": New Id = " + NetCircuit.prettyString(iCircuitId) + "; Changing circuit ID on connections");
            }
            this.changeCircuitId(iCircuitId);
            try {
                this.deleteCircuitModel();
            }
            catch (DeletionError deletionError) {
                throw new CircuitProvError("Partial circuit repair");
            }
            return true;
        }
        boolean bl = false;
        if (this.dbgOn()) {
            this.debug("repairCircuit(" + this.getCircuitName() + ", " + NetCircuit.prettyString(this.circuitId) + ")" + ": Checking drops to see if they have to old NodeId");
        }
        Iterator iterator = this.getCktDrops().iterator();
        while (iterator.hasNext()) {
            NetCircuitDropInfo netCircuitDropInfo = (NetCircuitDropInfo)iterator.next();
            if (netCircuitDropInfo.getNetCktEnd().getCircuitEnd().getNodeId() != n) continue;
            ICircuitEnd iCircuitEnd = netCircuitDropInfo.getNetCktEnd().getCircuitEnd();
            IHoLoNum iHoLoNum = iCircuitEnd.getHoLoNum();
            CircuitEnd circuitEnd = new CircuitEnd(n2, iCircuitEnd.getPortNum(), iHoLoNum.getHoNum(), iHoLoNum.getLoNum(), iCircuitEnd.getDropProt(), iCircuitEnd.getPathIdentifier());
            CircuitDropInfo circuitDropInfo = new CircuitDropInfo();
            circuitDropInfo.setDropPoint(circuitEnd);
            circuitDropInfo.setPathProt(netCircuitDropInfo.getPathProt());
            try {
                if (this.dbgOn()) {
                    this.debug("repairCircuit(" + this.getCircuitName() + ", " + NetCircuit.prettyString(this.circuitId) + ")" + ": Modifying drop in circuitModel");
                }
                this.circuitModel.addDrop((ICircuitDropInfo)circuitDropInfo);
                this.circuitModel.delDrop(iCircuitEnd);
            }
            catch (CTCUserException cTCUserException) {
                if (this.dbgOn()) {
                    db.println(" repairCircuit - unexpected exception " + (Object)((Object)cTCUserException));
                }
                throw new CircuitProvError("Unable add/delete drop into circuit");
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (this.dbgOn()) {
                    db.println("repairCircuit - " + (Object)((Object)abstractCmsIOException));
                }
                throw new CircuitProvError("Unable to add/delete drop into circuit due to IO exception");
            }
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDiscoveredCircuitInfo(INodeModel iNodeModel, ICircuitModel iCircuitModel) throws AbstractCmsIOException {
        NetCircuit netCircuit = this;
        synchronized (netCircuit) {
            if (!this.isCircuitRefValid()) {
                return;
            }
            if (this.circuitInfoActive()) {
                if (this.deletedEventPending()) {
                    if (this.dbgOn()) {
                        this.debug("Processing circuitInfo delete event for (Id = " + NetCircuit.prettyString(this.circuitId) + ") at " + iNodeModel.getName());
                    }
                    this.disposeCircuitInfo(false);
                } else {
                    return;
                }
            }
            if (this.dbgOn()) {
                this.debug("Adding discovered circuitinfo to circuit (Id = " + NetCircuit.prettyString(this.circuitId) + ") at " + iNodeModel.getName());
            }
            this.srcNodeModel = iNodeModel;
            if (this.getState() == 5 || this.getState() == 6) {
                this.setState(4);
            }
            try {
                this.updateCircuitInfo(iCircuitModel, true);
                this.reloadTl1Objects();
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                this.disposeCircuitInfo(true);
                throw abstractCmsIOException;
            }
        }
        if (NetCircuitWatchDog.instance().dumpDb.isEventLogEnabled()) {
            UpdateEventCollector.instance().LogEvent("NCkt::addDiscoveredCktInfo : cktId: " + NetCircuit.prettyString(this.circuitId) + " node: " + iNodeModel.getName());
        }
        this.notifyChanged();
    }

    protected synchronized void disposeCircuitInfo(boolean bl) {
        if (!this.circuitInfoActive()) {
            if (this.dbgOn()) {
                db.println("disposeCircuitInfo: ERROR-Attempt to dispose inactive or deleted circuitInfo. circuit ID = " + NetCircuit.prettyString(this.circuitId));
            }
            return;
        }
        if (this.dbgOn()) {
            db.println("disposeCircuitInfo for circuit " + NetCircuit.prettyString(this.circuitId));
        }
        this.circuitInfoActive = false;
        if (this.getCktOperation() != 1) {
            this.disposeCircuitInfoAtNodes();
            this.srcNodeModel = null;
            this.setSources(null);
            this.setDrops(null);
        }
        this.deleteCircuitInfoObserver();
        this.circuitModel = null;
        this.setChanged();
        if (this.getCktOperation() != 1 && bl) {
            this.checkAndUpdateCircuit();
        }
    }

    public ICircuitId getCircuitId() {
        return this.circuitId;
    }

    public ICircuitId getPreviousCircuitId() {
        return this.previousCircuitId;
    }

    public String getCircuitName() {
        return this.circuitInfo.getCircuitName();
    }

    public void setCircuitName(String string) {
        this.circuitInfo.setCircuitName(string);
    }

    public void updateCircuitName(String string) {
        this.setCircuitName(string);
        this.ncMgr.updateCircuitNameMap(this.circuitId, string);
    }

    public int getCircuitDir() {
        return this.circuitInfo.getDir();
    }

    public void setCircuitDir(int n) {
        if (this.dbgOn()) {
            db.println("setCircuitDir: " + this.getCircuitName());
        }
        this.circuitInfo.setDir(n);
    }

    public int getCircuitOptChannel() {
        return this.circuitInfo.getCktOptChannel();
    }

    public int getCircuitOptDirection() {
        return this.circuitInfo.getCktOptDir();
    }

    public int getCircuitType() {
        return this.circuitInfo.getCircuitType();
    }

    public void setCircuitType(int n) {
        this.circuitInfo.setCircuitType(n);
    }

    public ICircuitType getCircuitTypeObj() {
        return CircuitType.getCircuitType((int)this.getCircuitType());
    }

    public int getCircuitSize() {
        return this.circuitInfo.getCircuitSize();
    }

    public ICircuitSize getCircuitSizeObj() {
        return CircuitSize.getCircuitSize((int)this.getCircuitSize());
    }

    public boolean isMonitorCircuit() {
        return this.circuitInfo.getMonitor();
    }

    public short getSla() {
        return this.circuitInfo.getSla();
    }

    public int getVcatRoutingPref() {
        return this.circuitInfo.getVcatRoutingPref();
    }

    public boolean isBidirectional() {
        return this.getCircuitDir() == 1;
    }

    public boolean supportsISTU() {
        return false;
    }

    public List getAvailDropPorts(INodeModel iNodeModel, CircuitCreatInfo circuitCreatInfo, boolean bl) {
        Object object;
        IEntityModel iEntityModel;
        if (this.dbgOn()) {
            this.debug("getAvailDropPorts() at " + iNodeModel.getName());
        }
        List list = this.ncMgr.getAvailPortEntities(iNodeModel, circuitCreatInfo, bl, this);
        try {
            iEntityModel = this.getPrimarySource().getEntityModel();
        }
        catch (ObjNotFound objNotFound) {
            iEntityModel = null;
        }
        List list2 = new LinkedList<IEntityModel>();
        ICircuitType iCircuitType = this.getCircuitTypeObj();
        if (iCircuitType.isOchncType() || iCircuitType.isOchccCircuitType()) {
            return list;
        }
        if (iCircuitType.isEthernetCircuitType() || iCircuitType.isTunnelCircuitType()) {
            if (this.state != 0) {
                list2 = this.additionFilter(list);
            }
        } else if (iEntityModel != null) {
            list2 = this.filterAvailDropEntities(iEntityModel, list);
        }
        LinkedList<IEntityModel> linkedList = list2;
        if (this.state == 0 && this.isBidirectional()) {
            linkedList = new LinkedList();
            object = list2.iterator();
            while (object.hasNext()) {
                Object object2;
                IEntityModel iEntityModel2 = (IEntityModel)object.next();
                if (iEntityModel2 == null) continue;
                boolean bl2 = false;
                Iterator iterator = this.getCktSources().iterator();
                while (iterator.hasNext() && !bl2) {
                    object2 = (NetCircuitEnd)iterator.next();
                    if (object2 == null || ((NetCircuitEnd)object2).getNodeId() != iEntityModel2.getNodeModel().getNodeId() || ((NetCircuitEnd)object2).getEntityIndex() != iEntityModel2.getIndex()) continue;
                    bl2 = true;
                }
                if (bl2) {
                    object2 = this.ncMgr.getAvailPortPaths(iNodeModel, iEntityModel2, this.getCircuitType(), this.getCircuitSize(), this.getConfiguredForwardMemberSize(), this.getCktSources());
                    if (object2 == null || object2.isEmpty()) continue;
                    linkedList.add(iEntityModel2);
                    continue;
                }
                linkedList.add(iEntityModel2);
            }
        } else if (this.state == 1 && !this.isBidirectional() && !this.isMonitorCircuit() && this.getPrimarySource().getNodeModel() == iNodeModel && this.getSecondarySource() == null) {
            object = (NetCircuitEnd)this.getPrimarySource();
            NetCircuitDropInfo netCircuitDropInfo = new NetCircuitDropInfo((NetCircuitEnd)object, 0);
            if (!this.getCktDrops().contains(netCircuitDropInfo) && iEntityModel != null && !linkedList.contains(iEntityModel)) {
                linkedList.add(iEntityModel);
            }
        }
        if (iCircuitType.isLoCircuitType() && this.useLAP() == null && this.getSrcNetElement().getNodeId() != iNodeModel.getNodeId()) {
            object = this.ncMgr.getAvailLAPEntities(iNodeModel, this.getCircuitSize(), bl, this);
            linkedList.addAll((Collection<IEntityModel>)object);
        }
        if (iCircuitType.isVcatCircuitType()) {
            this.filterOnVcatRestrictions(iEntityModel, linkedList, circuitCreatInfo.lcasMode());
        }
        if (iEntityModel != null) {
            int n = iEntityModel.getModuleModel().getEqType();
            if (this.dbgOn()) {
                this.debug("getAvailDropPorts() ML2 check for srcEqType " + n);
            }
            if (n == 102 || n == 103 || n == 221) {
                if (this.dbgOn()) {
                    this.debug("getAvailDropPorts() has " + linkedList.size() + " entities before ML2 check");
                }
                this.filterMLPorts(iEntityModel, linkedList);
            }
        }
        if (this.dbgOn()) {
            this.debug("getAvailDropPorts() returning " + linkedList.size() + " entities");
        }
        return linkedList;
    }

    private void filterMLPorts(IEntityModel iEntityModel, List list) {
        INetCircuitEnd iNetCircuitEnd = this.getPrimarySource();
        if (!Feature.provides((INodeModel)iNetCircuitEnd.getNodeModel(), (Feature)Feature.RPR_802_17)) {
            if (this.dbgOn()) {
                this.debug("East-west enforcement is not supported for NE version:" + iNetCircuitEnd.getNodeModel().getSwVersion());
            }
            return;
        }
        int n = iEntityModel.getPort();
        boolean bl = iEntityModel.inRPRMode();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IEntityModel iEntityModel2 = (IEntityModel)iterator.next();
            int n2 = iEntityModel2.getModuleModel().getEqType();
            if (!Feature.provides((INodeModel)iEntityModel2.getNodeModel(), (Feature)Feature.RPR_802_17)) {
                if (!this.dbgOn()) continue;
                this.debug("East-west enforcement is not supported for NE version:" + iEntityModel2.getNodeModel().getSwVersion());
                continue;
            }
            if (n2 != 102 && n2 != 103 && n2 != 221) continue;
            if (bl ^ iEntityModel2.inRPRMode()) {
                iterator.remove();
            }
            if (!bl || !iEntityModel2.inRPRMode() || iEntityModel2.getPort() != n) continue;
            iterator.remove();
        }
    }

    public int validateML2CircuitSize() throws CircuitProvError {
        IEntityModel iEntityModel = null;
        IL2scPosPortModel[] iL2scPosPortModelArray = null;
        IL2scPosPortModel iL2scPosPortModel = null;
        INetCircuitEnd iNetCircuitEnd = this.getPrimarySource();
        if (!Feature.provides((INodeModel)iNetCircuitEnd.getNodeModel(), (Feature)Feature.RPR_802_17)) {
            if (this.dbgOn()) {
                this.debug("Circuit Size validation for ML ports is not supported for NE version:" + iNetCircuitEnd.getNodeModel().getSwVersion());
            }
            return 0;
        }
        try {
            iEntityModel = iNetCircuitEnd.getEntityModel();
        }
        catch (ObjNotFound objNotFound) {
            iEntityModel = null;
        }
        int n = iEntityModel.getModuleModel().getEqType();
        if (this.dbgOn()) {
            this.debug("getAvailDropPorts() ML2 check for srcEqType " + n);
        }
        if (n == 102 || n == 103 || n == 221) {
            NetCircuitEnd netCircuitEnd;
            NetCircuit netCircuit;
            if (!iEntityModel.inRPRMode()) {
                return 0;
            }
            int n2 = iEntityModel.getPort();
            iL2scPosPortModelArray = ((IL2scModuleModel)iEntityModel.getModuleModel()).getIL2scPosPorts();
            for (int i = 0; i < iL2scPosPortModelArray.length; ++i) {
                if (iEntityModel.equals(iL2scPosPortModelArray[i])) continue;
                iL2scPosPortModel = iL2scPosPortModelArray[i];
                break;
            }
            if ((netCircuit = (NetCircuit)this.ncMgr.getCircuitFromCircuitEnd(netCircuitEnd = new NetCircuitEnd(iNetCircuitEnd.getNodeModel(), (IEntityModel)iL2scPosPortModel, iNetCircuitEnd.getHoLoNum(), false))) == null) {
                return this.getCircuitSize();
            }
            if (this.getCircuitSize() == netCircuit.getCircuitSize()) {
                return this.getCircuitSize();
            }
            return netCircuit.getCircuitSize();
        }
        return 0;
    }

    public List getAvailDropPoints(INodeModel iNodeModel, IEntityModel iEntityModel) {
        Object object;
        IEntityModel iEntityModel2;
        if (this.dbgOn()) {
            db.println("getAvailDropPoints() for " + this.getCircuitName());
        }
        List list = this.ncMgr.getAvailPortPaths(iNodeModel, iEntityModel, this.getCircuitType(), this.getCircuitSize(), this.getConfiguredForwardMemberSize(), this.getCktSources());
        try {
            iEntityModel2 = this.getPrimarySource().getEntityModel();
        }
        catch (ObjNotFound objNotFound) {
            iEntityModel2 = null;
        }
        if (!this.isBidirectional() && !this.isMonitorCircuit() && this.getPrimarySource() != null && this.getPrimarySource().getNodeModel() == iNodeModel && iEntityModel2 != null && iEntityModel2 == iEntityModel && this.getSecondarySource() == null) {
            object = (NetCircuitEnd)this.getPrimarySource();
            NetCircuitDropInfo netCircuitDropInfo = new NetCircuitDropInfo((NetCircuitEnd)object, 0);
            if (!this.getCktDrops().contains(netCircuitDropInfo)) {
                list.add(object);
            }
        }
        if (this.getCircuitTypeObj().isLoCircuitType() && this.useLAP() == null && this.getSrcNetElement().getNodeId() != iNodeModel.getNodeId()) {
            object = this.ncMgr.getAvailLAPPaths(iNodeModel, iEntityModel, this.getCircuitSize(), this);
            list.addAll(object);
        }
        if (this.dbgOn()) {
            this.debug("getAvailDropPoints() returning " + list.size() + " points");
        }
        return list;
    }

    protected List filterAvailDropEntities(IEntityModel iEntityModel, List list) {
        IFramingType iFramingType;
        ICircuitType iCircuitType = this.getCircuitTypeObj();
        if (iCircuitType.isLoCircuitType() || iCircuitType.isLoVcatCircuitType() ? !(iFramingType = FramingType.getFramingType((int)iEntityModel.getNodeModel().getFramingType())).isSonet() : iCircuitType.isHoCircuitType() || iCircuitType.isHoVcatCircuitType()) {
            return this.filterOnPayloadType(iEntityModel, list);
        }
        return list;
    }

    private List filterOnPayloadType(IEntityModel iEntityModel, List list) {
        LinkedList<IEntityModel> linkedList = new LinkedList<IEntityModel>();
        int n = this.getCircuitDir();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IEntityModel iEntityModel2 = (IEntityModel)iterator.next();
            if (!PayloadTypeCompatibility.isCompatible(iEntityModel, iEntityModel2, n)) continue;
            linkedList.add(iEntityModel2);
        }
        return linkedList;
    }

    private void filterOnVcatRestrictions(IEntityModel iEntityModel, List list, int n) {
        if (n != 1) {
            return;
        }
        int n2 = iEntityModel.getPayloadType();
        if (n2 != 18) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IEntityModel iEntityModel2 = (IEntityModel)iterator.next();
            int n3 = iEntityModel2.getEqType();
            int n4 = iEntityModel.getEqType();
            if (n4 != 165 || n3 != 165) continue;
            iterator.remove();
        }
    }

    private List additionFilter(List list) {
        if (this.dbgOn()) {
            db.println("additionFilter()");
        }
        LinkedList<IEntityModel> linkedList = new LinkedList<IEntityModel>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IEntityModel iEntityModel = (IEntityModel)iterator.next();
            int n = iEntityModel.getPayloadType();
            int n2 = iEntityModel.getNodeModel().getFramingType();
            IFramingType iFramingType = FramingType.getFramingType((int)n2);
            if ((n != 1 && n != 7 && n != 2 || !iFramingType.isSonet()) && (n != 9 || !iFramingType.isSdh())) continue;
            linkedList.add(iEntityModel);
        }
        return linkedList;
    }

    public INetCircuitEnd getPrimarySource() {
        if (this.sources.size() < 1) {
            return null;
        }
        return (INetCircuitEnd)this.getCktSources().get(0);
    }

    public INetCircuitEnd getSecondarySource() {
        if (this.sources.size() < 2) {
            return null;
        }
        return (INetCircuitEnd)this.getCktSources().get(1);
    }

    public INetCircuitEnd getPrimaryDrop() {
        if (this.drops.size() < 1) {
            return null;
        }
        return (INetCircuitEnd)this.getDropCktEnds().get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getCktSources() {
        LinkedList linkedList;
        List list = this.sources;
        synchronized (list) {
            linkedList = new LinkedList(this.sources);
        }
        return linkedList;
    }

    public List getSources() {
        return this.getCktSources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getCktDrops() {
        LinkedList linkedList;
        List list = this.drops;
        synchronized (list) {
            linkedList = new LinkedList(this.drops);
        }
        return linkedList;
    }

    public List getDrops() {
        return this.getCktDrops();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSources(List list) {
        List list2 = this.sources;
        synchronized (list2) {
            this.sources.clear();
            if (list != null) {
                this.sources.addAll(list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDrops(List list) {
        List list2 = this.drops;
        synchronized (list2) {
            this.drops.clear();
            if (list != null) {
                this.drops.addAll(list);
            }
        }
    }

    protected int getSourcesSize() {
        return this.sources.size();
    }

    protected int getDropsSize() {
        return this.drops.size();
    }

    public List getDropCktEnds() {
        LinkedList<NetCircuitEnd> linkedList = new LinkedList<NetCircuitEnd>();
        Iterator iterator = this.getCktDrops().iterator();
        while (iterator.hasNext()) {
            NetCircuitDropInfo netCircuitDropInfo = (NetCircuitDropInfo)iterator.next();
            linkedList.add(netCircuitDropInfo.getNetCktEnd());
        }
        return linkedList;
    }

    protected LinkedList getCktInfoEndPoints() {
        LinkedList linkedList = new LinkedList(this.getSources());
        linkedList.addAll((LinkedList)this.getDropCktEnds());
        return linkedList;
    }

    protected int getUniqueNumSrcDstNodes() {
        HashSet<INodeModel> hashSet = new HashSet<INodeModel>();
        Iterator iterator = this.getCktSources().iterator();
        for (int i = 0; i < 2; ++i) {
            while (iterator.hasNext()) {
                NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
                hashSet.add(netCircuitEnd.getNodeModel());
            }
            iterator = this.getDropCktEnds().iterator();
        }
        return hashSet.size();
    }

    public boolean isSource(NetCircuitEnd netCircuitEnd) {
        Iterator iterator = this.getCktSources().iterator();
        while (iterator.hasNext()) {
            NetCircuitEnd netCircuitEnd2 = (NetCircuitEnd)iterator.next();
            if (!netCircuitEnd2.equals(netCircuitEnd)) continue;
            return true;
        }
        return false;
    }

    public boolean isDrop(NetCircuitEnd netCircuitEnd) {
        Iterator iterator = this.getDropCktEnds().iterator();
        while (iterator.hasNext()) {
            NetCircuitEnd netCircuitEnd2 = (NetCircuitEnd)iterator.next();
            if (!netCircuitEnd2.equals(netCircuitEnd)) continue;
            return true;
        }
        return false;
    }

    public boolean isEndPoint(INetElement iNetElement) {
        return this.isSource(iNetElement) || this.isDrop(iNetElement);
    }

    public boolean isSource(INetElement iNetElement) {
        if (!this.circuitInfoActive()) {
            return false;
        }
        Iterator iterator = this.getCktSources().iterator();
        while (iterator.hasNext()) {
            NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
            if (!iNetElement.equals(netCircuitEnd.getNetElement())) continue;
            return true;
        }
        return false;
    }

    public boolean isDrop(INetElement iNetElement) {
        Iterator iterator = this.getDropCktEnds().iterator();
        while (iterator.hasNext()) {
            NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
            if (!iNetElement.equals(netCircuitEnd.getNetElement())) continue;
            return true;
        }
        return false;
    }

    public INetElement getSourceNE() {
        INetCircuitEnd iNetCircuitEnd = this.getPrimarySource();
        if (iNetCircuitEnd != null) {
            return iNetCircuitEnd.getNetElement();
        }
        return null;
    }

    public INetElement getDropNE() {
        INetCircuitEnd iNetCircuitEnd = this.getPrimaryDrop();
        if (iNetCircuitEnd != null) {
            return iNetCircuitEnd.getNetElement();
        }
        return null;
    }

    protected void updateCircuitSourceInfo() {
        this.circuitInfo.setSrcPoint((ICircuitEnd)NetCircuit.createNullCircuitEnd());
        this.circuitInfo.setSecSrcPoint((ICircuitEnd)NetCircuit.createNullCircuitEnd());
        int n = 0;
        Iterator iterator = this.getCktSources().iterator();
        while (iterator.hasNext()) {
            NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
            if (n == 0) {
                this.circuitInfo.setSrcPoint(netCircuitEnd.getCircuitEnd());
                ++n;
                continue;
            }
            if (n != true) continue;
            this.circuitInfo.setSecSrcPoint(netCircuitEnd.getCircuitEnd());
            break;
        }
    }

    protected void updateCircuitDropInfo() {
        ICircuitDropInfo[] iCircuitDropInfoArray = new ICircuitDropInfo[this.getDropsSize()];
        int n = 0;
        Iterator iterator = this.getCktDrops().iterator();
        while (iterator.hasNext()) {
            NetCircuitDropInfo netCircuitDropInfo = (NetCircuitDropInfo)iterator.next();
            iCircuitDropInfoArray[n++] = netCircuitDropInfo.getCircuitDropInfo();
        }
        this.circuitInfo.setDropInfo(iCircuitDropInfoArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertSource(NetCircuitEnd netCircuitEnd) {
        List list = this.sources;
        synchronized (list) {
            if (this.sources.contains(netCircuitEnd)) {
                if (this.dbgOn()) {
                    db.println("insertSource: source already in list!");
                }
                return;
            }
            if (this.dbgOn()) {
                db.println("sources.add(" + netCircuitEnd.prettyString() + ")");
            }
            this.sources.add(netCircuitEnd);
        }
        this.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertDrop(NetCircuitDropInfo netCircuitDropInfo) {
        List list = this.drops;
        synchronized (list) {
            if (this.drops.contains(netCircuitDropInfo)) {
                if (this.dbgOn()) {
                    db.println("insertDrop: drop already in list!");
                }
                return;
            }
            if (this.dbgOn()) {
                db.println("drops.add(" + netCircuitDropInfo.getNetCktEnd().prettyString() + ")");
            }
            this.drops.add(netCircuitDropInfo);
        }
        this.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDrop(NetCircuitDropInfo netCircuitDropInfo) {
        List list = this.drops;
        synchronized (list) {
            if (!this.drops.contains(netCircuitDropInfo)) {
                if (this.dbgOn()) {
                    db.println("removeDrop: drop not found!");
                }
                return;
            }
            if (this.dbgOn()) {
                db.println("drops.remove(" + netCircuitDropInfo.getNetCktEnd().prettyString() + ")");
            }
            this.drops.remove(netCircuitDropInfo);
        }
        this.setChanged();
    }

    protected void addCircuitInfoObserver() {
        if (this.srcNodeModel == null || this.circuitModel == null) {
            if (this.dbgOn()) {
                db.println("Warning! addCircuitInfoObserver: srcNode or circuitModel null");
            }
            return;
        }
        if (this.dbgOn()) {
            db.println("addCircuitInfoObserver for " + this.getCircuitName());
        }
        this.updateEvent.init();
        ModelIndirectObservable.instance().addObserver((IObservable)this.circuitModel, this);
    }

    protected void deleteCircuitInfoObserver() {
        if (this.circuitModel != null) {
            if (this.dbgOn()) {
                db.println("deleteCircuitInfoObserver for " + this.getCircuitName());
            }
            try {
                ModelIndirectObservable.instance().deleteObserver((IObservable)this.circuitModel, this);
            }
            catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                // empty catch block
            }
            this.updateEvent.init();
        }
    }

    protected List addDropToCircuitInfo() throws CircuitProvError {
        if (this.dbgOn()) {
            db.println("addDropToCircuitInfo: " + this.getDropsSize() + " drop(s)");
        }
        LinkedList<NetCircuitDropInfo> linkedList = new LinkedList<NetCircuitDropInfo>();
        Iterator iterator = this.getCktDrops().iterator();
        while (iterator.hasNext()) {
            NetCircuitDropInfo netCircuitDropInfo = (NetCircuitDropInfo)iterator.next();
            if (netCircuitDropInfo.getNetCktEnd().getStage() != 3) continue;
            try {
                this.circuitModel.addDrop(netCircuitDropInfo.getCircuitDropInfo());
                linkedList.add(netCircuitDropInfo);
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (this.dbgOn()) {
                    db.println("Unable to modify circuit info: " + (Object)((Object)abstractCmsIOException));
                }
                throw new CircuitProvError("Unable to modify circuit info");
            }
            catch (OnlyOneDropPerBidirCktAllowed onlyOneDropPerBidirCktAllowed) {
                if (this.dbgOn()) {
                    db.println("Unable to modify circuit info: " + (Object)((Object)onlyOneDropPerBidirCktAllowed));
                }
                throw new CircuitProvError("Cannot add more than one drop to bidirectional circuit");
            }
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ICircuitId createCircuitInfo(INodeModel iNodeModel, ICircuitInfo iCircuitInfo) throws CircuitProvError {
        ICircuitId iCircuitId;
        int n = 0;
        if (iCircuitInfo.getSrcPoint().getNodeId() != 0) {
            ++n;
        }
        if (iCircuitInfo.getSecSrcPoint().getNodeId() != 0) {
            ++n;
        }
        if (this.dbgOn()) {
            db.println("createCircuitInfo: " + n + " source(s), " + iCircuitInfo.getDropInfo().length + " drop(s)");
        }
        ICircuitFactoryModel iCircuitFactoryModel = iNodeModel.getCircuitFactoryModel();
        Object object = this.ncMgr.getMasterCktListLock();
        synchronized (object) {
            this.ncMgr.removeCircuit(this);
            try {
                this.circuitModel = iCircuitFactoryModel.createCircuit(iCircuitInfo);
                this.circuitInfo.setCircuitName(iCircuitInfo.getCircuitName());
            }
            catch (CTCUserException cTCUserException) {
                if (this.dbgOn()) {
                    db.println("Unable to create circuit info: " + (Object)((Object)cTCUserException));
                }
                String string = "Unable to create circuit info";
                if (cTCUserException instanceof InvalidCircuitName) {
                    string = string + "\nInvalid circuit name";
                }
                throw new CircuitProvError(string);
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (this.dbgOn()) {
                    db.println("Unable to create circuit info: " + (Object)((Object)abstractCmsIOException));
                }
                throw new CircuitProvError("Unable to create circuit info due to IO exception");
            }
            this.circuitInfoActive = true;
            this.addCircuitInfoObserver();
            try {
                iCircuitId = this.circuitModel.getId();
            }
            catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                this.disposeCircuitInfo(true);
                throw new CircuitProvError("Circuit info disappeared");
            }
            catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                this.disposeCircuitInfo(true);
                if (this.dbgOn()) {
                    db.println("Unable to get circuit id: " + (Object)((Object)abstractCmsCommFailException));
                }
                throw new CircuitProvError("Unable to get circuit id");
            }
            this.updateCircuitId(iCircuitId);
            this.ncMgr.insertCircuit(this, false);
        }
        this.checkForDefaultName();
        return iCircuitId;
    }

    private void checkForDefaultName() throws CircuitProvError {
        String string = this.circuitInfo.getCircuitName();
        if (string.equals("")) {
            String string2 = this.deriveDefaultName();
            this.renameCircuit(string2);
        } else if (this.isMonitorCircuit()) {
            String string3;
            String string4 = "::" + this.circuitId.getUniquePart().getUniqueId();
            int n = 48;
            if (string.length() + string4.length() > n) {
                String string5 = "_MON";
                int n2 = string.lastIndexOf(string5);
                string3 = n2 >= 0 ? string.substring(0, n2) : string;
                string3 = string3.substring(0, n - string5.length() - string4.length());
                string3 = string3 + string5 + string4;
            } else {
                string3 = string + string4;
            }
            this.renameCircuit(string3);
        }
    }

    protected void createTl1Info() throws CircuitProvError {
        this.updateCircuitId(new CircuitId(0, 0));
        this.tl1InfoActive = true;
        this.ncMgr.insertCircuit(this, false);
        this.checkForDefaultName();
    }

    protected void addDropCheck(NetCircuitEnd netCircuitEnd, int n) throws SanityCheckFailed, IncorrectCircuitState {
        if (this.getState() != 1 && this.getState() != 0 && this.getState() != 5) {
            throw new IncorrectCircuitState("Drop can be added only for DISCOVERED, DISCOVERED_TL1, and CREATING circuits");
        }
        if (this.inconsistentDropPathProtection(n)) {
            if (this.dbgOn()) {
                db.println("addDrop: ERROR - new drop pathProt != existing drop pathProt");
            }
            throw new SanityCheckFailed("All circuit drops must have matching path protection");
        }
        if (this.isBidirectional()) {
            if (this.getCktSources().contains(netCircuitEnd)) {
                if (this.dbgOn()) {
                    db.println("addDrop: drop same as source");
                }
                throw new SanityCheckFailed("Source and Destination are identical");
            }
            if (this.getState() == 1 && !this.getCircuitTypeObj().isEthernetCircuitType()) {
                throw new SanityCheckFailed("Cannot add a drop to a discovered bi-directional circuit ");
            }
        }
    }

    private boolean inconsistentDropPathProtection(int n) {
        return this.getState() == 1 && n != this.getDropPathProtection() || this.getState() == 5 && !this.isCircuitProtected() && n == 0;
    }

    public synchronized void routeDrop(INetCircuitEnd iNetCircuitEnd, INetCircuitEnd iNetCircuitEnd2, RoutePrefs routePrefs) throws AllocFailed, ObjNotFound, NoRoute, CircuitDropOutstanding, IncorrectCircuitState, SanityCheckFailed, AbstractCmsIOException {
        INetElement iNetElement;
        try {
            iNetElement = iNetCircuitEnd2.getNetElement();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            db.println("Unable to find net element for secondary drop");
            throw new ObjNotFound("Network Element not found");
        }
        routePrefs.setSecDst(iNetElement);
        try {
            this.routeDrop(iNetCircuitEnd, routePrefs);
        }
        catch (SanityCheckFailed sanityCheckFailed) {
            if (this.dbgOn()) {
                db.println("unable to route to drop " + sanityCheckFailed.getMessage());
            }
            SDebug.printStackTrace((Throwable)sanityCheckFailed);
            routePrefs.setSecDst(null);
            throw sanityCheckFailed;
        }
        catch (NoRoute noRoute) {
            if (this.dbgOn()) {
                db.println("unable to route to drop " + noRoute.getMessage());
            }
            SDebug.printStackTrace((Throwable)((Object)noRoute));
            throw noRoute;
        }
        catch (AllocFailed allocFailed) {
            if (this.dbgOn()) {
                db.println("unable to route to drop " + allocFailed.getMessage());
            }
            SDebug.printStackTrace((Throwable)((Object)allocFailed));
            throw allocFailed;
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            if (this.dbgOn()) {
                db.println("unable to route to drop " + abstractCmsIOException.getMessage());
            }
            SDebug.printStackTrace((Throwable)abstractCmsIOException);
            throw abstractCmsIOException;
        }
        this.addDrop(iNetCircuitEnd2, routePrefs);
    }

    public synchronized void routeDrop(INetCircuitEnd iNetCircuitEnd, RoutePrefs routePrefs) throws AllocFailed, ObjNotFound, NoRoute, CircuitDropOutstanding, IncorrectCircuitState, SanityCheckFailed, AbstractCmsIOException {
        INetElement iNetElement;
        if (this.dbgOn()) {
            db.println("routeDrop called for " + this.getCircuitName() + ". drop = " + ((NetCircuitEnd)iNetCircuitEnd).prettyString());
        }
        if (!this.isCircuitRefValid()) {
            throw new IncorrectCircuitState("Circuit already destroyed");
        }
        try {
            iNetElement = iNetCircuitEnd.getNetElement();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            db.println("i/o exception in routeDrop");
            SDebug.printStackTrace((Throwable)abstractCmsIOException);
            iNetElement = null;
        }
        if (iNetElement == null) {
            if (this.dbgOn()) {
                db.println("routeDrop: unable to find NE");
            }
            throw new ObjNotFound("Network Element not found");
        }
        if (this.doesCircuitUseNetElem(iNetElement) && this.state != 0) {
            this.addDrop(iNetCircuitEnd, routePrefs);
            return;
        }
        this.addDrop(iNetCircuitEnd, routePrefs);
        if (!this.doesCircuitUseNetElem(iNetElement)) {
            throw new ObjNotFound("CircuitNode not found");
        }
        try {
            this.routeCurrentDrop(iNetElement, routePrefs, true);
        }
        catch (NoRoute noRoute) {
            SDebug.printStackTrace((Throwable)((Object)noRoute));
            if (this.dbgOn()) {
                db.println("unable to route to drop " + noRoute.getMessage());
            }
            this.deleteDrops(iNetCircuitEnd);
            throw noRoute;
        }
        catch (AllocFailed allocFailed) {
            if (this.dbgOn()) {
                db.println("unable to route to drop " + allocFailed.getMessage());
            }
            SDebug.printStackTrace((Throwable)((Object)allocFailed));
            this.deleteDrops(iNetCircuitEnd);
            throw allocFailed;
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            if (this.dbgOn()) {
                db.println("unable to route to drop " + abstractCmsIOException.getMessage());
            }
            SDebug.printStackTrace((Throwable)abstractCmsIOException);
            this.deleteDrops(iNetCircuitEnd);
            throw abstractCmsIOException;
        }
        catch (SanityCheckFailed sanityCheckFailed) {
            if (this.dbgOn()) {
                db.println("unable to route to drop " + sanityCheckFailed.getMessage());
            }
            SDebug.printStackTrace((Throwable)sanityCheckFailed);
            this.deleteDrops(iNetCircuitEnd);
            throw sanityCheckFailed;
        }
    }

    protected void deleteDrops(INetCircuitEnd iNetCircuitEnd) throws CircuitDropOutstanding, ObjNotFound, IncorrectCircuitState, SanityCheckFailed, AbstractCmsIOException {
        block4: {
            try {
                this.deleteDropCktEnd(iNetCircuitEnd);
            }
            catch (CannotDeleteLastDrop cannotDeleteLastDrop) {
                if (this.dbgOn()) {
                    db.println("Cannot del. last drop: unexpected exception.");
                }
            }
            catch (DeletionError deletionError) {
                if (!this.dbgOn()) break block4;
                db.println("unable to reverse for deleting routed drop encountered exception " + deletionError.getMessage());
            }
        }
    }

    public void deleteDrop(INetCircuitDropInfo iNetCircuitDropInfo) throws CircuitDropOutstanding, ObjNotFound, CannotDeleteLastDrop, IncorrectCircuitState, SanityCheckFailed, DeletionError, AbstractCmsIOException {
        this.deleteDrop(((NetCircuitDropInfo)iNetCircuitDropInfo).getNetCktEnd());
    }

    public List getEtherCircuitNodes() throws IncorrectCircuitState {
        return new LinkedList();
    }

    public List getEtherAddDropCircuitNodes() throws IncorrectCircuitState {
        return new LinkedList();
    }

    protected boolean hasSourceWithNetElement(INetElement iNetElement) {
        Iterator iterator = this.getCktSources().iterator();
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
            bl = netCircuitEnd.usesNetElement(iNetElement);
        }
        return bl;
    }

    public void circuitDeleteCheck() throws IncorrectCircuitState {
        if (this.state == 4 || this.state == 0 || this.state == 8 || this.state == 11) {
            throw new IncorrectCircuitState("Cannot destroy a circuit in transition state");
        }
    }

    protected synchronized void destroyCircuitInfo() throws IncorrectCircuitState, DeletionError {
        if (!this.isCircuitRefValid()) {
            throw new IncorrectCircuitState("Circuit already destroyed");
        }
        if (!this.circuitInfoActive()) {
            return;
        }
        if (this.dbgOn()) {
            this.debug("destroyCircuitInfo(" + this.getCircuitName() + "): Id = " + NetCircuit.prettyString(this.getCircuitId()));
        }
        this.deleteCircuitModel();
        this.disposeCircuitInfo(true);
    }

    protected synchronized void finalDispose() {
        if (this.dbgOn()) {
            this.debug("finalDispose(" + this.getCircuitName() + ", " + NetCircuit.prettyString(this.circuitId) + ")");
        }
        this.protType.dispose();
        this.ncMgr.updateCircuitNameMap(this.circuitId, null);
        this.isCircuitRefValid = false;
        this.ncMgr.removeCircuit(this);
    }

    protected synchronized void renameCircuit(String string) throws CircuitProvError {
        if (!this.isCircuitRefValid()) {
            throw new CircuitProvError("Circuit already destroyed");
        }
        if (this.circuitModel != null) {
            try {
                this.circuitModel.setName(string);
            }
            catch (InvalidCircuitName invalidCircuitName) {
                if (this.dbgOn()) {
                    db.println("rename: Invalid Circuit Name");
                }
                throw new CircuitProvError("Unable to write new circuit name");
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                throw new CircuitProvError("Unable to rename circuit.");
            }
        }
        this.setCircuitName(string);
        this.setChanged();
    }

    protected synchronized boolean isTL1Convertible() {
        boolean bl = false;
        try {
            bl = this.isCircuitRefValid() && !this.hasNullCircuitId() && this.state != 8 && !this.getCircuitTypeObj().isTunnelCircuitType() && !this.getCircuitTypeObj().isLAPCircuitType() && !this.isVlanCapable() && !this.isUcpCircuit();
        }
        catch (IncorrectCircuitState incorrectCircuitState) {
            // empty catch block
        }
        return bl;
    }

    public ICircuitModel circuitModel() {
        return this.circuitModel;
    }

    public void update(IObservable iObservable, Object object) {
        if (iObservable instanceof ICircuitModel) {
            if (((Integer)object).equals(ModelUpdateType.DELETED)) {
                if (this.dbgOn()) {
                    this.debug("ckt.update: DELETED for " + this.getCircuitName() + " (" + NetCircuit.prettyString(this.circuitId) + ")");
                }
                this.updateEvent.deleted = true;
                NetCircuitWatchDog.instance().queueCircuitUpdate(this, this, "deleted");
            } else if (((Integer)object).equals(ModelUpdateType.CHANGED)) {
                if (this.dbgOn()) {
                    this.debug("ckt.update: CHANGED for " + this.getCircuitName() + " (" + NetCircuit.prettyString(this.circuitId) + ")");
                }
                this.updateEvent.changed = true;
                NetCircuitWatchDog.instance().queueCircuitUpdate(this, this, "changed");
            }
        }
    }

    protected void setEventChanged(boolean bl) {
        this.updateEvent.changed = bl;
    }

    private boolean deletedEventPending() {
        return this.updateEvent.deleted;
    }

    protected boolean getUpdateEventQueued() {
        return this.updateEventQueued;
    }

    protected void setUpdateEventQueued(boolean bl) {
        this.updateEventQueued = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runUpdate() {
        boolean bl = this.updateEvent.deleted;
        NetCircuit netCircuit = this;
        synchronized (netCircuit) {
            if (!this.isCircuitRefValid()) {
                return;
            }
            if (this.updateEvent.deleted) {
                this.updateEvent.deleted = false;
                if (this.dbgOn()) {
                    db.println("ckt.runUpdate: DELETED for " + this.getCircuitName());
                }
                this.updateDeleted();
            } else if (this.updateEvent.changed) {
                this.updateEvent.changed = false;
                if (this.dbgOn()) {
                    db.println("ckt.runUpdate: CHANGED for " + this.getCircuitName());
                }
                this.updateChanged();
            }
            this.runChildUpdate();
        }
        if (!this.isCircuitRefValid) {
            this.notifyDeleted();
        } else {
            this.notifyChanged();
        }
        if (NetCircuitWatchDog.instance().dumpDb.isEventLogEnabled()) {
            UpdateEventCollector.instance().LogEvent(" NCkt: runUpdate " + this.getCircuitName() + (bl ? " delete" : " changed") + " event" + ", State: " + EnumStrings.getString((Class)INetCircuitState.class, (int)this.getState()));
        }
    }

    private void updateDeleted() {
        this.disposeCircuitInfo(true);
    }

    private void updateChanged() {
        if (!this.circuitInfoActive()) {
            return;
        }
        if (this.state != 1 && this.state != 4 && this.state != 8) {
            return;
        }
        try {
            this.updateCircuitInfo(this.circuitModel, false);
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            INetElement iNetElement = this.getSrcNetElement();
            this.disposeCircuitInfo(true);
            NetCircuitWatchDog.instance().reloadCircuitInfos(iNetElement);
        }
    }

    protected int srcPayloadType() {
        return this.getPayloadType((NetCircuitEnd)this.getPrimarySource());
    }

    protected int secSrcPayloadType() {
        return this.getPayloadType((NetCircuitEnd)this.getSecondarySource());
    }

    protected int getPayloadType(NetCircuitEnd netCircuitEnd) {
        IEntityModel iEntityModel = null;
        if (netCircuitEnd != null) {
            try {
                iEntityModel = netCircuitEnd.getEntityModel();
            }
            catch (ObjNotFound objNotFound) {
                iEntityModel = null;
            }
            if (iEntityModel != null) {
                return iEntityModel.getPayloadType();
            }
        }
        return 0;
    }

    protected Network getNetwork() {
        return this.net;
    }

    public INetElement getSrcNetElement() {
        INetElement iNetElement = null;
        if (this.srcNodeModel != null) {
            iNetElement = this.net.findNetElem(this.srcNodeModel);
        }
        return iNetElement;
    }

    public INodeModel getSrcNodeModel() {
        return this.srcNodeModel;
    }

    public void setSrcNodeModel(INodeModel iNodeModel) {
        this.srcNodeModel = iNodeModel;
    }

    public void deleteCircuitModel() throws DeletionError {
        try {
            this.circuitModel.delete();
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
            if (db.on()) {
                db.println("Circuit model has already been deleted.");
            }
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Error deleting circuit model of " + this.getCircuitName());
                SDebug.printStackTrace((Throwable)exception);
            }
            throw new DeletionError("Error deleting circuit model of " + this.getCircuitName());
        }
    }

    public boolean hasLoopback() {
        return false;
    }

    public boolean hasXcLoopback() {
        return false;
    }

    public boolean supportsMonitorCircuits() {
        boolean bl = true;
        LinkedList linkedList = (LinkedList)this.getCktSources();
        for (int i = 0; bl && i < linkedList.size(); ++i) {
            NetCircuitEnd netCircuitEnd = (NetCircuitEnd)linkedList.get(i);
            if (netCircuitEnd == null || this.supportsMonitorCircuits(netCircuitEnd)) continue;
            bl = false;
        }
        LinkedList linkedList2 = (LinkedList)this.getCktDrops();
        for (int i = 0; bl && i < linkedList2.size(); ++i) {
            NetCircuitDropInfo netCircuitDropInfo = (NetCircuitDropInfo)linkedList2.get(i);
            if (netCircuitDropInfo == null || this.supportsMonitorCircuits(netCircuitDropInfo)) continue;
            bl = false;
        }
        return bl;
    }

    private boolean supportsMonitorCircuits(INetCircuitEnd iNetCircuitEnd) {
        INodeModel iNodeModel;
        boolean bl = true;
        IEntityModel iEntityModel = null;
        try {
            iEntityModel = iNetCircuitEnd.getEntityModel();
        }
        catch (ObjNotFound objNotFound) {
            iEntityModel = null;
        }
        if (iEntityModel != null && iEntityModel instanceof IPortModel && (iNodeModel = iNetCircuitEnd.getNodeModel()) != null && iNodeModel.provides(Feature.MONITOR_CKTS)) {
            bl = ((IPortModel)iEntityModel).supportsMonitorCircuits();
        }
        return bl;
    }

    public boolean needRoute(INetCircuitEnd iNetCircuitEnd) {
        return true;
    }

    protected ICircuitInfo getCircuitInfo() {
        return this.circuitInfo;
    }

    protected static boolean isPathFullyProtected(int n) {
        return n == 0 || n == 6 || n == 7 || n == 5;
    }

    protected static CircuitEnd createNullCircuitEnd() {
        return new CircuitEnd(0, 0, null, null, false, 0);
    }

    public static boolean isNullCircuitId(ICircuitId iCircuitId) {
        if (iCircuitId == null) {
            return true;
        }
        return iCircuitId.getNodeId() == 0 && iCircuitId.getUniquePart().getUniqueId() == 0;
    }

    public boolean hasNullCircuitId() {
        return NetCircuit.isNullCircuitId(this.getCircuitId());
    }

    public static boolean cktEndIsNodeDrop(INetCircuitEnd iNetCircuitEnd) {
        return iNetCircuitEnd.getEntityIndex() == 0;
    }

    public static boolean cktEndIsNodeDrop(ICircuitEnd iCircuitEnd) {
        return iCircuitEnd.getPortNum() == 0;
    }

    public LinkedList getCircuitCosts() {
        LinkedList linkedList = new LinkedList(this.pathCosts);
        return linkedList;
    }

    protected void setCircuitCosts(LinkedList linkedList) {
        this.pathCosts.clear();
        this.pathCosts.addAll(linkedList);
    }

    protected static String prettyString(ICircuitId iCircuitId) {
        if (iCircuitId == null || iCircuitId.getUniquePart() == null) {
            return "<null>";
        }
        return Integer.toHexString(iCircuitId.getNodeId()) + "::" + iCircuitId.getUniquePart().getUniqueId();
    }

    public void prettyPrintDeconstruction(SDebug sDebug) {
        if (!sDebug.on()) {
            return;
        }
        sDebug.println("CIRCUIT Name=\"" + this.getCircuitName() + "\"" + "  Id=" + NetCircuit.prettyString(this.circuitId) + "  State=" + EnumStrings.getString((Class)INetCircuitState.class, (int)this.state) + "  circuitInfo=" + (this.circuitInfoActive() ? "active" : "inactive"));
        this.printDeconstructedConnections(sDebug);
    }

    public void prettyPrint(SDebug sDebug) {
        if (!sDebug.on()) {
            return;
        }
        NetCircuit netCircuit = this;
        netCircuit.ncMgr.suppressPkgDbg();
        sDebug.println("CIRCUIT Name=\"" + this.getCircuitName() + "\"" + "  Id=" + NetCircuit.prettyString(this.circuitId) + "  State=" + EnumStrings.getString((Class)INetCircuitState.class, (int)this.state) + "  circuitInfo=" + (this.circuitInfoActive() ? "active" : "inactive"));
        sDebug.println("        " + EnumStrings.getString((Class)ICircuitType.class, (int)this.getCircuitType()) + "  " + EnumStrings.getString((Class)ICircuitSize.class, (int)this.getCircuitSize()) + "  " + EnumStrings.getString((Class)ICircuitDirection.class, (int)this.getCircuitDir()) + (this.isMonitorCircuit() ? "  MONITOR" : "") + "  " + " SLA = " + this.getSla());
        sDebug.println("        serviceState=" + this.translateServiceState(this.getServiceState()) + "  adminState=" + this.translateAdminState(this.getAdminState()));
        sDebug.println("        pathProt=" + EnumStrings.getString((Class)IPathProtection.class, (int)this.getDropPathProtection()) + "  protType=" + this.protType.getProtectionTypeString());
        if (!this.getCircuitTypeObj().isVcatCircuitType()) {
            sDebug.println("        isMemberOfVcat=" + this.isMemberOfVcat());
        } else {
            sDebug.println("        vcatRoutingPref=" + EnumStrings.getString((Class)IVcatRoutePreference.class, (int)this.getVcatRoutingPref()));
        }
        sDebug.println("");
        sDebug.println("srcNode: " + (this.srcNodeModel == null ? "null" : this.srcNodeModel.getName()));
        sDebug.println("");
        sDebug.println("Source(s) :");
        Iterator iterator = this.getCktSources().iterator();
        while (iterator.hasNext()) {
            NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
            sDebug.println(" " + netCircuitEnd.prettyString() + " " + EnumStrings.getString((Class)(class$cerent$cms$ncp$INetCircuitCreatStage == null ? NetCircuit.class$("cerent.cms.ncp.INetCircuitCreatStage") : class$cerent$cms$ncp$INetCircuitCreatStage), (int)netCircuitEnd.getStage()));
        }
        sDebug.println("");
        sDebug.println("Drop(s) :");
        iterator = this.getCktDrops().iterator();
        while (iterator.hasNext()) {
            NetCircuitDropInfo netCircuitDropInfo = (NetCircuitDropInfo)iterator.next();
            sDebug.println(" " + netCircuitDropInfo.getNetCktEnd().prettyString() + " " + EnumStrings.getString((Class)(class$cerent$cms$ncp$INetCircuitCreatStage == null ? NetCircuit.class$("cerent.cms.ncp.INetCircuitCreatStage") : class$cerent$cms$ncp$INetCircuitCreatStage), (int)netCircuitDropInfo.getNetCktEnd().getStage()) + " " + EnumStrings.getString((Class)(class$cerent$cms$model$IPathProtection == null ? NetCircuit.class$("cerent.cms.model.IPathProtection") : class$cerent$cms$model$IPathProtection), (int)netCircuitDropInfo.getPathProt()));
        }
        this.printChild(sDebug);
        NetCircuit netCircuit2 = this;
        netCircuit2.ncMgr.permitPkgDbg();
    }

    protected String translateAdminState(int n) {
        return EnumStrings.getString((Class)IAdminState.class, (int)(n + 1));
    }

    protected String translateServiceState(int n) {
        return EnumStrings.getString((Class)INetCircuitServiceState.class, (int)(n + 1));
    }

    protected abstract void checkAndUpdateCircuit();

    protected abstract void runChildUpdate();

    protected abstract boolean completeCheck();

    protected abstract void deleteDropCktEnd(INetCircuitEnd var1) throws CircuitDropOutstanding, ObjNotFound, CannotDeleteLastDrop, IncorrectCircuitState, SanityCheckFailed, DeletionError, AbstractCmsIOException;

    protected abstract int deriveServiceState();

    protected abstract String deriveDefaultName();

    protected abstract void changeCircuitId(ICircuitId var1);

    protected abstract void printChild(SDebug var1);

    protected abstract void printDeconstructedConnections(SDebug var1);

    protected abstract void notifyChanged();

    protected abstract void notifyDeleted();

    protected abstract void dispose();

    protected abstract Set getAffectedNodes(int var1, int var2);

    protected abstract void routeCurrentDrop(INetElement var1, RoutePrefs var2, boolean var3) throws SanityCheckFailed, NoRoute, AllocFailed, AbstractCmsIOException;

    protected abstract List getLinkEndpoints(INetLink var1);

    protected abstract boolean doesCircuitUseConn(INetElement var1, IConnectionModel var2);

    protected abstract String getCircuitNameFromSrcNode();

    protected abstract boolean isTl1Ckt() throws IncorrectCircuitState;

    protected abstract boolean circuitInfoActive();

    protected abstract boolean usesNetElement(INetElement var1);

    protected boolean isUcpCircuit() {
        return false;
    }

    protected void conformToCircuitInfo() {
    }

    protected void reloadTl1Objects() {
    }

    protected void disposeCircuitInfoAtNodes() {
    }

    public boolean upsrBerThresholdsSettable() {
        return true;
    }

    protected List getUpsrSelectors() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            try {
                arrayList.addAll(((INetCircuitNode)iterator.next()).getUpsrConns());
            }
            catch (Exception exception) {
                db.println("Caught exception in getUpsrSelectors");
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return arrayList;
    }

    public boolean validateBLSRTimeSlots(List list) throws SanityCheckFailed {
        Iterator iterator = this.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            if (netCircuitNode.validateBLSRTimeSlots(list)) continue;
            return false;
        }
        return true;
    }

    protected class UpdateEvent {
        public boolean changed;
        public boolean deleted;

        public UpdateEvent() {
            this.init();
        }

        public void init() {
            this.changed = false;
            this.deleted = false;
        }
    }
}

