/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.CircuitMergeManager;
import cerent.cms.model.ErrorWritingToDb;
import cerent.cms.model.FramingType;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.ICircuitInfo;
import cerent.cms.model.ICircuitModel;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IFramingType;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ObjNotFound;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.CircuitMergeError;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.DualConnectionCircuitNode;
import cerent.cms.ncp.EtherNodeDropCircuitEnd;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ncp.LoTunnelNode;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitFactory;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitNodeFactory;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.NetCircuitWatchDog;
import cerent.cms.ncp.NetVcatCircuit;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.topo.INetElement;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NetCircuitMergeOperator {
    private static final SDebug db = new SDebug("NetCircuitMergeOperator");
    private static CircuitMergeManager mergeManager = CircuitMergeManager.instance();
    private NetCcatCircuit circuit;
    private int operation;
    private ICircuitModel circuitModelBeforeMerge;
    private NetCircuitNode sourceNodeBeforeMerge;
    private String circuitNameBeforeMerge;
    private int circuitNodeNumBeforeMerge;
    private boolean pureTl1CktBeforeMerge;
    private List disjointParts = new ArrayList();
    private Map nodeDisjointPartMap = new HashMap();
    private boolean changed = false;
    private boolean existsRollbackXconnects = false;

    public NetCircuitMergeOperator(NetCcatCircuit netCcatCircuit, int n) {
        this.circuit = netCcatCircuit;
        this.operation = n;
    }

    public void validateForMerge() throws CircuitMergeError {
        NetCircuitMergeOperator.validateForMerge(this.circuit);
    }

    public static void validateForMerge(INetCircuit iNetCircuit) throws CircuitMergeError {
        String string = iNetCircuit.getCircuitName();
        if (iNetCircuit instanceof NetVcatCircuit) {
            throw new CircuitMergeError("Circuit \"" + string + "\" is a VCAT circuit.");
        }
        NetCcatCircuit netCcatCircuit = (NetCcatCircuit)iNetCircuit;
        if (netCcatCircuit.getCktNodeListSize() == 0) {
            throw new CircuitMergeError("Circuit \"" + string + "\" has no connection.");
        }
        switch (netCcatCircuit.getState()) {
            case 0: {
                throw new CircuitMergeError("Circuit \"" + string + "\" is in creation.");
            }
            case 2: {
                throw new CircuitMergeError("Circuit \"" + string + "\" is in deletion.");
            }
            case 3: {
                throw new CircuitMergeError("Circuit \"" + string + "\" is in drop pending.");
            }
            case 8: {
                throw new CircuitMergeError("Circuit \"" + string + "\" is in roll pending.");
            }
        }
        if (NetCircuitMergeOperator.containsVlanCircuitEnds(netCcatCircuit) && netCcatCircuit.getVlans().length == 0) {
            throw new CircuitMergeError("The VLAN set of the circuit \"" + string + "\" is empty.");
        }
    }

    private static boolean containsVlanCircuitEnds(NetCcatCircuit netCcatCircuit) {
        Iterator iterator = netCcatCircuit.getDrops().iterator();
        while (iterator.hasNext()) {
            NetCircuitEnd netCircuitEnd = ((NetCircuitDropInfo)iterator.next()).getNetCktEnd();
            if (!netCircuitEnd.isEtherP2PCircuitEnd()) continue;
            return true;
        }
        return false;
    }

    public void prepareMerge() {
        this.circuit.setInCircuitMerge(true);
        this.circuitModelBeforeMerge = this.circuit.circuitModel();
        this.sourceNodeBeforeMerge = this.circuit.srcCircuitNode;
        this.circuitNameBeforeMerge = this.circuit.getCircuitName();
        this.circuitNodeNumBeforeMerge = this.circuit.getCktNodeListSize();
        this.pureTl1CktBeforeMerge = this.circuit.hasNullCircuitId();
        Iterator iterator = this.circuit.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            if (netCircuitNode.getConn() == null) continue;
            this.disjointParts.add(new DisjointPart(netCircuitNode));
            netCircuitNode.conformToConnection(mergeManager.getSplicer());
        }
    }

    private void handleHoGroomingNode(NetCircuitNode netCircuitNode) {
        if (db.on()) {
            db.println("handleHoGroomingNode");
        }
        Iterator iterator = netCircuitNode.getAllSpansList().iterator();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            INetElement iNetElement = netCircuitNode.getNetElement() == netCircuitSpan.getLink().getSrc() ? netCircuitSpan.getLink().getDst() : netCircuitSpan.getLink().getSrc();
            NetCircuitNode netCircuitNode2 = (NetCircuitNode)this.circuit.getCircuitNodeFromNE(iNetElement);
            if (netCircuitNode2 == null || !netCircuitNode2.getAllSpansList().contains(netCircuitSpan)) continue;
            if (this.dbgOn()) {
                db.println("Found peer node.");
            }
            this.getDisjointPartOnNode(netCircuitNode2).add(netCircuitNode);
            break;
        }
    }

    protected void lapNodeDestroyed(NetCircuitNode netCircuitNode) {
        DisjointPart disjointPart;
        if (db.on()) {
            db.println("lapNodeDestroyed");
        }
        if (netCircuitNode.getConn() == null && (disjointPart = this.getDisjointPartOnNode(netCircuitNode)) != null) {
            disjointPart.remove(netCircuitNode);
        }
    }

    protected void lapNodeDiscovered(NetCircuitNode netCircuitNode) {
        if (db.on()) {
            db.println("lapNodeDiscovered");
        }
        if (netCircuitNode.getConn() == null) {
            this.handleHoGroomingNode(netCircuitNode);
        }
    }

    public boolean canBeCompleted() {
        return this.getDisjointPartsNum() == 0 || this.getDisjointPartsNum() == 1 && this.isNodesStructureComplete(this.circuit);
    }

    public boolean finalizeMerge() {
        if (this.dbgOn()) {
            db.println("Start finalizeMerge");
            Iterator iterator = this.disjointParts.iterator();
            while (iterator.hasNext()) {
                ((DisjointPart)iterator.next()).prettyPrint(db);
            }
        }
        if (this.operation == 1 && this.circuit != mergeManager.getMasterCircuit()) {
            this.reloadWholeCircuit();
            return false;
        }
        boolean bl = true;
        DisjointPart disjointPart = this.getSourcePart();
        int n = 1;
        ArrayList arrayList = new ArrayList(this.disjointParts);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            DisjointPart disjointPart2 = (DisjointPart)iterator.next();
            if (disjointPart2 == disjointPart) continue;
            if (!this.handleDisjointPart(disjointPart2, n)) {
                bl = false;
                continue;
            }
            this.changed = true;
            ++n;
        }
        if (disjointPart != null) {
            if (!bl) {
                boolean bl2 = this.handleDisjointPart(disjointPart, n);
                if (bl2) {
                    this.changed = true;
                }
            } else {
                bl = this.handleSrcPart(disjointPart);
            }
        }
        if (!bl) {
            this.reloadWholeCircuit();
        }
        return bl;
    }

    public void cleanup() {
        if (this.circuit.getCktNodeListSize() == 0 && !this.existsRollbackXconnects) {
            this.deleteOldCircuitModel();
            this.circuit.finalDispose();
            this.circuit.notifyDeleted();
        }
    }

    private void deleteOldCircuitModel() {
        block5: {
            if (this.circuitModelBeforeMerge != null) {
                try {
                    this.circuitModelBeforeMerge.delete();
                }
                catch (ErrorWritingToDb errorWritingToDb) {
                    if (this.dbgOn()) {
                        SDebug.printStackTrace((Throwable)errorWritingToDb);
                    }
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    if (!this.dbgOn()) break block5;
                    SDebug.printStackTrace((Throwable)abstractCmsIOException);
                }
            }
        }
    }

    private void removeCircuitFromManager(INetCircuit iNetCircuit) {
        NetCircuitManager.instance().removeCircuit(iNetCircuit);
    }

    private void destroyCircuit(INetCircuit iNetCircuit) {
        block6: {
            try {
                iNetCircuit.destroyCircuit();
            }
            catch (IncorrectCircuitState incorrectCircuitState) {
                if (this.dbgOn()) {
                    SDebug.printStackTrace((Throwable)incorrectCircuitState);
                }
            }
            catch (SanityCheckFailed sanityCheckFailed) {
                if (this.dbgOn()) {
                    SDebug.printStackTrace((Throwable)sanityCheckFailed);
                }
            }
            catch (DeletionError deletionError) {
                if (!this.dbgOn()) break block6;
                SDebug.printStackTrace((Throwable)deletionError);
            }
        }
    }

    private boolean handleSrcPart(DisjointPart disjointPart) {
        if (!this.isNodesStructureComplete(this.circuit)) {
            return false;
        }
        if (this.circuitModelBeforeMerge != null && this.doesCktModelMatchCktSourceAndDropInfo(this.circuitModelBeforeMerge)) {
            if (this.dbgOn()) {
                db.println("circuit model mathes circuit node info - restore the circuit model.");
            }
            try {
                this.permanentlyMoveConnections();
                if (this.needToUseOldCircuitName() && !this.circuit.getCircuitName().equals(this.circuitNameBeforeMerge)) {
                    this.circuit.renameCircuit(this.circuitNameBeforeMerge);
                    this.changed = true;
                }
                this.reloadCircuitInfo();
                return true;
            }
            catch (CircuitProvError circuitProvError) {
                SDebug.printStackTrace((Throwable)circuitProvError);
                return false;
            }
        }
        if (this.dbgOn()) {
            db.println("circuit model does not match circuit node info - create a new circuit model.");
        }
        String string = this.needToUseOldCircuitName() ? this.circuitNameBeforeMerge : null;
        boolean bl = this.completeCircuit(this.circuit, string);
        if (this.dbgOn()) {
            db.println("New model created? " + bl);
        }
        if (bl) {
            this.deleteOldCircuitModel();
            this.changed = true;
        }
        return bl;
    }

    private boolean handleDisjointPart(DisjointPart disjointPart, int n) {
        if (this.dbgOn()) {
            db.println("Start handleDisjointPart");
        }
        return this.changeDisjointPartToNewCtcCircuit(disjointPart, n);
    }

    private NetCcatCircuit buildPartialCircuit(DisjointPart disjointPart, String string) {
        CircuitCreatInfo circuitCreatInfo = this.createNewCircuitCreatInfo(string);
        NetCcatCircuit netCcatCircuit = null;
        if (this.circuit.getCircuitTypeObj().isTunnelCircuitType() || this.circuit.getCircuitTypeObj().isEthernetCircuitType()) {
            List list = this.getSpecialNodes(disjointPart, this.circuit.getCircuitTypeObj());
            if (list.isEmpty()) {
                NetCircuitNode netCircuitNode = (NetCircuitNode)disjointPart.getNodeSet().iterator().next();
                IFramingType iFramingType = FramingType.getFramingType((int)netCircuitNode.getNodeModel().getFramingType());
                circuitCreatInfo.setType(iFramingType.getHoCircuitType());
            } else {
                block5: {
                    NetCircuitNode netCircuitNode = list.contains(this.sourceNodeBeforeMerge) ? this.sourceNodeBeforeMerge : (NetCircuitNode)list.get(0);
                    try {
                        netCcatCircuit = (NetCcatCircuit)NetCircuitFactory.newCircuit(circuitCreatInfo, netCircuitNode.getNetElement());
                    }
                    catch (SanityCheckFailed sanityCheckFailed) {
                        if (!this.dbgOn()) break block5;
                        db.println(sanityCheckFailed.getMessage());
                    }
                }
                return netCcatCircuit;
            }
        }
        netCcatCircuit = (NetCcatCircuit)NetCircuitFactory.newCircuit(circuitCreatInfo, (INetCircuitEnd)null);
        return netCcatCircuit;
    }

    private boolean changeDisjointPartToNewCtcCircuit(DisjointPart disjointPart, int n) {
        String string = this.needToUseOldCircuitName() ? this.getNewCircuitName(n) : null;
        NetCcatCircuit netCcatCircuit = this.buildPartialCircuit(disjointPart, string);
        if (this.dbgOn()) {
            db.println("newCkt=" + netCcatCircuit);
        }
        if (netCcatCircuit == null) {
            return false;
        }
        this.moveDisjointPart(disjointPart, this.circuit, netCcatCircuit);
        if (this.isNodesStructureComplete(netCcatCircuit) && this.completeCircuit(netCcatCircuit, string)) {
            if (this.dbgOn()) {
                db.println("new circuit is created successfully");
            }
            mergeManager.addNewCreatedCircuit(netCcatCircuit);
            return true;
        }
        if (this.dbgOn()) {
            db.println("new circuit could not be created successfully");
        }
        this.moveDisjointPart(disjointPart, netCcatCircuit, this.circuit);
        this.destroyCircuit(netCcatCircuit);
        return false;
    }

    private List getSpecialNodes(DisjointPart disjointPart, ICircuitType iCircuitType) {
        ArrayList<NetCircuitNode> arrayList = new ArrayList<NetCircuitNode>();
        Iterator iterator = disjointPart.getNodeSet().iterator();
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            if ((!iCircuitType.isTunnelCircuitType() || !(netCircuitNode instanceof LoTunnelNode)) && (!iCircuitType.isEthernetCircuitType() || netCircuitNode.getConnectionType() != 8)) continue;
            arrayList.add(netCircuitNode);
        }
        return arrayList;
    }

    private boolean completeCircuit(NetCcatCircuit netCcatCircuit, String string) {
        boolean bl;
        block13: {
            try {
                block14: {
                    netCcatCircuit.setInCircuitMerge(false);
                    netCcatCircuit.deleteCircuitInfoObserver();
                    this.removeCircuitFromManager(netCcatCircuit);
                    List list = netCcatCircuit.createNewCircuitModel(string);
                    if (list.isEmpty()) {
                        if (this.dbgOn()) {
                            db.println("New circuit model is successfully created.");
                        }
                        bl = true;
                        break block13;
                    }
                    if (this.dbgOn()) {
                        db.println("Some connection IDs could not be changed.");
                    }
                    this.removeCircuitFromManager(netCcatCircuit);
                    if (netCcatCircuit.circuitInfoActive()) {
                        try {
                            netCcatCircuit.destroyCircuitInfo();
                        }
                        catch (IncorrectCircuitState incorrectCircuitState) {
                            if (this.dbgOn()) {
                                SDebug.printStackTrace((Throwable)incorrectCircuitState);
                            }
                        }
                        catch (DeletionError deletionError) {
                            if (!this.dbgOn()) break block14;
                            SDebug.printStackTrace((Throwable)deletionError);
                        }
                    }
                }
                bl = false;
            }
            catch (CircuitProvError circuitProvError) {
                if (this.dbgOn()) {
                    SDebug.printStackTrace((Throwable)circuitProvError);
                }
                bl = false;
            }
            catch (SanityCheckFailed sanityCheckFailed) {
                if (this.dbgOn()) {
                    SDebug.printStackTrace((Throwable)sanityCheckFailed);
                }
                bl = false;
            }
        }
        NetCircuitManager.instance().insertCircuit(netCcatCircuit, true);
        return bl;
    }

    private CircuitCreatInfo createNewCircuitCreatInfo(String string) {
        ICircuitInfo iCircuitInfo = this.circuit.getCircuitInfo();
        return new CircuitCreatInfo(iCircuitInfo.getCircuitType(), iCircuitInfo.getCircuitSize(), iCircuitInfo.getDir(), iCircuitInfo.getMonitor(), string, this.circuit.getAdminState(), false, iCircuitInfo.getCktOptDir(), iCircuitInfo.getCktOptChannel());
    }

    private String getNewCircuitName(int n) {
        return this.circuitNameBeforeMerge + ":" + n;
    }

    private DisjointPart getSourcePart() {
        return this.getDisjointPartOnNode(this.sourceNodeBeforeMerge);
    }

    private boolean doesCktModelMatchCktSourceAndDropInfo(ICircuitModel iCircuitModel) {
        if (iCircuitModel == null) {
            return false;
        }
        if (this.dbgOn()) {
            db.println("doesCktModelMatchCktSourceAndDropInfo started: cktModel = " + iCircuitModel);
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        this.circuit.fetchSourcesAndDropsFromCircuitModel(iCircuitModel, arrayList, arrayList2);
        if (this.dbgOn()) {
            this.circuit.prettyPrint(db);
        }
        HashSet hashSet = new HashSet(this.circuit.getSources());
        HashSet hashSet2 = new HashSet(this.circuit.getDropCktEnds());
        HashSet hashSet3 = new HashSet();
        hashSet3.addAll(arrayList);
        HashSet<NetCircuitEnd> hashSet4 = new HashSet<NetCircuitEnd>();
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            hashSet4.add(((NetCircuitDropInfo)iterator.next()).getNetCktEnd());
        }
        return this.doesSrcDropPairMatch(new Set[]{hashSet, hashSet2}, new Set[]{hashSet3, hashSet4}, this.circuit.isBidirectional());
    }

    private boolean doesSrcDropPairMatch(Set[] setArray, Set[] setArray2, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = ((Object)setArray[0]).equals(setArray2[0]) && ((Object)setArray[1]).equals(setArray2[1]);
        if (bl) {
            boolean bl4 = bl2 = bl2 || ((Object)setArray[0]).equals(setArray2[1]) && ((Object)setArray[1]).equals(setArray2[0]);
        }
        if (this.dbgOn()) {
            db.println("isMatch=" + bl2);
        }
        return bl2;
    }

    public DisjointPart getDisjointPartOnNode(NetCircuitNode netCircuitNode) {
        NetCircuitNode netCircuitNode2;
        DisjointPart disjointPart = (DisjointPart)this.nodeDisjointPartMap.get(netCircuitNode);
        if (disjointPart == null && (netCircuitNode2 = (NetCircuitNode)this.circuit.getCircuitNodeFromNE(netCircuitNode.getNetElement())) != null && netCircuitNode2.hasDualConnections()) {
            disjointPart = (DisjointPart)this.nodeDisjointPartMap.get(netCircuitNode2);
        }
        return disjointPart;
    }

    protected void unify(NetCircuitNode netCircuitNode, NetCircuitNode netCircuitNode2) {
        NetCircuitMergeOperator netCircuitMergeOperator;
        DisjointPart disjointPart;
        DisjointPart disjointPart2;
        NetCcatCircuit netCcatCircuit;
        boolean bl;
        if (this.dbgOn()) {
            db.println("unify starts - # disjoint parts = " + this.getDisjointPartsNum());
        }
        if (db.on()) {
            db.fine("myNode:");
            netCircuitNode.prettyPrint(db);
            db.fine("otherNode:");
            netCircuitNode2.prettyPrint(db);
        }
        boolean bl2 = bl = (netCcatCircuit = (NetCcatCircuit)netCircuitNode2.getCircuit()) == this.circuit;
        if (this.dbgOn()) {
            db.println("onSameCircuit = " + bl);
        }
        if ((disjointPart2 = this.getDisjointPartOnNode(netCircuitNode)) == (disjointPart = (netCircuitMergeOperator = bl ? this : mergeManager.getMergeOperator(netCcatCircuit)).getDisjointPartOnNode(netCircuitNode2))) {
            if (this.dbgOn()) {
                db.println("on same disjoing part");
            }
        } else {
            Object object;
            if (!bl && (object = this.findCommonNE(disjointPart)) != null) {
                this.handleDualNodes((NetCircuitNode)this.circuit.getCircuitNodeFromNE((INetElement)object), (NetCircuitNode)netCcatCircuit.getCircuitNodeFromNE((INetElement)object), disjointPart2, disjointPart, netCcatCircuit);
            }
            netCircuitMergeOperator.removeDisjointPart(disjointPart);
            disjointPart2.unify(disjointPart);
            if (!bl) {
                object = disjointPart.getNodeSet().iterator();
                while (object.hasNext()) {
                    NetCircuitNode netCircuitNode3 = (NetCircuitNode)object.next();
                    this.moveConnection(netCircuitNode3, (NetCcatCircuit)netCircuitNode3.getCircuit(), this.circuit);
                }
            }
        }
        if (this.dbgOn()) {
            db.println("unify ends - # disjoint parts = " + this.getDisjointPartsNum());
            this.circuit.prettyPrint(db);
        }
    }

    private INetElement findCommonNE(DisjointPart disjointPart) {
        Iterator iterator = disjointPart.nodeSet.iterator();
        while (iterator.hasNext()) {
            INetElement iNetElement = ((INetCircuitNode)iterator.next()).getNetElement();
            if (this.circuit.getCircuitNodeFromNE(iNetElement) == null) continue;
            return iNetElement;
        }
        return null;
    }

    private void handleDualNodes(NetCircuitNode netCircuitNode, NetCircuitNode netCircuitNode2, DisjointPart disjointPart, DisjointPart disjointPart2, NetCcatCircuit netCcatCircuit) {
        if (this.circuit.sameNEUnifyAllowed(netCircuitNode, netCircuitNode2)) {
            NetCircuitNode netCircuitNode3 = NetCircuitNodeFactory.createDualConnectionCircuitNode(netCircuitNode, netCircuitNode2);
            this.moveConnection(netCircuitNode2, netCcatCircuit, this.circuit);
            this.circuit.insertCktNode(netCircuitNode3);
            disjointPart.add(netCircuitNode3);
            disjointPart.add(netCircuitNode2);
            disjointPart2.remove(netCircuitNode2);
            if (this.dbgOn()) {
                db.println("after handleDualNodes - # disjoint parts = " + this.getDisjointPartsNum());
                this.circuit.prettyPrint(db);
            }
        }
    }

    private void moveConnection(NetCircuitNode netCircuitNode, NetCcatCircuit netCcatCircuit, NetCcatCircuit netCcatCircuit2) {
        NetCircuitSpan netCircuitSpan;
        HashMap hashMap = netCircuitNode.getAllSpans();
        netCcatCircuit.removeCktNode(netCircuitNode);
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            netCircuitSpan = (NetCircuitSpan)iterator.next();
            netCcatCircuit.removeCktSpan(netCircuitSpan);
        }
        netCcatCircuit2.insertCktNode(netCircuitNode);
        iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            netCircuitSpan = (NetCircuitSpan)iterator.next();
            netCcatCircuit2.insertCktSpan(netCircuitSpan);
        }
        netCircuitNode.setCircuit(netCcatCircuit2);
    }

    private void moveDisjointPart(DisjointPart disjointPart, NetCcatCircuit netCcatCircuit, NetCcatCircuit netCcatCircuit2) {
        Object object;
        Object object2 = disjointPart.getNodeSet().iterator();
        while (object2.hasNext()) {
            object = (NetCircuitNode)object2.next();
            this.moveConnection((NetCircuitNode)object, netCcatCircuit, netCcatCircuit2);
        }
        object2 = mergeManager.getMergeOperator(netCcatCircuit);
        object = mergeManager.getMergeOperator(netCcatCircuit2);
        if (object2 != null) {
            super.removeDisjointPart(disjointPart);
        }
        if (object != null) {
            super.addDisjointPart(disjointPart);
        }
    }

    private void addDisjointPart(DisjointPart disjointPart) {
        if (!this.disjointParts.contains(disjointPart)) {
            this.disjointParts.add(disjointPart);
            Iterator iterator = disjointPart.getNodeSet().iterator();
            while (iterator.hasNext()) {
                NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
                this.nodeDisjointPartMap.put(netCircuitNode, disjointPart);
            }
        }
    }

    private void removeDisjointPart(DisjointPart disjointPart) {
        if (this.disjointParts.contains(disjointPart)) {
            this.disjointParts.remove(disjointPart);
            Iterator iterator = disjointPart.getNodeSet().iterator();
            while (iterator.hasNext()) {
                NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
                this.nodeDisjointPartMap.remove(netCircuitNode);
            }
        } else if (this.dbgOn()) {
            db.print("Can't find disjointPart: ");
            disjointPart.prettyPrint(db);
        }
    }

    private void permanentlyMoveConnections() throws CircuitProvError {
        Iterator iterator = this.disjointParts.iterator();
        while (iterator.hasNext()) {
            this.permanentlyMoveConnections((DisjointPart)iterator.next());
        }
    }

    private void permanentlyMoveConnections(DisjointPart disjointPart) throws CircuitProvError {
        ICircuitId iCircuitId = this.circuit.getCircuitId();
        Iterator iterator = disjointPart.getNodeSet().iterator();
        while (iterator.hasNext()) {
            Object object;
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            if (!netCircuitNode.getConnectionCircuitId().equals(iCircuitId)) {
                netCircuitNode.setConnectionCircuitId(iCircuitId);
                this.changed = true;
                object = mergeManager.findOperatorBeforeMerge(netCircuitNode);
                ((NetCircuitMergeOperator)object).changed = true;
            }
            if (!this.needToUseOldCircuitName() || (object = netCircuitNode.getConnNameFromNE()) == null || ((String)object).equals(this.circuitNameBeforeMerge)) continue;
            netCircuitNode.setConnName(this.circuitNameBeforeMerge);
            this.changed = true;
        }
    }

    public void reloadWholeCircuit() {
        this.circuit.setInCircuitMerge(false);
        this.reloadCircuitInfo();
        this.reloadAllConnections();
    }

    private void reloadAllConnections() {
        Iterator iterator = this.circuit.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            NetCircuitMergeOperator netCircuitMergeOperator = mergeManager.findOperatorBeforeMerge(netCircuitNode);
            if (netCircuitMergeOperator == this) {
                netCircuitNode.conformToConnection();
                continue;
            }
            this.markRollbackXconExisted(netCircuitNode);
            this.circuit.disposeConnection(netCircuitNode, false);
            NetCircuitWatchDog.instance().reloadConnections(netCircuitNode.getNetElement());
        }
        if (this.pureTl1CktBeforeMerge && this.circuit.getCktNodeListSize() == 0) {
            this.circuit.checkAndUpdateCircuit();
            if (!this.circuit.isCircuitRefValid()) {
                this.circuit.notifyObservers(ModelUpdateType.DELETED);
            }
        }
        if (this.circuit.isCircuitRefValid()) {
            this.circuit.setProtType();
        }
    }

    private void markRollbackXconExisted(NetCircuitNode netCircuitNode) {
        NetCircuitMergeOperator netCircuitMergeOperator = mergeManager.findOperatorBeforeMerge(netCircuitNode);
        if (netCircuitMergeOperator != null) {
            ICircuitId iCircuitId = netCircuitNode.getConnectionCircuitId();
            if (iCircuitId != null && !NetCircuit.isNullCircuitId(iCircuitId)) {
                if (db.on()) {
                    db.println("Circuit " + netCircuitMergeOperator.circuit.getCircuitName() + "exist rollback cross-connect.");
                }
                netCircuitMergeOperator.existsRollbackXconnects = true;
            }
        } else if (netCircuitNode instanceof DualConnectionCircuitNode) {
            NetCircuitNode[] netCircuitNodeArray = ((DualConnectionCircuitNode)netCircuitNode).getChildCktNodes();
            for (int i = 0; i < netCircuitNodeArray.length; ++i) {
                this.markRollbackXconExisted(netCircuitNodeArray[i]);
            }
        }
    }

    private void reloadCircuitInfo() {
        this.circuit.setInCircuitMerge(false);
        if (this.circuitModelBeforeMerge != null) {
            this.circuit.updateCircuitInfo(this.circuitModelBeforeMerge, false);
            this.circuit.notifyChanged();
        }
    }

    public boolean connectToCircuitSource(NetCircuitNode netCircuitNode) {
        DisjointPart disjointPart = this.getDisjointPartOnNode(netCircuitNode);
        if (disjointPart == null) {
            return false;
        }
        return disjointPart.getNodeSet().contains(this.sourceNodeBeforeMerge);
    }

    private boolean isNodesStructureComplete(NetCcatCircuit netCcatCircuit) {
        IEntityModel iEntityModel;
        netCcatCircuit.setCircuitRoutingDirection();
        if (!netCcatCircuit.initSourcesAndDrops()) {
            if (this.isEtherPacketRingCircuit(netCcatCircuit)) {
                if (!this.reconfigureEtherPacketRingCircuit(netCcatCircuit)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (!netCcatCircuit.isNodesStructureComplete()) {
            if (this.dbgOn()) {
                db.println("node structure is incomplete.");
            }
            return false;
        }
        if (netCcatCircuit.getCircuitTypeObj().isTunnelCircuitType() || netCcatCircuit.getCircuitTypeObj().isLAPCircuitType() || netCcatCircuit.getCircuitTypeObj().isEthernetCircuitType() || netCcatCircuit.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
            return true;
        }
        ArrayList<IEntityModel> arrayList = new ArrayList<IEntityModel>();
        try {
            iEntityModel = netCcatCircuit.getPrimarySource().getEntityModel();
        }
        catch (ObjNotFound objNotFound) {
            if (this.dbgOn()) {
                SDebug.printStackTrace((Throwable)objNotFound);
            }
            return false;
        }
        Iterator iterator = netCcatCircuit.getCktDrops().iterator();
        while (iterator.hasNext()) {
            arrayList.clear();
            NetCircuitDropInfo netCircuitDropInfo = (NetCircuitDropInfo)iterator.next();
            try {
                arrayList.add(netCircuitDropInfo.getEntityModel());
            }
            catch (ObjNotFound objNotFound) {
                if (this.dbgOn()) {
                    SDebug.printStackTrace((Throwable)objNotFound);
                }
                return false;
            }
            if (!netCcatCircuit.filterAvailDropEntities(iEntityModel, arrayList).isEmpty()) continue;
            if (db.on()) {
                db.println("source and drop payload types do not match");
            }
            return false;
        }
        return true;
    }

    private boolean isEtherPacketRingCircuit(NetCcatCircuit netCcatCircuit) {
        if (db.on()) {
            db.println("checkEtherPacketRing");
        }
        if (netCcatCircuit.getSourcesSize() != 0 || netCcatCircuit.getDropsSize() < 2) {
            return false;
        }
        Iterator iterator = netCcatCircuit.getDrops().iterator();
        while (iterator.hasNext()) {
            NetCircuitDropInfo netCircuitDropInfo = (NetCircuitDropInfo)iterator.next();
            if (netCircuitDropInfo.getNetCktEnd() instanceof EtherNodeDropCircuitEnd) continue;
            return false;
        }
        if (db.on()) {
            db.println("Is a ether packet ring circuit.");
        }
        return true;
    }

    private boolean reconfigureEtherPacketRingCircuit(NetCcatCircuit netCcatCircuit) {
        Object object;
        ArrayList<NetCircuitNode> arrayList = new ArrayList<NetCircuitNode>();
        Object object2 = netCcatCircuit.getCircuitNodes().iterator();
        while (object2.hasNext()) {
            object = (NetCircuitNode)object2.next();
            if (!((NetCircuitNode)object).isNodeDrop()) continue;
            arrayList.add((NetCircuitNode)object);
        }
        if (arrayList.size() == 0) {
            db.severe("Wrong - could not find drops");
            return false;
        }
        object2 = arrayList.contains(this.sourceNodeBeforeMerge) ? this.sourceNodeBeforeMerge : (NetCircuitNode)arrayList.get(0);
        object = ((NetCircuitNode)object2).getNodeDrop();
        netCcatCircuit.insertSource((NetCircuitEnd)object);
        netCcatCircuit.removeDrop(new NetCircuitDropInfo((NetCircuitEnd)object, 2));
        netCcatCircuit.updateCircuitSourceInfo();
        netCcatCircuit.updateCircuitDropInfo();
        boolean bl = netCcatCircuit.setSrcCircuitNode();
        if (db.on()) {
            db.println("source size = " + netCcatCircuit.getSourcesSize());
            db.println("drop size = " + netCcatCircuit.getDropsSize());
            db.println("reconfigure packet ring result = " + bl);
        }
        return bl;
    }

    public int getDisjointPartsNum() {
        if (this.dbgOn()) {
            db.println("# of disjoint parts = " + this.disjointParts.size());
        }
        return this.disjointParts.size();
    }

    public boolean needToUseOldCircuitName() {
        return this.operation == 0 || this.operation == 1 || this.circuit.getCircuitTypeObj().isEthernetCircuitType();
    }

    public int getNodeNumInAllDisjointParts() {
        int n = 0;
        Iterator iterator = this.disjointParts.iterator();
        while (iterator.hasNext()) {
            n += ((DisjointPart)iterator.next()).getNodeSet().size();
        }
        return n;
    }

    private Set getNodesInAllDisjointParts() {
        HashSet hashSet = new HashSet();
        Iterator iterator = this.disjointParts.iterator();
        while (iterator.hasNext()) {
            hashSet.addAll(((DisjointPart)iterator.next()).getNodeSet());
        }
        return hashSet;
    }

    public int getCircuitNodeNumBeforeMerge() {
        return this.circuitNodeNumBeforeMerge;
    }

    public boolean changed() {
        return this.changed;
    }

    protected boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    protected class DisjointPart {
        private Set nodeSet = new HashSet();

        DisjointPart(NetCircuitNode netCircuitNode) {
            this.nodeSet.add(netCircuitNode);
            NetCircuitMergeOperator.this.nodeDisjointPartMap.put(netCircuitNode, this);
        }

        Set getNodeSet() {
            return this.nodeSet;
        }

        void unify(DisjointPart disjointPart) {
            Iterator iterator = disjointPart.nodeSet.iterator();
            while (iterator.hasNext()) {
                this.add((NetCircuitNode)iterator.next());
            }
        }

        void add(INetCircuitNode iNetCircuitNode) {
            this.nodeSet.add(iNetCircuitNode);
            NetCircuitMergeOperator.this.nodeDisjointPartMap.put(iNetCircuitNode, this);
        }

        void remove(INetCircuitNode iNetCircuitNode) {
            this.nodeSet.remove(iNetCircuitNode);
            NetCircuitMergeOperator.this.nodeDisjointPartMap.remove(iNetCircuitNode);
        }

        boolean containLoTunnelNode() {
            Iterator iterator = this.nodeSet.iterator();
            while (iterator.hasNext()) {
                if (!(iterator.next() instanceof LoTunnelNode)) continue;
                return true;
            }
            return false;
        }

        boolean containEtherStitchNode() {
            Iterator iterator = this.nodeSet.iterator();
            while (iterator.hasNext()) {
                NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
                if (netCircuitNode.getConnectionType() != 8) continue;
                return true;
            }
            return false;
        }

        boolean containUpsrNode() {
            Iterator iterator = this.nodeSet.iterator();
            while (iterator.hasNext()) {
                NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
                int n = netCircuitNode.getConnectionType();
                if (n == 0 || !netCircuitNode.isUpsrSelector() && !netCircuitNode.isUpsrBridge()) continue;
                return true;
            }
            return false;
        }

        boolean containDualConnectionNode() {
            Iterator iterator = this.nodeSet.iterator();
            while (iterator.hasNext()) {
                NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
                if (!netCircuitNode.hasDualConnections()) continue;
                return true;
            }
            return false;
        }

        protected void prettyPrint(SDebug sDebug) {
            if (!sDebug.on()) {
                return;
            }
            sDebug.println("This disjoint part has totally " + this.nodeSet.size() + " circuit nodes.");
            Iterator iterator = this.nodeSet.iterator();
            while (iterator.hasNext()) {
                ((NetCircuitNode)iterator.next()).prettyPrint(sDebug);
            }
        }
    }
}

