/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.NetProtectionType;
import cerent.cms.ncp.HoCcatCircuit;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.NetVcatCircuit;
import cerent.cms.ncp.NetVcatGroup;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ncp.SelectorConnection;
import cerent.util.Debug;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class NetCircuitProtType {
    private static Debug db = new Debug("NetCircuitProtType");
    private NetCircuit ckt;
    private boolean disposed;
    private int rawProtectionType;
    private int reportedProtectionType;
    private boolean isNonRevertivePca;

    public NetCircuitProtType(NetCircuit netCircuit) {
        this.ckt = netCircuit;
        this.disposed = false;
        this.initProtectionType();
    }

    private void initProtectionType() {
        this.rawProtectionType = 15;
        this.reportedProtectionType = 15;
        this.isNonRevertivePca = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        NetCircuit netCircuit = this.ckt;
        synchronized (netCircuit) {
            if (this.dbgOn()) {
                this.debug("disposing protType");
            }
            this.disposed = true;
        }
    }

    public int getProtectionType() {
        return this.reportedProtectionType;
    }

    public int getProtectionType(List list, List list2) {
        ProtTypeInfo protTypeInfo = this.calculateRawProtectionType(list, list2);
        return protTypeInfo.protType;
    }

    public boolean isNonRevertivePca(boolean bl) {
        if (bl) {
            this.setProtectionType();
        }
        return this.isNonRevertivePca;
    }

    public boolean isProtected() {
        return NetProtectionType.isProtectedType(this.getProtectionType());
    }

    public boolean isPca() {
        return NetProtectionType.isPcaType(this.getRawProtectionType());
    }

    public boolean isDri() {
        return this.getRawProtectionType() == 17;
    }

    protected int getRawProtectionType() {
        return this.rawProtectionType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setProtectionType() {
        NetCircuit netCircuit = this.ckt;
        synchronized (netCircuit) {
            if (this.disposed) {
                this.initProtectionType();
                return true;
            }
            ProtTypeInfo protTypeInfo = this.ckt instanceof NetVcatCircuit ? this.calculateRawProtectionType((NetVcatCircuit)this.ckt) : this.calculateRawProtectionType((NetCcatCircuit)this.ckt);
            this.rawProtectionType = protTypeInfo.protType;
            boolean bl = protTypeInfo.isNonRevertivePca;
            int n = this.ckt.getState() == 1 || this.ckt.getState() == 5 || this.ckt.getState() == 8 ? this.checkForLostProtection(this.rawProtectionType) : (this.ckt.getState() == 11 && this.rawProtectionType == 12 ? this.rawProtectionType : 15);
            if (n != this.reportedProtectionType || bl != this.isNonRevertivePca) {
                if (this.dbgOn()) {
                    this.debug("setProtectionType(" + this.ckt.getCircuitName() + ") " + "CPT: " + this.getProtectionTypeString(this.reportedProtectionType) + " --> " + this.getProtectionTypeString(n) + "; nonRevertPca: " + this.isNonRevertivePca + " --> " + bl);
                }
                this.reportedProtectionType = n;
                this.isNonRevertivePca = bl;
                return true;
            }
            return false;
        }
    }

    private int checkForLostProtection(int n) {
        if (this.ckt.dropsArePathFullyProtected() && NetProtectionType.isUnprotectedType(n) && !NetProtectionType.isPcaType(n)) {
            return 14;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProtTypeInfo calculateRawProtectionType(NetCcatCircuit netCcatCircuit) {
        ProtTypeInfo protTypeInfo;
        if (this.dbgOn()) {
            this.debug("calculateRawProtectionType(CCAT, " + netCcatCircuit.getCircuitName() + ")");
        }
        NetCcatCircuit netCcatCircuit2 = netCcatCircuit;
        synchronized (netCcatCircuit2) {
            protTypeInfo = this.calculateRawProtectionType(netCcatCircuit.getCircuitSpans(), netCcatCircuit.getCircuitNodes());
            NetCircuit netCircuit = (NetCircuit)netCcatCircuit.useLAP();
            if (netCircuit != null && netCcatCircuit.getCircuitSpanFromNetLink(netCircuit.getLapLink()) == null && netCcatCircuit.getCircuitSpanFromNetLink(netCircuit.getReverseLapLink()) == null) {
                protTypeInfo = this.includeLapProtTypeInfo(protTypeInfo);
            }
        }
        return protTypeInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProtTypeInfo calculateRawProtectionType(NetVcatCircuit netVcatCircuit) {
        if (this.dbgOn()) {
            this.debug("calculateRawProtectionType(VCAT, " + netVcatCircuit.getCircuitName() + ")");
        }
        ProtTypeInfo protTypeInfo = new ProtTypeInfo();
        NetVcatCircuit netVcatCircuit2 = netVcatCircuit;
        synchronized (netVcatCircuit2) {
            boolean bl = true;
            boolean bl2 = true;
            NetVcatGroup netVcatGroup = (NetVcatGroup)netVcatCircuit.getForwardVcatGroup();
            for (int i = 0; i < 2; ++i) {
                if (netVcatGroup != null) {
                    ProtTypeInfo protTypeInfo2 = this.calculateRawProtectionType(netVcatGroup);
                    if (bl) {
                        protTypeInfo.protType = protTypeInfo2.protType;
                        bl = false;
                        bl2 = true;
                    } else if (bl2 && protTypeInfo2.protType != protTypeInfo.protType) {
                        protTypeInfo.protType = 16;
                        bl2 = false;
                    }
                    if (protTypeInfo2.isNonRevertivePca) {
                        protTypeInfo.isNonRevertivePca = true;
                    }
                }
                netVcatGroup = (NetVcatGroup)netVcatCircuit.getReverseVcatGroup();
            }
        }
        return protTypeInfo;
    }

    private ProtTypeInfo calculateRawProtectionType(NetVcatGroup netVcatGroup) {
        boolean bl = true;
        boolean bl2 = true;
        ProtTypeInfo protTypeInfo = new ProtTypeInfo();
        List list = netVcatGroup.getAllMemberCircuits();
        if (this.dbgOn()) {
            this.debug("calculateRawProtectionType(VCG with " + list.size() + " members)");
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NetCcatCircuit netCcatCircuit = (NetCcatCircuit)iterator.next();
            if (bl) {
                protTypeInfo.protType = netCcatCircuit.getProtType();
                bl = false;
                bl2 = true;
            } else if (bl2 && netCcatCircuit.getProtType() != protTypeInfo.protType) {
                protTypeInfo.protType = 16;
                bl2 = false;
            }
            if (!netCcatCircuit.isNonRevertivePca()) continue;
            protTypeInfo.isNonRevertivePca = true;
        }
        return protTypeInfo;
    }

    private ProtTypeInfo calculateRawProtectionType(List list, List list2) {
        int n = 0;
        ProtTypeInfo protTypeInfo = new ProtTypeInfo();
        if (this.dbgOn()) {
            this.debug("calculateRawProtType spanList: " + list.size() + "  name " + this.ckt.getCircuitName());
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            int n2 = netCircuitSpan.getProtectionType();
            if (this.dbgOn()) {
                this.debug("calculateRawProtType spanProtType: " + n2 + " name: " + this.ckt.getCircuitName());
            }
            n |= 1 << n2;
            if (this.dbgOn()) {
                this.debug("calculateRawProtType Protflags: " + n);
            }
            if (!netCircuitSpan.isNonRevertivePca()) continue;
            protTypeInfo.isNonRevertivePca = true;
        }
        if (this.dbgOn()) {
            this.debug("calculateRawProtType nodeList: " + list2.size() + "  name " + this.ckt.getCircuitName());
        }
        iterator = list2.iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext() && this.ckt.getCircuitNodes().size() != 1) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            String string = "";
            if (netCircuitNode.hasUnprotectedSelector()) {
                string = "unprotected selector";
            } else if (netCircuitNode.hasUnprotectedDrop()) {
                string = "unprotected drop";
            } else if (netCircuitNode.circuit.driConfigurationError) {
                string = "dri configuration error";
            } else {
                try {
                    if (!netCircuitNode.validateBLSRTimeSlots()) {
                        string = "invalid BLSR time slot interchange";
                    }
                }
                catch (SanityCheckFailed sanityCheckFailed) {
                    string = sanityCheckFailed.getMessage();
                }
            }
            if (string.length() > 0) {
                n |= 8;
                if (!this.dbgOn()) break;
                this.debug("calculateRawProtType: unprotected flag set reason - " + string + " node " + netCircuitNode.getName() + " circuit " + this.ckt.getCircuitName() + " Protflags " + n);
                break;
            }
            try {
                netCircuitNode.validateBlsrDriPcaSpans(arrayList);
            }
            catch (SanityCheckFailed sanityCheckFailed) {
                n |= 0x2000;
            }
            if (!netCircuitNode.hasSelector()) continue;
            Iterator iterator2 = netCircuitNode.getSelectors().iterator();
            while (iterator2.hasNext()) {
                SelectorConnection selectorConnection = (SelectorConnection)iterator2.next();
                if (!selectorConnection.hasBothInputsOnSecondaryPath()) continue;
                n |= 0x2000;
            }
        }
        protTypeInfo.protType = this.integrateMultipleProtectionTypes(n);
        return protTypeInfo;
    }

    private int integrateMultipleProtectionTypes(int n) {
        if (this.dbgOn()) {
            this.debug("integrateMultipleProtectionTypes(" + this.ckt.getCircuitName() + ")" + ", protFlags = " + n);
        }
        int n2 = 15;
        if (n == 0) {
            if (this.dbgOn()) {
                this.debug("integrateMultipleProtectionTypes(" + this.ckt.getCircuitName() + ")" + "noProtFlags: " + this.ckt.getCircuitName());
            }
            return 16;
        }
        if ((n & 0x8000) != 0) {
            if (this.dbgOn()) {
                this.debug("WARNING: integrateMultipleProtectionTypes returns Unknown" + this.ckt.getCircuitName());
            }
            return 15;
        }
        int n3 = 0;
        int n4 = 1;
        while (n3 < 18) {
            if (n == n4) {
                if (this.dbgOn()) {
                    this.debug("integrateMultipleProtectionTypes returns " + this.getProtectionTypeString(n3));
                }
                return n3;
            }
            ++n3;
            n4 <<= 1;
        }
        int n5 = n & 0x2060;
        n2 = n5 == 32 ? 5 : (n5 == 64 ? 6 : (n5 != 0 ? 13 : ((n & 0x4000) != 0 ? 14 : ((n & 0x188) != 0 ? 3 : ((n & 0xFFFFF7EE) == 0 ? 11 : 10)))));
        if (this.dbgOn()) {
            this.debug("integrateMultipleProtectionTypes returns " + this.getProtectionTypeString(n2));
        }
        return n2;
    }

    private int getProtFlags(int n) {
        return 1 << n;
    }

    private int getProtFlags(ProtTypeInfo protTypeInfo) {
        return this.getProtFlags(protTypeInfo.protType);
    }

    private ProtTypeInfo includeLapProtTypeInfo(ProtTypeInfo protTypeInfo) {
        NetCircuit netCircuit = (NetCircuit)this.ckt.useLAP();
        if (netCircuit == null) {
            return protTypeInfo;
        }
        int n = this.getProtFlags(protTypeInfo);
        if (((HoCcatCircuit)netCircuit).getLoTunnelNodes().size() == 2) {
            n = 0;
        }
        protTypeInfo.protType = this.integrateMultipleProtectionTypes(n |= this.getProtFlags(netCircuit.getProtType()));
        if (netCircuit.isNonRevertivePca()) {
            protTypeInfo.isNonRevertivePca = true;
        }
        return protTypeInfo;
    }

    private boolean isProtectedType(int n) {
        return n == 12 || n == 0 || n == 4 || n == 11 || n == 1 || n == 17 || n == 10;
    }

    private boolean isBlsrType(int n) {
        return n == 0 || n == 4 || n == 11;
    }

    private boolean isPcaType(int n) {
        return n == 5 || n == 6 || n == 13;
    }

    protected String getProtectionTypeString() {
        return this.getProtectionTypeString(this.getProtectionType());
    }

    private String getProtectionTypeString(int n) {
        switch (n) {
            case 0: {
                return "2F-BLSR";
            }
            case 1: {
                return "1+1";
            }
            case 2: {
                return "LOT";
            }
            case 3: {
                return "Unprotected";
            }
            case 4: {
                return "4F-BLSR";
            }
            case 5: {
                return "2F-PCA";
            }
            case 6: {
                return "4F-PCA";
            }
            case 7: {
                return "Y-Cable";
            }
            case 8: {
                return "Splitter";
            }
            case 10: {
                return "Protected";
            }
            case 11: {
                return "BLSR";
            }
            case 12: {
                return "UPSR";
            }
            case 13: {
                return "PCA";
            }
            case 14: {
                return "Lost";
            }
            case 15: {
                return "Unknown";
            }
            case 16: {
                return "None";
            }
            case 17: {
                return "DRI";
            }
        }
        return "?????";
    }

    private boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    private void debug(String string) {
        db.println(string);
    }

    private class ProtTypeInfo {
        public int protType = 15;
        public boolean isNonRevertivePca = false;
    }
}

