/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.AllocFailed;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CannotDeleteLastDrop;
import cerent.cms.model.CircuitEnd;
import cerent.cms.model.CircuitId;
import cerent.cms.model.CircuitType;
import cerent.cms.model.Feature;
import cerent.cms.model.ICircuitEnd;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.ICircuitModel;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IHoUpsrAttributes;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.IVcatTermModel;
import cerent.cms.model.IVlanModel;
import cerent.cms.model.InvalidOperation;
import cerent.cms.model.InvalidParms;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ObjNotFound;
import cerent.cms.ncp.AdminStateProvisioningError;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.CircuitDropOutstanding;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.ConnTypeUnsupported;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.INetCircuitSpan;
import cerent.cms.ncp.INetVcatGroup;
import cerent.cms.ncp.INetVcatTermination;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitDeleteWorker;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitEndFactory;
import cerent.cms.ncp.NetCircuitPath;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.NetCircuitWatchDog;
import cerent.cms.ncp.NetVcatGroup;
import cerent.cms.ncp.NetVcatTermination;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.route.INetLinkSpan;
import cerent.cms.route.MemberGroupPrefs;
import cerent.cms.route.MemberPath;
import cerent.cms.route.MemberPrefs;
import cerent.cms.route.NoRoute;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetLinkComparator;
import cerent.cms.vlan.NetVlanInfo;
import cerent.util.AnnotatedException;
import cerent.util.ILoNum;
import cerent.util.SDebug;
import cerent.util.job.IJobControl;
import cerent.util.job.IJobGroupListener;
import cerent.util.job.JobController;
import cerent.util.job.JobControllerFactory;
import cerent.util.job.JobGroup;
import cerent.util.job.JobStatus;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class NetVcatCircuit
extends NetCircuit
implements IJobGroupListener {
    private NetVcatGroup forwardVcatGroup;
    private NetVcatGroup reverseVcatGroup = null;
    private RoutePrefs routePrefs;
    private boolean deleteDone = false;
    private Object threadWaitObject = new Object();
    protected List ccat2VcatList;
    protected List vcat2CcatList;
    private static final SDebug db = new SDebug("NetVcatCircuit");

    protected boolean dbgOn() {
        return db.on() || super.dbgOn();
    }

    protected void debug(String string) {
        db.println(string);
    }

    protected NetVcatCircuit(CircuitCreatInfo circuitCreatInfo) {
        super(circuitCreatInfo);
        this.forwardVcatGroup = new NetVcatGroup(this);
        this.ccat2VcatList = new LinkedList();
        this.vcat2CcatList = new LinkedList();
    }

    protected NetVcatCircuit(CircuitCreatInfo circuitCreatInfo, INetCircuitEnd iNetCircuitEnd) {
        this(circuitCreatInfo);
        this.setCktOperation(1);
        this.addSources(circuitCreatInfo, iNetCircuitEnd);
    }

    protected NetVcatCircuit(CircuitCreatInfo circuitCreatInfo, INodeModel iNodeModel, ICircuitModel iCircuitModel) throws AbstractCmsObjectNotExistException {
        this(circuitCreatInfo);
        this.initState(4);
        this.addDiscoveredCircuitInfo(iNodeModel, iCircuitModel);
        this.clearChanged();
    }

    protected NetVcatCircuit(CircuitCreatInfo circuitCreatInfo, INetElement iNetElement, Object object) {
        this(circuitCreatInfo);
        ICircuitId iCircuitId = ((IVcatTermModel)object).getCircuitId();
        if (iCircuitId == null) {
            if (this.dbgOn()) {
                db.println("Warning! Unable to get circuit ID");
            }
            return;
        }
        this.updateCircuitId(iCircuitId);
        int n = ((IVcatTermModel)object).getPortIndex();
        CircuitEnd circuitEnd = new CircuitEnd(iNetElement.getNodeId(), n, null, null, false, 0);
        NetCircuitEnd netCircuitEnd = new NetCircuitEnd(iNetElement.getNodeModel(), circuitEnd);
        netCircuitEnd = NetCircuitEndFactory.createCircuitEnd(this.getCircuitType(), netCircuitEnd);
        this.discoverVcatTerm(netCircuitEnd, object);
        if (this.isCircuitRefValid()) {
            if (!NetVcatCircuit.isNullCircuitId(iCircuitId)) {
                this.initState(4);
            } else {
                if (this.inRoll()) {
                    this.initState(8);
                } else {
                    this.initState(6);
                }
                this.tl1CircuitCompleteCheck();
            }
            this.serviceState = this.deriveServiceState();
            this.setProtType();
        }
        this.clearChanged();
    }

    protected void addSources(CircuitCreatInfo circuitCreatInfo, INetCircuitEnd iNetCircuitEnd) {
        if (iNetCircuitEnd != null) {
            NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createCircuitEnd(circuitCreatInfo.type(), iNetCircuitEnd);
            this.circuitInfo.setSrcPoint(netCircuitEnd.getCircuitEnd());
            this.setSource(netCircuitEnd);
            NetVcatTermination netVcatTermination = new NetVcatTermination(this, netCircuitEnd, circuitCreatInfo);
            this.forwardVcatGroup.addCreatedVcatTerm(circuitCreatInfo, circuitCreatInfo.forwardMembers(), iNetCircuitEnd, null, netVcatTermination);
            netCircuitEnd.setStage(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDiscoveredVcatTerm(INetElement iNetElement, Object object) throws AbstractCmsIOException {
        NetVcatCircuit netVcatCircuit = this;
        synchronized (netVcatCircuit) {
            Object object2;
            if (!this.isCircuitRefValid()) {
                return;
            }
            int n = ((IVcatTermModel)object).getPortIndex();
            NetCircuitEnd netCircuitEnd = this.getNetCktEnd(iNetElement, n);
            if (netCircuitEnd == null) {
                object2 = new CircuitEnd(iNetElement.getNodeId(), n, null, null, false, 0);
                netCircuitEnd = new NetCircuitEnd(iNetElement.getNodeModel(), (ICircuitEnd)object2);
                netCircuitEnd = NetCircuitEndFactory.createCircuitEnd(this.getCircuitType(), netCircuitEnd);
            }
            if ((object2 = (NetVcatTermination)this.getVcatTermFromCktEnd(netCircuitEnd)) != null) {
                if (((NetVcatTermination)object2).deletedEventPending()) {
                    if (this.dbgOn()) {
                        this.debug("Processing vcatTerm delete event for " + this.getCircuitName() + "(" + NetVcatCircuit.prettyString(this.circuitId) + ")" + " at " + iNetElement.getName());
                    }
                    this.disposeVcatTerm((NetVcatTermination)object2, false);
                } else {
                    return;
                }
            }
            if (this.dbgOn()) {
                this.debug("Adding discovered vcat termination to " + this.getCircuitName() + "(" + NetVcatCircuit.prettyString(this.circuitId) + ")" + " at " + iNetElement.getName());
            }
            this.discoverVcatTerm(netCircuitEnd, object);
            if (this.isCircuitRefValid() && !this.completeCheck()) {
                this.setState(4);
            }
        }
        if (!this.isCircuitRefValid()) {
            this.notifyDeleted();
        } else {
            this.notifyChanged();
        }
    }

    private void discoverVcatTerm(NetCircuitEnd netCircuitEnd, Object object) {
        NetVcatTermination netVcatTermination = new NetVcatTermination(this, netCircuitEnd, object);
        if (netVcatTermination.getDirection() == 1) {
            if (!this.circuitInfoActive()) {
                if (this.getSourcesSize() == 0) {
                    this.insertSource(netCircuitEnd);
                    this.updateCircuitSourceInfo();
                } else {
                    this.insertDrop(new NetCircuitDropInfo(netCircuitEnd, 9));
                    this.updateCircuitDropInfo();
                }
            }
            this.forwardVcatGroup.addDiscoveredVcatTerm(netVcatTermination);
        } else if (this.getCircuitDir() == 1) {
            if (!this.circuitInfoActive()) {
                if (this.getSourcesSize() == 0) {
                    this.insertSource(netCircuitEnd);
                    this.updateCircuitSourceInfo();
                } else {
                    this.insertDrop(new NetCircuitDropInfo(netCircuitEnd, 9));
                    this.updateCircuitDropInfo();
                }
            }
            if (this.isSource(netCircuitEnd)) {
                this.forwardVcatGroup.addDiscoveredVcatTerm(netVcatTermination);
                if (this.reverseVcatGroup == null) {
                    this.reverseVcatGroup = new NetVcatGroup(this);
                }
                this.reverseVcatGroup.addDiscoveredVcatTerm(netVcatTermination);
            } else if (this.isDrop(netCircuitEnd)) {
                this.forwardVcatGroup.addDiscoveredVcatTerm(netVcatTermination);
                if (this.reverseVcatGroup == null) {
                    this.reverseVcatGroup = new NetVcatGroup(this);
                }
                this.reverseVcatGroup.addDiscoveredVcatTerm(netVcatTermination);
            } else {
                this.forwardVcatGroup.addDiscoveredVcatTerm(netVcatTermination);
                if (this.reverseVcatGroup == null) {
                    this.reverseVcatGroup = new NetVcatGroup(this);
                }
                this.reverseVcatGroup.addDiscoveredVcatTerm(netVcatTermination);
            }
        } else if (netVcatTermination.getConfiguredNumOfMembers(1) != 0 && netVcatTermination.getConfiguredNumOfMembers(0) == 0) {
            if (!this.circuitInfoActive()) {
                this.insertSource(netCircuitEnd);
                this.updateCircuitSourceInfo();
            }
            this.forwardVcatGroup.addDiscoveredVcatTerm(netVcatTermination);
        } else if (netVcatTermination.getConfiguredNumOfMembers(1) == 0 && netVcatTermination.getConfiguredNumOfMembers(0) != 0) {
            if (!this.circuitInfoActive()) {
                this.insertDrop(new NetCircuitDropInfo(netCircuitEnd, 9));
                this.updateCircuitDropInfo();
            }
            this.forwardVcatGroup.addDiscoveredVcatTerm(netVcatTermination);
        }
        if (!this.circuitInfoActive()) {
            this.setSrcCircuitNode();
        }
    }

    public INetVcatGroup getForwardVcatGroup() {
        return this.forwardVcatGroup;
    }

    public INetVcatGroup getReverseVcatGroup() {
        return this.reverseVcatGroup;
    }

    public int getConfiguredForwardMemberSize() {
        NetVcatTermination netVcatTermination = (NetVcatTermination)this.getVcatTermFromCktEnd(this.getPrimarySource());
        if (netVcatTermination == null) {
            netVcatTermination = (NetVcatTermination)this.getVcatTermFromCktEnd(this.getPrimaryDrop());
        }
        if (netVcatTermination == null) {
            return 0;
        }
        return this.forwardVcatGroup.getConfiguredNumOfMembers(netVcatTermination);
    }

    public int getConfiguredReverseMemberSize() {
        NetVcatTermination netVcatTermination = (NetVcatTermination)this.getVcatTermFromCktEnd(this.getPrimarySource());
        if (netVcatTermination == null) {
            netVcatTermination = (NetVcatTermination)this.getVcatTermFromCktEnd(this.getPrimaryDrop());
        }
        if (netVcatTermination == null) {
            return 0;
        }
        return this.reverseVcatGroup.getConfiguredNumOfMembers(netVcatTermination);
    }

    public List getAllMemberCircuits() {
        LinkedList linkedList = new LinkedList();
        linkedList.addAll(this.forwardVcatGroup.getAllMemberCircuits());
        if (this.reverseVcatGroup != null) {
            linkedList.addAll(this.reverseVcatGroup.getAllMemberCircuits());
        }
        return linkedList;
    }

    public List getAllVcatTerms() {
        return this.forwardVcatGroup.getAllVcatTerms();
    }

    public void setAdminState(int n) throws IncorrectCircuitState, AdminStateProvisioningError {
        NetCcatCircuit netCcatCircuit;
        LinkedList<NetCcatCircuit> linkedList = new LinkedList<NetCcatCircuit>();
        Iterator iterator = this.getAllMemberCircuits().iterator();
        while (iterator.hasNext()) {
            netCcatCircuit = (NetCcatCircuit)iterator.next();
            if (netCcatCircuit.isMemberInGroup()) {
                netCcatCircuit.setAdminState(n);
                continue;
            }
            linkedList.add(netCcatCircuit);
        }
        iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            netCcatCircuit = (NetCcatCircuit)iterator.next();
            netCcatCircuit.setAdminState(n);
        }
        this.adminState = n;
        this.setChanged();
        this.notifyChanged();
    }

    protected RoutePrefs getRoutePrefs() {
        return this.routePrefs;
    }

    protected void setRoutePrefs(RoutePrefs routePrefs) {
        this.routePrefs = routePrefs;
    }

    public synchronized void addDrop(INetCircuitEnd iNetCircuitEnd, RoutePrefs routePrefs) throws AllocFailed, CircuitDropOutstanding, ObjNotFound, SanityCheckFailed, IncorrectCircuitState {
        if (!this.isCircuitRefValid()) {
            throw new IncorrectCircuitState("Circuit already destroyed");
        }
        NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createCircuitEnd(this.getCircuitType(), iNetCircuitEnd);
        if (this.dbgOn()) {
            db.println("addDrop called. Drop = " + netCircuitEnd.prettyString());
        }
        this.setRoutePrefs(routePrefs);
        this.circuitInfo.setVcatRoutingPref(routePrefs.getFwdDropPrefs().isCommonFiber() ? 1 : 2);
        this.addDropCheck(netCircuitEnd, 9);
        NetCircuitDropInfo netCircuitDropInfo = new NetCircuitDropInfo(netCircuitEnd, 9);
        if (this.getCktDrops().contains(netCircuitDropInfo)) {
            throw new SanityCheckFailed("Attempt to add duplicate drop to circuit");
        }
        NetVcatTermination netVcatTermination = (NetVcatTermination)this.getVcatTermFromCktEnd(this.getPrimarySource());
        NetVcatTermination netVcatTermination2 = new NetVcatTermination(this, netCircuitEnd, netVcatTermination);
        this.forwardVcatGroup.insertVcatTermination(netVcatTermination2);
        this.forwardVcatGroup.addDrop(iNetCircuitEnd, routePrefs);
        netCircuitEnd.setStage(2);
        this.insertDrop(netCircuitDropInfo);
        if (this.getState() != 0) {
            this.setState(3);
        }
    }

    protected void routeCurrentDrop(INetElement iNetElement, RoutePrefs routePrefs, boolean bl) throws SanityCheckFailed, NoRoute, AllocFailed, AbstractCmsIOException {
        this.routeCurrentDrop(iNetElement, routePrefs, bl, this.getAllMemberCircuits());
    }

    private void routeCurrentDrop(INetElement iNetElement, RoutePrefs routePrefs, boolean bl, List list) throws SanityCheckFailed, NoRoute, AllocFailed, AbstractCmsIOException {
        NetCircuitPath netCircuitPath = new NetCircuitPath(routePrefs, this);
        LinkedList linkedList = netCircuitPath.computeCircuitPath().getDropPath().getMemberPaths();
        Iterator iterator = linkedList.iterator();
        this.setCircuitCosts(netCircuitPath.computePathCosts());
        if (bl) {
            while (iterator.hasNext()) {
                MemberPath memberPath = (MemberPath)iterator.next();
                MemberPrefs memberPrefs = memberPath.getMemberPrefs();
                boolean bl2 = false;
                NetCcatCircuit netCcatCircuit = null;
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    netCcatCircuit = (NetCcatCircuit)iterator2.next();
                    if (netCcatCircuit.getMemberPrefs().getMemberId() != memberPrefs.getMemberId()) continue;
                    bl2 = true;
                    iterator2.remove();
                    break;
                }
                if (bl2) {
                    if (this.dbgOn()) {
                        db.println("found a member circuit to addCircuitSpan (" + netCcatCircuit.getCircuitName() + ", " + NetCcatCircuit.prettyString(netCcatCircuit.getCircuitId()) + ")");
                    }
                } else if (this.dbgOn()) {
                    db.println("Warning !!! Can not found a member circuit to addCircuitSpan");
                }
                if (!bl2 || netCcatCircuit == null) continue;
                Iterator iterator3 = memberPath.getSpans().iterator();
                while (iterator3.hasNext()) {
                    netCcatCircuit.addCircuitSpan((INetLinkSpan)iterator3.next());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDrop(INetCircuitEnd iNetCircuitEnd) throws CircuitDropOutstanding, ObjNotFound, CannotDeleteLastDrop, IncorrectCircuitState, SanityCheckFailed, DeletionError, AbstractCmsIOException {
        NetVcatCircuit netVcatCircuit = this;
        synchronized (netVcatCircuit) {
            this.deleteDropCktEnd(iNetCircuitEnd);
        }
        this.notifyChanged();
    }

    protected void deleteDropCktEnd(INetCircuitEnd iNetCircuitEnd) throws CircuitDropOutstanding, ObjNotFound, CannotDeleteLastDrop, IncorrectCircuitState, SanityCheckFailed, DeletionError, AbstractCmsIOException {
        if (!this.isCircuitRefValid()) {
            throw new IncorrectCircuitState("Circuit already destroyed");
        }
        if (this.state != 0 && this.state != 1 && this.state != 3) {
            throw new IncorrectCircuitState("Circuit drop can be deleted only when status \nis CREATING, DISCOVERED, DISCOVERED_TL1 or DROP_PENDING");
        }
        NetCircuitDropInfo netCircuitDropInfo = null;
        Iterator iterator = this.getCktDrops().iterator();
        while (iterator.hasNext() && !(netCircuitDropInfo = (NetCircuitDropInfo)iterator.next()).getNetCktEnd().equals((NetCircuitEnd)iNetCircuitEnd)) {
            netCircuitDropInfo = null;
        }
        if (netCircuitDropInfo == null) {
            if (this.dbgOn()) {
                db.println("deleteDrop: unable to find drop");
            }
            throw new ObjNotFound("Unable to find the drop being deleted");
        }
        if (this.state == 1 && this.getDropsSize() == 1) {
            throw new CannotDeleteLastDrop("Last circuit drop cannot be deleted. \nPlease destroy the circuit instead");
        }
        int n = netCircuitDropInfo.getNetCktEnd().getStage();
        if (this.state == 3 && n != 2) {
            throw new CircuitDropOutstanding("Cannot delete an existing drop when another drop is pending");
        }
        this.forwardVcatGroup.deleteDrop(iNetCircuitEnd);
        if (n != 2) {
            try {
                this.circuitModel.delDrop(netCircuitDropInfo.getNetCktEnd().getCircuitEnd());
            }
            catch (CannotDeleteLastDrop cannotDeleteLastDrop) {
                if (this.dbgOn()) {
                    db.println("Cannot del. last drop: unexpected exception");
                }
                throw cannotDeleteLastDrop;
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (this.dbgOn()) {
                    db.println("Cannot del. last drop: unexpected exception");
                }
                throw abstractCmsIOException;
            }
        }
        NetVcatTermination netVcatTermination = (NetVcatTermination)this.getVcatTermFromCktEnd(netCircuitDropInfo.getNetCktEnd());
        this.forwardVcatGroup.removeVcatTermination(netVcatTermination);
        this.removeDrop(netCircuitDropInfo);
        if (this.getDropsSize() > 0 && this.state == 3) {
            this.setState(1);
        }
    }

    public synchronized void destroySanityCheck() throws SanityCheckFailed {
        Iterator iterator = this.getAllMemberCircuits().iterator();
        while (iterator.hasNext()) {
            ((NetCcatCircuit)iterator.next()).destroySanityCheck();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyCircuit() throws IncorrectCircuitState, SanityCheckFailed, DeletionError {
        NetVcatCircuit netVcatCircuit = this;
        synchronized (netVcatCircuit) {
            if (!this.isCircuitRefValid()) {
                throw new IncorrectCircuitState("Circuit already destroyed");
            }
            if (this.dbgOn()) {
                this.debug("destroy(" + this.getCircuitName() + ", " + NetVcatCircuit.prettyString(this.circuitId) + ")");
            }
            INetCircuit[] iNetCircuitArray = this.getAllMemberCircuits().toArray(new INetCircuit[0]);
            this.deleteCircuits(iNetCircuitArray);
            String string = null;
            NetVcatTermination netVcatTermination = null;
            List list = this.getAllVcatTerms();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                netVcatTermination = (NetVcatTermination)iterator.next();
                try {
                    netVcatTermination.deactivate();
                }
                catch (DeletionError deletionError) {
                    if (string == null) {
                        string = "VCAT group Deletion Failed on node " + netVcatTermination.getNodeName() + "\n";
                    }
                    string = string + deletionError.toString();
                }
            }
            if (string != null) {
                throw new DeletionError(string);
            }
            if (this.circuitInfoActive()) {
                this.destroyCircuitInfo();
            }
        }
        this.notifyDeleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteCircuits(INetCircuit[] iNetCircuitArray) throws IncorrectCircuitState, SanityCheckFailed, DeletionError {
        if (iNetCircuitArray.length > 0) {
            Object object;
            for (int i = 0; i < iNetCircuitArray.length; ++i) {
                iNetCircuitArray[i].setState(2);
            }
            IJobControl[] iJobControlArray = new IJobControl[iNetCircuitArray.length];
            for (int i = 0; i < iNetCircuitArray.length; ++i) {
                iJobControlArray[i] = new NetCircuitDeleteWorker(iNetCircuitArray[i], -1);
            }
            JobController jobController = JobControllerFactory.createJC((int)iNetCircuitArray.length);
            JobGroup jobGroup = new JobGroup(iJobControlArray, (IJobGroupListener)this, (Object)jobController);
            this.deleteDone = false;
            jobController.submitJob(jobGroup);
            while (!this.deleteDone) {
                object = this.threadWaitObject;
                synchronized (object) {
                    block14: {
                        try {
                            this.threadWaitObject.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            if (!this.dbgOn()) break block14;
                            db.println("provision: InterruptedException");
                        }
                    }
                }
            }
            object = null;
            DeletionError deletionError = null;
            try {
                JobStatus[] jobStatusArray = jobGroup.getJobStatusList();
                for (int i = 0; i < jobStatusArray.length; ++i) {
                    if (jobStatusArray[i].value() != 2) continue;
                    if (object == null) {
                        object = "Member Circuit Deletion Failed\n";
                    }
                    if ((deletionError = (DeletionError)jobStatusArray[i].getResult()) == null) continue;
                    object = (String)object + deletionError.toString();
                }
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
            if (object != null) {
                throw new DeletionError((String)object);
            }
        }
    }

    public synchronized void disposeVcatTerm(NetVcatTermination netVcatTermination, boolean bl) {
        if (netVcatTermination == null) {
            if (this.dbgOn()) {
                db.println("disposeVcatTerm: vcat term not known!");
            }
            return;
        }
        if (this.dbgOn()) {
            db.println("Disposing vcat term from " + NetVcatCircuit.prettyString(this.circuitId) + " at Node " + netVcatTermination.getNodeName() + " for circuit " + this.getCircuitName());
        }
        netVcatTermination.dispose();
        this.forwardVcatGroup.removeVcatTermination(netVcatTermination);
        if (this.reverseVcatGroup != null) {
            this.reverseVcatGroup.removeVcatTermination(netVcatTermination);
        }
        if (bl) {
            if (!this.circuitInfoActive()) {
                if (!this.tl1CircuitCompleteCheck()) {
                    this.checkAndUpdateCircuit();
                }
            } else if (!this.completeCheck()) {
                this.checkAndUpdateCircuit();
            }
        }
    }

    protected synchronized void dispose() {
        if (this.dbgOn()) {
            db.println("dispose circuit: " + this.getCircuitName());
        }
        super.destroy();
        this.deleteCircuitInfoObserver();
        this.forwardVcatGroup.dispose();
        if (this.reverseVcatGroup != null) {
            this.reverseVcatGroup.dispose();
        }
    }

    public synchronized LinkedList sanityCheckSRGs() throws SanityCheckFailed {
        if (this.dbgOn()) {
            db.println("VCAT calling sanityCheckSRGs");
        }
        if (!this.isCircuitRefValid()) {
            throw new SanityCheckFailed("Circuit already destroyed");
        }
        LinkedList linkedList = new LinkedList();
        List list = this.getNewMemberCkts();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NetCcatCircuit netCcatCircuit = (NetCcatCircuit)iterator.next();
            try {
                linkedList.addAll(netCcatCircuit.sanityCheckSRGs());
            }
            catch (SanityCheckFailed sanityCheckFailed) {
                throw new SanityCheckFailed("Validation failed on member circuit# " + netCcatCircuit.getMemberNumber() + ":\n" + sanityCheckFailed.getMessage());
            }
        }
        if (this.dbgOn()) {
            db.println("VCAT sanityCheckSRGs got " + linkedList.size() + " violations");
        }
        return linkedList;
    }

    public synchronized void sanityCheckManualRouting() throws SanityCheckFailed {
        if (!this.isCircuitRefValid()) {
            throw new SanityCheckFailed("Circuit already destroyed");
        }
        List list = this.getNewMemberCkts();
        NetCcatCircuit netCcatCircuit = this.getLongestRoutedMember();
        if (netCcatCircuit == null) {
            netCcatCircuit = (NetCcatCircuit)list.get(0);
        }
        List list2 = this.getRefCktLinkInfo(netCcatCircuit);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NetCcatCircuit netCcatCircuit2 = (NetCcatCircuit)iterator.next();
            try {
                netCcatCircuit2.sanityCheckManualRouting();
            }
            catch (SanityCheckFailed sanityCheckFailed) {
                throw new SanityCheckFailed("Validation failed on member circuit# " + netCcatCircuit2.getMemberNumber() + ":\n" + sanityCheckFailed.getMessage());
            }
            if (this.getVcatRoutingPref() != 1) continue;
            if (netCcatCircuit2.hasUpsrConnection()) {
                throw new SanityCheckFailed("Validation failed on member circuit# " + netCcatCircuit2.getMemberNumber() + ":\n" + "Common fiber routing does not allow member circuits " + "to be path protected.");
            }
            if (netCcatCircuit2 == netCcatCircuit || this.shareCommonFiber(netCcatCircuit2, list2)) continue;
            throw new SanityCheckFailed("Validation failed on member circuit# " + netCcatCircuit2.getMemberNumber() + ":\n" + "Common fiber routing requires all member circuits " + "to traverse through the same set of fibers.");
        }
    }

    private List getRefCktLinkInfo(NetCcatCircuit netCcatCircuit) {
        LinkedList<INetLink> linkedList = new LinkedList<INetLink>();
        List list = netCcatCircuit.getCircuitSpans();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            linkedList.add(((NetCircuitSpan)iterator.next()).getLink());
        }
        NetLinkComparator netLinkComparator = new NetLinkComparator();
        Collections.sort(linkedList, netLinkComparator);
        return linkedList;
    }

    private boolean shareCommonFiber(NetCcatCircuit netCcatCircuit, List list) {
        if (netCcatCircuit.isUpsrCircuit()) {
            return false;
        }
        LinkedList<INetLink> linkedList = new LinkedList<INetLink>();
        List list2 = netCcatCircuit.getCircuitSpans();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            linkedList.add(((NetCircuitSpan)iterator.next()).getLink());
        }
        NetLinkComparator netLinkComparator = new NetLinkComparator();
        Collections.sort(linkedList, netLinkComparator);
        Collections.sort(list, netLinkComparator);
        if (list.size() != linkedList.size()) {
            return false;
        }
        Iterator iterator2 = list.iterator();
        Iterator iterator3 = linkedList.iterator();
        while (iterator2.hasNext() && iterator3.hasNext()) {
            INetLink iNetLink = (INetLink)iterator2.next();
            INetLink iNetLink2 = (INetLink)iterator3.next();
            if (iNetLink != null ? iNetLink.physicalLinkEquals(iNetLink2) : iNetLink2 == null) continue;
            return false;
        }
        return true;
    }

    public synchronized void sanityCheck() throws SanityCheckFailed {
        if (!this.isCircuitRefValid()) {
            throw new SanityCheckFailed("Circuit already destroyed");
        }
        Iterator iterator = this.getAllMemberCircuits().iterator();
        while (iterator.hasNext()) {
            NetCcatCircuit netCcatCircuit = (NetCcatCircuit)iterator.next();
            if (netCcatCircuit.getState() != 0) continue;
            netCcatCircuit.sanityCheck();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(String string) throws CircuitProvError {
        NetVcatCircuit netVcatCircuit = this;
        synchronized (netVcatCircuit) {
            if (string.trim().equals("")) {
                throw new CircuitProvError("Circuit name cannot be blank");
            }
            this.renameCircuit(string);
            this.renameVcatTerms(string);
        }
        this.notifyChanged();
    }

    private void renameVcatTerms(String string) throws CircuitProvError {
        Iterator iterator = this.getAllVcatTerms().iterator();
        while (iterator.hasNext()) {
            ((NetVcatTermination)iterator.next()).setVcatName(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void provision() throws NoRoute, ConnTypeUnsupported, SanityCheckFailed, CircuitProvError, AnnotatedException {
        boolean bl = false;
        NetVcatCircuit netVcatCircuit = this;
        synchronized (netVcatCircuit) {
            if (this.dbgOn()) {
                db.println("provision called for " + this.getCircuitName() + ". Id = " + NetVcatCircuit.prettyString(this.circuitId));
            }
            if (!this.isCircuitRefValid()) {
                throw new CircuitProvError("Circuit already destroyed");
            }
            if (this.state != 0 && this.state != 3) {
                throw new CircuitProvError("Invalid state for provision");
            }
            if (this.tl1Compatible()) {
                if (!this.tl1InfoActive()) {
                    this.createTl1Info();
                    bl = true;
                }
            } else if (!this.circuitInfoActive()) {
                this.createCircuitInfo(this.srcNodeModel, this.circuitInfo);
                bl = true;
            }
            if (this.dbgOn()) {
                db.println("Vcat circuitInfo creation successful");
            }
            String string = null;
            NetVcatTermination netVcatTermination = null;
            try {
                Iterator iterator = this.getAllVcatTerms().iterator();
                while (iterator.hasNext()) {
                    netVcatTermination = (NetVcatTermination)iterator.next();
                    netVcatTermination.activate();
                }
            }
            catch (CircuitProvError circuitProvError) {
                if (string == null) {
                    string = "VCAT group Creation Failed on node " + netVcatTermination.getNodeName() + "\n";
                }
                string = string + circuitProvError.toString();
            }
            if (string != null) {
                block27: {
                    try {
                        if (this.dbgOn()) {
                            db.println("VcatTerm creation failed on node " + netVcatTermination.getNodeName() + ", call tentative2Routed");
                        }
                        this.tentative2Routed();
                    }
                    catch (DeletionError deletionError) {
                        if (this.dbgOn()) {
                            db.println("tentative2Routed encountered exception " + deletionError.getMessage());
                        }
                    }
                    catch (IncorrectCircuitState incorrectCircuitState) {
                        if (!this.dbgOn()) break block27;
                        db.println("tentative2Routed encountered exception " + incorrectCircuitState.getMessage());
                    }
                }
                throw new CircuitProvError(string);
            }
            if (this.dbgOn()) {
                db.println("VcatTerms creation successful");
            }
            this.provisionCircuits(this.getAllMemberCircuits());
            if (this.tl1Compatible()) {
                this.setState(5);
                this.tl1Compatible = false;
            } else {
                this.setState(1);
            }
            if (bl) {
                this.serviceState = this.deriveServiceState();
                this.setProtType();
            }
        }
        if (bl) {
            this.clearChanged();
            this.ncMgr.notifyChanged(this);
        } else {
            this.notifyChanged();
        }
    }

    private void provisionCircuits(List list) throws NoRoute, ConnTypeUnsupported, SanityCheckFailed, CircuitProvError, AnnotatedException {
        String string = null;
        NetCcatCircuit netCcatCircuit = null;
        try {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                netCcatCircuit = (NetCcatCircuit)iterator.next();
                netCcatCircuit.provision();
            }
        }
        catch (NoRoute noRoute) {
            if (string == null) {
                string = "VCAT circuit creation failed on member circuit# " + netCcatCircuit.getMemberNumber() + ":\n";
            }
            string = string + noRoute.toString();
        }
        catch (ConnTypeUnsupported connTypeUnsupported) {
            if (string == null) {
                string = "VCAT circuit creation failed on member circuit# " + netCcatCircuit.getMemberNumber() + ":\n";
            }
            string = string + connTypeUnsupported.toString();
        }
        catch (SanityCheckFailed sanityCheckFailed) {
            if (string == null) {
                string = "VCAT circuit creation failed on member circuit# " + netCcatCircuit.getMemberNumber() + ":\n";
            }
            string = string + sanityCheckFailed.toString();
        }
        catch (CircuitProvError circuitProvError) {
            if (string == null) {
                string = "VCAT circuit creation failed on member circuit# " + netCcatCircuit.getMemberNumber() + ":\n";
            }
            string = string + circuitProvError.toString();
        }
        catch (AnnotatedException annotatedException) {
            if (string == null) {
                string = "VCAT circuit creation failed on member circuit# " + netCcatCircuit.getMemberNumber() + ":\n";
            }
            string = string + annotatedException.toString();
        }
        if (string != null) {
            block28: {
                try {
                    if (this.dbgOn()) {
                        db.println("member circuit creation failure on member ckt " + netCcatCircuit.getMemberNumber() + ", call tentative2Routed");
                    }
                    this.tentative2Routed();
                }
                catch (DeletionError deletionError) {
                    if (this.dbgOn()) {
                        db.println("tentative2Routed encountered exception " + deletionError.getMessage());
                    }
                }
                catch (IncorrectCircuitState incorrectCircuitState) {
                    if (!this.dbgOn()) break block28;
                    db.println("tentative2Routed encountered exception " + incorrectCircuitState.getMessage());
                }
            }
            throw new CircuitProvError(string);
        }
        if (this.dbgOn()) {
            db.println("all member circuits creation successful");
        }
        if (this.circuitInfoActive()) {
            try {
                this.addDropToCircuitInfo();
            }
            catch (CircuitProvError circuitProvError) {
                block29: {
                    try {
                        if (this.dbgOn()) {
                            db.println("Vcat circuit add drop failed, call tentative2Routed");
                        }
                        this.tentative2Routed();
                    }
                    catch (DeletionError deletionError) {
                        if (this.dbgOn()) {
                            db.println("tentative2Routed encountered exception " + deletionError.getMessage());
                        }
                    }
                    catch (IncorrectCircuitState incorrectCircuitState) {
                        if (!this.dbgOn()) break block29;
                        db.println("tentative2Routed encountered exception " + incorrectCircuitState.getMessage());
                    }
                }
                throw circuitProvError;
            }
        }
        if (this.dbgOn()) {
            db.println("Vcat circuit add drop successful");
        }
        this.tentative2Active();
    }

    private void tentative2Routed() throws DeletionError, IncorrectCircuitState {
        Iterator iterator = this.getAllMemberCircuits().iterator();
        while (iterator.hasNext()) {
            ((NetCcatCircuit)iterator.next()).tentative2Routed();
        }
        if (this.getCktOperation() == 1 && this.circuitInfoActive()) {
            this.destroyCircuitInfo();
        }
        iterator = this.getAllVcatTerms().iterator();
        while (iterator.hasNext()) {
            ((NetVcatTermination)iterator.next()).tentative2Routed();
        }
    }

    private void tentative2Active() {
        Iterator iterator = this.getAllMemberCircuits().iterator();
        while (iterator.hasNext()) {
            ((NetCcatCircuit)iterator.next()).tentative2Active();
        }
        iterator = this.getAllVcatTerms().iterator();
        while (iterator.hasNext()) {
            ((NetVcatTermination)iterator.next()).tentative2Active();
        }
        this.setCktOperation(0);
    }

    protected synchronized boolean completeCheck() {
        if (this.dbgOn()) {
            db.println("completeCheck() for " + this.getCircuitName());
        }
        if (this.inRoll()) {
            this.setState(8);
        }
        if (!this.circuitInfoActive()) {
            if (this.dbgOn()) {
                db.println("Circuit Info is not active");
            }
            return false;
        }
        if (!this.setSrcCircuitNode()) {
            return false;
        }
        if (!this.forwardVcatGroup.completeCheck()) {
            return false;
        }
        if (this.reverseVcatGroup != null && !this.reverseVcatGroup.completeCheck()) {
            return false;
        }
        if (this.inRoll()) {
            return true;
        }
        this.setState(1);
        if (this.dbgOn()) {
            db.println("completeCheck passed. Setting the state to ACTIVE");
        }
        return true;
    }

    protected synchronized boolean tl1CircuitCompleteCheck() {
        if (this.dbgOn()) {
            db.println("tl1CircuitCompleteCheck() for " + this.getCircuitName());
        }
        if (this.circuitInfoActive()) {
            if (this.dbgOn()) {
                db.println("circuit Info is Active : CTC ckt.");
            }
            return false;
        }
        this.initSourcesAndDrops();
        if (!this.forwardVcatGroup.completeCheck()) {
            return false;
        }
        if (this.reverseVcatGroup != null && !this.reverseVcatGroup.completeCheck()) {
            return false;
        }
        if (this.inRoll()) {
            this.setState(8);
        } else {
            try {
                if (this.isTl1Ckt()) {
                    this.setState(5);
                } else {
                    this.setState(4);
                }
            }
            catch (IncorrectCircuitState incorrectCircuitState) {
                // empty catch block
            }
        }
        if (this.dbgOn()) {
            db.println("tl1CircuitCompleteCheck passed");
        }
        return true;
    }

    protected synchronized void checkAndUpdateCircuit() {
        if (this.dbgOn()) {
            this.debug("calling checkAndUpdateCircuit on " + this.getCircuitName());
        }
        if (this.getAllVcatTerms().size() == 0) {
            if (this.getAllMemberCircuits().size() == 0) {
                if (this.circuitModel == null) {
                    this.finalDispose();
                    return;
                }
            } else {
                this.forwardVcatGroup.convertMemberCircuits();
                if (this.reverseVcatGroup != null) {
                    this.reverseVcatGroup.convertMemberCircuits();
                }
                if (this.circuitModel == null) {
                    this.finalDispose();
                    return;
                }
            }
        }
        if (!this.circuitInfoActive()) {
            this.initSourcesAndDrops();
        }
        if (this.inRoll()) {
            this.setState(8);
        } else if (this.getState() == 5 || this.getState() == 6) {
            this.setState(6);
        } else if (this.getState() != 2 && this.getState() != 0) {
            this.setState(4);
        }
    }

    protected void initSourcesAndDrops() {
        if (this.circuitInfoActive()) {
            return;
        }
        if (this.dbgOn()) {
            db.println("initSourcesAndDrops() called");
        }
        List list = this.getAllVcatTerms();
        List list2 = this.getAllMemberCircuits();
        if (list.size() == 0) {
            return;
        }
        if (list2.size() == 0) {
            int n = this.getSourcesSize() + this.getDropsSize();
            if (n != list.size()) {
                this.setSources(null);
                this.setDrops(null);
                this.setChanged();
                Iterator iterator = list.iterator();
                NetVcatTermination netVcatTermination = (NetVcatTermination)iterator.next();
                NetCircuitEnd netCircuitEnd = (NetCircuitEnd)netVcatTermination.getNetCktEnd();
                this.insertSource(netCircuitEnd);
                while (iterator.hasNext()) {
                    netVcatTermination = (NetVcatTermination)iterator.next();
                    NetCircuitEnd netCircuitEnd2 = (NetCircuitEnd)netVcatTermination.getNetCktEnd();
                    NetCircuitDropInfo netCircuitDropInfo = new NetCircuitDropInfo(netCircuitEnd2, 9);
                    this.insertDrop(netCircuitDropInfo);
                }
                this.updateCircuitSourceInfo();
                this.updateCircuitDropInfo();
                this.setSrcCircuitNode();
            }
            return;
        }
        NetCircuitEnd netCircuitEnd = null;
        NetCircuitEnd netCircuitEnd3 = null;
        NetCircuitEnd netCircuitEnd4 = null;
        NetCircuitEnd netCircuitEnd5 = null;
        NetVcatTermination netVcatTermination = null;
        NetVcatTermination netVcatTermination2 = null;
        NetCcatCircuit netCcatCircuit = null;
        NetCircuit netCircuit = null;
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            netVcatTermination = null;
            netVcatTermination2 = null;
            netCcatCircuit = (NetCcatCircuit)iterator.next();
            if (netCcatCircuit.getPrimarySource() != null && netCcatCircuit.getPrimarySource().getNodeId() != 0) {
                netCircuitEnd = netCcatCircuit.getTermEndFromCktEnd(netCcatCircuit.getPrimarySource());
                netVcatTermination = (NetVcatTermination)this.getVcatTermFromCktEnd(netCircuitEnd);
            }
            if (netCcatCircuit.getPrimaryDrop() != null && netCcatCircuit.getPrimaryDrop().getNodeId() != 0) {
                netCircuitEnd3 = netCcatCircuit.getTermEndFromCktEnd(netCcatCircuit.getPrimaryDrop());
                netVcatTermination2 = (NetVcatTermination)this.getVcatTermFromCktEnd(netCircuitEnd3);
            }
            if (list.size() == 1) {
                if (netVcatTermination != null && netVcatTermination2 == null) {
                    netCircuit = netCcatCircuit;
                    netCircuitEnd4 = netCircuitEnd;
                    netCircuitEnd5 = null;
                    break;
                }
                if (netVcatTermination != null || netVcatTermination2 == null) continue;
                netCircuit = netCcatCircuit;
                netCircuitEnd4 = null;
                netCircuitEnd5 = netCircuitEnd3;
                break;
            }
            if (netVcatTermination == null || netVcatTermination2 == null) continue;
            netCircuit = netCcatCircuit;
            netCircuitEnd4 = netCircuitEnd;
            netCircuitEnd5 = netCircuitEnd3;
            break;
        }
        if (this.dbgOn()) {
            if (netCircuit != null && netCircuitEnd4 != null && netCircuitEnd5 != null) {
                db.println("found a member circuit that matches both src and drop vcat terms: " + netCircuit.getCircuitName());
            } else if (netCircuit != null && netCircuitEnd4 == null && netCircuitEnd5 != null) {
                db.println("found a member circuit matches only drop vcat term (open-ended vcat ckt): " + netCircuit.getCircuitName());
            } else if (netCircuit != null && netCircuitEnd4 != null && netCircuitEnd5 == null) {
                db.println("found a member circuit matches only src vcat term (open-ended vcat ckt): " + netCircuit.getCircuitName());
            } else if (netCircuit == null && netCircuitEnd4 == null && netCircuitEnd5 == null) {
                db.println("didn't find any member circuit matches src or drop vcat termination, exit");
            }
        }
        if (netCircuit == null) {
            return;
        }
        this.setSources(null);
        this.setDrops(null);
        this.setChanged();
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            netCcatCircuit = (NetCcatCircuit)iterator.next();
            if (netCcatCircuit == netCircuit) continue;
            netCcatCircuit.initSourcesAndDrops(netCircuitEnd4, netCircuitEnd5);
        }
        if (netCircuitEnd4 != null) {
            this.insertSource(netCircuitEnd4);
        }
        if (netCircuitEnd5 != null) {
            NetCircuitDropInfo netCircuitDropInfo = new NetCircuitDropInfo(netCircuitEnd5, 9);
            this.insertDrop(netCircuitDropInfo);
        }
        this.updateCircuitSourceInfo();
        this.updateCircuitDropInfo();
        this.setSrcCircuitNode();
    }

    protected boolean isTl1Ckt() throws IncorrectCircuitState {
        if (this.circuitInfoActive()) {
            if (this.dbgOn()) {
                this.debug("isTL1Ckt: " + this.getCircuitName() + ": CircuitInfo is ACTIVE !!");
            }
            throw new IncorrectCircuitState("CircuitInfo has been discovered");
        }
        CircuitId circuitId = new CircuitId(0, 0);
        CircuitId circuitId2 = new CircuitId(0, 0);
        boolean bl = false;
        boolean bl2 = false;
        Iterator iterator = this.getAllVcatTerms().iterator();
        while (iterator.hasNext()) {
            NetVcatTermination netVcatTermination = (NetVcatTermination)iterator.next();
            circuitId = netVcatTermination.getCircuitId();
            if (this.dbgOn()) {
                this.debug("isTl1Ckt: For ckt = " + this.getCircuitName() + " ;On node :" + netVcatTermination.getNodeName() + " has cktId = " + NetVcatCircuit.prettyString(circuitId));
            }
            if (NetVcatCircuit.isNullCircuitId(circuitId)) {
                bl2 = true;
                continue;
            }
            if (bl) {
                if (((Object)circuitId).equals(circuitId2)) continue;
                if (this.dbgOn()) {
                    this.debug("isTl1Ckt: " + this.getCircuitName() + " failed:Found two circuitIds " + circuitId2 + " and " + circuitId);
                }
                throw new IncorrectCircuitState("Circuit has multiple circuit ids");
            }
            bl = true;
            circuitId2 = circuitId;
        }
        if (this.dbgOn()) {
            this.debug("isTl1Ckt: " + this.getCircuitName() + bl2 + " Non-null cktId = " + NetVcatCircuit.prettyString(circuitId2));
        }
        if (NetVcatCircuit.isNullCircuitId(this.circuitId) && !NetVcatCircuit.isNullCircuitId(circuitId2) || !NetVcatCircuit.isNullCircuitId(this.circuitId) && NetVcatCircuit.isNullCircuitId(circuitId2)) {
            this.ncMgr.removeCircuit(this);
            this.updateCircuitId(circuitId2);
            this.ncMgr.insertCircuit(this, false);
        }
        return bl2;
    }

    public Set getAffectedNodes(int n, int n2) {
        HashSet<INodeModel> hashSet = new HashSet<INodeModel>();
        if (NetVcatCircuit.isNullCircuitId(this.circuitId)) {
            return hashSet;
        }
        Iterator iterator = this.getAllMemberCircuits().iterator();
        while (iterator.hasNext()) {
            hashSet.addAll(((NetCcatCircuit)iterator.next()).getAffectedNodes(n, n2));
        }
        if (this.circuitId.getNodeId() == n) {
            iterator = this.getAllVcatTerms().iterator();
            while (iterator.hasNext()) {
                NetVcatTermination netVcatTermination = (NetVcatTermination)iterator.next();
                hashSet.add(netVcatTermination.getNodeModel());
            }
        }
        return hashSet;
    }

    public synchronized boolean repairCircuit(int n, int n2) throws CircuitProvError {
        if (!this.isRepairable()) {
            return false;
        }
        boolean bl = true;
        Iterator iterator = this.getAllMemberCircuits().iterator();
        while (iterator.hasNext()) {
            NetCcatCircuit netCcatCircuit = (NetCcatCircuit)iterator.next();
            try {
                if (netCcatCircuit.repairCircuit(n, n2)) continue;
                bl = false;
            }
            catch (CircuitProvError circuitProvError) {
                if (this.dbgOn()) {
                    db.println("repairCircuit encountered exception " + circuitProvError.getMessage());
                }
                bl = false;
            }
        }
        if (!super.repairCircuit(n, n2)) {
            bl = false;
        }
        return bl;
    }

    protected synchronized void changeCircuitId(ICircuitId iCircuitId) {
        Iterator iterator = this.getAllVcatTerms().iterator();
        while (iterator.hasNext()) {
            NetVcatTermination netVcatTermination = (NetVcatTermination)iterator.next();
            netVcatTermination.setVcatTermCircuitId(iCircuitId);
            this.disposeVcatTerm(netVcatTermination, false);
            NetCircuitWatchDog.instance().reloadVcatTerms(netVcatTermination.getNetElement());
        }
    }

    public synchronized INetCircuit[] createNewMemberCkts(CircuitCreatInfo circuitCreatInfo) {
        return this.forwardVcatGroup.createMemberCircuit(circuitCreatInfo, circuitCreatInfo.forwardMembers(), this.getPrimarySource(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNewMemberCkts() throws IncorrectCircuitState, SanityCheckFailed, DeletionError {
        NetVcatCircuit netVcatCircuit = this;
        synchronized (netVcatCircuit) {
            INetCircuit[] iNetCircuitArray = this.getNewMemberCkts().toArray(new INetCircuit[0]);
            this.deleteCircuits(iNetCircuitArray);
            if (this.hasNullCircuitId()) {
                if (!this.tl1CircuitCompleteCheck()) {
                    this.checkAndUpdateCircuit();
                }
            } else if (!this.completeCheck()) {
                this.checkAndUpdateCircuit();
            }
            this.setChanged();
        }
        this.notifyChanged();
    }

    public synchronized void addDropForNewMemberCkts() throws AllocFailed, CircuitDropOutstanding, ObjNotFound, SanityCheckFailed, IncorrectCircuitState {
        List list = this.getNewMemberCkts();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((NetCcatCircuit)iterator.next()).addDrop(this.getPrimaryDrop(), null);
        }
    }

    public synchronized void deleteDropForNewMemberCkts() throws CircuitDropOutstanding, ObjNotFound, IncorrectCircuitState, SanityCheckFailed, AbstractCmsIOException {
        block5: {
            try {
                List list = this.getNewMemberCkts();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ((NetCcatCircuit)iterator.next()).deleteDrop(this.getPrimaryDrop());
                }
            }
            catch (CannotDeleteLastDrop cannotDeleteLastDrop) {
                if (this.dbgOn()) {
                    db.println("Cannot del. last drop: unexpected exception.");
                }
            }
            catch (DeletionError deletionError) {
                if (!this.dbgOn()) break block5;
                db.println("unable to reverse for deleting routed drop encountered exception " + deletionError.getMessage());
            }
        }
    }

    public synchronized void routeNewMemberCkts(RoutePrefs routePrefs) throws AllocFailed, ObjNotFound, NoRoute, CircuitDropOutstanding, IncorrectCircuitState, SanityCheckFailed, AbstractCmsIOException {
        RoutePrefs routePrefs2 = new RoutePrefs(routePrefs);
        NetCcatCircuit netCcatCircuit = this.getLongestRoutedMember();
        if (netCcatCircuit != null) {
            LinkedList linkedList = routePrefs2.getFwdDropPrefs().getMemberGroupPrefs();
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                MemberPrefs memberPrefs = ((MemberGroupPrefs)iterator.next()).getMemberPrefs();
                LinkedList<INetLink> linkedList2 = new LinkedList<INetLink>();
                LinkedList linkedList3 = netCcatCircuit.getRequiredSpans();
                Iterator iterator2 = linkedList3.iterator();
                while (iterator2.hasNext()) {
                    INetLink iNetLink;
                    INetLink iNetLink2 = ((INetLinkSpan)iterator2.next()).getLink();
                    if (memberPrefs.getPathProtection() == 2) {
                        linkedList2.add(iNetLink2);
                        continue;
                    }
                    if (memberPrefs.getPathProtection() == 4) {
                        if (iNetLink2.isPca()) {
                            linkedList2.add(iNetLink2);
                            continue;
                        }
                        iNetLink = iNetLink2.getCounterpartLink();
                        if (iNetLink == null) continue;
                        linkedList2.add(iNetLink);
                        continue;
                    }
                    if (iNetLink2.isPca()) {
                        iNetLink = iNetLink2.getCounterpartLink();
                        if (iNetLink == null) continue;
                        linkedList2.add(iNetLink);
                        continue;
                    }
                    linkedList2.add(iNetLink2);
                }
                if (routePrefs2.getFwdDropPrefs().isCommonFiber()) {
                    memberPrefs.addRequiredLinks(linkedList2);
                    continue;
                }
                memberPrefs.addPreferredLinks(linkedList2);
            }
        }
        this.addDropForNewMemberCkts();
        try {
            this.routeCurrentDrop(this.getPrimaryDrop().getNetElement(), routePrefs2, true, this.getNewMemberCkts());
        }
        catch (NoRoute noRoute) {
            SDebug.printStackTrace((Throwable)((Object)noRoute));
            if (this.dbgOn()) {
                db.println("unable to route to drop " + noRoute.getMessage());
            }
            this.deleteDropForNewMemberCkts();
            throw noRoute;
        }
        catch (AllocFailed allocFailed) {
            if (this.dbgOn()) {
                db.println("unable to route to drop " + allocFailed.getMessage());
            }
            SDebug.printStackTrace((Throwable)((Object)allocFailed));
            this.deleteDropForNewMemberCkts();
            throw allocFailed;
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            if (this.dbgOn()) {
                db.println("unable to route to drop " + abstractCmsIOException.getMessage());
            }
            SDebug.printStackTrace((Throwable)abstractCmsIOException);
            this.deleteDropForNewMemberCkts();
            throw abstractCmsIOException;
        }
        catch (SanityCheckFailed sanityCheckFailed) {
            if (this.dbgOn()) {
                db.println("unable to route to drop " + sanityCheckFailed.getMessage());
            }
            SDebug.printStackTrace((Throwable)sanityCheckFailed);
            this.deleteDropForNewMemberCkts();
            throw sanityCheckFailed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void provisionNewMemberCkts() throws NoRoute, ConnTypeUnsupported, SanityCheckFailed, CircuitProvError, AnnotatedException {
        NetVcatCircuit netVcatCircuit = this;
        synchronized (netVcatCircuit) {
            this.setCktOperation(6);
            List list = this.getNewMemberCkts();
            this.increaseMemberCount(list.size());
            if (this.dbgOn()) {
                db.println("increase member count successful");
            }
            this.provisionCircuits(list);
            if (this.dbgOn()) {
                db.println("provision new member circuits successful");
            }
            this.setCktOperation(0);
            this.setChanged();
        }
        this.notifyChanged();
    }

    public boolean requireForceDeletion(INetCircuit[] iNetCircuitArray) {
        for (int i = 0; i < iNetCircuitArray.length; ++i) {
            if (!((NetCcatCircuit)iNetCircuitArray[i]).requireForceDeletion()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyMemberCkts(INetCircuit[] iNetCircuitArray) throws IncorrectCircuitState, SanityCheckFailed, DeletionError {
        NetVcatCircuit netVcatCircuit = this;
        synchronized (netVcatCircuit) {
            this.setCktOperation(7);
            this.deleteCircuits(iNetCircuitArray);
            if (this.dbgOn()) {
                db.println("delete old member circuits successful");
            }
            this.decreaseMemberCount(iNetCircuitArray.length);
            if (this.dbgOn()) {
                db.println("decrease member count successful");
            }
            this.setCktOperation(0);
            this.setChanged();
        }
        this.notifyChanged();
    }

    private void increaseMemberCount(int n) throws CircuitProvError {
        Iterator iterator;
        String string = null;
        NetVcatTermination netVcatTermination = null;
        int n2 = 0;
        try {
            iterator = this.getAllVcatTerms().iterator();
            while (iterator.hasNext()) {
                netVcatTermination = (NetVcatTermination)iterator.next();
                n2 = netVcatTermination.getConfiguredNumOfMembers(2);
                netVcatTermination.setConfiguredNumOfMembersOnNE(n2 + n, 2);
            }
        }
        catch (InvalidOperation invalidOperation) {
            if (string == null) {
                string = "Fail to increase member count on node " + netVcatTermination.getNodeName() + "\n";
            }
            string = string + invalidOperation.toString();
        }
        catch (InvalidParms invalidParms) {
            if (string == null) {
                string = "Fail to increase member count on node " + netVcatTermination.getNodeName() + "\n";
            }
            string = string + invalidParms.toString();
        }
        catch (ObjNotFound objNotFound) {
            if (string == null) {
                string = "Fail to increase member count on node " + netVcatTermination.getNodeName() + "\n";
            }
            string = string + objNotFound.toString();
        }
        if (string != null) {
            iterator = this.getAllVcatTerms().iterator();
            while (iterator.hasNext()) {
                netVcatTermination = (NetVcatTermination)iterator.next();
                netVcatTermination.revertMemberCount();
            }
            if (this.dbgOn()) {
                db.println("revert member count successful");
            }
            throw new CircuitProvError(string);
        }
    }

    private void decreaseMemberCount(int n) throws DeletionError {
        String string = null;
        NetVcatTermination netVcatTermination = null;
        int n2 = 0;
        Iterator iterator = this.getAllVcatTerms().iterator();
        while (iterator.hasNext()) {
            netVcatTermination = (NetVcatTermination)iterator.next();
            n2 = netVcatTermination.getConfiguredNumOfMembers(2);
            try {
                netVcatTermination.setConfiguredNumOfMembersOnNE(n2 - n, 2);
                netVcatTermination.setConfiguredNumOfMembers(n2 - n, 2);
            }
            catch (InvalidOperation invalidOperation) {
                if (string == null) {
                    string = "Fail to decrease member count on node " + netVcatTermination.getNodeName() + "\n";
                }
                string = string + invalidOperation.toString();
            }
            catch (InvalidParms invalidParms) {
                if (string == null) {
                    string = "Fail to decrease member count on node " + netVcatTermination.getNodeName() + "\n";
                }
                string = string + invalidParms.toString();
            }
            catch (ObjNotFound objNotFound) {
                if (string == null) {
                    string = "Fail to decrease member count on node " + netVcatTermination.getNodeName() + "\n";
                }
                string = string + objNotFound.toString();
            }
        }
        if (string != null) {
            throw new DeletionError(string);
        }
    }

    private List getExistingMemberCkts() {
        LinkedList<NetCcatCircuit> linkedList = new LinkedList<NetCcatCircuit>();
        Iterator iterator = this.getAllMemberCircuits().iterator();
        while (iterator.hasNext()) {
            NetCcatCircuit netCcatCircuit = (NetCcatCircuit)iterator.next();
            if (netCcatCircuit.getState() == 0) continue;
            linkedList.add(netCcatCircuit);
        }
        return linkedList;
    }

    private List getNewMemberCkts() {
        LinkedList<NetCcatCircuit> linkedList = new LinkedList<NetCcatCircuit>();
        Iterator iterator = this.getAllMemberCircuits().iterator();
        while (iterator.hasNext()) {
            NetCcatCircuit netCcatCircuit = (NetCcatCircuit)iterator.next();
            if (netCcatCircuit.getState() != 0) continue;
            linkedList.add(netCcatCircuit);
        }
        return linkedList;
    }

    private NetCcatCircuit getLongestRoutedMember() {
        NetCcatCircuit netCcatCircuit = null;
        int n = 0;
        Iterator iterator = this.getAllMemberCircuits().iterator();
        while (iterator.hasNext()) {
            NetCcatCircuit netCcatCircuit2 = (NetCcatCircuit)iterator.next();
            int n2 = netCcatCircuit2.getActiveCircuitSpans().size();
            if (n2 <= n) continue;
            netCcatCircuit = netCcatCircuit2;
            n = n2;
        }
        return netCcatCircuit;
    }

    protected List getLinkEndpoints(INetLink iNetLink) {
        LinkedList linkedList = new LinkedList();
        Iterator iterator = this.getAllMemberCircuits().iterator();
        while (iterator.hasNext()) {
            linkedList.addAll(((NetCcatCircuit)iterator.next()).getLinkEndpoints(iNetLink));
        }
        return linkedList;
    }

    protected boolean usesNetElement(INetElement iNetElement) {
        return this.doesCircuitUseNetElem(iNetElement) || this.doesCircuitUseVcatTerm(iNetElement) || this.hasSourceWithNetElement(iNetElement);
    }

    protected boolean doesCircuitUseVcatTerm(INetElement iNetElement) {
        Iterator iterator = this.getAllVcatTerms().iterator();
        while (iterator.hasNext()) {
            if (!((NetVcatTermination)iterator.next()).getNetElement().equals(iNetElement)) continue;
            return true;
        }
        return false;
    }

    protected boolean doesCircuitUseConn(INetElement iNetElement, IConnectionModel iConnectionModel) {
        Iterator iterator = this.getAllMemberCircuits().iterator();
        while (iterator.hasNext()) {
            if (!((NetCcatCircuit)iterator.next()).doesCircuitUseConn(iNetElement, iConnectionModel)) continue;
            return true;
        }
        return false;
    }

    public boolean doesCircuitUseNetElem(INetElement iNetElement) {
        Iterator iterator = this.getAllMemberCircuits().iterator();
        while (iterator.hasNext()) {
            if (!((NetCcatCircuit)iterator.next()).doesCircuitUseNetElem(iNetElement)) continue;
            return true;
        }
        return false;
    }

    public boolean doesCircuitUseNetLink(INetLink iNetLink) {
        Iterator iterator = this.getAllMemberCircuits().iterator();
        while (iterator.hasNext()) {
            if (!((NetCcatCircuit)iterator.next()).doesCircuitUseNetLink(iNetLink)) continue;
            return true;
        }
        return false;
    }

    public List getCircuitNodes() {
        LinkedList linkedList = new LinkedList();
        Iterator iterator = this.getAllMemberCircuits().iterator();
        while (iterator.hasNext()) {
            linkedList.addAll(((NetCcatCircuit)iterator.next()).getCircuitNodes());
        }
        return linkedList;
    }

    public List getCircuitSpans() {
        LinkedList linkedList = new LinkedList();
        Iterator iterator = this.getAllMemberCircuits().iterator();
        while (iterator.hasNext()) {
            linkedList.addAll(((NetCcatCircuit)iterator.next()).getCircuitSpans());
        }
        return linkedList;
    }

    public INetVcatTermination getVcatTermFromCktEnd(INetCircuitEnd iNetCircuitEnd) {
        return this.forwardVcatGroup.getVcatTermFromCktEnd(iNetCircuitEnd);
    }

    protected NetCircuitEnd getNetCktEnd(INetElement iNetElement, int n) {
        NetCircuitEnd netCircuitEnd;
        Iterator iterator = this.getCktSources().iterator();
        while (iterator.hasNext()) {
            netCircuitEnd = (NetCircuitEnd)iterator.next();
            if (netCircuitEnd.getNetElement() != iNetElement || netCircuitEnd.getEntityIndex() != n) continue;
            return netCircuitEnd;
        }
        iterator = this.getCktDrops().iterator();
        while (iterator.hasNext()) {
            netCircuitEnd = ((NetCircuitDropInfo)iterator.next()).getNetCktEnd();
            if (netCircuitEnd.getNetElement() != iNetElement || netCircuitEnd.getEntityIndex() != n) continue;
            return netCircuitEnd;
        }
        return null;
    }

    private boolean setSrcCircuitNode() {
        if (this.dbgOn()) {
            db.println("setSrcCircuitNode()");
        }
        if (this.getSourcesSize() == 0) {
            if (this.dbgOn()) {
                db.println("setSrcCircuitNode: source list is empty!");
            }
            return false;
        }
        NetCircuitEnd netCircuitEnd = (NetCircuitEnd)this.getPrimarySource();
        INetElement iNetElement = netCircuitEnd.getNetElement();
        if (iNetElement == null) {
            if (this.dbgOn()) {
                db.println("setSrcCircuitNode: Unable to find NE in the network");
            }
            return false;
        }
        this.srcNodeModel = iNetElement.getNodeModel();
        String string = this.getCircuitNameFromSrcNode();
        this.updateCircuitName(string);
        return true;
    }

    public int getPhysicalRoutingPref() {
        List list = this.getExistingMemberCkts();
        if (list.size() == 0) {
            return 1;
        }
        NetCcatCircuit netCcatCircuit = (NetCcatCircuit)list.get(0);
        List list2 = this.getRefCktLinkInfo(netCcatCircuit);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NetCcatCircuit netCcatCircuit2 = (NetCcatCircuit)iterator.next();
            if (netCcatCircuit2 == netCcatCircuit || this.shareCommonFiber(netCcatCircuit2, list2)) continue;
            return 2;
        }
        return 1;
    }

    protected void setSource(NetCircuitEnd netCircuitEnd) {
        this.insertSource(netCircuitEnd);
        INetElement iNetElement = null;
        try {
            iNetElement = netCircuitEnd.getNetElement();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            db.println("i/o exception in NetVcatCircuit/findNetElem");
            SDebug.printStackTrace((Throwable)abstractCmsIOException);
            iNetElement = null;
        }
        if (iNetElement == null) {
            if (this.dbgOn()) {
                db.println("Warning: unable to find Net Element in NetVcatCircuit()");
            }
            return;
        }
        this.srcNodeModel = iNetElement.getNodeModel();
    }

    public boolean isOpenEndedVcatCircuit() {
        return this.forwardVcatGroup.getVcatTermsSize() == 1;
    }

    public boolean isSplitRoutingAllowed() {
        INetCircuitEnd iNetCircuitEnd = this.getPrimarySource();
        INetCircuitEnd iNetCircuitEnd2 = this.getPrimaryDrop();
        if (this.isOpenEndedVcatCircuit()) {
            return this.supportsSplitRouting(iNetCircuitEnd) || this.supportsSplitRouting(iNetCircuitEnd2);
        }
        return this.supportsSplitRouting(iNetCircuitEnd) && this.supportsSplitRouting(iNetCircuitEnd2);
    }

    private boolean supportsSplitRouting(INetCircuitEnd iNetCircuitEnd) {
        INodeModel iNodeModel;
        boolean bl = false;
        IEntityModel iEntityModel = null;
        if (iNetCircuitEnd != null) {
            try {
                iEntityModel = iNetCircuitEnd.getEntityModel();
            }
            catch (ObjNotFound objNotFound) {
                iEntityModel = null;
            }
        }
        if (iEntityModel != null && iEntityModel instanceof IPortModel && (iNodeModel = iNetCircuitEnd.getNodeModel()) != null && iNodeModel.provides(Feature.VCAT_LCAS)) {
            bl = ((IPortModel)iEntityModel).supportsSplitRouting();
        }
        return bl;
    }

    public boolean isSplitRoutingEnabled() {
        Object object;
        if (!this.isSplitRoutingAllowed()) {
            return false;
        }
        boolean bl = false;
        try {
            IEntityModel iEntityModel = this.getPrimarySource().getEntityModel();
            bl = iEntityModel.getEqType() == 144;
        }
        catch (Exception exception) {
            bl = false;
        }
        boolean bl2 = false;
        try {
            object = this.getPrimaryDrop().getEntityModel();
            bl2 = object.getEqType() == 144;
        }
        catch (Exception exception) {
            bl2 = false;
        }
        if (!bl && !bl2) {
            return true;
        }
        object = (NetVcatTermination)this.getVcatTermFromCktEnd(this.getPrimarySource());
        NetVcatTermination netVcatTermination = (NetVcatTermination)this.getVcatTermFromCktEnd(this.getPrimaryDrop());
        if (this.isOpenEndedVcatCircuit()) {
            if (object != null) {
                if (!bl) {
                    return true;
                }
                return ((NetVcatTermination)object).getExtBuffer();
            }
            if (netVcatTermination != null) {
                if (!bl2) {
                    return true;
                }
                return netVcatTermination.getExtBuffer();
            }
        } else if (object != null && netVcatTermination != null) {
            if (bl && !bl2) {
                return ((NetVcatTermination)object).getExtBuffer();
            }
            if (!bl && bl2) {
                return netVcatTermination.getExtBuffer();
            }
            return ((NetVcatTermination)object).getExtBuffer() && netVcatTermination.getExtBuffer();
        }
        return false;
    }

    public void setUpsrSelectorAttributes(IRevertiveBehavior iRevertiveBehavior, short s, short s2, boolean bl) {
        Iterator iterator = this.getNewMemberCkts().iterator();
        while (iterator.hasNext()) {
            ((NetCcatCircuit)iterator.next()).setUpsrSelectorAttributes(iRevertiveBehavior, s, s2, bl);
        }
    }

    public IHoUpsrAttributes getUpsrAttributes() {
        List list = this.getExistingMemberCkts();
        if (list.size() == 0) {
            return null;
        }
        NetCcatCircuit netCcatCircuit = (NetCcatCircuit)list.get(0);
        return netCcatCircuit.getUpsrAttributes();
    }

    public void setExtBuffer(boolean bl) {
        Iterator iterator = this.getAllVcatTerms().iterator();
        while (iterator.hasNext()) {
            ((NetVcatTermination)iterator.next()).setExtBuffer(bl);
        }
    }

    protected boolean isCommonFiberRouted(NetCcatCircuit netCcatCircuit, List list) {
        Iterator iterator = this.getExistingMemberCkts().iterator();
        while (iterator.hasNext()) {
            NetCcatCircuit netCcatCircuit2 = (NetCcatCircuit)iterator.next();
            if (netCcatCircuit2 == netCcatCircuit || this.shareCommonFiber(netCcatCircuit2, list)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int deriveServiceState() {
        if (this.dbgOn()) {
            this.debug("deriveServiceState(" + this.getCircuitName() + ", " + NetVcatCircuit.prettyString(this.circuitId) + ")");
        }
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        int n = 0;
        NetVcatCircuit netVcatCircuit = this;
        synchronized (netVcatCircuit) {
            if (this.getState() == 4 || this.getState() == 6) {
                return -1;
            }
            Iterator iterator = this.getAllMemberCircuits().iterator();
            while (iterator.hasNext()) {
                NetCcatCircuit netCcatCircuit = (NetCcatCircuit)iterator.next();
                int n2 = netCcatCircuit.getServiceState();
                if (n2 == -1) {
                    bl = false;
                    continue;
                }
                ++n;
                if (!netCcatCircuit.isMemberInGroup()) continue;
                bl3 = false;
                if (n2 == 0) {
                    bl2 = false;
                    continue;
                }
                bl = false;
            }
        }
        if (n == 0) {
            return -1;
        }
        if (bl3) {
            return 1;
        }
        if (bl) {
            return 0;
        }
        if (bl2) {
            return 1;
        }
        return 2;
    }

    protected String deriveDefaultName() {
        String string = this.srcNodeModel.getName();
        if (string.length() > 16) {
            string = string.substring(0, 15);
        }
        int n = this.circuitId.getUniquePart().getUniqueId();
        String string2 = this.getCircuitTypeObj().getProtocolIndepCktTypeShortStr() + "_" + string + (n != 0 ? "::" + n : "_TL1");
        return string2;
    }

    protected String getCircuitNameFromSrcNode() {
        String string = "";
        NetVcatTermination netVcatTermination = (NetVcatTermination)this.getVcatTermFromCktEnd(this.getPrimarySource());
        if (netVcatTermination != null && netVcatTermination.getNodeModel().provides(Feature.TCCU)) {
            string = netVcatTermination.getVcatName();
        }
        if (string.equals("")) {
            string = this.circuitInfoActive() ? this.circuitModel.getName() : "Unknown";
        }
        if (this.dbgOn()) {
            this.debug("getCircuitNameFromSrcNode() returns \"" + string + "\"");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean unify(NetVcatCircuit netVcatCircuit) {
        NetVcatCircuit netVcatCircuit2 = netVcatCircuit;
        synchronized (netVcatCircuit2) {
            NetCcatCircuit netCcatCircuit;
            NetVcatTermination netVcatTermination;
            if (this.dbgOn()) {
                db.println("Unify two VCAT circuits");
            }
            if (!(NetVcatCircuit.isNullCircuitId(this.circuitId) || NetVcatCircuit.isNullCircuitId(netVcatCircuit.circuitId) || this.circuitId.equals(netVcatCircuit.circuitId))) {
                if (this.dbgOn()) {
                    db.println("Cannot Unify two circuits with different circuit Ids");
                }
                return false;
            }
            Iterator iterator = netVcatCircuit.getAllVcatTerms().iterator();
            while (iterator.hasNext()) {
                netVcatTermination = (NetVcatTermination)iterator.next();
                netVcatTermination.setVcatCircuit(this);
            }
            iterator = netVcatCircuit.getAllMemberCircuits().iterator();
            while (iterator.hasNext()) {
                netCcatCircuit = (NetCcatCircuit)iterator.next();
                netCcatCircuit.setVcatGroup(this.forwardVcatGroup);
            }
            iterator = netVcatCircuit.getAllVcatTerms().iterator();
            while (iterator.hasNext()) {
                netVcatTermination = (NetVcatTermination)iterator.next();
                this.forwardVcatGroup.insertVcatTermination(netVcatTermination);
            }
            iterator = netVcatCircuit.getAllMemberCircuits().iterator();
            while (iterator.hasNext()) {
                netCcatCircuit = (NetCcatCircuit)iterator.next();
                this.forwardVcatGroup.insertMemberCircuit(netCcatCircuit);
            }
            netVcatCircuit.forwardVcatGroup.finalDispose();
            netVcatCircuit.finalDispose();
        }
        return true;
    }

    protected boolean circuitInfoActive() {
        return this.circuitInfoActive;
    }

    public boolean inRoll() {
        Iterator iterator = this.getAllMemberCircuits().iterator();
        while (iterator.hasNext()) {
            if (!((NetCcatCircuit)iterator.next()).inRoll()) continue;
            return true;
        }
        return false;
    }

    protected void runChildUpdate() {
        Iterator iterator = this.getAllVcatTerms().iterator();
        while (iterator.hasNext()) {
            try {
                ((NetVcatTermination)iterator.next()).runUpdate();
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                db.println("AbstractCmsIOException during vcat term update");
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
            }
        }
    }

    protected void notifyChanged() {
        Iterator iterator = this.ccat2VcatList.iterator();
        while (iterator.hasNext()) {
            ((NetCcatCircuit)iterator.next()).notifyChanged(false);
        }
        this.ccat2VcatList.clear();
        iterator = this.vcat2CcatList.iterator();
        while (iterator.hasNext()) {
            this.ncMgr.notifyChanged((NetCcatCircuit)iterator.next());
        }
        this.vcat2CcatList.clear();
        if (!this.isCircuitRefValid()) {
            return;
        }
        if (this.hasChanged()) {
            if (this.dbgOn()) {
                this.debug("notifyChanged(" + this.getCircuitName() + ", " + NetVcatCircuit.prettyString(this.circuitId) + ")");
            }
            int n = this.serviceState;
            this.serviceState = this.deriveServiceState();
            if (this.serviceState != n && this.dbgOn()) {
                this.debug("notifyChanged(): serviceState changed from " + this.translateServiceState(n) + " to " + this.translateServiceState(this.serviceState));
            }
            this.setProtType();
        }
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    protected void notifyDeleted() {
        if (this.dbgOn()) {
            this.debug("notifyDeleted(" + this.getCircuitName() + ", " + NetVcatCircuit.prettyString(this.circuitId) + ")");
        }
        this.setChanged();
        this.notifyObservers(ModelUpdateType.DELETED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobGroupFinished(JobGroup jobGroup) {
        Object object = this.threadWaitObject;
        synchronized (object) {
            this.deleteDone = true;
            this.threadWaitObject.notifyAll();
            JobController jobController = (JobController)jobGroup.getUserObject();
            if (jobController.isIdle()) {
                JobControllerFactory.disposeJC((JobController)jobController);
            }
        }
    }

    public int getMemberCktType() {
        int n = this.getCircuitType();
        if (n == 10) {
            return 1;
        }
        if (n == 12) {
            return 4;
        }
        if (n == 11) {
            return 2;
        }
        if (n == 13) {
            return 5;
        }
        return CircuitType.UNDEFINED_TYPE;
    }

    protected void printChild(SDebug sDebug) {
        if (!sDebug.on()) {
            return;
        }
        sDebug.println("");
        sDebug.println("Vcat Termination(s) :");
        Iterator iterator = this.getAllVcatTerms().iterator();
        while (iterator.hasNext()) {
            NetVcatTermination netVcatTermination = (NetVcatTermination)iterator.next();
            netVcatTermination.prettyPrint(sDebug);
            sDebug.println("");
        }
        sDebug.println("");
        sDebug.println("Member Circuit(s) :");
        iterator = this.getAllMemberCircuits().iterator();
        while (iterator.hasNext()) {
            sDebug.println("~~~~~~~~~~~~~~~~");
            NetCcatCircuit netCcatCircuit = (NetCcatCircuit)iterator.next();
            netCcatCircuit.prettyPrint(sDebug);
        }
    }

    protected void printDeconstructedConnections(SDebug sDebug) {
        if (!sDebug.on()) {
            return;
        }
        sDebug.println("");
        sDebug.println("Vcat Termination(s) :");
        Iterator iterator = this.getAllVcatTerms().iterator();
        while (iterator.hasNext()) {
            NetVcatTermination netVcatTermination = (NetVcatTermination)iterator.next();
            netVcatTermination.prettyPrint(sDebug);
            sDebug.println("");
        }
        sDebug.println("");
        sDebug.println("Vcat Member Circuit(s) :");
        iterator = this.getAllMemberCircuits().iterator();
        while (iterator.hasNext()) {
            sDebug.println("~~~~~~~~~~~~~~~~~~~~~~~~");
            NetCcatCircuit netCcatCircuit = (NetCcatCircuit)iterator.next();
            netCcatCircuit.printDeconstructedConnections(sDebug);
        }
    }

    public void addNetElement(INetElement iNetElement, RoutePrefs routePrefs) throws IncorrectCircuitState {
    }

    public void deleteNetElement(INetElement iNetElement) throws ObjNotFound, CannotDeleteLastDrop, IncorrectCircuitState, DeletionError, SanityCheckFailed {
    }

    public void routeNetElement(INetElement iNetElement, RoutePrefs routePrefs) throws SanityCheckFailed, IncorrectCircuitState, CTCUserException, AbstractCmsIOException {
    }

    public void routeNetElement(INetElement iNetElement, INetElement iNetElement2, RoutePrefs routePrefs) throws SanityCheckFailed, IncorrectCircuitState, CTCUserException, AbstractCmsIOException {
    }

    public boolean isVlanCapable() throws IncorrectCircuitState {
        return false;
    }

    public boolean mustDisableStp() throws IncorrectCircuitState {
        return false;
    }

    public IVlanModel[] getVlans() {
        return new IVlanModel[0];
    }

    public NetVlanInfo[] getNetVlans() {
        return new NetVlanInfo[0];
    }

    public void assignVlanSet(IVlanModel[] iVlanModelArray) throws IncorrectCircuitState, SanityCheckFailed {
    }

    public void assignVlanSet(NetVlanInfo[] netVlanInfoArray) throws IncorrectCircuitState, SanityCheckFailed {
    }

    public void createWithStpEnabled(boolean bl) {
    }

    public boolean isStpEnabled() {
        return false;
    }

    public INetLink getLotLink() {
        return null;
    }

    public INetLink getReverseLotLink() {
        return null;
    }

    public INetLink getLapLink() {
        return null;
    }

    public INetLink getReverseLapLink() {
        return null;
    }

    public List getXmCircuitEnds() {
        return new LinkedList();
    }

    public void setXmCircuitEnds(INetCircuitEnd[] iNetCircuitEndArray) {
    }

    public void setXmCircuitEnds(IEntityModel[] iEntityModelArray) {
    }

    public INetCircuit useLAP() {
        return null;
    }

    public List getLoTunnelNodes() {
        return new LinkedList();
    }

    public ILoNum getLoOverHo() {
        return null;
    }

    public INetCircuitNode getCircuitNodeFromNE(INetElement iNetElement) {
        return null;
    }

    public INetCircuitSpan getCircuitSpanFromNetLink(INetLink iNetLink) {
        return null;
    }

    public void addCircuitSpan(INetLinkSpan iNetLinkSpan) {
    }

    public void deleteCircuitSpan(INetLinkSpan iNetLinkSpan) {
    }

    public LinkedList getRequiredSpans() {
        return new LinkedList();
    }

    public List getActiveCircuitSpans() {
        return new LinkedList();
    }

    public List getRoutedCircuitSpans() {
        return new LinkedList();
    }

    public INetCircuitNode getSrcCircuitNode() {
        return null;
    }

    public int getCircuitSpanNum() {
        List list;
        if (this.getPhysicalRoutingPref() == 1 && !(list = this.getExistingMemberCkts()).isEmpty()) {
            return ((NetCcatCircuit)list.get(0)).getCircuitSpanNum();
        }
        return -1;
    }

    public boolean isMemberOfVcat() {
        return false;
    }

    public void setMemberPrefs(MemberPrefs memberPrefs) {
    }

    public int getMemberNumber() {
        return -1;
    }

    public void setMemberNumber(int n) {
    }

    public int getMemberStatus(INetCircuitEnd iNetCircuitEnd) {
        return -1;
    }

    public void setMemberStatus(INetCircuitEnd iNetCircuitEnd, int n) throws CTCUserException {
    }

    public String getFullCircuitName() {
        return null;
    }

    public boolean isMemberInGroup() {
        return false;
    }

    public boolean isUpsr1wayTl1() {
        return false;
    }

    public boolean useLink(INetLink iNetLink) {
        Iterator iterator = this.getAllMemberCircuits().iterator();
        while (iterator.hasNext()) {
            if (!((NetCcatCircuit)iterator.next()).useLink(iNetLink)) continue;
            return true;
        }
        return false;
    }

    public int[] memberDeleteCheck(INetCircuit[] iNetCircuitArray) {
        int[] nArray = null;
        int[] nArray2 = new int[iNetCircuitArray.length];
        int n = 0;
        int n2 = 0;
        if (this.dbgOn()) {
            this.debug("DEL: deleteCheck entered......");
        }
        for (n2 = 0; n2 < iNetCircuitArray.length; ++n2) {
            try {
                iNetCircuitArray[n2].circuitDeleteCheck();
                continue;
            }
            catch (IncorrectCircuitState incorrectCircuitState) {
                if (db.on()) {
                    db.println("Incorrect Circuit State");
                }
                nArray2[n++] = n2;
            }
        }
        if (n > 0) {
            nArray = new int[n];
            if (this.dbgOn()) {
                this.debug("DEL: invalid count is " + n);
            }
            for (n2 = 0; n2 < n; ++n2) {
                nArray[n2] = nArray2[n2];
                if (!this.dbgOn()) continue;
                this.debug("DEL: invalid index " + nArray[n2]);
            }
        }
        return nArray;
    }
}

