/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CannotDeleteLastDrop;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.ConfigError;
import cerent.cms.model.DetailedConfigError;
import cerent.cms.model.ICircuitModel;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.CircuitDropOutstanding;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.ConnTypeUnsupported;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.DualConnectionCircuitNode;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitEndFactory;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitNodeFactory;
import cerent.cms.ncp.OchTrailTunnelNode;
import cerent.cms.ncp.OchccCircuitNode;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.route.NoRoute;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.INetElement;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OchccCircuit
extends NetCcatCircuit {
    private static final SDebug db = new SDebug("OchccCircuit");
    private int specificSize;
    private ArrayList tunnelCircuits = new ArrayList();
    private CircuitCreatInfo.TrunkInfo srcTrunkInfo;
    private CircuitCreatInfo.TrunkInfo dropTrunkInfo;
    private IRevertiveBehavior srcReversion;
    private IRevertiveBehavior dropReversion;

    protected OchccCircuit(CircuitCreatInfo circuitCreatInfo) {
        super(circuitCreatInfo);
        this.specificSize = circuitCreatInfo.specificSize();
    }

    protected OchccCircuit(CircuitCreatInfo circuitCreatInfo, INetCircuitEnd iNetCircuitEnd, INetCircuitEnd iNetCircuitEnd2) {
        super(circuitCreatInfo, iNetCircuitEnd, iNetCircuitEnd2);
        this.specificSize = circuitCreatInfo.specificSize();
        Iterator iterator = this.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            OchccCircuitNode ochccCircuitNode = (OchccCircuitNode)iterator.next();
            ochccCircuitNode.updateSpecificSize(this.specificSize);
        }
    }

    protected OchccCircuit(CircuitCreatInfo circuitCreatInfo, INetElement iNetElement, Object object) {
        super(circuitCreatInfo, iNetElement, object);
        this.specificSize = circuitCreatInfo.specificSize();
        this.clearChanged();
    }

    protected OchccCircuit(CircuitCreatInfo circuitCreatInfo, INodeModel iNodeModel, ICircuitModel iCircuitModel) throws AbstractCmsObjectNotExistException {
        this(circuitCreatInfo);
        this.initState(4);
        this.addDiscoveredCircuitInfo(iNodeModel, iCircuitModel);
        this.clearChanged();
    }

    protected OchccCircuit(CircuitCreatInfo circuitCreatInfo, INetElement iNetElement) {
        this(circuitCreatInfo);
        NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createNodeDrop(circuitCreatInfo.type(), iNetElement);
        this.circuitInfo.setSrcPoint(netCircuitEnd.getCircuitEnd());
        this.insertSource(netCircuitEnd);
        NetCircuitDropInfo netCircuitDropInfo = new NetCircuitDropInfo(netCircuitEnd, 2);
        this.srcCircuitNode = NetCircuitNodeFactory.createCircuitNode(iNetElement, this);
        this.setSrcNodeModel(iNetElement.getNodeModel());
        this.insertCktNode(this.srcCircuitNode);
        this.srcCircuitNode.addDropInfo(netCircuitDropInfo);
    }

    public synchronized void routeNetElement(INetElement iNetElement, RoutePrefs routePrefs) throws SanityCheckFailed, IncorrectCircuitState, CTCUserException, AbstractCmsIOException {
        if (this.dbgOn()) {
            db.println("routeNetElement called for circuit " + this.getCircuitName() + ". NE = " + iNetElement.getName());
        }
        NetCircuitNode netCircuitNode = (NetCircuitNode)this.getCircuitNodeFromNE(iNetElement);
        this.addNetElement(iNetElement, routePrefs);
        if (netCircuitNode != null) {
            return;
        }
        try {
            this.routeCurrentDrop(iNetElement, routePrefs, true);
        }
        catch (NoRoute noRoute) {
            block7: {
                if (this.dbgOn()) {
                    db.println("routeCurrentDrop failed. deleting the net element");
                }
                try {
                    this.deleteNetElement(iNetElement);
                }
                catch (DeletionError deletionError) {
                    if (!this.dbgOn()) break block7;
                    db.println("unable to reverse as deleting routed drop encountered exception " + deletionError.getMessage());
                }
            }
            throw noRoute;
        }
    }

    public void provision() throws NoRoute, ConnTypeUnsupported, SanityCheckFailed, CircuitProvError, AnnotatedException {
        boolean bl = true;
        try {
            super.provision();
            bl = false;
        }
        catch (NoRoute noRoute) {
            throw noRoute;
        }
        catch (ConnTypeUnsupported connTypeUnsupported) {
            throw connTypeUnsupported;
        }
        catch (SanityCheckFailed sanityCheckFailed) {
            throw sanityCheckFailed;
        }
        catch (CircuitProvError circuitProvError) {
            throw circuitProvError;
        }
        catch (AnnotatedException annotatedException) {
            throw annotatedException;
        }
        finally {
            if (bl) {
                try {
                    this.restoreReversions();
                }
                catch (Exception exception) {
                    if (db.on()) {
                        db.println("Caught exception while restoring reversions: " + exception.getMessage());
                    }
                    SDebug.printStackTrace((Throwable)exception);
                }
                try {
                    this.restoreTrunkAttrs();
                }
                catch (Exception exception) {
                    if (db.on()) {
                        db.println("Caught exception while restoring trunk attrs: " + exception.getMessage());
                    }
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
    }

    public void destroyCircuit() throws IncorrectCircuitState, SanityCheckFailed, DeletionError {
        super.destroyCircuit();
        if (this.dbgOn()) {
            this.debug("OCHCC destroyCircuit: tunnel ckt size " + this.tunnelCircuits.size());
        }
        Iterator iterator = this.tunnelCircuits.iterator();
        while (iterator.hasNext()) {
            INetCircuit iNetCircuit = (INetCircuit)iterator.next();
            if (this.dbgOn()) {
                this.debug("OCHCC destroyCircuit: destroying (" + iNetCircuit.getCircuitName() + ", " + OchccCircuit.prettyString(iNetCircuit.getCircuitId()) + ")");
            }
            try {
                boolean bl;
                List list = iNetCircuit.getCircuitNodes();
                Iterator iterator2 = list.iterator();
                NetCircuitNode netCircuitNode = null;
                OchTrailTunnelNode ochTrailTunnelNode = null;
                boolean bl2 = bl = list.size() > 0;
                while (bl && iterator2.hasNext()) {
                    netCircuitNode = (NetCircuitNode)iterator2.next();
                    if (netCircuitNode instanceof OchTrailTunnelNode) {
                        ochTrailTunnelNode = (OchTrailTunnelNode)netCircuitNode;
                    } else {
                        if (!(netCircuitNode instanceof DualConnectionCircuitNode)) continue;
                        ochTrailTunnelNode = (OchTrailTunnelNode)((DualConnectionCircuitNode)netCircuitNode).getFstCircuitNode();
                    }
                    try {
                        if (ochTrailTunnelNode == null || !ochTrailTunnelNode.inUse()) continue;
                        if (this.dbgOn()) {
                            this.debug("OCHCC destroyCircuit: ochTrailAdit is in USE " + ochTrailTunnelNode.getName());
                        }
                        bl = false;
                    }
                    catch (AbstractCmsIOException abstractCmsIOException) {
                        if (!this.dbgOn()) continue;
                        this.debug("OCHCC destroyCircuit: the OchTrailAdit is no longer accessible.");
                    }
                }
                if (!bl) continue;
                if (this.dbgOn()) {
                    this.debug("OCHCC destroyCircuit: (" + iNetCircuit.getCircuitName() + ", " + OchccCircuit.prettyString(iNetCircuit.getCircuitId()) + " is being deleted");
                }
                iNetCircuit.destroyCircuit();
            }
            catch (IncorrectCircuitState incorrectCircuitState) {
                if (!this.dbgOn()) continue;
                this.debug("OCHCC destroyCircuit: (" + iNetCircuit.getCircuitName() + ", " + OchccCircuit.prettyString(iNetCircuit.getCircuitId()) + incorrectCircuitState);
            }
            catch (SanityCheckFailed sanityCheckFailed) {
                if (!this.dbgOn()) continue;
                this.debug("OCHCC destroyCircuit: (" + iNetCircuit.getCircuitName() + ", " + OchccCircuit.prettyString(iNetCircuit.getCircuitId()) + sanityCheckFailed);
            }
            catch (DeletionError deletionError) {
                if (!this.dbgOn()) continue;
                this.debug("OCHCC destroyCircuit: (" + iNetCircuit.getCircuitName() + ", " + OchccCircuit.prettyString(iNetCircuit.getCircuitId()) + deletionError);
            }
        }
    }

    public synchronized void addTunnelCircuit(INetCircuit iNetCircuit) {
        this.tunnelCircuits.add(iNetCircuit);
    }

    public synchronized void addNetElement(INetElement iNetElement, RoutePrefs routePrefs) throws IncorrectCircuitState {
        NetCircuitNode netCircuitNode;
        if (this.dbgOn()) {
            db.println("Adding a Network Element to circuit. NE = " + iNetElement.getName());
        }
        if (!this.isCircuitRefValid()) {
            throw new IncorrectCircuitState("Circuit already destroyed");
        }
        if (this.getState() != 1 && this.getState() != 0) {
            throw new IncorrectCircuitState("Circuit should have DISCOVERED or CREATING status when adding a Network Element");
        }
        if (this.getCircuitTypeObj().isOchccCircuitType() && this.getState() == 1) {
            throw new IncorrectCircuitState("Cannot add a Node to a DISCOVERED OchTrail Circuit");
        }
        if (routePrefs != null) {
            this.setMemberPrefs(routePrefs.getFwdDropPrefs().getFirstMemberGroupPrefs().getMemberPrefs());
        }
        if ((netCircuitNode = (NetCircuitNode)this.getCircuitNodeFromNE(iNetElement)) == null) {
            netCircuitNode = NetCircuitNodeFactory.createCircuitNode(iNetElement, this);
            this.insertCktNode(netCircuitNode);
        }
        NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createNodeDrop(this.getCircuitType(), iNetElement);
        NetCircuitDropInfo netCircuitDropInfo = new NetCircuitDropInfo(netCircuitEnd, 2);
        netCircuitNode.addDropInfo(netCircuitDropInfo);
        this.insertDrop(netCircuitDropInfo);
        if (this.getState() != 0) {
            this.setState(3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNetElement(INetElement iNetElement) throws ObjNotFound, CannotDeleteLastDrop, IncorrectCircuitState, DeletionError, SanityCheckFailed {
        if (this.dbgOn()) {
            db.println("Deleting Net Element from circuit. Node = " + iNetElement.getName());
        }
        OchccCircuit ochccCircuit = this;
        synchronized (ochccCircuit) {
            block10: {
                NetCircuitNode netCircuitNode = (NetCircuitNode)this.getCircuitNodeFromNE(iNetElement);
                if (netCircuitNode == null) {
                    if (this.dbgOn()) {
                        db.println("Warning! unable to find circuit node");
                    }
                    throw new ObjNotFound("Unable to find the Network Element");
                }
                if (netCircuitNode == this.srcCircuitNode) {
                    if (this.dbgOn()) {
                        db.println("Cannot delete source circuit node");
                    }
                    throw new SanityCheckFailed("Cannot delete Source circuit node");
                }
                NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createNodeDrop(this.getCircuitType(), iNetElement);
                try {
                    this.deleteDropCktEnd(netCircuitEnd);
                }
                catch (CircuitDropOutstanding circuitDropOutstanding) {
                    if (!this.dbgOn()) break block10;
                    db.println("deleteNetElement- circuit drop outstanding " + circuitDropOutstanding);
                }
            }
        }
        this.notifyChanged();
    }

    protected boolean validateCircuitTopology() {
        if (this.dbgOn()) {
            db.println("validateCircuitTopology: Circuit has " + this.getCktNodeListSize() + " nodes " + this.getDropsSize() + " drops " + this.getSourcesSize() + " sources");
        }
        if (this.getCircuitTypeObj().isOchccCircuitType()) {
            if (this.getCktNodeListSize() < 2 || this.getSourcesSize() != 1 || this.getDropsSize() != 1) {
                if (this.dbgOn()) {
                    db.println("Circuit has invalid nodes/drops/sources");
                }
                return false;
            }
            return true;
        }
        return super.validateCircuitTopology();
    }

    protected void getNodeLevelSourcesAndDrops(List list, List list2) {
        super.getNodeLevelSourcesAndDrops(list, list2);
        if (this.circuitInfoActive()) {
            return;
        }
        Iterator iterator = this.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            try {
                if (netCircuitNode.getPathList().size() != 1) continue;
                NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createNodeDrop(this.getCircuitType(), netCircuitNode.getNetElement());
                if (list.size() == 0) {
                    if (this.dbgOn()) {
                        db.println("OCHCC ITU TL1, Added node level source");
                    }
                    list.add(netCircuitEnd);
                    continue;
                }
                if (this.dbgOn()) {
                    db.println("OCHCC ITU TL1, Added node level drop");
                }
                list2.add(netCircuitEnd);
            }
            catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                if (!this.dbgOn()) continue;
                db.println("OchccCircuit.getNodeLevelSourcesAndDrops: circuit is being deleted");
            }
        }
    }

    public ICircuitSize getCircuitSizeObj() {
        return CircuitSize.SIZE_OCHCC;
    }

    public int getCircuitSize() {
        return CircuitSize.SIZE_OCHCC.value();
    }

    public int getSpecificSize() {
        if (this.specificSize == 0 && this.getSrcCircuitNode() != null) {
            this.specificSize = ((OchccCircuitNode)this.getCircuitNodes().get(0)).getPathWidth();
        }
        return this.specificSize;
    }

    public CircuitCreatInfo.TrunkInfo getSrcTrunkInfo() {
        return this.srcTrunkInfo;
    }

    public CircuitCreatInfo.TrunkInfo getDropTrunkInfo() {
        return this.dropTrunkInfo;
    }

    public void applyTrunkAttrs(IEntityModel iEntityModel, IEntityModel iEntityModel2, CircuitCreatInfo.TrunkInfo trunkInfo) throws NoSuchEquipment, DetailedConfigError, AbstractCmsNoSuchEntityException, NoSuchInterface, WrongInterfaceType, ConfigError, ObjNotFound {
        this.srcTrunkInfo = null;
        this.dropTrunkInfo = null;
        if (trunkInfo == null) {
            if (db.on()) {
                db.println("Cannot apply null trunk attrs");
            }
            return;
        }
        if (OchTrailHelper.isLineCard(iEntityModel) || OchTrailHelper.isLineCard(iEntityModel2)) {
            if (db.on()) {
                db.println("Cannot apply null trunk attrs to ITU-T line cards.");
            }
            return;
        }
        IEntityModel iEntityModel3 = OchTrailHelper.getWorkingTrunk(iEntityModel);
        IEntityModel iEntityModel4 = OchTrailHelper.getWorkingTrunk(iEntityModel2);
        boolean bl = OchTrailHelper.isTrunkInUse(iEntityModel3);
        boolean bl2 = OchTrailHelper.isTrunkInUse(iEntityModel4);
        if (db.on()) {
            db.println("Applying trunk attrs: isSrcInUse = " + bl + ", isDstInUse = " + bl2);
        }
        if (!bl) {
            this.srcTrunkInfo = OchTrailHelper.getTrunkAttrs(iEntityModel3);
            if (db.on()) {
                db.println("Stored src trunk attrs: " + this.srcTrunkInfo);
            }
            OchTrailHelper.setTrunkAttrs(trunkInfo, iEntityModel3);
        }
        if (!bl2) {
            this.dropTrunkInfo = OchTrailHelper.getTrunkAttrs(iEntityModel4);
            if (db.on()) {
                db.println("Stored dst trunk attrs: " + this.dropTrunkInfo);
            }
            OchTrailHelper.setTrunkAttrs(trunkInfo, iEntityModel4);
        }
        if (db.on()) {
            db.println("Applied trunk attrs: " + trunkInfo);
        }
    }

    public void restoreTrunkAttrs() throws Exception {
        Exception exception;
        block13: {
            IEntityModel iEntityModel;
            block12: {
                INetCircuitEnd iNetCircuitEnd = (INetCircuitEnd)this.getSources().get(0);
                INetCircuitEnd iNetCircuitEnd2 = (INetCircuitEnd)this.getDrops().get(0);
                IEntityModel iEntityModel2 = OchTrailHelper.getWorkingTrunk(iNetCircuitEnd.getEntityModel());
                iEntityModel = OchTrailHelper.getWorkingTrunk(iNetCircuitEnd2.getEntityModel());
                if (OchTrailHelper.isLineCard(iEntityModel2)) {
                    if (db.on()) {
                        db.println("Line Cards , Apply skipped.");
                    }
                    return;
                }
                exception = null;
                if (this.srcTrunkInfo != null) {
                    try {
                        if (db.on()) {
                            db.println("Restoring src trunk attrs: " + this.srcTrunkInfo);
                        }
                        OchTrailHelper.setTrunkAttrs(this.srcTrunkInfo, iEntityModel2);
                    }
                    catch (Exception exception2) {
                        exception = exception2;
                        if (!db.on()) break block12;
                        db.println("Got exception while restoring src trunk attrs: " + exception2.getMessage());
                    }
                }
            }
            if (this.dropTrunkInfo != null) {
                try {
                    if (db.on()) {
                        db.println("Restoring dst trunk attrs: " + this.dropTrunkInfo);
                    }
                    OchTrailHelper.setTrunkAttrs(this.dropTrunkInfo, iEntityModel);
                }
                catch (Exception exception3) {
                    exception = exception3;
                    if (!db.on()) break block13;
                    db.println("Got exception while restoring dst trunk attrs: " + exception3.getMessage());
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
        if (db.on()) {
            db.println("Restored trunk attrs");
        }
    }

    public IRevertiveBehavior getSrcReversion() {
        return this.srcReversion;
    }

    public IRevertiveBehavior getDropReversion() {
        return this.dropReversion;
    }

    public void applyReversions(IEntityModel iEntityModel, IEntityModel iEntityModel2, IRevertiveBehavior iRevertiveBehavior) throws AbstractCmsNoSuchEntityException, NoSuchEquipment, AbstractCmsNoSuchElementException, ObjNotFound {
        if (iRevertiveBehavior == null) {
            if (db.on()) {
                db.println("Cannot apply null reversions");
            }
            return;
        }
        if (OchTrailHelper.isProtected(iEntityModel) && OchTrailHelper.isProtected(iEntityModel2)) {
            INodeModel iNodeModel = iEntityModel.getNodeModel();
            INodeModel iNodeModel2 = iEntityModel2.getNodeModel();
            IEntityModel iEntityModel3 = OchTrailHelper.getWorkingTrunk(iEntityModel);
            IEntityModel iEntityModel4 = OchTrailHelper.getWorkingTrunk(iEntityModel2);
            this.srcReversion = OchTrailHelper.getReversion(iEntityModel3);
            this.dropReversion = OchTrailHelper.getReversion(iEntityModel4);
            if (db.on()) {
                db.println("Stored reversions: " + this.srcReversion + ", " + this.dropReversion);
            }
            OchTrailHelper.setReversion(iRevertiveBehavior, iEntityModel3);
            OchTrailHelper.setReversion(iRevertiveBehavior, iEntityModel4);
        } else {
            this.srcReversion = null;
            this.dropReversion = null;
        }
        if (db.on()) {
            db.println("Applied reversion: " + iRevertiveBehavior);
        }
    }

    public void restoreReversions() throws Exception {
        Exception exception;
        block11: {
            IEntityModel iEntityModel;
            INetCircuitEnd iNetCircuitEnd;
            block10: {
                INetCircuitEnd iNetCircuitEnd2 = (INetCircuitEnd)this.getSources().get(0);
                iNetCircuitEnd = (INetCircuitEnd)this.getDrops().get(0);
                exception = null;
                if (this.srcReversion != null) {
                    if (db.on()) {
                        db.println("Restoring src reversion: " + this.srcReversion);
                    }
                    try {
                        iEntityModel = OchTrailHelper.getWorkingTrunk(iNetCircuitEnd2.getEntityModel());
                        OchTrailHelper.setReversion(this.srcReversion, iEntityModel);
                    }
                    catch (Exception exception2) {
                        exception = exception2;
                        if (!db.on()) break block10;
                        db.println("Got exception while restoring src reversion: " + exception2.getMessage());
                    }
                }
            }
            if (this.dropReversion != null) {
                if (db.on()) {
                    db.println("Restoring dst reversion: " + this.dropReversion);
                }
                try {
                    iEntityModel = OchTrailHelper.getWorkingTrunk(iNetCircuitEnd.getEntityModel());
                    OchTrailHelper.setReversion(this.dropReversion, iEntityModel);
                }
                catch (Exception exception3) {
                    exception = exception3;
                    if (!db.on()) break block11;
                    db.println("Got exception while restoring dst reversion: " + exception3.getMessage());
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
        if (db.on()) {
            db.println("Restored original reversions");
        }
    }

    public int getProtType() {
        if (this.isSplitterProtected()) {
            return 8;
        }
        return 3;
    }

    public boolean isCircuitProtected() {
        return this.isSplitterProtected();
    }

    private boolean isSplitterProtected() {
        block3: {
            if (this.getSources().size() > 0) {
                INetCircuitEnd iNetCircuitEnd = (INetCircuitEnd)this.getSources().get(0);
                try {
                    return OchTrailHelper.isProtected(iNetCircuitEnd.getEntityModel());
                }
                catch (ObjNotFound objNotFound) {
                    if (!OchccCircuit.db.on) break block3;
                    db.println("Cannot get source port: " + objNotFound.getMessage());
                }
            }
        }
        return false;
    }
}

