/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AdminStateOpt;
import cerent.cms.model.Busy;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CircuitEnd;
import cerent.cms.model.CircuitId;
import cerent.cms.model.ConnCreateAttrs;
import cerent.cms.model.ConnectionTypeError;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IConnCreateAttrs;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IConnectionModels;
import cerent.cms.model.IConnectionType;
import cerent.cms.model.IOchncConnectionModel;
import cerent.cms.model.IOchncPathDefModel;
import cerent.cms.model.InvalidCircuitName;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.InvalidPortState;
import cerent.cms.model.InvalidState;
import cerent.cms.model.PathInUse;
import cerent.cms.model.WrongNumberOfPaths;
import cerent.cms.ncp.AdminStateProvisioningError;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.OchncCircuit;
import cerent.cms.ncp.OchncCircuitEnd;
import cerent.cms.ncp.OchncCircuitSpan;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ncp.TL1ObjectManager;
import cerent.cms.ncp.eSpanDirection;
import cerent.cms.topo.INetElement;
import cerent.util.EID;
import cerent.util.EnumStrings;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class OchncCircuitNode
extends NetCircuitNode {
    private static final SDebug db = new SDebug("OchncCircuitNode");
    private IOchncConnectionModel ochncConn;

    public OchncCircuitNode(INetElement iNetElement, OchncCircuit ochncCircuit) {
        super(iNetElement, ochncCircuit);
        this.connName = ochncCircuit.getCircuitName();
        this.cktId = new CircuitId(0, 0);
        this.serviceState = -2;
        this.pathWidth = (short)ochncCircuit.getCircuitSize();
    }

    public OchncCircuitNode(INetElement iNetElement, OchncCircuit ochncCircuit, Object object) {
        super(iNetElement, ochncCircuit, object);
        this.ne = iNetElement;
        this.connName = this.getConnNameFromNE();
        ochncCircuit.setChanged();
        this.pathWidth = (short)ochncCircuit.getCircuitSize();
    }

    protected void setAdminState(int n) {
        if (n == 0) {
            n = 3;
        }
        super.setAdminState(n);
    }

    protected void sanityCheckConnModel() {
        this.getConnTypeFromConnModel();
    }

    protected int getConnTypeFromConnModel() {
        IOchncConnectionModel iOchncConnectionModel = this.ochncConn;
        if (iOchncConnectionModel != null) {
            return iOchncConnectionModel.getConnectionType();
        }
        return 20;
    }

    protected Object[] getPathsFromConnModel() {
        IOchncConnectionModel iOchncConnectionModel = this.ochncConn;
        if (iOchncConnectionModel != null) {
            return iOchncConnectionModel.getPaths();
        }
        if (this.dbgOn()) {
            db.println("getPathsFromConnModel @ Node " + this.getName() + " with connection object deleted");
        }
        return new LinkedList().toArray();
    }

    public int totalSpans() {
        return this.inSpans.size() + this.outSpans.size() + this.biSpans.size();
    }

    protected void modifyConnection() throws CircuitProvError {
        if (this.dbgOn()) {
            db.println("modifyConnection @ Node " + this.getName());
        }
        this.modifyConnectionType();
        this.modifyConnectionDropsAndSpans();
        this.numberOfPaths = this.countNumInputs() + this.countNumOutputs() + this.countNumOmniSpans();
        this.setState(2);
    }

    protected void destroyCrossConnection() {
        if (this.ochncConn != null) {
            if (this.dbgOn()) {
                db.println("destroyOchncConnection(" + this.getName() + "): destroy ochncConn");
            }
            try {
                this.ochncConn.localDestroy();
            }
            catch (Busy busy) {
                if (this.dbgOn()) {
                    db.println("Unable to delete Ochnc connection - xBusy");
                }
                return;
            }
        }
        this.updateConnectionPathEnds(new LinkedList());
    }

    protected int findConnType() {
        if (this.circuit.getCircuitDir() == 1) {
            return 12;
        }
        return 0;
    }

    protected void createConnection() throws CircuitProvError {
        this.setConnectionType(this.findConnType());
        if (this.getConnectionType() == 20) {
            if (this.dbgOn()) {
                db.println("Warning! createConnection at " + this.getName() + " connection type is unknown");
            }
            throw new CircuitProvError("Invalid connection type at " + this.getName());
        }
        this.cktId = this.circuit.getCircuitId();
        this.connName = this.circuit.getCircuitName();
        if (this.dbgOn()) {
            this.debug("createConnection(" + this.getName() + ")" + "; connType=" + EnumStrings.getString((Class)IConnectionType.class, (int)this.getConnectionType()) + "; cktId=" + NetCcatCircuit.prettyString(this.cktId));
        }
        ICircuitType iCircuitType = this.circuit.getCircuitTypeObj();
        try {
            this.createConnection(this.cktId);
        }
        catch (CTCUserException cTCUserException) {
            if (this.dbgOn()) {
                db.println("Exception while creating connection at " + this.getName());
                SDebug.printStackTrace((Throwable)cTCUserException);
            }
            String string = "Unable to create connection at " + this.getName();
            if (cTCUserException instanceof PathInUse) {
                string = string + "\nPath already in use";
            } else if (cTCUserException instanceof InvalidPortState) {
                string = string + "\nAt least one of the involved ports is in maintenance state";
            }
            throw new CircuitProvError(string);
        }
        catch (AdminStateProvisioningError adminStateProvisioningError) {
            if (this.dbgOn()) {
                db.println("Exception while creating connection at " + this.getName());
                SDebug.printStackTrace((Throwable)adminStateProvisioningError);
            }
            String string = "Unable to create connection at " + this.getName();
            string = string + "\n" + adminStateProvisioningError.getMessage();
            throw new CircuitProvError(string);
        }
        if (this.ochncConn == null) {
            if (this.dbgOn()) {
                db.println("Connection Models returned NULL connection ");
            }
            throw new CircuitProvError(ErrorMsg.getString((EID)NEMC.EID_ERROR_CONNECTION_OBJECT_PARAM_1, (Object)this.getName()) + this.getName());
        }
        this.addConnectionObserver();
        this.setState(1);
        this.setCreateStage(3);
        this.numberOfPaths = this.countNumInputs() + this.countNumOutputs() + this.countNumOmniSpans() + (this.isDstCoLocatedCktNode() || this.isSrcCoLocatedCktNode() ? 2 : 0);
        this.updateConnectionPathEnds(this.getPathEndsFromPathDefs(this.getConnectionPathDefs()));
    }

    protected String prettyString(IOchncPathDefModel iOchncPathDefModel) {
        return this.getName() + "::" + Integer.toHexString(iOchncPathDefModel.getPortEntityIdx()) + "::" + iOchncPathDefModel.getOptChannel();
    }

    protected void prettyPrint(IOchncPathDefModel[] iOchncPathDefModelArray, String string) {
        for (int i = 0; i < iOchncPathDefModelArray.length; ++i) {
            if (!this.dbgOn()) continue;
            this.debug(string + " OchncPath #" + i + " " + this.prettyString(iOchncPathDefModelArray[i]));
        }
    }

    protected void createConn(ICircuitId iCircuitId, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, int n, int n2, ArrayList arrayList4, ArrayList arrayList5) throws PathInUse, InvalidPath, InvalidState, InvalidCircuitName, ConnectionTypeError, WrongNumberOfPaths, InvalidPortState, CTCUserException {
        this.prettyPrint(arrayList.toArray(new IOchncPathDefModel[0]), "input");
        this.prettyPrint(arrayList2.toArray(new IOchncPathDefModel[0]), "output");
        IOchncPathDefModel[][] iOchncPathDefModelArrayArray = new IOchncPathDefModel[][]{arrayList.toArray(new IOchncPathDefModel[0]), arrayList2.toArray(new IOchncPathDefModel[0])};
        this.ochncConn = this.createOchncConnOnNE(iCircuitId, iOchncPathDefModelArrayArray);
        if (this.ochncConn == null) {
            return;
        }
        if (this.circuit.getVlans().length == 0) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IOchncConnectionModel createOchncConnOnNE(ICircuitId iCircuitId, IOchncPathDefModel[][] iOchncPathDefModelArray) throws PathInUse, InvalidPath, InvalidState, InvalidCircuitName, ConnectionTypeError, WrongNumberOfPaths, InvalidPortState, CTCUserException {
        IOchncPathDefModel[] iOchncPathDefModelArray2 = iOchncPathDefModelArray[0];
        IOchncPathDefModel[] iOchncPathDefModelArray3 = iOchncPathDefModelArray[1];
        IOchncPathDefModel[] iOchncPathDefModelArray4 = null;
        AdminStateOpt adminStateOpt = new AdminStateOpt();
        adminStateOpt.setAdminState(this.getAdminState());
        ConnCreateAttrs connCreateAttrs = new ConnCreateAttrs();
        connCreateAttrs.setCktName(this.connName);
        connCreateAttrs.setAdminStateOpt(adminStateOpt);
        IConnectionModels iConnectionModels = this.getNodeModel().getConnectionModels();
        if (this.dbgOn()) {
            db.println("createOchncConnOnNE:connType=" + EnumStrings.getString((Class)IConnectionType.class, (int)this.getConnectionType()));
        }
        Map map = TL1ObjectManager.instance().getTL1Conns();
        synchronized (map) {
            if (this.getConnectionType() == 0) {
                iOchncPathDefModelArray4 = new IOchncPathDefModel[]{iOchncPathDefModelArray2[0], iOchncPathDefModelArray3[0]};
                this.ochncConn = iConnectionModels.createOchncConnection(iCircuitId, 0, iOchncPathDefModelArray4, (IConnCreateAttrs)connCreateAttrs);
            } else if (this.getConnectionType() == 12) {
                iOchncPathDefModelArray4 = new IOchncPathDefModel[]{iOchncPathDefModelArray2[0], iOchncPathDefModelArray2[1], iOchncPathDefModelArray3[0], iOchncPathDefModelArray3[1]};
                this.ochncConn = iConnectionModels.createOchncConnection(iCircuitId, 12, iOchncPathDefModelArray4, (IConnCreateAttrs)connCreateAttrs);
            } else {
                if (this.dbgOn()) {
                    db.println("Circuit Node: createOchncConnection Unknown connection type " + this.getConnectionType());
                }
                return null;
            }
            if (NetCcatCircuit.isNullCircuitId(iCircuitId) && this.ochncConn != null) {
                this.registerNullCircuitConnection(this.getNetElement(), this.ochncConn);
            }
        }
        return this.ochncConn;
    }

    protected void destroySanityCheck() throws SanityCheckFailed {
        if (this.dbgOn()) {
            db.println("destroy sanity check at " + this.getName());
        }
        if (!this.hasConnection()) {
            return;
        }
    }

    protected void deleteNodeDrop() throws DeletionError {
        if (this.dbgOn()) {
            db.println("deleteNodeDrop at Node " + this.getName());
        }
        if (this.biSpans.size() == 1) {
            this.destroyCrossConnection();
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)this.biSpans.getFirst();
            if (this.findRoutingDir(netCircuitSpan) == eSpanDirection.TERMINATING) {
                netCircuitSpan.setDstState(0);
            } else {
                netCircuitSpan.setSrcState(0);
            }
            NetCircuitNode netCircuitNode = this.spanGetPeer(netCircuitSpan);
            netCircuitNode.deleteBiSpan(netCircuitSpan);
            this.biSpans.remove(netCircuitSpan);
        } else if (this.biSpans.size() == 2) {
            try {
                if (this.dbgOn()) {
                    db.println("changing the intended type to 2 way");
                }
                this.setConnTypeInConnModel(1);
                this.setConnectionType(1);
            }
            catch (CTCUserException cTCUserException) {
                if (this.dbgOn()) {
                    db.println("Unable to change intended type");
                }
            }
        } else if (this.dbgOn()) {
            db.println("deleteNodeDrop: invalid conn. type");
        }
        this.nodeDrop = null;
    }

    protected void deleteDrop(INetCircuitEnd iNetCircuitEnd) throws DeletionError, SanityCheckFailed {
        if (this.dbgOn()) {
            db.println("Deleting drop: ckt. node: " + this.getName());
        }
        super.deleteDrop(iNetCircuitEnd);
    }

    public void setConnectionCircuitId(ICircuitId iCircuitId) {
        if (this.dbgOn()) {
            db.println("setting the connection circuit Id at " + this.getName() + " to " + NetCircuit.prettyString(iCircuitId));
        }
        ICircuitId iCircuitId2 = this.getConnectionCircuitId();
        if (this.ochncConn != null) {
            this.ochncConn.setCircuitId(iCircuitId);
            this.cktId = iCircuitId;
            if (iCircuitId2 == null || iCircuitId2.getNodeId() == 0 && iCircuitId2.getUniquePart().getUniqueId() == 0) {
                this.deregisterNullCircuitConnection(this.getNetElement(), this.ochncConn);
            }
        }
    }

    public NetCircuitEnd getSpanEndpoint(NetCircuitSpan netCircuitSpan) {
        CircuitEnd circuitEnd = new CircuitEnd();
        circuitEnd.setNodeId(this.ne.getNodeId());
        circuitEnd.setPortNum(netCircuitSpan.getEntityIndex(this.ne));
        circuitEnd.setDropProt(false);
        return new OchncCircuitEnd(this.ne.getNodeModel(), circuitEnd, ((OchncCircuitSpan)netCircuitSpan).getOptChannel());
    }

    public ICircuitId getConnectionCircuitId() {
        if (this.ochncConn != null) {
            return this.ochncConn.getCircuitId();
        }
        if (this.dbgOn()) {
            db.println("getConnectionCircuitId @ Node " + this.getName() + " with connection object deleted");
        }
        return null;
    }

    protected boolean isSrcCoLocatedCktNode() {
        return !this.circuit.getSrcInternalSpliceLinkEnds().isEmpty() && ((NetCircuitEnd)this.circuit.getSrcInternalSpliceLinkEnds().get(0)).getNodeId() == this.getNodeModel().getNodeId();
    }

    protected boolean isDstCoLocatedCktNode() {
        return !this.circuit.getDstInternalSpliceLinkEnds().isEmpty() && ((NetCircuitEnd)this.circuit.getDstInternalSpliceLinkEnds().get(0)).getNodeId() == this.getNodeModel().getNodeId();
    }

    protected List getSrcCoLocatedCktEnds() {
        LinkedList linkedList = new LinkedList();
        if (!this.circuit.getSrcInternalSpliceLinkEnds().isEmpty()) {
            linkedList.add(this.circuit.getSrcInternalSpliceLinkEnds().get(1));
            linkedList.add(this.circuit.getSrcInternalSpliceLinkEnds().get(2));
        }
        return linkedList;
    }

    protected List getDstCoLocatedCktEnds() {
        LinkedList linkedList = new LinkedList();
        if (!this.circuit.getDstInternalSpliceLinkEnds().isEmpty()) {
            linkedList.add(this.circuit.getDstInternalSpliceLinkEnds().get(1));
            linkedList.add(this.circuit.getDstInternalSpliceLinkEnds().get(2));
        }
        return linkedList;
    }

    public IConnectionModel getConn() {
        return this.ochncConn;
    }

    protected void setConn(IConnectionModel iConnectionModel) {
        this.ochncConn = (IOchncConnectionModel)iConnectionModel;
    }

    protected boolean dbgOn() {
        return db.on() || super.dbgOn();
    }

    private void debug(String string) {
        db.println(string);
    }

    protected Object[] getActivePathsFromConnModel() {
        if (this.dbgOn()) {
            db.println("OchncCircuitNode -> getActivePathsFromConnModel @ Node " + this.getName());
        }
        return null;
    }

    protected int getProtectionOpFromConnModel() {
        if (this.dbgOn()) {
            db.println("OchncCircuitNode -> getProtectionOpFromConnModel @ Node " + this.getName());
        }
        return -1;
    }

    protected int getReverseProtectionOpFromConnModel() {
        if (this.dbgOn()) {
            db.println("OchncCircuitNode -> getReverseProtectionOpFromConnModel @ Node " + this.getName());
        }
        return -1;
    }
}

