/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.IPathDefModel;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.OchncPathDefModel;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.topo.INetElement;
import cerent.util.SDebug;

public class OchncCircuitSpan
extends NetCircuitSpan {
    private static final SDebug db = new SDebug("OchncCircuitSpan");
    private int optChannel;
    private int srcEntityIndex;
    private int dstEntityIndex;

    public OchncCircuitSpan(NetCcatCircuit netCcatCircuit, NetLinkSpan netLinkSpan) {
        super(netCcatCircuit, netLinkSpan);
        this.optChannel = netCcatCircuit.getCircuitOptChannel();
        this.srcEntityIndex = netLinkSpan.getLink().getSrcEntityIndex();
        this.dstEntityIndex = netLinkSpan.getLink().getDstEntityIndex();
        if (this.dbgOn()) {
            db.println("OchncCircuitSpan object instantiated");
        }
    }

    protected int getOptChannel() {
        return this.optChannel;
    }

    public int getEntityIndex(INetElement iNetElement) {
        if (this.getLink() == null) {
            return -1;
        }
        if (iNetElement == this.getLink().getSrc()) {
            return this.srcEntityIndex;
        }
        return this.dstEntityIndex;
    }

    protected IPathDefModel getPathDef(INetElement iNetElement, short s) throws ObjNotFound {
        if (this.dbgOn()) {
            db.println("getPathDef: optChannel " + this.optChannel + " EntIdx " + Integer.toHexString(this.getEntityIndex(iNetElement)));
        }
        OchncPathDefModel ochncPathDefModel = new OchncPathDefModel(iNetElement.getNodeModel(), this.optChannel, this.getEntityIndex(iNetElement), s);
        return ochncPathDefModel;
    }

    private boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    private void debug(String string) {
        db.println(string);
    }
}

