/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.IOchccPathDefModel;
import cerent.cms.model.IOchncPathDefModel;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.OchTrailTunnelNode;
import cerent.cms.ncp.OchccCircuitNode;
import cerent.cms.ncp.OchncCircuitNode;
import cerent.util.HoLoComparator;
import cerent.util.IHoNum;
import cerent.util.ILoNum;

class SpliceListener {
    public IHoNum hoNum;
    public ILoNum loNum;
    public NetCircuitNode node;
    public boolean loAdit;
    private static final HoLoComparator holoComp = HoLoComparator.instance();
    public int optChannel = 0;

    public SpliceListener(IHoNum iHoNum, ILoNum iLoNum, NetCircuitNode netCircuitNode, boolean bl) {
        this.hoNum = iHoNum;
        this.loNum = iLoNum;
        this.node = netCircuitNode;
        this.loAdit = bl;
        if (netCircuitNode instanceof OchncCircuitNode || netCircuitNode instanceof OchTrailTunnelNode) {
            try {
                IOchncPathDefModel iOchncPathDefModel = (IOchncPathDefModel)netCircuitNode.getConnectionPathDefs()[0];
                this.optChannel = iOchncPathDefModel.getOptChannel();
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                this.optChannel = 0;
            }
        } else if (netCircuitNode instanceof OchccCircuitNode) {
            try {
                IOchccPathDefModel iOchccPathDefModel = (IOchccPathDefModel)netCircuitNode.getConnectionPathDefs()[0];
                if (iOchccPathDefModel.getOchTrailAdit() != null) {
                    this.optChannel = iOchccPathDefModel.getOchTrailAdit().getOptChannel();
                }
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                this.optChannel = 0;
            }
        }
    }

    String prettyString() {
        return "HO " + this.hoNum + "::LO " + this.loNum + (this.loAdit ? "::loAdit" : "") + (this.optChannel != 0 ? "::OCH " + this.optChannel : "");
    }

    public boolean equals(Object object) {
        if (object instanceof SpliceListener) {
            SpliceListener spliceListener = (SpliceListener)object;
            if (spliceListener.node != null && this.node != null && !spliceListener.node.equals(this.node)) {
                return false;
            }
            if (!holoComp.isEqual(spliceListener.hoNum, this.hoNum)) {
                return false;
            }
            if (!holoComp.isEqual(spliceListener.loNum, this.loNum)) {
                return false;
            }
            return spliceListener.loAdit == this.loAdit;
        }
        return false;
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + (this.node == null ? 0 : this.node.hashCode());
        n = 37 * n + (this.hoNum == null ? 0 : this.hoNum.hashCode());
        n = 37 * n + (this.loNum == null ? 0 : this.loNum.hashCode());
        n = 37 * n + (this.loAdit ? 1 : 0);
        return n;
    }
}

