/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IHoConnectionModel;
import cerent.cms.model.IHoVcatTermModel;
import cerent.cms.model.ILoConnectionModel;
import cerent.cms.model.ILoVcatTermModel;
import cerent.cms.model.IOchccConnectionModel;
import cerent.cms.model.IOchncConnectionModel;
import cerent.cms.model.IVcatTermModel;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.topo.INetElement;
import cerent.util.ComparisonUtil;
import cerent.util.SDebug;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

public class TL1ObjectManager {
    private static final SDebug db = new SDebug("TL1ObjectManager");
    private static TL1ObjectManager manager;
    private Map TL1Conns = new TreeMap(new TL1ObjectIdComparator());
    private Map TL1VcatTerms = new TreeMap(new TL1ObjectIdComparator());

    public static synchronized TL1ObjectManager instance() {
        if (manager == null) {
            if (TL1ObjectManager.dbgOn()) {
                TL1ObjectManager.debug("Creating a TL1 Object Manager");
            }
            manager = new TL1ObjectManager();
        }
        return manager;
    }

    private TL1ObjectManager() {
    }

    public Map getTL1Conns() {
        return this.TL1Conns;
    }

    public Map getTL1VcatTerms() {
        return this.TL1VcatTerms;
    }

    private int getObjIndex(Object object) {
        if (object instanceof IConnectionModel) {
            return ((IConnectionModel)object).getIndex();
        }
        if (object instanceof IVcatTermModel) {
            return ((IVcatTermModel)object).getIndex();
        }
        return 0;
    }

    private int getObjType(Object object) {
        if (object instanceof IHoConnectionModel) {
            return 1;
        }
        if (object instanceof ILoConnectionModel) {
            return 2;
        }
        if (object instanceof IHoVcatTermModel) {
            return 3;
        }
        if (object instanceof ILoVcatTermModel) {
            return 4;
        }
        if (object instanceof IOchncConnectionModel) {
            return 5;
        }
        if (object instanceof IOchccConnectionModel) {
            return 6;
        }
        return 0;
    }

    private TL1ObjectId createTL1ObjectId(INetElement iNetElement, Object object) {
        return new TL1ObjectId(iNetElement.getNodeId(), this.getObjIndex(object), this.getObjType(object));
    }

    private Map getTL1ObjectMap(Object object) {
        if (object instanceof IConnectionModel) {
            return this.TL1Conns;
        }
        if (object instanceof IVcatTermModel) {
            return this.TL1VcatTerms;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTL1Object(INetElement iNetElement, Object object, Object object2) {
        TL1ObjectId tL1ObjectId = this.createTL1ObjectId(iNetElement, object);
        Map map = this.getTL1ObjectMap(object);
        if (map == null) {
            return;
        }
        Map map2 = map;
        synchronized (map2) {
            if (TL1ObjectManager.dbgOn()) {
                TL1ObjectManager.debug("registerTL1Object(" + iNetElement.getName() + ")");
            }
            map.put(tL1ObjectId, object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterTL1Object(INetElement iNetElement, Object object) {
        TL1ObjectId tL1ObjectId = this.createTL1ObjectId(iNetElement, object);
        Map map = this.getTL1ObjectMap(object);
        if (map == null) {
            return;
        }
        Map map2 = map;
        synchronized (map2) {
            if (TL1ObjectManager.dbgOn()) {
                TL1ObjectManager.debug("deregisterTL1Object(" + iNetElement.getName() + ")");
            }
            map.remove(tL1ObjectId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasTL1Object(INetElement iNetElement, Object object) {
        TL1ObjectId tL1ObjectId = this.createTL1ObjectId(iNetElement, object);
        Map map = this.getTL1ObjectMap(object);
        if (map == null) {
            return false;
        }
        Map map2 = map;
        synchronized (map2) {
            return map.containsKey(tL1ObjectId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getTL1Object(INetElement iNetElement, Object object) {
        TL1ObjectId tL1ObjectId = this.createTL1ObjectId(iNetElement, object);
        Map map = this.getTL1ObjectMap(object);
        if (map == null) {
            return null;
        }
        Map map2 = map;
        synchronized (map2) {
            return map.get(tL1ObjectId);
        }
    }

    private static boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    private static void debug(String string) {
        db.println(string);
    }

    private class TL1ObjectIdComparator
    implements Comparator {
        private TL1ObjectIdComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object == null || object2 == null) {
                return -1;
            }
            TL1ObjectId tL1ObjectId = (TL1ObjectId)object;
            TL1ObjectId tL1ObjectId2 = (TL1ObjectId)object2;
            if (tL1ObjectId.nodeId != tL1ObjectId2.nodeId) {
                return ComparisonUtil.compare((int)tL1ObjectId.nodeId, (int)tL1ObjectId2.nodeId);
            }
            if (tL1ObjectId.objIndex != tL1ObjectId2.objIndex) {
                return ComparisonUtil.compare((int)tL1ObjectId.objIndex, (int)tL1ObjectId2.objIndex);
            }
            if (tL1ObjectId.objType != tL1ObjectId2.objType) {
                return ComparisonUtil.compare((int)tL1ObjectId.objType, (int)tL1ObjectId2.objType);
            }
            return 0;
        }
    }

    private class TL1ObjectId {
        private int nodeId;
        private int objIndex;
        private int objType;

        public TL1ObjectId(int n, int n2, int n3) {
            this.nodeId = n;
            this.objIndex = n2;
            this.objType = n3;
        }
    }
}

