/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.AllocFailed;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CircuitMergeManager;
import cerent.cms.model.CircuitType;
import cerent.cms.model.Feature;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IConnCreateAttrs;
import cerent.cms.model.IConnectionConversionModel;
import cerent.cms.model.IConnectionType;
import cerent.cms.model.IPathDefModel;
import cerent.cms.model.ISelectorAttrsOpt;
import cerent.cms.model.InServiceUpgradeState;
import cerent.cms.model.NoMoreLoCapableHo;
import cerent.cms.model.NoMoreVtCapableSts;
import cerent.cms.model.ObjDuplicate;
import cerent.cms.model.PathInUse;
import cerent.cms.model.PathListIncomplete;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.CircuitDropOutstanding;
import cerent.cms.ncp.CircuitMergeError;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.ConnTypeUnsupported;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.InServiceUpgradeError;
import cerent.cms.ncp.InServiceUpgradeMgr;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitFactory;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitPath;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.PortGrouping;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ncp.eSpanDirection;
import cerent.cms.route.CircuitPath;
import cerent.cms.route.INetLinkSpan;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.route.NoRoute;
import cerent.cms.route.PathSegment;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.util.AnnotatedException;
import cerent.util.EnumStrings;
import cerent.util.IAsyncObserver;
import cerent.util.SDebug;
import cerent.util.job.JobStatus;
import cerent.util.threadpool.IActionClient;
import cerent.util.threadpool.IThreadWorker;
import cerent.util.threadpool.ThreadPool;
import java.util.AbstractCollection;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Unprot2UpsrInServiceUpgradeMgr
extends InServiceUpgradeMgr {
    private NetCcatCircuit cktInUpgrade = null;
    private RoutePrefs prefs;
    private List allCktLinks;
    private List allCktNetElems;
    private List newLinkSpans;
    private int newCktCounter = 0;
    private InServiceUpgradeState state;
    private INetElement srcNetElem;
    private INetElement dstNetElem;
    private NetCircuitNode masterNode;
    private boolean autoRoute = true;
    private boolean goReturnTrafficDir;
    private List activeCktSpans;
    private List routedCktSpans;
    private Map connCreators = Collections.synchronizedMap(new TreeMap());
    private Map connConverters = Collections.synchronizedMap(new TreeMap());
    private UpgradeActionClient upgradeActionClient = null;
    private IAsyncObserver asyncObserver = null;
    private IConnCreateAttrs connAttrs;
    private boolean disposed = false;
    private String UPSR_TERM;

    public Unprot2UpsrInServiceUpgradeMgr() {
        this.allCktLinks = Collections.synchronizedList(new LinkedList());
        this.allCktNetElems = Collections.synchronizedList(new LinkedList());
        this.newLinkSpans = Collections.synchronizedList(new LinkedList());
        this.activeCktSpans = Collections.synchronizedList(new LinkedList());
        this.routedCktSpans = Collections.synchronizedList(new LinkedList());
        this.upgradeActionClient = new UpgradeActionClient();
        Unprot2UpsrInServiceUpgradeMgr.debug("Unprot2UpsrInServiceUpgradeMgr: default constructor called");
    }

    public Unprot2UpsrInServiceUpgradeMgr(INetCircuit iNetCircuit, RoutePrefs routePrefs, boolean bl, boolean bl2, IConnCreateAttrs iConnCreateAttrs, IAsyncObserver iAsyncObserver) throws InServiceUpgradeError {
        this();
        this.setCktInUpgrade(iNetCircuit);
        this.prefs = routePrefs;
        this.autoRoute = bl;
        this.goReturnTrafficDir = bl2;
        this.connAttrs = iConnCreateAttrs;
        this.asyncObserver = iAsyncObserver;
        this.cktInUpgrade.setMemberPrefs(routePrefs.getFwdDropPrefs().getFirstMemberGroupPrefs().getMemberPrefs());
        if (dbg.on()) {
            Unprot2UpsrInServiceUpgradeMgr.debug("Unprot2UpsrInServiceUpgradeMgr Created");
            Unprot2UpsrInServiceUpgradeMgr.debug(routePrefs.prettyString());
            Unprot2UpsrInServiceUpgradeMgr.debug("ISTU Routing Pref: " + (bl ? "Automatic Routing" : "Manual Routing"));
            Unprot2UpsrInServiceUpgradeMgr.debug("ISTU Routing Dir: " + (bl2 ? "Go and Return" : "Unidirectional"));
        }
        this.srcNetElem = iNetCircuit.getSrcCircuitNode().getNetElement();
        this.dstNetElem = ((NetCircuitDropInfo)iNetCircuit.getDrops().get(0)).getNetElement();
        this.masterNode = (NetCircuitNode)iNetCircuit.getSrcCircuitNode();
        if (this.cktInUpgrade.getCircuitType() == 3 || this.cktInUpgrade.getCircuitType() == 6) {
            this.cktInUpgrade.setPathProtForDrops(false);
        } else {
            this.cktInUpgrade.setPathProtForDrops(true);
        }
        this.cktInUpgrade.setCktOperation(5);
    }

    public void setGoReturnTrafficDir(boolean bl) {
        this.goReturnTrafficDir = bl;
    }

    public void setAutoRoute(boolean bl) {
        this.autoRoute = bl;
    }

    public int getInServiceUpgradeOp() {
        return 0;
    }

    public void setCktInUpgrade(INetCircuit iNetCircuit) {
        this.cktInUpgrade = (NetCcatCircuit)iNetCircuit;
    }

    public Collection calculateAlternatePath() throws InServiceUpgradeError {
        Object object;
        Object object2;
        RoutePrefs routePrefs;
        LinkedList linkedList = new LinkedList();
        if (this.cktInUpgrade.getCircuitType() == 3 || this.cktInUpgrade.getCircuitType() == 6) {
            if (dbg.on()) {
                dbg.println("calculateAlternatePath: for LO TUNNEL circuit");
            }
            routePrefs = this.computeLOTRoutePrefs(new LinkedList());
        } else {
            if (dbg.on()) {
                dbg.println("calculateAlternatePath: for HO/LO circuit");
            }
            object2 = this.getOrderedCircuitNetLinks();
            object = this.getNetLinkSpansFromNetCircuitSpans(this.cktInUpgrade.getCircuitSpans());
            routePrefs = this.computeRoutePrefs(this.srcNetElem, this.dstNetElem, (List)object, (List)object2, new LinkedList(), new LinkedList());
        }
        object2 = new NetCircuitPath(routePrefs, null);
        object = null;
        try {
            object = ((NetCircuitPath)object2).computeCircuitPath();
        }
        catch (NoRoute noRoute) {
            if (dbg.on()) {
                Unprot2UpsrInServiceUpgradeMgr.debug("calculateAlternatePath: Alternate path not found => " + noRoute.getMessage());
                SDebug.printStackTrace((Throwable)((Object)noRoute));
            }
            this.cancelUpgrade();
            throw new InServiceUpgradeError(noRoute.getMessage());
        }
        catch (AllocFailed allocFailed) {
            if (dbg.on()) {
                Unprot2UpsrInServiceUpgradeMgr.debug("calculateAlternatePath: Alternate path not found => " + allocFailed.getMessage());
                SDebug.printStackTrace((Throwable)((Object)allocFailed));
            }
            throw new InServiceUpgradeError(allocFailed.getMessage());
        }
        linkedList.addAll(((CircuitPath)object).getPathSegments());
        return this.getAlternateLinkSpans(linkedList);
    }

    private void upgradeLoTunnel(List list) throws InServiceUpgradeError {
        if (dbg.on()) {
            Unprot2UpsrInServiceUpgradeMgr.debug("upgradeLoTunnel: creating new LO Tunnel");
        }
        this.setCircuitSpans();
        this.setCircuitNodes();
        RoutePrefs routePrefs = this.computeLOTRoutePrefs(list);
        CircuitCreatInfo circuitCreatInfo = this.createCircuitCreateInfo();
        try {
            NetCcatCircuit netCcatCircuit = (NetCcatCircuit)NetCircuitFactory.newCircuit(circuitCreatInfo, this.srcNetElem);
            netCcatCircuit.routeNetElement(this.dstNetElem, routePrefs);
            netCcatCircuit.sanityCheck();
            netCcatCircuit.provision();
            if (dbg.on()) {
                Unprot2UpsrInServiceUpgradeMgr.debug("upgradeLoTunnel: created new circuit " + netCcatCircuit.getCircuitName() + ", ckt ID => " + NetCircuit.prettyString(netCcatCircuit.getCircuitId()));
            }
        }
        catch (CTCUserException cTCUserException) {
            throw new InServiceUpgradeError((Exception)((Object)cTCUserException));
        }
        catch (SanityCheckFailed sanityCheckFailed) {
            throw new InServiceUpgradeError(sanityCheckFailed);
        }
        catch (ConnTypeUnsupported connTypeUnsupported) {
            throw new InServiceUpgradeError(connTypeUnsupported);
        }
        catch (IncorrectCircuitState incorrectCircuitState) {
            throw new InServiceUpgradeError(incorrectCircuitState);
        }
        catch (CircuitProvError circuitProvError) {
            throw new InServiceUpgradeError(circuitProvError);
        }
        catch (AnnotatedException annotatedException) {
            throw new InServiceUpgradeError((Exception)((Object)annotatedException));
        }
    }

    public CircuitCreatInfo createCircuitCreateInfo() {
        CircuitCreatInfo circuitCreatInfo = new CircuitCreatInfo(this.cktInUpgrade.getCircuitType(), this.cktInUpgrade.getCircuitSize(), 1);
        circuitCreatInfo.setName(this.cktInUpgrade.getCircuitName());
        circuitCreatInfo.setAdminState(this.masterNode.getAdminState());
        if (dbg.on()) {
            Unprot2UpsrInServiceUpgradeMgr.debug("createCircuitCreateInfo: new circuit attributes ");
            Unprot2UpsrInServiceUpgradeMgr.debug("createCircuitCreateInfo:    name => " + circuitCreatInfo.name());
            Unprot2UpsrInServiceUpgradeMgr.debug("createCircuitCreateInfo:    admin state => " + circuitCreatInfo.adminState());
        }
        return circuitCreatInfo;
    }

    public void convert() throws InServiceUpgradeError {
        try {
            this.sanityCheckCircuit();
            this.initializeState();
        }
        catch (InServiceUpgradeError inServiceUpgradeError) {
            throw new InServiceUpgradeError(inServiceUpgradeError.getMessage());
        }
        ThreadPool.instance().enqueueClient((IActionClient)this.upgradeActionClient);
    }

    public void cancel() {
        if (dbg.on()) {
            Unprot2UpsrInServiceUpgradeMgr.debug("cancel: Upgrade operation is being cancelled for CKT " + this.cktInUpgrade.getCircuitName());
        }
        if (this.state != InServiceUpgradeState.PENDING_UPGRADE && this.state != InServiceUpgradeState.COMPLETE) {
            this.cancelUpgrade();
        }
        this.dispose();
    }

    private void cancelUpgrade() {
        if (dbg.on()) {
            Unprot2UpsrInServiceUpgradeMgr.debug("cancelUpgrade: cancelling upgrade operation due to error");
        }
        this.destroyNewCircuits();
        this.cancelConnConvModels();
        this.cktInUpgrade.removeRoutedSpans();
        this.cktInUpgrade.setPathProtForDrops(false);
        this.cktInUpgrade.markUpsr();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initializeState() throws InServiceUpgradeError {
        NetCircuitNode netCircuitNode;
        boolean bl = false;
        IConnectionConversionModel iConnectionConversionModel = null;
        if (this.cktInUpgrade.getState() != 11) {
            this.state = InServiceUpgradeState.PENDING_CREATE;
            this.masterNode = (NetCircuitNode)this.cktInUpgrade.getSrcCircuitNode();
            return;
        }
        if (dbg.on()) {
            Unprot2UpsrInServiceUpgradeMgr.debug("initializeState: circuit in CONVERSION_PENDING state");
        }
        if ((iConnectionConversionModel = (netCircuitNode = (NetCircuitNode)this.cktInUpgrade.getSrcCircuitNode()).getConnConvModel()) != null && iConnectionConversionModel.isMasterNode()) {
            bl = true;
            this.masterNode = netCircuitNode;
            if (dbg.on()) {
                Unprot2UpsrInServiceUpgradeMgr.debug("initializeState: SRC node is Master node");
            }
        } else {
            netCircuitNode = (NetCircuitNode)this.cktInUpgrade.getCircuitNodeFromNE(this.dstNetElem);
            if (netCircuitNode == null) {
                Unprot2UpsrInServiceUpgradeMgr.debug("initializeState: cannot find DST ckt node for NE " + this.dstNetElem.getHostName());
            }
            if ((iConnectionConversionModel = netCircuitNode.getConnConvModel()) != null && iConnectionConversionModel.isMasterNode()) {
                bl = true;
                this.masterNode = netCircuitNode;
                if (dbg.on()) {
                    Unprot2UpsrInServiceUpgradeMgr.debug("initializeState: DST node is Master node");
                }
                try {
                    if (dbg.on()) {
                        Unprot2UpsrInServiceUpgradeMgr.debug("initializeState: swapping SRC/DST");
                    }
                    this.cktInUpgrade.reverseRoutingDir();
                }
                catch (IncorrectCircuitState incorrectCircuitState) {
                    Unprot2UpsrInServiceUpgradeMgr.debug("initializeState: failed to reverse routing direction");
                    SDebug.printStackTrace((Throwable)incorrectCircuitState);
                    throw new InServiceUpgradeError("Cannot determine upgrade state, aborting upgrade");
                }
            }
        }
        if (!bl) {
            Unprot2UpsrInServiceUpgradeMgr.debug("initializeState: ERROR => cannot find Conn Conv Model on Master Node");
            throw new InServiceUpgradeError("Cannot determine upgrade state, aborting upgrade");
        }
        if (dbg.on()) {
            Unprot2UpsrInServiceUpgradeMgr.debug("initializeState: masterNode is " + this.masterNode.getNetElement().getHostName());
        }
        if ((iConnectionConversionModel = this.masterNode.getConnConvModel()).getState() == InServiceUpgradeState.PENDING_CREATE.value()) {
            if (dbg.on()) {
                Unprot2UpsrInServiceUpgradeMgr.debug("initializeState: found Conn Conv Model in PENDING_CREATE state");
            }
            this.state = InServiceUpgradeState.PENDING_CREATE;
            this.cleanupOldConversion();
            return;
        }
        if (iConnectionConversionModel.getState() == InServiceUpgradeState.PENDING_UPGRADE.value()) {
            if (dbg.on()) {
                Unprot2UpsrInServiceUpgradeMgr.debug("initializeState: found Conn Conv Model in PENDING_UPGRADE state");
            }
            this.state = InServiceUpgradeState.PENDING_UPGRADE;
            return;
        }
        if (iConnectionConversionModel.getState() != InServiceUpgradeState.COMPLETE.value()) return;
        if (dbg.on()) {
            Unprot2UpsrInServiceUpgradeMgr.debug("initializeState: found Conn Conv Model in COMPLETE state");
        }
        this.state = InServiceUpgradeState.COMPLETE;
    }

    private void setState(InServiceUpgradeState inServiceUpgradeState) throws InServiceUpgradeError {
        InServiceUpgradeState inServiceUpgradeState2 = this.state;
        if (inServiceUpgradeState2 == inServiceUpgradeState) {
            return;
        }
        if (inServiceUpgradeState == InServiceUpgradeState.PENDING_UPGRADE) {
            IConnectionConversionModel iConnectionConversionModel = this.masterNode.getConnConvModel();
            if (iConnectionConversionModel == null) {
                INetElement iNetElement = this.masterNode.getNetElement();
                if (dbg.on()) {
                    Unprot2UpsrInServiceUpgradeMgr.debug("setState: ERROR - cannot find Conn Conv model on src node " + iNetElement.getHostName());
                }
                throw new InServiceUpgradeError("Fatal error - required upgrade information not available on " + iNetElement.getHostName());
            }
            iConnectionConversionModel.setState(InServiceUpgradeState.PENDING_UPGRADE.value());
        }
        this.state = inServiceUpgradeState;
        if (dbg.on()) {
            Unprot2UpsrInServiceUpgradeMgr.debug("setState: state changed, old => " + inServiceUpgradeState2.toString() + ", new => " + this.state.toString());
        }
    }

    private void cleanupOldConversion() throws InServiceUpgradeError {
        if (dbg.on()) {
            Unprot2UpsrInServiceUpgradeMgr.debug("cleanupOldConversion: destroying existing Conn Conv Models");
        }
        this.getConnConvModels();
        this.getCircuitsFromSourceConnConvModel();
        this.destroyNewCircuits();
        this.cancelConnConvModels();
        try {
            if (dbg.on()) {
                Unprot2UpsrInServiceUpgradeMgr.debug("cleanupOldConversion: sleeping for 5 seconds");
            }
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void handleFatalException(Exception exception) throws InServiceUpgradeError, NoMoreVtCapableSts, PathListIncomplete, NoMoreLoCapableHo, PathInUse {
        if (dbg.on()) {
            Unprot2UpsrInServiceUpgradeMgr.debug("handleFatalException: caught exception => " + exception.getMessage());
            SDebug.printStackTrace((Throwable)exception);
        }
        if (exception instanceof NoMoreVtCapableSts) {
            throw (NoMoreVtCapableSts)((Object)exception);
        }
        if (exception instanceof NoMoreLoCapableHo) {
            throw (NoMoreLoCapableHo)exception;
        }
        if (exception instanceof PathListIncomplete) {
            throw (PathListIncomplete)((Object)exception);
        }
        if (exception instanceof PathInUse) {
            throw (PathInUse)exception;
        }
        throw new InServiceUpgradeError(exception.getMessage());
    }

    private Collection getNewCircuits() {
        LinkedList<INetCircuit> linkedList = new LinkedList<INetCircuit>();
        Iterator iterator = this.connCreators.values().iterator();
        while (iterator.hasNext()) {
            ConnectionCreator connectionCreator = (ConnectionCreator)iterator.next();
            linkedList.add(connectionCreator.getNewCircuit());
        }
        return linkedList;
    }

    private void destroyNewCircuits() {
        Iterator iterator = this.getNewCircuits().iterator();
        while (iterator.hasNext()) {
            NetCircuit netCircuit = (NetCircuit)iterator.next();
            if (netCircuit == null) continue;
            if (dbg.on()) {
                Unprot2UpsrInServiceUpgradeMgr.debug("destroyNewCircuits: destroying new circuit " + netCircuit.getCircuitName());
            }
            try {
                netCircuit.destroyCircuit();
            }
            catch (Exception exception) {
                Unprot2UpsrInServiceUpgradeMgr.debug("destroyNewCircuits: caught exception => " + exception.getMessage());
            }
        }
    }

    private void convertExistingOnewayConnsToTwoway() {
        if (this.cktInUpgrade.isBidirectional()) {
            if (dbg.on()) {
                Unprot2UpsrInServiceUpgradeMgr.debug("convertExistingOnewayConnsToTwoway: ckt is Bidirectional, nothing to do");
            }
            return;
        }
        Iterator iterator = this.cktInUpgrade.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            Object object;
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            if (netCircuitNode.getConnectionType() != 0 || netCircuitNode.getAllSpansList().size() != 2) continue;
            Iterator iterator2 = netCircuitNode.getAllSpansList().iterator();
            boolean bl = true;
            while (iterator2.hasNext()) {
                object = (NetCircuitSpan)iterator2.next();
                if (((NetCircuitSpan)object).getLink().getProtectionType() == 3) continue;
                bl = false;
            }
            if (!bl || this.connConverters.containsKey(new Integer((object = netCircuitNode.getNetElement()).getNodeId()))) continue;
            ConnectionConverter connectionConverter = new ConnectionConverter((INetElement)object, 1);
            this.connConverters.put(new Integer(object.getNodeId()), connectionConverter);
        }
    }

    private void createConnCreationModels() throws InServiceUpgradeError {
        Iterator iterator = this.connCreators.values().iterator();
        while (iterator.hasNext()) {
            ConnectionCreator connectionCreator = (ConnectionCreator)iterator.next();
            INetCircuit iNetCircuit = connectionCreator.create();
        }
    }

    private void createConnConvModels() throws CTCUserException {
        ConnectionConverter connectionConverter = (ConnectionConverter)this.connConverters.get(new Integer(this.srcNetElem.getNodeId()));
        if (connectionConverter != null) {
            if (dbg.on()) {
                Unprot2UpsrInServiceUpgradeMgr.debug("createConnConvModels: creating SRC conn converter first");
            }
            connectionConverter.create();
        } else {
            Unprot2UpsrInServiceUpgradeMgr.debug("createConnConvModels: ERROR, src Conn Converter not  found");
        }
        Iterator iterator = this.connConverters.values().iterator();
        while (iterator.hasNext()) {
            connectionConverter = (ConnectionConverter)iterator.next();
            connectionConverter.create();
        }
    }

    private void convertConnConvModels() throws InServiceUpgradeError {
        Object object;
        Object object2;
        this.setState(InServiceUpgradeState.PENDING_UPGRADE);
        ConnectionConverter connectionConverter = null;
        Iterator<Object> iterator = this.connConverters.values().iterator();
        while (iterator.hasNext()) {
            object2 = (ConnectionConverter)iterator.next();
            object = ((ConnectionConverter)object2).getCktNode();
            if (((NetCircuitNode)object).getNetElement().equals(this.srcNetElem)) {
                connectionConverter = object2;
                continue;
            }
            ((ConnectionConverter)object2).convert();
        }
        if (connectionConverter != null) {
            connectionConverter.convert();
        }
        iterator = this.cktInUpgrade.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            object2 = (NetCircuitNode)iterator.next();
            object = ((NetCircuitNode)object2).getAllSpansList().iterator();
            while (object.hasNext()) {
                NetCircuitSpan netCircuitSpan = (NetCircuitSpan)object.next();
                netCircuitSpan.setSrcState(4);
                netCircuitSpan.setDstState(4);
            }
        }
    }

    private void cancelConnConvModels() {
        Iterator iterator = this.connConverters.values().iterator();
        while (iterator.hasNext()) {
            ConnectionConverter connectionConverter = (ConnectionConverter)iterator.next();
            connectionConverter.cancel();
        }
        this.connConverters.clear();
    }

    private void getConnConvModels() {
        Iterator iterator = this.cktInUpgrade.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            INetElement iNetElement = netCircuitNode.getNetElement();
            if (!this.connConverters.containsKey(new Integer(iNetElement.getNodeId()))) {
                IConnectionConversionModel iConnectionConversionModel = netCircuitNode.getConnConvModel();
                if (iConnectionConversionModel == null) continue;
                if (dbg.on()) {
                    Unprot2UpsrInServiceUpgradeMgr.debug("getConnConvModels: found ConnConvModel on " + iNetElement.getHostName());
                }
                ConnectionConverter connectionConverter = new ConnectionConverter(iNetElement);
                this.connConverters.put(new Integer(iNetElement.getNodeId()), connectionConverter);
                continue;
            }
            if (!dbg.on()) continue;
            Unprot2UpsrInServiceUpgradeMgr.debug("getConnConvModels: found existing Connection Converter for " + iNetElement.getHostName());
        }
    }

    private void getCircuitsFromSourceConnConvModel() throws InServiceUpgradeError {
        IConnectionConversionModel iConnectionConversionModel = this.masterNode.getConnConvModel();
        if (iConnectionConversionModel == null) {
            INetElement iNetElement = this.masterNode.getNetElement();
            if (dbg.on()) {
                Unprot2UpsrInServiceUpgradeMgr.debug("getCircuitsFromSourceConnConvModel: ERROR - Conn Conv Model not found on " + iNetElement.getHostName());
            }
            throw new InServiceUpgradeError("FATAL ERROR - required upgrade information not available on " + iNetElement.getHostName());
        }
        ICircuitId[] iCircuitIdArray = iConnectionConversionModel.getTempCircuitIds();
        if (dbg.on()) {
            Unprot2UpsrInServiceUpgradeMgr.debug("getCircuitsFromSourceConnConvModel: getting " + iCircuitIdArray.length + " circuit IDs");
        }
        for (int i = 0; i < iCircuitIdArray.length; ++i) {
            INetCircuit iNetCircuit = NetCircuitManager.instance().getCircuitFromId(iCircuitIdArray[i]);
            if (iNetCircuit == null) {
                if (!dbg.on()) continue;
                Unprot2UpsrInServiceUpgradeMgr.debug("getCircuitsFromSourceConvModel: ERROR - unknown Circuit ID " + iCircuitIdArray[i]);
                continue;
            }
            INetElement iNetElement = iNetCircuit.getSrcCircuitNode().getNetElement();
            if (dbg.on()) {
                Unprot2UpsrInServiceUpgradeMgr.debug("getCircuitsFromSourceConnConvModel: NE => " + iNetElement.getHostName() + ", ckt ID => " + NetCircuit.prettyString(iCircuitIdArray[i]));
            }
            ConnectionCreator connectionCreator = new ConnectionCreator(iNetCircuit);
            this.connCreators.put(new Integer(iNetElement.getNodeId()), connectionCreator);
        }
    }

    private void updateNodeConnectionPaths() {
        if (dbg.on()) {
            Unprot2UpsrInServiceUpgradeMgr.debug("updateNodeConnectionPaths: forcing NCN connection path update");
        }
        this.cktInUpgrade.updateCircuitNodeConnectionPaths();
    }

    private void mergeCircuits() throws InServiceUpgradeError {
        Object object;
        Collection collection;
        if (dbg.on()) {
            Unprot2UpsrInServiceUpgradeMgr.debug("mergeCircuits: merging the following circuits ");
            Unprot2UpsrInServiceUpgradeMgr.debug("mergeCircuits: original ckt => " + this.cktInUpgrade.getCircuitName());
        }
        if ((collection = this.getNewCircuits()).size() == 0) {
            if (dbg.on()) {
                Unprot2UpsrInServiceUpgradeMgr.debug("mergeCircuits: no circuits to merge");
            }
            return;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            object = (NetCircuit)iterator.next();
            Unprot2UpsrInServiceUpgradeMgr.debug("mergeCircuits: new ckt => " + ((NetCircuit)object).getCircuitName());
        }
        object = new LinkedList();
        ((LinkedList)object).add(this.cktInUpgrade);
        ((LinkedList)object).addAll(collection);
        CircuitMergeManager circuitMergeManager = CircuitMergeManager.instance();
        try {
            circuitMergeManager.init((List)object, 0);
            circuitMergeManager.mergeCircuits();
        }
        catch (IllegalStateException illegalStateException) {
            if (dbg.on()) {
                Unprot2UpsrInServiceUpgradeMgr.debug("mergeCircuits: caught exception => " + illegalStateException.getMessage());
                SDebug.printStackTrace((Throwable)illegalStateException);
            }
            throw new InServiceUpgradeError(illegalStateException.getMessage());
        }
        catch (CircuitMergeError circuitMergeError) {
            if (dbg.on()) {
                Unprot2UpsrInServiceUpgradeMgr.debug("mergeCircuits: caught exception => " + circuitMergeError.getMessage());
                SDebug.printStackTrace((Throwable)circuitMergeError);
            }
            throw new InServiceUpgradeError(circuitMergeError.getMessage());
        }
    }

    private void createSrcConnConvModel() {
        INetElement iNetElement = this.masterNode.getNetElement();
        if (!this.connConverters.containsKey(new Integer(iNetElement.getNodeId()))) {
            if (dbg.on()) {
                Unprot2UpsrInServiceUpgradeMgr.debug("createSrcConnConvModel: creating SRC Conn Conv, connType => " + EnumStrings.getString((Class)IConnectionType.class, (int)this.masterNode.getConnectionType()));
            }
            ConnectionConverter connectionConverter = new ConnectionConverter(iNetElement, this.masterNode.getConnectionType());
            this.connConverters.put(new Integer(iNetElement.getNodeId()), connectionConverter);
        }
    }

    private void createConnectionOperators(Collection collection) {
        Object object;
        if (dbg.on()) {
            Unprot2UpsrInServiceUpgradeMgr.debug("createConnectionOperators: start");
        }
        ConnectionCreator connectionCreator = null;
        ConnectionConverter connectionConverter = null;
        INetElement iNetElement = null;
        INetElement iNetElement2 = null;
        Iterator<Object> iterator = collection.iterator();
        while (iterator.hasNext()) {
            object = (NetLinkSpan)iterator.next();
            iNetElement = ((NetLinkSpan)object).getLink().getSrc();
            iNetElement2 = ((NetLinkSpan)object).getLink().getDst();
            if (!this.allCktNetElems.contains(iNetElement)) {
                connectionCreator = (ConnectionCreator)this.connCreators.get(new Integer(iNetElement.getNodeId()));
                if (connectionCreator == null) {
                    connectionCreator = new ConnectionCreator(iNetElement);
                    connectionCreator.setDstLinkSpan((INetLinkSpan)object);
                    this.connCreators.put(new Integer(iNetElement.getNodeId()), connectionCreator);
                } else {
                    connectionCreator.setDstLinkSpan((INetLinkSpan)object);
                }
            } else {
                connectionConverter = (ConnectionConverter)this.connConverters.get(new Integer(iNetElement.getNodeId()));
                if (connectionConverter == null) {
                    connectionConverter = new ConnectionConverter(iNetElement);
                    connectionConverter.addLinkSpan((INetLinkSpan)object);
                    this.connConverters.put(new Integer(iNetElement.getNodeId()), connectionConverter);
                } else {
                    connectionConverter.addLinkSpan((INetLinkSpan)object);
                }
            }
            if (!this.allCktNetElems.contains(iNetElement2)) {
                connectionCreator = (ConnectionCreator)this.connCreators.get(new Integer(iNetElement2.getNodeId()));
                if (connectionCreator == null) {
                    connectionCreator = new ConnectionCreator(iNetElement2);
                    connectionCreator.setSrcLinkSpan((INetLinkSpan)object);
                    this.connCreators.put(new Integer(iNetElement2.getNodeId()), connectionCreator);
                    continue;
                }
                connectionCreator.setSrcLinkSpan((INetLinkSpan)object);
                continue;
            }
            connectionConverter = (ConnectionConverter)this.connConverters.get(new Integer(iNetElement2.getNodeId()));
            if (connectionConverter == null) {
                connectionConverter = new ConnectionConverter(iNetElement2);
                connectionConverter.addLinkSpan((INetLinkSpan)object);
                this.connConverters.put(new Integer(iNetElement2.getNodeId()), connectionConverter);
                continue;
            }
            connectionConverter.addLinkSpan((INetLinkSpan)object);
        }
        if (dbg.on()) {
            dbg.println("createConnectionOperators: ConnectionCreators =>");
            iterator = this.connCreators.values().iterator();
            while (iterator.hasNext()) {
                object = (ConnectionCreator)iterator.next();
                dbg.println(((ConnectionCreator)object).prettyString());
            }
            dbg.println("createConnectionOperators: ConnectionConverters =>");
            iterator = this.connConverters.values().iterator();
            while (iterator.hasNext()) {
                object = (ConnectionConverter)iterator.next();
                dbg.println(((ConnectionConverter)object).prettyString());
            }
        }
    }

    private LinkedList findAlternatePathFromCircuit() throws InServiceUpgradeError {
        if (dbg.on()) {
            Unprot2UpsrInServiceUpgradeMgr.debug("findAlternatePathFromCircuit: Retrieving manually routed spans from circuit");
        }
        LinkedList<INetLinkSpan> linkedList = new LinkedList<INetLinkSpan>();
        this.setCircuitSpans();
        this.setCircuitNodes();
        Iterator iterator = this.getRoutedCircuitSpans().iterator();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            linkedList.add(netCircuitSpan.getNetLinkSpan());
        }
        return linkedList;
    }

    private void findAlternatePath() throws InServiceUpgradeError {
        if (dbg.on()) {
            Unprot2UpsrInServiceUpgradeMgr.debug("findAlternatePath: Starting alternate path calculation");
        }
        this.setCircuitSpans();
        this.setCircuitNodes();
        if (dbg.on()) {
            Unprot2UpsrInServiceUpgradeMgr.debug("findAlternatePath: Completed alternate path calculation");
        }
    }

    private Collection getAlternateLinkSpans(LinkedList linkedList) {
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            LinkedList<INetElement> linkedList2;
            Object object;
            PathSegment pathSegment = (PathSegment)iterator.next();
            if (pathSegment.isPathProtected()) {
                Object object2;
                Object object3;
                Object object4;
                if (dbg.on()) {
                    Unprot2UpsrInServiceUpgradeMgr.debug("getAlternateLinkSpans: found path protected segment");
                    Unprot2UpsrInServiceUpgradeMgr.debug("getAlternateLinkSpans: => " + pathSegment.prettyString());
                }
                object = new LinkedList();
                linkedList2 = new LinkedList();
                boolean bl = true;
                Iterator iterator2 = pathSegment.getPrimary().iterator();
                while (iterator2.hasNext()) {
                    object4 = (NetLinkSpan)iterator2.next();
                    object3 = (NetCircuitSpan)this.cktInUpgrade.getCircuitSpanFromNetLink(((NetLinkSpan)object4).getLink());
                    if (object3 != null && ((NetCircuitSpan)object3).isUpsr()) {
                        if (bl) {
                            ((LinkedList)object).add(linkedList2);
                            bl = false;
                        }
                        if (linkedList2.isEmpty()) {
                            linkedList2.add(0, ((NetCircuitSpan)object3).getLink().getSrc());
                        }
                        linkedList2.add(1, ((NetCircuitSpan)object3).getLink().getDst());
                        continue;
                    }
                    bl = true;
                    linkedList2 = new LinkedList<INetElement>();
                }
                object4 = new LinkedList();
                if (!((AbstractCollection)object).isEmpty()) {
                    object3 = ((AbstractSequentialList)object).iterator();
                    while (object3.hasNext()) {
                        object2 = (List)object3.next();
                        Iterator iterator3 = object2.iterator();
                        while (iterator3.hasNext()) {
                            INetElement iNetElement = (INetElement)iterator3.next();
                            ((LinkedList)object4).add(iNetElement);
                        }
                    }
                }
                boolean bl2 = false;
                iterator2 = pathSegment.getAlternate().iterator();
                while (iterator2.hasNext()) {
                    object2 = (NetLinkSpan)iterator2.next();
                    if (((AbstractCollection)object4).isEmpty()) {
                        this.newLinkSpans.add(object2);
                        this.cktInUpgrade.addCircuitSpan((INetLinkSpan)object2);
                        continue;
                    }
                    if (((LinkedList)object4).contains(((NetLinkSpan)object2).getLink().getSrc()) && ((LinkedList)object4).indexOf(((NetLinkSpan)object2).getLink().getSrc()) % 2 == 0) {
                        if (((LinkedList)object4).contains(((NetLinkSpan)object2).getLink().getDst())) continue;
                        bl2 = true;
                        continue;
                    }
                    if (((LinkedList)object4).contains(((NetLinkSpan)object2).getLink().getDst()) && ((LinkedList)object4).indexOf(((NetLinkSpan)object2).getLink().getDst()) % 2 == 1) {
                        if (!bl2) continue;
                        bl2 = false;
                        continue;
                    }
                    if (bl2) continue;
                    this.newLinkSpans.add(object2);
                    this.cktInUpgrade.addCircuitSpan((INetLinkSpan)object2);
                }
                continue;
            }
            if (pathSegment.isLineProtected()) {
                if (!dbg.on()) continue;
                Unprot2UpsrInServiceUpgradeMgr.debug("getAlternateLinkSpans: ignoring line protected segment");
                Unprot2UpsrInServiceUpgradeMgr.debug("getAlternateLinkSpans: => " + pathSegment.prettyString());
                continue;
            }
            if (this.cktInUpgrade.getCircuitType() == 3 || this.cktInUpgrade.getCircuitType() == 6) {
                if (dbg.on()) {
                    Unprot2UpsrInServiceUpgradeMgr.debug("getAlternateLinkSpans: found unprotected path for LOT");
                }
                object = pathSegment.getPrimary().iterator();
                while (object.hasNext()) {
                    linkedList2 = (NetLinkSpan)object.next();
                    this.newLinkSpans.add(linkedList2);
                    this.cktInUpgrade.addCircuitSpan((INetLinkSpan)((Object)linkedList2));
                }
                continue;
            }
            Unprot2UpsrInServiceUpgradeMgr.debug("getAlternateLinkSpans: WARNING found unexpected unprotected path segment");
        }
        return this.newLinkSpans;
    }

    private void sanityCheckCircuit() throws InServiceUpgradeError {
        Object object;
        Object object2;
        Iterator iterator;
        if (this.cktInUpgrade.getState() != 1 && this.cktInUpgrade.getState() != 11 && this.cktInUpgrade.getState() != 5) {
            if (dbg.on()) {
                Unprot2UpsrInServiceUpgradeMgr.debug("sanityCheckCircuit: circuit is not active");
            }
            throw new InServiceUpgradeError("Circuit must be in ACTIVE state");
        }
        this.UPSR_TERM = NetCircuitNode.getTDMTerminology(null).getRingTerms(0);
        if (this.cktInUpgrade.getCircuitType() != 1 && this.cktInUpgrade.getCircuitType() != 2 && this.cktInUpgrade.getCircuitType() != 3 && this.cktInUpgrade.getCircuitType() != 4 && this.cktInUpgrade.getCircuitType() != 5 && this.cktInUpgrade.getCircuitType() != 6) {
            if (dbg.on()) {
                Unprot2UpsrInServiceUpgradeMgr.debug("sanityCheckCircuit: circuit type unsupported => " + EnumStrings.getString((Class)ICircuitType.class, (int)this.cktInUpgrade.getCircuitType()));
            }
            throw new InServiceUpgradeError("Circuit type " + (this.cktInUpgrade.isStitchedEthernet() ? "ETHERGROUP" : EnumStrings.getString((Class)ICircuitType.class, (int)this.cktInUpgrade.getCircuitType())) + " not supported");
        }
        if (this.cktInUpgrade.isMonitorCircuit()) {
            throw new InServiceUpgradeError("Monitor circuits cannot be upgraded to " + this.UPSR_TERM);
        }
        if (this.cktInUpgrade.hasLoopback() || this.cktInUpgrade.hasXcLoopback()) {
            throw new InServiceUpgradeError("Circuits in LoopBack cannot be upgraded to " + this.UPSR_TERM);
        }
        if (this.cktInUpgrade.isDiag()) {
            throw new InServiceUpgradeError("Diag circuits cannot be upgraded to " + this.UPSR_TERM);
        }
        if (this.cktInUpgrade.getCircuitNodes().size() == 1) {
            throw new InServiceUpgradeError("Intra-node circuits cannot be upgraded to " + this.UPSR_TERM);
        }
        if (!PortGrouping.getCircuitsInPortGroup(this.cktInUpgrade).isEmpty()) {
            throw new InServiceUpgradeError("Circuit in port grouping cannot be upgraded to " + this.UPSR_TERM);
        }
        if (this.cktInUpgrade.getSources().size() == 1 && this.cktInUpgrade.getDrops().size() == 1 && this.cktInUpgrade.getPrimarySource().getNetElement() == this.cktInUpgrade.getPrimaryDrop().getNetElement()) {
            throw new InServiceUpgradeError("STS around circuits cannot be upgraded to " + this.UPSR_TERM);
        }
        if (this.cktInUpgrade.getSources().size() == 2) {
            iterator = (NetCircuitEnd)this.cktInUpgrade.getSources().get(0);
            object2 = (NetCircuitEnd)this.cktInUpgrade.getSources().get(1);
            if (((NetCircuitEnd)((Object)iterator)).getNodeId() != ((NetCircuitEnd)object2).getNodeId()) {
                if (dbg.on()) {
                    Unprot2UpsrInServiceUpgradeMgr.debug("sanityCheckCircuit: unsupported circuit type => 2 sources on different nodes");
                }
                throw new InServiceUpgradeError("Circuit contains 2 sources on different nodes. Upgrade of unprotected circuit to open-ended " + this.UPSR_TERM + " circuit not supported");
            }
        }
        if (this.cktInUpgrade.getDrops().size() > 1) {
            iterator = (NetCircuitDropInfo)this.cktInUpgrade.getDrops().get(0);
            for (int i = 1; i < this.cktInUpgrade.getDrops().size(); ++i) {
                object = (NetCircuitDropInfo)this.cktInUpgrade.getDrops().get(i);
                if (((NetCircuitDropInfo)((Object)iterator)).getNodeId() == ((NetCircuitDropInfo)object).getNodeId()) continue;
                if (dbg.on()) {
                    Unprot2UpsrInServiceUpgradeMgr.debug("sanityCheckCircuit: unsupported circuit type => 2 drops on different nodes");
                }
                throw new InServiceUpgradeError("Upgrade not supported as circuit contains drops on different nodes.");
            }
        }
        if (!this.cktInUpgrade.getXmCircuitEnds().isEmpty()) {
            throw new InServiceUpgradeError("This " + CircuitType.getCircuitType((int)this.cktInUpgrade.getCircuitType()) + " circuit cannot be upgraded");
        }
        if (this.cktInUpgrade.isCircuitProtected()) {
            if (this.cktInUpgrade.getState() == 11) {
                this.getConnConvModels();
                this.cancelConnConvModels();
            } else {
                if (dbg.on()) {
                    Unprot2UpsrInServiceUpgradeMgr.debug("sanityCheckCircuit: circuit already protected");
                }
                throw new InServiceUpgradeError("Circuit is already protected");
            }
        }
        iterator = this.cktInUpgrade.getCircuitSpans().iterator();
        while (iterator.hasNext()) {
            object2 = (NetCircuitSpan)iterator.next();
            if (((NetCircuitSpan)object2).getSrcState() != 4 || ((NetCircuitSpan)object2).getDstState() != 4 || !((NetCircuitSpan)object2).getDri()) continue;
            throw new InServiceUpgradeError("Partial DRI circuits cannot be upgraded to " + this.UPSR_TERM);
        }
        iterator = this.cktInUpgrade.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            object2 = (NetCircuitNode)iterator.next();
            if (((NetCircuitNode)object2).getDriNodeTypeFromModelLayer() != 1 && ((NetCircuitNode)object2).getDriNodeTypeFromModelLayer() != 2) continue;
            throw new InServiceUpgradeError("Partial DRI circuits cannot be upgraded to " + this.UPSR_TERM);
        }
        object2 = "";
        iterator = this.cktInUpgrade.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            object = (INetCircuitNode)iterator.next();
            if (object.getNodeModel().provides(Feature.ISTU)) {
                if (!dbg.on()) continue;
                Unprot2UpsrInServiceUpgradeMgr.debug("sanityCheckCircuit: ISTU feature supported on " + object.getNetElement().getHostName());
                continue;
            }
            if (dbg.on()) {
                Unprot2UpsrInServiceUpgradeMgr.debug("sanityCheckCircuit: ISTU feature NOT supported on " + object.getNetElement().getHostName());
            }
            object2 = (String)object2 + object.getNetElement().getHostName() + "\n";
        }
        if (((String)object2).length() > 0) {
            throw new InServiceUpgradeError("Circuit cannot be upgraded as the In-Service Topology Upgrade feature is not supported on the following nodes: \n" + (String)object2);
        }
        if (!this.autoRoute) {
            boolean bl = false;
            iterator = this.cktInUpgrade.getCircuitSpans().iterator();
            while (iterator.hasNext()) {
                NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
                if (netCircuitSpan.getSrcState() != 2 || netCircuitSpan.getDstState() != 2) continue;
                if (dbg.on()) {
                    Unprot2UpsrInServiceUpgradeMgr.debug("sanityCheckCircuit: found ROUTED span " + netCircuitSpan.prettyString());
                }
                bl = true;
            }
            if (!bl) {
                throw new InServiceUpgradeError("Protect path not fully specified");
            }
            try {
                this.cktInUpgrade.sanityCheckManualRouting();
                this.cktInUpgrade.sanityCheck();
            }
            catch (SanityCheckFailed sanityCheckFailed) {
                throw new InServiceUpgradeError(sanityCheckFailed.getMessage());
            }
        }
    }

    private void setCircuitSpans() {
        Iterator iterator = this.cktInUpgrade.getCircuitSpans().iterator();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            if (dbg.on()) {
                Unprot2UpsrInServiceUpgradeMgr.debug("setCircuitSpans:     " + netCircuitSpan.prettyString());
            }
            if (netCircuitSpan.getSrcState() == 2 && netCircuitSpan.getDstState() == 2) {
                this.routedCktSpans.add(netCircuitSpan);
                this.cktInUpgrade.deleteCircuitSpan(netCircuitSpan.getNetLinkSpan());
                continue;
            }
            if (netCircuitSpan.getSrcState() != 4 || netCircuitSpan.getDstState() != 4) continue;
            this.activeCktSpans.add(netCircuitSpan);
            this.allCktLinks.add(netCircuitSpan.getLink());
            this.allCktLinks.add(netCircuitSpan.getReverseLink());
        }
    }

    private void setCircuitNodes() {
        Iterator iterator = this.cktInUpgrade.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            if (netCircuitNode.getState() != 2 && netCircuitNode.getState() != 3 && netCircuitNode.getState() != 4) continue;
            this.allCktNetElems.add(netCircuitNode.getNetElement());
            if (!dbg.on()) continue;
            Unprot2UpsrInServiceUpgradeMgr.debug("setCircuitNodes: added ckt node => " + netCircuitNode.getName());
        }
    }

    private Collection getRoutedCircuitSpans() {
        return this.routedCktSpans;
    }

    private List getLinksFromSpans(List list) {
        LinkedList<INetLink> linkedList = new LinkedList<INetLink>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            linkedList.add(netCircuitSpan.getLink());
        }
        return linkedList;
    }

    private LinkedList getNetLinkSpansFromNetCircuitSpans(List list) {
        LinkedList<INetLinkSpan> linkedList = new LinkedList<INetLinkSpan>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            linkedList.add(netCircuitSpan.getNetLinkSpan());
        }
        return linkedList;
    }

    private LinkedList getOrderedCircuitNetLinks() {
        LinkedList linkedList = new LinkedList();
        LinkedList linkedList2 = new LinkedList();
        this.cktInUpgrade.getOrderedNodeAndSpanList(null, null, linkedList, linkedList2);
        if (dbg.on()) {
            Unprot2UpsrInServiceUpgradeMgr.debug("getOrderedCircuitNetLinks: Circuit contains " + linkedList.size() + " paths");
        }
        LinkedList linkedList3 = (LinkedList)this.getLinksFromSpans(linkedList2);
        if (dbg.on()) {
            Unprot2UpsrInServiceUpgradeMgr.debug("getOrderedCircuitNetLinks: Ordered Links => ");
            Iterator iterator = linkedList3.iterator();
            while (iterator.hasNext()) {
                INetLink iNetLink = (INetLink)iterator.next();
                Unprot2UpsrInServiceUpgradeMgr.debug("getOrderedCircuitNetLinks:     " + iNetLink.prettyString());
            }
            return linkedList3;
        }
        return new LinkedList();
    }

    private RoutePrefs computeRoutePrefs(INetElement iNetElement, INetElement iNetElement2, List list, List list2, List list3, List list4) {
        block11: {
            Object object;
            if (dbg.on()) {
                Unprot2UpsrInServiceUpgradeMgr.debug("computeRoutePrefs: computing route prefs from " + iNetElement.getHostName() + " to " + iNetElement2.getHostName());
            }
            Iterator iterator = null;
            this.prefs.setSrc(iNetElement);
            this.prefs.setDst(iNetElement2);
            this.prefs.setRequiredSpans(list);
            if (dbg.on()) {
                iterator = list.iterator();
                Unprot2UpsrInServiceUpgradeMgr.debug("computeRoutePrefs: required spans => ");
                while (iterator.hasNext()) {
                    object = (INetLinkSpan)iterator.next();
                    Unprot2UpsrInServiceUpgradeMgr.debug("computeRoutePrefs:     " + object.prettyString());
                }
            }
            if (this.cktInUpgrade.getCircuitType() == 3 || this.cktInUpgrade.getCircuitType() == 6) {
                this.prefs.setTunnel(true);
                this.prefs.setPathProt(2);
            } else {
                this.prefs.setTunnel(false);
                this.prefs.setPathProt(1);
            }
            try {
                object = new LinkedList();
                object.addAll(list3);
                object.addAll(list4);
                if (dbg.on()) {
                    Object object2;
                    Unprot2UpsrInServiceUpgradeMgr.debug("computeRoutePrefs: Excluded links => ");
                    iterator = list3.iterator();
                    while (iterator.hasNext()) {
                        object2 = (INetLink)iterator.next();
                        Unprot2UpsrInServiceUpgradeMgr.debug("computeRoutePrefs:    " + object2.prettyString());
                    }
                    Unprot2UpsrInServiceUpgradeMgr.debug("computeRoutePrefs: Excluded nodes => ");
                    iterator = list4.iterator();
                    while (iterator.hasNext()) {
                        object2 = (INetElement)iterator.next();
                        Unprot2UpsrInServiceUpgradeMgr.debug("computeRoutePrefs:    " + object2.prettyString());
                    }
                    Unprot2UpsrInServiceUpgradeMgr.debug("computeRoutePrefs: Required links => ");
                    iterator = list2.iterator();
                    while (iterator.hasNext()) {
                        object2 = (INetLink)iterator.next();
                        Unprot2UpsrInServiceUpgradeMgr.debug("computeRoutePrefs:    " + object2.prettyString());
                    }
                }
                this.prefs.setExcEntityList((Collection)object);
                this.prefs.setReqEntityList(list2);
            }
            catch (ObjDuplicate objDuplicate) {
                if (!dbg.on()) break block11;
                Unprot2UpsrInServiceUpgradeMgr.debug("computeRoutePrefs: ObjDuplicate exception => " + objDuplicate.getMessage());
            }
        }
        this.prefs.setCircuitSize(this.cktInUpgrade.getCircuitSize());
        this.prefs.setCircuitType(this.cktInUpgrade.getCircuitType());
        this.prefs.setPathOnly(false);
        this.prefs.setDir(this.cktInUpgrade.getCircuitDir());
        this.prefs.setSla(this.cktInUpgrade.getSla());
        return this.prefs;
    }

    private RoutePrefs computeLOTRoutePrefs(List list) throws InServiceUpgradeError {
        Object object;
        LinkedList linkedList = this.getOrderedCircuitNetLinks();
        LinkedList<INetElement> linkedList2 = new LinkedList<INetElement>();
        if (dbg.on()) {
            Unprot2UpsrInServiceUpgradeMgr.debug("computeLOTRoutePrefs: computing route prefs for LOT");
        }
        if (this.prefs.getDiversityOption() == 1) {
            if (dbg.on()) {
                Unprot2UpsrInServiceUpgradeMgr.debug("computeLOTRoutePrefs: Nodal diversity required, calculating exclude nodes list");
            }
            object = new LinkedList();
            LinkedList linkedList3 = new LinkedList();
            this.cktInUpgrade.getOrderedNodeAndSpanList(null, null, (List)object, linkedList3);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                linkedList2.add(((NetCircuitNode)iterator.next()).getNetElement());
            }
            linkedList2.remove(this.srcNetElem);
            linkedList2.remove(this.dstNetElem);
        }
        object = this.computeRoutePrefs(this.srcNetElem, this.dstNetElem, new LinkedList(), list, linkedList, linkedList2);
        return object;
    }

    private void dispose() {
        if (this.disposed) {
            return;
        }
        if (dbg.on()) {
            Unprot2UpsrInServiceUpgradeMgr.debug("dispose: disposing ISTU object");
        }
        this.cktInUpgrade.setCktOperation(0);
        this.connCreators.clear();
        this.connConverters.clear();
        this.allCktLinks.clear();
        this.allCktNetElems.clear();
        this.newLinkSpans.clear();
        this.activeCktSpans.clear();
        this.routedCktSpans.clear();
        this.disposed = true;
    }

    private void printAllCircuits(String string) {
        if (dbg.on()) {
            Unprot2UpsrInServiceUpgradeMgr.debug(string + ": all circuit links:");
            Iterator iterator = this.allCktLinks.iterator();
            while (iterator.hasNext()) {
                INetLink iNetLink = (INetLink)iterator.next();
                Unprot2UpsrInServiceUpgradeMgr.debug(string + ": => " + iNetLink.prettyString());
            }
        }
    }

    private class UpgradeActionClient
    implements IActionClient {
        JobStatus jobStatus = new JobStatus();
        String resultMsg = "";

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doAction() {
            try {
                if (InServiceUpgradeMgr.dbg.on()) {
                    InServiceUpgradeMgr.debug("doAction: beginning upgrade using internalthread");
                }
                if (Unprot2UpsrInServiceUpgradeMgr.this.cktInUpgrade.isCircuitProtected()) {
                    this.resultMsg = "Reset circuit state to ACTIVE for circuit " + Unprot2UpsrInServiceUpgradeMgr.this.cktInUpgrade.getCircuitName();
                    if (InServiceUpgradeMgr.dbg.on()) {
                        InServiceUpgradeMgr.debug("doAction: circuit already protected, returning");
                    }
                    Unprot2UpsrInServiceUpgradeMgr.this.asyncObserver.asyncUpdate(null, new JobStatus(5, (Object)this.resultMsg));
                    return;
                }
                if (Unprot2UpsrInServiceUpgradeMgr.this.cktInUpgrade.getCircuitType() == 3 || Unprot2UpsrInServiceUpgradeMgr.this.cktInUpgrade.getCircuitType() == 6) {
                    this.resultMsg = "Successfully created new alternate path Tunnel for " + Unprot2UpsrInServiceUpgradeMgr.this.cktInUpgrade.getCircuitName();
                    if (Unprot2UpsrInServiceUpgradeMgr.this.autoRoute) {
                        LinkedList<INetLink> linkedList = new LinkedList<INetLink>();
                        Iterator iterator = Unprot2UpsrInServiceUpgradeMgr.this.newLinkSpans.iterator();
                        while (iterator.hasNext()) {
                            INetLinkSpan iNetLinkSpan = (INetLinkSpan)iterator.next();
                            linkedList.add(iNetLinkSpan.getLink());
                        }
                        Unprot2UpsrInServiceUpgradeMgr.this.upgradeLoTunnel(linkedList);
                        Unprot2UpsrInServiceUpgradeMgr.this.asyncObserver.asyncUpdate(null, new JobStatus(4, (Object)this.resultMsg));
                        return;
                    }
                    Unprot2UpsrInServiceUpgradeMgr.this.newLinkSpans.clear();
                    if (InServiceUpgradeMgr.dbg.on()) {
                        InServiceUpgradeMgr.debug("doAction: circuit manually routed");
                    }
                    Unprot2UpsrInServiceUpgradeMgr.this.newLinkSpans.addAll(Unprot2UpsrInServiceUpgradeMgr.this.findAlternatePathFromCircuit());
                    LinkedList<INetLink> linkedList = new LinkedList<INetLink>();
                    Iterator iterator = Unprot2UpsrInServiceUpgradeMgr.this.newLinkSpans.iterator();
                    while (iterator.hasNext()) {
                        INetLinkSpan iNetLinkSpan = (INetLinkSpan)iterator.next();
                        linkedList.add(iNetLinkSpan.getLink());
                    }
                    Unprot2UpsrInServiceUpgradeMgr.this.upgradeLoTunnel(linkedList);
                    Unprot2UpsrInServiceUpgradeMgr.this.asyncObserver.asyncUpdate(null, new JobStatus(4, (Object)this.resultMsg));
                    return;
                }
                if (Unprot2UpsrInServiceUpgradeMgr.this.state == InServiceUpgradeState.PENDING_CREATE) {
                    if (Unprot2UpsrInServiceUpgradeMgr.this.autoRoute) {
                        if (InServiceUpgradeMgr.dbg.on()) {
                            InServiceUpgradeMgr.debug("doAction: automatic routing required");
                        }
                        if (Unprot2UpsrInServiceUpgradeMgr.this.newLinkSpans.isEmpty()) {
                            Unprot2UpsrInServiceUpgradeMgr.this.calculateAlternatePath();
                        }
                        try {
                            Unprot2UpsrInServiceUpgradeMgr.this.cktInUpgrade.sanityCheck();
                        }
                        catch (SanityCheckFailed sanityCheckFailed) {
                            Unprot2UpsrInServiceUpgradeMgr.this.cancelUpgrade();
                            Unprot2UpsrInServiceUpgradeMgr.this.handleFatalException(sanityCheckFailed);
                        }
                        Unprot2UpsrInServiceUpgradeMgr.this.findAlternatePath();
                    } else {
                        Unprot2UpsrInServiceUpgradeMgr.this.newLinkSpans.clear();
                        if (InServiceUpgradeMgr.dbg.on()) {
                            InServiceUpgradeMgr.debug("doAction: circuit manually routed");
                        }
                        Unprot2UpsrInServiceUpgradeMgr.this.newLinkSpans.addAll(Unprot2UpsrInServiceUpgradeMgr.this.findAlternatePathFromCircuit());
                    }
                    try {
                        Unprot2UpsrInServiceUpgradeMgr.this.createConnectionOperators(Unprot2UpsrInServiceUpgradeMgr.this.newLinkSpans);
                        Unprot2UpsrInServiceUpgradeMgr.this.createConnCreationModels();
                        Unprot2UpsrInServiceUpgradeMgr.this.createSrcConnConvModel();
                        Unprot2UpsrInServiceUpgradeMgr.this.convertExistingOnewayConnsToTwoway();
                        Unprot2UpsrInServiceUpgradeMgr.this.createConnConvModels();
                    }
                    catch (InServiceUpgradeError inServiceUpgradeError) {
                        Unprot2UpsrInServiceUpgradeMgr.this.cancelUpgrade();
                        Unprot2UpsrInServiceUpgradeMgr.this.handleFatalException(inServiceUpgradeError);
                    }
                    catch (CTCUserException cTCUserException) {
                        Unprot2UpsrInServiceUpgradeMgr.this.cancelUpgrade();
                        Unprot2UpsrInServiceUpgradeMgr.this.handleFatalException((Exception)((Object)cTCUserException));
                    }
                    catch (AbstractCmsIOException abstractCmsIOException) {
                        Unprot2UpsrInServiceUpgradeMgr.this.cancelUpgrade();
                        Unprot2UpsrInServiceUpgradeMgr.this.handleFatalException((Exception)((Object)abstractCmsIOException));
                    }
                    Unprot2UpsrInServiceUpgradeMgr.this.convertConnConvModels();
                    Unprot2UpsrInServiceUpgradeMgr.this.updateNodeConnectionPaths();
                    Unprot2UpsrInServiceUpgradeMgr.this.mergeCircuits();
                    Unprot2UpsrInServiceUpgradeMgr.this.cancelConnConvModels();
                } else if (Unprot2UpsrInServiceUpgradeMgr.this.state == InServiceUpgradeState.PENDING_UPGRADE) {
                    Unprot2UpsrInServiceUpgradeMgr.this.getConnConvModels();
                    Unprot2UpsrInServiceUpgradeMgr.this.getCircuitsFromSourceConnConvModel();
                    Unprot2UpsrInServiceUpgradeMgr.this.convertConnConvModels();
                    Unprot2UpsrInServiceUpgradeMgr.this.updateNodeConnectionPaths();
                    Unprot2UpsrInServiceUpgradeMgr.this.mergeCircuits();
                    Unprot2UpsrInServiceUpgradeMgr.this.cancelConnConvModels();
                } else if (Unprot2UpsrInServiceUpgradeMgr.this.state == InServiceUpgradeState.COMPLETE) {
                    Unprot2UpsrInServiceUpgradeMgr.this.getConnConvModels();
                    Unprot2UpsrInServiceUpgradeMgr.this.getCircuitsFromSourceConnConvModel();
                    Unprot2UpsrInServiceUpgradeMgr.this.mergeCircuits();
                    Unprot2UpsrInServiceUpgradeMgr.this.cancelConnConvModels();
                }
                this.resultMsg = "Successfully upgraded " + Unprot2UpsrInServiceUpgradeMgr.this.cktInUpgrade.getCircuitName() + " from unprotected to " + Unprot2UpsrInServiceUpgradeMgr.this.UPSR_TERM;
                Unprot2UpsrInServiceUpgradeMgr.this.asyncObserver.asyncUpdate(null, new JobStatus(4, (Object)this.resultMsg));
            }
            catch (Exception exception) {
                InServiceUpgradeMgr.debug("doAction: caught FATAL EXCEPTION => " + exception.getMessage());
                SDebug.printStackTrace((Throwable)exception);
                Unprot2UpsrInServiceUpgradeMgr.this.asyncObserver.asyncUpdate((Object)exception, new JobStatus(2, (Object)exception));
            }
            finally {
                this.dispose();
            }
        }

        public void dispose() {
            if (Unprot2UpsrInServiceUpgradeMgr.this.disposed) {
                return;
            }
            if (InServiceUpgradeMgr.dbg.on()) {
                InServiceUpgradeMgr.debug("dispose: UpgradeActionClient disposed");
            }
            Unprot2UpsrInServiceUpgradeMgr.this.dispose();
        }

        public void failedAction(IThreadWorker iThreadWorker) {
        }
    }

    class ConnectionCreator {
        private INetElement ne;
        private INetLinkSpan srcLinkSpan;
        private INetLinkSpan dstLinkSpan;
        private INetCircuit newCircuit;
        SDebug dbg;

        public ConnectionCreator(INetElement iNetElement) {
            this.dbg = new SDebug("ConnectionCreator_" + iNetElement.getHostName());
            if (InServiceUpgradeMgr.dbg.on()) {
                this.dbg.set(true);
            }
            if (this.dbg.on()) {
                this.dbg.println("creating new Connection Creator");
            }
            this.ne = iNetElement;
        }

        public ConnectionCreator(INetCircuit iNetCircuit) {
            this.ne = iNetCircuit.getSrcCircuitNode().getNetElement();
            this.newCircuit = iNetCircuit;
            this.dbg = new SDebug("ConnectionCreator_" + this.ne.getHostName());
            if (InServiceUpgradeMgr.dbg.on()) {
                this.dbg.set(true);
            }
            if (this.dbg.on()) {
                this.dbg.println("creating new Connection Creator");
            }
        }

        public void setSrcLinkSpan(INetLinkSpan iNetLinkSpan) {
            this.srcLinkSpan = iNetLinkSpan;
            if (this.dbg.on()) {
                this.dbg.println("setSrcLinkSpan: NE " + this.ne.getHostName() + " => " + iNetLinkSpan.prettyString());
            }
        }

        public void setDstLinkSpan(INetLinkSpan iNetLinkSpan) {
            this.dstLinkSpan = iNetLinkSpan;
            if (this.dbg.on()) {
                this.dbg.println("setDstLinkSpan: NE " + this.ne.getHostName() + " => " + iNetLinkSpan.prettyString());
            }
        }

        public INetCircuit create() throws InServiceUpgradeError {
            if (this.srcLinkSpan == null || this.dstLinkSpan == null) {
                if (this.dbg.on()) {
                    InServiceUpgradeMgr.debug("create: src/dst link span is null, aborting");
                }
                throw new InServiceUpgradeError("Protect path not fully specified");
            }
            Unprot2UpsrInServiceUpgradeMgr.this.newCktCounter++;
            NetCircuitEnd netCircuitEnd = new NetCircuitEnd(this.ne.getNodeId(), this.srcLinkSpan.getLink().getDstEntityIndex(), this.srcLinkSpan.getDstHoNum(), this.srcLinkSpan.getLoNum(), false);
            CircuitCreatInfo circuitCreatInfo = Unprot2UpsrInServiceUpgradeMgr.this.createCircuitCreateInfo();
            this.newCircuit = (NetCcatCircuit)NetCircuitFactory.newCircuit(circuitCreatInfo, netCircuitEnd);
            ISelectorAttrsOpt iSelectorAttrsOpt = Unprot2UpsrInServiceUpgradeMgr.this.connAttrs.getSelectorAttrsOpt();
            this.newCircuit.setUpsrSelectorAttributes(iSelectorAttrsOpt.getHoUpsrAttributes().getUpsrReversion(), iSelectorAttrsOpt.getHoUpsrAttributes().getUpsrSfBerLevel(), iSelectorAttrsOpt.getHoUpsrAttributes().getUpsrSdBerLevel(), iSelectorAttrsOpt.getHoUpsrAttributes().getUpsrSwitchOnPdiP());
            NetCircuitEnd netCircuitEnd2 = new NetCircuitEnd(this.ne.getNodeId(), this.dstLinkSpan.getLink().getSrcEntityIndex(), this.dstLinkSpan.getSrcHoNum(), this.dstLinkSpan.getLoNum(), false);
            try {
                this.newCircuit.addDrop(netCircuitEnd2, new RoutePrefs());
                this.newCircuit.sanityCheck();
                this.newCircuit.provision();
                if (this.dbg.on()) {
                    InServiceUpgradeMgr.debug("createNewCircuit: created new circuit " + this.newCircuit.getCircuitName() + ", ckt ID => " + NetCircuit.prettyString(this.newCircuit.getCircuitId()));
                }
                return this.newCircuit;
            }
            catch (CTCUserException cTCUserException) {
                throw new InServiceUpgradeError((Exception)((Object)cTCUserException));
            }
            catch (CircuitDropOutstanding circuitDropOutstanding) {
                throw new InServiceUpgradeError(circuitDropOutstanding);
            }
            catch (SanityCheckFailed sanityCheckFailed) {
                throw new InServiceUpgradeError(sanityCheckFailed);
            }
            catch (ConnTypeUnsupported connTypeUnsupported) {
                throw new InServiceUpgradeError(connTypeUnsupported);
            }
            catch (IncorrectCircuitState incorrectCircuitState) {
                throw new InServiceUpgradeError(incorrectCircuitState);
            }
            catch (CircuitProvError circuitProvError) {
                throw new InServiceUpgradeError(circuitProvError);
            }
            catch (AnnotatedException annotatedException) {
                throw new InServiceUpgradeError((Exception)((Object)annotatedException));
            }
        }

        public INetCircuit getNewCircuit() {
            return this.newCircuit;
        }

        public String prettyString() {
            return "NE => " + this.ne.getHostName() + "\n    " + (this.srcLinkSpan != null ? this.srcLinkSpan.prettyString() + "\n" : "") + (this.dstLinkSpan != null ? this.dstLinkSpan.prettyString() + "\n" : "");
        }
    }

    class ConnectionConverter {
        INetElement ne;
        NetCircuitNode cktNode;
        List linkSpans;
        boolean isOnewayUpgrade;
        NetCircuit originalCkt;
        List newCktIdList;
        int originalConnType;
        int newConnType;
        boolean destroyOnCompletion;
        boolean isMasterNode;
        InServiceUpgradeState state;
        List newPathDefs;
        boolean destroyed = false;
        boolean circuitSource = false;
        SDebug dbg;

        public ConnectionConverter(INetElement iNetElement) {
            this.ne = iNetElement;
            this.dbg = new SDebug("ConnectionConverter_" + iNetElement.getHostName());
            if (InServiceUpgradeMgr.dbg.on()) {
                this.dbg.set(true);
            }
            this.linkSpans = new LinkedList();
            this.newCktIdList = new LinkedList();
            this.newPathDefs = new LinkedList();
            this.newConnType = -1;
            this.cktNode = (NetCircuitNode)Unprot2UpsrInServiceUpgradeMgr.this.cktInUpgrade.getCircuitNodeFromNE(iNetElement);
            this.originalConnType = this.cktNode.getConnectionType();
            if (iNetElement.equals(Unprot2UpsrInServiceUpgradeMgr.this.masterNode.getNetElement())) {
                if (this.dbg.on()) {
                    this.dbg.println("creating new Connection Converter for Master Node");
                }
                this.destroyOnCompletion = false;
                this.isMasterNode = true;
                this.state = InServiceUpgradeState.PENDING_CREATE;
                this.circuitSource = true;
            } else {
                if (this.dbg.on()) {
                    this.dbg.println("creating new Connection Converter");
                }
                this.destroyOnCompletion = true;
                this.isMasterNode = false;
                this.state = InServiceUpgradeState.PENDING_UPGRADE;
            }
        }

        public ConnectionConverter(INetElement iNetElement, int n) {
            this(iNetElement);
            this.newConnType = n;
        }

        public void addLinkSpan(INetLinkSpan iNetLinkSpan) {
            if (this.dbg.on()) {
                this.dbg.println("addLinkSpan: " + iNetLinkSpan.prettyString());
            }
            this.linkSpans.add(iNetLinkSpan);
        }

        public void create() throws CTCUserException {
            Iterator iterator;
            Object object;
            IConnectionConversionModel iConnectionConversionModel;
            if (this.dbg.on()) {
                this.dbg.println("create: creating new Conn Conv Model for cktNode " + this.ne.getHostName());
            }
            if ((iConnectionConversionModel = this.cktNode.getConnConvModel()) != null) {
                if (this.dbg.on()) {
                    this.dbg.println("create: Conn Conv Model already exists");
                }
                return;
            }
            this.addRoutedSpans();
            if (this.circuitSource) {
                object = Unprot2UpsrInServiceUpgradeMgr.this.getNewCircuits().iterator();
                while (object.hasNext()) {
                    iterator = (INetCircuit)object.next();
                    this.newCktIdList.add(iterator.getCircuitId());
                }
            }
            if (this.newConnType == -1) {
                this.newConnType = this.cktNode.calculateConnectionType(this.dbg);
            }
            if (this.newConnType == -1) {
                if (this.dbg.on()) {
                    this.dbg.println("create: Invalid new ConnType, quitting");
                }
                throw new CTCUserException("Invalid connection type on " + this.ne.getHostName());
            }
            object = this.cktNode.getPathList();
            try {
                this.newPathDefs = (LinkedList)this.cktNode.getOrderedPathDefs(this.newConnType, Unprot2UpsrInServiceUpgradeMgr.this.goReturnTrafficDir, this.dbg);
                if (this.dbg.on()) {
                    IPathDefModel iPathDefModel;
                    this.dbg.println("create: " + (Unprot2UpsrInServiceUpgradeMgr.this.goReturnTrafficDir ? "Go Return Path:" : "Unidirectional Path:"));
                    this.dbg.println("create: Original Path List:");
                    iterator = object.iterator();
                    while (iterator.hasNext()) {
                        iPathDefModel = (IPathDefModel)iterator.next();
                        this.dbg.println("create:    path Def => " + this.cktNode.prettyString(iPathDefModel));
                    }
                    this.dbg.println("create: New Path List:");
                    iterator = this.newPathDefs.iterator();
                    while (iterator.hasNext()) {
                        iPathDefModel = (IPathDefModel)iterator.next();
                        this.dbg.println("create:     path Def => " + this.cktNode.prettyString(iPathDefModel));
                    }
                }
                this.cktNode.createConnConvModel(0, this.state, Unprot2UpsrInServiceUpgradeMgr.this.cktInUpgrade.getCircuitId(), this.newCktIdList, this.originalConnType, this.newConnType, (List)object, this.newPathDefs, Unprot2UpsrInServiceUpgradeMgr.this.connAttrs, this.destroyOnCompletion, this.isMasterNode);
            }
            catch (CTCUserException cTCUserException) {
                if (this.dbg.on()) {
                    this.dbg.println("create: caught exception => " + cTCUserException.getMessage());
                }
                if (cTCUserException instanceof NoMoreVtCapableSts) {
                    ((NoMoreVtCapableSts)((Object)cTCUserException)).setNodeName(this.cktNode.getName());
                } else if (cTCUserException instanceof NoMoreLoCapableHo) {
                    ((NoMoreLoCapableHo)cTCUserException).setNodeName(this.cktNode.getName());
                }
                throw cTCUserException;
            }
        }

        public void convert() throws InServiceUpgradeError {
            if (this.destroyed) {
                return;
            }
            IConnectionConversionModel iConnectionConversionModel = this.cktNode.getConnConvModel();
            if (iConnectionConversionModel != null) {
                if (this.dbg.on()) {
                    this.dbg.println("convert: converting Conn Conv Model for cktNode " + this.cktNode.getNetElement().getHostName());
                    this.dbg.println("convert: old conn type => " + EnumStrings.getString((Class)(class$cerent$cms$model$IConnectionType == null ? (class$cerent$cms$model$IConnectionType = Unprot2UpsrInServiceUpgradeMgr.class$("cerent.cms.model.IConnectionType")) : class$cerent$cms$model$IConnectionType), (int)iConnectionConversionModel.getOriginalConnType()) + ", new conn type => " + EnumStrings.getString((Class)(class$cerent$cms$model$IConnectionType == null ? (class$cerent$cms$model$IConnectionType = Unprot2UpsrInServiceUpgradeMgr.class$("cerent.cms.model.IConnectionType")) : class$cerent$cms$model$IConnectionType), (int)iConnectionConversionModel.getNewConnType()));
                }
                try {
                    iConnectionConversionModel.convert();
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    this.dbg.println("convert: caught CommFail exception");
                    throw new InServiceUpgradeError("Connection upgrade failed on " + this.ne.getHostName() + " due to Communications " + "failure. Please try " + "again");
                }
                if (this.dbg.on()) {
                    this.dbg.println("convert: Conversion succeeded");
                }
            } else {
                if (this.dbg.on()) {
                    this.dbg.println("convert: ERROR - Conn Conv Model not found on " + this.cktNode.getNetElement().getHostName());
                }
                throw new InServiceUpgradeError("Connection Conversion Model is null");
            }
        }

        public void cancel() {
            IConnectionConversionModel iConnectionConversionModel;
            if (this.destroyed) {
                return;
            }
            if (this.dbg.on()) {
                this.dbg.println("cancel: cancelling Connection Conversion");
            }
            if ((iConnectionConversionModel = this.cktNode.getConnConvModel()) != null) {
                try {
                    iConnectionConversionModel.destroy();
                }
                catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                    if (this.dbg.on()) {
                        this.dbg.println("cancel: Conn Conv Model already destroyed on node");
                    }
                }
            } else if (this.dbg.on()) {
                this.dbg.println("cancel: Connection Conversion Model doesn't exist");
            }
            this.destroy();
        }

        private void addRoutedSpans() {
            if (this.destroyed) {
                return;
            }
            Iterator iterator = this.linkSpans.iterator();
            while (iterator.hasNext()) {
                INetLinkSpan iNetLinkSpan = (INetLinkSpan)iterator.next();
                if (Unprot2UpsrInServiceUpgradeMgr.this.cktInUpgrade.isBidirectional()) {
                    if (this.dbg.on()) {
                        this.dbg.println("addRoutedSpans: adding BI span => " + iNetLinkSpan.prettyString());
                    }
                    Unprot2UpsrInServiceUpgradeMgr.this.cktInUpgrade.addCircuitSpan((NetLinkSpan)iNetLinkSpan, this.cktNode, eSpanDirection.BIDIRECTIONAL);
                    continue;
                }
                if (iNetLinkSpan.getLink().getSrc().equals(this.ne)) {
                    if (this.dbg.on()) {
                        this.dbg.println("addRoutedSpans: adding ORIG span => " + iNetLinkSpan.prettyString());
                    }
                    Unprot2UpsrInServiceUpgradeMgr.this.cktInUpgrade.addCircuitSpan((NetLinkSpan)iNetLinkSpan, this.cktNode, eSpanDirection.ORIGINATING);
                    continue;
                }
                if (this.dbg.on()) {
                    this.dbg.println("addRoutedSpans: adding TERM span => " + iNetLinkSpan.prettyString());
                }
                Unprot2UpsrInServiceUpgradeMgr.this.cktInUpgrade.addCircuitSpan((NetLinkSpan)iNetLinkSpan, this.cktNode, eSpanDirection.TERMINATING);
            }
        }

        public NetCircuitNode getCktNode() {
            return this.cktNode;
        }

        public List getNewPathDefs() {
            return this.newPathDefs;
        }

        public void destroy() {
            if (this.dbg.on()) {
                this.dbg.println("destroy: destroying Connection Converter");
            }
            this.dbg.dispose();
            this.linkSpans.clear();
            this.newCktIdList.clear();
            this.newPathDefs.clear();
            this.cktNode = null;
            this.originalCkt = null;
            this.ne = null;
            this.destroyed = true;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ConnectionConverter)) {
                return false;
            }
            ConnectionConverter connectionConverter = (ConnectionConverter)object;
            return this.cktNode.areNodesEqual(connectionConverter.getCktNode());
        }

        public String prettyString() {
            String string = "NE => " + this.ne.getHostName();
            Iterator iterator = this.linkSpans.iterator();
            while (iterator.hasNext()) {
                INetLinkSpan iNetLinkSpan = (INetLinkSpan)iterator.next();
                string = string + "\n    " + iNetLinkSpan.prettyString();
            }
            return string;
        }
    }
}

