/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ocm;

import cerent.cms.model.AllocFailed;
import cerent.cms.model.Busy;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOhChannel;
import cerent.cms.model.IOhCircuitEnd;
import cerent.cms.model.IOhCircuitInfo;
import cerent.cms.model.IOhCircuitModel;
import cerent.cms.model.IOhConnectionModel;
import cerent.cms.model.IOhTermModel;
import cerent.cms.model.IOhXconModel;
import cerent.cms.model.InvalidOhTerm;
import cerent.cms.model.InvalidOhXcon;
import cerent.cms.model.InvalidUdcRate;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.OhCircuitEnd;
import cerent.cms.model.OhMaxConnections;
import cerent.cms.model.OwCircuitInfo;
import cerent.cms.model.PCMCoding;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ResourceInUse;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ocm.OhCircuit;
import cerent.cms.ocm.OhNetCircuitEnd;
import cerent.cms.ocm.OwLoopFoundException;
import cerent.cms.route.NoRoute;
import cerent.cms.topo.INetLink;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Set;
import java.util.TreeSet;

public class OwCircuit
extends OhCircuit {
    private static final SDebug db = new SDebug("OwCircuit");
    private int circuitPCMCoding;
    private boolean circuitPCMCodingInitiated;

    public OwCircuit(IOhCircuitInfo iOhCircuitInfo) throws AnnotatedException {
        super(iOhCircuitInfo);
    }

    protected void createOhCircuitInfoIfce(IOhCircuitInfo iOhCircuitInfo) throws CircuitProvError {
        this.circuitPCMCoding = ((OwCircuitInfo)iOhCircuitInfo).getPCMCoding();
        this.circuitPCMCodingInitiated = true;
        if (this.dbgOn()) {
            db.fine("createOhCircuitInfoIfce - circuit PCM coding is set to " + PCMCoding.getPCMCodingObj((int)this.circuitPCMCoding).getName());
        }
        super.createOhCircuitInfoIfce(iOhCircuitInfo);
    }

    protected boolean addConnection(IOhConnectionModel iOhConnectionModel) {
        boolean bl = super.addConnection(iOhConnectionModel);
        if (bl && iOhConnectionModel instanceof IOhTermModel) {
            this.handleTermPCMCoding((IOhTermModel)iOhConnectionModel);
        }
        return bl;
    }

    public OwCircuit(IOhConnectionModel iOhConnectionModel) {
        super(iOhConnectionModel);
    }

    public OwCircuit(IOhCircuitModel iOhCircuitModel) {
        super(iOhCircuitModel);
    }

    public void addDestination(IOhCircuitEnd iOhCircuitEnd) throws IncorrectCircuitState, CircuitProvError, NoRoute, AllocFailed, ResourceInUse, OhMaxConnections, Busy, DeletionError, InvalidOhTerm, InvalidOhXcon, OwLoopFoundException, InvalidUdcRate, ProvisionError {
        if (!this.isCircuitRefValid()) {
            throw new IncorrectCircuitState("Circuit already destroyed");
        }
        if (this.getState() != 1) {
            throw new IncorrectCircuitState("Destination can be added only for circuits in state DISCOVERED");
        }
        if (!this.getCircuitTypeObj().isOwCircuitType()) {
            throw new IllegalStateException("Only orderwire circuits can have more than 1 destinations.");
        }
        if (this.dbgOn()) {
            db.fine("drops.add(" + iOhCircuitEnd + ")");
        }
        this.setState(11);
        Integer n = new Integer(iOhCircuitEnd.getNodeId());
        if (this.manager.getOwLoopPrevention(this.getCircuitType()).formingLoop(this, n)) {
            throw new OwLoopFoundException("A loop will be formed by adding this destination.");
        }
        Set set = (Set)this.connModelMap.get(n);
        if (set != null) {
            this.owTurnXcons2Terms((IOhXconModel)set.iterator().next(), iOhCircuitEnd);
            this.addDestinationIntoCktInfoIfce(iOhCircuitEnd);
            return;
        }
        ArrayList<OhNetCircuitEnd> arrayList = new ArrayList<OhNetCircuitEnd>(this.getDestinations());
        arrayList.add(0, this.getSource());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            INetLink[] iNetLinkArray;
            IOhCircuitEnd iOhCircuitEnd2 = (IOhCircuitEnd)iterator.next();
            if (this.calcTermNumber(iOhCircuitEnd2.getNodeId()) >= 4) continue;
            try {
                iNetLinkArray = this.routeDestination(iOhCircuitEnd2, iOhCircuitEnd, this.getCircuitType());
            }
            catch (NoRoute noRoute) {
                continue;
            }
            this.createConnections(iOhCircuitEnd2, iOhCircuitEnd, this.getCircuitType(), iNetLinkArray);
            this.addDestinationIntoCktInfoIfce(iOhCircuitEnd);
            return;
        }
        throw new NoRoute("No route found");
    }

    private void owTurnXcons2Terms(IOhXconModel iOhXconModel, IOhCircuitEnd iOhCircuitEnd) throws OhMaxConnections, DeletionError, ResourceInUse, CircuitProvError, Busy, InvalidOhTerm, InvalidOhXcon, InvalidUdcRate, ProvisionError {
        int n = iOhCircuitEnd.getNodeId();
        ArrayList<IOhConnectionModel> arrayList = new ArrayList<IOhConnectionModel>();
        IOhChannel iOhChannel = iOhXconModel.getOhXcon().getA();
        IOhChannel iOhChannel2 = iOhXconModel.getOhXcon().getB();
        this.destroyConnection((IOhConnectionModel)iOhXconModel);
        arrayList.add(this.createConnection(new OhCircuitEnd(n, iOhChannel.getPortIndex()), iOhCircuitEnd, this.getCircuitType(), false, true));
        arrayList.add(this.createConnection(iOhCircuitEnd, new OhCircuitEnd(n, iOhChannel2.getPortIndex()), this.getCircuitType(), true, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int calcTermNumber(int n) {
        Set set;
        int n2 = 0;
        Set set2 = set = (Set)this.connModelMap.get(new Integer(n));
        synchronized (set2) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                if (!(iterator.next() instanceof IOhTermModel)) continue;
                ++n2;
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDestinationIntoCktInfoIfce(IOhCircuitEnd iOhCircuitEnd) throws CircuitProvError {
        INodeModel iNodeModel;
        if (this.dbgOn()) {
            db.fine("addDestinationIntoCktInfoIfce: dst = " + iOhCircuitEnd);
        }
        if ((iNodeModel = net.getNodeModel(this.getSource().getNodeId())) == null) {
            throw new CircuitProvError("Can't find the source node");
        }
        OwCircuit owCircuit = this;
        synchronized (owCircuit) {
            this.circuitModel.addDestination(iOhCircuitEnd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteDestinationIntoCktInfoIfce(IOhCircuitEnd iOhCircuitEnd) throws CircuitProvError {
        INodeModel iNodeModel;
        if (this.dbgOn()) {
            db.fine("deleteDestinationIntoCktInfoIfce: dst = " + iOhCircuitEnd);
        }
        if ((iNodeModel = net.getNodeModel(this.getSource().getNodeId())) == null) {
            throw new CircuitProvError("Can't find the source node");
        }
        OwCircuit owCircuit = this;
        synchronized (owCircuit) {
            this.circuitModel.delDestination(iOhCircuitEnd);
        }
    }

    protected boolean foundAllPaths() {
        ArrayList arrayList = new ArrayList();
        TreeSet treeSet = new TreeSet();
        treeSet.addAll(this.getDestinations());
        TreeSet treeSet2 = new TreeSet(treeSet);
        TreeSet<OhNetCircuitEnd> treeSet3 = new TreeSet<OhNetCircuitEnd>();
        treeSet3.add(this.getSource());
        while (!treeSet2.isEmpty()) {
            if (treeSet3.isEmpty()) {
                return false;
            }
            IOhCircuitEnd iOhCircuitEnd = (IOhCircuitEnd)treeSet3.first();
            treeSet3.remove(iOhCircuitEnd);
            TreeSet treeSet4 = this.getEndsHavingPath(iOhCircuitEnd, treeSet2, arrayList);
            treeSet3.addAll(treeSet4);
        }
        this.spanList = arrayList;
        return true;
    }

    private TreeSet getEndsHavingPath(IOhCircuitEnd iOhCircuitEnd, TreeSet treeSet, List list) {
        TreeSet<IOhCircuitEnd> treeSet2 = new TreeSet<IOhCircuitEnd>();
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            IOhCircuitEnd iOhCircuitEnd2 = (IOhCircuitEnd)iterator.next();
            List list2 = this.getPathLinks(iOhCircuitEnd, iOhCircuitEnd2);
            if (list2 == null) continue;
            list.addAll(list2);
            treeSet2.add(iOhCircuitEnd2);
            iterator.remove();
        }
        return treeSet2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDestinations(Set set) throws IncorrectCircuitState, CircuitProvError, NoRoute, AllocFailed, ResourceInUse, OhMaxConnections, Busy, DeletionError, InvalidOhTerm, InvalidOhXcon, OwLoopFoundException, InvalidUdcRate, ProvisionError {
        Set set2 = this.getOhCircuitEndsFromNodeModels(set);
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            try {
                this.addDestination((IOhCircuitEnd)iterator.next());
            }
            finally {
                this.completeCheck();
                this.circuitChanged();
            }
        }
    }

    protected IOhConnectionModel createConnection(IOhCircuitEnd iOhCircuitEnd, IOhCircuitEnd iOhCircuitEnd2, int n, boolean bl, boolean bl2) throws InvalidOhTerm, InvalidOhXcon, Busy, CircuitProvError, ResourceInUse, OhMaxConnections, InvalidUdcRate, ProvisionError {
        IOhConnectionModel iOhConnectionModel = super.createConnection(iOhCircuitEnd, iOhCircuitEnd2, n, bl, bl2);
        if (iOhConnectionModel instanceof IOhTermModel) {
            this.handleTermPCMCoding((IOhTermModel)iOhConnectionModel);
        }
        return iOhConnectionModel;
    }

    private void handleTermPCMCoding(IOhTermModel iOhTermModel) {
        int n = iOhTermModel.getOwTermPCMCoding();
        if (!this.circuitPCMCodingInitiated) {
            this.circuitPCMCoding = n;
            this.circuitPCMCodingInitiated = true;
            if (this.dbgOn()) {
                db.fine("handleTermPCMCoding - ckt PCM coding is set to " + PCMCoding.getPCMCodingObj((int)this.circuitPCMCoding).getName());
            }
        } else if (n != this.circuitPCMCoding) {
            if (iOhTermModel.supportOwTermPCMCoding(this.circuitPCMCoding)) {
                iOhTermModel.setOwTermPCMCoding(this.circuitPCMCoding);
                if (this.dbgOn()) {
                    db.fine("handleTermPCMCoding - connection PCM coding is set to " + PCMCoding.getPCMCodingObj((int)this.circuitPCMCoding).getName());
                }
            } else {
                this.changeCircuitPCMCoding(n);
            }
        }
    }

    public boolean supportPCMCoding(int n) {
        Iterator iterator = this.getConnections().iterator();
        while (iterator.hasNext()) {
            IOhConnectionModel iOhConnectionModel = (IOhConnectionModel)iterator.next();
            if (!(iOhConnectionModel instanceof IOhTermModel)) continue;
            IOhTermModel iOhTermModel = (IOhTermModel)iOhConnectionModel;
            if (((IOhTermModel)iOhConnectionModel).supportOwTermPCMCoding(n)) continue;
            return false;
        }
        return true;
    }

    public void changeCircuitPCMCoding(int n) {
        if (this.dbgOn()) {
            db.fine("Change the circuit PCM Coding from " + this.circuitPCMCoding + " to " + n);
        }
        if (!this.circuitPCMCodingInitiated) {
            throw new IllegalStateException("Circuit PCM coding not set yet");
        }
        this.circuitPCMCoding = n;
        Iterator iterator = this.getConnections().iterator();
        while (iterator.hasNext()) {
            IOhTermModel iOhTermModel;
            IOhConnectionModel iOhConnectionModel = (IOhConnectionModel)iterator.next();
            if (iOhConnectionModel instanceof IOhXconModel || (iOhTermModel = (IOhTermModel)iOhConnectionModel).getOwTermPCMCoding() == n) continue;
            iOhTermModel.setOwTermPCMCoding(n);
        }
    }

    protected synchronized void completeCheck() {
        int n = this.getState();
        super.completeCheck();
        if (this.getState() == 11) {
            this.setState(4);
        }
        if (this.dbgOn()) {
            db.fine("oldState=" + n + ", newState=" + this.getState());
        }
    }

    private Set getOhCircuitEndsFromNodeModels(Set set) {
        if (set.isEmpty()) {
            return set;
        }
        TreeSet<IOhCircuitEnd> treeSet = new TreeSet<IOhCircuitEnd>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            INodeModel iNodeModel = (INodeModel)iterator.next();
            if (iNodeModel == null) continue;
            treeSet.add(this.getOhCircuitEndFromNodeModel(iNodeModel));
        }
        if (this.dbgOn()) {
            db.fine("nodeModelSet=" + set + ", dstEndSet=" + treeSet);
        }
        return treeSet;
    }

    private IOhCircuitEnd getOhCircuitEndFromNodeModel(INodeModel iNodeModel) {
        return new OhCircuitEnd(iNodeModel.getNodeId(), this.getSource().getPort());
    }

    private IOhCircuitEnd getOhCircuitEndFromTermModel(IOhTermModel iOhTermModel) {
        return this.getOhCircuitEndFromNodeModel(iOhTermModel.getNodeModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDestinations(Set set) throws OhMaxConnections, DeletionError, ResourceInUse, CircuitProvError, Busy, InvalidOhTerm, InvalidOhXcon, InvalidUdcRate, ProvisionError {
        this.setState(11);
        Set set2 = this.getOhCircuitEndsFromNodeModels(set);
        try {
            while (!set2.isEmpty()) {
                TreeSet treeSet = this.getBranchesSet(set2);
                List list = (List)treeSet.first();
                if (list.size() > 2) {
                    throw new DeletionError("All remaining destinations have more than 2 children.");
                }
                IOhCircuitEnd iOhCircuitEnd = this.getOhCircuitEndFromTermModel((IOhTermModel)list.get(0));
                if (list.size() == 1) {
                    this.deletePath((IOhTermModel)list.get(0));
                } else {
                    this.owTurnTerms2Xcon((IOhTermModel)list.get(0), (IOhTermModel)list.get(1));
                }
                this.deleteDestinationIntoCktInfoIfce(iOhCircuitEnd);
                set2.remove(iOhCircuitEnd);
            }
        }
        finally {
            this.completeCheck();
            this.circuitChanged();
        }
    }

    private void deletePath(IOhTermModel iOhTermModel) throws DeletionError {
        if (this.dbgOn()) {
            db.fine("delete path for ohTerm = " + iOhTermModel);
        }
        ArrayList<IOhTermModel> arrayList = new ArrayList<IOhTermModel>();
        arrayList.add(iOhTermModel);
        IOhTermModel iOhTermModel2 = iOhTermModel;
        ArrayList arrayList2 = new ArrayList();
        while ((iOhTermModel2 = this.getNextConnection((IOhConnectionModel)iOhTermModel2, arrayList2, false)) != null) {
            arrayList.add(iOhTermModel2);
            if (!(iOhTermModel2 instanceof IOhTermModel)) continue;
        }
        if (this.dbgOn()) {
            db.fine("The path to delete is " + arrayList);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            IOhConnectionModel iOhConnectionModel = (IOhConnectionModel)iterator.next();
            if (this.dbgOn()) {
                db.fine("Delete connection " + iOhConnectionModel);
            }
            this.destroyConnection(iOhConnectionModel);
        }
    }

    private void owTurnTerms2Xcon(IOhTermModel iOhTermModel, IOhTermModel iOhTermModel2) throws OhMaxConnections, DeletionError, ResourceInUse, CircuitProvError, Busy, InvalidOhTerm, InvalidOhXcon, InvalidUdcRate, ProvisionError {
        if (iOhTermModel == null || iOhTermModel2 == null) {
            return;
        }
        int n = iOhTermModel.getNodeModel().getNodeId();
        int n2 = iOhTermModel.getOpticalPortIndex();
        int n3 = iOhTermModel2.getOpticalPortIndex();
        int n4 = iOhTermModel.getCircuitType();
        this.destroyConnection((IOhConnectionModel)iOhTermModel);
        this.destroyConnection((IOhConnectionModel)iOhTermModel2);
        this.createConnection(new OhCircuitEnd(n, n2), new OhCircuitEnd(n, n3), n4, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeSet getBranchesSet(Set set) {
        TreeSet treeSet = new TreeSet(new Comparator(){

            public int compare(Object object, Object object2) {
                List list = (List)object;
                List list2 = (List)object2;
                if (list.size() != list2.size()) {
                    return list.size() - list2.size();
                }
                IOhConnectionModel iOhConnectionModel = (IOhConnectionModel)list.get(0);
                IOhConnectionModel iOhConnectionModel2 = (IOhConnectionModel)list2.get(0);
                return iOhConnectionModel.getNodeModel().getNodeId() - iOhConnectionModel2.getNodeModel().getNodeId();
            }
        });
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Set set2;
            LinkedList<IOhConnectionModel> linkedList = new LinkedList<IOhConnectionModel>();
            IOhCircuitEnd iOhCircuitEnd = (IOhCircuitEnd)iterator.next();
            Set set3 = set2 = (Set)this.connModelMap.get(new Integer(iOhCircuitEnd.getNodeId()));
            synchronized (set3) {
                Iterator iterator2 = set2.iterator();
                while (iterator2.hasNext()) {
                    IOhConnectionModel iOhConnectionModel = (IOhConnectionModel)iterator2.next();
                    if (!(iOhConnectionModel instanceof IOhTermModel)) continue;
                    linkedList.add(iOhConnectionModel);
                }
            }
            treeSet.add(linkedList);
        }
        return treeSet;
    }

    public boolean isComplete() {
        return super.isComplete() || this.getState() == 10;
    }

    protected void setState(int n) {
        boolean bl = this.isComplete();
        super.setState(n);
        boolean bl2 = this.isComplete();
        if (bl != bl2) {
            if (bl2) {
                this.manager.getOwLoopPrevention(this.getCircuitType()).addCircuit(this);
            } else if (this.getCircuitType() != -1) {
                this.manager.getOwLoopPrevention(this.getCircuitType()).removeCircuit(this);
            } else {
                this.manager.getOwLoopPrevention(2).removeCircuit(this);
                this.manager.getOwLoopPrevention(3).removeCircuit(this);
            }
        }
    }

    public int getCircuitPCMCoding() {
        if (!this.circuitPCMCodingInitiated) {
            throw new IllegalStateException("Ckt PCM coding not initiated");
        }
        return this.circuitPCMCoding;
    }

    public void update(Observable observable, Object object) {
        IOhTermModel iOhTermModel;
        if (observable instanceof IOhTermModel && ((Integer)object).equals(ModelUpdateType.CHANGED) && this.circuitPCMCoding != (iOhTermModel = (IOhTermModel)observable).getOwTermPCMCoding()) {
            this.circuitPCMCoding = iOhTermModel.getOwTermPCMCoding();
            if (this.dbgOn()) {
                db.fine("update - circuit PCM coding is set to " + PCMCoding.getPCMCodingObj((int)this.circuitPCMCoding).getName());
            }
        }
        super.update(observable, object);
    }

    public boolean haveTerminationsInCircuit() {
        return this.getSource() != null && !this.getSource().isPortOptical() || this.getFirstDestination() != null && !this.getFirstDestination().isPortOptical();
    }
}

