/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ocm;

import cerent.cms.model.IOhCircuitInfo;
import cerent.cms.ocm.OhCircuit;
import cerent.cms.ocm.OhCircuitManager;
import cerent.cms.ocm.OhNetCircuitEnd;
import cerent.cms.ocm.OwCircuit;
import cerent.cms.ocm.OwLoopFoundException;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class OwLoopPrevention {
    private static final SDebug db = new SDebug("OwLoopPrevention");
    static final int ADD_CIRCUIT = 0;
    static final int MODIFY_CIRCUIT = 1;
    static final int DELETE_CIRCUIT = 2;
    private List owNodeSetList = new ArrayList();
    private OhCircuitManager manager;
    private int supportingType;

    public OwLoopPrevention(OhCircuitManager ohCircuitManager, int n) {
        this.manager = ohCircuitManager;
        this.supportingType = n;
        this.reCalculateNodeSets();
    }

    private void reCalculateNodeSets() {
        Object object;
        if (this.dbgOn()) {
            db.fine("Before recalculate: " + this.owNodeSetList);
        }
        this.owNodeSetList.clear();
        List[] listArray = this.manager.getDividedCircuitLists(this.supportingType);
        Object object2 = listArray[0].iterator();
        while (object2.hasNext()) {
            this.addCircuitNodes((OwCircuit)object2.next());
        }
        object2 = new ArrayList();
        object2.addAll(listArray[1]);
        object2.addAll(listArray[3]);
        object2.addAll(listArray[2]);
        List list = this.manager.getCircuitPathList(listArray, false);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (List)iterator.next();
            object2.removeAll((Collection<?>)object);
            this.addCircuitNodes((List)object);
        }
        iterator = object2.iterator();
        while (iterator.hasNext()) {
            object = (OhCircuit)iterator.next();
            if (((OhCircuit)object).getState() != 10) continue;
            ((OhCircuit)object).setState(1);
        }
        if (this.dbgOn()) {
            db.fine("After recalculate: " + this.owNodeSetList);
        }
    }

    private boolean addCircuitNodes(OwCircuit owCircuit) {
        if (owCircuit.isTerm2TermCircuit()) {
            try {
                this.addNodeSet(owCircuit.getCircuitEndNodes());
                if (owCircuit.getState() == 10) {
                    owCircuit.setState(1);
                }
                return true;
            }
            catch (OwLoopFoundException owLoopFoundException) {
                if (this.dbgOn()) {
                    db.fine("Fond loop on circuit " + owCircuit);
                }
                if (owCircuit.getState() == 1) {
                    owCircuit.setState(10);
                }
                return false;
            }
        }
        List list = this.manager.getCircuitPath(owCircuit);
        if (list == null) {
            return false;
        }
        return this.addCircuitNodes(list);
    }

    private boolean addCircuitNodes(List list) {
        OwCircuit owCircuit = (OwCircuit)list.get(0);
        OwCircuit owCircuit2 = (OwCircuit)list.get(list.size() - 1);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(new Integer(owCircuit.getSource().getNodeId()));
        hashSet.add(new Integer(owCircuit2.getFirstDestination().getNodeId()));
        try {
            this.addNodeSet(hashSet);
            if (owCircuit.getState() == 10) {
                owCircuit.setState(1);
            }
            if (owCircuit2.getState() == 10) {
                owCircuit2.setState(1);
            }
            return true;
        }
        catch (OwLoopFoundException owLoopFoundException) {
            if (this.dbgOn()) {
                db.fine("Fond loop on circuit " + owCircuit2);
            }
            if (owCircuit2.getState() == 1) {
                owCircuit2.setState(10);
            }
            return false;
        }
    }

    private void addNodeSet(Set set) throws OwLoopFoundException {
        Set set2;
        ArrayList<Set> arrayList = new ArrayList<Set>();
        if (this.dbgOn()) {
            db.fine("Call addNodeSet: newSet=" + set);
        }
        Iterator iterator = this.owNodeSetList.iterator();
        while (iterator.hasNext()) {
            int n;
            set2 = (Set)iterator.next();
            if (this.dbgOn()) {
                db.fine("owNodeSet=" + set2 + ", newNodeSet=" + set);
            }
            if ((n = OwLoopPrevention.numOfCommonElements(set2, set)) >= 2) {
                if (this.dbgOn()) {
                    db.fine("Will form a loop");
                }
                throw new OwLoopFoundException("An orderwire loop is found");
            }
            if (n != 1) continue;
            if (this.dbgOn()) {
                db.fine("Set " + set + " has intersection with a node " + "set " + set2);
            }
            arrayList.add(set2);
        }
        if (!arrayList.isEmpty()) {
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                set2 = (Set)iterator.next();
                this.owNodeSetList.remove(set2);
                set.addAll(set2);
            }
        }
        if (this.dbgOn()) {
            db.fine("The new add node set is: " + set);
        }
        this.owNodeSetList.add(set);
    }

    public void addCircuit(OwCircuit owCircuit) {
        if (this.dbgOn()) {
            db.fine("Add a circuit to OwLoopPrevention - " + owCircuit);
        }
        this.addCircuitNodes(owCircuit);
    }

    public void removeCircuit(OwCircuit owCircuit) {
        if (this.dbgOn()) {
            db.fine("Remove a circuit from OwLoopPrevention");
        }
        this.reCalculateNodeSets();
    }

    public boolean formingLoop(IOhCircuitInfo iOhCircuitInfo) {
        if (iOhCircuitInfo.getCircuitType() != this.supportingType) {
            throw new IllegalArgumentException("The given circuit info is not supported.");
        }
        OhNetCircuitEnd ohNetCircuitEnd = new OhNetCircuitEnd(iOhCircuitInfo.getSrcPoint());
        OhNetCircuitEnd ohNetCircuitEnd2 = new OhNetCircuitEnd(iOhCircuitInfo.getDestPoints()[0]);
        if (!ohNetCircuitEnd.isPortOptical() && !ohNetCircuitEnd2.isPortOptical()) {
            return this.formingLoop(iOhCircuitInfo.getCircuitEndNodes());
        }
        return false;
    }

    public boolean formingLoop(Set set) {
        Iterator iterator = this.owNodeSetList.iterator();
        while (iterator.hasNext()) {
            Set set2 = (Set)iterator.next();
            if (OwLoopPrevention.numOfCommonElements(set, set2) < 2) continue;
            return true;
        }
        return false;
    }

    private static int numOfCommonElements(Set set, Set set2) {
        HashSet hashSet = new HashSet(set);
        hashSet.retainAll(set2);
        return hashSet.size();
    }

    public boolean formingLoop(OwCircuit owCircuit, Integer n) {
        if (owCircuit.getCircuitType() != this.supportingType) {
            throw new IllegalArgumentException("The given circuit info is not supported.");
        }
        Set set = owCircuit.getCircuitEndNodes();
        if (set.contains(n)) {
            return true;
        }
        Set set2 = this.getOwNodeSet(set);
        if (set2 == null) {
            return false;
        }
        return set2.contains(n);
    }

    private Set getOwNodeSet(Set set) {
        if (this.dbgOn()) {
            db.fine("All node sets=" + this.owNodeSetList + ", s=" + set);
        }
        Iterator iterator = this.owNodeSetList.iterator();
        while (iterator.hasNext()) {
            Set set2 = (Set)iterator.next();
            if (!set2.containsAll(set)) continue;
            return set2;
        }
        if (this.dbgOn()) {
            db.fine("Can't find a existing owNodeSet contains all given nodes");
        }
        return null;
    }

    private boolean dbgOn() {
        return db.on() || OhCircuitManager.pkgDbgOn();
    }
}

