/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ocm;

import cerent.cms.model.Busy;
import cerent.cms.model.Feature;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOhCircuitInfo;
import cerent.cms.model.IOhCircuitModel;
import cerent.cms.model.IOhConnectionModel;
import cerent.cms.model.IOhConnectionModels;
import cerent.cms.model.IOhTerm;
import cerent.cms.model.IOhTermModel;
import cerent.cms.model.InvalidOhTerm;
import cerent.cms.model.InvalidUdcRate;
import cerent.cms.model.OhMaxConnections;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ResourceInUse;
import cerent.cms.model.UdcF1CircuitInfo;
import cerent.cms.model.UdcRate;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ocm.OhCircuit;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;

public class UdcF1Circuit
extends OhCircuit {
    private static final SDebug db = new SDebug("UdcF1Circuit");
    private UdcRate udcRate;

    public UdcF1Circuit(IOhCircuitInfo iOhCircuitInfo) throws AnnotatedException {
        super(iOhCircuitInfo);
    }

    public UdcF1Circuit(IOhConnectionModel iOhConnectionModel) {
        super(iOhConnectionModel);
    }

    public UdcF1Circuit(IOhCircuitModel iOhCircuitModel) {
        super(iOhCircuitModel);
    }

    protected void createOhCircuitInfoIfce(IOhCircuitInfo iOhCircuitInfo) throws CircuitProvError {
        if (iOhCircuitInfo.getCircuitType() == 0) {
            this.udcRate = ((UdcF1CircuitInfo)iOhCircuitInfo).getPortRate();
        }
        if (db.on()) {
            db.println("creating udc_f1 circuit info ifce, rate: " + this.udcRate);
        }
        super.createOhCircuitInfoIfce(iOhCircuitInfo);
    }

    protected IOhConnectionModel createOhTerm(IOhConnectionModels iOhConnectionModels, IOhTerm iOhTerm) throws InvalidOhTerm, Busy, ResourceInUse, OhMaxConnections, InvalidUdcRate, ProvisionError {
        iOhTerm.setUdcRate(this.udcRate.getIndex());
        return iOhConnectionModels.createOhTerm(this.getCircuitId(), iOhTerm);
    }

    protected boolean addConnection(IOhConnectionModel iOhConnectionModel) {
        boolean bl = super.addConnection(iOhConnectionModel);
        if (bl && iOhConnectionModel instanceof IOhTermModel && Feature.provides((INodeModel)iOhConnectionModel.getNodeModel(), (Feature)Feature.PROV_UDC_RATE)) {
            IOhTermModel iOhTermModel = (IOhTermModel)iOhConnectionModel;
            this.udcRate = UdcRate.getUdcRateObj((int)iOhTermModel.getUdcRate());
        }
        return bl;
    }

    public UdcRate getUdcRate() {
        return this.udcRate;
    }
}

