/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.route;

import cerent.cms.route.ILabelSet;
import cerent.util.IHoLoNum;
import cerent.util.IHoNum;
import cerent.util.ILabel;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public abstract class AbstractLabelSet
implements ILabelSet {
    protected Set labels;

    public void addLabel(ILabel iLabel) {
        this.labels.add(iLabel);
    }

    public void removeLabel(ILabel iLabel) {
        this.labels.remove(iLabel);
    }

    public void addLabels(Set set) {
        this.labels.addAll(set);
    }

    public int size() {
        return this.labels.size();
    }

    public ILabel getFirstLabel() {
        return (ILabel)this.labels.iterator().next();
    }

    public void intersect(ILabelSet iLabelSet) {
        int n = 0;
        if (iLabelSet == null) {
            this.labels.clear();
            return;
        }
        ILabel[] iLabelArray = this.labels.toArray(new ILabel[this.labels.size()]);
        ILabel[] iLabelArray2 = iLabelSet.getLabelSet().toArray(new ILabel[iLabelSet.size()]);
        this.labels.clear();
        for (int i = 0; i < iLabelArray.length; ++i) {
            int n2;
            for (n2 = n; n2 < iLabelArray2.length; ++n2) {
                if (iLabelArray[i].compareTo((Object)iLabelArray2[n2]) == 0) {
                    this.labels.add(iLabelArray[i]);
                    break;
                }
                if (iLabelArray2[n2].compareTo((Object)iLabelArray[i]) > 0) break;
            }
            n = n2;
        }
    }

    public void intersectSelf(ILabelSet iLabelSet) {
        this.intersect(iLabelSet);
        if (iLabelSet != null) {
            iLabelSet.intersect(this);
        }
    }

    public Set getLabelSet() {
        return this.labels;
    }

    public ILabel[] getLabels(int n) {
        int n2 = 0;
        Iterator iterator = this.labels.iterator();
        ILabel[] iLabelArray = new ILabel[n];
        while (iterator.hasNext()) {
            iLabelArray[n2] = (ILabel)iterator.next();
            if (++n2 < n) continue;
            return iLabelArray;
        }
        return new ILabel[0];
    }

    public void hoFilter(LinkedList linkedList) {
        ILabel[] iLabelArray = this.labels.toArray(new ILabel[this.labels.size()]);
        this.labels.clear();
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            int n2 = n;
            for (int i = 0; i < iLabelArray.length; ++i) {
                IHoNum iHoNum;
                if (iLabelArray[i] instanceof IHoLoNum) {
                    IHoLoNum iHoLoNum = (IHoLoNum)iLabelArray[i];
                    if (iHoLoNum.getHoNum().getHoNum() != n2) continue;
                    this.labels.add(iLabelArray[i]);
                    continue;
                }
                if (!(iLabelArray[i] instanceof IHoNum) || (iHoNum = (IHoNum)iLabelArray[i]).getHoNum() != n2) continue;
                this.labels.add(iLabelArray[i]);
            }
        }
    }
}

