/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.route;

import cerent.cms.route.DebugLog;
import cerent.cms.route.RoutePrefs;
import cerent.cms.route.SptNode;
import cerent.cms.route.xAlreadyInCandidateList;
import java.util.Iterator;
import java.util.LinkedList;

public class CandidateList {
    private LinkedList nodesList = new LinkedList();
    RoutePrefs prefs;
    DebugLog dLog;

    public CandidateList(RoutePrefs routePrefs) {
        this.prefs = routePrefs;
        this.dLog = routePrefs.getLog().getDebugLog();
    }

    protected void add(SptNode sptNode) throws xAlreadyInCandidateList {
        SptNode sptNode2 = null;
        int n = this.nodesList.indexOf(sptNode);
        if (n != -1) {
            sptNode2 = (SptNode)this.nodesList.get(n);
        }
        DebugLog debugLog = this.prefs.getLog().getDebugLog();
        if (sptNode2 != null) {
            debugLog.info("CandidateList: Found a duplicate node " + sptNode2.getNetElement().prettyString() + " Cost: " + sptNode2.getCostString());
            if (!this.prefs.needOptimalPath()) {
                return;
            }
            if (sptNode2.areYouBetterPath(sptNode)) {
                throw new xAlreadyInCandidateList(sptNode2.prettyString());
            }
            this.remove(sptNode2);
            debugLog.info("CandidateList: Replacing the node New cost: " + sptNode.getCostString());
        } else {
            debugLog.info("CandidateList: Adding " + sptNode.getNetElement().prettyString() + " Cost: " + sptNode.getCostString());
        }
        this.nodesList.add(sptNode);
    }

    protected void remove(SptNode sptNode) {
        this.nodesList.remove(sptNode);
    }

    protected SptNode getBestCandidate() {
        SptNode sptNode = null;
        Iterator iterator = this.nodesList.iterator();
        while (iterator.hasNext()) {
            SptNode sptNode2 = (SptNode)iterator.next();
            if (sptNode == null) {
                sptNode = sptNode2;
                continue;
            }
            if (!sptNode2.getCost().betterThan(sptNode.getCost())) continue;
            sptNode = sptNode2;
        }
        this.remove(sptNode);
        return sptNode;
    }

    protected SptNode getNextCandidate() {
        SptNode sptNode = (SptNode)this.nodesList.getFirst();
        this.remove(sptNode);
        return sptNode;
    }

    protected boolean isEmpty() {
        return this.nodesList.size() == 0;
    }
}

