/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.route;

import cerent.cms.route.DriNodePair;
import cerent.cms.route.DriNodes;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.util.IDebugDiag;
import cerent.util.LogLevel;
import cerent.util.SDebug;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DebugLog
extends SDebug
implements IDebugDiag {
    private int indent = 0;
    private String indentString = "";
    protected static DebugLog debug;
    private int suppressIndent = 0;
    protected List driPrefs = null;

    private DebugLog() {
        super("Route");
    }

    public static synchronized DebugLog instance() {
        if (debug == null) {
            debug = new DebugLog();
        }
        return debug;
    }

    public final void setVerbose() {
        this.setLogLevel(LogLevel.FINEST);
    }

    public final void resetVerbose() {
        if (this.getLogLevel() == LogLevel.FINEST) {
            this.setLogLevel(LogLevel.FINE);
        }
    }

    private void setIndentation() {
        this.indentString = "";
        for (int i = 0; i < this.indent; ++i) {
            this.indentString = this.indentString + "    ";
        }
    }

    protected void beginIndent() {
        ++this.indent;
        this.setIndentation();
    }

    protected void endIndent() {
        if (this.indent > 0) {
            --this.indent;
        }
        this.setIndentation();
    }

    protected final void resetIndent() {
        this.indent = 0;
        this.indentString = "";
    }

    public final void suppressIndent() {
        this.suppressIndent = 1;
    }

    public final void dump() {
        if (this.driPrefs != null) {
            this.println("BLSR DRI Nodes");
            Iterator iterator = this.driPrefs.iterator();
            while (iterator.hasNext()) {
                DriNodes driNodes = (DriNodes)iterator.next();
                this.println(driNodes.prettyString());
            }
        }
    }

    public void dumpDiag() {
        this.dump();
    }

    public final void setSuppressIndent(int n) {
        this.suppressIndent = n;
    }

    public final void resetSuppressIndent() {
        this.suppressIndent = 0;
    }

    public final void create4Blsr(String string, String string2, String string3, String string4, int n) {
        INetElement iNetElement = null;
        INetElement iNetElement2 = null;
        INetElement iNetElement3 = null;
        INetElement iNetElement4 = null;
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            iNetElement = Network.instance().findNetElemByIp(inetAddress.getHostAddress());
            inetAddress = InetAddress.getByName(string2);
            iNetElement2 = Network.instance().findNetElemByIp(inetAddress.getHostAddress());
            inetAddress = InetAddress.getByName(string3);
            iNetElement3 = Network.instance().findNetElemByIp(inetAddress.getHostAddress());
            inetAddress = InetAddress.getByName(string4);
            iNetElement4 = Network.instance().findNetElemByIp(inetAddress.getHostAddress());
        }
        catch (UnknownHostException unknownHostException) {
            super.println("Unrecognized host name");
        }
        if (this.driPrefs == null) {
            this.driPrefs = new LinkedList();
        }
        DriNodes driNodes = n != 0 ? new DriNodes(1, true) : new DriNodes(1, false);
        driNodes.addNodePair(new DriNodePair(iNetElement, iNetElement2));
        driNodes.addNodePair(new DriNodePair(iNetElement3, iNetElement4));
        this.driPrefs.add(driNodes);
    }

    private void createBlsrIntegOrNonTrad(String string, String string2, int n, int n2) {
        INetElement iNetElement = null;
        INetElement iNetElement2 = null;
        this.info("Creating BLSR integrated nodes " + string + " : " + string2);
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            iNetElement = Network.instance().findNetElemByIp(inetAddress.getHostAddress());
            inetAddress = InetAddress.getByName(string2);
            iNetElement2 = Network.instance().findNetElemByIp(inetAddress.getHostAddress());
        }
        catch (UnknownHostException unknownHostException) {
            super.println("Unrecognized host name");
        }
        this.info("NetElements are :" + iNetElement.prettyString() + " and " + iNetElement2.prettyString());
        if (this.driPrefs == null) {
            this.driPrefs = new LinkedList();
        }
        DriNodes driNodes = n2 != 0 ? new DriNodes(n, true) : new DriNodes(n, false);
        driNodes.addNodePair(new DriNodePair(iNetElement, iNetElement2));
        this.driPrefs.add(driNodes);
    }

    public final void create2Blsr(String string, String string2, int n) {
        this.createBlsrIntegOrNonTrad(string, string2, 2, n);
    }

    public final void clearBlsr() {
        this.driPrefs.clear();
    }

    public final void delBlsr(int n) {
        this.driPrefs.remove(n);
    }

    public boolean on() {
        if (!super.on()) {
            return false;
        }
        if (this.suppressIndent == 0) {
            return true;
        }
        return this.indent < this.suppressIndent;
    }

    public void info(String string) {
        if (this.on()) {
            super.println(this.indentString + string);
        }
    }

    public void finest(String string) {
        if (this.on()) {
            super.println(this.indentString + string);
        }
    }

    public void warning(String string) {
        if (this.on()) {
            super.println(this.indentString + string);
        }
    }

    public void severe(String string) {
        if (this.on()) {
            super.println(this.indentString + string);
        }
    }
}

