/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.route;

import cerent.cms.route.DriNodes;
import cerent.cms.route.DriPathFilter;
import cerent.cms.route.IGranularityFilter;
import cerent.cms.route.IPathFilter;
import cerent.cms.route.PathFilter;
import cerent.cms.route.PreemptiblePathFilter;
import cerent.cms.route.RoutePrefs;
import cerent.cms.route.SptLink;
import cerent.cms.route.UnprotectedPathFilter;
import cerent.cms.route.xLinkNotUsable;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;

public class DriSecondaryPathFilter
extends PathFilter {
    private static final int P1_S1_SEGMENT = 1;
    private static final int S1_S2_SEGMENT = 2;
    private static final int S2_P2_SEGMENT = 3;
    private static final int P1_S2_SEGMENT = 4;
    private static final int P_S_SEGMENT = 5;
    private static final int S_P_SEGMENT = 6;
    static String[] segmentName = new String[]{"INVALID", "P1->S1", "S1->S2", "S2->P2", "P1->S2", "P->S", "S->P"};
    private INetElement prevStop;
    IPathFilter endFilter;

    public DriSecondaryPathFilter(RoutePrefs routePrefs, IGranularityFilter iGranularityFilter) {
        super(routePrefs, iGranularityFilter);
        routePrefs.getLog().getDebugLog().info("DriSecondaryPathFilter: Created. RouteProtection = " + routePrefs.getPathProtection());
        boolean bl = false;
        IPathFilter iPathFilter = routePrefs.getParentFilter();
        if (iPathFilter != null) {
            if (iPathFilter instanceof DriPathFilter) {
                DriNodes driNodes = ((DriPathFilter)iPathFilter).getActiveDriNodes();
                if (driNodes != null) {
                    bl = driNodes.isSecPca();
                    this.info("Invoking parent filter from DRISec for secPca" + bl);
                } else {
                    this.info("ERROR : ActiveDriNodes not SET");
                }
            }
        } else {
            this.info("ERROR : PARENT Filter not set in DriSec");
        }
        this.endFilter = bl ? new PreemptiblePathFilter(routePrefs, iGranularityFilter) : new UnprotectedPathFilter(routePrefs, iGranularityFilter);
    }

    private int findDriSegment(SptLink sptLink) throws xLinkNotUsable {
        SptLink sptLink2 = sptLink;
        this.info("findDriSegment");
        while (sptLink2 != null) {
            this.info("link = " + sptLink2.prettyString());
            INetElement iNetElement = sptLink2.getLink().getSrc();
            SptLink sptLink3 = sptLink2.getSrcNode().getBestLink();
            int n = this.prefs.getActiveMember().findDriNodeType(iNetElement);
            this.prevStop = iNetElement;
            int n2 = this.prefs.getPathProtection();
            this.info("Node type is " + n);
            switch (n) {
                case 2: {
                    if (n2 == 100) {
                        return 1;
                    }
                    return 4;
                }
                case 4: {
                    return 2;
                }
                case 5: {
                    return 3;
                }
                case 6: {
                    return 5;
                }
                case 7: {
                    return 6;
                }
            }
            sptLink2 = sptLink3;
        }
        throw new xLinkNotUsable("Unable to determine secondary path segment for link");
    }

    public boolean isUsable(SptLink sptLink) throws xLinkNotUsable {
        IPathFilter iPathFilter = this.prefs.getParentFilter();
        String string = "";
        String string2 = "";
        if (iPathFilter != null) {
            if (iPathFilter instanceof DriPathFilter) {
                DriNodes driNodes = ((DriPathFilter)iPathFilter).getActiveDriNodes();
                if (driNodes != null) {
                    string = driNodes.getFirstDriRing();
                    string2 = driNodes.getSecondDriRing();
                    this.info("Invoking parent filter from DRISec : Got driRing1 = " + string + " driRing2 = " + string2);
                } else {
                    this.info("ERROR : ActiveDriNodes not SET - isUsable");
                }
            }
        } else {
            this.info("ERROR : PARENT Filter not set in DriSec - isUsable");
        }
        int n = this.findDriSegment(sptLink);
        this.info("Dri Segment is " + segmentName[n]);
        INetLink iNetLink = sptLink.getLink();
        String string3 = iNetLink.originatingRingName();
        INetElement iNetElement = sptLink.getLink().getSrc();
        INetElement iNetElement2 = sptLink.getLink().getDst();
        int n2 = this.prefs.getActiveMember().findDriNodeType(sptLink.getLink().getDst());
        int n3 = this.prefs.getActiveMember().findDriNodeType(sptLink.getLink().getSrc());
        switch (n) {
            case 1: {
                if (!iNetLink.terminatingInRing()) {
                    throw new xLinkNotUsable("P1->S1 must be in BLSR segment ");
                }
                if (!string3.equals(string)) {
                    throw new xLinkNotUsable("Ring " + string3 + " not allowed in P1-S1");
                }
                if (n2 != 4 || iNetElement2.equals(this.prefs.getActiveMember().findDriS1(this.prevStop))) break;
                throw new xLinkNotUsable("P1->S1 segment has to terminate on S1");
            }
            case 2: {
                if (!sptLink.getLink().isFullyUnprotected()) {
                    throw new xLinkNotUsable("only unprot links allowed in S1->S2 segment");
                }
                if (iNetElement2.equals(this.prefs.getActiveMember().findDriS2givenS1(iNetElement))) break;
                throw new xLinkNotUsable("only single link allowed between S1 and S2");
            }
            case 4: {
                if (!sptLink.getLink().isFullyUnprotected()) {
                    throw new xLinkNotUsable("only unprot links allowed in P1->S2 segment");
                }
                if (iNetElement2.equals(this.prefs.getActiveMember().findDriS2(iNetElement))) break;
                throw new xLinkNotUsable("only single link allowed between P1 and S2");
            }
            case 3: {
                if (!iNetLink.terminatingInRing()) {
                    throw new xLinkNotUsable("only BLSR links allowed in S2->P2 segment");
                }
                if (!string3.equals(string2)) {
                    throw new xLinkNotUsable("Ring " + string3 + " not valid for S2->P2 segment ");
                }
                if (n2 != 3 || iNetElement2.equals(this.prefs.getActiveMember().findDriS2givenP2(this.prevStop))) break;
                throw new xLinkNotUsable("S2->P2 does not terminate at the correct P2");
            }
            case 5: {
                if (!iNetLink.terminatingInRing()) {
                    throw new xLinkNotUsable("only BLSR links allowed in P->S segment");
                }
                if (this.prefs.getPathProtection() == 102) {
                    if (!string3.equals(string)) {
                        throw new xLinkNotUsable("Ring " + string3 + " not allowed for SameSide P->S segment");
                    }
                } else if (this.prefs.getPathProtection() == 103 && !string3.equals(string2)) {
                    throw new xLinkNotUsable("Ring " + string3 + " not allowed for Opp-Side P->S segment");
                }
                if (n2 != 7 || iNetElement2.equals(this.prefs.getActiveMember().findDriS(this.prevStop))) break;
                throw new xLinkNotUsable("P->S segment does not terminate at the right S");
            }
            case 6: {
                if (!iNetLink.terminatingInRing()) {
                    throw new xLinkNotUsable("only BLSR links allowed in S->P segment");
                }
                if (!string3.equals(string2)) {
                    throw new xLinkNotUsable("Ring " + string3 + " not allowed in S-P segment ");
                }
                if (n2 != 6 || iNetElement2.equals(this.prefs.getActiveMember().findDriPgivenS(this.prevStop))) break;
                throw new xLinkNotUsable("S->P segment does not terminate at the right P");
            }
        }
        return this.endFilter.isUsable(sptLink);
    }

    private void info(String string) {
        this.prefs.getLog().getDebugLog().info(string);
    }
}

