/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.route;

import cerent.cms.route.CircuitPath;
import cerent.cms.route.MemberPath;
import cerent.cms.route.PathSegment;
import java.util.Iterator;
import java.util.LinkedList;

public class DropPath {
    private CircuitPath circuitPath;
    private LinkedList memberPaths;

    public DropPath(CircuitPath circuitPath) {
        this.circuitPath = circuitPath;
        this.memberPaths = new LinkedList();
    }

    protected CircuitPath getCircuitPath() {
        return this.circuitPath;
    }

    public void addMemberPath(MemberPath memberPath) {
        this.memberPaths.add(memberPath);
    }

    public void addMemberPaths(LinkedList linkedList) {
        this.memberPaths.addAll(linkedList);
    }

    public LinkedList getMemberPaths() {
        return this.memberPaths;
    }

    public LinkedList getSpans() {
        LinkedList linkedList = new LinkedList();
        Iterator iterator = this.memberPaths.iterator();
        while (iterator.hasNext()) {
            MemberPath memberPath = (MemberPath)iterator.next();
            linkedList.addAll(memberPath.getSpans());
        }
        return linkedList;
    }

    protected LinkedList getMemberSegments() {
        LinkedList<LinkedList> linkedList = new LinkedList<LinkedList>();
        Iterator iterator = this.memberPaths.iterator();
        MemberPath memberPath = (MemberPath)iterator.next();
        if (memberPath != null) {
            LinkedList linkedList2 = memberPath.getPathSegments();
            iterator = linkedList2.iterator();
            while (iterator.hasNext()) {
                PathSegment pathSegment = (PathSegment)iterator.next();
                linkedList.add(pathSegment.getPrimaryLinks());
            }
        }
        return linkedList;
    }

    public LinkedList getPathSegments() {
        LinkedList linkedList = new LinkedList();
        Iterator iterator = this.memberPaths.iterator();
        while (iterator.hasNext()) {
            MemberPath memberPath = (MemberPath)iterator.next();
            linkedList.addAll(memberPath.getPathSegments());
        }
        return linkedList;
    }

    public void updatePathSegments(DropPath dropPath) {
        if (this.memberPaths.size() != dropPath.memberPaths.size()) {
            return;
        }
        for (int i = 0; i < this.memberPaths.size(); ++i) {
            MemberPath memberPath = (MemberPath)this.memberPaths.get(i);
            memberPath.updatePathSegment((MemberPath)dropPath.memberPaths.get(i));
        }
    }

    public void addDriSegment(DropPath dropPath) {
        if (this.memberPaths.size() != dropPath.memberPaths.size()) {
            return;
        }
        for (int i = 0; i < this.memberPaths.size(); ++i) {
            MemberPath memberPath = (MemberPath)this.memberPaths.get(i);
            memberPath.addDriPathSegment((MemberPath)dropPath.memberPaths.get(i));
        }
    }

    public void addBlsrDriSecondary(DropPath dropPath) {
        if (this.memberPaths.size() != dropPath.memberPaths.size()) {
            return;
        }
        for (int i = 0; i < this.memberPaths.size(); ++i) {
            MemberPath memberPath = (MemberPath)this.memberPaths.get(i);
            memberPath.addBlsrDriSecondary((MemberPath)dropPath.memberPaths.get(i));
        }
    }

    public String prettyString() {
        String string = "\n\tDrop Path:";
        Iterator iterator = this.memberPaths.iterator();
        while (iterator.hasNext()) {
            MemberPath memberPath = (MemberPath)iterator.next();
            string = string + memberPath.prettyString();
        }
        return string;
    }
}

